#include "precompiled.hh"

tBool dap_tmcfi_tclDescription::bInitMessage(dap_tmcfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case dap_tmcfi_tclToken::EN_LAST_TOKEN:
   case dap_tmcfi_tclToken::EN_LIST:
   case dap_tmcfi_tclToken::EN_END_OF_STRUCT:
   case dap_tmcfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case dap_tmcfi_tclToken::EN_MSG_LOCATIONTABLELISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E8_DAPORDERTYPE,dap_tmcfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_MSG_LOCATIONTABLELISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LOCTABLEDESC,dap_tmcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LIST,dap_tmcfi_tclSemanticDomain::EN_MSG_AOLOCTABLES));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32MAXLOCATIONSIZEWITHOUTOC));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32MAXLOCATIONSIZEWITHOC));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_MSG_GETLOCATIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_STRING,dap_tmcfi_tclSemanticDomain::EN_MSG_SZSHAREDMEMORY));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32SHAREDMEMSIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_U8DISTANCE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_U8DIRECTION));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_BOOL,dap_tmcfi_tclSemanticDomain::EN_MSG_BFOUNDSECUNDARY));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_BOOL,dap_tmcfi_tclSemanticDomain::EN_MSG_BWITHOCS));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E8_LOCCLASS,dap_tmcfi_tclSemanticDomain::EN_MSG_T_E8_LOCCLASS));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LOCTABLEIDENT,dap_tmcfi_tclSemanticDomain::EN_MSG_T_LOCTABLEIDENT));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U16,dap_tmcfi_tclSemanticDomain::EN_MSG_U16LOCATIONID));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E8_DAPORDERTYPE,dap_tmcfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_MSG_GETLOCATIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_BBOX,dap_tmcfi_tclSemanticDomain::EN_MSG_OBBOX));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_STRING,dap_tmcfi_tclSemanticDomain::EN_MSG_SZSHAREDMEMORY));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32LOCATIONSIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_U8DISTANCE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E8_FOLLOWDIRECTION,dap_tmcfi_tclSemanticDomain::EN_MSG_ENDIRECTION));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_BOOL,dap_tmcfi_tclSemanticDomain::EN_MSG_BFOUNDSECUNDARY));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_BOOL,dap_tmcfi_tclSemanticDomain::EN_MSG_BWITHOCS));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E8_LOCCLASS,dap_tmcfi_tclSemanticDomain::EN_MSG_ENLOCCLASS));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LOCTABLEIDENT,dap_tmcfi_tclSemanticDomain::EN_MSG_OLOCTABLEIDENT));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U16,dap_tmcfi_tclSemanticDomain::EN_MSG_U16LOCATIONID));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_MSG_LANGUAGEIDLISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E8_DAPORDERTYPE,dap_tmcfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_MSG_LANGUAGEIDLISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LANGUAGEIDELEM,dap_tmcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LIST,dap_tmcfi_tclSemanticDomain::EN_MSG_AOLANGUAGEIDS));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_MSG_BSAIDLISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LOCTABLEIDENT,dap_tmcfi_tclSemanticDomain::EN_MSG_OLOCTABLEIDENT));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E8_DAPORDERTYPE,dap_tmcfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_MSG_BSAIDLISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U16,dap_tmcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LIST,dap_tmcfi_tclSemanticDomain::EN_MSG_AU16BSAIDS));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LOCTABLEIDENT,dap_tmcfi_tclSemanticDomain::EN_MSG_OLOCTABLEIDENT));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_MSG_PREFIXTABLEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E8_DAPORDERTYPE,dap_tmcfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_MSG_PREFIXTABLEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_PREFIXELEM,dap_tmcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LIST,dap_tmcfi_tclSemanticDomain::EN_MSG_AOPREFIXELEMS));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_PREFIXTABLE,dap_tmcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LIST,dap_tmcfi_tclSemanticDomain::EN_MSG_AOPREFIXTABLE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_tmcfi_tclToken::EN_BINCONTAINER:
   case dap_tmcfi_tclToken::EN_S32_LONGITUDE:
   case dap_tmcfi_tclToken::EN_S32_LATITUDE:
   case dap_tmcfi_tclToken::EN_POSITIONWGS84:
   case dap_tmcfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case dap_tmcfi_tclToken::EN_E16_ISOLANGUAGECODE:
   case dap_tmcfi_tclToken::EN_E8_DAPORDERTYPE:
   case dap_tmcfi_tclToken::EN_BBOX:
   case dap_tmcfi_tclToken::EN_E8_LOCCLASS:
   case dap_tmcfi_tclToken::EN_E8_FOLLOWDIRECTION:
   case dap_tmcfi_tclToken::EN_LOCTABLEIDENT:
   case dap_tmcfi_tclToken::EN_OUTLINE:
   case dap_tmcfi_tclToken::EN_LANGUAGEIDELEM:
   case dap_tmcfi_tclToken::EN_PREFIXELEM:
   case dap_tmcfi_tclToken::EN_PREFIXTABLE:
   case dap_tmcfi_tclToken::EN_LOCTABLEDESC:
   case dap_tmcfi_tclToken::EN_U8:   
   case dap_tmcfi_tclToken::EN_S8:   
   case dap_tmcfi_tclToken::EN_U16:   
   case dap_tmcfi_tclToken::EN_S16:   
   case dap_tmcfi_tclToken::EN_U24:   
   case dap_tmcfi_tclToken::EN_S24:   
   case dap_tmcfi_tclToken::EN_U32:   
   case dap_tmcfi_tclToken::EN_S32:   
   case dap_tmcfi_tclToken::EN_U64:   
   case dap_tmcfi_tclToken::EN_S64:   
   case dap_tmcfi_tclToken::EN_F32:   
   case dap_tmcfi_tclToken::EN_F64:   
   case dap_tmcfi_tclToken::EN_BOOL:   
   case dap_tmcfi_tclToken::EN_STRING:   
   case dap_tmcfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(dap_tmcfi_tclKnot(enMsgToken,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool dap_tmcfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool dap_tmcfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      dap_tmcfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      dap_tmcfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      dap_tmcfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == dap_tmcfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(dap_tmcfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(dap_tmcfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(dap_tmcfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case dap_tmcfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == dap_tmcfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_tmcfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_tmcfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_tmcfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_tmcfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case dap_tmcfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case dap_tmcfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_tmcfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case dap_tmcfi_tclToken::EN_MSG_LOCATIONTABLELISTMETHODSTART:
   case dap_tmcfi_tclToken::EN_MSG_LOCATIONTABLELISTMETHODRESULT:
   case dap_tmcfi_tclToken::EN_MSG_GETLOCATIONMETHODSTART:
   case dap_tmcfi_tclToken::EN_MSG_GETLOCATIONMETHODRESULT:
   case dap_tmcfi_tclToken::EN_MSG_LANGUAGEIDLISTMETHODSTART:
   case dap_tmcfi_tclToken::EN_MSG_LANGUAGEIDLISTMETHODRESULT:
   case dap_tmcfi_tclToken::EN_MSG_BSAIDLISTMETHODSTART:
   case dap_tmcfi_tclToken::EN_MSG_BSAIDLISTMETHODRESULT:
   case dap_tmcfi_tclToken::EN_MSG_PREFIXTABLEMETHODSTART:
   case dap_tmcfi_tclToken::EN_MSG_PREFIXTABLEMETHODRESULT:
      bInitMessage(enToken);
      break;
   case dap_tmcfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_END_OF_STRUCT,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LIST,dap_tmcfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_tmcfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_tmcfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_tmcfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_END_OF_STRUCT,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_S32_LATITUDE,dap_tmcfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_S32_LONGITUDE,dap_tmcfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_tmcfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_tmcfi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_tmcfi_tclToken::EN_E8_DAPORDERTYPE:
   {
      fi_tcl_e8_DapOrderType o_e8_DapOrderType;
      if (!bDoIt(o_e8_DapOrderType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_tmcfi_tclToken::EN_BBOX:
   {
      if (poVisitor->bDoExpand_BBox(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_END_OF_STRUCT,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_POSITIONWGS84,dap_tmcfi_tclSemanticDomain::EN_UPPERRIGTHPOSITION));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_POSITIONWGS84,dap_tmcfi_tclSemanticDomain::EN_LOWERLEFTPOSITION));
      }
      else
      {
         fi_tcl_BBox o_BBox;
         if (!bDoIt(o_BBox))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_tmcfi_tclToken::EN_E8_LOCCLASS:
   {
      fi_tcl_e8_LocClass o_e8_LocClass;
      if (!bDoIt(o_e8_LocClass))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_tmcfi_tclToken::EN_E8_FOLLOWDIRECTION:
   {
      fi_tcl_e8_FollowDirection o_e8_FollowDirection;
      if (!bDoIt(o_e8_FollowDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_tmcfi_tclToken::EN_LOCTABLEIDENT:
   {
      if (poVisitor->bDoExpand_LocTableIdent(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_END_OF_STRUCT,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_U8TABLENUMBER));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_U8COUNTRYCODE));
      }
      else
      {
         fi_tcl_LocTableIdent o_LocTableIdent;
         if (!bDoIt(o_LocTableIdent))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocTableIdent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocTableIdent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_tmcfi_tclToken::EN_OUTLINE:
   {
      if (poVisitor->bDoExpand_Outline(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_END_OF_STRUCT,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_POSITIONWGS84,dap_tmcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LIST,dap_tmcfi_tclSemanticDomain::EN_POINTS));
      }
      else
      {
         fi_tcl_Outline o_Outline;
         if (!bDoIt(o_Outline))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Outline.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Outline.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_tmcfi_tclToken::EN_LANGUAGEIDELEM:
   {
      if (poVisitor->bDoExpand_LanguageIdElem(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_END_OF_STRUCT,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_BOOL,dap_tmcfi_tclSemanticDomain::EN_BDEFAULTLANGUAGE));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_U8LANGUAGEID));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E16_ISOLANGUAGECODE,dap_tmcfi_tclSemanticDomain::EN_OLANGUAGE));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_E16_ISOCOUNTRYCODE,dap_tmcfi_tclSemanticDomain::EN_OCOUNTRY));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LOCTABLEIDENT,dap_tmcfi_tclSemanticDomain::EN_OLOCTABLEIDENT));
      }
      else
      {
         fi_tcl_LanguageIdElem o_LanguageIdElem;
         if (!bDoIt(o_LanguageIdElem))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageIdElem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageIdElem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_tmcfi_tclToken::EN_PREFIXELEM:
   {
      if (poVisitor->bDoExpand_PrefixElem(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_END_OF_STRUCT,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_STRING,dap_tmcfi_tclSemanticDomain::EN_PCROADPREFIX));
         if (u16MajorVersion <= 3)
         {
            oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_BOOL,dap_tmcfi_tclSemanticDomain::EN_BVOICE));
         }
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_U32STATECODE));
         }
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_U8NUMBERHIERARCHY));
         }
         if (4 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U16,dap_tmcfi_tclSemanticDomain::EN_U16STATUS));
         }
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_U8PRIORITY));
      }
      else
      {
         fi_tcl_PrefixElem o_PrefixElem;
         if (!bDoIt(o_PrefixElem))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixElem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixElem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_tmcfi_tclToken::EN_PREFIXTABLE:
   {
      if (poVisitor->bDoExpand_PrefixTable(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_END_OF_STRUCT,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_U32NUMBEROFPREFIXES));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U32,dap_tmcfi_tclSemanticDomain::EN_U32STARTINDEX));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LOCTABLEIDENT,dap_tmcfi_tclSemanticDomain::EN_OTABLEIDENT));
      }
      else
      {
         fi_tcl_PrefixTable o_PrefixTable;
         if (!bDoIt(o_PrefixTable))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixTable.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixTable.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_tmcfi_tclToken::EN_LOCTABLEDESC:
   {
      if (poVisitor->bDoExpand_LocTableDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_END_OF_STRUCT,dap_tmcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_OUTLINE,dap_tmcfi_tclSemanticDomain::EN_OOUTLINE));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U16,dap_tmcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LIST,dap_tmcfi_tclSemanticDomain::EN_FEATUREAVAILLIST));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U8,dap_tmcfi_tclSemanticDomain::EN_U8DEFAULTLANGUAGEID));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U16,dap_tmcfi_tclSemanticDomain::EN_U16ISOCOUNTRYCODE));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_U16,dap_tmcfi_tclSemanticDomain::EN_U16TABLEVERSION));
         oPath.bGoDown(dap_tmcfi_tclKnot(dap_tmcfi_tclToken::EN_LOCTABLEIDENT,dap_tmcfi_tclSemanticDomain::EN_OLOCTABLEIDENT));
      }
      else
      {
         fi_tcl_LocTableDesc o_LocTableDesc;
         if (!bDoIt(o_LocTableDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocTableDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocTableDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case dap_tmcfi_tclToken::EN_UNKNOWN:
      case dap_tmcfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

