#ifndef DAP_RNWFILANGUAGE_HEADER
#define DAP_RNWFILANGUAGE_HEADER

class dap_rnwfi_tclInContext;
class dap_rnwfi_tclOutContext;
class dap_rnwfi_tclVisitorBase;

class MY_DECL dap_rnwfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  dap_rnwfi_tclDescription(fi_tclInContext* poIn, dap_rnwfi_tclVisitorBase* poVisit);
  dap_rnwfi_tclDescription(fi_tclOutContext* poOut, dap_rnwfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(dap_rnwfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ dap_rnwfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  dap_rnwfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<dap_rnwfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<dap_rnwfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline dap_rnwfi_tclDescription::dap_rnwfi_tclDescription(fi_tclInContext* poIn, dap_rnwfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline dap_rnwfi_tclDescription::dap_rnwfi_tclDescription(fi_tclOutContext* poOut, dap_rnwfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

