#include "precompiled.hh"

tBool dap_rnwfi_tclDescription::bInitMessage(dap_rnwfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case dap_rnwfi_tclToken::EN_LAST_TOKEN:
   case dap_rnwfi_tclToken::EN_LIST:
   case dap_rnwfi_tclToken::EN_END_OF_STRUCT:
   case dap_rnwfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case dap_rnwfi_tclToken::EN_MSG_GETMAPBLOCKSMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_UNIQUEID,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_AOUNIQUEIDS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_U32MEMSIZE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_U32MEMADR));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETMAPBLOCKSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_RESULTBLOCKS,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_AORESULTS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_U32USEDMEMSIZE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETPREFIXTABLEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_U32DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETPREFIXTABLEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_DAPPREFIXSTATE,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_OPREFIXTABLE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LOCALONECELLID,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_ONECELLIDLIST));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVCLUSTERID,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_CLUSTERIDLIST));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_U32MEMSIZE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_U32MEMADR));
      if (poOutContext->u16GetMajorVersion() <= 1)
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_MSG_U16HANDLEDUMMY));
      }
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_rnwfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_RESULTBLOCKS,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_RESULTBLOCKLIST));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_SIZE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVONECELLDESC,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_ONECELLIDLIST));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVCLUSTERDESC,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_CLUSTERIDLIST));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_BOUNDINGBOX,dap_rnwfi_tclSemanticDomain::EN_MSG_BOUNDINGBOX));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U8,dap_rnwfi_tclSemanticDomain::EN_MSG_BREAKDOWNLEVEL));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_REQUESTTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_REQUESTTYPE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_rnwfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_SAMELEVELONECELLBLOCK,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_ROUTEBREAKDOWNLIST));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETREGPROFOUTLINEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETREGPROFOUTLINEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_REGPROFOUTLINE,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_OREGPROFOUTLINELIST));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETROOTFILEHEADERMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_MSG_SEMAPHORE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_MSG_SHAREDMEMORY));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMPOS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETROOTFILEHEADERMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMPOS));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_DAP_RNW_READCLUSTERMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_CLUSTERSTARTINFO,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_CLUSTERINFOS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_MSG_SEMAPHORE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_MSG_SHAREDMEMORY));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMPOS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_rnwfi_tclToken::EN_MSG_DAP_RNW_READCLUSTERMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_CLUSTERRESULTINFO,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_CLUSTERINFOS));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETGLOBALINSTRUCTIONRECORDMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_MSG_SEMAPHORE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_MSG_SHAREDMEMORY));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMPOS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETGLOBALINSTRUCTIONRECORDMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMPOS));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETGLOBALAREARECORDMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_MSG_SEMAPHORE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_MSG_SHAREDMEMORY));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMPOS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETGLOBALAREARECORDMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMPOS));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_REQUESTUSERIDENTMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_MAXUSERMEMORY));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_MINUSERMEMORY));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_REQUESTUSERIDENTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_SHAREDMEMORYSIZE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_MSG_SHAREDMEMORYNAME));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_RELEASEUSERIDENTMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_REQUESTGLOBALDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_REQUESTGLOBALDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U8,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMORYUSAGE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_RELOFFSET));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_RELEASEGLOBALDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_RELEASEGLOBALDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U8,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMORYUSAGE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_REQUESTDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E32_RNWEXTENSIONTYPE,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_EXTENSIONS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVCLUSTERID,dap_rnwfi_tclSemanticDomain::EN_MSG_CLUSTERID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_REQUESTDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U8,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMORYUSAGE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_RELOFFSETEXTENSIONS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_RELOFFSETCLUSTER));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E32_RNWEXTENSIONTYPE,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_EXTENSIONS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVCLUSTERID,dap_rnwfi_tclSemanticDomain::EN_MSG_CLUSTERID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVCLUSTERID,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_CLUSTERIDS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U8,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMORYUSAGE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_RNWDATASTORAGEINFO,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_RELEASEINFOS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETDATASTORAGEINFOMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE,dap_rnwfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_GETDATASTORAGEINFOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U8,dap_rnwfi_tclSemanticDomain::EN_MSG_MEMORYUSAGE));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_RNWDATASTORAGEINFO,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASTORAGEINFOS));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_USERIDENT));
   } break;
   case dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDSTATUS:
   {
      bResult &= oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_MSG_U32DATASETID));
   } break;
   case dap_rnwfi_tclToken::EN_BINCONTAINER:
   case dap_rnwfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case dap_rnwfi_tclToken::EN_S32_LONGITUDE:
   case dap_rnwfi_tclToken::EN_S32_LATITUDE:
   case dap_rnwfi_tclToken::EN_POSITIONWGS84:
   case dap_rnwfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case dap_rnwfi_tclToken::EN_NAVCLUSTERDESC:
   case dap_rnwfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case dap_rnwfi_tclToken::EN_NAVONECELLDESC:
   case dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE:
   case dap_rnwfi_tclToken::EN_NAVCLUSTERID:
   case dap_rnwfi_tclToken::EN_LOCALONECELLID:
   case dap_rnwfi_tclToken::EN_REGPROFOUTLINE:
   case dap_rnwfi_tclToken::EN_DAPPREFIXDESC:
   case dap_rnwfi_tclToken::EN_DAPPREFIXSTATE:
   case dap_rnwfi_tclToken::EN_UNIQUEID:
   case dap_rnwfi_tclToken::EN_BOUNDINGBOX:
   case dap_rnwfi_tclToken::EN_RESULTBLOCKS:
   case dap_rnwfi_tclToken::EN_E8_REQUESTTYPE:
   case dap_rnwfi_tclToken::EN_E16_ONECELLINDEX:
   case dap_rnwfi_tclToken::EN_ONECELLRELATION:
   case dap_rnwfi_tclToken::EN_SAMELEVELONECELLBLOCK:
   case dap_rnwfi_tclToken::EN_B8_STRUCTURETYPE:
   case dap_rnwfi_tclToken::EN_E32_RNWEXTENSIONTYPE:
   case dap_rnwfi_tclToken::EN_E8_RNWDATAUSAGESTATE:
   case dap_rnwfi_tclToken::EN_MEMPOS:
   case dap_rnwfi_tclToken::EN_STRUCTUREREFERENCE:
   case dap_rnwfi_tclToken::EN_CLUSTERSTARTINFO:
   case dap_rnwfi_tclToken::EN_CLUSTERRESULTINFO:
   case dap_rnwfi_tclToken::EN_RNWDATASTORAGEINFO:
   case dap_rnwfi_tclToken::EN_U8:   
   case dap_rnwfi_tclToken::EN_S8:   
   case dap_rnwfi_tclToken::EN_U16:   
   case dap_rnwfi_tclToken::EN_S16:   
   case dap_rnwfi_tclToken::EN_U24:   
   case dap_rnwfi_tclToken::EN_S24:   
   case dap_rnwfi_tclToken::EN_U32:   
   case dap_rnwfi_tclToken::EN_S32:   
   case dap_rnwfi_tclToken::EN_U64:   
   case dap_rnwfi_tclToken::EN_S64:   
   case dap_rnwfi_tclToken::EN_F32:   
   case dap_rnwfi_tclToken::EN_F64:   
   case dap_rnwfi_tclToken::EN_BOOL:   
   case dap_rnwfi_tclToken::EN_STRING:   
   case dap_rnwfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(dap_rnwfi_tclKnot(enMsgToken,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool dap_rnwfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool dap_rnwfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      dap_rnwfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      dap_rnwfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      dap_rnwfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(dap_rnwfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(dap_rnwfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(dap_rnwfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case dap_rnwfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == dap_rnwfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_rnwfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_rnwfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_rnwfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_rnwfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case dap_rnwfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case dap_rnwfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rnwfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case dap_rnwfi_tclToken::EN_MSG_GETMAPBLOCKSMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_GETMAPBLOCKSMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_GETPREFIXTABLEMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_GETPREFIXTABLEMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_GETREGPROFOUTLINEMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_GETREGPROFOUTLINEMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_GETROOTFILEHEADERMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_GETROOTFILEHEADERMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_DAP_RNW_READCLUSTERMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_DAP_RNW_READCLUSTERMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_GETGLOBALINSTRUCTIONRECORDMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_GETGLOBALINSTRUCTIONRECORDMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_GETGLOBALAREARECORDMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_GETGLOBALAREARECORDMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_REQUESTUSERIDENTMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_REQUESTUSERIDENTMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_RELEASEUSERIDENTMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_RELEASEUSERIDENTMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_REQUESTGLOBALDATAMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_REQUESTGLOBALDATAMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_RELEASEGLOBALDATAMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_RELEASEGLOBALDATAMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_REQUESTDATAMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_REQUESTDATAMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_GETDATASTORAGEINFOMETHODSTART:
   case dap_rnwfi_tclToken::EN_MSG_GETDATASTORAGEINFOMETHODRESULT:
   case dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDGET:
   case dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDUPREG:
   case dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDRELUPREG:
   case dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDSTATUS:
      bInitMessage(enToken);
      break;
   case dap_rnwfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U8,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_S32_LATITUDE,dap_rnwfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_S32_LONGITUDE,dap_rnwfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U8,dap_rnwfi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_rnwfi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_NAVONECELLDIRECTION,dap_rnwfi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_E8_DAPORDERTYPE:
   {
      fi_tcl_e8_DapOrderType o_e8_DapOrderType;
      if (!bDoIt(o_e8_DapOrderType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_NAVCLUSTERID:
   {
      if (poVisitor->bDoExpand_NavClusterId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_CLUSTERLENGTH));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_FILEOFFSET));
      }
      else
      {
         fi_tcl_NavClusterId o_NavClusterId;
         if (!bDoIt(o_NavClusterId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_LOCALONECELLID:
   {
      if (poVisitor->bDoExpand_LocalOneCellID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_ONECELLINDEX));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_CLUSTERINDEX));
      }
      else
      {
         fi_tcl_LocalOneCellID o_LocalOneCellID;
         if (!bDoIt(o_LocalOneCellID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocalOneCellID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocalOneCellID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_REGPROFOUTLINE:
   {
      if (poVisitor->bDoExpand_RegProfOutline(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_POSITIONWGS84,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_OUTLINE));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_REGIONPROFILEID));
      }
      else
      {
         fi_tcl_RegProfOutline o_RegProfOutline;
         if (!bDoIt(o_RegProfOutline))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegProfOutline.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegProfOutline.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_DAPPREFIXDESC:
   {
      if (poVisitor->bDoExpand_DapPrefixDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRING,dap_rnwfi_tclSemanticDomain::EN_PREFIX));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_MODE));
      }
      else
      {
         fi_tcl_DapPrefixDesc o_DapPrefixDesc;
         if (!bDoIt(o_DapPrefixDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapPrefixDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapPrefixDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_DAPPREFIXSTATE:
   {
      if (poVisitor->bDoExpand_DapPrefixState(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_DAPPREFIXDESC,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_PREFIXDESCLIST));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E16_ISOCOUNTRYCODE,dap_rnwfi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_DapPrefixState o_DapPrefixState;
         if (!bDoIt(o_DapPrefixState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapPrefixState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapPrefixState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_UNIQUEID:
   {
      if (poVisitor->bDoExpand_UniqueID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_SECONDELEMENT));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_FIRSTELEMENT));
      }
      else
      {
         fi_tcl_UniqueID o_UniqueID;
         if (!bDoIt(o_UniqueID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UniqueID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UniqueID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_BOUNDINGBOX:
   {
      if (poVisitor->bDoExpand_BoundingBox(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_POSITIONWGS84,dap_rnwfi_tclSemanticDomain::EN_BOUNDINGBOXUPPERRIGHT));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_POSITIONWGS84,dap_rnwfi_tclSemanticDomain::EN_BOUNDINGBOXLOWERLEFT));
      }
      else
      {
         fi_tcl_BoundingBox o_BoundingBox;
         if (!bDoIt(o_BoundingBox))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BoundingBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BoundingBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_RESULTBLOCKS:
   {
      if (poVisitor->bDoExpand_ResultBlocks(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_ERRORCODE));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_OFFSET));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_UNIQUEID,dap_rnwfi_tclSemanticDomain::EN_UNIQUEID));
      }
      else
      {
         fi_tcl_ResultBlocks o_ResultBlocks;
         if (!bDoIt(o_ResultBlocks))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ResultBlocks.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ResultBlocks.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_E8_REQUESTTYPE:
   {
      fi_tcl_e8_RequestType o_e8_RequestType;
      if (!bDoIt(o_e8_RequestType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_E16_ONECELLINDEX:
   {
      fi_tcl_e16_OneCellIndex o_e16_OneCellIndex;
      if (!bDoIt(o_e16_OneCellIndex))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_ONECELLRELATION:
   {
      if (poVisitor->bDoExpand_OneCellRelation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_NAVONECELLDIRECTION,dap_rnwfi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E16_ONECELLINDEX,dap_rnwfi_tclSemanticDomain::EN_PARENTONECELLINDEX));
      }
      else
      {
         fi_tcl_OneCellRelation o_OneCellRelation;
         if (!bDoIt(o_OneCellRelation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OneCellRelation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OneCellRelation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_SAMELEVELONECELLBLOCK:
   {
      if (poVisitor->bDoExpand_SameLevelOneCellBlock(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_ONECELLRELATION,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_ONECELLRELATIONLIST));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LOCALONECELLID,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_ONECELLIDLIST));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVCLUSTERID,dap_rnwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_LIST,dap_rnwfi_tclSemanticDomain::EN_CLUSTERIDLIST));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U8,dap_rnwfi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_SameLevelOneCellBlock o_SameLevelOneCellBlock;
         if (!bDoIt(o_SameLevelOneCellBlock))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SameLevelOneCellBlock.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SameLevelOneCellBlock.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_B8_STRUCTURETYPE:
   {
      fi_tcl_b8_StructureType o_b8_StructureType;
      if (!bDoIt(o_b8_StructureType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_E32_RNWEXTENSIONTYPE:
   {
      fi_tcl_e32_RNWExtensionType o_e32_RNWExtensionType;
      if (!bDoIt(o_e32_RNWExtensionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_E8_RNWDATAUSAGESTATE:
   {
      fi_tcl_e8_RNWDataUsageState o_e8_RNWDataUsageState;
      if (!bDoIt(o_e8_RNWDataUsageState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rnwfi_tclToken::EN_MEMPOS:
   {
      if (poVisitor->bDoExpand_MemPos(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_U32LENGTH));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U32,dap_rnwfi_tclSemanticDomain::EN_U32OFFSET));
      }
      else
      {
         fi_tcl_MemPos o_MemPos;
         if (!bDoIt(o_MemPos))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MemPos.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MemPos.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_STRUCTUREREFERENCE:
   {
      if (poVisitor->bDoExpand_StructureReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_OAREAPOS));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_OEXTCLPOS));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_OEXPANNPOS));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_MEMPOS,dap_rnwfi_tclSemanticDomain::EN_OCLUSTERPOS));
      }
      else
      {
         fi_tcl_StructureReference o_StructureReference;
         if (!bDoIt(o_StructureReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StructureReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StructureReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_CLUSTERSTARTINFO:
   {
      if (poVisitor->bDoExpand_ClusterStartInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_B8_STRUCTURETYPE,dap_rnwfi_tclSemanticDomain::EN_ETYPE));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVCLUSTERID,dap_rnwfi_tclSemanticDomain::EN_OCLUSTERID));
      }
      else
      {
         fi_tcl_ClusterStartInfo o_ClusterStartInfo;
         if (!bDoIt(o_ClusterStartInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ClusterStartInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ClusterStartInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_CLUSTERRESULTINFO:
   {
      if (poVisitor->bDoExpand_ClusterResultInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_U16,dap_rnwfi_tclSemanticDomain::EN_U16ERRORCODE));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_STRUCTUREREFERENCE,dap_rnwfi_tclSemanticDomain::EN_ODATAREF));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVCLUSTERID,dap_rnwfi_tclSemanticDomain::EN_OCLUSTERID));
      }
      else
      {
         fi_tcl_ClusterResultInfo o_ClusterResultInfo;
         if (!bDoIt(o_ClusterResultInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ClusterResultInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ClusterResultInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rnwfi_tclToken::EN_RNWDATASTORAGEINFO:
   {
      if (poVisitor->bDoExpand_RNWDataStorageInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_END_OF_STRUCT,dap_rnwfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_E8_RNWDATAUSAGESTATE,dap_rnwfi_tclSemanticDomain::EN_USAGESTATE));
         oPath.bGoDown(dap_rnwfi_tclKnot(dap_rnwfi_tclToken::EN_NAVCLUSTERID,dap_rnwfi_tclSemanticDomain::EN_OCLUSTERID));
      }
      else
      {
         fi_tcl_RNWDataStorageInfo o_RNWDataStorageInfo;
         if (!bDoIt(o_RNWDataStorageInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RNWDataStorageInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RNWDataStorageInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case dap_rnwfi_tclToken::EN_UNKNOWN:
      case dap_rnwfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

