#ifndef __DAP_RNWFIDEBUGVISITOR_H__
#define __DAP_RNWFIDEBUGVISITOR_H__

class MY_DECL dap_rnwfi_tclPrintVisitor : public dap_rnwfi_tclVisitorBase {

private:
   /* default constructor */ dap_rnwfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   dap_rnwfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tBool bDoExpand_NavClusterDesc(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tBool bDoExpand_NavOneCellDesc(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DapOrderType(fi_tcl_e8_DapOrderType& o_e8_DapOrderType);
   virtual tBool bDoExpand_NavClusterId(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LocalOneCellID(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RegProfOutline(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapPrefixDesc(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapPrefixState(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UniqueID(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BoundingBox(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ResultBlocks(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RequestType(fi_tcl_e8_RequestType& o_e8_RequestType);
   virtual tVoid vVisit_e16_OneCellIndex(fi_tcl_e16_OneCellIndex& o_e16_OneCellIndex);
   virtual tBool bDoExpand_OneCellRelation(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SameLevelOneCellBlock(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_StructureType(fi_tcl_b8_StructureType& o_b8_StructureType);
   virtual tVoid vVisit_e32_RNWExtensionType(fi_tcl_e32_RNWExtensionType& o_e32_RNWExtensionType);
   virtual tVoid vVisit_e8_RNWDataUsageState(fi_tcl_e8_RNWDataUsageState& o_e8_RNWDataUsageState);
   virtual tBool bDoExpand_MemPos(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StructureReference(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ClusterStartInfo(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ClusterResultInfo(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RNWDataStorageInfo(dap_rnwfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL dap_rnwfi_tclRandomInitVisitor : public dap_rnwfi_tclVisitorBase {
public:

   dap_rnwfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_DapOrderType(fi_tcl_e8_DapOrderType& o_e8_DapOrderType);
   virtual tVoid vVisit_e8_RequestType(fi_tcl_e8_RequestType& o_e8_RequestType);
   virtual tVoid vVisit_e16_OneCellIndex(fi_tcl_e16_OneCellIndex& o_e16_OneCellIndex);
   virtual tVoid vVisit_b8_StructureType(fi_tcl_b8_StructureType& o_b8_StructureType);
   virtual tVoid vVisit_e32_RNWExtensionType(fi_tcl_e32_RNWExtensionType& o_e32_RNWExtensionType);
   virtual tVoid vVisit_e8_RNWDataUsageState(fi_tcl_e8_RNWDataUsageState& o_e8_RNWDataUsageState);
	tU32 u32ListSize;
};

#endif
