/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DAP_RESINFFITYPES_HEADER
#define DAP_RESINFFITYPES_HEADER

// #include <vector>
// 


class dap_resinffi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class dap_resinffi_tclMsgGetLanguageDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgGetLanguageDescriptionMethodStart():Priority(0),DataSize(0),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgGetLanguageDescriptionMethodStart& operator=(const dap_resinffi_tclMsgGetLanguageDescriptionMethodStart& coRef);
   dap_resinffi_tclMsgGetLanguageDescriptionMethodStart(const dap_resinffi_tclMsgGetLanguageDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   tU32 u32DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgGetLanguageDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_GETLANGUAGEDESCRIPTIONMETHODSTART;}
};

class dap_resinffi_tclMsgGetLanguageDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgGetLanguageDescriptionMethodResult():Priority(0),DataSize(0),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgGetLanguageDescriptionMethodResult& operator=(const dap_resinffi_tclMsgGetLanguageDescriptionMethodResult& coRef);
   dap_resinffi_tclMsgGetLanguageDescriptionMethodResult(const dap_resinffi_tclMsgGetLanguageDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   tU32 u32DatasetId;
   std::vector<fi_tcl_DapCodePageDescr, std::allocator<fi_tcl_DapCodePageDescr> > aoCodePages;
   std::vector<fi_tcl_DapLanguageDescr, std::allocator<fi_tcl_DapLanguageDescr> > aoLanguageList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgGetLanguageDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_GETLANGUAGEDESCRIPTIONMETHODRESULT;}
};

class dap_resinffi_tclMsgGetFileDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgGetFileDescriptionMethodStart():Priority(0),DataSize(0),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgGetFileDescriptionMethodStart& operator=(const dap_resinffi_tclMsgGetFileDescriptionMethodStart& coRef);
   dap_resinffi_tclMsgGetFileDescriptionMethodStart(const dap_resinffi_tclMsgGetFileDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   tU32 u32DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgGetFileDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_GETFILEDESCRIPTIONMETHODSTART;}
};

class dap_resinffi_tclMsgGetFileDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgGetFileDescriptionMethodResult():Priority(0),DataSize(0),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgGetFileDescriptionMethodResult& operator=(const dap_resinffi_tclMsgGetFileDescriptionMethodResult& coRef);
   dap_resinffi_tclMsgGetFileDescriptionMethodResult(const dap_resinffi_tclMsgGetFileDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   tU32 u32DatasetId;
   std::vector<fi_tcl_DapFileType, std::allocator<fi_tcl_DapFileType> > aoFileDescs;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgGetFileDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_GETFILEDESCRIPTIONMETHODRESULT;}
};

class dap_resinffi_tclMsgdap_ri_StateOfDeviceGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfDeviceGet():u8Priority(),u32DataSize(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfDeviceGet& operator=(const dap_resinffi_tclMsgdap_ri_StateOfDeviceGet& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfDeviceGet(const dap_resinffi_tclMsgdap_ri_StateOfDeviceGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfDeviceGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICEGET;}
};

class dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg():u8Priority(),u32DataSize(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg& operator=(const dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg(const dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICEUPREG;}
};

class dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg():u8Priority(),u32DataSize(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg(const dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICERELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus():u8Priority(),u32DataSize(),oDeviceInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus& operator=(const dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus(const dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tcl_DapDeviceInfo oDeviceInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICESTATUS;}
};

class dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet& operator=(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDEVICESGET;}
};

class dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus& operator=(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   std::vector<fi_tcl_DapDeviceInfo, std::allocator<fi_tcl_DapDeviceInfo> > aoDeviceInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDEVICESSTATUS;}
};

class dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet():u8Priority(),u32DataSize(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet& operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet& coRef);
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICEGET;}
};

class dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg():u8Priority(),u32DataSize(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg& operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICEUPREG;}
};

class dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg():u8Priority(),u32DataSize(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICERELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus():u8Priority(),u32DataSize(),oMediaInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus& operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus& coRef);
   dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tcl_DapMediaInfo oMediaInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICESTATUS;}
};

class dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet& operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet& coRef);
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESGET;}
};

class dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg& operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESUPREG;}
};

class dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESRELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus& operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus& coRef);
   dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   std::vector<fi_tcl_DapMediaInfo, std::allocator<fi_tcl_DapMediaInfo> > aoMediaInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESSTATUS;}
};

class dap_resinffi_tclMsgdap_ri_StateOfDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfDataGet():u8Priority(),u32DataSize(),enDataType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfDataGet& operator=(const dap_resinffi_tclMsgdap_ri_StateOfDataGet& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfDataGet(const dap_resinffi_tclMsgdap_ri_StateOfDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tcl_e8_DapDataType enDataType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATAGET;}
};

class dap_resinffi_tclMsgdap_ri_StateOfDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfDataUpReg():u8Priority(),u32DataSize(),enDataType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfDataUpReg& operator=(const dap_resinffi_tclMsgdap_ri_StateOfDataUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfDataUpReg(const dap_resinffi_tclMsgdap_ri_StateOfDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tcl_e8_DapDataType enDataType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATAUPREG;}
};

class dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg():u8Priority(),u32DataSize(),enDataType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg(const dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tcl_e8_DapDataType enDataType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATARELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_StateOfDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfDataStatus():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfDataStatus& operator=(const dap_resinffi_tclMsgdap_ri_StateOfDataStatus& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfDataStatus(const dap_resinffi_tclMsgdap_ri_StateOfDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   std::vector<fi_tcl_DapDataInfo, std::allocator<fi_tcl_DapDataInfo> > aoDataInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATASTATUS;}
};

class dap_resinffi_tclMsgdap_ri_StateOfAllDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfAllDataGet():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfAllDataGet& operator=(const dap_resinffi_tclMsgdap_ri_StateOfAllDataGet& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfAllDataGet(const dap_resinffi_tclMsgdap_ri_StateOfAllDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfAllDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDATAGET;}
};

class dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus& operator=(const dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus(const dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   std::vector<fi_tcl_DapDataInfo, std::allocator<fi_tcl_DapDataInfo> > aoDataInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDATASTATUS;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDatasetGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDatasetGet():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDatasetGet& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetGet& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDatasetGet(const dap_resinffi_tclMsgdap_ri_DefaultDatasetGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETGET;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg(const dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETUPREG;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg(const dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETRELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus():u8Priority(),u32DataSize(),oDatasetInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus(const dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tcl_DapDataSetInfo oDatasetInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETSTATUS;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDatasetSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDatasetSet():u8Priority(),u32DataSize(),u32ControlHandle(0),oDatasetInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDatasetSet& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetSet& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDatasetSet(const dap_resinffi_tclMsgdap_ri_DefaultDatasetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   tU32 u32ControlHandle;
   fi_tcl_DapDataSetInfo oDatasetInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETSET;}
};

class dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet():u8Priority(),u32DataSize(),oDefaultControl() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet& operator=(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet& coRef);
   dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tcl_DapDefaultControl oDefaultControl;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_CTRLDEFAULTDATASETSET;}
};

class dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus():u8Priority(),u32DataSize(),oDefaultControl() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus& operator=(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus& coRef);
   dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tcl_DapDefaultControl oDefaultControl;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_CTRLDEFAULTDATASETSTATUS;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFOUPREG;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg():u8Priority(),DataSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFORELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   std::vector<fi_tcl_DapDataInfo, std::allocator<fi_tcl_DapDataInfo> > aoDataInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFOSTATUS;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDeviceSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDeviceSet():u8Priority(),u32DataSize(),szDevicePath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDeviceSet& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDeviceSet& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDeviceSet(const dap_resinffi_tclMsgdap_ri_DefaultDeviceSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDevicePath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDeviceSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDEVICESET;}
};

class dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus():u8Priority(),u32DataSize(),szDevicePath(),u16ErrorState(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus& operator=(const dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus(const dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDevicePath;
   tU16 u16ErrorState;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDEVICESTATUS;}
};

class dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet& operator=(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet& coRef);
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETGET;}
};

class dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg& operator=(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETUPREG;}
};

class dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETRELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus():u8Priority(),u32DataSize(),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus& operator=(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus& coRef);
   dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   tU32 u32DatasetId;
   std::vector<fi_tcl_DapRegionDescription, std::allocator<fi_tcl_DapRegionDescription> > aoRegionDescriptions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETSTATUS;}
};

class dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet& operator=(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATAGET;}
};

class dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg& operator=(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATAUPREG;}
};

class dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATARELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus():u8Priority(),u32DataSize(),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus& operator=(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus& coRef);
   dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   tU32 u32DatasetId;
   std::vector<fi_tcl_DapRegionMetaInfo, std::allocator<fi_tcl_DapRegionMetaInfo> > aoRegionMetaDatas;
   std::vector<fi_tcl_DapProfileMetaInfo, std::allocator<fi_tcl_DapProfileMetaInfo> > aoProfileMetaDatas;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATASTATUS;}
};

class dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet():u8Priority(),u32DataSize(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet& operator=(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONGET;}
};

class dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg():u8Priority(),u32DataSize(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg& operator=(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONUPREG;}
};

class dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg():u8Priority(),u32DataSize(),szDeviceName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szDeviceName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONRELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus():u8Priority(),u32DataSize(),u8WriteProtState() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus& operator=(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus& coRef);
   dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tcl_e8_DapWriteProt u8WriteProtState;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONSTATUS;}
};

class dap_resinffi_tclMsgdap_ri_EngineeringTextSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_EngineeringTextSet():u8Priority(),u32DataSize(),szEngineeringString() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_EngineeringTextSet& operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextSet& coRef);
   dap_resinffi_tclMsgdap_ri_EngineeringTextSet(const dap_resinffi_tclMsgdap_ri_EngineeringTextSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szEngineeringString;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTSET;}
};

class dap_resinffi_tclMsgdap_ri_EngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_EngineeringTextGet():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_EngineeringTextGet& operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextGet& coRef);
   dap_resinffi_tclMsgdap_ri_EngineeringTextGet(const dap_resinffi_tclMsgdap_ri_EngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTGET;}
};

class dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg& operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg(const dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTUPREG;}
};

class dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg():u8Priority(),u32DataSize() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg& operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg& coRef);
   dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg(const dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTRELUPREG;}
};

class dap_resinffi_tclMsgdap_ri_EngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_resinffi_tclMsgdap_ri_EngineeringTextStatus():u8Priority(),u32DataSize(),szEngineeringString() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_resinffi_tclMsgdap_ri_EngineeringTextStatus& operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextStatus& coRef);
   dap_resinffi_tclMsgdap_ri_EngineeringTextStatus(const dap_resinffi_tclMsgdap_ri_EngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   fi_tcl_u32_DapContainerSize u32DataSize;
   fi_tclString szEngineeringString;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTSTATUS;}
};


#endif
