/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgGetLanguageDescriptionMethodStart::dap_resinffi_tclMsgGetLanguageDescriptionMethodStart(const dap_resinffi_tclMsgGetLanguageDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgGetLanguageDescriptionMethodStart& dap_resinffi_tclMsgGetLanguageDescriptionMethodStart::operator=(const dap_resinffi_tclMsgGetLanguageDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgGetLanguageDescriptionMethodStart::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgGetLanguageDescriptionMethodStart::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_GETLANGUAGEDESCRIPTION;}
tU8 dap_resinffi_tclMsgGetLanguageDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_resinffi_tclMsgGetLanguageDescriptionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool dap_resinffi_tclMsgGetLanguageDescriptionMethodStart::operator==(const dap_resinffi_tclMsgGetLanguageDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgGetLanguageDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   oIn >> u32DatasetId;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgGetLanguageDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   oOut << u32DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::dap_resinffi_tclMsgGetLanguageDescriptionMethodResult(const dap_resinffi_tclMsgGetLanguageDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoCodePages = coRef.aoCodePages;
   aoLanguageList = coRef.aoLanguageList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgGetLanguageDescriptionMethodResult& dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::operator=(const dap_resinffi_tclMsgGetLanguageDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoCodePages = coRef.aoCodePages;
   aoLanguageList = coRef.aoLanguageList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_GETLANGUAGEDESCRIPTION;}
tU8 dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoCodePages.size(); ++u32Idx)
         aoCodePages[u32Idx].vDestroy();
   }
   aoCodePages.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < aoLanguageList.size(); ++u32Idx)
         aoLanguageList[u32Idx].vDestroy();
   }
   aoLanguageList.clear();
}

tU32 dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoCodePages.size(); ++u32ListIdx)
      u32DynamicSize += aoCodePages[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < aoLanguageList.size(); ++u32ListIdx)
      u32DynamicSize += aoLanguageList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+17;
}

tBool dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::operator==(const dap_resinffi_tclMsgGetLanguageDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (aoCodePages.size() == rfoCmp.aoCodePages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoCodePages.size()); ++u32Idx)
            bResult = bResult && (aoCodePages[u32Idx] == rfoCmp.aoCodePages[u32Idx]);
      }
      bResult = bResult && (aoLanguageList.size() == rfoCmp.aoLanguageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoLanguageList.size()); ++u32Idx)
            bResult = bResult && (aoLanguageList[u32Idx] == rfoCmp.aoLanguageList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   oIn >> u32DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoCodePages.size(); ++u32Idx)
      {
         aoCodePages[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoCodePages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoCodePages[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoLanguageList.size(); ++u32Idx)
      {
         aoLanguageList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoLanguageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoLanguageList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgGetLanguageDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   oOut << u32DatasetId;
   oOut << (tU32)aoCodePages.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoCodePages.size(); ++u32Idx)
         oOut << aoCodePages[u32Idx];
   }
   oOut << (tU32)aoLanguageList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoLanguageList.size(); ++u32Idx)
         oOut << aoLanguageList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgGetFileDescriptionMethodStart::dap_resinffi_tclMsgGetFileDescriptionMethodStart(const dap_resinffi_tclMsgGetFileDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgGetFileDescriptionMethodStart& dap_resinffi_tclMsgGetFileDescriptionMethodStart::operator=(const dap_resinffi_tclMsgGetFileDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgGetFileDescriptionMethodStart::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgGetFileDescriptionMethodStart::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_GETFILEDESCRIPTION;}
tU8 dap_resinffi_tclMsgGetFileDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_resinffi_tclMsgGetFileDescriptionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool dap_resinffi_tclMsgGetFileDescriptionMethodStart::operator==(const dap_resinffi_tclMsgGetFileDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgGetFileDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   oIn >> u32DatasetId;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgGetFileDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   oOut << u32DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgGetFileDescriptionMethodResult::dap_resinffi_tclMsgGetFileDescriptionMethodResult(const dap_resinffi_tclMsgGetFileDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoFileDescs = coRef.aoFileDescs;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgGetFileDescriptionMethodResult& dap_resinffi_tclMsgGetFileDescriptionMethodResult::operator=(const dap_resinffi_tclMsgGetFileDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Priority = coRef.Priority;
   DataSize = coRef.DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoFileDescs = coRef.aoFileDescs;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgGetFileDescriptionMethodResult::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgGetFileDescriptionMethodResult::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_GETFILEDESCRIPTION;}
tU8 dap_resinffi_tclMsgGetFileDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_resinffi_tclMsgGetFileDescriptionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoFileDescs.size(); ++u32Idx)
         aoFileDescs[u32Idx].vDestroy();
   }
   aoFileDescs.clear();
}

tU32 dap_resinffi_tclMsgGetFileDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoFileDescs.size(); ++u32ListIdx)
      u32DynamicSize += aoFileDescs[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13;
}

tBool dap_resinffi_tclMsgGetFileDescriptionMethodResult::operator==(const dap_resinffi_tclMsgGetFileDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Priority == rfoCmp.Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (aoFileDescs.size() == rfoCmp.aoFileDescs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoFileDescs.size()); ++u32Idx)
            bResult = bResult && (aoFileDescs[u32Idx] == rfoCmp.aoFileDescs[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgGetFileDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Priority;
   oIn >> DataSize;
   oIn >> u32DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoFileDescs.size(); ++u32Idx)
      {
         aoFileDescs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoFileDescs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoFileDescs[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgGetFileDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Priority;
   oOut << DataSize;
   oOut << u32DatasetId;
   oOut << (tU32)aoFileDescs.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoFileDescs.size(); ++u32Idx)
         oOut << aoFileDescs[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::dap_resinffi_tclMsgdap_ri_StateOfDeviceGet(const dap_resinffi_tclMsgdap_ri_StateOfDeviceGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDeviceGet& dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::operator=(const dap_resinffi_tclMsgdap_ri_StateOfDeviceGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::operator==(const dap_resinffi_tclMsgdap_ri_StateOfDeviceGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfDeviceGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg(const dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg& dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::operator=(const dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::operator==(const dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfDeviceUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg(const dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg& dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfDeviceRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus(const dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oDeviceInfo = coRef.oDeviceInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus& dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::operator=(const dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oDeviceInfo = coRef.oDeviceInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::vDestroy()
{
   oDeviceInfo.vDestroy(); 
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+oDeviceInfo.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::operator==(const dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (oDeviceInfo == rfoCmp.oDeviceInfo);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> oDeviceInfo;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << oDeviceInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet::dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet& dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet::operator=(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFALLDEVICES;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet::operator==(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfAllDevicesGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoDeviceInfo = coRef.aoDeviceInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus& dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::operator=(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoDeviceInfo = coRef.aoDeviceInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFALLDEVICES;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoDeviceInfo.size(); ++u32Idx)
         aoDeviceInfo[u32Idx].vDestroy();
   }
   aoDeviceInfo.clear();
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoDeviceInfo.size(); ++u32ListIdx)
      u32DynamicSize += aoDeviceInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::operator==(const dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (aoDeviceInfo.size() == rfoCmp.aoDeviceInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoDeviceInfo.size()); ++u32Idx)
            bResult = bResult && (aoDeviceInfo[u32Idx] == rfoCmp.aoDeviceInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoDeviceInfo.size(); ++u32Idx)
      {
         aoDeviceInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoDeviceInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoDeviceInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfAllDevicesStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << (tU32)aoDeviceInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoDeviceInfo.size(); ++u32Idx)
         oOut << aoDeviceInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_MEDIASTATEOFDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tVoid dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_MEDIASTATEOFDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tVoid dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_MEDIASTATEOFDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tVoid dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oMediaInfo = coRef.oMediaInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oMediaInfo = coRef.oMediaInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_MEDIASTATEOFDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::vDestroy()
{
   oMediaInfo.vDestroy(); 
}

tU32 dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+oMediaInfo.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (oMediaInfo == rfoCmp.oMediaInfo);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> oMediaInfo;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_MediaStateOfDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << oMediaInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet::dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet::operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_MEDIASTATEOFALLDEVICES;}
tU8 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet::operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg::dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg::operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_MEDIASTATEOFALLDEVICES;}
tU8 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg::operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg::dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_MEDIASTATEOFALLDEVICES;}
tU8 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoMediaInfo = coRef.aoMediaInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::operator=(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoMediaInfo = coRef.aoMediaInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_MEDIASTATEOFALLDEVICES;}
tU8 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoMediaInfo.size(); ++u32Idx)
         aoMediaInfo[u32Idx].vDestroy();
   }
   aoMediaInfo.clear();
}

tU32 dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoMediaInfo.size(); ++u32ListIdx)
      u32DynamicSize += aoMediaInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::operator==(const dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (aoMediaInfo.size() == rfoCmp.aoMediaInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoMediaInfo.size()); ++u32Idx)
            bResult = bResult && (aoMediaInfo[u32Idx] == rfoCmp.aoMediaInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoMediaInfo.size(); ++u32Idx)
      {
         aoMediaInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoMediaInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoMediaInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_MediaStateOfAllDevicesStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << (tU32)aoMediaInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoMediaInfo.size(); ++u32Idx)
         oOut << aoMediaInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDataGet::dap_resinffi_tclMsgdap_ri_StateOfDataGet(const dap_resinffi_tclMsgdap_ri_StateOfDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   enDataType = coRef.enDataType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDataGet& dap_resinffi_tclMsgdap_ri_StateOfDataGet::operator=(const dap_resinffi_tclMsgdap_ri_StateOfDataGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   enDataType = coRef.enDataType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfDataGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfDataGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFDATA;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_resinffi_tclMsgdap_ri_StateOfDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool dap_resinffi_tclMsgdap_ri_StateOfDataGet::operator==(const dap_resinffi_tclMsgdap_ri_StateOfDataGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (enDataType == rfoCmp.enDataType);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfDataGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> enDataType;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfDataGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << enDataType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDataUpReg::dap_resinffi_tclMsgdap_ri_StateOfDataUpReg(const dap_resinffi_tclMsgdap_ri_StateOfDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   enDataType = coRef.enDataType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDataUpReg& dap_resinffi_tclMsgdap_ri_StateOfDataUpReg::operator=(const dap_resinffi_tclMsgdap_ri_StateOfDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   enDataType = coRef.enDataType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfDataUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfDataUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFDATA;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_resinffi_tclMsgdap_ri_StateOfDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool dap_resinffi_tclMsgdap_ri_StateOfDataUpReg::operator==(const dap_resinffi_tclMsgdap_ri_StateOfDataUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (enDataType == rfoCmp.enDataType);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfDataUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> enDataType;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << enDataType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg::dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg(const dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   enDataType = coRef.enDataType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg& dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   enDataType = coRef.enDataType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFDATA;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (enDataType == rfoCmp.enDataType);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> enDataType;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << enDataType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDataStatus::dap_resinffi_tclMsgdap_ri_StateOfDataStatus(const dap_resinffi_tclMsgdap_ri_StateOfDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoDataInfo = coRef.aoDataInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfDataStatus& dap_resinffi_tclMsgdap_ri_StateOfDataStatus::operator=(const dap_resinffi_tclMsgdap_ri_StateOfDataStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoDataInfo = coRef.aoDataInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfDataStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfDataStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFDATA;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfo.size(); ++u32Idx)
         aoDataInfo[u32Idx].vDestroy();
   }
   aoDataInfo.clear();
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoDataInfo.size(); ++u32ListIdx)
      u32DynamicSize += aoDataInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool dap_resinffi_tclMsgdap_ri_StateOfDataStatus::operator==(const dap_resinffi_tclMsgdap_ri_StateOfDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (aoDataInfo.size() == rfoCmp.aoDataInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoDataInfo.size()); ++u32Idx)
            bResult = bResult && (aoDataInfo[u32Idx] == rfoCmp.aoDataInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoDataInfo.size(); ++u32Idx)
      {
         aoDataInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoDataInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoDataInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << (tU32)aoDataInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfo.size(); ++u32Idx)
         oOut << aoDataInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfAllDataGet::dap_resinffi_tclMsgdap_ri_StateOfAllDataGet(const dap_resinffi_tclMsgdap_ri_StateOfAllDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfAllDataGet& dap_resinffi_tclMsgdap_ri_StateOfAllDataGet::operator=(const dap_resinffi_tclMsgdap_ri_StateOfAllDataGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfAllDataGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfAllDataGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFALLDATA;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfAllDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_resinffi_tclMsgdap_ri_StateOfAllDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_StateOfAllDataGet::operator==(const dap_resinffi_tclMsgdap_ri_StateOfAllDataGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfAllDataGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfAllDataGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus(const dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoDataInfo = coRef.aoDataInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus& dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::operator=(const dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoDataInfo = coRef.aoDataInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFALLDATA;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfo.size(); ++u32Idx)
         aoDataInfo[u32Idx].vDestroy();
   }
   aoDataInfo.clear();
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoDataInfo.size(); ++u32ListIdx)
      u32DynamicSize += aoDataInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::operator==(const dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (aoDataInfo.size() == rfoCmp.aoDataInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoDataInfo.size()); ++u32Idx)
            bResult = bResult && (aoDataInfo[u32Idx] == rfoCmp.aoDataInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoDataInfo.size(); ++u32Idx)
      {
         aoDataInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoDataInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoDataInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfAllDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << (tU32)aoDataInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfo.size(); ++u32Idx)
         oOut << aoDataInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetGet::dap_resinffi_tclMsgdap_ri_DefaultDatasetGet(const dap_resinffi_tclMsgdap_ri_DefaultDatasetGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetGet& dap_resinffi_tclMsgdap_ri_DefaultDatasetGet::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDatasetGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDatasetGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDatasetGet::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg::dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg(const dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg& dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg::dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg(const dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg& dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus(const dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oDatasetInfo = coRef.oDatasetInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus& dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oDatasetInfo = coRef.oDatasetInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::vDestroy()
{
   oDatasetInfo.vDestroy(); 
}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+oDatasetInfo.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (oDatasetInfo == rfoCmp.oDatasetInfo);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> oDatasetInfo;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << oDatasetInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::dap_resinffi_tclMsgdap_ri_DefaultDatasetSet(const dap_resinffi_tclMsgdap_ri_DefaultDatasetSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32ControlHandle = coRef.u32ControlHandle;
   oDatasetInfo = coRef.oDatasetInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDatasetSet& dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDatasetSet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32ControlHandle = coRef.u32ControlHandle;
   oDatasetInfo = coRef.oDatasetInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tVoid dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::vDestroy()
{
   oDatasetInfo.vDestroy(); 
}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+oDatasetInfo.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDatasetSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u32ControlHandle == rfoCmp.u32ControlHandle);
      bResult = bResult && (oDatasetInfo == rfoCmp.oDatasetInfo);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> u32ControlHandle;
   oIn >> oDatasetInfo;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDatasetSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << u32ControlHandle;
   oOut << oDatasetInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oDefaultControl = coRef.oDefaultControl;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet& dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::operator=(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oDefaultControl = coRef.oDefaultControl;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_CTRLDEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tVoid dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::vDestroy()
{
   oDefaultControl.vDestroy(); 
}

tU32 dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::operator==(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (oDefaultControl == rfoCmp.oDefaultControl);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> oDefaultControl;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << oDefaultControl;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oDefaultControl = coRef.oDefaultControl;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus& dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::operator=(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   oDefaultControl = coRef.oDefaultControl;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_CTRLDEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::vDestroy()
{
   oDefaultControl.vDestroy(); 
}

tU32 dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::operator==(const dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (oDefaultControl == rfoCmp.oDefaultControl);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> oDefaultControl;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_CtrlDefaultDatasetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << oDefaultControl;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg::dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg& dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDATAINFO;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDataInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg::dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg& dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   DataSize = coRef.DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDATAINFO;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (DataSize == rfoCmp.DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDataInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoDataInfo = coRef.aoDataInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus& dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   aoDataInfo = coRef.aoDataInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDATAINFO;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfo.size(); ++u32Idx)
         aoDataInfo[u32Idx].vDestroy();
   }
   aoDataInfo.clear();
}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoDataInfo.size(); ++u32ListIdx)
      u32DynamicSize += aoDataInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (aoDataInfo.size() == rfoCmp.aoDataInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoDataInfo.size()); ++u32Idx)
            bResult = bResult && (aoDataInfo[u32Idx] == rfoCmp.aoDataInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoDataInfo.size(); ++u32Idx)
      {
         aoDataInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoDataInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoDataInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDataInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << (tU32)aoDataInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfo.size(); ++u32Idx)
         oOut << aoDataInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::dap_resinffi_tclMsgdap_ri_DefaultDeviceSet(const dap_resinffi_tclMsgdap_ri_DefaultDeviceSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDevicePath = coRef.szDevicePath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDeviceSet& dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDeviceSet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDevicePath = coRef.szDevicePath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tVoid dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::vDestroy()
{
   szDevicePath.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDevicePath.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDeviceSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDevicePath == rfoCmp.szDevicePath);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDevicePath;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDeviceSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDevicePath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus(const dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDevicePath = coRef.szDevicePath;
   u16ErrorState = coRef.u16ErrorState;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus& dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::operator=(const dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDevicePath = coRef.szDevicePath;
   u16ErrorState = coRef.u16ErrorState;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTDEVICE;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::vDestroy()
{
   szDevicePath.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+szDevicePath.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::operator==(const dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDevicePath == rfoCmp.szDevicePath);
      bResult = bResult && (u16ErrorState == rfoCmp.u16ErrorState);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDevicePath;
   oIn >> u16ErrorState;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDevicePath;
   oOut << u16ErrorState;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet::dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet::operator=(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_REGIONSOFDEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet::operator==(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg::dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg::operator=(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_REGIONSOFDEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg::operator==(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg::dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_REGIONSOFDEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoRegionDescriptions = coRef.aoRegionDescriptions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::operator=(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoRegionDescriptions = coRef.aoRegionDescriptions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_REGIONSOFDEFAULTDATASET;}
tU8 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoRegionDescriptions.size(); ++u32Idx)
         aoRegionDescriptions[u32Idx].vDestroy();
   }
   aoRegionDescriptions.clear();
}

tU32 dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoRegionDescriptions.size(); ++u32ListIdx)
      u32DynamicSize += aoRegionDescriptions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13;
}

tBool dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::operator==(const dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (aoRegionDescriptions.size() == rfoCmp.aoRegionDescriptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoRegionDescriptions.size()); ++u32Idx)
            bResult = bResult && (aoRegionDescriptions[u32Idx] == rfoCmp.aoRegionDescriptions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> u32DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoRegionDescriptions.size(); ++u32Idx)
      {
         aoRegionDescriptions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoRegionDescriptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoRegionDescriptions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_RegionsOfDefaultDatasetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << u32DatasetId;
   oOut << (tU32)aoRegionDescriptions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoRegionDescriptions.size(); ++u32Idx)
         oOut << aoRegionDescriptions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet::dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet::operator=(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTREGIONMETADATA;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet::operator==(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg::dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg::operator=(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTREGIONMETADATA;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg::operator==(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg::dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTREGIONMETADATA;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoRegionMetaDatas = coRef.aoRegionMetaDatas;
   aoProfileMetaDatas = coRef.aoProfileMetaDatas;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::operator=(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32DatasetId = coRef.u32DatasetId;
   aoRegionMetaDatas = coRef.aoRegionMetaDatas;
   aoProfileMetaDatas = coRef.aoProfileMetaDatas;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_DEFAULTREGIONMETADATA;}
tU8 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoRegionMetaDatas.size(); ++u32Idx)
         aoRegionMetaDatas[u32Idx].vDestroy();
   }
   aoRegionMetaDatas.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < aoProfileMetaDatas.size(); ++u32Idx)
         aoProfileMetaDatas[u32Idx].vDestroy();
   }
   aoProfileMetaDatas.clear();
}

tU32 dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoRegionMetaDatas.size(); ++u32ListIdx)
      u32DynamicSize += aoRegionMetaDatas[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < aoProfileMetaDatas.size(); ++u32ListIdx)
      u32DynamicSize += aoProfileMetaDatas[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+17;
}

tBool dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::operator==(const dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (aoRegionMetaDatas.size() == rfoCmp.aoRegionMetaDatas.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoRegionMetaDatas.size()); ++u32Idx)
            bResult = bResult && (aoRegionMetaDatas[u32Idx] == rfoCmp.aoRegionMetaDatas[u32Idx]);
      }
      bResult = bResult && (aoProfileMetaDatas.size() == rfoCmp.aoProfileMetaDatas.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoProfileMetaDatas.size()); ++u32Idx)
            bResult = bResult && (aoProfileMetaDatas[u32Idx] == rfoCmp.aoProfileMetaDatas[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> u32DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoRegionMetaDatas.size(); ++u32Idx)
      {
         aoRegionMetaDatas[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoRegionMetaDatas.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoRegionMetaDatas[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoProfileMetaDatas.size(); ++u32Idx)
      {
         aoProfileMetaDatas[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoProfileMetaDatas.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoProfileMetaDatas[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_DefaultRegionMetaDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << u32DatasetId;
   oOut << (tU32)aoRegionMetaDatas.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoRegionMetaDatas.size(); ++u32Idx)
         oOut << aoRegionMetaDatas[u32Idx];
   }
   oOut << (tU32)aoProfileMetaDatas.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoProfileMetaDatas.size(); ++u32Idx)
         oOut << aoProfileMetaDatas[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::operator=(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFWRITEPROTECTION;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::operator==(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::operator=(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFWRITEPROTECTION;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::operator==(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szDeviceName = coRef.szDeviceName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFWRITEPROTECTION;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tVoid dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::vDestroy()
{
   szDeviceName.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDeviceName.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szDeviceName == rfoCmp.szDeviceName);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szDeviceName;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szDeviceName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus::dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8WriteProtState = coRef.u8WriteProtState;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus::operator=(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8WriteProtState = coRef.u8WriteProtState;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_STATEOFWRITEPROTECTION;}
tU8 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus::operator==(const dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u8WriteProtState == rfoCmp.u8WriteProtState);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> u8WriteProtState;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_StateOfWriteProtectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << u8WriteProtState;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextSet::dap_resinffi_tclMsgdap_ri_EngineeringTextSet(const dap_resinffi_tclMsgdap_ri_EngineeringTextSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szEngineeringString = coRef.szEngineeringString;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextSet& dap_resinffi_tclMsgdap_ri_EngineeringTextSet::operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextSet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szEngineeringString = coRef.szEngineeringString;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextSet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextSet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_ENGINEERINGTEXT;}
tU8 dap_resinffi_tclMsgdap_ri_EngineeringTextSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tVoid dap_resinffi_tclMsgdap_ri_EngineeringTextSet::vDestroy()
{
   szEngineeringString.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_EngineeringTextSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szEngineeringString.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_EngineeringTextSet::operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szEngineeringString == rfoCmp.szEngineeringString);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_EngineeringTextSet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szEngineeringString;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_EngineeringTextSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szEngineeringString;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextGet::dap_resinffi_tclMsgdap_ri_EngineeringTextGet(const dap_resinffi_tclMsgdap_ri_EngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextGet& dap_resinffi_tclMsgdap_ri_EngineeringTextGet::operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextGet::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextGet::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_ENGINEERINGTEXT;}
tU8 dap_resinffi_tclMsgdap_ri_EngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_resinffi_tclMsgdap_ri_EngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_EngineeringTextGet::operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_EngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_EngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg::dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg(const dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg& dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg::operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_ENGINEERINGTEXT;}
tU8 dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg::operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_EngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg::dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg(const dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg& dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg::operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_ENGINEERINGTEXT;}
tU8 dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg::operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_EngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::dap_resinffi_tclMsgdap_ri_EngineeringTextStatus(const dap_resinffi_tclMsgdap_ri_EngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szEngineeringString = coRef.szEngineeringString;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_resinffi_tclMsgdap_ri_EngineeringTextStatus& dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::operator=(const dap_resinffi_tclMsgdap_ri_EngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   szEngineeringString = coRef.szEngineeringString;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::u16GetServiceID() const {return DAP_RESINFFI_C_U16_SERVICE_ID;}
tU16 dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::u16GetFunctionID() const {return DAP_RESINFFI_C_U16_DAP_RI_ENGINEERINGTEXT;}
tU8 dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::vDestroy()
{
   szEngineeringString.vDestroy();
}

tU32 dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szEngineeringString.u32GetSize(u16MajorVersion);
}

tBool dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::operator==(const dap_resinffi_tclMsgdap_ri_EngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (szEngineeringString == rfoCmp.szEngineeringString);
   return bResult;
}

fi_tclInContext& dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> szEngineeringString;
   return oIn;
}

fi_tclOutContext& dap_resinffi_tclMsgdap_ri_EngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << szEngineeringString;
   return oOut;
}

