#ifndef DAP_RESINFFILANGUAGE_HEADER
#define DAP_RESINFFILANGUAGE_HEADER

class dap_resinffi_tclInContext;
class dap_resinffi_tclOutContext;
class dap_resinffi_tclVisitorBase;

class MY_DECL dap_resinffi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  dap_resinffi_tclDescription(fi_tclInContext* poIn, dap_resinffi_tclVisitorBase* poVisit);
  dap_resinffi_tclDescription(fi_tclOutContext* poOut, dap_resinffi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(dap_resinffi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ dap_resinffi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  dap_resinffi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<dap_resinffi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<dap_resinffi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline dap_resinffi_tclDescription::dap_resinffi_tclDescription(fi_tclInContext* poIn, dap_resinffi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline dap_resinffi_tclDescription::dap_resinffi_tclDescription(fi_tclOutContext* poOut, dap_resinffi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

