#include "precompiled.hh"

tBool dap_resinffi_tclDescription::bInitMessage(dap_resinffi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case dap_resinffi_tclToken::EN_LAST_TOKEN:
   case dap_resinffi_tclToken::EN_LIST:
   case dap_resinffi_tclToken::EN_END_OF_STRUCT:
   case dap_resinffi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case dap_resinffi_tclToken::EN_MSG_GETLANGUAGEDESCRIPTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U8,dap_resinffi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_GETLANGUAGEDESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPLANGUAGEDESCR,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AOLANGUAGELIST));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPCODEPAGEDESCR,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AOCODEPAGES));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U8,dap_resinffi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_GETFILEDESCRIPTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U8,dap_resinffi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_GETFILEDESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPFILETYPE,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AOFILEDESCS));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U8,dap_resinffi_tclSemanticDomain::EN_MSG_PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICEGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICENAME));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICEUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICENAME));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICERELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICENAME));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICESTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPDEVICEINFO,dap_resinffi_tclSemanticDomain::EN_MSG_ODEVICEINFO));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDEVICESGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDEVICESSTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPDEVICEINFO,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AODEVICEINFO));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICEGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICENAME));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICEUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICENAME));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICERELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICENAME));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICESTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPMEDIAINFO,dap_resinffi_tclSemanticDomain::EN_MSG_OMEDIAINFO));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESRELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESSTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPMEDIAINFO,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AOMEDIAINFO));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATAGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPDATATYPE,dap_resinffi_tclSemanticDomain::EN_MSG_ENDATATYPE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATAUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPDATATYPE,dap_resinffi_tclSemanticDomain::EN_MSG_ENDATATYPE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATARELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPDATATYPE,dap_resinffi_tclSemanticDomain::EN_MSG_ENDATATYPE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATASTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPDATAINFO,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AODATAINFO));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDATAGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDATASTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPDATAINFO,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AODATAINFO));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETRELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPDATASETINFO,dap_resinffi_tclSemanticDomain::EN_MSG_ODATASETINFO));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETSET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPDATASETINFO,dap_resinffi_tclSemanticDomain::EN_MSG_ODATASETINFO));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_U32CONTROLHANDLE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_CTRLDEFAULTDATASETSET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPDEFAULTCONTROL,dap_resinffi_tclSemanticDomain::EN_MSG_ODEFAULTCONTROL));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_CTRLDEFAULTDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPDEFAULTCONTROL,dap_resinffi_tclSemanticDomain::EN_MSG_ODEFAULTCONTROL));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFOUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFORELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFOSTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPDATAINFO,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AODATAINFO));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDEVICESET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICEPATH));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDEVICESTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U16,dap_resinffi_tclSemanticDomain::EN_MSG_U16ERRORSTATE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICEPATH));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETRELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPREGIONDESCRIPTION,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AOREGIONDESCRIPTIONS));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATAGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATAUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATARELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATASTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPPROFILEMETAINFO,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AOPROFILEMETADATAS));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPREGIONMETAINFO,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_MSG_AOREGIONMETADATAS));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASETID));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICENAME));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICENAME));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONRELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZDEVICENAME));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONSTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPWRITEPROT,dap_resinffi_tclSemanticDomain::EN_MSG_U8WRITEPROTSTATE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTSET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZENGINEERINGSTRING));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTGET:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTRELUPREG:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_MSG_SZENGINEERINGSTRING));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE,dap_resinffi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPPRIORITAET,dap_resinffi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_resinffi_tclToken::EN_BINCONTAINER:
   case dap_resinffi_tclToken::EN_E8_DAPPRIORITAET:
   case dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE:
   case dap_resinffi_tclToken::EN_E8_DAPDATAAVAILABLE:
   case dap_resinffi_tclToken::EN_E8_DAPDATATYPE:
   case dap_resinffi_tclToken::EN_E8_DAPMEDIATYPE:
   case dap_resinffi_tclToken::EN_E8_DAPDEVICEERROR:
   case dap_resinffi_tclToken::EN_E8_DAPACCESSMODE:
   case dap_resinffi_tclToken::EN_E8_DAPWRITEPROT:
   case dap_resinffi_tclToken::EN_E16_DAPFILETYPE:
   case dap_resinffi_tclToken::EN_E16_DAPNUMBERREPR:
   case dap_resinffi_tclToken::EN_DAPDEVICEINFO:
   case dap_resinffi_tclToken::EN_DAPFILETYPE:
   case dap_resinffi_tclToken::EN_DAPCODEPAGEDESCR:
   case dap_resinffi_tclToken::EN_DAPLANGUAGEDESCR:
   case dap_resinffi_tclToken::EN_DAPVIRTUALMEDIAINFO:
   case dap_resinffi_tclToken::EN_DAPMEDIAINFO:
   case dap_resinffi_tclToken::EN_DAPDATAINFO:
   case dap_resinffi_tclToken::EN_DAPDATASETINFO:
   case dap_resinffi_tclToken::EN_DAPDEFAULTCONTROL:
   case dap_resinffi_tclToken::EN_DAPREGIONMETAINFO:
   case dap_resinffi_tclToken::EN_DAPPROFILEMETAINFO:
   case dap_resinffi_tclToken::EN_DAPREGIONDESCRIPTION:
   case dap_resinffi_tclToken::EN_U8:   
   case dap_resinffi_tclToken::EN_S8:   
   case dap_resinffi_tclToken::EN_U16:   
   case dap_resinffi_tclToken::EN_S16:   
   case dap_resinffi_tclToken::EN_U24:   
   case dap_resinffi_tclToken::EN_S24:   
   case dap_resinffi_tclToken::EN_U32:   
   case dap_resinffi_tclToken::EN_S32:   
   case dap_resinffi_tclToken::EN_U64:   
   case dap_resinffi_tclToken::EN_S64:   
   case dap_resinffi_tclToken::EN_F32:   
   case dap_resinffi_tclToken::EN_F64:   
   case dap_resinffi_tclToken::EN_BOOL:   
   case dap_resinffi_tclToken::EN_STRING:   
   case dap_resinffi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(dap_resinffi_tclKnot(enMsgToken,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool dap_resinffi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool dap_resinffi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      dap_resinffi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      dap_resinffi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      dap_resinffi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(dap_resinffi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(dap_resinffi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(dap_resinffi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case dap_resinffi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == dap_resinffi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_resinffi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_resinffi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_resinffi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_resinffi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case dap_resinffi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case dap_resinffi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_resinffi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case dap_resinffi_tclToken::EN_MSG_GETLANGUAGEDESCRIPTIONMETHODSTART:
   case dap_resinffi_tclToken::EN_MSG_GETLANGUAGEDESCRIPTIONMETHODRESULT:
   case dap_resinffi_tclToken::EN_MSG_GETFILEDESCRIPTIONMETHODSTART:
   case dap_resinffi_tclToken::EN_MSG_GETFILEDESCRIPTIONMETHODRESULT:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICEGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICEUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICERELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDEVICESTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDEVICESGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDEVICESSTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICEGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICEUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICERELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFDEVICESTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESRELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_MEDIASTATEOFALLDEVICESSTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATAGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATAUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATARELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFDATASTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDATAGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFALLDATASTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETRELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETSTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATASETSET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_CTRLDEFAULTDATASETSET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_CTRLDEFAULTDATASETSTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFOUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFORELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDATAINFOSTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDEVICESET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTDEVICESTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETRELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_REGIONSOFDEFAULTDATASETSTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATAGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATAUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATARELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_DEFAULTREGIONMETADATASTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONRELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_STATEOFWRITEPROTECTIONSTATUS:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTSET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTGET:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTRELUPREG:
   case dap_resinffi_tclToken::EN_MSG_DAP_RI_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case dap_resinffi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U8,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_E8_DAPPRIORITAET:
   {
      fi_tcl_e8_DapPrioritaet o_e8_DapPrioritaet;
      if (!bDoIt(o_e8_DapPrioritaet))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_U32_DAPCONTAINERSIZE:
   {
      fi_tcl_u32_DapContainerSize o_u32_DapContainerSize;
      if (!bDoIt(o_u32_DapContainerSize))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_E8_DAPDATAAVAILABLE:
   {
      fi_tcl_e8_DapDataAvailable o_e8_DapDataAvailable;
      if (!bDoIt(o_e8_DapDataAvailable))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_E8_DAPDATATYPE:
   {
      fi_tcl_e8_DapDataType o_e8_DapDataType;
      if (!bDoIt(o_e8_DapDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_E8_DAPMEDIATYPE:
   {
      fi_tcl_e8_DapMediaType o_e8_DapMediaType;
      if (!bDoIt(o_e8_DapMediaType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_E8_DAPDEVICEERROR:
   {
      fi_tcl_e8_DapDeviceError o_e8_DapDeviceError;
      if (!bDoIt(o_e8_DapDeviceError))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_E8_DAPACCESSMODE:
   {
      fi_tcl_e8_DapAccessMode o_e8_DapAccessMode;
      if (!bDoIt(o_e8_DapAccessMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_E8_DAPWRITEPROT:
   {
      fi_tcl_e8_DapWriteProt o_e8_DapWriteProt;
      if (!bDoIt(o_e8_DapWriteProt))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_E16_DAPFILETYPE:
   {
      fi_tcl_e16_DapFileType o_e16_DapFileType;
      if (!bDoIt(o_e16_DapFileType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_E16_DAPNUMBERREPR:
   {
      fi_tcl_e16_DapNumberRepr o_e16_DapNumberRepr;
      if (!bDoIt(o_e16_DapNumberRepr))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_resinffi_tclToken::EN_DAPDEVICEINFO:
   {
      if (poVisitor->bDoExpand_DapDeviceInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZDEVICENAME));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPDEVICEERROR,dap_resinffi_tclSemanticDomain::EN_ENDEVICEERROR));
      }
      else
      {
         fi_tcl_DapDeviceInfo o_DapDeviceInfo;
         if (!bDoIt(o_DapDeviceInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDeviceInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDeviceInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPFILETYPE:
   {
      if (poVisitor->bDoExpand_DapFileType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZSUFFIX));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZPREFIX));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E16_DAPNUMBERREPR,dap_resinffi_tclSemanticDomain::EN_U16NUMREP));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E16_DAPFILETYPE,dap_resinffi_tclSemanticDomain::EN_U16FILETYPE));
      }
      else
      {
         fi_tcl_DapFileType o_DapFileType;
         if (!bDoIt(o_DapFileType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapFileType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapFileType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPCODEPAGEDESCR:
   {
      if (poVisitor->bDoExpand_DapCodePageDescr(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZCODEPAGE));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32LASTLETTER));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32FIRSTLETTER));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U16,dap_resinffi_tclSemanticDomain::EN_U16LISTPOSITION));
      }
      else
      {
         fi_tcl_DapCodePageDescr o_DapCodePageDescr;
         if (!bDoIt(o_DapCodePageDescr))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapCodePageDescr.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapCodePageDescr.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPLANGUAGEDESCR:
   {
      if (poVisitor->bDoExpand_DapLanguageDescr(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U16,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_AU16CODEPAGEPOS));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U16,dap_resinffi_tclSemanticDomain::EN_U16LANGUAGECODE));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U16,dap_resinffi_tclSemanticDomain::EN_U16LANGUAGEID));
      }
      else
      {
         fi_tcl_DapLanguageDescr o_DapLanguageDescr;
         if (!bDoIt(o_DapLanguageDescr))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapLanguageDescr.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapLanguageDescr.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPVIRTUALMEDIAINFO:
   {
      if (poVisitor->bDoExpand_DapVirtualMediaInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZMEDIADESCRIPTION));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPDATAAVAILABLE,dap_resinffi_tclSemanticDomain::EN_ENDATAAVAILABLE));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32MEDIAID));
      }
      else
      {
         fi_tcl_DapVirtualMediaInfo o_DapVirtualMediaInfo;
         if (!bDoIt(o_DapVirtualMediaInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapVirtualMediaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapVirtualMediaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPMEDIAINFO:
   {
      if (poVisitor->bDoExpand_DapMediaInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_DAPVIRTUALMEDIAINFO,dap_resinffi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_LIST,dap_resinffi_tclSemanticDomain::EN_AOVIRTUALMEDIAINFO));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZDEVICENAME));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPMEDIATYPE,dap_resinffi_tclSemanticDomain::EN_ENMEDIATYPE));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPACCESSMODE,dap_resinffi_tclSemanticDomain::EN_ENACCESSMODE));
      }
      else
      {
         fi_tcl_DapMediaInfo o_DapMediaInfo;
         if (!bDoIt(o_DapMediaInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapMediaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapMediaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPDATAINFO:
   {
      if (poVisitor->bDoExpand_DapDataInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZACCESSPATH));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32DATABASEID));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32DATASETID));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32MEDIAID));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPDATAAVAILABLE,dap_resinffi_tclSemanticDomain::EN_ENDATAAVAILABLE));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPDATATYPE,dap_resinffi_tclSemanticDomain::EN_ENDATATYPE));
      }
      else
      {
         fi_tcl_DapDataInfo o_DapDataInfo;
         if (!bDoIt(o_DapDataInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDataInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDataInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPDATASETINFO:
   {
      if (poVisitor->bDoExpand_DapDataSetInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZACCESSPATH));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_E8_DAPDATAAVAILABLE,dap_resinffi_tclSemanticDomain::EN_ENDATAAVAILABLE));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32DATASETID));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32MEDIAID));
      }
      else
      {
         fi_tcl_DapDataSetInfo o_DapDataSetInfo;
         if (!bDoIt(o_DapDataSetInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDataSetInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDataSetInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPDEFAULTCONTROL:
   {
      if (poVisitor->bDoExpand_DapDefaultControl(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_BOOL,dap_resinffi_tclSemanticDomain::EN_BGETCONTROL));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32CTRLHANDLE));
      }
      else
      {
         fi_tcl_DapDefaultControl o_DapDefaultControl;
         if (!bDoIt(o_DapDefaultControl))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDefaultControl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDefaultControl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPREGIONMETAINFO:
   {
      if (poVisitor->bDoExpand_DapRegionMetaInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZREGIONCODE));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U16,dap_resinffi_tclSemanticDomain::EN_U16REGIONID));
      }
      else
      {
         fi_tcl_DapRegionMetaInfo o_DapRegionMetaInfo;
         if (!bDoIt(o_DapRegionMetaInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionMetaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionMetaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPPROFILEMETAINFO:
   {
      if (poVisitor->bDoExpand_DapProfileMetaInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZPROFILE));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U8,dap_resinffi_tclSemanticDomain::EN_U8PROFILEID));
      }
      else
      {
         fi_tcl_DapProfileMetaInfo o_DapProfileMetaInfo;
         if (!bDoIt(o_DapProfileMetaInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapProfileMetaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapProfileMetaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_resinffi_tclToken::EN_DAPREGIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_DapRegionDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_END_OF_STRUCT,dap_resinffi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U32,dap_resinffi_tclSemanticDomain::EN_U32MEDIUMID));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_STRING,dap_resinffi_tclSemanticDomain::EN_SZDEVICE));
         oPath.bGoDown(dap_resinffi_tclKnot(dap_resinffi_tclToken::EN_U16,dap_resinffi_tclSemanticDomain::EN_U16REGIONID));
      }
      else
      {
         fi_tcl_DapRegionDescription o_DapRegionDescription;
         if (!bDoIt(o_DapRegionDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case dap_resinffi_tclToken::EN_UNKNOWN:
      case dap_resinffi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

