/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DAP_REGIONSELECTIONFITYPES_HEADER
#define DAP_REGIONSELECTIONFITYPES_HEADER

// #include <vector>
// 


class dap_regionselectionfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class dap_regionselectionfi_tclMsgGetRegionListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgGetRegionListMethodStart():MediaId(0),Device() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgGetRegionListMethodStart& operator=(const dap_regionselectionfi_tclMsgGetRegionListMethodStart& coRef);
   dap_regionselectionfi_tclMsgGetRegionListMethodStart(const dap_regionselectionfi_tclMsgGetRegionListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MediaId;
   fi_tclString Device;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgGetRegionListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_GETREGIONLISTMETHODSTART;}
};

class dap_regionselectionfi_tclMsgGetRegionListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgGetRegionListMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgGetRegionListMethodResult& operator=(const dap_regionselectionfi_tclMsgGetRegionListMethodResult& coRef);
   dap_regionselectionfi_tclMsgGetRegionListMethodResult(const dap_regionselectionfi_tclMsgGetRegionListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RegionInfo, std::allocator<fi_tcl_RegionInfo> > RegionInfos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgGetRegionListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_GETREGIONLISTMETHODRESULT;}
};

class dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart():Device() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart& operator=(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart& coRef);
   dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Device;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_GETFREEMEMORYMETHODSTART;}
};

class dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult():MemorySizeLow(0),MemorySizeHigh(0),MaxSlots(0),FreeSlots(0),WriteEnabled(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult& operator=(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult& coRef);
   dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MemorySizeLow;
   tU32 MemorySizeHigh;
   tU16 MaxSlots;
   tU16 FreeSlots;
   tBool WriteEnabled;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_GETFREEMEMORYMETHODRESULT;}
};

class dap_regionselectionfi_tclMsgStoreRegionsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgStoreRegionsMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgStoreRegionsMethodStart& operator=(const dap_regionselectionfi_tclMsgStoreRegionsMethodStart& coRef);
   dap_regionselectionfi_tclMsgStoreRegionsMethodStart(const dap_regionselectionfi_tclMsgStoreRegionsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RegionNumberOrder, std::allocator<fi_tcl_RegionNumberOrder> > RegionNumberOrderList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgStoreRegionsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODSTART;}
};

class dap_regionselectionfi_tclMsgStoreRegionsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgStoreRegionsMethodResult():NrReadErrors(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgStoreRegionsMethodResult& operator=(const dap_regionselectionfi_tclMsgStoreRegionsMethodResult& coRef);
   dap_regionselectionfi_tclMsgStoreRegionsMethodResult(const dap_regionselectionfi_tclMsgStoreRegionsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RegionNumberResult, std::allocator<fi_tcl_RegionNumberResult> > RegionNumberList;
   tU32 NrReadErrors;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgStoreRegionsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODRESULT;}
};

class dap_regionselectionfi_tclMsgStoreRegionsMethodAbort : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgStoreRegionsMethodAbort() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgStoreRegionsMethodAbort& operator=(const dap_regionselectionfi_tclMsgStoreRegionsMethodAbort& coRef);
   dap_regionselectionfi_tclMsgStoreRegionsMethodAbort(const dap_regionselectionfi_tclMsgStoreRegionsMethodAbort& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgStoreRegionsMethodAbort& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODABORT;}
};

class dap_regionselectionfi_tclMsgStoreRegionsAbortResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgStoreRegionsAbortResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgStoreRegionsAbortResult& operator=(const dap_regionselectionfi_tclMsgStoreRegionsAbortResult& coRef);
   dap_regionselectionfi_tclMsgStoreRegionsAbortResult(const dap_regionselectionfi_tclMsgStoreRegionsAbortResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgStoreRegionsAbortResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSABORTRESULT;}
};

class dap_regionselectionfi_tclMsgResumeStorageMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgResumeStorageMethodStart():ResumeType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgResumeStorageMethodStart& operator=(const dap_regionselectionfi_tclMsgResumeStorageMethodStart& coRef);
   dap_regionselectionfi_tclMsgResumeStorageMethodStart(const dap_regionselectionfi_tclMsgResumeStorageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ResumeType ResumeType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgResumeStorageMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODSTART;}
};

class dap_regionselectionfi_tclMsgResumeStorageMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgResumeStorageMethodResult():NrReadErrors(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgResumeStorageMethodResult& operator=(const dap_regionselectionfi_tclMsgResumeStorageMethodResult& coRef);
   dap_regionselectionfi_tclMsgResumeStorageMethodResult(const dap_regionselectionfi_tclMsgResumeStorageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RegionNumberResult, std::allocator<fi_tcl_RegionNumberResult> > RegionNumberList;
   tU32 NrReadErrors;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgResumeStorageMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODRESULT;}
};

class dap_regionselectionfi_tclMsgResumeStorageMethodAbort : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgResumeStorageMethodAbort() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgResumeStorageMethodAbort& operator=(const dap_regionselectionfi_tclMsgResumeStorageMethodAbort& coRef);
   dap_regionselectionfi_tclMsgResumeStorageMethodAbort(const dap_regionselectionfi_tclMsgResumeStorageMethodAbort& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgResumeStorageMethodAbort& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODABORT;}
};

class dap_regionselectionfi_tclMsgResumeStorageAbortResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgResumeStorageAbortResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgResumeStorageAbortResult& operator=(const dap_regionselectionfi_tclMsgResumeStorageAbortResult& coRef);
   dap_regionselectionfi_tclMsgResumeStorageAbortResult(const dap_regionselectionfi_tclMsgResumeStorageAbortResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgResumeStorageAbortResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEABORTRESULT;}
};

class dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart():MediaId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart& operator=(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart& coRef);
   dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MediaId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_GETREGIONOUTLINESMETHODSTART;}
};

class dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult& operator=(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult& coRef);
   dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RegionOutline, std::allocator<fi_tcl_RegionOutline> > RegionOutlines;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_GETREGIONOUTLINESMETHODRESULT;}
};

class dap_regionselectionfi_tclMsgLastOrderListGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgLastOrderListGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgLastOrderListGet& operator=(const dap_regionselectionfi_tclMsgLastOrderListGet& coRef);
   dap_regionselectionfi_tclMsgLastOrderListGet(const dap_regionselectionfi_tclMsgLastOrderListGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgLastOrderListGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_LASTORDERLISTGET;}
};

class dap_regionselectionfi_tclMsgLastOrderListStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgLastOrderListStatus():Validity(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgLastOrderListStatus& operator=(const dap_regionselectionfi_tclMsgLastOrderListStatus& coRef);
   dap_regionselectionfi_tclMsgLastOrderListStatus(const dap_regionselectionfi_tclMsgLastOrderListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool Validity;
   std::vector<fi_tcl_OrderInfo, std::allocator<fi_tcl_OrderInfo> > RegionOrderList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgLastOrderListStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_LASTORDERLISTSTATUS;}
};

class dap_regionselectionfi_tclMsgStorageProgressGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgStorageProgressGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgStorageProgressGet& operator=(const dap_regionselectionfi_tclMsgStorageProgressGet& coRef);
   dap_regionselectionfi_tclMsgStorageProgressGet(const dap_regionselectionfi_tclMsgStorageProgressGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgStorageProgressGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSGET;}
};

class dap_regionselectionfi_tclMsgStorageProgressUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgStorageProgressUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgStorageProgressUpReg& operator=(const dap_regionselectionfi_tclMsgStorageProgressUpReg& coRef);
   dap_regionselectionfi_tclMsgStorageProgressUpReg(const dap_regionselectionfi_tclMsgStorageProgressUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgStorageProgressUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSUPREG;}
};

class dap_regionselectionfi_tclMsgStorageProgressRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgStorageProgressRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgStorageProgressRelUpReg& operator=(const dap_regionselectionfi_tclMsgStorageProgressRelUpReg& coRef);
   dap_regionselectionfi_tclMsgStorageProgressRelUpReg(const dap_regionselectionfi_tclMsgStorageProgressRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgStorageProgressRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSRELUPREG;}
};

class dap_regionselectionfi_tclMsgStorageProgressStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgStorageProgressStatus():Status(),OverallProgress(),SingleProgress() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgStorageProgressStatus& operator=(const dap_regionselectionfi_tclMsgStorageProgressStatus& coRef);
   dap_regionselectionfi_tclMsgStorageProgressStatus(const dap_regionselectionfi_tclMsgStorageProgressStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ProgressStatus Status;
   fi_tcl_u8_Percent OverallProgress;
   fi_tcl_u8_Percent SingleProgress;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgStorageProgressStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSSTATUS;}
};

class dap_regionselectionfi_tclMsgGetLinkDeviceGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgGetLinkDeviceGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgGetLinkDeviceGet& operator=(const dap_regionselectionfi_tclMsgGetLinkDeviceGet& coRef);
   dap_regionselectionfi_tclMsgGetLinkDeviceGet(const dap_regionselectionfi_tclMsgGetLinkDeviceGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgGetLinkDeviceGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_GETLINKDEVICEGET;}
};

class dap_regionselectionfi_tclMsgGetLinkDeviceStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgGetLinkDeviceStatus():Device() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgGetLinkDeviceStatus& operator=(const dap_regionselectionfi_tclMsgGetLinkDeviceStatus& coRef);
   dap_regionselectionfi_tclMsgGetLinkDeviceStatus(const dap_regionselectionfi_tclMsgGetLinkDeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Device;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgGetLinkDeviceStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_GETLINKDEVICESTATUS;}
};

class dap_regionselectionfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgEngineeringTextGet& operator=(const dap_regionselectionfi_tclMsgEngineeringTextGet& coRef);
   dap_regionselectionfi_tclMsgEngineeringTextGet(const dap_regionselectionfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class dap_regionselectionfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgEngineeringTextUpReg& operator=(const dap_regionselectionfi_tclMsgEngineeringTextUpReg& coRef);
   dap_regionselectionfi_tclMsgEngineeringTextUpReg(const dap_regionselectionfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class dap_regionselectionfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgEngineeringTextRelUpReg& operator=(const dap_regionselectionfi_tclMsgEngineeringTextRelUpReg& coRef);
   dap_regionselectionfi_tclMsgEngineeringTextRelUpReg(const dap_regionselectionfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class dap_regionselectionfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_regionselectionfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_regionselectionfi_tclMsgEngineeringTextStatus& operator=(const dap_regionselectionfi_tclMsgEngineeringTextStatus& coRef);
   dap_regionselectionfi_tclMsgEngineeringTextStatus(const dap_regionselectionfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_regionselectionfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
