/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetRegionListMethodStart::dap_regionselectionfi_tclMsgGetRegionListMethodStart(const dap_regionselectionfi_tclMsgGetRegionListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
   Device = coRef.Device;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetRegionListMethodStart& dap_regionselectionfi_tclMsgGetRegionListMethodStart::operator=(const dap_regionselectionfi_tclMsgGetRegionListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   Device = coRef.Device;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgGetRegionListMethodStart::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgGetRegionListMethodStart::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_GETREGIONLIST;}
tU8 dap_regionselectionfi_tclMsgGetRegionListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_regionselectionfi_tclMsgGetRegionListMethodStart::vDestroy()
{
   Device.vDestroy();
}

tU32 dap_regionselectionfi_tclMsgGetRegionListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Device.u32GetSize(u16MajorVersion);
}

tBool dap_regionselectionfi_tclMsgGetRegionListMethodStart::operator==(const dap_regionselectionfi_tclMsgGetRegionListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
      bResult = bResult && (Device == rfoCmp.Device);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgGetRegionListMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   oIn >> Device;
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgGetRegionListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   oOut << Device;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetRegionListMethodResult::dap_regionselectionfi_tclMsgGetRegionListMethodResult(const dap_regionselectionfi_tclMsgGetRegionListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionInfos = coRef.RegionInfos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetRegionListMethodResult& dap_regionselectionfi_tclMsgGetRegionListMethodResult::operator=(const dap_regionselectionfi_tclMsgGetRegionListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RegionInfos = coRef.RegionInfos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgGetRegionListMethodResult::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgGetRegionListMethodResult::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_GETREGIONLIST;}
tU8 dap_regionselectionfi_tclMsgGetRegionListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_regionselectionfi_tclMsgGetRegionListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RegionInfos.size(); ++u32Idx)
         RegionInfos[u32Idx].vDestroy();
   }
   RegionInfos.clear();
}

tU32 dap_regionselectionfi_tclMsgGetRegionListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RegionInfos.size(); ++u32ListIdx)
      u32DynamicSize += RegionInfos[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_regionselectionfi_tclMsgGetRegionListMethodResult::operator==(const dap_regionselectionfi_tclMsgGetRegionListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionInfos.size() == rfoCmp.RegionInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionInfos.size()); ++u32Idx)
            bResult = bResult && (RegionInfos[u32Idx] == rfoCmp.RegionInfos[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgGetRegionListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RegionInfos.size(); ++u32Idx)
      {
         RegionInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RegionInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RegionInfos[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgGetRegionListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RegionInfos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RegionInfos.size(); ++u32Idx)
         oOut << RegionInfos[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Device = coRef.Device;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart& dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::operator=(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Device = coRef.Device;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_GETFREEMEMORY;}
tU8 dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::vDestroy()
{
   Device.vDestroy();
}

tU32 dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Device.u32GetSize(u16MajorVersion);
}

tBool dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::operator==(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Device == rfoCmp.Device);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Device;
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgGetFreeMemoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Device;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult::dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MemorySizeLow = coRef.MemorySizeLow;
   MemorySizeHigh = coRef.MemorySizeHigh;
   MaxSlots = coRef.MaxSlots;
   FreeSlots = coRef.FreeSlots;
   WriteEnabled = coRef.WriteEnabled;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult& dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult::operator=(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MemorySizeLow = coRef.MemorySizeLow;
   MemorySizeHigh = coRef.MemorySizeHigh;
   MaxSlots = coRef.MaxSlots;
   FreeSlots = coRef.FreeSlots;
   WriteEnabled = coRef.WriteEnabled;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_GETFREEMEMORY;}
tU8 dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

tBool dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult::operator==(const dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MemorySizeLow == rfoCmp.MemorySizeLow);
      bResult = bResult && (MemorySizeHigh == rfoCmp.MemorySizeHigh);
      bResult = bResult && (MaxSlots == rfoCmp.MaxSlots);
      bResult = bResult && (FreeSlots == rfoCmp.FreeSlots);
      bResult = bResult && (WriteEnabled == rfoCmp.WriteEnabled);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MemorySizeLow;
   oIn >> MemorySizeHigh;
   oIn >> MaxSlots;
   oIn >> FreeSlots;
   oIn >> WriteEnabled;
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgGetFreeMemoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MemorySizeLow;
   oOut << MemorySizeHigh;
   oOut << MaxSlots;
   oOut << FreeSlots;
   oOut << WriteEnabled;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStoreRegionsMethodStart::dap_regionselectionfi_tclMsgStoreRegionsMethodStart(const dap_regionselectionfi_tclMsgStoreRegionsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionNumberOrderList = coRef.RegionNumberOrderList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStoreRegionsMethodStart& dap_regionselectionfi_tclMsgStoreRegionsMethodStart::operator=(const dap_regionselectionfi_tclMsgStoreRegionsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RegionNumberOrderList = coRef.RegionNumberOrderList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgStoreRegionsMethodStart::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgStoreRegionsMethodStart::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_STOREREGIONS;}
tU8 dap_regionselectionfi_tclMsgStoreRegionsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_regionselectionfi_tclMsgStoreRegionsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RegionNumberOrderList.size(); ++u32Idx)
         RegionNumberOrderList[u32Idx].vDestroy();
   }
   RegionNumberOrderList.clear();
}

tU32 dap_regionselectionfi_tclMsgStoreRegionsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+RegionNumberOrderList.size()*3;
}

tBool dap_regionselectionfi_tclMsgStoreRegionsMethodStart::operator==(const dap_regionselectionfi_tclMsgStoreRegionsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionNumberOrderList.size() == rfoCmp.RegionNumberOrderList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionNumberOrderList.size()); ++u32Idx)
            bResult = bResult && (RegionNumberOrderList[u32Idx] == rfoCmp.RegionNumberOrderList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgStoreRegionsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RegionNumberOrderList.size(); ++u32Idx)
      {
         RegionNumberOrderList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RegionNumberOrderList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RegionNumberOrderList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgStoreRegionsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RegionNumberOrderList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RegionNumberOrderList.size(); ++u32Idx)
         oOut << RegionNumberOrderList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStoreRegionsMethodResult::dap_regionselectionfi_tclMsgStoreRegionsMethodResult(const dap_regionselectionfi_tclMsgStoreRegionsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionNumberList = coRef.RegionNumberList;
   NrReadErrors = coRef.NrReadErrors;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStoreRegionsMethodResult& dap_regionselectionfi_tclMsgStoreRegionsMethodResult::operator=(const dap_regionselectionfi_tclMsgStoreRegionsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RegionNumberList = coRef.RegionNumberList;
   NrReadErrors = coRef.NrReadErrors;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgStoreRegionsMethodResult::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgStoreRegionsMethodResult::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_STOREREGIONS;}
tU8 dap_regionselectionfi_tclMsgStoreRegionsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_regionselectionfi_tclMsgStoreRegionsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RegionNumberList.size(); ++u32Idx)
         RegionNumberList[u32Idx].vDestroy();
   }
   RegionNumberList.clear();
}

tU32 dap_regionselectionfi_tclMsgStoreRegionsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+4+RegionNumberList.size()*4;
}

tBool dap_regionselectionfi_tclMsgStoreRegionsMethodResult::operator==(const dap_regionselectionfi_tclMsgStoreRegionsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionNumberList.size() == rfoCmp.RegionNumberList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionNumberList.size()); ++u32Idx)
            bResult = bResult && (RegionNumberList[u32Idx] == rfoCmp.RegionNumberList[u32Idx]);
      }
      bResult = bResult && (NrReadErrors == rfoCmp.NrReadErrors);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgStoreRegionsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RegionNumberList.size(); ++u32Idx)
      {
         RegionNumberList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RegionNumberList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RegionNumberList[u32Idx];
      }
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> NrReadErrors;
   }
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgStoreRegionsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RegionNumberList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RegionNumberList.size(); ++u32Idx)
         oOut << RegionNumberList[u32Idx];
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << NrReadErrors;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStoreRegionsMethodAbort::dap_regionselectionfi_tclMsgStoreRegionsMethodAbort(const dap_regionselectionfi_tclMsgStoreRegionsMethodAbort& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStoreRegionsMethodAbort& dap_regionselectionfi_tclMsgStoreRegionsMethodAbort::operator=(const dap_regionselectionfi_tclMsgStoreRegionsMethodAbort& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgStoreRegionsMethodAbort::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgStoreRegionsMethodAbort::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_STOREREGIONS;}
tU8 dap_regionselectionfi_tclMsgStoreRegionsMethodAbort::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODABORT;}

tU32 dap_regionselectionfi_tclMsgStoreRegionsMethodAbort::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgStoreRegionsMethodAbort::operator==(const dap_regionselectionfi_tclMsgStoreRegionsMethodAbort& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgStoreRegionsMethodAbort::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgStoreRegionsMethodAbort::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStoreRegionsAbortResult::dap_regionselectionfi_tclMsgStoreRegionsAbortResult(const dap_regionselectionfi_tclMsgStoreRegionsAbortResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStoreRegionsAbortResult& dap_regionselectionfi_tclMsgStoreRegionsAbortResult::operator=(const dap_regionselectionfi_tclMsgStoreRegionsAbortResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgStoreRegionsAbortResult::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgStoreRegionsAbortResult::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_STOREREGIONS;}
tU8 dap_regionselectionfi_tclMsgStoreRegionsAbortResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_ABORTRESULT;}

tU32 dap_regionselectionfi_tclMsgStoreRegionsAbortResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgStoreRegionsAbortResult::operator==(const dap_regionselectionfi_tclMsgStoreRegionsAbortResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgStoreRegionsAbortResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgStoreRegionsAbortResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgResumeStorageMethodStart::dap_regionselectionfi_tclMsgResumeStorageMethodStart(const dap_regionselectionfi_tclMsgResumeStorageMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ResumeType = coRef.ResumeType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgResumeStorageMethodStart& dap_regionselectionfi_tclMsgResumeStorageMethodStart::operator=(const dap_regionselectionfi_tclMsgResumeStorageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ResumeType = coRef.ResumeType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgResumeStorageMethodStart::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgResumeStorageMethodStart::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_RESUMESTORAGE;}
tU8 dap_regionselectionfi_tclMsgResumeStorageMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_regionselectionfi_tclMsgResumeStorageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool dap_regionselectionfi_tclMsgResumeStorageMethodStart::operator==(const dap_regionselectionfi_tclMsgResumeStorageMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ResumeType == rfoCmp.ResumeType);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgResumeStorageMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ResumeType;
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgResumeStorageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ResumeType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgResumeStorageMethodResult::dap_regionselectionfi_tclMsgResumeStorageMethodResult(const dap_regionselectionfi_tclMsgResumeStorageMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionNumberList = coRef.RegionNumberList;
   NrReadErrors = coRef.NrReadErrors;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgResumeStorageMethodResult& dap_regionselectionfi_tclMsgResumeStorageMethodResult::operator=(const dap_regionselectionfi_tclMsgResumeStorageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RegionNumberList = coRef.RegionNumberList;
   NrReadErrors = coRef.NrReadErrors;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgResumeStorageMethodResult::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgResumeStorageMethodResult::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_RESUMESTORAGE;}
tU8 dap_regionselectionfi_tclMsgResumeStorageMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_regionselectionfi_tclMsgResumeStorageMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RegionNumberList.size(); ++u32Idx)
         RegionNumberList[u32Idx].vDestroy();
   }
   RegionNumberList.clear();
}

tU32 dap_regionselectionfi_tclMsgResumeStorageMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+4+RegionNumberList.size()*4;
}

tBool dap_regionselectionfi_tclMsgResumeStorageMethodResult::operator==(const dap_regionselectionfi_tclMsgResumeStorageMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionNumberList.size() == rfoCmp.RegionNumberList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionNumberList.size()); ++u32Idx)
            bResult = bResult && (RegionNumberList[u32Idx] == rfoCmp.RegionNumberList[u32Idx]);
      }
      bResult = bResult && (NrReadErrors == rfoCmp.NrReadErrors);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgResumeStorageMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RegionNumberList.size(); ++u32Idx)
      {
         RegionNumberList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RegionNumberList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RegionNumberList[u32Idx];
      }
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> NrReadErrors;
   }
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgResumeStorageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RegionNumberList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RegionNumberList.size(); ++u32Idx)
         oOut << RegionNumberList[u32Idx];
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << NrReadErrors;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgResumeStorageMethodAbort::dap_regionselectionfi_tclMsgResumeStorageMethodAbort(const dap_regionselectionfi_tclMsgResumeStorageMethodAbort& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgResumeStorageMethodAbort& dap_regionselectionfi_tclMsgResumeStorageMethodAbort::operator=(const dap_regionselectionfi_tclMsgResumeStorageMethodAbort& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgResumeStorageMethodAbort::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgResumeStorageMethodAbort::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_RESUMESTORAGE;}
tU8 dap_regionselectionfi_tclMsgResumeStorageMethodAbort::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODABORT;}

tU32 dap_regionselectionfi_tclMsgResumeStorageMethodAbort::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgResumeStorageMethodAbort::operator==(const dap_regionselectionfi_tclMsgResumeStorageMethodAbort& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgResumeStorageMethodAbort::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgResumeStorageMethodAbort::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgResumeStorageAbortResult::dap_regionselectionfi_tclMsgResumeStorageAbortResult(const dap_regionselectionfi_tclMsgResumeStorageAbortResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgResumeStorageAbortResult& dap_regionselectionfi_tclMsgResumeStorageAbortResult::operator=(const dap_regionselectionfi_tclMsgResumeStorageAbortResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgResumeStorageAbortResult::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgResumeStorageAbortResult::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_RESUMESTORAGE;}
tU8 dap_regionselectionfi_tclMsgResumeStorageAbortResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_ABORTRESULT;}

tU32 dap_regionselectionfi_tclMsgResumeStorageAbortResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgResumeStorageAbortResult::operator==(const dap_regionselectionfi_tclMsgResumeStorageAbortResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgResumeStorageAbortResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgResumeStorageAbortResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart::dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart& dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart::operator=(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_GETREGIONOUTLINES;}
tU8 dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart::operator==(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgGetRegionOutlinesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RegionOutlines = coRef.RegionOutlines;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult& dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::operator=(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RegionOutlines = coRef.RegionOutlines;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_GETREGIONOUTLINES;}
tU8 dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RegionOutlines.size(); ++u32Idx)
         RegionOutlines[u32Idx].vDestroy();
   }
   RegionOutlines.clear();
}

tU32 dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RegionOutlines.size(); ++u32ListIdx)
      u32DynamicSize += RegionOutlines[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::operator==(const dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RegionOutlines.size() == rfoCmp.RegionOutlines.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionOutlines.size()); ++u32Idx)
            bResult = bResult && (RegionOutlines[u32Idx] == rfoCmp.RegionOutlines[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RegionOutlines.size(); ++u32Idx)
      {
         RegionOutlines[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RegionOutlines.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RegionOutlines[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgGetRegionOutlinesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RegionOutlines.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RegionOutlines.size(); ++u32Idx)
         oOut << RegionOutlines[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgLastOrderListGet::dap_regionselectionfi_tclMsgLastOrderListGet(const dap_regionselectionfi_tclMsgLastOrderListGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgLastOrderListGet& dap_regionselectionfi_tclMsgLastOrderListGet::operator=(const dap_regionselectionfi_tclMsgLastOrderListGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgLastOrderListGet::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgLastOrderListGet::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_LASTORDERLIST;}
tU8 dap_regionselectionfi_tclMsgLastOrderListGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_regionselectionfi_tclMsgLastOrderListGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgLastOrderListGet::operator==(const dap_regionselectionfi_tclMsgLastOrderListGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgLastOrderListGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgLastOrderListGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgLastOrderListStatus::dap_regionselectionfi_tclMsgLastOrderListStatus(const dap_regionselectionfi_tclMsgLastOrderListStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Validity = coRef.Validity;
   RegionOrderList = coRef.RegionOrderList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgLastOrderListStatus& dap_regionselectionfi_tclMsgLastOrderListStatus::operator=(const dap_regionselectionfi_tclMsgLastOrderListStatus& coRef)
{
   if (this == &coRef) return *this;
   Validity = coRef.Validity;
   RegionOrderList = coRef.RegionOrderList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgLastOrderListStatus::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgLastOrderListStatus::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_LASTORDERLIST;}
tU8 dap_regionselectionfi_tclMsgLastOrderListStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_regionselectionfi_tclMsgLastOrderListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RegionOrderList.size(); ++u32Idx)
         RegionOrderList[u32Idx].vDestroy();
   }
   RegionOrderList.clear();
}

tU32 dap_regionselectionfi_tclMsgLastOrderListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RegionOrderList.size(); ++u32ListIdx)
      u32DynamicSize += RegionOrderList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

tBool dap_regionselectionfi_tclMsgLastOrderListStatus::operator==(const dap_regionselectionfi_tclMsgLastOrderListStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Validity == rfoCmp.Validity);
      bResult = bResult && (RegionOrderList.size() == rfoCmp.RegionOrderList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionOrderList.size()); ++u32Idx)
            bResult = bResult && (RegionOrderList[u32Idx] == rfoCmp.RegionOrderList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgLastOrderListStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Validity;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RegionOrderList.size(); ++u32Idx)
      {
         RegionOrderList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RegionOrderList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RegionOrderList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgLastOrderListStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Validity;
   oOut << (tU32)RegionOrderList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RegionOrderList.size(); ++u32Idx)
         oOut << RegionOrderList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStorageProgressGet::dap_regionselectionfi_tclMsgStorageProgressGet(const dap_regionselectionfi_tclMsgStorageProgressGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStorageProgressGet& dap_regionselectionfi_tclMsgStorageProgressGet::operator=(const dap_regionselectionfi_tclMsgStorageProgressGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgStorageProgressGet::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgStorageProgressGet::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_STORAGEPROGRESS;}
tU8 dap_regionselectionfi_tclMsgStorageProgressGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_regionselectionfi_tclMsgStorageProgressGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgStorageProgressGet::operator==(const dap_regionselectionfi_tclMsgStorageProgressGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgStorageProgressGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgStorageProgressGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStorageProgressUpReg::dap_regionselectionfi_tclMsgStorageProgressUpReg(const dap_regionselectionfi_tclMsgStorageProgressUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStorageProgressUpReg& dap_regionselectionfi_tclMsgStorageProgressUpReg::operator=(const dap_regionselectionfi_tclMsgStorageProgressUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgStorageProgressUpReg::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgStorageProgressUpReg::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_STORAGEPROGRESS;}
tU8 dap_regionselectionfi_tclMsgStorageProgressUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_regionselectionfi_tclMsgStorageProgressUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgStorageProgressUpReg::operator==(const dap_regionselectionfi_tclMsgStorageProgressUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgStorageProgressUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgStorageProgressUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStorageProgressRelUpReg::dap_regionselectionfi_tclMsgStorageProgressRelUpReg(const dap_regionselectionfi_tclMsgStorageProgressRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStorageProgressRelUpReg& dap_regionselectionfi_tclMsgStorageProgressRelUpReg::operator=(const dap_regionselectionfi_tclMsgStorageProgressRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgStorageProgressRelUpReg::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgStorageProgressRelUpReg::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_STORAGEPROGRESS;}
tU8 dap_regionselectionfi_tclMsgStorageProgressRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_regionselectionfi_tclMsgStorageProgressRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgStorageProgressRelUpReg::operator==(const dap_regionselectionfi_tclMsgStorageProgressRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgStorageProgressRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgStorageProgressRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStorageProgressStatus::dap_regionselectionfi_tclMsgStorageProgressStatus(const dap_regionselectionfi_tclMsgStorageProgressStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   OverallProgress = coRef.OverallProgress;
   SingleProgress = coRef.SingleProgress;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgStorageProgressStatus& dap_regionselectionfi_tclMsgStorageProgressStatus::operator=(const dap_regionselectionfi_tclMsgStorageProgressStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   OverallProgress = coRef.OverallProgress;
   SingleProgress = coRef.SingleProgress;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgStorageProgressStatus::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgStorageProgressStatus::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_STORAGEPROGRESS;}
tU8 dap_regionselectionfi_tclMsgStorageProgressStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 dap_regionselectionfi_tclMsgStorageProgressStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool dap_regionselectionfi_tclMsgStorageProgressStatus::operator==(const dap_regionselectionfi_tclMsgStorageProgressStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (OverallProgress == rfoCmp.OverallProgress);
      bResult = bResult && (SingleProgress == rfoCmp.SingleProgress);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgStorageProgressStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Status;
   oIn >> OverallProgress;
   oIn >> SingleProgress;
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgStorageProgressStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Status;
   oOut << OverallProgress;
   oOut << SingleProgress;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetLinkDeviceGet::dap_regionselectionfi_tclMsgGetLinkDeviceGet(const dap_regionselectionfi_tclMsgGetLinkDeviceGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetLinkDeviceGet& dap_regionselectionfi_tclMsgGetLinkDeviceGet::operator=(const dap_regionselectionfi_tclMsgGetLinkDeviceGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgGetLinkDeviceGet::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgGetLinkDeviceGet::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_GETLINKDEVICE;}
tU8 dap_regionselectionfi_tclMsgGetLinkDeviceGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_regionselectionfi_tclMsgGetLinkDeviceGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgGetLinkDeviceGet::operator==(const dap_regionselectionfi_tclMsgGetLinkDeviceGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgGetLinkDeviceGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgGetLinkDeviceGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetLinkDeviceStatus::dap_regionselectionfi_tclMsgGetLinkDeviceStatus(const dap_regionselectionfi_tclMsgGetLinkDeviceStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Device = coRef.Device;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgGetLinkDeviceStatus& dap_regionselectionfi_tclMsgGetLinkDeviceStatus::operator=(const dap_regionselectionfi_tclMsgGetLinkDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   Device = coRef.Device;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgGetLinkDeviceStatus::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgGetLinkDeviceStatus::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_GETLINKDEVICE;}
tU8 dap_regionselectionfi_tclMsgGetLinkDeviceStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_regionselectionfi_tclMsgGetLinkDeviceStatus::vDestroy()
{
   Device.vDestroy();
}

tU32 dap_regionselectionfi_tclMsgGetLinkDeviceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Device.u32GetSize(u16MajorVersion);
}

tBool dap_regionselectionfi_tclMsgGetLinkDeviceStatus::operator==(const dap_regionselectionfi_tclMsgGetLinkDeviceStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Device == rfoCmp.Device);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgGetLinkDeviceStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Device;
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgGetLinkDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Device;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgEngineeringTextGet::dap_regionselectionfi_tclMsgEngineeringTextGet(const dap_regionselectionfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgEngineeringTextGet& dap_regionselectionfi_tclMsgEngineeringTextGet::operator=(const dap_regionselectionfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_ENGINEERINGTEXT;}
tU8 dap_regionselectionfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_regionselectionfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgEngineeringTextGet::operator==(const dap_regionselectionfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgEngineeringTextUpReg::dap_regionselectionfi_tclMsgEngineeringTextUpReg(const dap_regionselectionfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgEngineeringTextUpReg& dap_regionselectionfi_tclMsgEngineeringTextUpReg::operator=(const dap_regionselectionfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_ENGINEERINGTEXT;}
tU8 dap_regionselectionfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_regionselectionfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgEngineeringTextUpReg::operator==(const dap_regionselectionfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgEngineeringTextRelUpReg::dap_regionselectionfi_tclMsgEngineeringTextRelUpReg(const dap_regionselectionfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgEngineeringTextRelUpReg& dap_regionselectionfi_tclMsgEngineeringTextRelUpReg::operator=(const dap_regionselectionfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_ENGINEERINGTEXT;}
tU8 dap_regionselectionfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_regionselectionfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_regionselectionfi_tclMsgEngineeringTextRelUpReg::operator==(const dap_regionselectionfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgEngineeringTextStatus::dap_regionselectionfi_tclMsgEngineeringTextStatus(const dap_regionselectionfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_regionselectionfi_tclMsgEngineeringTextStatus& dap_regionselectionfi_tclMsgEngineeringTextStatus::operator=(const dap_regionselectionfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_regionselectionfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return DAP_REGIONSELECTIONFI_C_U16_SERVICE_ID;}
tU16 dap_regionselectionfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return DAP_REGIONSELECTIONFI_C_U16_ENGINEERINGTEXT;}
tU8 dap_regionselectionfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_regionselectionfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 dap_regionselectionfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool dap_regionselectionfi_tclMsgEngineeringTextStatus::operator==(const dap_regionselectionfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& dap_regionselectionfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& dap_regionselectionfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

