#include "precompiled.hh"

tBool dap_regionselectionfi_tclDescription::bInitMessage(dap_regionselectionfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case dap_regionselectionfi_tclToken::EN_LAST_TOKEN:
   case dap_regionselectionfi_tclToken::EN_LIST:
   case dap_regionselectionfi_tclToken::EN_END_OF_STRUCT:
   case dap_regionselectionfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONLISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_STRING,dap_regionselectionfi_tclSemanticDomain::EN_MSG_DEVICE));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U32,dap_regionselectionfi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONLISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_REGIONINFO,dap_regionselectionfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_LIST,dap_regionselectionfi_tclSemanticDomain::EN_MSG_REGIONINFOS));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_GETFREEMEMORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_STRING,dap_regionselectionfi_tclSemanticDomain::EN_MSG_DEVICE));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_GETFREEMEMORYMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_BOOL,dap_regionselectionfi_tclSemanticDomain::EN_MSG_WRITEENABLED));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_MSG_FREESLOTS));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_MSG_MAXSLOTS));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U32,dap_regionselectionfi_tclSemanticDomain::EN_MSG_MEMORYSIZEHIGH));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U32,dap_regionselectionfi_tclSemanticDomain::EN_MSG_MEMORYSIZELOW));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_REGIONNUMBERORDER,dap_regionselectionfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_LIST,dap_regionselectionfi_tclSemanticDomain::EN_MSG_REGIONNUMBERORDERLIST));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODRESULT:
   {
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U32,dap_regionselectionfi_tclSemanticDomain::EN_MSG_NRREADERRORS));
      }
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_REGIONNUMBERRESULT,dap_regionselectionfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_LIST,dap_regionselectionfi_tclSemanticDomain::EN_MSG_REGIONNUMBERLIST));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_E8_RESUMETYPE,dap_regionselectionfi_tclSemanticDomain::EN_MSG_RESUMETYPE));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODRESULT:
   {
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U32,dap_regionselectionfi_tclSemanticDomain::EN_MSG_NRREADERRORS));
      }
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_REGIONNUMBERRESULT,dap_regionselectionfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_LIST,dap_regionselectionfi_tclSemanticDomain::EN_MSG_REGIONNUMBERLIST));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONOUTLINESMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U32,dap_regionselectionfi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONOUTLINESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_REGIONOUTLINE,dap_regionselectionfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_LIST,dap_regionselectionfi_tclSemanticDomain::EN_MSG_REGIONOUTLINES));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_LASTORDERLISTSTATUS:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_ORDERINFO,dap_regionselectionfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_LIST,dap_regionselectionfi_tclSemanticDomain::EN_MSG_REGIONORDERLIST));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_BOOL,dap_regionselectionfi_tclSemanticDomain::EN_MSG_VALIDITY));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSSTATUS:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U8_PERCENT,dap_regionselectionfi_tclSemanticDomain::EN_MSG_SINGLEPROGRESS));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U8_PERCENT,dap_regionselectionfi_tclSemanticDomain::EN_MSG_OVERALLPROGRESS));
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_E8_PROGRESSSTATUS,dap_regionselectionfi_tclSemanticDomain::EN_MSG_STATUS));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_GETLINKDEVICESTATUS:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_STRING,dap_regionselectionfi_tclSemanticDomain::EN_MSG_DEVICE));
   } break;
   case dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_STRING,dap_regionselectionfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case dap_regionselectionfi_tclToken::EN_BINCONTAINER:
   case dap_regionselectionfi_tclToken::EN_U8_PERCENT:
   case dap_regionselectionfi_tclToken::EN_S32_LONGITUDE:
   case dap_regionselectionfi_tclToken::EN_S32_LATITUDE:
   case dap_regionselectionfi_tclToken::EN_POSITIONWGS84:
   case dap_regionselectionfi_tclToken::EN_E8_STORAGEMODE:
   case dap_regionselectionfi_tclToken::EN_E8_RESUMETYPE:
   case dap_regionselectionfi_tclToken::EN_E8_STORESTATUS:
   case dap_regionselectionfi_tclToken::EN_E8_PROGRESSSTATUS:
   case dap_regionselectionfi_tclToken::EN_REGIONINFO:
   case dap_regionselectionfi_tclToken::EN_REGIONNUMBERORDER:
   case dap_regionselectionfi_tclToken::EN_REGIONNUMBERRESULT:
   case dap_regionselectionfi_tclToken::EN_ORDERINFO:
   case dap_regionselectionfi_tclToken::EN_REGIONOUTLINE:
   case dap_regionselectionfi_tclToken::EN_U8:   
   case dap_regionselectionfi_tclToken::EN_S8:   
   case dap_regionselectionfi_tclToken::EN_U16:   
   case dap_regionselectionfi_tclToken::EN_S16:   
   case dap_regionselectionfi_tclToken::EN_U24:   
   case dap_regionselectionfi_tclToken::EN_S24:   
   case dap_regionselectionfi_tclToken::EN_U32:   
   case dap_regionselectionfi_tclToken::EN_S32:   
   case dap_regionselectionfi_tclToken::EN_U64:   
   case dap_regionselectionfi_tclToken::EN_S64:   
   case dap_regionselectionfi_tclToken::EN_F32:   
   case dap_regionselectionfi_tclToken::EN_F64:   
   case dap_regionselectionfi_tclToken::EN_BOOL:   
   case dap_regionselectionfi_tclToken::EN_STRING:   
   case dap_regionselectionfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(dap_regionselectionfi_tclKnot(enMsgToken,dap_regionselectionfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool dap_regionselectionfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool dap_regionselectionfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      dap_regionselectionfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      dap_regionselectionfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      dap_regionselectionfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == dap_regionselectionfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(dap_regionselectionfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(dap_regionselectionfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(dap_regionselectionfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case dap_regionselectionfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == dap_regionselectionfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_regionselectionfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_regionselectionfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_regionselectionfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_regionselectionfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case dap_regionselectionfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case dap_regionselectionfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_regionselectionfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONLISTMETHODSTART:
   case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONLISTMETHODRESULT:
   case dap_regionselectionfi_tclToken::EN_MSG_GETFREEMEMORYMETHODSTART:
   case dap_regionselectionfi_tclToken::EN_MSG_GETFREEMEMORYMETHODRESULT:
   case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODSTART:
   case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODRESULT:
   case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSMETHODABORT:
   case dap_regionselectionfi_tclToken::EN_MSG_STOREREGIONSABORTRESULT:
   case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODSTART:
   case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODRESULT:
   case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEMETHODABORT:
   case dap_regionselectionfi_tclToken::EN_MSG_RESUMESTORAGEABORTRESULT:
   case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONOUTLINESMETHODSTART:
   case dap_regionselectionfi_tclToken::EN_MSG_GETREGIONOUTLINESMETHODRESULT:
   case dap_regionselectionfi_tclToken::EN_MSG_LASTORDERLISTGET:
   case dap_regionselectionfi_tclToken::EN_MSG_LASTORDERLISTSTATUS:
   case dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSGET:
   case dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSUPREG:
   case dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSRELUPREG:
   case dap_regionselectionfi_tclToken::EN_MSG_STORAGEPROGRESSSTATUS:
   case dap_regionselectionfi_tclToken::EN_MSG_GETLINKDEVICEGET:
   case dap_regionselectionfi_tclToken::EN_MSG_GETLINKDEVICESTATUS:
   case dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case dap_regionselectionfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case dap_regionselectionfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_END_OF_STRUCT,dap_regionselectionfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U8,dap_regionselectionfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_LIST,dap_regionselectionfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_regionselectionfi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_regionselectionfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_regionselectionfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_regionselectionfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_END_OF_STRUCT,dap_regionselectionfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_S32_LATITUDE,dap_regionselectionfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_S32_LONGITUDE,dap_regionselectionfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_regionselectionfi_tclToken::EN_E8_STORAGEMODE:
   {
      fi_tcl_e8_StorageMode o_e8_StorageMode;
      if (!bDoIt(o_e8_StorageMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_regionselectionfi_tclToken::EN_E8_RESUMETYPE:
   {
      fi_tcl_e8_ResumeType o_e8_ResumeType;
      if (!bDoIt(o_e8_ResumeType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_regionselectionfi_tclToken::EN_E8_STORESTATUS:
   {
      fi_tcl_e8_StoreStatus o_e8_StoreStatus;
      if (!bDoIt(o_e8_StoreStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_regionselectionfi_tclToken::EN_E8_PROGRESSSTATUS:
   {
      fi_tcl_e8_ProgressStatus o_e8_ProgressStatus;
      if (!bDoIt(o_e8_ProgressStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_regionselectionfi_tclToken::EN_REGIONINFO:
   {
      if (poVisitor->bDoExpand_RegionInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_END_OF_STRUCT,dap_regionselectionfi_tclSemanticDomain::EN_UNKNOWN));
         if (1 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_E8_STORAGEMODE,dap_regionselectionfi_tclSemanticDomain::EN_STORESTATUS));
         }
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U32,dap_regionselectionfi_tclSemanticDomain::EN_CREATIONDATE));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_MULTILANGUAGESTRING,dap_regionselectionfi_tclSemanticDomain::EN_REGIONNAME));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_NEEDEDSLOTS));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U32,dap_regionselectionfi_tclSemanticDomain::EN_SIZE));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_REGIONPROFILEID));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_REGIONCODEID));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_REGIONNUMBER));
      }
      else
      {
         fi_tcl_RegionInfo o_RegionInfo;
         if (!bDoIt(o_RegionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_regionselectionfi_tclToken::EN_REGIONNUMBERORDER:
   {
      if (poVisitor->bDoExpand_RegionNumberOrder(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_END_OF_STRUCT,dap_regionselectionfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_E8_STORAGEMODE,dap_regionselectionfi_tclSemanticDomain::EN_ENSTORAGEMODE));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_REGIONNUMBER));
      }
      else
      {
         fi_tcl_RegionNumberOrder o_RegionNumberOrder;
         if (!bDoIt(o_RegionNumberOrder))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionNumberOrder.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionNumberOrder.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_regionselectionfi_tclToken::EN_REGIONNUMBERRESULT:
   {
      if (poVisitor->bDoExpand_RegionNumberResult(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_END_OF_STRUCT,dap_regionselectionfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_ERROR));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_REGIONNUMBER));
      }
      else
      {
         fi_tcl_RegionNumberResult o_RegionNumberResult;
         if (!bDoIt(o_RegionNumberResult))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionNumberResult.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionNumberResult.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_regionselectionfi_tclToken::EN_ORDERINFO:
   {
      if (poVisitor->bDoExpand_OrderInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_END_OF_STRUCT,dap_regionselectionfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_E8_STORESTATUS,dap_regionselectionfi_tclSemanticDomain::EN_STORESTATUS));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_REGIONINFO,dap_regionselectionfi_tclSemanticDomain::EN_REGIONINFO));
      }
      else
      {
         fi_tcl_OrderInfo o_OrderInfo;
         if (!bDoIt(o_OrderInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OrderInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OrderInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_regionselectionfi_tclToken::EN_REGIONOUTLINE:
   {
      if (poVisitor->bDoExpand_RegionOutline(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_END_OF_STRUCT,dap_regionselectionfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_POSITIONWGS84,dap_regionselectionfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_LIST,dap_regionselectionfi_tclSemanticDomain::EN_OUTLINE));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_E8_STORAGEMODE,dap_regionselectionfi_tclSemanticDomain::EN_STORESTATUS));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U32,dap_regionselectionfi_tclSemanticDomain::EN_CREATIONDATE));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_REGIONPROFILEID));
         oPath.bGoDown(dap_regionselectionfi_tclKnot(dap_regionselectionfi_tclToken::EN_U16,dap_regionselectionfi_tclSemanticDomain::EN_REGIONCODEID));
      }
      else
      {
         fi_tcl_RegionOutline o_RegionOutline;
         if (!bDoIt(o_RegionOutline))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionOutline.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionOutline.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case dap_regionselectionfi_tclToken::EN_UNKNOWN:
      case dap_regionselectionfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

