#include "precompiled.hh"

tBool dap_rawdatafi_tclDescription::bInitMessage(dap_rawdatafi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case dap_rawdatafi_tclToken::EN_LAST_TOKEN:
   case dap_rawdatafi_tclToken::EN_LIST:
   case dap_rawdatafi_tclToken::EN_END_OF_STRUCT:
   case dap_rawdatafi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FILESIZEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZFILENAME));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZPATH));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPORDERTYPE,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FILESIZEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32FILESIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZFILENAME));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZPATH));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_READBLOCKMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_DATABLOCKSTARTINFO,dap_rawdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_LIST,dap_rawdatafi_tclSemanticDomain::EN_MSG_AODATABLOCKINFO));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPORDERTYPE,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_READBLOCKMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_DATABLOCKRESULTINFO,dap_rawdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_LIST,dap_rawdatafi_tclSemanticDomain::EN_MSG_AODATABLOCKINFO));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_DIRECTORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZSHAREDMEMORY));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U16,dap_rawdatafi_tclSemanticDomain::EN_MSG_U16FIRSTENTRY));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MAXRESULTSIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZMASK));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZPATH));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPORDERTYPE,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_DIRECTORYMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZSHAREDMEMORY));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_BOOL,dap_rawdatafi_tclSemanticDomain::EN_MSG_BCOMPLETE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U16,dap_rawdatafi_tclSemanticDomain::EN_MSG_U16LASTENTRY));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32REALRESULTSIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZMASK));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZPATH));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_MEDIASPACEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZDEVICE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPORDERTYPE,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_MEDIASPACEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIASPACEHIGH));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIASPACELOW));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZDEVICE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FREEMEDIASPACEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZDEVICE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPORDERTYPE,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FREEMEDIASPACEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIASPACEHIGH));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIASPACELOW));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_MSG_SZDEVICE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32MEDIAID));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_MSG_U32DATASIZE));
      bResult &= oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET,dap_rawdatafi_tclSemanticDomain::EN_MSG_U8PRIORITY));
   } break;
   case dap_rawdatafi_tclToken::EN_BINCONTAINER:
   case dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET:
   case dap_rawdatafi_tclToken::EN_E8_DAPORDERTYPE:
   case dap_rawdatafi_tclToken::EN_DATABLOCKSTARTINFO:
   case dap_rawdatafi_tclToken::EN_DATABLOCKRESULTINFO:
   case dap_rawdatafi_tclToken::EN_U8:   
   case dap_rawdatafi_tclToken::EN_S8:   
   case dap_rawdatafi_tclToken::EN_U16:   
   case dap_rawdatafi_tclToken::EN_S16:   
   case dap_rawdatafi_tclToken::EN_U24:   
   case dap_rawdatafi_tclToken::EN_S24:   
   case dap_rawdatafi_tclToken::EN_U32:   
   case dap_rawdatafi_tclToken::EN_S32:   
   case dap_rawdatafi_tclToken::EN_U64:   
   case dap_rawdatafi_tclToken::EN_S64:   
   case dap_rawdatafi_tclToken::EN_F32:   
   case dap_rawdatafi_tclToken::EN_F64:   
   case dap_rawdatafi_tclToken::EN_BOOL:   
   case dap_rawdatafi_tclToken::EN_STRING:   
   case dap_rawdatafi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(dap_rawdatafi_tclKnot(enMsgToken,dap_rawdatafi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool dap_rawdatafi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool dap_rawdatafi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      dap_rawdatafi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      dap_rawdatafi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      dap_rawdatafi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == dap_rawdatafi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(dap_rawdatafi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(dap_rawdatafi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(dap_rawdatafi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case dap_rawdatafi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == dap_rawdatafi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_rawdatafi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_rawdatafi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_rawdatafi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_rawdatafi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case dap_rawdatafi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case dap_rawdatafi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_rawdatafi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FILESIZEMETHODSTART:
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FILESIZEMETHODRESULT:
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_READBLOCKMETHODSTART:
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_READBLOCKMETHODRESULT:
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_DIRECTORYMETHODSTART:
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_DIRECTORYMETHODRESULT:
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_MEDIASPACEMETHODSTART:
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_MEDIASPACEMETHODRESULT:
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FREEMEDIASPACEMETHODSTART:
   case dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FREEMEDIASPACEMETHODRESULT:
      bInitMessage(enToken);
      break;
   case dap_rawdatafi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_END_OF_STRUCT,dap_rawdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U8,dap_rawdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_LIST,dap_rawdatafi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rawdatafi_tclToken::EN_E8_DAPPRIORITAET:
   {
      fi_tcl_e8_DapPrioritaet o_e8_DapPrioritaet;
      if (!bDoIt(o_e8_DapPrioritaet))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rawdatafi_tclToken::EN_E8_DAPORDERTYPE:
   {
      fi_tcl_e8_DapOrderType o_e8_DapOrderType;
      if (!bDoIt(o_e8_DapOrderType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_rawdatafi_tclToken::EN_DATABLOCKSTARTINFO:
   {
      if (poVisitor->bDoExpand_DataBlockStartInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_END_OF_STRUCT,dap_rawdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_SZFILENAME));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_SZPATH));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_SZSHAREDMEMORY));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_U32SIZE));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_U32OFFSET));
      }
      else
      {
         fi_tcl_DataBlockStartInfo o_DataBlockStartInfo;
         if (!bDoIt(o_DataBlockStartInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataBlockStartInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataBlockStartInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_rawdatafi_tclToken::EN_DATABLOCKRESULTINFO:
   {
      if (poVisitor->bDoExpand_DataBlockResultInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_END_OF_STRUCT,dap_rawdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_SZFILENAME));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_SZPATH));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_STRING,dap_rawdatafi_tclSemanticDomain::EN_SZSHAREDMEMORY));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U16,dap_rawdatafi_tclSemanticDomain::EN_U16ERRORCODE));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_U32SIZE));
         oPath.bGoDown(dap_rawdatafi_tclKnot(dap_rawdatafi_tclToken::EN_U32,dap_rawdatafi_tclSemanticDomain::EN_U32OFFSET));
      }
      else
      {
         fi_tcl_DataBlockResultInfo o_DataBlockResultInfo;
         if (!bDoIt(o_DataBlockResultInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataBlockResultInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataBlockResultInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case dap_rawdatafi_tclToken::EN_UNKNOWN:
      case dap_rawdatafi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

