/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::dap_poifi_tclMsgGetPOIDataByOutlineMethodStart(const dap_poifi_tclMsgGetPOIDataByOutlineMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   OrderType = coRef.OrderType;
   UILanguage = coRef.UILanguage;
   POITypes = coRef.POITypes;
   CategoryFilter = coRef.CategoryFilter;
   Outlines = coRef.Outlines;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodStart& dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodStart& coRef)
{
   if (this == &coRef) return *this;
   OrderType = coRef.OrderType;
   UILanguage = coRef.UILanguage;
   POITypes = coRef.POITypes;
   CategoryFilter = coRef.CategoryFilter;
   Outlines = coRef.Outlines;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYOUTLINE;}
tU8 dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::vDestroy()
{
   CategoryFilter.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < Outlines.size(); ++u32Idx)
         Outlines[u32Idx].vDestroy();
   }
   Outlines.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Outlines.size(); ++u32ListIdx)
      u32DynamicSize += Outlines[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13+CategoryFilter.size()*2;
}

tBool dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OrderType == rfoCmp.OrderType);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (POITypes == rfoCmp.POITypes);
      bResult = bResult && (CategoryFilter.size() == rfoCmp.CategoryFilter.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CategoryFilter.size()); ++u32Idx)
            bResult = bResult && (CategoryFilter[u32Idx] == rfoCmp.CategoryFilter[u32Idx]);
      }
      bResult = bResult && (Outlines.size() == rfoCmp.Outlines.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Outlines.size()); ++u32Idx)
            bResult = bResult && (Outlines[u32Idx] == rfoCmp.Outlines[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> OrderType;
   oIn >> UILanguage;
   oIn >> POITypes;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CategoryFilter.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CategoryFilter[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Outlines.size(); ++u32Idx)
      {
         Outlines[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Outlines.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Outlines[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OrderType;
   oOut << UILanguage;
   oOut << POITypes;
   oOut << (tU32)CategoryFilter.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CategoryFilter.size(); ++u32Idx)
         oOut << CategoryFilter[u32Idx];
   }
   oOut << (tU32)Outlines.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Outlines.size(); ++u32Idx)
         oOut << Outlines[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::dap_poifi_tclMsgGetPOIDataByOutlineMethodResult(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   OutlineIndices = coRef.OutlineIndices;
   CountElementsPerOutline = coRef.CountElementsPerOutline;
   ElementList = coRef.ElementList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodResult& dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   OutlineIndices = coRef.OutlineIndices;
   CountElementsPerOutline = coRef.CountElementsPerOutline;
   ElementList = coRef.ElementList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYOUTLINE;}
tU8 dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::vDestroy()
{
   OutlineIndices.clear();
   CountElementsPerOutline.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
         ElementList[u32Idx].vDestroy();
   }
   ElementList.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ElementList.size(); ++u32ListIdx)
      u32DynamicSize += ElementList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14+OutlineIndices.size()*4+CountElementsPerOutline.size()*4;
}

tBool dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (OutlineIndices.size() == rfoCmp.OutlineIndices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OutlineIndices.size()); ++u32Idx)
            bResult = bResult && (OutlineIndices[u32Idx] == rfoCmp.OutlineIndices[u32Idx]);
      }
      bResult = bResult && (CountElementsPerOutline.size() == rfoCmp.CountElementsPerOutline.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountElementsPerOutline.size()); ++u32Idx)
            bResult = bResult && (CountElementsPerOutline[u32Idx] == rfoCmp.CountElementsPerOutline[u32Idx]);
      }
      bResult = bResult && (ElementList.size() == rfoCmp.ElementList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementList.size()); ++u32Idx)
            bResult = bResult && (ElementList[u32Idx] == rfoCmp.ElementList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      OutlineIndices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OutlineIndices[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CountElementsPerOutline.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CountElementsPerOutline[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
      {
         ElementList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ElementList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)OutlineIndices.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OutlineIndices.size(); ++u32Idx)
         oOut << OutlineIndices[u32Idx];
   }
   oOut << (tU32)CountElementsPerOutline.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CountElementsPerOutline.size(); ++u32Idx)
         oOut << CountElementsPerOutline[u32Idx];
   }
   oOut << (tU32)ElementList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
         oOut << ElementList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   OutlineIndices = coRef.OutlineIndices;
   CountElementsPerOutline = coRef.CountElementsPerOutline;
   ElementList = coRef.ElementList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst& dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   OutlineIndices = coRef.OutlineIndices;
   CountElementsPerOutline = coRef.CountElementsPerOutline;
   ElementList = coRef.ElementList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYOUTLINE;}
tU8 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTFIRST;}

tVoid dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::vDestroy()
{
   OutlineIndices.clear();
   CountElementsPerOutline.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
         ElementList[u32Idx].vDestroy();
   }
   ElementList.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ElementList.size(); ++u32ListIdx)
      u32DynamicSize += ElementList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14+OutlineIndices.size()*4+CountElementsPerOutline.size()*4;
}

tBool dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (OutlineIndices.size() == rfoCmp.OutlineIndices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OutlineIndices.size()); ++u32Idx)
            bResult = bResult && (OutlineIndices[u32Idx] == rfoCmp.OutlineIndices[u32Idx]);
      }
      bResult = bResult && (CountElementsPerOutline.size() == rfoCmp.CountElementsPerOutline.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountElementsPerOutline.size()); ++u32Idx)
            bResult = bResult && (CountElementsPerOutline[u32Idx] == rfoCmp.CountElementsPerOutline[u32Idx]);
      }
      bResult = bResult && (ElementList.size() == rfoCmp.ElementList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementList.size()); ++u32Idx)
            bResult = bResult && (ElementList[u32Idx] == rfoCmp.ElementList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      OutlineIndices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OutlineIndices[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CountElementsPerOutline.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CountElementsPerOutline[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
      {
         ElementList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ElementList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)OutlineIndices.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OutlineIndices.size(); ++u32Idx)
         oOut << OutlineIndices[u32Idx];
   }
   oOut << (tU32)CountElementsPerOutline.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CountElementsPerOutline.size(); ++u32Idx)
         oOut << CountElementsPerOutline[u32Idx];
   }
   oOut << (tU32)ElementList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
         oOut << ElementList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle& coRef):fi_tclVisitableTypeBase(coRef)
{
   OutlineIndices = coRef.OutlineIndices;
   CountElementsPerOutline = coRef.CountElementsPerOutline;
   ElementList = coRef.ElementList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle& dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   OutlineIndices = coRef.OutlineIndices;
   CountElementsPerOutline = coRef.CountElementsPerOutline;
   ElementList = coRef.ElementList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYOUTLINE;}
tU8 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTMIDDLE;}

tVoid dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::vDestroy()
{
   OutlineIndices.clear();
   CountElementsPerOutline.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
         ElementList[u32Idx].vDestroy();
   }
   ElementList.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ElementList.size(); ++u32ListIdx)
      u32DynamicSize += ElementList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+OutlineIndices.size()*4+CountElementsPerOutline.size()*4;
}

tBool dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OutlineIndices.size() == rfoCmp.OutlineIndices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OutlineIndices.size()); ++u32Idx)
            bResult = bResult && (OutlineIndices[u32Idx] == rfoCmp.OutlineIndices[u32Idx]);
      }
      bResult = bResult && (CountElementsPerOutline.size() == rfoCmp.CountElementsPerOutline.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountElementsPerOutline.size()); ++u32Idx)
            bResult = bResult && (CountElementsPerOutline[u32Idx] == rfoCmp.CountElementsPerOutline[u32Idx]);
      }
      bResult = bResult && (ElementList.size() == rfoCmp.ElementList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementList.size()); ++u32Idx)
            bResult = bResult && (ElementList[u32Idx] == rfoCmp.ElementList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      OutlineIndices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OutlineIndices[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CountElementsPerOutline.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CountElementsPerOutline[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
      {
         ElementList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ElementList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OutlineIndices.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OutlineIndices.size(); ++u32Idx)
         oOut << OutlineIndices[u32Idx];
   }
   oOut << (tU32)CountElementsPerOutline.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CountElementsPerOutline.size(); ++u32Idx)
         oOut << CountElementsPerOutline[u32Idx];
   }
   oOut << (tU32)ElementList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
         oOut << ElementList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast& coRef):fi_tclVisitableTypeBase(coRef)
{
   OutlineIndices = coRef.OutlineIndices;
   CountElementsPerOutline = coRef.CountElementsPerOutline;
   ElementList = coRef.ElementList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast& dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   OutlineIndices = coRef.OutlineIndices;
   CountElementsPerOutline = coRef.CountElementsPerOutline;
   ElementList = coRef.ElementList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYOUTLINE;}
tU8 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTLAST;}

tVoid dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::vDestroy()
{
   OutlineIndices.clear();
   CountElementsPerOutline.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
         ElementList[u32Idx].vDestroy();
   }
   ElementList.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ElementList.size(); ++u32ListIdx)
      u32DynamicSize += ElementList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+OutlineIndices.size()*4+CountElementsPerOutline.size()*4;
}

tBool dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OutlineIndices.size() == rfoCmp.OutlineIndices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OutlineIndices.size()); ++u32Idx)
            bResult = bResult && (OutlineIndices[u32Idx] == rfoCmp.OutlineIndices[u32Idx]);
      }
      bResult = bResult && (CountElementsPerOutline.size() == rfoCmp.CountElementsPerOutline.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountElementsPerOutline.size()); ++u32Idx)
            bResult = bResult && (CountElementsPerOutline[u32Idx] == rfoCmp.CountElementsPerOutline[u32Idx]);
      }
      bResult = bResult && (ElementList.size() == rfoCmp.ElementList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementList.size()); ++u32Idx)
            bResult = bResult && (ElementList[u32Idx] == rfoCmp.ElementList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      OutlineIndices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OutlineIndices[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CountElementsPerOutline.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CountElementsPerOutline[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
      {
         ElementList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ElementList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)OutlineIndices.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OutlineIndices.size(); ++u32Idx)
         oOut << OutlineIndices[u32Idx];
   }
   oOut << (tU32)CountElementsPerOutline.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CountElementsPerOutline.size(); ++u32Idx)
         oOut << CountElementsPerOutline[u32Idx];
   }
   oOut << (tU32)ElementList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementList.size(); ++u32Idx)
         oOut << ElementList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   OrderType = coRef.OrderType;
   POITypes = coRef.POITypes;
   CategoryFilter = coRef.CategoryFilter;
   Handle = coRef.Handle;
   SharedMemOffset = coRef.SharedMemOffset;
   SharedMemMaxSize = coRef.SharedMemMaxSize;
   UseStreaming = coRef.UseStreaming;
   TileIDs = coRef.TileIDs;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart& dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   OrderType = coRef.OrderType;
   POITypes = coRef.POITypes;
   CategoryFilter = coRef.CategoryFilter;
   Handle = coRef.Handle;
   SharedMemOffset = coRef.SharedMemOffset;
   SharedMemMaxSize = coRef.SharedMemMaxSize;
   UseStreaming = coRef.UseStreaming;
   TileIDs = coRef.TileIDs;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYTILEIDS;}
tU8 dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::vDestroy()
{
   CategoryFilter.clear();
   TileIDs.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 22+CategoryFilter.size()*2+TileIDs.size()*4;
}

tBool dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OrderType == rfoCmp.OrderType);
      bResult = bResult && (POITypes == rfoCmp.POITypes);
      bResult = bResult && (CategoryFilter.size() == rfoCmp.CategoryFilter.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CategoryFilter.size()); ++u32Idx)
            bResult = bResult && (CategoryFilter[u32Idx] == rfoCmp.CategoryFilter[u32Idx]);
      }
      bResult = bResult && (Handle == rfoCmp.Handle);
      bResult = bResult && (SharedMemOffset == rfoCmp.SharedMemOffset);
      bResult = bResult && (SharedMemMaxSize == rfoCmp.SharedMemMaxSize);
      bResult = bResult && (UseStreaming == rfoCmp.UseStreaming);
      bResult = bResult && (TileIDs.size() == rfoCmp.TileIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TileIDs.size()); ++u32Idx)
            bResult = bResult && (TileIDs[u32Idx] == rfoCmp.TileIDs[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> OrderType;
   oIn >> POITypes;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CategoryFilter.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CategoryFilter[u32Idx];
      }
   }
   oIn >> Handle;
   oIn >> SharedMemOffset;
   oIn >> SharedMemMaxSize;
   oIn >> UseStreaming;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      TileIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TileIDs[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OrderType;
   oOut << POITypes;
   oOut << (tU32)CategoryFilter.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CategoryFilter.size(); ++u32Idx)
         oOut << CategoryFilter[u32Idx];
   }
   oOut << Handle;
   oOut << SharedMemOffset;
   oOut << SharedMemMaxSize;
   oOut << UseStreaming;
   oOut << (tU32)TileIDs.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TileIDs.size(); ++u32Idx)
         oOut << TileIDs[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYTILEIDS;}
tU8 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         ResultBlocks[u32Idx].vDestroy();
   }
   ResultBlocks.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ResultBlocks.size()*16;
}

tBool dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Size == rfoCmp.Size);
      bResult = bResult && (ResultBlocks.size() == rfoCmp.ResultBlocks.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ResultBlocks.size()); ++u32Idx)
            bResult = bResult && (ResultBlocks[u32Idx] == rfoCmp.ResultBlocks[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Size;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
      {
         ResultBlocks[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ResultBlocks.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ResultBlocks[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Size;
   oOut << (tU32)ResultBlocks.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         oOut << ResultBlocks[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst& coRef):fi_tclVisitableTypeBase(coRef)
{
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYTILEIDS;}
tU8 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTFIRST;}

tVoid dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         ResultBlocks[u32Idx].vDestroy();
   }
   ResultBlocks.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ResultBlocks.size()*16;
}

tBool dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Size == rfoCmp.Size);
      bResult = bResult && (ResultBlocks.size() == rfoCmp.ResultBlocks.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ResultBlocks.size()); ++u32Idx)
            bResult = bResult && (ResultBlocks[u32Idx] == rfoCmp.ResultBlocks[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   oIn >> Size;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
      {
         ResultBlocks[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ResultBlocks.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ResultBlocks[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Size;
   oOut << (tU32)ResultBlocks.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         oOut << ResultBlocks[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle& coRef):fi_tclVisitableTypeBase(coRef)
{
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYTILEIDS;}
tU8 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTMIDDLE;}

tVoid dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         ResultBlocks[u32Idx].vDestroy();
   }
   ResultBlocks.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ResultBlocks.size()*16;
}

tBool dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Size == rfoCmp.Size);
      bResult = bResult && (ResultBlocks.size() == rfoCmp.ResultBlocks.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ResultBlocks.size()); ++u32Idx)
            bResult = bResult && (ResultBlocks[u32Idx] == rfoCmp.ResultBlocks[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   oIn >> Size;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
      {
         ResultBlocks[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ResultBlocks.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ResultBlocks[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Size;
   oOut << (tU32)ResultBlocks.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         oOut << ResultBlocks[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast& coRef):fi_tclVisitableTypeBase(coRef)
{
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   Size = coRef.Size;
   ResultBlocks = coRef.ResultBlocks;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETPOIDATABYTILEIDS;}
tU8 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTLAST;}

tVoid dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         ResultBlocks[u32Idx].vDestroy();
   }
   ResultBlocks.clear();
}

tU32 dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ResultBlocks.size()*16;
}

tBool dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Size == rfoCmp.Size);
      bResult = bResult && (ResultBlocks.size() == rfoCmp.ResultBlocks.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ResultBlocks.size()); ++u32Idx)
            bResult = bResult && (ResultBlocks[u32Idx] == rfoCmp.ResultBlocks[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::oRead(fi_tclInContext& oIn)
{
   oIn >> Size;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
      {
         ResultBlocks[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ResultBlocks.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ResultBlocks[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Size;
   oOut << (tU32)ResultBlocks.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlocks.size(); ++u32Idx)
         oOut << ResultBlocks[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgOpenFastMapChannelMethodStart::dap_poifi_tclMsgOpenFastMapChannelMethodStart(const dap_poifi_tclMsgOpenFastMapChannelMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   ChannelName = coRef.ChannelName;
   ChannelSize = coRef.ChannelSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgOpenFastMapChannelMethodStart& dap_poifi_tclMsgOpenFastMapChannelMethodStart::operator=(const dap_poifi_tclMsgOpenFastMapChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   ChannelName = coRef.ChannelName;
   ChannelSize = coRef.ChannelSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgOpenFastMapChannelMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgOpenFastMapChannelMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_OPENFASTMAPCHANNEL;}
tU8 dap_poifi_tclMsgOpenFastMapChannelMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgOpenFastMapChannelMethodStart::vDestroy()
{
   ChannelName.vDestroy();
}

tU32 dap_poifi_tclMsgOpenFastMapChannelMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+ChannelName.u32GetSize(u16MajorVersion);
}

tBool dap_poifi_tclMsgOpenFastMapChannelMethodStart::operator==(const dap_poifi_tclMsgOpenFastMapChannelMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MajorVersion == rfoCmp.MajorVersion);
      bResult = bResult && (MinorVersion == rfoCmp.MinorVersion);
      bResult = bResult && (ChannelName == rfoCmp.ChannelName);
      bResult = bResult && (ChannelSize == rfoCmp.ChannelSize);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgOpenFastMapChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> MajorVersion;
   oIn >> MinorVersion;
   oIn >> ChannelName;
   oIn >> ChannelSize;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgOpenFastMapChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MajorVersion;
   oOut << MinorVersion;
   oOut << ChannelName;
   oOut << ChannelSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgOpenFastMapChannelMethodResult::dap_poifi_tclMsgOpenFastMapChannelMethodResult(const dap_poifi_tclMsgOpenFastMapChannelMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Handle = coRef.Handle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgOpenFastMapChannelMethodResult& dap_poifi_tclMsgOpenFastMapChannelMethodResult::operator=(const dap_poifi_tclMsgOpenFastMapChannelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Handle = coRef.Handle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgOpenFastMapChannelMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgOpenFastMapChannelMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_OPENFASTMAPCHANNEL;}
tU8 dap_poifi_tclMsgOpenFastMapChannelMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_poifi_tclMsgOpenFastMapChannelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool dap_poifi_tclMsgOpenFastMapChannelMethodResult::operator==(const dap_poifi_tclMsgOpenFastMapChannelMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Handle == rfoCmp.Handle);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgOpenFastMapChannelMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Handle;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgOpenFastMapChannelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Handle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCloseFastMapChannelMethodStart::dap_poifi_tclMsgCloseFastMapChannelMethodStart(const dap_poifi_tclMsgCloseFastMapChannelMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Handle = coRef.Handle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCloseFastMapChannelMethodStart& dap_poifi_tclMsgCloseFastMapChannelMethodStart::operator=(const dap_poifi_tclMsgCloseFastMapChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Handle = coRef.Handle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgCloseFastMapChannelMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgCloseFastMapChannelMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_CLOSEFASTMAPCHANNEL;}
tU8 dap_poifi_tclMsgCloseFastMapChannelMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_poifi_tclMsgCloseFastMapChannelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool dap_poifi_tclMsgCloseFastMapChannelMethodStart::operator==(const dap_poifi_tclMsgCloseFastMapChannelMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Handle == rfoCmp.Handle);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgCloseFastMapChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Handle;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgCloseFastMapChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Handle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCloseFastMapChannelMethodResult::dap_poifi_tclMsgCloseFastMapChannelMethodResult(const dap_poifi_tclMsgCloseFastMapChannelMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCloseFastMapChannelMethodResult& dap_poifi_tclMsgCloseFastMapChannelMethodResult::operator=(const dap_poifi_tclMsgCloseFastMapChannelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgCloseFastMapChannelMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgCloseFastMapChannelMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_CLOSEFASTMAPCHANNEL;}
tU8 dap_poifi_tclMsgCloseFastMapChannelMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_poifi_tclMsgCloseFastMapChannelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgCloseFastMapChannelMethodResult::operator==(const dap_poifi_tclMsgCloseFastMapChannelMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgCloseFastMapChannelMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgCloseFastMapChannelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAddPOIsMethodStart::dap_poifi_tclMsgAddPOIsMethodStart(const dap_poifi_tclMsgAddPOIsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   POIType = coRef.POIType;
   POIs = coRef.POIs;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAddPOIsMethodStart& dap_poifi_tclMsgAddPOIsMethodStart::operator=(const dap_poifi_tclMsgAddPOIsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   POIType = coRef.POIType;
   POIs = coRef.POIs;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgAddPOIsMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgAddPOIsMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_ADDPOIS;}
tU8 dap_poifi_tclMsgAddPOIsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgAddPOIsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < POIs.size(); ++u32Idx)
         POIs[u32Idx].vDestroy();
   }
   POIs.clear();
}

tU32 dap_poifi_tclMsgAddPOIsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < POIs.size(); ++u32ListIdx)
      u32DynamicSize += POIs[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool dap_poifi_tclMsgAddPOIsMethodStart::operator==(const dap_poifi_tclMsgAddPOIsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (POIType == rfoCmp.POIType);
      bResult = bResult && (POIs.size() == rfoCmp.POIs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < POIs.size()); ++u32Idx)
            bResult = bResult && (POIs[u32Idx] == rfoCmp.POIs[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgAddPOIsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> POIType;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < POIs.size(); ++u32Idx)
      {
         POIs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      POIs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> POIs[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgAddPOIsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << POIType;
   oOut << (tU32)POIs.size();
   {
      for (tU32 u32Idx = 0; u32Idx < POIs.size(); ++u32Idx)
         oOut << POIs[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAddPOIsMethodResult::dap_poifi_tclMsgAddPOIsMethodResult(const dap_poifi_tclMsgAddPOIsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UniqueIDs = coRef.UniqueIDs;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAddPOIsMethodResult& dap_poifi_tclMsgAddPOIsMethodResult::operator=(const dap_poifi_tclMsgAddPOIsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UniqueIDs = coRef.UniqueIDs;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgAddPOIsMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgAddPOIsMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_ADDPOIS;}
tU8 dap_poifi_tclMsgAddPOIsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_poifi_tclMsgAddPOIsMethodResult::vDestroy()
{
   UniqueIDs.clear();
}

tU32 dap_poifi_tclMsgAddPOIsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+UniqueIDs.size()*4;
}

tBool dap_poifi_tclMsgAddPOIsMethodResult::operator==(const dap_poifi_tclMsgAddPOIsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UniqueIDs.size() == rfoCmp.UniqueIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UniqueIDs.size()); ++u32Idx)
            bResult = bResult && (UniqueIDs[u32Idx] == rfoCmp.UniqueIDs[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgAddPOIsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      UniqueIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UniqueIDs[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgAddPOIsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)UniqueIDs.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UniqueIDs.size(); ++u32Idx)
         oOut << UniqueIDs[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeletePOIsMethodStart::dap_poifi_tclMsgDeletePOIsMethodStart(const dap_poifi_tclMsgDeletePOIsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   POIType = coRef.POIType;
   UniqueIDs = coRef.UniqueIDs;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeletePOIsMethodStart& dap_poifi_tclMsgDeletePOIsMethodStart::operator=(const dap_poifi_tclMsgDeletePOIsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   POIType = coRef.POIType;
   UniqueIDs = coRef.UniqueIDs;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgDeletePOIsMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgDeletePOIsMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_DELETEPOIS;}
tU8 dap_poifi_tclMsgDeletePOIsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgDeletePOIsMethodStart::vDestroy()
{
   UniqueIDs.clear();
}

tU32 dap_poifi_tclMsgDeletePOIsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+UniqueIDs.size()*4;
}

tBool dap_poifi_tclMsgDeletePOIsMethodStart::operator==(const dap_poifi_tclMsgDeletePOIsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (POIType == rfoCmp.POIType);
      bResult = bResult && (UniqueIDs.size() == rfoCmp.UniqueIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UniqueIDs.size()); ++u32Idx)
            bResult = bResult && (UniqueIDs[u32Idx] == rfoCmp.UniqueIDs[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgDeletePOIsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> POIType;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      UniqueIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UniqueIDs[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgDeletePOIsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << POIType;
   oOut << (tU32)UniqueIDs.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UniqueIDs.size(); ++u32Idx)
         oOut << UniqueIDs[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeletePOIsMethodResult::dap_poifi_tclMsgDeletePOIsMethodResult(const dap_poifi_tclMsgDeletePOIsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeletePOIsMethodResult& dap_poifi_tclMsgDeletePOIsMethodResult::operator=(const dap_poifi_tclMsgDeletePOIsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgDeletePOIsMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgDeletePOIsMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_DELETEPOIS;}
tU8 dap_poifi_tclMsgDeletePOIsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_poifi_tclMsgDeletePOIsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgDeletePOIsMethodResult::operator==(const dap_poifi_tclMsgDeletePOIsMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgDeletePOIsMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgDeletePOIsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeleteAllPOIsMethodStart::dap_poifi_tclMsgDeleteAllPOIsMethodStart(const dap_poifi_tclMsgDeleteAllPOIsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   POIType = coRef.POIType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeleteAllPOIsMethodStart& dap_poifi_tclMsgDeleteAllPOIsMethodStart::operator=(const dap_poifi_tclMsgDeleteAllPOIsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   POIType = coRef.POIType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgDeleteAllPOIsMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgDeleteAllPOIsMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_DELETEALLPOIS;}
tU8 dap_poifi_tclMsgDeleteAllPOIsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_poifi_tclMsgDeleteAllPOIsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool dap_poifi_tclMsgDeleteAllPOIsMethodStart::operator==(const dap_poifi_tclMsgDeleteAllPOIsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (POIType == rfoCmp.POIType);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgDeleteAllPOIsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> POIType;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgDeleteAllPOIsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << POIType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeleteAllPOIsMethodResult::dap_poifi_tclMsgDeleteAllPOIsMethodResult(const dap_poifi_tclMsgDeleteAllPOIsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeleteAllPOIsMethodResult& dap_poifi_tclMsgDeleteAllPOIsMethodResult::operator=(const dap_poifi_tclMsgDeleteAllPOIsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgDeleteAllPOIsMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgDeleteAllPOIsMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_DELETEALLPOIS;}
tU8 dap_poifi_tclMsgDeleteAllPOIsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_poifi_tclMsgDeleteAllPOIsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgDeleteAllPOIsMethodResult::operator==(const dap_poifi_tclMsgDeleteAllPOIsMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgDeleteAllPOIsMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgDeleteAllPOIsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportUPOIsMethodStart::dap_poifi_tclMsgImportUPOIsMethodStart(const dap_poifi_tclMsgImportUPOIsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   OrderType = coRef.OrderType;
   SourcePath = coRef.SourcePath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportUPOIsMethodStart& dap_poifi_tclMsgImportUPOIsMethodStart::operator=(const dap_poifi_tclMsgImportUPOIsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   OrderType = coRef.OrderType;
   SourcePath = coRef.SourcePath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportUPOIsMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportUPOIsMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTUPOIS;}
tU8 dap_poifi_tclMsgImportUPOIsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgImportUPOIsMethodStart::vDestroy()
{
   SourcePath.vDestroy();
}

tU32 dap_poifi_tclMsgImportUPOIsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+SourcePath.u32GetSize(u16MajorVersion);
}

tBool dap_poifi_tclMsgImportUPOIsMethodStart::operator==(const dap_poifi_tclMsgImportUPOIsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OrderType == rfoCmp.OrderType);
      bResult = bResult && (SourcePath == rfoCmp.SourcePath);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportUPOIsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> OrderType;
   oIn >> SourcePath;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportUPOIsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OrderType;
   oOut << SourcePath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportUPOIsMethodResult::dap_poifi_tclMsgImportUPOIsMethodResult(const dap_poifi_tclMsgImportUPOIsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NumOfIgnoredFiles = coRef.NumOfIgnoredFiles;
   NumOfIgnoredPOIs = coRef.NumOfIgnoredPOIs;
   FirstErrorFileName = coRef.FirstErrorFileName;
   FirstErrorLineNumber = coRef.FirstErrorLineNumber;
   NumOfImportedPOIs = coRef.NumOfImportedPOIs;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportUPOIsMethodResult& dap_poifi_tclMsgImportUPOIsMethodResult::operator=(const dap_poifi_tclMsgImportUPOIsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NumOfIgnoredFiles = coRef.NumOfIgnoredFiles;
   NumOfIgnoredPOIs = coRef.NumOfIgnoredPOIs;
   FirstErrorFileName = coRef.FirstErrorFileName;
   FirstErrorLineNumber = coRef.FirstErrorLineNumber;
   NumOfImportedPOIs = coRef.NumOfImportedPOIs;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportUPOIsMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportUPOIsMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTUPOIS;}
tU8 dap_poifi_tclMsgImportUPOIsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_poifi_tclMsgImportUPOIsMethodResult::vDestroy()
{
   FirstErrorFileName.vDestroy();
}

tU32 dap_poifi_tclMsgImportUPOIsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+12+FirstErrorFileName.u32GetSize(u16MajorVersion);
}

tBool dap_poifi_tclMsgImportUPOIsMethodResult::operator==(const dap_poifi_tclMsgImportUPOIsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NumOfIgnoredFiles == rfoCmp.NumOfIgnoredFiles);
      bResult = bResult && (NumOfIgnoredPOIs == rfoCmp.NumOfIgnoredPOIs);
      bResult = bResult && (FirstErrorFileName == rfoCmp.FirstErrorFileName);
      bResult = bResult && (FirstErrorLineNumber == rfoCmp.FirstErrorLineNumber);
      bResult = bResult && (NumOfImportedPOIs == rfoCmp.NumOfImportedPOIs);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportUPOIsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NumOfIgnoredFiles;
   oIn >> NumOfIgnoredPOIs;
   oIn >> FirstErrorFileName;
   oIn >> FirstErrorLineNumber;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> NumOfImportedPOIs;
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportUPOIsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NumOfIgnoredFiles;
   oOut << NumOfIgnoredPOIs;
   oOut << FirstErrorFileName;
   oOut << FirstErrorLineNumber;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << NumOfImportedPOIs;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportUPOIsMethodAbort::dap_poifi_tclMsgImportUPOIsMethodAbort(const dap_poifi_tclMsgImportUPOIsMethodAbort& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportUPOIsMethodAbort& dap_poifi_tclMsgImportUPOIsMethodAbort::operator=(const dap_poifi_tclMsgImportUPOIsMethodAbort& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportUPOIsMethodAbort::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportUPOIsMethodAbort::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTUPOIS;}
tU8 dap_poifi_tclMsgImportUPOIsMethodAbort::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODABORT;}

tU32 dap_poifi_tclMsgImportUPOIsMethodAbort::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgImportUPOIsMethodAbort::operator==(const dap_poifi_tclMsgImportUPOIsMethodAbort& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportUPOIsMethodAbort::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportUPOIsMethodAbort::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgExportUPOIsMethodStart::dap_poifi_tclMsgExportUPOIsMethodStart(const dap_poifi_tclMsgExportUPOIsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   OrderType = coRef.OrderType;
   DestPath = coRef.DestPath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgExportUPOIsMethodStart& dap_poifi_tclMsgExportUPOIsMethodStart::operator=(const dap_poifi_tclMsgExportUPOIsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   OrderType = coRef.OrderType;
   DestPath = coRef.DestPath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgExportUPOIsMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgExportUPOIsMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_EXPORTUPOIS;}
tU8 dap_poifi_tclMsgExportUPOIsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgExportUPOIsMethodStart::vDestroy()
{
   DestPath.vDestroy();
}

tU32 dap_poifi_tclMsgExportUPOIsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DestPath.u32GetSize(u16MajorVersion);
}

tBool dap_poifi_tclMsgExportUPOIsMethodStart::operator==(const dap_poifi_tclMsgExportUPOIsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OrderType == rfoCmp.OrderType);
      bResult = bResult && (DestPath == rfoCmp.DestPath);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgExportUPOIsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> OrderType;
   oIn >> DestPath;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgExportUPOIsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OrderType;
   oOut << DestPath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgExportUPOIsMethodResult::dap_poifi_tclMsgExportUPOIsMethodResult(const dap_poifi_tclMsgExportUPOIsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NumOfIgnoredFiles = coRef.NumOfIgnoredFiles;
   FirstErrorFileName = coRef.FirstErrorFileName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgExportUPOIsMethodResult& dap_poifi_tclMsgExportUPOIsMethodResult::operator=(const dap_poifi_tclMsgExportUPOIsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NumOfIgnoredFiles = coRef.NumOfIgnoredFiles;
   FirstErrorFileName = coRef.FirstErrorFileName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgExportUPOIsMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgExportUPOIsMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_EXPORTUPOIS;}
tU8 dap_poifi_tclMsgExportUPOIsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_poifi_tclMsgExportUPOIsMethodResult::vDestroy()
{
   FirstErrorFileName.vDestroy();
}

tU32 dap_poifi_tclMsgExportUPOIsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+FirstErrorFileName.u32GetSize(u16MajorVersion);
}

tBool dap_poifi_tclMsgExportUPOIsMethodResult::operator==(const dap_poifi_tclMsgExportUPOIsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NumOfIgnoredFiles == rfoCmp.NumOfIgnoredFiles);
      bResult = bResult && (FirstErrorFileName == rfoCmp.FirstErrorFileName);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgExportUPOIsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NumOfIgnoredFiles;
   oIn >> FirstErrorFileName;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgExportUPOIsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NumOfIgnoredFiles;
   oOut << FirstErrorFileName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgExportUPOIsMethodAbort::dap_poifi_tclMsgExportUPOIsMethodAbort(const dap_poifi_tclMsgExportUPOIsMethodAbort& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgExportUPOIsMethodAbort& dap_poifi_tclMsgExportUPOIsMethodAbort::operator=(const dap_poifi_tclMsgExportUPOIsMethodAbort& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgExportUPOIsMethodAbort::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgExportUPOIsMethodAbort::u16GetFunctionID() const {return DAP_POIFI_C_U16_EXPORTUPOIS;}
tU8 dap_poifi_tclMsgExportUPOIsMethodAbort::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODABORT;}

tU32 dap_poifi_tclMsgExportUPOIsMethodAbort::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgExportUPOIsMethodAbort::operator==(const dap_poifi_tclMsgExportUPOIsMethodAbort& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgExportUPOIsMethodAbort::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgExportUPOIsMethodAbort::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportPOIsMethodStart::dap_poifi_tclMsgImportPOIsMethodStart(const dap_poifi_tclMsgImportPOIsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   OrderType = coRef.OrderType;
   SourcePath = coRef.SourcePath;
   Dataset = coRef.Dataset;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportPOIsMethodStart& dap_poifi_tclMsgImportPOIsMethodStart::operator=(const dap_poifi_tclMsgImportPOIsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   OrderType = coRef.OrderType;
   SourcePath = coRef.SourcePath;
   Dataset = coRef.Dataset;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportPOIsMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportPOIsMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTPOIS;}
tU8 dap_poifi_tclMsgImportPOIsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgImportPOIsMethodStart::vDestroy()
{
   SourcePath.vDestroy();
}

tU32 dap_poifi_tclMsgImportPOIsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+SourcePath.u32GetSize(u16MajorVersion);
}

tBool dap_poifi_tclMsgImportPOIsMethodStart::operator==(const dap_poifi_tclMsgImportPOIsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OrderType == rfoCmp.OrderType);
      bResult = bResult && (SourcePath == rfoCmp.SourcePath);
      bResult = bResult && (Dataset == rfoCmp.Dataset);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportPOIsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> OrderType;
   oIn >> SourcePath;
   oIn >> Dataset;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportPOIsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OrderType;
   oOut << SourcePath;
   oOut << Dataset;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportPOIsMethodResult::dap_poifi_tclMsgImportPOIsMethodResult(const dap_poifi_tclMsgImportPOIsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NumOfIgnoredFiles = coRef.NumOfIgnoredFiles;
   NumOfIgnoredPOIs = coRef.NumOfIgnoredPOIs;
   FirstErrorFileName = coRef.FirstErrorFileName;
   FirstErrorLineNumber = coRef.FirstErrorLineNumber;
   NumOfImportedPOIs = coRef.NumOfImportedPOIs;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportPOIsMethodResult& dap_poifi_tclMsgImportPOIsMethodResult::operator=(const dap_poifi_tclMsgImportPOIsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NumOfIgnoredFiles = coRef.NumOfIgnoredFiles;
   NumOfIgnoredPOIs = coRef.NumOfIgnoredPOIs;
   FirstErrorFileName = coRef.FirstErrorFileName;
   FirstErrorLineNumber = coRef.FirstErrorLineNumber;
   NumOfImportedPOIs = coRef.NumOfImportedPOIs;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportPOIsMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportPOIsMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTPOIS;}
tU8 dap_poifi_tclMsgImportPOIsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_poifi_tclMsgImportPOIsMethodResult::vDestroy()
{
   FirstErrorFileName.vDestroy();
}

tU32 dap_poifi_tclMsgImportPOIsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+12+FirstErrorFileName.u32GetSize(u16MajorVersion);
}

tBool dap_poifi_tclMsgImportPOIsMethodResult::operator==(const dap_poifi_tclMsgImportPOIsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NumOfIgnoredFiles == rfoCmp.NumOfIgnoredFiles);
      bResult = bResult && (NumOfIgnoredPOIs == rfoCmp.NumOfIgnoredPOIs);
      bResult = bResult && (FirstErrorFileName == rfoCmp.FirstErrorFileName);
      bResult = bResult && (FirstErrorLineNumber == rfoCmp.FirstErrorLineNumber);
      bResult = bResult && (NumOfImportedPOIs == rfoCmp.NumOfImportedPOIs);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportPOIsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NumOfIgnoredFiles;
   oIn >> NumOfIgnoredPOIs;
   oIn >> FirstErrorFileName;
   oIn >> FirstErrorLineNumber;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> NumOfImportedPOIs;
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportPOIsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NumOfIgnoredFiles;
   oOut << NumOfIgnoredPOIs;
   oOut << FirstErrorFileName;
   oOut << FirstErrorLineNumber;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << NumOfImportedPOIs;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportPOIsMethodAbort::dap_poifi_tclMsgImportPOIsMethodAbort(const dap_poifi_tclMsgImportPOIsMethodAbort& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportPOIsMethodAbort& dap_poifi_tclMsgImportPOIsMethodAbort::operator=(const dap_poifi_tclMsgImportPOIsMethodAbort& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportPOIsMethodAbort::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportPOIsMethodAbort::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTPOIS;}
tU8 dap_poifi_tclMsgImportPOIsMethodAbort::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODABORT;}

tU32 dap_poifi_tclMsgImportPOIsMethodAbort::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgImportPOIsMethodAbort::operator==(const dap_poifi_tclMsgImportPOIsMethodAbort& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportPOIsMethodAbort::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportPOIsMethodAbort::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetMapIdsMethodStart::dap_poifi_tclMsgGetMapIdsMethodStart(const dap_poifi_tclMsgGetMapIdsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   IndexIds = coRef.IndexIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetMapIdsMethodStart& dap_poifi_tclMsgGetMapIdsMethodStart::operator=(const dap_poifi_tclMsgGetMapIdsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   IndexIds = coRef.IndexIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetMapIdsMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetMapIdsMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETMAPIDS;}
tU8 dap_poifi_tclMsgGetMapIdsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgGetMapIdsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < IndexIds.size(); ++u32Idx)
         IndexIds[u32Idx].vDestroy();
   }
   IndexIds.clear();
}

tU32 dap_poifi_tclMsgGetMapIdsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+IndexIds.size()*4;
}

tBool dap_poifi_tclMsgGetMapIdsMethodStart::operator==(const dap_poifi_tclMsgGetMapIdsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IndexIds.size() == rfoCmp.IndexIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IndexIds.size()); ++u32Idx)
            bResult = bResult && (IndexIds[u32Idx] == rfoCmp.IndexIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetMapIdsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IndexIds.size(); ++u32Idx)
      {
         IndexIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IndexIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IndexIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetMapIdsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)IndexIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IndexIds.size(); ++u32Idx)
         oOut << IndexIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetMapIdsMethodResult::dap_poifi_tclMsgGetMapIdsMethodResult(const dap_poifi_tclMsgGetMapIdsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MapIds = coRef.MapIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgGetMapIdsMethodResult& dap_poifi_tclMsgGetMapIdsMethodResult::operator=(const dap_poifi_tclMsgGetMapIdsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MapIds = coRef.MapIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgGetMapIdsMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgGetMapIdsMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_GETMAPIDS;}
tU8 dap_poifi_tclMsgGetMapIdsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_poifi_tclMsgGetMapIdsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MapIds.size(); ++u32Idx)
         MapIds[u32Idx].vDestroy();
   }
   MapIds.clear();
}

tU32 dap_poifi_tclMsgGetMapIdsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+MapIds.size()*4;
}

tBool dap_poifi_tclMsgGetMapIdsMethodResult::operator==(const dap_poifi_tclMsgGetMapIdsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MapIds.size() == rfoCmp.MapIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MapIds.size()); ++u32Idx)
            bResult = bResult && (MapIds[u32Idx] == rfoCmp.MapIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgGetMapIdsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MapIds.size(); ++u32Idx)
      {
         MapIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MapIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MapIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgGetMapIdsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)MapIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MapIds.size(); ++u32Idx)
         oOut << MapIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgReAssignCategoryMethodStart::dap_poifi_tclMsgReAssignCategoryMethodStart(const dap_poifi_tclMsgReAssignCategoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   OldSelectionPath = coRef.OldSelectionPath;
   NewCategory = coRef.NewCategory;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgReAssignCategoryMethodStart& dap_poifi_tclMsgReAssignCategoryMethodStart::operator=(const dap_poifi_tclMsgReAssignCategoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   OldSelectionPath = coRef.OldSelectionPath;
   NewCategory = coRef.NewCategory;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgReAssignCategoryMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgReAssignCategoryMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_REASSIGNCATEGORY;}
tU8 dap_poifi_tclMsgReAssignCategoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgReAssignCategoryMethodStart::vDestroy()
{
   OldSelectionPath.vDestroy(); 
}

tU32 dap_poifi_tclMsgReAssignCategoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+OldSelectionPath.u32GetSize(u16MajorVersion);
}

tBool dap_poifi_tclMsgReAssignCategoryMethodStart::operator==(const dap_poifi_tclMsgReAssignCategoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OldSelectionPath == rfoCmp.OldSelectionPath);
      bResult = bResult && (NewCategory == rfoCmp.NewCategory);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgReAssignCategoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> OldSelectionPath;
   oIn >> NewCategory;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgReAssignCategoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OldSelectionPath;
   oOut << NewCategory;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgReAssignCategoryMethodResult::dap_poifi_tclMsgReAssignCategoryMethodResult(const dap_poifi_tclMsgReAssignCategoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgReAssignCategoryMethodResult& dap_poifi_tclMsgReAssignCategoryMethodResult::operator=(const dap_poifi_tclMsgReAssignCategoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgReAssignCategoryMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgReAssignCategoryMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_REASSIGNCATEGORY;}
tU8 dap_poifi_tclMsgReAssignCategoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_poifi_tclMsgReAssignCategoryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgReAssignCategoryMethodResult::operator==(const dap_poifi_tclMsgReAssignCategoryMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgReAssignCategoryMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgReAssignCategoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeleteCategoryMethodStart::dap_poifi_tclMsgDeleteCategoryMethodStart(const dap_poifi_tclMsgDeleteCategoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SelectionPath = coRef.SelectionPath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeleteCategoryMethodStart& dap_poifi_tclMsgDeleteCategoryMethodStart::operator=(const dap_poifi_tclMsgDeleteCategoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectionPath = coRef.SelectionPath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgDeleteCategoryMethodStart::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgDeleteCategoryMethodStart::u16GetFunctionID() const {return DAP_POIFI_C_U16_DELETECATEGORY;}
tU8 dap_poifi_tclMsgDeleteCategoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_poifi_tclMsgDeleteCategoryMethodStart::vDestroy()
{
   SelectionPath.vDestroy(); 
}

tU32 dap_poifi_tclMsgDeleteCategoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+SelectionPath.u32GetSize(u16MajorVersion);
}

tBool dap_poifi_tclMsgDeleteCategoryMethodStart::operator==(const dap_poifi_tclMsgDeleteCategoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SelectionPath == rfoCmp.SelectionPath);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgDeleteCategoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> SelectionPath;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgDeleteCategoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SelectionPath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeleteCategoryMethodResult::dap_poifi_tclMsgDeleteCategoryMethodResult(const dap_poifi_tclMsgDeleteCategoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgDeleteCategoryMethodResult& dap_poifi_tclMsgDeleteCategoryMethodResult::operator=(const dap_poifi_tclMsgDeleteCategoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgDeleteCategoryMethodResult::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgDeleteCategoryMethodResult::u16GetFunctionID() const {return DAP_POIFI_C_U16_DELETECATEGORY;}
tU8 dap_poifi_tclMsgDeleteCategoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_poifi_tclMsgDeleteCategoryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgDeleteCategoryMethodResult::operator==(const dap_poifi_tclMsgDeleteCategoryMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgDeleteCategoryMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgDeleteCategoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAvailablePOITypesGet::dap_poifi_tclMsgAvailablePOITypesGet(const dap_poifi_tclMsgAvailablePOITypesGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAvailablePOITypesGet& dap_poifi_tclMsgAvailablePOITypesGet::operator=(const dap_poifi_tclMsgAvailablePOITypesGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgAvailablePOITypesGet::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgAvailablePOITypesGet::u16GetFunctionID() const {return DAP_POIFI_C_U16_AVAILABLEPOITYPES;}
tU8 dap_poifi_tclMsgAvailablePOITypesGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_poifi_tclMsgAvailablePOITypesGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgAvailablePOITypesGet::operator==(const dap_poifi_tclMsgAvailablePOITypesGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgAvailablePOITypesGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgAvailablePOITypesGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAvailablePOITypesUpReg::dap_poifi_tclMsgAvailablePOITypesUpReg(const dap_poifi_tclMsgAvailablePOITypesUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAvailablePOITypesUpReg& dap_poifi_tclMsgAvailablePOITypesUpReg::operator=(const dap_poifi_tclMsgAvailablePOITypesUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgAvailablePOITypesUpReg::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgAvailablePOITypesUpReg::u16GetFunctionID() const {return DAP_POIFI_C_U16_AVAILABLEPOITYPES;}
tU8 dap_poifi_tclMsgAvailablePOITypesUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_poifi_tclMsgAvailablePOITypesUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgAvailablePOITypesUpReg::operator==(const dap_poifi_tclMsgAvailablePOITypesUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgAvailablePOITypesUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgAvailablePOITypesUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAvailablePOITypesRelUpReg::dap_poifi_tclMsgAvailablePOITypesRelUpReg(const dap_poifi_tclMsgAvailablePOITypesRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAvailablePOITypesRelUpReg& dap_poifi_tclMsgAvailablePOITypesRelUpReg::operator=(const dap_poifi_tclMsgAvailablePOITypesRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgAvailablePOITypesRelUpReg::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgAvailablePOITypesRelUpReg::u16GetFunctionID() const {return DAP_POIFI_C_U16_AVAILABLEPOITYPES;}
tU8 dap_poifi_tclMsgAvailablePOITypesRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_poifi_tclMsgAvailablePOITypesRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgAvailablePOITypesRelUpReg::operator==(const dap_poifi_tclMsgAvailablePOITypesRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgAvailablePOITypesRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgAvailablePOITypesRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAvailablePOITypesStatus::dap_poifi_tclMsgAvailablePOITypesStatus(const dap_poifi_tclMsgAvailablePOITypesStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   AvailablePOITypes = coRef.AvailablePOITypes;
   ChangedPOITypes = coRef.ChangedPOITypes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgAvailablePOITypesStatus& dap_poifi_tclMsgAvailablePOITypesStatus::operator=(const dap_poifi_tclMsgAvailablePOITypesStatus& coRef)
{
   if (this == &coRef) return *this;
   AvailablePOITypes = coRef.AvailablePOITypes;
   ChangedPOITypes = coRef.ChangedPOITypes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgAvailablePOITypesStatus::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgAvailablePOITypesStatus::u16GetFunctionID() const {return DAP_POIFI_C_U16_AVAILABLEPOITYPES;}
tU8 dap_poifi_tclMsgAvailablePOITypesStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 dap_poifi_tclMsgAvailablePOITypesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+2;
}

tBool dap_poifi_tclMsgAvailablePOITypesStatus::operator==(const dap_poifi_tclMsgAvailablePOITypesStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AvailablePOITypes == rfoCmp.AvailablePOITypes);
      bResult = bResult && (ChangedPOITypes == rfoCmp.ChangedPOITypes);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgAvailablePOITypesStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> AvailablePOITypes;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> ChangedPOITypes;
   }
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgAvailablePOITypesStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AvailablePOITypes;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << ChangedPOITypes;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportProgressGet::dap_poifi_tclMsgImportProgressGet(const dap_poifi_tclMsgImportProgressGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportProgressGet& dap_poifi_tclMsgImportProgressGet::operator=(const dap_poifi_tclMsgImportProgressGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportProgressGet::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportProgressGet::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTPROGRESS;}
tU8 dap_poifi_tclMsgImportProgressGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_poifi_tclMsgImportProgressGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgImportProgressGet::operator==(const dap_poifi_tclMsgImportProgressGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportProgressGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportProgressGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportProgressUpReg::dap_poifi_tclMsgImportProgressUpReg(const dap_poifi_tclMsgImportProgressUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportProgressUpReg& dap_poifi_tclMsgImportProgressUpReg::operator=(const dap_poifi_tclMsgImportProgressUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportProgressUpReg::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportProgressUpReg::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTPROGRESS;}
tU8 dap_poifi_tclMsgImportProgressUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_poifi_tclMsgImportProgressUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgImportProgressUpReg::operator==(const dap_poifi_tclMsgImportProgressUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportProgressUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportProgressUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportProgressRelUpReg::dap_poifi_tclMsgImportProgressRelUpReg(const dap_poifi_tclMsgImportProgressRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportProgressRelUpReg& dap_poifi_tclMsgImportProgressRelUpReg::operator=(const dap_poifi_tclMsgImportProgressRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportProgressRelUpReg::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportProgressRelUpReg::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTPROGRESS;}
tU8 dap_poifi_tclMsgImportProgressRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_poifi_tclMsgImportProgressRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgImportProgressRelUpReg::operator==(const dap_poifi_tclMsgImportProgressRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportProgressRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportProgressRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportProgressStatus::dap_poifi_tclMsgImportProgressStatus(const dap_poifi_tclMsgImportProgressStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Progress = coRef.Progress;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgImportProgressStatus& dap_poifi_tclMsgImportProgressStatus::operator=(const dap_poifi_tclMsgImportProgressStatus& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgImportProgressStatus::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgImportProgressStatus::u16GetFunctionID() const {return DAP_POIFI_C_U16_IMPORTPROGRESS;}
tU8 dap_poifi_tclMsgImportProgressStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 dap_poifi_tclMsgImportProgressStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool dap_poifi_tclMsgImportProgressStatus::operator==(const dap_poifi_tclMsgImportProgressStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Progress == rfoCmp.Progress);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgImportProgressStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Progress;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgImportProgressStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Progress;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCurrentUPOIDataSetIdGet::dap_poifi_tclMsgCurrentUPOIDataSetIdGet(const dap_poifi_tclMsgCurrentUPOIDataSetIdGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCurrentUPOIDataSetIdGet& dap_poifi_tclMsgCurrentUPOIDataSetIdGet::operator=(const dap_poifi_tclMsgCurrentUPOIDataSetIdGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgCurrentUPOIDataSetIdGet::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgCurrentUPOIDataSetIdGet::u16GetFunctionID() const {return DAP_POIFI_C_U16_CURRENTUPOIDATASETID;}
tU8 dap_poifi_tclMsgCurrentUPOIDataSetIdGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_poifi_tclMsgCurrentUPOIDataSetIdGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgCurrentUPOIDataSetIdGet::operator==(const dap_poifi_tclMsgCurrentUPOIDataSetIdGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgCurrentUPOIDataSetIdGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgCurrentUPOIDataSetIdGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg::dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg(const dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg& dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg::operator=(const dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg::u16GetFunctionID() const {return DAP_POIFI_C_U16_CURRENTUPOIDATASETID;}
tU8 dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg::operator==(const dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg::dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg(const dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg& dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg::operator=(const dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg::u16GetFunctionID() const {return DAP_POIFI_C_U16_CURRENTUPOIDATASETID;}
tU8 dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg::operator==(const dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCurrentUPOIDataSetIdStatus::dap_poifi_tclMsgCurrentUPOIDataSetIdStatus(const dap_poifi_tclMsgCurrentUPOIDataSetIdStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataSetId = coRef.DataSetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_poifi_tclMsgCurrentUPOIDataSetIdStatus& dap_poifi_tclMsgCurrentUPOIDataSetIdStatus::operator=(const dap_poifi_tclMsgCurrentUPOIDataSetIdStatus& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_poifi_tclMsgCurrentUPOIDataSetIdStatus::u16GetServiceID() const {return DAP_POIFI_C_U16_SERVICE_ID;}
tU16 dap_poifi_tclMsgCurrentUPOIDataSetIdStatus::u16GetFunctionID() const {return DAP_POIFI_C_U16_CURRENTUPOIDATASETID;}
tU8 dap_poifi_tclMsgCurrentUPOIDataSetIdStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 dap_poifi_tclMsgCurrentUPOIDataSetIdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool dap_poifi_tclMsgCurrentUPOIDataSetIdStatus::operator==(const dap_poifi_tclMsgCurrentUPOIDataSetIdStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
   return bResult;
}

fi_tclInContext& dap_poifi_tclMsgCurrentUPOIDataSetIdStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> DataSetId;
   return oIn;
}

fi_tclOutContext& dap_poifi_tclMsgCurrentUPOIDataSetIdStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataSetId;
   return oOut;
}

