#include "precompiled.hh"

tBool dap_poifi_tclDescription::bInitMessage(dap_poifi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case dap_poifi_tclToken::EN_LAST_TOKEN:
   case dap_poifi_tclToken::EN_LIST:
   case dap_poifi_tclToken::EN_END_OF_STRUCT:
   case dap_poifi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_OUTLINE,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_OUTLINES));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_CATEGORYFILTER));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_B16_POITYPE,dap_poifi_tclSemanticDomain::EN_MSG_POITYPES));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_poifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_DAPORDERTYPE,dap_poifi_tclSemanticDomain::EN_MSG_ORDERTYPE));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_USERPOIELEMENT,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_ELEMENTLIST));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_COUNTELEMENTSPEROUTLINE));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_OUTLINEINDICES));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_poifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTFIRST:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_USERPOIELEMENT,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_ELEMENTLIST));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_COUNTELEMENTSPEROUTLINE));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_OUTLINEINDICES));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_poifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTMIDDLE:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_USERPOIELEMENT,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_ELEMENTLIST));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_COUNTELEMENTSPEROUTLINE));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_OUTLINEINDICES));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTLAST:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_USERPOIELEMENT,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_ELEMENTLIST));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_COUNTELEMENTSPEROUTLINE));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_OUTLINEINDICES));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_TILEIDS));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_BOOL,dap_poifi_tclSemanticDomain::EN_MSG_USESTREAMING));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_SHAREDMEMMAXSIZE));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_SHAREDMEMOFFSET));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_MSG_HANDLE));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_CATEGORYFILTER));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_B16_POITYPE,dap_poifi_tclSemanticDomain::EN_MSG_POITYPES));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_DAPORDERTYPE,dap_poifi_tclSemanticDomain::EN_MSG_ORDERTYPE));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_RESULTBLOCKS,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_RESULTBLOCKS));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_SIZE));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTFIRST:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_RESULTBLOCKS,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_RESULTBLOCKS));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_SIZE));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTMIDDLE:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_RESULTBLOCKS,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_RESULTBLOCKS));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_SIZE));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTLAST:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_RESULTBLOCKS,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_RESULTBLOCKS));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_SIZE));
   } break;
   case dap_poifi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_CHANNELSIZE));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_MSG_CHANNELNAME));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U8,dap_poifi_tclSemanticDomain::EN_MSG_MINORVERSION));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U8,dap_poifi_tclSemanticDomain::EN_MSG_MAJORVERSION));
   } break;
   case dap_poifi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_MSG_HANDLE));
   } break;
   case dap_poifi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_MSG_HANDLE));
   } break;
   case dap_poifi_tclToken::EN_MSG_ADDPOISMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_USERPOIELEMENT,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_POIS));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E16_POITYPE,dap_poifi_tclSemanticDomain::EN_MSG_POITYPE));
   } break;
   case dap_poifi_tclToken::EN_MSG_ADDPOISMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_UNIQUEIDS));
   } break;
   case dap_poifi_tclToken::EN_MSG_DELETEPOISMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_UNIQUEIDS));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E16_POITYPE,dap_poifi_tclSemanticDomain::EN_MSG_POITYPE));
   } break;
   case dap_poifi_tclToken::EN_MSG_DELETEALLPOISMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_B16_POITYPE,dap_poifi_tclSemanticDomain::EN_MSG_POITYPE));
   } break;
   case dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_MSG_SOURCEPATH));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_DAPORDERTYPE,dap_poifi_tclSemanticDomain::EN_MSG_ORDERTYPE));
   } break;
   case dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODRESULT:
   {
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_NUMOFIMPORTEDPOIS));
      }
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_FIRSTERRORLINENUMBER));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_MSG_FIRSTERRORFILENAME));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_NUMOFIGNOREDPOIS));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_NUMOFIGNOREDFILES));
   } break;
   case dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_MSG_DESTPATH));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_DAPORDERTYPE,dap_poifi_tclSemanticDomain::EN_MSG_ORDERTYPE));
   } break;
   case dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_MSG_FIRSTERRORFILENAME));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_NUMOFIGNOREDFILES));
   } break;
   case dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_POIDATASET,dap_poifi_tclSemanticDomain::EN_MSG_DATASET));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_MSG_SOURCEPATH));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_DAPORDERTYPE,dap_poifi_tclSemanticDomain::EN_MSG_ORDERTYPE));
   } break;
   case dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODRESULT:
   {
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_NUMOFIMPORTEDPOIS));
      }
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_FIRSTERRORLINENUMBER));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_MSG_FIRSTERRORFILENAME));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_NUMOFIGNOREDPOIS));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_NUMOFIGNOREDFILES));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETMAPIDSMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_INDEXCATBRAND,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_INDEXIDS));
   } break;
   case dap_poifi_tclToken::EN_MSG_GETMAPIDSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_MAPIDPAIR,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_MSG_MAPIDS));
   } break;
   case dap_poifi_tclToken::EN_MSG_REASSIGNCATEGORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,dap_poifi_tclSemanticDomain::EN_MSG_NEWCATEGORY));
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LOCATIONDESCRIPTION,dap_poifi_tclSemanticDomain::EN_MSG_OLDSELECTIONPATH));
   } break;
   case dap_poifi_tclToken::EN_MSG_DELETECATEGORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LOCATIONDESCRIPTION,dap_poifi_tclSemanticDomain::EN_MSG_SELECTIONPATH));
   } break;
   case dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESSTATUS:
   {
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_B16_POITYPE,dap_poifi_tclSemanticDomain::EN_MSG_CHANGEDPOITYPES));
      }
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_B16_POITYPE,dap_poifi_tclSemanticDomain::EN_MSG_AVAILABLEPOITYPES));
   } break;
   case dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSSTATUS:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U8_PERCENT,dap_poifi_tclSemanticDomain::EN_MSG_PROGRESS));
   } break;
   case dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDSTATUS:
   {
      bResult &= oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_MSG_DATASETID));
   } break;
   case dap_poifi_tclToken::EN_BINCONTAINER:
   case dap_poifi_tclToken::EN_RESERVED:
   case dap_poifi_tclToken::EN_U8_PERCENT:
   case dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case dap_poifi_tclToken::EN_S32_METER:
   case dap_poifi_tclToken::EN_S16_CENTIMETERSECOND:
   case dap_poifi_tclToken::EN_FIVERSION:
   case dap_poifi_tclToken::EN_S32_LONGITUDE:
   case dap_poifi_tclToken::EN_S32_LATITUDE:
   case dap_poifi_tclToken::EN_POSITIONWGS84:
   case dap_poifi_tclToken::EN_E16_ISOLANGUAGECODE:
   case dap_poifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case dap_poifi_tclToken::EN_E8_DAPORDERTYPE:
   case dap_poifi_tclToken::EN_UNIQUEID:
   case dap_poifi_tclToken::EN_RESULTBLOCKS:
   case dap_poifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case dap_poifi_tclToken::EN_E8_BINCONTAINERTYPES:
   case dap_poifi_tclToken::EN_B16_POSITIONRELIABILITY:
   case dap_poifi_tclToken::EN_POSITIONHEADINGSPEED:
   case dap_poifi_tclToken::EN_U32_DATASETID:
   case dap_poifi_tclToken::EN_NAVCLUSTERDESC:
   case dap_poifi_tclToken::EN_NAVONECELLDESC:
   case dap_poifi_tclToken::EN_E8_SIDEINFO:
   case dap_poifi_tclToken::EN_S32_EMU:
   case dap_poifi_tclToken::EN_NAVZEROCELLDESC:
   case dap_poifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   case dap_poifi_tclToken::EN_NAVLOCATIONDESC:
   case dap_poifi_tclToken::EN_NAVLOCATIONDESCUNION0:
   case dap_poifi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   case dap_poifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   case dap_poifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   case dap_poifi_tclToken::EN_NAVLOCATIONDATADESC:
   case dap_poifi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   case dap_poifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   case dap_poifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   case dap_poifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   case dap_poifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   case dap_poifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   case dap_poifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   case dap_poifi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   case dap_poifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   case dap_poifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   case dap_poifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   case dap_poifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   case dap_poifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   case dap_poifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   case dap_poifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   case dap_poifi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   case dap_poifi_tclToken::EN_LOCATIONDESCRIPTOR:
   case dap_poifi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   case dap_poifi_tclToken::EN_LOCATIONDESCRIPTION:
   case dap_poifi_tclToken::EN_STRINGPOSITION:
   case dap_poifi_tclToken::EN_STRINGID:
   case dap_poifi_tclToken::EN_FLISTRING:
   case dap_poifi_tclToken::EN_B8_POSITIONSTATUS:
   case dap_poifi_tclToken::EN_LISTOFPOSITIONS:
   case dap_poifi_tclToken::EN_E16_POITYPE:
   case dap_poifi_tclToken::EN_B16_POITYPE:
   case dap_poifi_tclToken::EN_E8_POIDATASET:
   case dap_poifi_tclToken::EN_USERPOIELEMENT:
   case dap_poifi_tclToken::EN_OUTLINE:
   case dap_poifi_tclToken::EN_INDEXCATBRAND:
   case dap_poifi_tclToken::EN_MAPIDPAIR:
   case dap_poifi_tclToken::EN_U8:   
   case dap_poifi_tclToken::EN_S8:   
   case dap_poifi_tclToken::EN_U16:   
   case dap_poifi_tclToken::EN_S16:   
   case dap_poifi_tclToken::EN_U24:   
   case dap_poifi_tclToken::EN_S24:   
   case dap_poifi_tclToken::EN_U32:   
   case dap_poifi_tclToken::EN_S32:   
   case dap_poifi_tclToken::EN_U64:   
   case dap_poifi_tclToken::EN_S64:   
   case dap_poifi_tclToken::EN_F32:   
   case dap_poifi_tclToken::EN_F64:   
   case dap_poifi_tclToken::EN_BOOL:   
   case dap_poifi_tclToken::EN_STRING:   
   case dap_poifi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(dap_poifi_tclKnot(enMsgToken,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool dap_poifi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool dap_poifi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      dap_poifi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      dap_poifi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      dap_poifi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(dap_poifi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(dap_poifi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(dap_poifi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case dap_poifi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == dap_poifi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_poifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_poifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_poifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_poifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case dap_poifi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case dap_poifi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_poifi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTFIRST:
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTMIDDLE:
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTLAST:
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTFIRST:
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTMIDDLE:
   case dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTLAST:
   case dap_poifi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_ADDPOISMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_ADDPOISMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_DELETEPOISMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_DELETEPOISMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_DELETEALLPOISMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_DELETEALLPOISMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODABORT:
   case dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODABORT:
   case dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODABORT:
   case dap_poifi_tclToken::EN_MSG_GETMAPIDSMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_GETMAPIDSMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_REASSIGNCATEGORYMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_REASSIGNCATEGORYMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_DELETECATEGORYMETHODSTART:
   case dap_poifi_tclToken::EN_MSG_DELETECATEGORYMETHODRESULT:
   case dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESGET:
   case dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESUPREG:
   case dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESRELUPREG:
   case dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESSTATUS:
   case dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSGET:
   case dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSUPREG:
   case dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSRELUPREG:
   case dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSSTATUS:
   case dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDGET:
   case dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDUPREG:
   case dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDRELUPREG:
   case dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDSTATUS:
      bInitMessage(enToken);
      break;
   case dap_poifi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U8,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U8,dap_poifi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U8,dap_poifi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U8,dap_poifi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_S32_LATITUDE,dap_poifi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_S32_LONGITUDE,dap_poifi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_E8_DAPORDERTYPE:
   {
      fi_tcl_e8_DapOrderType o_e8_DapOrderType;
      if (!bDoIt(o_e8_DapOrderType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_UNIQUEID:
   {
      if (poVisitor->bDoExpand_UniqueID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_SECONDELEMENT));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_FIRSTELEMENT));
      }
      else
      {
         fi_tcl_UniqueID o_UniqueID;
         if (!bDoIt(o_UniqueID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UniqueID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UniqueID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_RESULTBLOCKS:
   {
      if (poVisitor->bDoExpand_ResultBlocks(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_ERRORCODE));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_OFFSET));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_UNIQUEID,dap_poifi_tclSemanticDomain::EN_UNIQUEID));
      }
      else
      {
         fi_tcl_ResultBlocks o_ResultBlocks;
         if (!bDoIt(o_ResultBlocks))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ResultBlocks.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ResultBlocks.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_B16_POSITIONRELIABILITY:
   {
      fi_tcl_b16_PositionReliability o_b16_PositionReliability;
      if (!bDoIt(o_b16_PositionReliability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_POSITIONHEADINGSPEED:
   {
      if (poVisitor->bDoExpand_PositionHeadingSpeed(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U8_DIRECTIONABSOLUTE,dap_poifi_tclSemanticDomain::EN_HEADING));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_S16_CENTIMETERSECOND,dap_poifi_tclSemanticDomain::EN_SPEED));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_B16_POSITIONRELIABILITY,dap_poifi_tclSemanticDomain::EN_POSITIONRELIABILITY));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_POSITIONWGS84));
      }
      else
      {
         fi_tcl_PositionHeadingSpeed o_PositionHeadingSpeed;
         if (!bDoIt(o_PositionHeadingSpeed))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U8,dap_poifi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_poifi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_NAVONECELLDIRECTION,dap_poifi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_E8_SIDEINFO:
   {
      fi_tcl_e8_SideInfo o_e8_SideInfo;
      if (!bDoIt(o_e8_SideInfo))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_S32_EMU:
   {
      fi_tcl_s32_EMU o_s32_EMU;
      if (!bDoIt(o_s32_EMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_NAVZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_poifi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_ZEROCELLID));
      }
      else
      {
         fi_tcl_NavZeroCellDesc o_NavZeroCellDesc;
         if (!bDoIt(o_NavZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   {
      fi_tcl_e8_NavLocationDescType o_e8_NavLocationDescType;
      if (!bDoIt(o_e8_NavLocationDescType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_NAVLOCATIONDESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationDescType oDataType;
      oCallStack.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE,dap_poifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_RESERVED,dap_poifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVLOCATIONDATADESC,dap_poifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE,dap_poifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON,dap_poifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      }
   } break;
   case dap_poifi_tclToken::EN_NAVLOCATIONDESC:
   {
      if (poVisitor->bDoExpand_NavLocationDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVLOCATIONDESCUNION0,dap_poifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
      }
      else
      {
         fi_tcl_NavLocationDesc o_NavLocationDesc;
         if (!bDoIt(o_NavLocationDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case dap_poifi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   {
      if (poVisitor->bDoExpand_NavLocationBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVLOCATIONDESC,dap_poifi_tclSemanticDomain::EN_CONTAINERDATA));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_BINCONTAINERTYPES,dap_poifi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_FIVERSION,dap_poifi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_NavLocationBinContainer o_NavLocationBinContainer;
         if (!bDoIt(o_NavLocationBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case dap_poifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   {
      fi_tcl_e8_NavIndexZFDestinationType o_e8_NavIndexZFDestinationType;
      if (!bDoIt(o_e8_NavIndexZFDestinationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   {
      fi_tcl_e8_NavLocationNavDataType o_e8_NavLocationNavDataType;
      if (!bDoIt(o_e8_NavLocationNavDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationNavDataType oDataType;
      oCallStack.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE,dap_poifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_RESERVED,dap_poifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET,dap_poifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET,dap_poifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET,dap_poifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      }
   } break;
   case dap_poifi_tclToken::EN_NAVLOCATIONDATADESC:
   {
      if (poVisitor->bDoExpand_NavLocationDataDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVLOCATIONDATADESCUNION0,dap_poifi_tclSemanticDomain::EN_NAVDATATYPE));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_ACCESSPOINTREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_OBJECTPOINTREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE,dap_poifi_tclSemanticDomain::EN_INDEXZFDESTTYPE));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32_DATASETID,dap_poifi_tclSemanticDomain::EN_NAVDATASETID));
      }
      else
      {
         fi_tcl_NavLocationDataDesc o_NavLocationDataDesc;
         if (!bDoIt(o_NavLocationDataDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_poifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_poifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_DECISIONPOINT));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_S32_EMU,dap_poifi_tclSemanticDomain::EN_DESTDISTANCE));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_S32_EMU,dap_poifi_tclSemanticDomain::EN_ONECELLLENGTH));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_S32_EMU,dap_poifi_tclSemanticDomain::EN_FROMZEROCELLTOSPOTLENGTH));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_SIDEINFO,dap_poifi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellProperty o_NavSpotDestinationOneCellProperty;
         if (!bDoIt(o_NavSpotDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY,dap_poifi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVONECELLDESC,dap_poifi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellDesc o_NavSpotDestinationOneCellDesc;
         if (!bDoIt(o_NavSpotDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_SPOTDESTINATIONONECELLREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVCLUSTERDESC,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellListSet o_NavSpotDestinationOneCellListSet;
         if (!bDoIt(o_NavSpotDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_poifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_poifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_SIDEINFO,dap_poifi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellProperty o_NavStreetDestinationOneCellProperty;
         if (!bDoIt(o_NavStreetDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY,dap_poifi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVONECELLDESC,dap_poifi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellDesc o_NavStreetDestinationOneCellDesc;
         if (!bDoIt(o_NavStreetDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_STREETDESTINATIONONECELLREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVCLUSTERDESC,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellListSet o_NavStreetDestinationOneCellListSet;
         if (!bDoIt(o_NavStreetDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   {
      fi_tcl_e8_NavIntersectionType o_e8_NavIntersectionType;
      if (!bDoIt(o_e8_NavIntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_poifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_poifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_NAVINTERSECTIONTYPE,dap_poifi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellProperty o_NavIntersectionDestinationZeroCellProperty;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY,dap_poifi_tclSemanticDomain::EN_ZEROCELLPROPERTY));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVZEROCELLDESC,dap_poifi_tclSemanticDomain::EN_ZEROCELLDESC));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellDesc o_NavIntersectionDestinationZeroCellDesc;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_INTERSECTIONDESTINATIONZEROCELLREFLIST));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVCLUSTERDESC,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellListSet o_NavIntersectionDestinationZeroCellListSet;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionCircle(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_COORDINATE));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_S32_METER,dap_poifi_tclSemanticDomain::EN_RADIUS));
      }
      else
      {
         fi_tcl_NavAreaDescriptionCircle o_NavAreaDescriptionCircle;
         if (!bDoIt(o_NavAreaDescriptionCircle))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionPolygon(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_COORDINATELIST));
      }
      else
      {
         fi_tcl_NavAreaDescriptionPolygon o_NavAreaDescriptionPolygon;
         if (!bDoIt(o_NavAreaDescriptionPolygon))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   {
      fi_tcl_e16_SelectionCriterionType o_e16_SelectionCriterionType;
      if (!bDoIt(o_e16_SelectionCriterionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   {
      fi_tcl_e8_LocationDescriptionDataType o_e8_LocationDescriptionDataType;
      if (!bDoIt(o_e8_LocationDescriptionDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   {
      fi_tcl_b8_LocationDescriptorStatus o_b8_LocationDescriptorStatus;
      if (!bDoIt(o_b8_LocationDescriptorStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_LocationDescriptionDataType oDataType;
      oCallStack.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE,dap_poifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS) &&
          !(17 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING) &&
          !(11 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_RESERVED,dap_poifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRINGID,dap_poifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONHEADINGSPEED,dap_poifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         #ifndef FI_S_EXTERNAL_FI
         if (bUseSpecialBinContainer)
         {
            oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_NAVLOCATIONBINCONTAINER,dap_poifi_tclSemanticDomain::EN_DATA));
         }
         else
         #endif // FI_S_EXTERNAL_FI
         {
            oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_BINCONTAINER,dap_poifi_tclSemanticDomain::EN_DATA));
         }
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRINGPOSITION,dap_poifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_FLISTRING,dap_poifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LISTOFPOSITIONS,dap_poifi_tclSemanticDomain::EN_DATA));
         break;
      }
   } break;
   case dap_poifi_tclToken::EN_LOCATIONDESCRIPTOR:
   {
      if (poVisitor->bDoExpand_LocationDescriptor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS,dap_poifi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LOCATIONDESCRIPTORUNION0,dap_poifi_tclSemanticDomain::EN_DATA));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,dap_poifi_tclSemanticDomain::EN_SELECTIONCRITERION));
      }
      else
      {
         fi_tcl_LocationDescriptor o_LocationDescriptor;
         if (!bDoIt(o_LocationDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_LOCATIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_LocationDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LOCATIONDESCRIPTOR,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_DESCRIPTORS));
      }
      else
      {
         fi_tcl_LocationDescription o_LocationDescription;
         if (!bDoIt(o_LocationDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_STRINGPOSITION:
   {
      if (poVisitor->bDoExpand_StringPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringPosition o_StringPosition;
         if (!bDoIt(o_StringPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_STRINGID:
   {
      if (poVisitor->bDoExpand_StringID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringID o_StringID;
         if (!bDoIt(o_StringID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_FLISTRING:
   {
      if (poVisitor->bDoExpand_FLIString(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_FLIString o_FLIString;
         if (!bDoIt(o_FLIString))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_B8_POSITIONSTATUS:
   {
      fi_tcl_b8_PositionStatus o_b8_PositionStatus;
      if (!bDoIt(o_b8_PositionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_LISTOFPOSITIONS:
   {
      if (poVisitor->bDoExpand_ListOfPositions(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_CURRENTPOSITION));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_ID));
         if (26 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_B8_POSITIONSTATUS,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_POSITIONSTATI));
         }
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_POSITIONS));
      }
      else
      {
         fi_tcl_ListOfPositions o_ListOfPositions;
         if (!bDoIt(o_ListOfPositions))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_E16_POITYPE:
   {
      fi_tcl_e16_POIType o_e16_POIType;
      if (!bDoIt(o_e16_POIType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_B16_POITYPE:
   {
      fi_tcl_b16_POIType o_b16_POIType;
      if (!bDoIt(o_b16_POIType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_E8_POIDATASET:
   {
      fi_tcl_e8_POIDataset o_e8_POIDataset;
      if (!bDoIt(o_e8_POIDataset))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_poifi_tclToken::EN_USERPOIELEMENT:
   {
      if (poVisitor->bDoExpand_UserPOIElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_STRING,dap_poifi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_CATEGORY));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U32,dap_poifi_tclSemanticDomain::EN_UNIQUEID));
      }
      else
      {
         fi_tcl_UserPOIElement o_UserPOIElement;
         if (!bDoIt(o_UserPOIElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UserPOIElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UserPOIElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_OUTLINE:
   {
      if (poVisitor->bDoExpand_Outline(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_POSITIONWGS84,dap_poifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_LIST,dap_poifi_tclSemanticDomain::EN_POINTS));
      }
      else
      {
         fi_tcl_Outline o_Outline;
         if (!bDoIt(o_Outline))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Outline.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Outline.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_INDEXCATBRAND:
   {
      if (poVisitor->bDoExpand_IndexCatBrand(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_BRAND));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_IndexCatBrand o_IndexCatBrand;
         if (!bDoIt(o_IndexCatBrand))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexCatBrand.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexCatBrand.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_poifi_tclToken::EN_MAPIDPAIR:
   {
      if (poVisitor->bDoExpand_MapIdPair(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_END_OF_STRUCT,dap_poifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_SUBGROUP));
         oPath.bGoDown(dap_poifi_tclKnot(dap_poifi_tclToken::EN_U16,dap_poifi_tclSemanticDomain::EN_FEATUREGROUP));
      }
      else
      {
         fi_tcl_MapIdPair o_MapIdPair;
         if (!bDoIt(o_MapIdPair))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapIdPair.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapIdPair.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case dap_poifi_tclToken::EN_UNKNOWN:
      case dap_poifi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

