#ifndef DAP_LIFILANGUAGE_HEADER
#define DAP_LIFILANGUAGE_HEADER

class dap_lifi_tclInContext;
class dap_lifi_tclOutContext;
class dap_lifi_tclVisitorBase;

class MY_DECL dap_lifi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  dap_lifi_tclDescription(fi_tclInContext* poIn, dap_lifi_tclVisitorBase* poVisit);
  dap_lifi_tclDescription(fi_tclOutContext* poOut, dap_lifi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(dap_lifi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ dap_lifi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  dap_lifi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<dap_lifi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<dap_lifi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline dap_lifi_tclDescription::dap_lifi_tclDescription(fi_tclInContext* poIn, dap_lifi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline dap_lifi_tclDescription::dap_lifi_tclDescription(fi_tclOutContext* poOut, dap_lifi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

