/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DAP_DEVMANFITYPES_HEADER
#define DAP_DEVMANFITYPES_HEADER

// #include <vector>
// 


class dap_devmanfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class dap_devmanfi_tclMsgReadDataBlocksMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgReadDataBlocksMethodStart():bCloseFilesAfterProcessing(0),oDataBlock() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgReadDataBlocksMethodStart& operator=(const dap_devmanfi_tclMsgReadDataBlocksMethodStart& coRef);
   dap_devmanfi_tclMsgReadDataBlocksMethodStart(const dap_devmanfi_tclMsgReadDataBlocksMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool bCloseFilesAfterProcessing;
   fi_tcl_DapComplexPhysicalBlockAddress oDataBlock;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgReadDataBlocksMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_READDATABLOCKSMETHODSTART;}
};

class dap_devmanfi_tclMsgReadDataBlocksMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgReadDataBlocksMethodResult():oDataBlock() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgReadDataBlocksMethodResult& operator=(const dap_devmanfi_tclMsgReadDataBlocksMethodResult& coRef);
   dap_devmanfi_tclMsgReadDataBlocksMethodResult(const dap_devmanfi_tclMsgReadDataBlocksMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapComplexPhysicalBlockAddress oDataBlock;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgReadDataBlocksMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_READDATABLOCKSMETHODRESULT;}
};

class dap_devmanfi_tclMsgGetFileSizeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgGetFileSizeMethodStart():bCloseFileAfterProcessing(0),oPhysicalAddress() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgGetFileSizeMethodStart& operator=(const dap_devmanfi_tclMsgGetFileSizeMethodStart& coRef);
   dap_devmanfi_tclMsgGetFileSizeMethodStart(const dap_devmanfi_tclMsgGetFileSizeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool bCloseFileAfterProcessing;
   fi_tcl_DapPhysicalAddress oPhysicalAddress;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgGetFileSizeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_GETFILESIZEMETHODSTART;}
};

class dap_devmanfi_tclMsgGetFileSizeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgGetFileSizeMethodResult():u32FileSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgGetFileSizeMethodResult& operator=(const dap_devmanfi_tclMsgGetFileSizeMethodResult& coRef);
   dap_devmanfi_tclMsgGetFileSizeMethodResult(const dap_devmanfi_tclMsgGetFileSizeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32FileSize;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgGetFileSizeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_GETFILESIZEMETHODRESULT;}
};

class dap_devmanfi_tclMsgGetDirectoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgGetDirectoryMethodStart():oDirectoryDescription(),u32ListOffset(0),oDirectoryList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgGetDirectoryMethodStart& operator=(const dap_devmanfi_tclMsgGetDirectoryMethodStart& coRef);
   dap_devmanfi_tclMsgGetDirectoryMethodStart(const dap_devmanfi_tclMsgGetDirectoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_DapPhysicalAddress oDirectoryDescription;
   tU32 u32ListOffset;
   fi_tcl_MemBlockDesc oDirectoryList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgGetDirectoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_GETDIRECTORYMETHODSTART;}
};

class dap_devmanfi_tclMsgGetDirectoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgGetDirectoryMethodResult():oDirectoryList(),bComplete(0),u32ListCounter(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgGetDirectoryMethodResult& operator=(const dap_devmanfi_tclMsgGetDirectoryMethodResult& coRef);
   dap_devmanfi_tclMsgGetDirectoryMethodResult(const dap_devmanfi_tclMsgGetDirectoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MemBlockDesc oDirectoryList;
   tBool bComplete;
   tU32 u32ListCounter;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgGetDirectoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_GETDIRECTORYMETHODRESULT;}
};

class dap_devmanfi_tclMsgGetDiscSpaceMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgGetDiscSpaceMethodStart():szDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgGetDiscSpaceMethodStart& operator=(const dap_devmanfi_tclMsgGetDiscSpaceMethodStart& coRef);
   dap_devmanfi_tclMsgGetDiscSpaceMethodStart(const dap_devmanfi_tclMsgGetDiscSpaceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szDevice;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgGetDiscSpaceMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_GETDISCSPACEMETHODSTART;}
};

class dap_devmanfi_tclMsgGetDiscSpaceMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgGetDiscSpaceMethodResult():u32LowDiscSpace(0),u32HighDiscSpace(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgGetDiscSpaceMethodResult& operator=(const dap_devmanfi_tclMsgGetDiscSpaceMethodResult& coRef);
   dap_devmanfi_tclMsgGetDiscSpaceMethodResult(const dap_devmanfi_tclMsgGetDiscSpaceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32LowDiscSpace;
   tU32 u32HighDiscSpace;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgGetDiscSpaceMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_GETDISCSPACEMETHODRESULT;}
};

class dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart():szDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart& operator=(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart& coRef);
   dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szDevice;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_GETFREEDISKSPACEMETHODSTART;}
};

class dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult():u32LowDiscSpace(0),u32HighDiscSpace(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult& operator=(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult& coRef);
   dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32LowDiscSpace;
   tU32 u32HighDiscSpace;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_GETFREEDISKSPACEMETHODRESULT;}
};

class dap_devmanfi_tclMsgCreateDirectoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgCreateDirectoryMethodStart():szTargetAccessPath(),szDirectoryName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgCreateDirectoryMethodStart& operator=(const dap_devmanfi_tclMsgCreateDirectoryMethodStart& coRef);
   dap_devmanfi_tclMsgCreateDirectoryMethodStart(const dap_devmanfi_tclMsgCreateDirectoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szTargetAccessPath;
   fi_tclString szDirectoryName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgCreateDirectoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_CREATEDIRECTORYMETHODSTART;}
};

class dap_devmanfi_tclMsgCreateDirectoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgCreateDirectoryMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgCreateDirectoryMethodResult& operator=(const dap_devmanfi_tclMsgCreateDirectoryMethodResult& coRef);
   dap_devmanfi_tclMsgCreateDirectoryMethodResult(const dap_devmanfi_tclMsgCreateDirectoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgCreateDirectoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_CREATEDIRECTORYMETHODRESULT;}
};

class dap_devmanfi_tclMsgCopyFilesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgCopyFilesMethodStart():u32SourceMediumId(0),szSourceDevice(),szTargetDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgCopyFilesMethodStart& operator=(const dap_devmanfi_tclMsgCopyFilesMethodStart& coRef);
   dap_devmanfi_tclMsgCopyFilesMethodStart(const dap_devmanfi_tclMsgCopyFilesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32SourceMediumId;
   fi_tclString szSourceDevice;
   fi_tclString szTargetDevice;
   std::vector<fi_tcl_FileCopy, std::allocator<fi_tcl_FileCopy> > aoCopyFiles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgCopyFilesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_COPYFILESMETHODSTART;}
};

class dap_devmanfi_tclMsgCopyFilesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgCopyFilesMethodResult():u16OrderIndex(0),u16ErrorCode(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgCopyFilesMethodResult& operator=(const dap_devmanfi_tclMsgCopyFilesMethodResult& coRef);
   dap_devmanfi_tclMsgCopyFilesMethodResult(const dap_devmanfi_tclMsgCopyFilesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 u16OrderIndex;
   tU16 u16ErrorCode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgCopyFilesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_COPYFILESMETHODRESULT;}
};

class dap_devmanfi_tclMsgWriteToFileMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgWriteToFileMethodStart():oTarget(),u32FileOffset(0),oDataBufferDescriptor(),bCloseAfterProcessing(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgWriteToFileMethodStart& operator=(const dap_devmanfi_tclMsgWriteToFileMethodStart& coRef);
   dap_devmanfi_tclMsgWriteToFileMethodStart(const dap_devmanfi_tclMsgWriteToFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PathFilename oTarget;
   tU32 u32FileOffset;
   fi_tcl_MemBlockDesc oDataBufferDescriptor;
   tBool bCloseAfterProcessing;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgWriteToFileMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_WRITETOFILEMETHODSTART;}
};

class dap_devmanfi_tclMsgWriteToFileMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgWriteToFileMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgWriteToFileMethodResult& operator=(const dap_devmanfi_tclMsgWriteToFileMethodResult& coRef);
   dap_devmanfi_tclMsgWriteToFileMethodResult(const dap_devmanfi_tclMsgWriteToFileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgWriteToFileMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_WRITETOFILEMETHODRESULT;}
};

class dap_devmanfi_tclMsgRenameMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRenameMethodStart():oSource(),szNewFilename() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRenameMethodStart& operator=(const dap_devmanfi_tclMsgRenameMethodStart& coRef);
   dap_devmanfi_tclMsgRenameMethodStart(const dap_devmanfi_tclMsgRenameMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PathFilename oSource;
   fi_tclString szNewFilename;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRenameMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_RENAMEMETHODSTART;}
};

class dap_devmanfi_tclMsgRenameMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRenameMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRenameMethodResult& operator=(const dap_devmanfi_tclMsgRenameMethodResult& coRef);
   dap_devmanfi_tclMsgRenameMethodResult(const dap_devmanfi_tclMsgRenameMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRenameMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_RENAMEMETHODRESULT;}
};

class dap_devmanfi_tclMsgRemoveFilesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRemoveFilesMethodStart():szPath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRemoveFilesMethodStart& operator=(const dap_devmanfi_tclMsgRemoveFilesMethodStart& coRef);
   dap_devmanfi_tclMsgRemoveFilesMethodStart(const dap_devmanfi_tclMsgRemoveFilesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szPath;
   std::vector<fi_tclString, std::allocator<fi_tclString> > szFilenameList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRemoveFilesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REMOVEFILESMETHODSTART;}
};

class dap_devmanfi_tclMsgRemoveFilesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRemoveFilesMethodResult():u16OrderIndex(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRemoveFilesMethodResult& operator=(const dap_devmanfi_tclMsgRemoveFilesMethodResult& coRef);
   dap_devmanfi_tclMsgRemoveFilesMethodResult(const dap_devmanfi_tclMsgRemoveFilesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 u16OrderIndex;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRemoveFilesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REMOVEFILESMETHODRESULT;}
};

class dap_devmanfi_tclMsgRemoveDirectoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRemoveDirectoryMethodStart():szPath(),szDirectoryName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRemoveDirectoryMethodStart& operator=(const dap_devmanfi_tclMsgRemoveDirectoryMethodStart& coRef);
   dap_devmanfi_tclMsgRemoveDirectoryMethodStart(const dap_devmanfi_tclMsgRemoveDirectoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szPath;
   fi_tclString szDirectoryName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRemoveDirectoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REMOVEDIRECTORYMETHODSTART;}
};

class dap_devmanfi_tclMsgRemoveDirectoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRemoveDirectoryMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRemoveDirectoryMethodResult& operator=(const dap_devmanfi_tclMsgRemoveDirectoryMethodResult& coRef);
   dap_devmanfi_tclMsgRemoveDirectoryMethodResult(const dap_devmanfi_tclMsgRemoveDirectoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRemoveDirectoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REMOVEDIRECTORYMETHODRESULT;}
};

class dap_devmanfi_tclMsgTimerProcessedMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgTimerProcessedMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgTimerProcessedMethodStart& operator=(const dap_devmanfi_tclMsgTimerProcessedMethodStart& coRef);
   dap_devmanfi_tclMsgTimerProcessedMethodStart(const dap_devmanfi_tclMsgTimerProcessedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgTimerProcessedMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_TIMERPROCESSEDMETHODSTART;}
};

class dap_devmanfi_tclMsgTimerProcessedMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgTimerProcessedMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgTimerProcessedMethodResult& operator=(const dap_devmanfi_tclMsgTimerProcessedMethodResult& coRef);
   dap_devmanfi_tclMsgTimerProcessedMethodResult(const dap_devmanfi_tclMsgTimerProcessedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgTimerProcessedMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_TIMERPROCESSEDMETHODRESULT;}
};

class dap_devmanfi_tclMsgDataTypeInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDataTypeInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDataTypeInfoUpReg& operator=(const dap_devmanfi_tclMsgDataTypeInfoUpReg& coRef);
   dap_devmanfi_tclMsgDataTypeInfoUpReg(const dap_devmanfi_tclMsgDataTypeInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDataTypeInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DATATYPEINFOUPREG;}
};

class dap_devmanfi_tclMsgDataTypeInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDataTypeInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDataTypeInfoRelUpReg& operator=(const dap_devmanfi_tclMsgDataTypeInfoRelUpReg& coRef);
   dap_devmanfi_tclMsgDataTypeInfoRelUpReg(const dap_devmanfi_tclMsgDataTypeInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDataTypeInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DATATYPEINFORELUPREG;}
};

class dap_devmanfi_tclMsgDataTypeInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDataTypeInfoStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDataTypeInfoStatus& operator=(const dap_devmanfi_tclMsgDataTypeInfoStatus& coRef);
   dap_devmanfi_tclMsgDataTypeInfoStatus(const dap_devmanfi_tclMsgDataTypeInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_DapDataTypeInfo, std::allocator<fi_tcl_DapDataTypeInfo> > aoDataInfos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDataTypeInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DATATYPEINFOSTATUS;}
};

class dap_devmanfi_tclMsgMediaInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgMediaInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgMediaInfoUpReg& operator=(const dap_devmanfi_tclMsgMediaInfoUpReg& coRef);
   dap_devmanfi_tclMsgMediaInfoUpReg(const dap_devmanfi_tclMsgMediaInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgMediaInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_MEDIAINFOUPREG;}
};

class dap_devmanfi_tclMsgMediaInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgMediaInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgMediaInfoRelUpReg& operator=(const dap_devmanfi_tclMsgMediaInfoRelUpReg& coRef);
   dap_devmanfi_tclMsgMediaInfoRelUpReg(const dap_devmanfi_tclMsgMediaInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgMediaInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_MEDIAINFORELUPREG;}
};

class dap_devmanfi_tclMsgMediaInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgMediaInfoStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgMediaInfoStatus& operator=(const dap_devmanfi_tclMsgMediaInfoStatus& coRef);
   dap_devmanfi_tclMsgMediaInfoStatus(const dap_devmanfi_tclMsgMediaInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_DevMediaInfo, std::allocator<fi_tcl_DevMediaInfo> > aoMediaInfos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgMediaInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_MEDIAINFOSTATUS;}
};

class dap_devmanfi_tclMsgDeviceStatusInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDeviceStatusInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDeviceStatusInfoUpReg& operator=(const dap_devmanfi_tclMsgDeviceStatusInfoUpReg& coRef);
   dap_devmanfi_tclMsgDeviceStatusInfoUpReg(const dap_devmanfi_tclMsgDeviceStatusInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDeviceStatusInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFOUPREG;}
};

class dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg& operator=(const dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg& coRef);
   dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg(const dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFORELUPREG;}
};

class dap_devmanfi_tclMsgDeviceStatusInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDeviceStatusInfoStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDeviceStatusInfoStatus& operator=(const dap_devmanfi_tclMsgDeviceStatusInfoStatus& coRef);
   dap_devmanfi_tclMsgDeviceStatusInfoStatus(const dap_devmanfi_tclMsgDeviceStatusInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_DapDeviceStatusInfo, std::allocator<fi_tcl_DapDeviceStatusInfo> > aoDeviceInfos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDeviceStatusInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFOSTATUS;}
};

class dap_devmanfi_tclMsgPRMNotificationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgPRMNotificationStatus():u32NotificationData(0),enNotification(),szDevicePath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgPRMNotificationStatus& operator=(const dap_devmanfi_tclMsgPRMNotificationStatus& coRef);
   dap_devmanfi_tclMsgPRMNotificationStatus(const dap_devmanfi_tclMsgPRMNotificationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32NotificationData;
   fi_tcl_e8_DevNotification enNotification;
   fi_tclString szDevicePath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgPRMNotificationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_PRMNOTIFICATIONSTATUS;}
};

class dap_devmanfi_tclMsgDefaultDataInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDefaultDataInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDefaultDataInfoUpReg& operator=(const dap_devmanfi_tclMsgDefaultDataInfoUpReg& coRef);
   dap_devmanfi_tclMsgDefaultDataInfoUpReg(const dap_devmanfi_tclMsgDefaultDataInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDefaultDataInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFOUPREG;}
};

class dap_devmanfi_tclMsgDefaultDataInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDefaultDataInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDefaultDataInfoRelUpReg& operator=(const dap_devmanfi_tclMsgDefaultDataInfoRelUpReg& coRef);
   dap_devmanfi_tclMsgDefaultDataInfoRelUpReg(const dap_devmanfi_tclMsgDefaultDataInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDefaultDataInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFORELUPREG;}
};

class dap_devmanfi_tclMsgDefaultDataInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDefaultDataInfoStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDefaultDataInfoStatus& operator=(const dap_devmanfi_tclMsgDefaultDataInfoStatus& coRef);
   dap_devmanfi_tclMsgDefaultDataInfoStatus(const dap_devmanfi_tclMsgDefaultDataInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_DapDataTypeInfo, std::allocator<fi_tcl_DapDataTypeInfo> > aoDataInfos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDefaultDataInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFOSTATUS;}
};

class dap_devmanfi_tclMsgDefaultDeviceSet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDefaultDeviceSet():szDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDefaultDeviceSet& operator=(const dap_devmanfi_tclMsgDefaultDeviceSet& coRef);
   dap_devmanfi_tclMsgDefaultDeviceSet(const dap_devmanfi_tclMsgDefaultDeviceSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szDevice;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDefaultDeviceSet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DEFAULTDEVICESET;}
};

class dap_devmanfi_tclMsgDefaultDeviceStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDefaultDeviceStatus():szDevice(),ErrorState(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDefaultDeviceStatus& operator=(const dap_devmanfi_tclMsgDefaultDeviceStatus& coRef);
   dap_devmanfi_tclMsgDefaultDeviceStatus(const dap_devmanfi_tclMsgDefaultDeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString szDevice;
   tU16 ErrorState;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDefaultDeviceStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DEFAULTDEVICESTATUS;}
};

class dap_devmanfi_tclMsgRegionDescriptionsUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRegionDescriptionsUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRegionDescriptionsUpReg& operator=(const dap_devmanfi_tclMsgRegionDescriptionsUpReg& coRef);
   dap_devmanfi_tclMsgRegionDescriptionsUpReg(const dap_devmanfi_tclMsgRegionDescriptionsUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRegionDescriptionsUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSUPREG;}
};

class dap_devmanfi_tclMsgRegionDescriptionsRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRegionDescriptionsRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRegionDescriptionsRelUpReg& operator=(const dap_devmanfi_tclMsgRegionDescriptionsRelUpReg& coRef);
   dap_devmanfi_tclMsgRegionDescriptionsRelUpReg(const dap_devmanfi_tclMsgRegionDescriptionsRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRegionDescriptionsRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSRELUPREG;}
};

class dap_devmanfi_tclMsgRegionDescriptionsStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRegionDescriptionsStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRegionDescriptionsStatus& operator=(const dap_devmanfi_tclMsgRegionDescriptionsStatus& coRef);
   dap_devmanfi_tclMsgRegionDescriptionsStatus(const dap_devmanfi_tclMsgRegionDescriptionsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_DapRegionDescrList, std::allocator<fi_tcl_DapRegionDescrList> > oRegionDescrLists;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRegionDescriptionsStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSSTATUS;}
};

class dap_devmanfi_tclMsgRegionMetaDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRegionMetaDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRegionMetaDataUpReg& operator=(const dap_devmanfi_tclMsgRegionMetaDataUpReg& coRef);
   dap_devmanfi_tclMsgRegionMetaDataUpReg(const dap_devmanfi_tclMsgRegionMetaDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRegionMetaDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REGIONMETADATAUPREG;}
};

class dap_devmanfi_tclMsgRegionMetaDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRegionMetaDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRegionMetaDataRelUpReg& operator=(const dap_devmanfi_tclMsgRegionMetaDataRelUpReg& coRef);
   dap_devmanfi_tclMsgRegionMetaDataRelUpReg(const dap_devmanfi_tclMsgRegionMetaDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRegionMetaDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REGIONMETADATARELUPREG;}
};

class dap_devmanfi_tclMsgRegionMetaDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgRegionMetaDataStatus():u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgRegionMetaDataStatus& operator=(const dap_devmanfi_tclMsgRegionMetaDataStatus& coRef);
   dap_devmanfi_tclMsgRegionMetaDataStatus(const dap_devmanfi_tclMsgRegionMetaDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32DatasetId;
   std::vector<fi_tcl_DapRegionMetaInfo, std::allocator<fi_tcl_DapRegionMetaInfo> > oRegionMetaInfoList;
   std::vector<fi_tcl_DapProfileMetaInfo, std::allocator<fi_tcl_DapProfileMetaInfo> > oProfileMetaInfoList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgRegionMetaDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_REGIONMETADATASTATUS;}
};

class dap_devmanfi_tclMsgDataVisibilitySet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDataVisibilitySet():bVisible(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDataVisibilitySet& operator=(const dap_devmanfi_tclMsgDataVisibilitySet& coRef);
   dap_devmanfi_tclMsgDataVisibilitySet(const dap_devmanfi_tclMsgDataVisibilitySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool bVisible;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDataVisibilitySet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYSET;}
};

class dap_devmanfi_tclMsgDataVisibilityUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDataVisibilityUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDataVisibilityUpReg& operator=(const dap_devmanfi_tclMsgDataVisibilityUpReg& coRef);
   dap_devmanfi_tclMsgDataVisibilityUpReg(const dap_devmanfi_tclMsgDataVisibilityUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDataVisibilityUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYUPREG;}
};

class dap_devmanfi_tclMsgDataVisibilityRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDataVisibilityRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDataVisibilityRelUpReg& operator=(const dap_devmanfi_tclMsgDataVisibilityRelUpReg& coRef);
   dap_devmanfi_tclMsgDataVisibilityRelUpReg(const dap_devmanfi_tclMsgDataVisibilityRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDataVisibilityRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYRELUPREG;}
};

class dap_devmanfi_tclMsgDataVisibilityStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_devmanfi_tclMsgDataVisibilityStatus():bVisible(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_devmanfi_tclMsgDataVisibilityStatus& operator=(const dap_devmanfi_tclMsgDataVisibilityStatus& coRef);
   dap_devmanfi_tclMsgDataVisibilityStatus(const dap_devmanfi_tclMsgDataVisibilityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool bVisible;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_devmanfi_tclMsgDataVisibilityStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYSTATUS;}
};


#endif
