/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef CATALOGUEFITYPES_HEADER
#define CATALOGUEFITYPES_HEADER

// #include <vector>
// 


class cataloguefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class cataloguefi_tclMsgGetCatalogueFileMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   cataloguefi_tclMsgGetCatalogueFileMethodStart():FileType(),FilePath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cataloguefi_tclMsgGetCatalogueFileMethodStart& operator=(const cataloguefi_tclMsgGetCatalogueFileMethodStart& coRef);
   cataloguefi_tclMsgGetCatalogueFileMethodStart(const cataloguefi_tclMsgGetCatalogueFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_FileType FileType;
   fi_tclString FilePath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const cataloguefi_tclMsgGetCatalogueFileMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return cataloguefi_tclToken::EN_MSG_GETCATALOGUEFILEMETHODSTART;}
};

class cataloguefi_tclMsgGetCatalogueFileMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   cataloguefi_tclMsgGetCatalogueFileMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cataloguefi_tclMsgGetCatalogueFileMethodResult& operator=(const cataloguefi_tclMsgGetCatalogueFileMethodResult& coRef);
   cataloguefi_tclMsgGetCatalogueFileMethodResult(const cataloguefi_tclMsgGetCatalogueFileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_CatalogueFiles, std::allocator<fi_tcl_CatalogueFiles> > CatalogueFile;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const cataloguefi_tclMsgGetCatalogueFileMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return cataloguefi_tclToken::EN_MSG_GETCATALOGUEFILEMETHODRESULT;}
};

class cataloguefi_tclMsgGetFileContentMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   cataloguefi_tclMsgGetFileContentMethodStart():ContentFileHandle(0),RowNumber(-1) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cataloguefi_tclMsgGetFileContentMethodStart& operator=(const cataloguefi_tclMsgGetFileContentMethodStart& coRef);
   cataloguefi_tclMsgGetFileContentMethodStart(const cataloguefi_tclMsgGetFileContentMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ContentFileHandle;
   tS32 RowNumber;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const cataloguefi_tclMsgGetFileContentMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return cataloguefi_tclToken::EN_MSG_GETFILECONTENTMETHODSTART;}
};

class cataloguefi_tclMsgGetFileContentMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   cataloguefi_tclMsgGetFileContentMethodResult():File() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cataloguefi_tclMsgGetFileContentMethodResult& operator=(const cataloguefi_tclMsgGetFileContentMethodResult& coRef);
   cataloguefi_tclMsgGetFileContentMethodResult(const cataloguefi_tclMsgGetFileContentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_FileContents File;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const cataloguefi_tclMsgGetFileContentMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return cataloguefi_tclToken::EN_MSG_GETFILECONTENTMETHODRESULT;}
};

class cataloguefi_tclMsgFireActionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   cataloguefi_tclMsgFireActionMethodStart():ActionFileHandle(0),ActEventSign(0),NoOfFollowingParameters(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cataloguefi_tclMsgFireActionMethodStart& operator=(const cataloguefi_tclMsgFireActionMethodStart& coRef);
   cataloguefi_tclMsgFireActionMethodStart(const cataloguefi_tclMsgFireActionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ActionFileHandle;
   tU32 ActEventSign;
   tU32 NoOfFollowingParameters;
   std::vector<fi_tcl_FileContents, std::allocator<fi_tcl_FileContents> > ParamInput;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const cataloguefi_tclMsgFireActionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return cataloguefi_tclToken::EN_MSG_FIREACTIONMETHODSTART;}
};

class cataloguefi_tclMsgFireActionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   cataloguefi_tclMsgFireActionMethodResult():StatusEventSign(0),ActionStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cataloguefi_tclMsgFireActionMethodResult& operator=(const cataloguefi_tclMsgFireActionMethodResult& coRef);
   cataloguefi_tclMsgFireActionMethodResult(const cataloguefi_tclMsgFireActionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 StatusEventSign;
   fi_tcl_e8_Status ActionStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const cataloguefi_tclMsgFireActionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return cataloguefi_tclToken::EN_MSG_FIREACTIONMETHODRESULT;}
};

class cataloguefi_tclMsgFileSystemListenerUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   cataloguefi_tclMsgFileSystemListenerUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cataloguefi_tclMsgFileSystemListenerUpReg& operator=(const cataloguefi_tclMsgFileSystemListenerUpReg& coRef);
   cataloguefi_tclMsgFileSystemListenerUpReg(const cataloguefi_tclMsgFileSystemListenerUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const cataloguefi_tclMsgFileSystemListenerUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERUPREG;}
};

class cataloguefi_tclMsgFileSystemListenerRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   cataloguefi_tclMsgFileSystemListenerRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cataloguefi_tclMsgFileSystemListenerRelUpReg& operator=(const cataloguefi_tclMsgFileSystemListenerRelUpReg& coRef);
   cataloguefi_tclMsgFileSystemListenerRelUpReg(const cataloguefi_tclMsgFileSystemListenerRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const cataloguefi_tclMsgFileSystemListenerRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERRELUPREG;}
};

class cataloguefi_tclMsgFileSystemListenerStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   cataloguefi_tclMsgFileSystemListenerStatus():EventSignature(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cataloguefi_tclMsgFileSystemListenerStatus& operator=(const cataloguefi_tclMsgFileSystemListenerStatus& coRef);
   cataloguefi_tclMsgFileSystemListenerStatus(const cataloguefi_tclMsgFileSystemListenerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 EventSignature;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const cataloguefi_tclMsgFileSystemListenerStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERSTATUS;}
};


#endif
