/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgGetCatalogueFileMethodStart::cataloguefi_tclMsgGetCatalogueFileMethodStart(const cataloguefi_tclMsgGetCatalogueFileMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   FileType = coRef.FileType;
   FilePath = coRef.FilePath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgGetCatalogueFileMethodStart& cataloguefi_tclMsgGetCatalogueFileMethodStart::operator=(const cataloguefi_tclMsgGetCatalogueFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileType = coRef.FileType;
   FilePath = coRef.FilePath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 cataloguefi_tclMsgGetCatalogueFileMethodStart::u16GetServiceID() const {return CATALOGUEFI_C_U16_SERVICE_ID;}
tU16 cataloguefi_tclMsgGetCatalogueFileMethodStart::u16GetFunctionID() const {return CATALOGUEFI_C_U16_GETCATALOGUEFILE;}
tU8 cataloguefi_tclMsgGetCatalogueFileMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid cataloguefi_tclMsgGetCatalogueFileMethodStart::vDestroy()
{
   FilePath.vDestroy();
}

tU32 cataloguefi_tclMsgGetCatalogueFileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+FilePath.u32GetSize(u16MajorVersion);
}

tBool cataloguefi_tclMsgGetCatalogueFileMethodStart::operator==(const cataloguefi_tclMsgGetCatalogueFileMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FileType == rfoCmp.FileType);
      bResult = bResult && (FilePath == rfoCmp.FilePath);
   return bResult;
}

fi_tclInContext& cataloguefi_tclMsgGetCatalogueFileMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> FileType;
   oIn >> FilePath;
   return oIn;
}

fi_tclOutContext& cataloguefi_tclMsgGetCatalogueFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FileType;
   oOut << FilePath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgGetCatalogueFileMethodResult::cataloguefi_tclMsgGetCatalogueFileMethodResult(const cataloguefi_tclMsgGetCatalogueFileMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CatalogueFile = coRef.CatalogueFile;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgGetCatalogueFileMethodResult& cataloguefi_tclMsgGetCatalogueFileMethodResult::operator=(const cataloguefi_tclMsgGetCatalogueFileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CatalogueFile = coRef.CatalogueFile;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 cataloguefi_tclMsgGetCatalogueFileMethodResult::u16GetServiceID() const {return CATALOGUEFI_C_U16_SERVICE_ID;}
tU16 cataloguefi_tclMsgGetCatalogueFileMethodResult::u16GetFunctionID() const {return CATALOGUEFI_C_U16_GETCATALOGUEFILE;}
tU8 cataloguefi_tclMsgGetCatalogueFileMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid cataloguefi_tclMsgGetCatalogueFileMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CatalogueFile.size(); ++u32Idx)
         CatalogueFile[u32Idx].vDestroy();
   }
   CatalogueFile.clear();
}

tU32 cataloguefi_tclMsgGetCatalogueFileMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CatalogueFile.size(); ++u32ListIdx)
      u32DynamicSize += CatalogueFile[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool cataloguefi_tclMsgGetCatalogueFileMethodResult::operator==(const cataloguefi_tclMsgGetCatalogueFileMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CatalogueFile.size() == rfoCmp.CatalogueFile.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CatalogueFile.size()); ++u32Idx)
            bResult = bResult && (CatalogueFile[u32Idx] == rfoCmp.CatalogueFile[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& cataloguefi_tclMsgGetCatalogueFileMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CatalogueFile.size(); ++u32Idx)
      {
         CatalogueFile[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CatalogueFile.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CatalogueFile[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& cataloguefi_tclMsgGetCatalogueFileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)CatalogueFile.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CatalogueFile.size(); ++u32Idx)
         oOut << CatalogueFile[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgGetFileContentMethodStart::cataloguefi_tclMsgGetFileContentMethodStart(const cataloguefi_tclMsgGetFileContentMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ContentFileHandle = coRef.ContentFileHandle;
   RowNumber = coRef.RowNumber;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgGetFileContentMethodStart& cataloguefi_tclMsgGetFileContentMethodStart::operator=(const cataloguefi_tclMsgGetFileContentMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ContentFileHandle = coRef.ContentFileHandle;
   RowNumber = coRef.RowNumber;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 cataloguefi_tclMsgGetFileContentMethodStart::u16GetServiceID() const {return CATALOGUEFI_C_U16_SERVICE_ID;}
tU16 cataloguefi_tclMsgGetFileContentMethodStart::u16GetFunctionID() const {return CATALOGUEFI_C_U16_GETFILECONTENT;}
tU8 cataloguefi_tclMsgGetFileContentMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 cataloguefi_tclMsgGetFileContentMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+4;
}

tBool cataloguefi_tclMsgGetFileContentMethodStart::operator==(const cataloguefi_tclMsgGetFileContentMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ContentFileHandle == rfoCmp.ContentFileHandle);
      bResult = bResult && (RowNumber == rfoCmp.RowNumber);
   return bResult;
}

fi_tclInContext& cataloguefi_tclMsgGetFileContentMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ContentFileHandle;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> RowNumber;
   }
   return oIn;
}

fi_tclOutContext& cataloguefi_tclMsgGetFileContentMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ContentFileHandle;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << RowNumber;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgGetFileContentMethodResult::cataloguefi_tclMsgGetFileContentMethodResult(const cataloguefi_tclMsgGetFileContentMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   File = coRef.File;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgGetFileContentMethodResult& cataloguefi_tclMsgGetFileContentMethodResult::operator=(const cataloguefi_tclMsgGetFileContentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   File = coRef.File;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 cataloguefi_tclMsgGetFileContentMethodResult::u16GetServiceID() const {return CATALOGUEFI_C_U16_SERVICE_ID;}
tU16 cataloguefi_tclMsgGetFileContentMethodResult::u16GetFunctionID() const {return CATALOGUEFI_C_U16_GETFILECONTENT;}
tU8 cataloguefi_tclMsgGetFileContentMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid cataloguefi_tclMsgGetFileContentMethodResult::vDestroy()
{
   File.vDestroy(); 
}

tU32 cataloguefi_tclMsgGetFileContentMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+File.u32GetSize(u16MajorVersion);
}

tBool cataloguefi_tclMsgGetFileContentMethodResult::operator==(const cataloguefi_tclMsgGetFileContentMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (File == rfoCmp.File);
   return bResult;
}

fi_tclInContext& cataloguefi_tclMsgGetFileContentMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> File;
   return oIn;
}

fi_tclOutContext& cataloguefi_tclMsgGetFileContentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << File;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFireActionMethodStart::cataloguefi_tclMsgFireActionMethodStart(const cataloguefi_tclMsgFireActionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ActionFileHandle = coRef.ActionFileHandle;
   ActEventSign = coRef.ActEventSign;
   NoOfFollowingParameters = coRef.NoOfFollowingParameters;
   ParamInput = coRef.ParamInput;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFireActionMethodStart& cataloguefi_tclMsgFireActionMethodStart::operator=(const cataloguefi_tclMsgFireActionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ActionFileHandle = coRef.ActionFileHandle;
   ActEventSign = coRef.ActEventSign;
   NoOfFollowingParameters = coRef.NoOfFollowingParameters;
   ParamInput = coRef.ParamInput;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 cataloguefi_tclMsgFireActionMethodStart::u16GetServiceID() const {return CATALOGUEFI_C_U16_SERVICE_ID;}
tU16 cataloguefi_tclMsgFireActionMethodStart::u16GetFunctionID() const {return CATALOGUEFI_C_U16_FIREACTION;}
tU8 cataloguefi_tclMsgFireActionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid cataloguefi_tclMsgFireActionMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ParamInput.size(); ++u32Idx)
         ParamInput[u32Idx].vDestroy();
   }
   ParamInput.clear();
}

tU32 cataloguefi_tclMsgFireActionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ParamInput.size(); ++u32ListIdx)
      u32DynamicSize += ParamInput[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool cataloguefi_tclMsgFireActionMethodStart::operator==(const cataloguefi_tclMsgFireActionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ActionFileHandle == rfoCmp.ActionFileHandle);
      bResult = bResult && (ActEventSign == rfoCmp.ActEventSign);
      bResult = bResult && (NoOfFollowingParameters == rfoCmp.NoOfFollowingParameters);
      bResult = bResult && (ParamInput.size() == rfoCmp.ParamInput.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ParamInput.size()); ++u32Idx)
            bResult = bResult && (ParamInput[u32Idx] == rfoCmp.ParamInput[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& cataloguefi_tclMsgFireActionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ActionFileHandle;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> ActEventSign;
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> NoOfFollowingParameters;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ParamInput.size(); ++u32Idx)
      {
         ParamInput[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ParamInput.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ParamInput[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& cataloguefi_tclMsgFireActionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ActionFileHandle;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << ActEventSign;
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << NoOfFollowingParameters;
   }
   oOut << (tU32)ParamInput.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ParamInput.size(); ++u32Idx)
         oOut << ParamInput[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFireActionMethodResult::cataloguefi_tclMsgFireActionMethodResult(const cataloguefi_tclMsgFireActionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   StatusEventSign = coRef.StatusEventSign;
   ActionStatus = coRef.ActionStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFireActionMethodResult& cataloguefi_tclMsgFireActionMethodResult::operator=(const cataloguefi_tclMsgFireActionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusEventSign = coRef.StatusEventSign;
   ActionStatus = coRef.ActionStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 cataloguefi_tclMsgFireActionMethodResult::u16GetServiceID() const {return CATALOGUEFI_C_U16_SERVICE_ID;}
tU16 cataloguefi_tclMsgFireActionMethodResult::u16GetFunctionID() const {return CATALOGUEFI_C_U16_FIREACTION;}
tU8 cataloguefi_tclMsgFireActionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 cataloguefi_tclMsgFireActionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+1;
}

tBool cataloguefi_tclMsgFireActionMethodResult::operator==(const cataloguefi_tclMsgFireActionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StatusEventSign == rfoCmp.StatusEventSign);
      bResult = bResult && (ActionStatus == rfoCmp.ActionStatus);
   return bResult;
}

fi_tclInContext& cataloguefi_tclMsgFireActionMethodResult::oRead(fi_tclInContext& oIn)
{
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> StatusEventSign;
   }
   oIn >> ActionStatus;
   return oIn;
}

fi_tclOutContext& cataloguefi_tclMsgFireActionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << StatusEventSign;
   }
   oOut << ActionStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFileSystemListenerUpReg::cataloguefi_tclMsgFileSystemListenerUpReg(const cataloguefi_tclMsgFileSystemListenerUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFileSystemListenerUpReg& cataloguefi_tclMsgFileSystemListenerUpReg::operator=(const cataloguefi_tclMsgFileSystemListenerUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 cataloguefi_tclMsgFileSystemListenerUpReg::u16GetServiceID() const {return CATALOGUEFI_C_U16_SERVICE_ID;}
tU16 cataloguefi_tclMsgFileSystemListenerUpReg::u16GetFunctionID() const {return CATALOGUEFI_C_U16_FILESYSTEMLISTENER;}
tU8 cataloguefi_tclMsgFileSystemListenerUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 cataloguefi_tclMsgFileSystemListenerUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool cataloguefi_tclMsgFileSystemListenerUpReg::operator==(const cataloguefi_tclMsgFileSystemListenerUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& cataloguefi_tclMsgFileSystemListenerUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& cataloguefi_tclMsgFileSystemListenerUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFileSystemListenerRelUpReg::cataloguefi_tclMsgFileSystemListenerRelUpReg(const cataloguefi_tclMsgFileSystemListenerRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFileSystemListenerRelUpReg& cataloguefi_tclMsgFileSystemListenerRelUpReg::operator=(const cataloguefi_tclMsgFileSystemListenerRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 cataloguefi_tclMsgFileSystemListenerRelUpReg::u16GetServiceID() const {return CATALOGUEFI_C_U16_SERVICE_ID;}
tU16 cataloguefi_tclMsgFileSystemListenerRelUpReg::u16GetFunctionID() const {return CATALOGUEFI_C_U16_FILESYSTEMLISTENER;}
tU8 cataloguefi_tclMsgFileSystemListenerRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 cataloguefi_tclMsgFileSystemListenerRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool cataloguefi_tclMsgFileSystemListenerRelUpReg::operator==(const cataloguefi_tclMsgFileSystemListenerRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& cataloguefi_tclMsgFileSystemListenerRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& cataloguefi_tclMsgFileSystemListenerRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFileSystemListenerStatus::cataloguefi_tclMsgFileSystemListenerStatus(const cataloguefi_tclMsgFileSystemListenerStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   EventSignature = coRef.EventSignature;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cataloguefi_tclMsgFileSystemListenerStatus& cataloguefi_tclMsgFileSystemListenerStatus::operator=(const cataloguefi_tclMsgFileSystemListenerStatus& coRef)
{
   if (this == &coRef) return *this;
   EventSignature = coRef.EventSignature;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 cataloguefi_tclMsgFileSystemListenerStatus::u16GetServiceID() const {return CATALOGUEFI_C_U16_SERVICE_ID;}
tU16 cataloguefi_tclMsgFileSystemListenerStatus::u16GetFunctionID() const {return CATALOGUEFI_C_U16_FILESYSTEMLISTENER;}
tU8 cataloguefi_tclMsgFileSystemListenerStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 cataloguefi_tclMsgFileSystemListenerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool cataloguefi_tclMsgFileSystemListenerStatus::operator==(const cataloguefi_tclMsgFileSystemListenerStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (EventSignature == rfoCmp.EventSignature);
   return bResult;
}

fi_tclInContext& cataloguefi_tclMsgFileSystemListenerStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> EventSignature;
   return oIn;
}

fi_tclOutContext& cataloguefi_tclMsgFileSystemListenerStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << EventSignature;
   return oOut;
}

