#ifndef CATALOGUEFILANGUAGE_HEADER
#define CATALOGUEFILANGUAGE_HEADER

class cataloguefi_tclInContext;
class cataloguefi_tclOutContext;
class cataloguefi_tclVisitorBase;

class MY_DECL cataloguefi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  cataloguefi_tclDescription(fi_tclInContext* poIn, cataloguefi_tclVisitorBase* poVisit);
  cataloguefi_tclDescription(fi_tclOutContext* poOut, cataloguefi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(cataloguefi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ cataloguefi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  cataloguefi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<cataloguefi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<cataloguefi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline cataloguefi_tclDescription::cataloguefi_tclDescription(fi_tclInContext* poIn, cataloguefi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline cataloguefi_tclDescription::cataloguefi_tclDescription(fi_tclOutContext* poOut, cataloguefi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

