#include "precompiled.hh"

tBool cataloguefi_tclDescription::bInitMessage(cataloguefi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case cataloguefi_tclToken::EN_LAST_TOKEN:
   case cataloguefi_tclToken::EN_LIST:
   case cataloguefi_tclToken::EN_END_OF_STRUCT:
   case cataloguefi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case cataloguefi_tclToken::EN_MSG_GETCATALOGUEFILEMETHODSTART:
   {
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_STRING,cataloguefi_tclSemanticDomain::EN_MSG_FILEPATH));
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_E8_FILETYPE,cataloguefi_tclSemanticDomain::EN_MSG_FILETYPE));
   } break;
   case cataloguefi_tclToken::EN_MSG_GETCATALOGUEFILEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_CATALOGUEFILES,cataloguefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_LIST,cataloguefi_tclSemanticDomain::EN_MSG_CATALOGUEFILE));
   } break;
   case cataloguefi_tclToken::EN_MSG_GETFILECONTENTMETHODSTART:
   {
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_S32,cataloguefi_tclSemanticDomain::EN_MSG_ROWNUMBER));
      }
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_MSG_CONTENTFILEHANDLE));
   } break;
   case cataloguefi_tclToken::EN_MSG_GETFILECONTENTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_FILECONTENTS,cataloguefi_tclSemanticDomain::EN_MSG_FILE));
   } break;
   case cataloguefi_tclToken::EN_MSG_FIREACTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_FILECONTENTS,cataloguefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_LIST,cataloguefi_tclSemanticDomain::EN_MSG_PARAMINPUT));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_MSG_NOOFFOLLOWINGPARAMETERS));
      }
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_MSG_ACTEVENTSIGN));
      }
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_MSG_ACTIONFILEHANDLE));
   } break;
   case cataloguefi_tclToken::EN_MSG_FIREACTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_E8_STATUS,cataloguefi_tclSemanticDomain::EN_MSG_ACTIONSTATUS));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_MSG_STATUSEVENTSIGN));
      }
   } break;
   case cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERSTATUS:
   {
      bResult &= oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_MSG_EVENTSIGNATURE));
   } break;
   case cataloguefi_tclToken::EN_RESERVED:
   case cataloguefi_tclToken::EN_BINCONTAINER:
   case cataloguefi_tclToken::EN_E8_FILETYPE:
   case cataloguefi_tclToken::EN_E8_STATUS:
   case cataloguefi_tclToken::EN_E8_TYPEOFFILE:
   case cataloguefi_tclToken::EN_FILECONTENTS:
   case cataloguefi_tclToken::EN_FILECONTENTSUNION0:
   case cataloguefi_tclToken::EN_CATALOGUEFILES:
   case cataloguefi_tclToken::EN_DIRECTORY:
   case cataloguefi_tclToken::EN_UTSTRING:
   case cataloguefi_tclToken::EN_UTINT:
   case cataloguefi_tclToken::EN_UTUINT:
   case cataloguefi_tclToken::EN_UTLISTMODEL:
   case cataloguefi_tclToken::EN_UTLISTSELECTIONMODEL:
   case cataloguefi_tclToken::EN_UTMESSAGE:
   case cataloguefi_tclToken::EN_UTCCAMESSAGE:
   case cataloguefi_tclToken::EN_UTACTION:
   case cataloguefi_tclToken::EN_UTBOOL:
   case cataloguefi_tclToken::EN_U8:   
   case cataloguefi_tclToken::EN_S8:   
   case cataloguefi_tclToken::EN_U16:   
   case cataloguefi_tclToken::EN_S16:   
   case cataloguefi_tclToken::EN_U24:   
   case cataloguefi_tclToken::EN_S24:   
   case cataloguefi_tclToken::EN_U32:   
   case cataloguefi_tclToken::EN_S32:   
   case cataloguefi_tclToken::EN_U64:   
   case cataloguefi_tclToken::EN_S64:   
   case cataloguefi_tclToken::EN_F32:   
   case cataloguefi_tclToken::EN_F64:   
   case cataloguefi_tclToken::EN_BOOL:   
   case cataloguefi_tclToken::EN_STRING:   
   case cataloguefi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(cataloguefi_tclKnot(enMsgToken,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool cataloguefi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool cataloguefi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      cataloguefi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      cataloguefi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      cataloguefi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == cataloguefi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(cataloguefi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(cataloguefi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(cataloguefi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case cataloguefi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == cataloguefi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            cataloguefi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(cataloguefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            cataloguefi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(cataloguefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case cataloguefi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case cataloguefi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case cataloguefi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case cataloguefi_tclToken::EN_MSG_GETCATALOGUEFILEMETHODSTART:
   case cataloguefi_tclToken::EN_MSG_GETCATALOGUEFILEMETHODRESULT:
   case cataloguefi_tclToken::EN_MSG_GETFILECONTENTMETHODSTART:
   case cataloguefi_tclToken::EN_MSG_GETFILECONTENTMETHODRESULT:
   case cataloguefi_tclToken::EN_MSG_FIREACTIONMETHODSTART:
   case cataloguefi_tclToken::EN_MSG_FIREACTIONMETHODRESULT:
   case cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERUPREG:
   case cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERRELUPREG:
   case cataloguefi_tclToken::EN_MSG_FILESYSTEMLISTENERSTATUS:
      bInitMessage(enToken);
      break;
   case cataloguefi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case cataloguefi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U8,cataloguefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_LIST,cataloguefi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_E8_FILETYPE:
   {
      fi_tcl_e8_FileType o_e8_FileType;
      if (!bDoIt(o_e8_FileType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case cataloguefi_tclToken::EN_E8_STATUS:
   {
      fi_tcl_e8_Status o_e8_Status;
      if (!bDoIt(o_e8_Status))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case cataloguefi_tclToken::EN_E8_TYPEOFFILE:
   {
      fi_tcl_e8_TypeOfFile o_e8_TypeOfFile;
      if (!bDoIt(o_e8_TypeOfFile))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case cataloguefi_tclToken::EN_FILECONTENTSUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_TypeOfFile oDataType;
      oCallStack.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_E8_TYPEOFFILE,cataloguefi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_TypeOfFile::FI_EN_T_RESERVED:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_RESERVED,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_DIRECTORY:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_DIRECTORY,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTSTRING:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_UTSTRING,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTINT:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_UTINT,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTUINT:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_UTUINT,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTMODEL:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_UTLISTMODEL,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTLISTSELECTIONMODEL:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_UTLISTSELECTIONMODEL,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTMESSAGE:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_UTMESSAGE,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTCCAMESSAGE:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_UTCCAMESSAGE,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTACTION:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_UTACTION,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      case fi_tcl_e8_TypeOfFile::FI_EN_T_UTBOOL:
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_UTBOOL,cataloguefi_tclSemanticDomain::EN_FILETYPE));
         break;
      }
   } break;
   case cataloguefi_tclToken::EN_FILECONTENTS:
   {
      if (poVisitor->bDoExpand_FileContents(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_FILECONTENTSUNION0,cataloguefi_tclSemanticDomain::EN_FILETYPE));
      }
      else
      {
         fi_tcl_FileContents o_FileContents;
         if (!bDoIt(o_FileContents))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FileContents.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FileContents.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_CATALOGUEFILES:
   {
      if (poVisitor->bDoExpand_CatalogueFiles(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_FILECONTENTS,cataloguefi_tclSemanticDomain::EN_CONTENTS));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_CATALOGUEFILEHANDLE));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_EVENTSIGNATURE));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_STRING,cataloguefi_tclSemanticDomain::EN_CATALOGUEFILENAME));
      }
      else
      {
         fi_tcl_CatalogueFiles o_CatalogueFiles;
         if (!bDoIt(o_CatalogueFiles))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CatalogueFiles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CatalogueFiles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_DIRECTORY:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case cataloguefi_tclToken::EN_UTSTRING:
   {
      if (poVisitor->bDoExpand_UTString(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_STRING,cataloguefi_tclSemanticDomain::EN_STRINGVALUE));
      }
      else
      {
         fi_tcl_UTString o_UTString;
         if (!bDoIt(o_UTString))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_UTINT:
   {
      if (poVisitor->bDoExpand_UTInt(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_S32,cataloguefi_tclSemanticDomain::EN_UTINTVALUE));
      }
      else
      {
         fi_tcl_UTInt o_UTInt;
         if (!bDoIt(o_UTInt))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTInt.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTInt.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_UTUINT:
   {
      if (poVisitor->bDoExpand_UTUInt(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_UTUINTVALUE));
      }
      else
      {
         fi_tcl_UTUInt o_UTUInt;
         if (!bDoIt(o_UTUInt))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTUInt.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTUInt.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_UTLISTMODEL:
   {
      if (poVisitor->bDoExpand_UTListModel(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_STRING,cataloguefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_LIST,cataloguefi_tclSemanticDomain::EN_UTLISTVALUE));
         if (3 <= u16MajorVersion)
         {
            oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_LISTROWCOUNT));
         }
      }
      else
      {
         fi_tcl_UTListModel o_UTListModel;
         if (!bDoIt(o_UTListModel))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTListModel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTListModel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_UTLISTSELECTIONMODEL:
   {
      if (poVisitor->bDoExpand_UTListSelectionModel(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_STRING,cataloguefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_LIST,cataloguefi_tclSemanticDomain::EN_UTLISTSELECTIONVALUE));
         if (3 <= u16MajorVersion)
         {
            oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_LISTSELROWCOUNT));
         }
      }
      else
      {
         fi_tcl_UTListSelectionModel o_UTListSelectionModel;
         if (!bDoIt(o_UTListSelectionModel))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTListSelectionModel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTListSelectionModel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_UTMESSAGE:
   {
      if (poVisitor->bDoExpand_UTMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_NOTDEFINED));
      }
      else
      {
         fi_tcl_UTMessage o_UTMessage;
         if (!bDoIt(o_UTMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_UTCCAMESSAGE:
   {
      if (poVisitor->bDoExpand_UTCCAMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_U32,cataloguefi_tclSemanticDomain::EN_TOBEDEFINED));
      }
      else
      {
         fi_tcl_UTCCAMessage o_UTCCAMessage;
         if (!bDoIt(o_UTCCAMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTCCAMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTCCAMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_UTACTION:
   {
      if (poVisitor->bDoExpand_UTAction(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_STRING,cataloguefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_LIST,cataloguefi_tclSemanticDomain::EN_UTACTIONPARAMETERS));
      }
      else
      {
         fi_tcl_UTAction o_UTAction;
         if (!bDoIt(o_UTAction))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTAction.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTAction.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case cataloguefi_tclToken::EN_UTBOOL:
   {
      if (poVisitor->bDoExpand_UTBool(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_END_OF_STRUCT,cataloguefi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(cataloguefi_tclKnot(cataloguefi_tclToken::EN_BOOL,cataloguefi_tclSemanticDomain::EN_UTBOOLVALUE));
      }
      else
      {
         fi_tcl_UTBool o_UTBool;
         if (!bDoIt(o_UTBool))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTBool.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTBool.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case cataloguefi_tclToken::EN_UNKNOWN:
      case cataloguefi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

