#ifndef gm_messages_h
#define gm_messages_h 1

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

class ahl_tclStreamableType;
class ahl_tclStreamer;


//##ModelId=3BA1E8980312
class gm_tclEmptyMessage : public amt_tclServiceData
{
  public:
      //##ModelId=3BA1E9100148
      gm_tclEmptyMessage (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU8 u8ACT = 0, tU16 u16SourceSub = 0, tU16 u16TargetSub = 0);

      //##ModelId=3BA1E98B034D
      gm_tclEmptyMessage (amt_tclServiceData* poServiceData);

      // deep copy constructor
      //##ModelId=3C04A3EA0022
      gm_tclEmptyMessage (const gm_tclEmptyMessage& roInMessage);


      //##ModelId=3C04A85F00C3
      gm_tclEmptyMessage& operator = (const gm_tclEmptyMessage& roEmptyMessage);

      //##ModelId=3C04AB21017C
      virtual amt_tclMappableMessage* poClone () const
      {
         return new gm_tclEmptyMessage(*this);
      }

};

//##ModelId=3BA1FF930034
class gm_tclU8Message : public amt_tclServiceData
{
  public:
      //##ModelId=3BA200A3039C
      gm_tclU8Message (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU8 u8ACT = 0);

      //##ModelId=3BA200A303B0
      gm_tclU8Message (amt_tclServiceData* poServiceData);

      // deep copy constructor
      //##ModelId=3C04CF2801CE
      gm_tclU8Message (const gm_tclU8Message& roInMessage);


      //##ModelId=3C04CF28025B
      gm_tclU8Message& operator = (const gm_tclU8Message& roU8Message);

      //##ModelId=3C04CF280283
      virtual amt_tclMappableMessage* poClone () const
      {
         return new gm_tclU8Message(*this);
      }

      //##ModelId=3BA202420302
      tVoid vSetByte (tU8 u8ByteIn)
      {
        _u8Byte.vSetValue(this,u8ByteIn);
      }

      //##ModelId=3BA2025401A0
      tU8 u8GetByte () const
      {
        return _u8Byte.nGetValue(this);
      }

  private:
    // Data Members for Class Attributes


      amt_tclMU8 _u8Byte;

};

//##ModelId=3BC4445C0075
class gm_tclU16Message : public amt_tclServiceData
{
  public:
      //##ModelId=3BC445790089
      gm_tclU16Message (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU8 u8ACT = 0);

      //##ModelId=3BC44579009D
      gm_tclU16Message (amt_tclServiceData* poServiceData);

      // deep copy constructor
      //##ModelId=3C04B0650207
      gm_tclU16Message (const gm_tclU16Message& roInMessage);


      //##ModelId=3C04B065021B
      gm_tclU16Message& operator = (const gm_tclU16Message& roU16Message);

      //##ModelId=3C04B065022F
      virtual amt_tclMappableMessage* poClone () const
      {
         return new gm_tclU16Message(*this);
      }

      //##ModelId=3BC4457900A7
      tVoid vSetWord (tU16 u16WordIn)
      {
         _u16Word.vSetValue(this,u16WordIn);
      }

      //##ModelId=3BC4457900B1
      tU16 u16GetWord () const
      {
         return _u16Word.nGetValue(this);
      }

  private:
    // Data Members for Class Attributes


      amt_tclMU16 _u16Word;

};

//##ModelId=3BC59292011F
class gm_tclU32Message : public amt_tclServiceData
{
  public:
      //##ModelId=3BC592B90021
      gm_tclU32Message (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU8 u8ACT = 0, tU16 u16SourceSub = 0, tU16 u16TargetSub = 0);

      //##ModelId=3BC592B9002B
      gm_tclU32Message (amt_tclServiceData* poServiceData);

      // deep copy constructor
      //##ModelId=3C04CF4C0112
      gm_tclU32Message (const gm_tclU32Message& roInMessage);


      //##ModelId=3C04CF4C0130
      gm_tclU32Message& operator = (const gm_tclU32Message& roU32Message);

      //##ModelId=3C04CF4C014E
      virtual amt_tclMappableMessage* poClone () const
      {
         return new gm_tclU32Message(*this);
      }

      //##ModelId=3BC592B90035
      tVoid vSetDWord (tU32 u32DWordIn)
      {
         _u32DWord.vSetValue(this,u32DWordIn);
      }

      //##ModelId=3BC592B90049
      tU32 u32GetDWord () const
      {
         return _u32DWord.nGetValue(this);
      }

  private:
    // Data Members for Class Attributes


      amt_tclMU32 _u32DWord;

};

//##ModelId=3BE8F7DA011A

class gm_tclStreamMessage : public amt_tclServiceData
{
  public:
      //##ModelId=3BE8F8910312
      gm_tclStreamMessage (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU32 u32DataSize, tU8 u8ACT = 0);

      //##ModelId=3BE8F891031C
      gm_tclStreamMessage (amt_tclServiceData* poServiceData);

      // deep copy constructor
      //##ModelId=3C04CF4101CA
      gm_tclStreamMessage (const gm_tclStreamMessage& roInMessage);

      //##ModelId=3DB00F7303CC
      gm_tclStreamMessage (ahl_tclStreamer &roInStream, tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU16 u16DataSize, tU8 u8ACT = 0);


      //##ModelId=3C04CF4101F2
      gm_tclStreamMessage& operator = (const gm_tclStreamMessage& roStreamMessage);

      //##ModelId=3C04CF410210
      virtual amt_tclMappableMessage* poClone () const
      {
         return new gm_tclStreamMessage(*this);
      }

      //##ModelId=3BE8F9660160
      const tChar* pcocGetData () const
      {
         return _oStream.pcocGetData((const amt_tclMappableMessage*)this);
      }

      //##ModelId=3D5B909D02CF
      tChar* pcGetDataRegion ();

      //##ModelId=3BE8F9A502E7
      tU32 u32GetDataSize () const
      {
         return _oStream.u32GetSizeOfType();
      }

      //##ModelId=3BE8F9AD0270
      tVoid vSetData (const tChar* pcocData);

  private:
    // Data Members for Associations


      gm_tclMStream _oStream;

};

//##ModelId=3E26B05B02CC

class gm_tclStreamableTypeMessage : public gm_tclStreamMessage
{
  public:
      //##ModelId=3E26B05E03AA
      gm_tclStreamableTypeMessage (amt_tclServiceData* poServiceData);

      //##ModelId=3E26B05E03AE
      gm_tclStreamableTypeMessage (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, ahl_tclStreamableType &rfoStreamableType, tU8 u8ACT = 0);


      //##ModelId=3E26B05E03B8
      gm_tclStreamableTypeMessage& operator = (const gm_tclStreamableTypeMessage& rfoStreamableTypeMessage);

};


#endif
