#define  AHL_S_IMPORT_INTERFACE_STREAMER
#include "ahl_if.h"
#define AHL_S_IMPORT_INTERFACE_STREAMABLETYPES
#include "ahl_if.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"



// Class gm_tclEmptyMessage 


gm_tclEmptyMessage::gm_tclEmptyMessage (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU8 u8ACT, tU16 u16SourceSub, tU16 u16TargetSub)
{
   if(TRUE == bAllocateMessage())
   {
      vInitServiceData (u16Source, u16Target,           // Source, Target
                        AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
                        0,                              // StreamCounter
                        u16RegID,                       // RegisterID
                        u16CmdCounter,                  // nCmdCounter, 
                        u16SvcID,                       // nServiceID, 
                        u16FktID,u8OpCode,u8ACT, u16SourceSub, u16TargetSub); 
   }
   
}

gm_tclEmptyMessage::gm_tclEmptyMessage (amt_tclServiceData* poServiceData)
    : amt_tclServiceData(poServiceData)
{
}

gm_tclEmptyMessage::gm_tclEmptyMessage (const gm_tclEmptyMessage& roInMessage)
:amt_tclServiceData(roInMessage)
{
   // allocate Message
   if(TRUE == bAllocateMessage())
   {
      // copy all elements with operator=
      *this = roInMessage;
   }
}



gm_tclEmptyMessage& gm_tclEmptyMessage::operator = (const gm_tclEmptyMessage& roEmptyMessage)
{
   if (this == &roEmptyMessage)
   {
      return *this;
   }

   // assign header elements
   amt_tclServiceData::operator=(roEmptyMessage);
   // no specific elements to assign


   return *this;
}

// Class gm_tclU8Message 


gm_tclU8Message::gm_tclU8Message (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU8 u8ACT)
{
   vAddType(&_u8Byte);

   if(TRUE == bAllocateMessage())
   {
      vInitServiceData (u16Source, u16Target,           // Source, Target
                        AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
                        0,                              // StreamCounter
                        u16RegID,                       // RegisterID
                        u16CmdCounter,                  // nCmdCounter, 
                        u16SvcID,                       // nServiceID, 
                        u16FktID,u8OpCode,u8ACT); 
   }
}

gm_tclU8Message::gm_tclU8Message (amt_tclServiceData* poServiceData)
    : amt_tclServiceData(poServiceData)
{
   vAddType(&_u8Byte);
}

gm_tclU8Message::gm_tclU8Message (const gm_tclU8Message& roInMessage)
:amt_tclServiceData(roInMessage)
{
   vAddType(&_u8Byte);

   // allocate Message
   if(TRUE == bAllocateMessage())
   {
      // copy all elements with operator=
      *this = roInMessage;
   }
}



gm_tclU8Message& gm_tclU8Message::operator = (const gm_tclU8Message& roU8Message)
{
   if (this == &roU8Message)
   {
      return *this;
   }

   // assign header elements
   amt_tclServiceData::operator=(roU8Message);
   // assing specific elements
   vSetByte(roU8Message.u8GetByte());
   
   return *this;
}

// Class gm_tclU16Message 


gm_tclU16Message::gm_tclU16Message (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU8 u8ACT)
{
   vAddType(&_u16Word);
   if(TRUE == bAllocateMessage())
   {
      vInitServiceData (u16Source, u16Target,           // Source, Target
                        AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
                        0,                              // StreamCounter
                        u16RegID,                       // RegisterID
                        u16CmdCounter,                  // nCmdCounter, 
                        u16SvcID,                       // nServiceID, 
                        u16FktID,u8OpCode,u8ACT); 
   }
}

gm_tclU16Message::gm_tclU16Message (amt_tclServiceData* poServiceData)
  : amt_tclServiceData(poServiceData)
{
   vAddType(&_u16Word);
}

gm_tclU16Message::gm_tclU16Message (const gm_tclU16Message& roInMessage)
:amt_tclServiceData(roInMessage)
{
   vAddType(&_u16Word);

   // allocate Message
   if(TRUE == bAllocateMessage())
   {
      // copy all elements with operator=
      *this = roInMessage;
   }
}



gm_tclU16Message& gm_tclU16Message::operator = (const gm_tclU16Message& roU16Message)
{
   if (this == &roU16Message)
   {
      return *this;
   }

   // assign header elements
   amt_tclServiceData::operator=(roU16Message);
   // assing specific elements
   vSetWord(roU16Message.u16GetWord());

   return *this;
}

// Class gm_tclU32Message 


gm_tclU32Message::gm_tclU32Message (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU8 u8ACT, tU16 u16SourceSub, tU16 u16TargetSub)
{
   vAddType(&_u32DWord);
   if(TRUE == bAllocateMessage())
   {
      vInitServiceData (u16Source, u16Target,           // Source, Target
                        AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
                        0,                              // StreamCounter
                        u16RegID,                       // RegisterID
                        u16CmdCounter,                  // nCmdCounter, 
                        u16SvcID,                       // nServiceID, 
                        u16FktID,u8OpCode,u8ACT, u16SourceSub, u16TargetSub); 
   }
}

gm_tclU32Message::gm_tclU32Message (amt_tclServiceData* poServiceData)
  : amt_tclServiceData(poServiceData)
{
   vAddType(&_u32DWord);
}

gm_tclU32Message::gm_tclU32Message (const gm_tclU32Message& roInMessage)
:amt_tclServiceData(roInMessage)
{
   vAddType(&_u32DWord);

   if(TRUE == bAllocateMessage())
   {
      // copy all elements with operator=
      *this = roInMessage;
   }
}



gm_tclU32Message& gm_tclU32Message::operator = (const gm_tclU32Message& roU32Message)
{
   if (this == &roU32Message)
   {
      return *this;
   }

   // assign header elements
   amt_tclServiceData::operator=(roU32Message);
   // assing specific elements
   vSetDWord(roU32Message.u32GetDWord());
   
   return *this;
}

// Class gm_tclStreamMessage 


gm_tclStreamMessage::gm_tclStreamMessage (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU32 u32DataSize, tU8 u8ACT)
{
   _oStream.vSetTypeSize(u32DataSize);
   vAddType(&_oStream);
   
   if(TRUE == bAllocateMessage())
   {
      vInitServiceData (u16Source, u16Target,           // Source, Target
                        AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
                        0,                              // StreamCounter
                        u16RegID,                       // RegisterID
                        u16CmdCounter,                  // nCmdCounter, 
                        u16SvcID,                       // nServiceID, 
                        u16FktID,u8OpCode,u8ACT); 
   }
}

gm_tclStreamMessage::gm_tclStreamMessage (amt_tclServiceData* poServiceData)
  : amt_tclServiceData(poServiceData)
{
   _oStream.vRetrieveDataSize(this,this->u32GetSize());
   vAddType(&_oStream);
}

gm_tclStreamMessage::gm_tclStreamMessage (const gm_tclStreamMessage& roInMessage)
:amt_tclServiceData(roInMessage)
{
   _oStream.vSetTypeSize(roInMessage.u32GetDataSize());
   vAddType(&_oStream);

   if(TRUE == bAllocateMessage())
   {
      // copy all elements with operator=
      *this = roInMessage;
   }
}

gm_tclStreamMessage::gm_tclStreamMessage (ahl_tclStreamer &roInStream, tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, tU16 u16DataSize, tU8 u8ACT)
{
   
   _oStream.vSetTypeSize(u16DataSize);
   vAddType(&_oStream);
   
   if(TRUE == bAllocateMessage())
   {
      vInitServiceData (u16Source, u16Target,           // Source, Target
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
         0,                              // StreamCounter
         u16RegID,                       // RegisterID
         u16CmdCounter,                  // nCmdCounter, 
         u16SvcID,                       // nServiceID, 
         u16FktID,u8OpCode,u8ACT); 

      vSetData(roInStream.pGetStream());
   }
}



gm_tclStreamMessage& gm_tclStreamMessage::operator = (const gm_tclStreamMessage& roStreamMessage)
{
   if (this == &roStreamMessage)
   {
      return *this;
   }

   // assign header elements
   amt_tclServiceData::operator=(roStreamMessage);
   
   // assing specific elements
   vSetData(roStreamMessage.pcocGetData());
   
   return *this;
}

tChar* gm_tclStreamMessage::pcGetDataRegion ()
{
   tChar* pcDataRegion = (tChar*)pu8GetSharedMemBase() +
      AMT_C_U32_BASEMSG_ABSMSGSIZE + AMT_C_U32_SVCDATA_RELMSGSIZE;
   return pcDataRegion;
}

tVoid gm_tclStreamMessage::vSetData (const tChar* pcocData)
{
   if (_oStream.u32GetSizeOfType() != 0) 
   {
      _oStream.vSetData(this,pcocData);
   }
}

// Class gm_tclStreamableTypeMessage 


gm_tclStreamableTypeMessage::gm_tclStreamableTypeMessage (amt_tclServiceData* poServiceData)
  :gm_tclStreamMessage(poServiceData)
{
}

gm_tclStreamableTypeMessage::gm_tclStreamableTypeMessage (tU16 u16Source, tU16 u16Target, tU16 u16RegID, tU16 u16CmdCounter, tU16 u16SvcID, tU16 u16FktID, tU8 u8OpCode, ahl_tclStreamableType &rfoStreamableType, tU8 u8ACT)
  :gm_tclStreamMessage(u16Source,u16Target,u16RegID,u16CmdCounter,u16SvcID,u16FktID,u8OpCode,rfoStreamableType.u16GetStreamSize(),u8ACT)
{
   if(TRUE == bIsValid())
   {
      ahl_tclListStreamer oSharedMemStream;
      oSharedMemStream.vSetStreamBuffer(pcGetDataRegion(),rfoStreamableType.u16GetStreamSize(),0);

      oSharedMemStream << rfoStreamableType;
   }
}



gm_tclStreamableTypeMessage& gm_tclStreamableTypeMessage::operator = (const gm_tclStreamableTypeMessage& rfoStreamableTypeMessage)
{
   if (this == &rfoStreamableTypeMessage)
   {
      return *this;
   }

   gm_tclStreamMessage::operator = (rfoStreamableTypeMessage);
   return *this;
}

