/******************************************************************************
* $Revision:   1.11  $
* $Date:   Nov 19 2003 14:11:30  $
* A changelog can be found at the end of this file
*******************************************************************************
* FILE:         et_Trace.h
* PROJECT:      ELeNa
*------------------------------------------------------------------------------
* DESCRIPTION:  elena trace macros
*------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2001 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      |   Modification       | Author
* 23.05.01  |   K7/EPE     Perick  | initial version
* 13.12.01  |   CM-CR/EES4 Perick  | format string extension 
* 13.06.02  |   CM-CR/EES4 Perick  | add ( #define _ , )
*           |                      | It is possible to use variable number of
*           |                      | parametre in formated strings, now. 
*           |                      | Attention: You must use a special syntax. 
*           |                      | The blanks between the parameter and the 
*           |                      | underlines are essential.
*           |                      | ET_TRACE_INFO(0, "hello %d %d %d %d" _ 1 _ 2 _ 3 _ 4); 
* 15.08.03  |   CM-CR/EES4 Perick  | add errmem handling
*               
******************************************************************************/


#ifndef _ET_TRACE_H
#define _ET_TRACE_H

/* trace settings ---------------------------------------------------------- */
// this defines can be spcified in the configuration to generally enable trace compiling
//#define ET_TRACE_WARNING_ON
//#define ET_TRACE_INFO_ON



/* includes ---------------------------------------------------------------- */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//#define _ , 
#if !defined(SPM_UNIT_TESTS) && !defined(_DONT_DEFINE_UNDERSCORE_AS_COMMA_)
#define _ , 
#endif


enum et_enTraceType
{
   // Marker for the end of the list
   ET_EN_DONE,

   // Insert a 8-bit value into the trace buffer:
   // ..., ET_EN_T8, u8Value, ...
   ET_EN_T8,
   // Insert a sequence of 8-bit values into the trace buffer:
   // ..., ET_EN_T8LIST, nEntries, ps8PointerToValues, ...
   ET_EN_T8LIST,

   // Insert a 16-bit value into the trace buffer (in big-endian format):
   // ..., ET_EN_T16, u16Value, ...
   ET_EN_T16,
   // Insert a sequence of 16-bit values into the trace buffer (each in
   // big-endian format):
   // ..., ET_EN_T16LIST, nEntries, ps16PointerToValues, ...
   ET_EN_T16LIST,

   // Insert a 32-bit value into the trace buffer (in big-endian format):
   // ..., ET_EN_T32, u32Value, ...
   ET_EN_T32,
   // Insert a sequence of 32-bit values into the trace buffer (each in
   // big-endian format):
   // ..., ET_EN_T32LIST, nEntries, ps32PointerToValues, ...
   ET_EN_T32LIST,

   // Insert a zero-terminated string into the trace buffer.
   // For cleartext interpretation, it usually makes sense to only insert
   // one single string, and to insert it as the last element into the
   // trace buffer.
   // ..., ET_EN_STRING, szValue, ...
   ET_EN_STRING
};


/* trace defines ----------------------------------------------------------- */
#define ET_TRACE_BIN(u16CompId, u16Level, pcBuffer) \
{ if (et_bIsTraceActive(u16CompId, (tU16)u16Level) == TRUE) \
      et_vTraceBinary(u16CompId, (tU16)u16Level, pcBuffer); \
}

#define ET_TRACE_ERROR_BIN(u16CompId, pcBuffer) \
{ if (et_bIsTraceActive(u16CompId, (tU16)TR_LEVEL_ERRORS) == TRUE) \
      et_vTraceBinary(u16CompId, (tU16)TR_LEVEL_ERRORS, pcBuffer); \
}

#define ET_TRACE_WARNING_BIN(u16CompId, pcBuffer) \
{ if (et_bIsTraceActive(u16CompId, (tU16)TR_LEVEL_COMPONENT) == TRUE) \
      et_vTraceBinary(u16CompId, (tU16)TR_LEVEL_COMPONENT, pcBuffer); \
}

#define ET_TRACE_INFO_BIN(u16CompId, pcBuffer) \
{ if (et_bIsTraceActive(u16CompId, (tU16)TR_LEVEL_USER_1) == TRUE) \
      et_vTraceBinary(u16CompId, (tU16)TR_LEVEL_USER_1, pcBuffer); \
}

#define ET_TRACE_INFO_BIN_C_WRAPPER(u16CompId, pcBuffer) \
{ if (et_bIsTraceActiveCWrapper(u16CompId, (tU16)TR_LEVEL_USER_1) == TRUE) \
      et_vTraceBinaryCWrapper(u16CompId, (tU16)TR_LEVEL_USER_1, pcBuffer); \
}

#define ET_TRACE( u16CompId, u16Level, pcBuffer)     (et_vTrace(u16CompId, (tU16)u16Level, pcBuffer))

#define ET_TRACE_ERROR( u16CompId, pcBuffer)   (et_vTrace(u16CompId, (tU16)TR_LEVEL_ERRORS, pcBuffer))
#define ET_TRACE_ERROR1( u16CompId, pcBuffer, a1) (et_vTrace(u16CompId, (tU16)TR_LEVEL_ERRORS, pcBuffer, a1))
#define ET_TRACE_ERROR2( u16CompId, pcBuffer, a1, a2) (et_vTrace(u16CompId, (tU16)TR_LEVEL_ERRORS, pcBuffer, a1, a2))
#define ET_TRACE_ERROR3( u16CompId, pcBuffer, a1, a2, a3) (et_vTrace(u16CompId, (tU16)TR_LEVEL_ERRORS, pcBuffer, a1, a2, a3))


#ifdef ET_TRACE_WARNING_ON
  #define ET_TRACE_WARNING( u16CompId, pcBuffer) (et_vTrace(u16CompId, (tU16)TR_LEVEL_COMPONENT, pcBuffer))
  #define ET_TRACE_WARNING1( u16CompId, pcBuffer, a1) (et_vTrace(u16CompId, (tU16)TR_LEVEL_COMPONENT, pcBuffer, a1))
  #define ET_TRACE_WARNING2( u16CompId, pcBuffer, a1, a2) (et_vTrace(u16CompId, (tU16)TR_LEVEL_COMPONENT, pcBuffer, a1, a2))
  #define ET_TRACE_WARNING3( u16CompId, pcBuffer, a1, a2, a3) (et_vTrace(u16CompId, (tU16)TR_LEVEL_COMPONENT, pcBuffer, a1, a2, a3))
#endif

#ifndef ET_TRACE_WARNING_ON
  #define ET_TRACE_WARNING( u16CompId, pcBuffer)
  #define ET_TRACE_WARNING1( u16CompId, pcBuffer, a1)
  #define ET_TRACE_WARNING2( u16CompId, pcBuffer, a1, a2)
  #define ET_TRACE_WARNING3( u16CompId, pcBuffer, a1, a2, a3)  
#endif

#ifdef ET_TRACE_INFO_ON
  #define ET_TRACE_INFO( u16CompId, pcBuffer)     (et_vTrace(u16CompId, (tU16)TR_LEVEL_USER_1, pcBuffer))
  #define ET_TRACE_INFO1( u16CompId, pcBuffer, a1) (et_vTrace(u16CompId, (tU16)TR_LEVEL_USER_1, pcBuffer, a1))
  #define ET_TRACE_INFO2( u16CompId, pcBuffer, a1, a2) (et_vTrace(u16CompId, (tU16)TR_LEVEL_USER_1, pcBuffer, a1, a2))
  #define ET_TRACE_INFO3( u16CompId, pcBuffer, a1, a2, a3) (et_vTrace(u16CompId, (tU16)TR_LEVEL_USER_1, pcBuffer, a1, a2, a3))
#endif

#ifndef ET_TRACE_INFO_ON
  #define ET_TRACE_INFO( u16CompId, pcBuffer) 
  #define ET_TRACE_INFO1( u16CompId, pcBuffer, a1)
  #define ET_TRACE_INFO2( u16CompId, pcBuffer, a1, a2) 
  #define ET_TRACE_INFO3( u16CompId, pcBuffer, a1, a2, a3) 
#endif

#ifdef ET_TRACE_BUFFER_ON
  #define ET_TRACE_BUFFER( u16CompId, u32Length, pcBuffer) (et_vTraceBuffer(u16CompId, (tU16)TR_LEVEL_USER_1, u32Length, pcBuffer))
#endif

#ifndef ET_TRACE_BUFFER_ON
  #define ET_TRACE_BUFFER( u16CompId, u32Length, pcBuffer)
#endif

#define ET_TRACE_OPEN  (tVoid)et_vTraceOpen()
#define ET_TRACE_CLOSE et_vTraceClose()

#define ET_ERRMEM_NORMAL_STRING(u16Entry, pcBuffer) (et_vErrmemStringNormal(u16Entry, "%s", pcBuffer))
#define ET_ERRMEM_INFO_STRING(u16Entry, pcBuffer) (et_vErrmemString(u16Entry, eErrmemEntryInfo, "%s", pcBuffer))



/* prototypes -------------------------------------------------------------- */

#ifdef __cplusplus
extern "C"
{
#endif

 tBool et_vTraceOpen(tVoid);
 tBool et_bIsTraceActive(tU16 u16CompID, tU16 u16LevelId);
 tVoid et_vTrace(tU16 u16CompId, tU16 u16LevelId, const tChar* pcBuffer, ...);
 tVoid et_vTraceBuffer(tU16 u16CompId, tU16 u16LevelId, tU32 u32Length, const tChar* pcBuffer);
 tVoid et_vTraceBinary(tU16 u16CompID, tU16 u16LevelId, ...); //lint !e579  /*Review happened by Grosse-Pawig*/
 tVoid et_vTraceClose(tVoid);
 tVoid et_vErrmemStringNormal(tU16 u16Entry, const tChar* pcFormat, ...);
 tVoid et_vErrmemString(tU16 u16Entry, tenErrmemEntryType eType, const tChar* pcFormat, ...);
 
 tBool et_bIsTraceActiveCWrapper(tU16 u16CompID, tU16 u16LevelId);
 tVoid et_vTraceBinaryCWrapper(tU16 u16CompID, tU16 u16LevelId, ...); //lint !e579  /*Review happened by Grosse-Pawig*/

#ifdef __cplusplus
}
#endif


/*
 * $Log:   //hi230124/projects/Vasco/swnavi/archives/components/etrace/et_Trace.h-arc  $
 * 
 *    Rev 1.11   Nov 19 2003 14:11:30   PEC2HI
 * add ET_ERRMEM_INFO_STRING Makro
 * 
 *    Rev 1.10   Aug 16 2003 13:02:40   PEC2HI
 * changed calling conventions
 * 
 *    Rev 1.9   Aug 16 2003 12:00:36   PEC2HI
 * changed temporary the calling conventions
 * 
 *    Rev 1.8   Aug 15 2003 16:24:48   PEC2HI
 * add errmem handling
 * 
 *    Rev 1.7   May 12 2003 17:11:34   bef2hi
 * Changes for new GPS library
 * 
 *    Rev 1.6   19 Mar 2003 15:24:40   SOR2HI
 * switched to interface includes
 * 
 *    Rev 1.5   Feb 18 2003 09:52:12   GGS2HI
 * Added functionality:
 * - et_bIsTraceActive() to check whether a given trace level is active
 * - et_vTraceBinary() for binary traces interpreted by TTFis
 * - new macros for binary traces
 */

#endif // _ET_TRACE_H
