/************************************************************************
 * FILE:         mm_MessageTarget.h
 * PROJECT:      ELeNa
 * SW-COMPONENT: (framework)
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  This class represents a message target. This Framework 
 *               is similar to MFC's CmdTarget. 
 *
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Author   | Modification
 * 03.04.01  | Bruns    | initial revision
 * 04.04.01  | Bruns    | added message map features ;-)
 * 10.04.01  | Bruns    | excluded "MessageTarget" ability
 * 26.06.01  | Perick   | gets the MessageMap-Mechanism for 
 *           |          | WorkThreads (WIL) and transformed it to a
 *           |          | universal MessageMap-Mechanism (MM)
 *************************************************************************/


#ifndef MM_MESSAGE_TARGET_H
#define MM_MESSAGE_TARGET_H


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


//#include "amt_CCAMessages.h"              // use CCA-messages


#include "mm_MessageMap.h"               // use message map 

/*****************************************************************************
 * mm_tclMessageTarget
 * --------------------------------------------------------------------------
 * This is the abstraction of a CCA-message target. Actually only ServiceData
 * messages are handled.
 *****************************************************************************/
class mm_tclMessageTarget
{
public:
                              mm_tclMessageTarget();
             virtual         ~mm_tclMessageTarget();   //ABR lint warning

protected:
   // handler for incomming ServiceData messages... calls specific handler
   // from message map.
   static tBool               bDefaultSvcDataHandler(mm_tclMessageTarget *pThis, 
                                                     amt_tclServiceData *poMessage);

   // searches an entry in the message map of this message target
   const mm_tMsgMapEntry    *pFindMsgEntry         ( const mm_tMsgMapEntry* lpEntry, 
                                                     const amt_tclServiceData *pMessage) const;

   // these fields represend the target's message map
   static const mm_tMsgMap   msgMap;                 // the map
   static const mm_tMsgMapEntry _msgEntries[];       // the entries
   static const mm_tMsgMap* _GetBaseMsgMap();        // the base map (untested)

   // overridable in order to implement own derived message maps
   virtual const mm_tMsgMap* GetMsgMap() const;      // the map retrieval
};


#endif

