///////////////////////////////////////////////////////////
//  ahl_tclStreamConfigStore.cpp
//  Implementation of the Class ahl_tclStreamConfigStore
//  Created on:      20-Sep-2007 00:04:10
//  Original author: Matthias Heling
///////////////////////////////////////////////////////////

#include "ahl_tclStreamConfigStore.h"
#include "ahl_trace.h"


// -- trace identifier ------- define this value for __every__ file new 
// regardless if used or not ;-)
#ifdef FILE_NUMBER
#undef FILE_NUMBER
#endif
#define FILE_NUMBER TRC::ahl_tclStreamConfigStore_cpp
// -- trace identifier ------- end


/**
 * the constructor definiert wo die daten gespeichert werden sollen. Der name ist
 * ein file mit ordnern( vollstndiger pfad ab /dev/ffs) an dessen ende die userid
 * angehngt wird
 */
ahl_tclStreamConfigStore::ahl_tclStreamConfigStore(tCString szConfigFileName, 
                                                   tU8 u8Major, tU8 u8Minor)
: ahl_tclBaseConfigStore(szConfigFileName, u8Major, u8Minor), mStream()
{
   TRC::tenTrcFile u=FILE_NUMBER; // lint wants to have at least one place using the define...
   u=u; // armcc wants to have at least one place to use the variable...
}

ahl_tclStreamConfigStore::~ahl_tclStreamConfigStore()
{
}

tVoid ahl_tclStreamConfigStore::vSetMachineData(tPCU8 pcu8Buf, tU32 u32Length)
{
   mStream.clear();
   mStream.insert(mStream.begin(), pcu8Buf, pcu8Buf+u32Length);
   vSetMachineDataStream(mStream);
}
tVoid ahl_tclStreamConfigStore::vGetMachineData(tPCU8 &rpcu8Buf, tU32 &ru32Length)
{
   mStream.clear();
   vGetMachineDataStream(mStream);
   rpcu8Buf = &(mStream.front());
   ru32Length = (tU32)mStream.size();
}
tVoid ahl_tclStreamConfigStore::vGetMachineDefaultData(tPCU8 &rpcu8Buf, tU32 &ru32Length)
{
   mStream.clear();
   vGetMachineDefaultDataStream(mStream);
   rpcu8Buf = (tPCU8)&mStream.front();
   ru32Length = (tU32)mStream.size();
}
tVoid ahl_tclStreamConfigStore::vSetUserData(tPCU8 pcu8Buf, tU32 u32Length)
{
   mStream.clear();
   mStream.insert(mStream.begin(), pcu8Buf, pcu8Buf+u32Length);
   vSetUserDataStream(mStream);
}
tVoid ahl_tclStreamConfigStore::vGetUserData(tPCU8 &rpcu8Buf, tU32 &ru32Length)
{
   mStream.clear();
   vGetUserDataStream(mStream);
   rpcu8Buf = &(mStream.front());
   ru32Length = (tU32)mStream.size();
}
tVoid ahl_tclStreamConfigStore::vGetUserDefaultData(tPCU8 &rpcu8Buf, tU32 &ru32Length)
{
   mStream.clear();
   vGetUserDefaultDataStream(mStream);
   rpcu8Buf = &(mStream.front());
   ru32Length = (tU32)mStream.size();
}
