/*****************************************************************************
 * FILE:         ahl_endian.cpp
 * PROJECT:      ELeNa
 * SW-COMPONENT: Help Library
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION:  function for big to little and little to big endian 
 *              
 *----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2001 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Author        | Modification
 * 26.10.01  | CM-CR/EES4 Schtte | initial version
 *
 * DO NOT USE!!!!!! WILL BE CHANGED IN NEAR FUTURE 
 *****************************************************************************/

#include "ahl_endian.h"

/******************************************************************************
* Defines and macros
******************************************************************************/




/******************************************************************************
*FUNCTION:          ahl_Little2BigEndian2Byte
*
*DESCRIPTION:       This function converts a tU16 little endian value into a
*                                       big endian value
*******************************************************************************/

tU16 ahl_u16Little2BigEndian(tU16 u16LittleValue)
{
        tU16 u16BigValue;
    u16BigValue = u16LittleValue >> 8;
    u16BigValue |= u16LittleValue << 8;
    return(u16BigValue);
}


/******************************************************************************
*FUNCTION:          ahl_Big2LittleEndian2Byte
*
*DESCRIPTION:       This function converts a tU16 big endian value into a
*                                       little endian value
*******************************************************************************/

tU16 ahl_u16Big2LittleEndian(tU16 u16BigValue)
{
    tU16 u16LittleValue;
    u16LittleValue = u16BigValue >> 8;
    u16LittleValue |= u16BigValue << 8;
    return(u16LittleValue);
}

/******************************************************************************
*FUNCTION:          ahl_Little2BigEndian4Byte
*
*DESCRIPTION:       This function converts a tU32 little endian value into a
*                                       big endian value
*******************************************************************************/

tU32 ahl_u32Little2BigEndian(tU32 u32LittleValue)
{
tU32 u32BigValue;
    u32BigValue =  (( u32LittleValue >> 24) & 0x000000FFL);
   u32BigValue |=  (( u32LittleValue >>  8) & 0x0000FF00L);
   u32BigValue |=  (( u32LittleValue <<  8) & 0x00FF0000L);
    u32BigValue|=  (( u32LittleValue << 24) & 0xFF000000L);

   return(u32BigValue);
}


/******************************************************************************
*FUNCTION:          ahl_Big2LittleEndian4Byte
*
*DESCRIPTION:       This function converts a tU32 big endian value into a
*                                       little endian value
*******************************************************************************/

tU32 ahl_u32Big2LittleEndian(tU32 u32BigValue)
{
tU32 u32LittleValue;
    u32LittleValue =  (( u32BigValue >> 24) & 0x000000FFL);
    u32LittleValue |=  (( u32BigValue >>  8) & 0x0000FF00L);
    u32LittleValue |=  (( u32BigValue <<  8) & 0x00FF0000L);
    u32LittleValue|=  (( u32BigValue << 24) & 0xFF000000L);

   return(u32LittleValue);
}



/* -- end of file ---------------------------------------------------------- */











