#ifndef AHLCFG_CCATCLTRACE_H
#define AHLCFG_CCATCLTRACE_H

// TR_CLASS_AIL                 TR_COMP_CCA + 0 = 0x8B00
// TR_CLASS_SCD                 TR_COMP_CCA + 1 = 0x8B01
// TR_CLASS_AMT                 TR_COMP_CCA + 2 = 0x8B02
// TR_CLASS_AHL_CCA_EXTENSION   TR_COMP_CCA + 3 = 0x8B03
#define TR_CLASS_AHL_CCA_EXTENSION  ((TR_tenTraceClass)(TR_COMP_CCA + 3))

#define TRACE_CCA_EXTENSIONS(u16Level, pcBuffer) \
{ \
   if (bTraceClassFilter(u16Level) == TRUE) \
   { \
     et_vTraceBinary(TR_CLASS_AHL_CCA_EXTENSION, (tU16)u16Level, pcBuffer); \
   } \
}

#define TRACE_CCA_ERROR(u16Level, pcBuffer) \
{ \
   if (et_bIsTraceActive(TR_CLASS_AHL_CCA_EXTENSION, (tU16)u16Level) == TRUE) \
   { \
     et_vTraceBinary(TR_CLASS_AHL_CCA_EXTENSION, (tU16)u16Level, pcBuffer); \
   } \
}


tVoid cca_extension_trace_errorstring(TR_tenTraceLevel enTraceLevel, tU32 AppID, tCString coszFormat, ...);

/* TRACE MACROS for CCA Helper */

#define TRACE_CCA_EXTENSION_ERRORSTRING(LEVEL, SOURCEAPPID, CCAERRORSTRING) TRACE_CCA_ERROR( LEVEL, ET_EN_T8 _ 0xFF _ ET_EN_T32 _ SOURCEAPPID _ ET_EN_STRING _ CCAERRORSTRING _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_APPSTATE(LEVEL, APPID, OLDAPPSTATE, NEWAPPSTATE) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x01 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ OLDAPPSTATE _ ET_EN_T32 _ NEWAPPSTATE _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_SERVICESTATE(LEVEL, APPID, SERVERAPPID, SERVID, SERVSTATE) TRACE_CCA_EXTENSIONS( LEVEL,  ET_EN_T8 _ 0x02 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_T32 _ SERVID _ ET_EN_T32 _ SERVSTATE _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_REGISTERSERVICE(LEVEL, APPID, SERVERAPPID, SERVID, ACTION, RESULT) TRACE_CCA_EXTENSIONS( LEVEL,  ET_EN_T8 _ 0x03 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_T32 _ SERVID _ ET_EN_T8 _ ACTION _ ET_EN_T8 _ RESULT _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_UNREGISTERSERVICE(LEVEL, APPID, SERVERAPPID, SERVID, ACTION, RESULT) TRACE_CCA_EXTENSIONS( LEVEL,  ET_EN_T8 _ 0x04 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_T32 _ SERVID _ ET_EN_T8 _ ACTION _ ET_EN_T8 _ RESULT _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_REGISTERALLFID(LEVEL, APPID, SERVERAPPID) TRACE_CCA_EXTENSIONS( LEVEL,  ET_EN_T8 _ 0x05 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_UNREGISTERALLFID(LEVEL, APPID, SERVERAPPID) TRACE_CCA_EXTENSIONS( LEVEL,  ET_EN_T8 _ 0x06 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_UNKNOWNMSG(LEVEL, APPID, SERVERAPPID, TYPE) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x07 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_T8 _ TYPE _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_MSGPREPROCESSING(LEVEL, APPID, SERVERAPPID) TRACE_CCA_EXTENSIONS( LEVEL,  ET_EN_T8 _ 0x08 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_REGISTERFIDSUCCESS(LEVEL, APPID, TAPPID, REGID, FID, SUCCESS) TRACE_CCA_EXTENSIONS( LEVEL,  ET_EN_T8 _ 0x09 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ TAPPID _ ET_EN_T32 _ REGID _ ET_EN_T32 _ FID _ ET_EN_T8 _ SUCCESS _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_UNREGISTERFIDSUCCESS(LEVEL, APPID, TAPPID, REGID, FID, SUCCESS) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x0a _ ET_EN_T32 _ APPID _ ET_EN_T32 _ TAPPID _ ET_EN_T32 _ REGID _ ET_EN_T32 _ FID _ ET_EN_T8 _ SUCCESS _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_SERVICEAVAILABLE(LEVEL, APPID, SERVERAPPID) TRACE_CCA_EXTENSIONS( LEVEL,  ET_EN_T8 _ 0x0b _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_SERVICEUNAVAILABLE(LEVEL, APPID, SERVERAPPID) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x0c _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_NEWSWBLOCKSTATE(LEVEL, APPID, SWBLOCKID) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x0d _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SWBLOCKID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_REGISTERSERVICECALL(LEVEL, APPID, SERVERAPPID) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x0e _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_UNREGISTERSERVICECALL(LEVEL, APPID, SERVERAPPID) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x0f _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_REGISTERCONF(LEVEL, APPID, SERVERAPPID, REGIDOLD, REGID, SERVICEID) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x10 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_T16 _ REGIDOLD _ ET_EN_T16 _ REGID _ ET_EN_T16 _ SERVICEID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_NEWMSG(LEVEL, APPID, SERVICEID) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x11 _ ET_EN_T32 _ APPID _ ET_EN_T16 _ SERVICEID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_UPDATECLIENTS(LEVEL, APPID, SERVERAPPID, SERVICEID, FUID) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x12 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_T32 _ SERVICEID _ ET_EN_T32 _ FUID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_NEWSWBLOCKSTATECLIENT(LEVEL, APPID, SERVERAPPID, SWBLOCKID) TRACE_CCA_EXTENSIONS( LEVEL, ET_EN_T8 _ 0x13 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVERAPPID _ ET_EN_T32 _ SWBLOCKID _ ET_EN_DONE);
#define TRACE_CCA_EXTENSION_SETSERVICESTATE(LEVEL, APPID, SERVID, ACTION) TRACE_CCA_EXTENSIONS( LEVEL,  ET_EN_T8 _ 0x14 _ ET_EN_T32 _ APPID _ ET_EN_T32 _ SERVID _ ET_EN_T8 _ ACTION _ ET_EN_DONE);

#endif /* AHLCFG_TCLTRACE_H */

