/* Inclusion of OSAL Interface */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define ERR_S_IMPORT_INTERFACE_ERRMEM
#include "err_if.h"


#include "ahl_ccaExtensionTrace.h"

tVoid cca_extension_trace_errorstring(TR_tenTraceLevel enTraceLevel, tU32 AppID, tCString coszFormat, ...)
{
   if (et_bIsTraceActive(TR_CLASS_AHL_CCA_EXTENSION, (tU16)enTraceLevel) == TRUE)
   {
      tChar acTraceBuffer[OSAL_C_U32_TRACE_MAX_BUFFERSIZE];
      OSAL_tVarArgList args;
      
      /* prepare the message buffer */
      OSAL_VarArgStart(args, coszFormat); //lint !e1055 !e530 !e830 Weird macro. But the parameters are fine. Works this way.
      OSAL_s32VarNPrintFormat(acTraceBuffer,
                                    sizeof(acTraceBuffer), 
                                    coszFormat, 
                                    args);//lint !e530 : OSAL_VarArgStart IS the initialiser */
         /* take care, that the last character is 0, because of behavior of nprintf */
      acTraceBuffer[OSAL_C_U32_TRACE_MAX_BUFFERSIZE-1] = 0;
      OSAL_VarArgEnd(args);

      if (enTraceLevel == TR_LEVEL_FATAL)
      {
         err_tclErrMem oErrMem;
         oErrMem.s32WriteErrorString(eErrmemEntryInfo, 
                                     (tU16)(TR_CLASS_AHL_CCA_EXTENSION & 0xFF00) /*u16TraceComp*/, 
                                     0 /*u8SpecificErrorCode*/, 
                                     acTraceBuffer);
         NORMAL_M_ASSERT_ALWAYS();
      }

      /* and write the trace message */
      TRACE_CCA_EXTENSION_ERRORSTRING(enTraceLevel, AppID, (tPCS8)acTraceBuffer);
   }
}

