/************************************************************************
* FILE:          ahl_ccaExtensionInternals.cpp
* PROJECT:       none
* SW-COMPONENT:  AHL
*----------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*----------------------------------------------------------------------
*
*          TMS-Jentsch  (jhr2hi)           
*
* COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
*
* HISTORY:      
*************************************************************************/

/* Inclusion of OSAL Interface */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ahl_ccaExtensionInternal.h"

/************************************************
* Base class of a property admin
*************************************************/

/* constructor */
ahl_tclPropertyAdmin::ahl_tclPropertyAdmin()
   : _bRegDone(FALSE)
   , _bRegInProgress(FALSE)
   , _bUnRegInProgress(FALSE)
{
}

/************************************************
* Base class of a Pairlist
*************************************************/

ahl_tclPairList::ahl_tclPairList(tU32 nMin, tU32 nMax): _nMin(nMin), _nMax(nMax)
{
   memset(_nMatrix,0,sizeof(_nMatrix));
}

tBool ahl_tclPairList::bAddPair(tU32 nFrom, tU32 nTo)
{
   if ((nFrom < AHL_MAX_PAIRLIST) && (nTo < AHL_MAX_PAIRLIST))
   {
      _nMatrix[nFrom] |= (1U << nTo);
      return TRUE;
   }
   else
   {
      return FALSE;
   }
}

tBool ahl_tclPairList::bRemovePair(tU32 nFrom, tU32 nTo)
{
   if ((nFrom < AHL_MAX_PAIRLIST) && (nTo < AHL_MAX_PAIRLIST))
   {
      _nMatrix[nFrom] &= ~(1U << nTo);
      return TRUE;
   }
   else
   {
      return FALSE;
   }
}

tBool ahl_tclPairList::bAddFrom(tU32 nFrom, ahl_tenPairListAdd enAddOption)
{
   if ((nFrom < AHL_MAX_PAIRLIST))
   {
      if (enAddOption == AHL_PAIRLIST_ALL)
      {
         _nMatrix[nFrom] = 0xFFFFFFFF;
      } 
      else if (enAddOption == AHL_PAIRLIST_ALL_LOWER)
      {
         tU32 i;
         for (i=_nMin;(i<=_nMax) && (i < nFrom);++i)
         {  
            if (bAddPair(nFrom,i) != TRUE)
            {
               return FALSE; 
            }
         }
      }
      else if (enAddOption == AHL_PAIRLIST_ALL_GREATER)
      {
         tU32 i;
         for (i=nFrom;i<=_nMax;++i)
         {  
            if (bAddPair(nFrom,i) != TRUE)
            {
               return FALSE; 
            }
         }
      }

      return TRUE;
   }
   else
   {
      return FALSE;
   }
}

tBool ahl_tclPairList::bAddTo(tU32 nTo, ahl_tenPairListAdd enAddOption)
{
   if (enAddOption == AHL_PAIRLIST_ALL)
   {
      tU32 i;
      for (i=_nMin;i<=_nMax;++i)
      {  
         if (bAddPair(i, nTo) != TRUE)
         {
            return FALSE; 
         }
      }
   } 
   else if (enAddOption == AHL_PAIRLIST_ALL_LOWER)
   {
      tU32 i;
      for (i=_nMin;(i<=_nMax) && (i < nTo);++i)
      {  
         if (bAddPair(i, nTo) != TRUE)
         {
            return FALSE; 
         }
      }
   }
   else if (enAddOption == AHL_PAIRLIST_ALL_GREATER)
   {
      tU32 i;
      for (i=nTo;i<=_nMax;++i)
      {  
         if (bAddPair(i, nTo) != TRUE)
         {
            return FALSE; 
         }
      }
   }

   return TRUE;
}


tBool ahl_tclPairList::bIfPairIncluded(tU32 nFrom, tU32 nTo) const
{
   if ((nFrom < AHL_MAX_PAIRLIST) && (nTo < AHL_MAX_PAIRLIST))
   {
      if ((_nMatrix[nFrom] & (1U << nTo)) != 0)
      {
         return TRUE;
      }
   }
   return FALSE;
}

/*
   This matrix is used to define when the settings of a application are load
*/
static tU32 nLoadMatrix[AHL_MAX_PAIRLIST] = 
{ 
   0x00F8, // AMT_C_U32_STATE_INVALID          -> AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_DIAGNOSIS, AMT_C_U32_STATE_PAUSE
   0x00F8, // AMT_C_U32_STATE_UNINITALIZED      
   0x00F8, // AMT_C_U32_STATE_INITIALIZED       
   0x0000, // AMT_C_U32_STATE_NORMAL            
   0x0000, // AMT_C_U32_STATE_DIAGNOSIS         
   0x0000, // AMT_C_U32_STATE_PAUSE             
   0x0000, // AMT_C_U32_STATE_PREPARE_DOWNLOAD  
   0x0000, // AMT_C_U32_STATE_RECEIVE_READY     
   0x00F8, // AMT_C_U32_STATE_OFF               
   0x0000, // 9
   0x0000, // 10
   0x0000, // 11
   0x0000, // 12
   0x0000, // 13
   0x0000, // 14
   0x0000 // 15
};

/*
   This matrix is used to define when the settings of a application are saved
*/
tU32 nSaveMatrix[AHL_MAX_PAIRLIST] = 
{ 
   0x0000, // AMT_C_U32_STATE_INVALID         
   0x0000, // AMT_C_U32_STATE_UNINITALIZED    
   0x0000, // AMT_C_U32_STATE_INITIALIZED     
   0x01C0, // AMT_C_U32_STATE_NORMAL           -> AMT_C_U32_STATE_RECEIVE_READY, AMT_C_U32_STATE_PREPARE_DOWNLOAD, AMT_C_U32_STATE_OFF
   0x01C0, // AMT_C_U32_STATE_DIAGNOSIS       
   0x01C0, // AMT_C_U32_STATE_PAUSE           
   0x0000, // AMT_C_U32_STATE_PREPARE_DOWNLOAD
   0x0000, // AMT_C_U32_STATE_RECEIVE_READY   
   0x0000, // AMT_C_U32_STATE_OFF             
   0x0000, // 9
   0x0000, // 10
   0x0000, // 11
   0x0000, // 12
   0x0000, // 13
   0x0000, // 14
   0x0000, // 15
};

/*
   This matrix is used to define when a application try to register for a service
*/
tU32 nRegisterMatrix[AHL_MAX_PAIRLIST] = 
{ 
   0x01F8, // AMT_C_U32_STATE_INVALID         -> AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_DIAGNOSIS, AMT_C_U32_STATE_PAUSE, AMT_C_U32_STATE_PREPARE_DOWNLOAD, AMT_C_U32_STATE_RECEIVE_READY, AMT_C_U32_STATE_OFF
   0x01F8, // AMT_C_U32_STATE_UNINITALIZED    
   0x01F8, // AMT_C_U32_STATE_INITIALIZED     
   0x0000, // AMT_C_U32_STATE_NORMAL           
   0x0000, // AMT_C_U32_STATE_DIAGNOSIS       
   0x0000, // AMT_C_U32_STATE_PAUSE           
   0x0000, // AMT_C_U32_STATE_PREPARE_DOWNLOAD
   0x0000, // AMT_C_U32_STATE_RECEIVE_READY   
   0x0000, // AMT_C_U32_STATE_OFF             
   0x0000, // 9
   0x0000, // 10
   0x0000, // 11
   0x0000, // 12
   0x0000, // 13
   0x0000, // 14
   0x0000, // 15
};

/*
   This matrix is used to define when a application try to unregister from a service
*/
tU32 nUnregisterMatrix[AHL_MAX_PAIRLIST] = 
{ 
   0x0000, // AMT_C_U32_STATE_INVALID         
   0x0000, // AMT_C_U32_STATE_UNINITALIZED    
   0x0000, // AMT_C_U32_STATE_INITIALIZED     
   0x0000, // AMT_C_U32_STATE_NORMAL           
   0x0000, // AMT_C_U32_STATE_DIAGNOSIS       
   0x0000, // AMT_C_U32_STATE_PAUSE           
   0x0000, // AMT_C_U32_STATE_PREPARE_DOWNLOAD
   0x0000, // AMT_C_U32_STATE_RECEIVE_READY   
   0x0000, // AMT_C_U32_STATE_OFF              
   0x0000, // 9
   0x0000, // 10
   0x0000, // 11
   0x0000, // 12
   0x0000, // 13
   0x0000, // 14
   0x0000, // 15
};

/*
   This matrix is used to define when a application try to register for a service
*/
tU32 nServiceAvailableMatrix[AHL_MAX_PAIRLIST] = 
{ 
   0x00F8, // AMT_C_U32_STATE_INVALID         -> AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_DIAGNOSIS, AMT_C_U32_STATE_PAUSE, AMT_C_U32_STATE_PREPARE_DOWNLOAD, AMT_C_U32_STATE_RECEIVE_READY
   0x00F8, // AMT_C_U32_STATE_UNINITALIZED    
   0x00F8, // AMT_C_U32_STATE_INITIALIZED     
   0x0000, // AMT_C_U32_STATE_NORMAL           
   0x0000, // AMT_C_U32_STATE_DIAGNOSIS       
   0x0000, // AMT_C_U32_STATE_PAUSE           
   0x0000, // AMT_C_U32_STATE_PREPARE_DOWNLOAD
   0x0000, // AMT_C_U32_STATE_RECEIVE_READY   
   0x00F8, // AMT_C_U32_STATE_OFF             
   0x0000, // 9
   0x0000, // 10
   0x0000, // 11
   0x0000, // 12
   0x0000, // 13
   0x0000, // 14
   0x0000, // 15
};

/*
   This matrix is used to define when a application try to unregister from a service
*/
tU32 nServiceUnavailableMatrix[AHL_MAX_PAIRLIST] = 
{ 
   0x0000, // AMT_C_U32_STATE_INVALID         
   0x0000, // AMT_C_U32_STATE_UNINITALIZED    
   0x0000, // AMT_C_U32_STATE_INITIALIZED     
   0x0100, // AMT_C_U32_STATE_NORMAL           
   0x0100, // AMT_C_U32_STATE_DIAGNOSIS       
   0x0100, // AMT_C_U32_STATE_PAUSE           
   0x0100, // AMT_C_U32_STATE_PREPARE_DOWNLOAD
   0x0100, // AMT_C_U32_STATE_RECEIVE_READY   
   0x0000, // AMT_C_U32_STATE_OFF              
   0x0000, // 9
   0x0000, // 10
   0x0000, // 11
   0x0000, // 12
   0x0000, // 13
   0x0000, // 14
   0x0000, // 15
};


tBool ahl_tclPairList::bSetDefault(ahl_tenPairListSetDefault enDefault)
{
   switch (enDefault)
   {
      case AHL_PAIRLIST_DEFAULT_EMPTY:
         {
            memset(_nMatrix, 0, sizeof(_nMatrix));
         }
         break;
      case AHL_PAIRLIST_DEFAULT_LOAD_SETTINGS_FILE:
         {
            memcpy(_nMatrix, nLoadMatrix, sizeof(_nMatrix));
         }
         break;
      case AHL_PAIRLIST_DEFAULT_SAVE_SETTINGS_FILE:
         {
            memcpy(_nMatrix, nSaveMatrix, sizeof(_nMatrix));
         }
         break;
      case AHL_PAIRLIST_DEFAULT_REGISTER_FOR_SERVICE:
         {
            memcpy(_nMatrix, nRegisterMatrix, sizeof(_nMatrix));
         }
         break;
      case AHL_PAIRLIST_DEFAULT_UNREGISTER_FOR_SERVICE:
         {
            memcpy(_nMatrix, nUnregisterMatrix, sizeof(_nMatrix));
         }
         break;
      case AHL_PAIRLIST_DEFAULT_SERVICE_AVAILABLE:
         {
            memcpy(_nMatrix, nServiceAvailableMatrix, sizeof(_nMatrix));
         }
         break;
      case AHL_PAIRLIST_DEFAULT_SERVICE_UNAVAILABLE:
         {
            memcpy(_nMatrix, nServiceUnavailableMatrix, sizeof(_nMatrix));
         }
         break;
      default:
         return FALSE;
   }
   return TRUE;
}

tclServerProperties::tclServerProperties() 
    :_oNotificationTable()
{

}

