// ahl_Timer
#include "ahl_Timer.h"

// Class ahl_tclTimer 


ahl_tclTimer::ahl_tclTimer()
  : m_hTimer(OSAL_C_INVALID_HANDLE)
{
}

ahl_tclTimer::~ahl_tclTimer()
{
   m_hTimer = OSAL_C_INVALID_HANDLE;
}


tBool ahl_tclTimer::bInit (ahl_tclCallbackBase* poCallback)
{
   tBool bSuccess = FALSE;

   if (poCallback != NULL)
   {
      tBool bCanInit = TRUE;

      if (m_hTimer != OSAL_C_INVALID_HANDLE)
      {
         bCanInit = bDestroy();
      }

      if ((bCanInit == TRUE) &&
          (OSAL_s32TimerCreate(&ahl_tclCallbackBase::vCallback,
                               poCallback, &m_hTimer) == OSAL_OK))
      {
         bSuccess = TRUE;
      }
      else
      {
         m_hTimer = OSAL_C_INVALID_HANDLE;
      }
   }
   return bSuccess;
}

tBool ahl_tclTimer::bDestroy ()
{
   tBool bSuccess = FALSE;

   if ((m_hTimer != OSAL_C_INVALID_HANDLE) &&
       (OSAL_s32TimerDelete(m_hTimer) == OSAL_OK))
   {
      bSuccess = TRUE;
      m_hTimer = OSAL_C_INVALID_HANDLE;
   }
   return bSuccess;
}

tBool ahl_tclTimer::bStart (OSAL_tMSecond msec, OSAL_tMSecond interval)
{
   tBool bSuccess = FALSE;

   if ((m_hTimer != OSAL_C_INVALID_HANDLE) &&
       (OSAL_s32TimerSetTime(m_hTimer, msec, interval) == OSAL_OK))
   {
      bSuccess = TRUE;
   }
   return bSuccess;
}

tBool ahl_tclTimer::bStartPeriodic (OSAL_tMSecond interval)
{
   return bStart(interval, interval);
}

tBool ahl_tclTimer::bStop ()
{
   tBool bSuccess = FALSE;

   if ((m_hTimer != OSAL_C_INVALID_HANDLE) &&
       (OSAL_s32TimerSetTime(m_hTimer, 0, 0) == OSAL_OK))
   {
      bSuccess = TRUE;
   }
   return bSuccess;
}

tBool ahl_tclTimer::bGetTime (OSAL_tMSecond* pMSec, OSAL_tMSecond* pInterval)
{
   tBool bSuccess = FALSE;

   if ((m_hTimer != OSAL_C_INVALID_HANDLE) &&
       (OSAL_s32TimerGetTime(m_hTimer, pMSec, pInterval) == OSAL_OK))
   {
      bSuccess = TRUE;
   }
   return bSuccess;
}



// Detached code regions:
// WARNING: this code will be lost if code is regenerated.
#if 0
   static_cast<ahl_tclCallbackBase*>(pvCallee)->vExecute();

#endif
