#define  AHL_S_IMPORT_INTERFACE_STREAMER
#include "ahl_if.h"

// Class ahl_tclStreamer 


ahl_tclStreamer::ahl_tclStreamer()
: _pStreamBuffer(0), _u32AllocatedMemory(0), _u32Size(0), _u32ReadIndex(0), _bExternData(TRUE)
{
}


ahl_tclStreamer::ahl_tclStreamer (tU32 u32StreamSize)
{
   if(u32StreamSize > 0)
   {
      _bExternData = FALSE;
      _pStreamBuffer = OSAL_NEW tChar[u32StreamSize];
   }
   else
   {
      _pStreamBuffer = 0;
      _bExternData = TRUE;
   }
   _u32AllocatedMemory = u32StreamSize;
   _u32Size = 0;
   _u32ReadIndex = 0;
}

ahl_tclStreamer::~ahl_tclStreamer()
{
   if((_pStreamBuffer != 0) && (!_bExternData) )
   {
      OSAL_DELETE [] _pStreamBuffer;
      _pStreamBuffer=0;
   }
}


tVoid ahl_tclStreamer::vSetStreamBuffer( tChar* pBuffer, tU32 u32BufferSize, tU32 u32WrittenBytes )
{
   if((_bExternData == FALSE) && (_pStreamBuffer != 0))
   {
      OSAL_DELETE [] _pStreamBuffer;
      _pStreamBuffer=0;
      _bExternData = TRUE;
   }
   //lint --e(423)
   //   this is not a memory leak, since externally supplied buffers
   //   are managed by their respective creators
   _pStreamBuffer = pBuffer;
   _u32AllocatedMemory = u32BufferSize;
   _u32Size = u32WrittenBytes;
   _u32ReadIndex = 0;
}

tU32 ahl_tclStreamer::u32GetActualStringSize () const
{
   OSAL_vAssert(_u32ReadIndex < _u32Size);
   
   if ((_u32ReadIndex < _u32Size)&& (_pStreamBuffer != NULL))
   {
      tU32 u32StringEnd = _u32ReadIndex;
      
      while ((u32StringEnd < _u32AllocatedMemory) && _pStreamBuffer[u32StringEnd] != '\0')
      {
         ++u32StringEnd;

         if ((u32StringEnd) == _u32Size)
         {
            // end of stream reached without finding '\0'
            return 0;
         }
      }
      
      return ++u32StringEnd - _u32ReadIndex;
   }
   else
   {
      return 0;
   }
}

ahl_tclStreamer& ahl_tclStreamer::rfWriteStream (const ahl_tclStreamer& prStrm)
{
   tU32 u32SizeToBeWritten = prStrm._u32Size - prStrm._u32ReadIndex;
   OSAL_vAssert((_u32Size + u32SizeToBeWritten) <= _u32AllocatedMemory);
   OSAL_vAssert(_pStreamBuffer != NULL);

   if (((_u32Size + u32SizeToBeWritten) <= _u32AllocatedMemory) &&
       (_pStreamBuffer != NULL))
   {
      tChar *pTemp = _pStreamBuffer + _u32Size;
      tChar *pSrc = prStrm._pStreamBuffer + prStrm._u32ReadIndex;


      OSAL_pvMemoryCopy(pTemp,pSrc,u32SizeToBeWritten);  //lint !e826
      
      _u32Size += u32SizeToBeWritten;
      _u32ReadIndex = 0;
   }
   
   return *this;
}

ahl_tclStreamer& ahl_tclStreamer::operator << (const bool bValue)
{
   // there must be enough place left to write
   OSAL_vAssert((_u32Size + sizeof(bool)) <= _u32AllocatedMemory );
   OSAL_vAssert(_pStreamBuffer != NULL);

   if (((_u32Size + sizeof(bool)) <= _u32AllocatedMemory) &&
      (_pStreamBuffer != NULL))
   {
      *(_pStreamBuffer + _u32Size) = (tChar)bValue;
      _u32Size += sizeof(bool);
      _u32ReadIndex = 0;
   }

   return *this;
}

ahl_tclStreamer& ahl_tclStreamer::operator << (const tU8 u8Value)
{
   // there must be enough place left to write
   OSAL_vAssert((_u32Size + sizeof(tU8)) <= _u32AllocatedMemory );
   OSAL_vAssert(_pStreamBuffer != NULL);

   if (((_u32Size + sizeof(tU8)) <= _u32AllocatedMemory) &&
      (_pStreamBuffer != NULL))
   {
      *(_pStreamBuffer + _u32Size) = (tChar)u8Value;
      _u32Size += sizeof(tU8);
      _u32ReadIndex = 0;
   }

   return *this;
}

ahl_tclStreamer& ahl_tclStreamer::operator << (const tU16 u16Value)
{
   // there must be enough place left to write
   OSAL_vAssert( (_u32Size + sizeof(tU16)) <= _u32AllocatedMemory );
   OSAL_vAssert(_pStreamBuffer != NULL);
   
   if (((_u32Size + sizeof(tU16)) <= _u32AllocatedMemory) &&
       (_pStreamBuffer != NULL))
   {
      tChar *pTemp = _pStreamBuffer + _u32Size;
      tChar *pSrc = (tChar*)&u16Value;

      (tVoid) OSAL_pvMemoryCopy(pTemp,pSrc,sizeof(tU16));

      _u32Size += sizeof(tU16);
      _u32ReadIndex = 0;
   }
   
   return *this;
}

ahl_tclStreamer& ahl_tclStreamer::operator << (const tU32 u32Value)
{
   // there must be enough place left to write
   OSAL_vAssert( (_u32Size + sizeof(tU32)) <= _u32AllocatedMemory );
   OSAL_vAssert(_pStreamBuffer != NULL);

   if (((_u32Size + sizeof(tU32)) <= _u32AllocatedMemory) &&
       (_pStreamBuffer != NULL))
   {
      tChar *pTemp = _pStreamBuffer + _u32Size;
      tChar *pSrc = (tChar*)&u32Value;

        (tVoid) OSAL_pvMemoryCopy(pTemp,pSrc,sizeof(tU32));

      _u32Size += sizeof(tU32);
      _u32ReadIndex = 0;
   }
   
   return *this;
}

ahl_tclStreamer& ahl_tclStreamer::operator << (const tU64 u64Value)
{
   // there must be enough place left to write
   OSAL_vAssert( (_u32Size + sizeof(tU64)) <= _u32AllocatedMemory );
   OSAL_vAssert(_pStreamBuffer != NULL);

   if (((_u32Size + sizeof(tU64)) <= _u32AllocatedMemory) &&
       (_pStreamBuffer != NULL))
   {
      tChar *pTemp = _pStreamBuffer + _u32Size;
      tChar *pSrc = (tChar*)&u64Value;

        (tVoid) OSAL_pvMemoryCopy(pTemp,pSrc,sizeof(tU64));

      _u32Size += sizeof(tU64);
      _u32ReadIndex = 0;
   }
   
   return *this;
}

#if defined(__APPLE__)
ahl_tclStreamer& ahl_tclStreamer::operator << (const uintptr_t value)
{
   // there must be enough place left to write
   OSAL_vAssert( (_u32Size + sizeof(uintptr_t)) <= _u32AllocatedMemory );
   OSAL_vAssert(_pStreamBuffer != NULL);

   if (((_u32Size + sizeof(uintptr_t)) <= _u32AllocatedMemory) &&
       (_pStreamBuffer != NULL))
   {
      tChar *pTemp = _pStreamBuffer + _u32Size;
      tChar *pSrc = (tChar*)&value;

      (tVoid) OSAL_pvMemoryCopy(pTemp,pSrc,sizeof(uintptr_t));

      _u32Size += sizeof(uintptr_t);
      _u32ReadIndex = 0;
   }

   return *this;
}
#endif

ahl_tclStreamer& ahl_tclStreamer::rfReadStream (ahl_tclStreamer& prStrm)
{
   // there must be enough byte left to read
   OSAL_vAssert( _u32Size >= _u32ReadIndex + prStrm._u32AllocatedMemory );
   OSAL_vAssert(_pStreamBuffer != NULL);

   if (( _u32Size >= _u32ReadIndex + prStrm._u32AllocatedMemory ) &&
       (prStrm._u32AllocatedMemory != 0) &&
       (_pStreamBuffer != NULL))
   {
      tChar *pcSource = _pStreamBuffer + _u32ReadIndex;

      (tVoid) OSAL_pvMemoryCopy(prStrm._pStreamBuffer,pcSource,
         prStrm._u32AllocatedMemory);

      _u32ReadIndex += prStrm._u32AllocatedMemory;

      prStrm.vResetReadIndex();
      prStrm._u32Size = prStrm._u32AllocatedMemory;
   }

   return *this;
}

ahl_tclStreamer& ahl_tclStreamer::operator >> (tU8& u8Value)
{
   // there must be enough byte left to read
   OSAL_vAssert( _u32Size > _u32ReadIndex);

   if ( (_u32Size > _u32ReadIndex)&&(_pStreamBuffer!=NULL))
   {
      tChar *pTemp = _pStreamBuffer + _u32ReadIndex; 
      u8Value = (tU8)*pTemp;
      ++_u32ReadIndex;
   }
   
   return *this;
}

ahl_tclStreamer& ahl_tclStreamer::operator >> (tU16& u16Value)
{
   // there must be enough byte left to read
   tU32 u32NewIndex = _u32ReadIndex + sizeof(tU16);
   OSAL_vAssert(u32NewIndex <= _u32Size);

   if ((_u32ReadIndex < _u32AllocatedMemory)&&(u32NewIndex <= _u32Size)&&(_pStreamBuffer!=NULL))
   {
      tChar *pTemp = _pStreamBuffer + _u32ReadIndex; 

      tChar *pDest = (tChar*)&u16Value;

      (tVoid) OSAL_pvMemoryCopy(pDest,pTemp,sizeof(tU16));

      _u32ReadIndex = u32NewIndex;
   }

   return *this;
}

ahl_tclStreamer& ahl_tclStreamer::operator >> (tU32& u32Value)
{
   // there must be enough byte left to read
   tU32 u32NewIndex = _u32ReadIndex + sizeof(tU32);
   OSAL_vAssert(u32NewIndex <= _u32Size);
   
   if ((_u32ReadIndex < _u32AllocatedMemory)&&(u32NewIndex <= _u32Size)&&(_pStreamBuffer!=0))
   {
      tChar *pTemp = _pStreamBuffer + _u32ReadIndex; 
      
      tChar *pDest = (tChar*)&u32Value;
      
      (tVoid) OSAL_pvMemoryCopy(pDest,pTemp,sizeof(tU32));
      
      _u32ReadIndex = u32NewIndex;
   }
   
   return *this;
}

ahl_tclStreamer& ahl_tclStreamer::operator >> (tU64& u64Value)
{
   // there must be enough byte left to read
   tU32 u32NewIndex = _u32ReadIndex + sizeof(tU64);
   OSAL_vAssert(u32NewIndex <= _u32Size);
   
   if ((_u32ReadIndex < _u32AllocatedMemory)&&(u32NewIndex <= _u32Size)&&(_pStreamBuffer!=0))
   {
      tChar *pTemp = _pStreamBuffer + _u32ReadIndex; 
      
      tChar *pDest = (tChar*)&u64Value;
      
      (tVoid) OSAL_pvMemoryCopy(pDest,pTemp,sizeof(tU64));
      
      _u32ReadIndex = u32NewIndex;
   }

   return *this;
}

#if defined(__APPLE__)
ahl_tclStreamer& ahl_tclStreamer::operator >> (uintptr_t& value)
{
   // there must be enough byte left to read
   tU32 u32NewIndex = _u32ReadIndex + sizeof(uintptr_t);
   OSAL_vAssert(u32NewIndex <= _u32Size);

   if ((_u32ReadIndex < _u32AllocatedMemory)&&(u32NewIndex <= _u32Size)&&(_pStreamBuffer!=0))
   {
      tChar *pTemp = _pStreamBuffer + _u32ReadIndex;

      tChar *pDest = (tChar*)&value;

      (tVoid) OSAL_pvMemoryCopy(pDest,pTemp,sizeof(uintptr_t));

      _u32ReadIndex = u32NewIndex;
   }

   return *this;
}
#endif

tVoid ahl_tclStreamer::vWriteString (tCString coszString, tU16 u16StringSize)
{
   OSAL_vAssert((_u32Size + u16StringSize) <= _u32AllocatedMemory );
   OSAL_vAssert(_pStreamBuffer != NULL);
   
   if (((_u32Size + u16StringSize) <= _u32AllocatedMemory) &&
       (_pStreamBuffer != NULL)&&
       (_u32Size < _u32AllocatedMemory))
   {
      (tVoid) OSAL_pvMemoryCopy((tChar *)(_pStreamBuffer + _u32Size),
                        coszString, u16StringSize);
      
      _u32Size += u16StringSize;
      
      _u32ReadIndex = 0;
   }
}

tVoid ahl_tclStreamer::vWriteStringToStream( tCString szString, tU32 u32StringSize )
{
   OSAL_vAssert((_u32Size + u32StringSize) <= _u32AllocatedMemory );
   OSAL_vAssert(_pStreamBuffer != NULL);
   
   if (((_u32Size + u32StringSize) <= _u32AllocatedMemory) &&
       (_pStreamBuffer != NULL)&&
       (_u32Size < _u32AllocatedMemory)) // important in case of (_u32Size + u32StringSize) having overflow
   {
      if (u32StringSize != 0) 
      {
         (tVoid) OSAL_pvMemoryCopy((tChar *)(_pStreamBuffer + _u32Size),
                           szString, u32StringSize);
         
         _u32Size += u32StringSize;
         
         _pStreamBuffer[_u32Size - 1] = '\0';
      }
      
      _u32ReadIndex = 0;
   }
}

tVoid ahl_tclStreamer::vReadString (tChar*& rfpcBuffer, tU32 u32BufferSize)
{
   tU32 u32StringSize = u32GetActualStringSize();

   OSAL_vAssert(u32StringSize != 0);
   OSAL_vAssert(u32StringSize <= u32BufferSize);
   OSAL_vAssert(_pStreamBuffer != NULL);

   if ((u32StringSize != 0) &&
       (u32StringSize <= u32BufferSize) &&
       (_pStreamBuffer != NULL) &&
       (_u32ReadIndex < _u32AllocatedMemory))
   {
      tChar *pTemp = _pStreamBuffer + _u32ReadIndex;
      
      (tVoid) OSAL_pvMemoryCopy(rfpcBuffer,pTemp,u32StringSize);
      
      _u32ReadIndex += u32StringSize;
   }
}

tVoid ahl_tclStreamer::vReadStringFromStream (tString szBuffer, tU32 u32BufferSize, tU32 u32KnownStringSize)
{
   tU32 u32StringSize = u32KnownStringSize;
   if (u32StringSize == 0)
   {
      u32StringSize = u32GetActualStringSize();
   }
   
   OSAL_vAssert(u32StringSize != 0);
   OSAL_vAssert(u32StringSize <= u32BufferSize);
   OSAL_vAssert(_pStreamBuffer != NULL);

   if ((u32StringSize != 0) &&
       (u32StringSize <= u32BufferSize) &&
       (_pStreamBuffer != NULL) &&
       (_u32ReadIndex < _u32AllocatedMemory))
   {
      tChar *pTemp = _pStreamBuffer + _u32ReadIndex;
      
      OSAL_pvMemoryCopy(szBuffer,pTemp,u32StringSize);
      
      _u32ReadIndex += u32StringSize;
   }
}

