#define AHL_S_IMPORT_INTERFACE_LISTSTREAMER
#include "ahl_if.h"
#define AHL_S_IMPORT_INTERFACE_STREAMABLETYPES
#include "ahl_if.h"


// Class ahl_tclStreamableList 


ahl_tclStreamableList::ahl_tclStreamableList()
{
}


ahl_tclStreamableList::~ahl_tclStreamableList()
{
}



tU32 ahl_tclStreamableList::u32GetStreamSize () const
{
   tU32 u32ReturnValue = 4; // list of
   vRewind();
   ahl_tclStreamableType *poEntry;
   while (0 != 
      (poEntry = (ahl_tclStreamableType*)pvGetSequential()))
   {
      u32ReturnValue += poEntry->u32GetStreamSize();
   }

   return u32ReturnValue;
}

tU16 ahl_tclStreamableList::u16GetStreamSize () const
{
   tU32 u32ReturnValue = u32GetStreamSize();
   if (u32ReturnValue <= 0xFFFF)
   {
      return (tU16)u32ReturnValue;
   }
   else
   {
      OSAL_vAssert(u32ReturnValue <= 0xFFFF);
      return 0;
   }
}
tVoid ahl_tclStreamableList::vSerializeType (ahl_tclListStreamer& rfoStream)
{
      tU32 u32NumberOfEntries = (tU32)u16GetElementNr();
      rfoStream << u32NumberOfEntries;
      
      ahl_tclStreamableType *poEntry;
      vRewind();
      
      while (0 != (poEntry = (ahl_tclStreamableType *)(pvGetSequential())))
      {
         poEntry->vSerializeType(rfoStream);
         
      }
}

tVoid ahl_tclStreamableList::vFillType (ahl_tclListStreamer& rfoStream)
{
   vDeleteEntries();
   
   tU32 u32NumberOfEntries;
   ahl_tclStreamableType *poEntry;
   
   rfoStream >> u32NumberOfEntries;
   
   OSAL_vAssert(u32NumberOfEntries <= 0xFFFF);
   
   while (u32NumberOfEntries-- != 0)
   {
      poEntry = poNewStreamableElement();
      if (0 != poEntry)
      {
         poEntry->vFillType(rfoStream);
      }
   }
}

// Class ahl_tclStreamableType 


ahl_tclStreamableType::ahl_tclStreamableType()
{
}


ahl_tclStreamableType::~ahl_tclStreamableType()
{
}



tVoid ahl_tclStreamableType::vSerializeType (ahl_tclListStreamer& rfoStream)
{
   (tVoid)rfoStream; //lint
}

tVoid ahl_tclStreamableType::vFillType (ahl_tclListStreamer& rfoStream)
{
   (tVoid)rfoStream; //lint
}

// Class ahl_tclFixedSizeElementList 


ahl_tclFixedSizeElementList::ahl_tclFixedSizeElementList (tU16 u16ElementSize, tU16 u16NrOfElements)
:_u16ElementSize(u16ElementSize),_u16NrOfElements(u16NrOfElements)
{
   if (_u16NrOfElements != 0 && _u16ElementSize != 0)
   {
      _pu8Array = OSAL_NEW tU8[_u16ElementSize*_u16NrOfElements];
   }
   else
   {
      _pu8Array = 0;
   }
}

ahl_tclFixedSizeElementList::ahl_tclFixedSizeElementList (tU16 u16ElementSize)
:_u16ElementSize(u16ElementSize),_u16NrOfElements(0),_pu8Array(0)
{
}

ahl_tclFixedSizeElementList::ahl_tclFixedSizeElementList (const ahl_tclFixedSizeElementList &right)
: ahl_tclStreamableType(right), _u16ElementSize(right._u16ElementSize),_u16NrOfElements(right._u16NrOfElements),_pu8Array(0)
{
   if (right._pu8Array != 0 && right._u16ElementSize != 0 && 
       right._u16NrOfElements != 0)
   {
      _pu8Array = OSAL_NEW tU8[_u16ElementSize*_u16NrOfElements];
      if (_pu8Array != NULL)
      {
         (tVoid)OSAL_pvMemoryCopy(_pu8Array,right._pu8Array,_u16ElementSize*_u16NrOfElements);
      }
   }
}

ahl_tclFixedSizeElementList::~ahl_tclFixedSizeElementList()
{
   if (_pu8Array != 0) 
   {
      OSAL_DELETE[] _pu8Array;
      _pu8Array=0;
   }
}



tVoid ahl_tclFixedSizeElementList::vSerializeType (ahl_tclListStreamer& rfoStream)
{
   ahl_tclListStreamer oListStream;
   tU32 u32ArraySize = u32GetStreamSize() - 4;
   tU32 u32ListSize = (tU32)_u16NrOfElements;
   rfoStream << u32ListSize;
   oListStream.vSetStreamBuffer((tChar*)_pu8Array,u32ArraySize,u32ArraySize);
   rfoStream.rfWriteStream(oListStream);
}

tVoid ahl_tclFixedSizeElementList::vFillType (ahl_tclListStreamer& rfoStream)
{
   tU32 u32ListSize = 0;
   rfoStream >> u32ListSize;
   _u16NrOfElements = (tU16)u32ListSize;
   if(_u16NrOfElements != 0 && _u16ElementSize != 0)
   {
      if (_pu8Array == 0) 
      {
         _pu8Array = OSAL_NEW tU8[_u16ElementSize*_u16NrOfElements];

         OSAL_vAssert(_pu8Array != 0);

         ahl_tclStreamer oListStream;
         tU32 u32ListSize2 = u32GetStreamSize() - 4;
         oListStream.vSetStreamBuffer((tChar*)_pu8Array,u32ListSize2,0);
         rfoStream.rfReadStream(oListStream);
      }
      else 
      {
         ahl_tclStreamer oListStream;
         tU32 u32ListSize2 = u32GetStreamSize() - 4;
         oListStream.vSetStreamBuffer((tChar*)_pu8Array,u32ListSize2,0);
         rfoStream.rfReadStream(oListStream);
      }
   }
}

// Class ahl_te8 

// Class ahl_tb8 

// Class ahl_tclStringList 


ahl_tclStringList::ahl_tclStringList()
{
}


ahl_tclStringList::~ahl_tclStringList()
{
}


// Class ahl_tclStreamableString 


ahl_tclStreamableString::ahl_tclStreamableString()
      : _szString(NULL)
{
}

ahl_tclStreamableString::ahl_tclStreamableString (tCString rfszString)
      : _szString(NULL)
{
   tU32 u32StringSize = OSAL_u32StringLength(rfszString) + sizeof('\0');
   
   OSAL_vAssert(u32StringSize < 0xFFFF);
   
   _szString = OSAL_NEW tChar[u32StringSize];
   if (_szString != NULL)
   {
      (tVoid)OSAL_pvMemoryCopy(_szString,rfszString,u32StringSize);
   }
}

ahl_tclStreamableString::ahl_tclStreamableString (const ahl_tclStreamableString &right)
      : ahl_tclStreamableType(right), _szString(NULL)
{
   tU32 u32StringSize = right.u32GetStreamSize();
   if (right._szString != NULL) 
   {
      _szString = OSAL_NEW tChar[u32StringSize];
      if (_szString != NULL)
      {
         (tVoid)OSAL_pvMemoryCopy(_szString,right._szString,u32StringSize);
      }
   }
}


ahl_tclStreamableString::~ahl_tclStreamableString()
{
   OSAL_DELETE[] _szString;
   _szString=NULL;
}



tU32 ahl_tclStreamableString::u32GetStreamSize () const
{
   if (_szString != NULL)
   {
      return OSAL_u32StringLength(_szString) + sizeof('\0');
   }
   else
   {
      return sizeof('\0');
   }
}

tVoid ahl_tclStreamableString::vSerializeType (ahl_tclListStreamer& rfoStream)
{
   if (_szString != NULL)
   {
      rfoStream.vWriteStringToStream(_szString,u32GetStreamSize());
   }
   else
   {
      _szString = OSAL_NEW tChar[sizeof('\0')];
      if (_szString != NULL)
      {
         _szString[0] = 0;
         rfoStream.vWriteStringToStream(_szString,sizeof('\0'));
      }
   }
}

tVoid ahl_tclStreamableString::vFillType (ahl_tclListStreamer& rfoStream)
{
   if(_szString) {
      OSAL_DELETE[] _szString;
      _szString=NULL;
   }
   tU32 u32StringSize = rfoStream.u32GetActualStringSize();
   if (u32StringSize != 0) 
   {
      _szString = OSAL_NEW tChar[u32StringSize];
      if (_szString != NULL)
         rfoStream.vReadStringFromStream(_szString,u32StringSize,u32StringSize);
   }
   else
   {
      _szString = OSAL_NEW tChar[sizeof('\0')];
      if (_szString != NULL)
      {
         _szString[0] = 0;
      }
   }
}

tVoid ahl_tclStreamableString::vSetString(tCString pString)
{
   if(NULL != pString)
   {
      OSAL_DELETE[] _szString;
      _szString=NULL;

      tU32 u32StringSize = OSAL_u32StringLength(pString) + 1;

      //if (u16StringSize != 0) 
      //{
         _szString = OSAL_NEW tChar[u32StringSize];
         if (_szString != NULL)
         {
            (tVoid)OSAL_szStringCopy(_szString, pString);
            _szString[u32StringSize-1] = 0;
         }
      //}
      //else
      //{
      //   _szString = OSAL_NEW tChar[sizeof('\0')];
      //   if (_szString != NULL)
      //   {
      //      _szString[0] = 0;
      //   }
      //}
   }
   
}

// Class ahl_tclLessAllocStreamableString 


ahl_tclLessAllocStreamableString::ahl_tclLessAllocStreamableString()
{
   _szShortString[0] = 0;
   _szString = _szShortString;
}

ahl_tclLessAllocStreamableString::ahl_tclLessAllocStreamableString (tCString szString)
      : _szString(NULL)
{
   if (szString != 0)
   {
      tU32 u32StringSize = OSAL_u32StringLength(szString) + sizeof('\0');

      OSAL_vAssert(u32StringSize < 0xFFFF);

      if (u32StringSize > SHORTSTRINGLENGTH)
      {
         _szString = OSAL_NEW tChar[u32StringSize];
         if (_szString != NULL)
         {
            (tVoid)OSAL_pvMemoryCopy(_szString,szString,u32StringSize);
         }
         _szShortString[0] = 0;
      }
      else
      {
         (tVoid)OSAL_pvMemoryCopy(_szShortString,szString,u32StringSize);
         _szString = _szShortString;
      }
   }
   else
   {
      _szShortString[0] = 0;
      _szString = _szShortString;
   }
}

ahl_tclLessAllocStreamableString::ahl_tclLessAllocStreamableString (const ahl_tclStreamableString &right)
: _szString(NULL)
{
   if (right._szString != NULL)
   {
      tU32 u32StringSize = OSAL_u32StringLength(right._szString) + sizeof('\0');

      OSAL_vAssert(u32StringSize < 0xFFFF);

      if (u32StringSize > SHORTSTRINGLENGTH)
      {
         _szString = OSAL_NEW tChar[u32StringSize];
         if (_szString != NULL)
         {
            (tVoid)OSAL_pvMemoryCopy(_szString,right._szString,u32StringSize);
         }
         _szShortString[0] = 0;
      }
      else
      {
         (tVoid)OSAL_pvMemoryCopy(_szShortString,right._szString,u32StringSize);
         _szString = _szShortString;
      }
   }
   else
   {
      _szShortString[0] = 0;
      _szString = _szShortString;
   }
}

ahl_tclLessAllocStreamableString::ahl_tclLessAllocStreamableString (const ahl_tclLessAllocStreamableString &right)
      : ahl_tclStreamableType(right),_szString(NULL)
{
   _szShortString[0] = 0;
   tU32 u32StringSize = right.u32GetStreamSize();
   if (u32StringSize > SHORTSTRINGLENGTH) 
   {
      _szString = OSAL_NEW tChar[u32StringSize];
      if (_szString != NULL)
      {
         (tVoid)OSAL_pvMemoryCopy(_szString,right._szString,u32StringSize);
      }
   }
   else // u16StringSize always > 0
   {
      (tVoid)OSAL_pvMemoryCopy(_szShortString,right._szShortString,u32StringSize);
      _szString = _szShortString;
   }
}


ahl_tclLessAllocStreamableString::~ahl_tclLessAllocStreamableString()
{
   if (_szString != NULL)
   {
      if(_szString != _szShortString)
      {
         OSAL_DELETE[] _szString;//lint !e673 PQM_authorized_multi_178. Reason: Handling done by design of class, reviewed and not critical 
         _szString=NULL;
      }
   }
}

ahl_tclLessAllocStreamableString & ahl_tclLessAllocStreamableString::operator=( const ahl_tclLessAllocStreamableString &rfoRight )
{
   if( &rfoRight == this ) return *this;
   
   // Clean up lhs string. (delete is OK on null pointer.)
   if( _szString != _szShortString ) OSAL_DELETE[] _szString; //lint !e673  PQM_authorized_multi_178. Reason: Handling done by design of class, reviewed and not critical 
   // ALWAYS reset lhs string to initial state.
   _szString = _szShortString; //lint !e672 PQM_authorized_193. Reason: Statement reviewed. Noncritical use case.
   _szShortString[0] = 0;

   tU32 rhsSize( rfoRight.u32GetStreamSize( ));

   // long string - must alloc
   if( SHORTSTRINGLENGTH < rhsSize )
   {
      _szString = OSAL_NEW tChar[ rhsSize ];
      NORMAL_M_ASSERT( _szString );
   }

   // Can use (lhs) _szString since it always points to the 'right' location. (Short or long)
   (tVoid)OSAL_pvMemoryCopy( _szString, rfoRight._szString, rhsSize );      

   return *this;
}

tU32 ahl_tclLessAllocStreamableString::u32GetStreamSize () const
{
   if (_szString != NULL)
   {
      return (tU16)OSAL_u32StringLength(_szString) + sizeof('\0');
   }
   else
   {
      return sizeof('\0');
   }
}

tVoid ahl_tclLessAllocStreamableString::vSerializeType (ahl_tclListStreamer& rfoStream)
{
   if (_szString == NULL)
   {
      _szShortString[0] = 0;
      _szString = _szShortString;
   }

   rfoStream.vWriteStringToStream(_szString,u32GetStreamSize());
}

tVoid ahl_tclLessAllocStreamableString::vFillType (ahl_tclListStreamer& rfoStream)
{
    if (_szString != NULL)
    {
        if (_szString != _szShortString) 
        {
            OSAL_DELETE[] _szString;//lint !e673 PQM_authorized_multi_178. Reason: Handling done by design of class, reviewed and not critical 
        }
        _szString=NULL;//lint !e672 known handling of memory _szShortString and _szString
    }

    tU16 u16StringSize = rfoStream.u16GetActualStringSize();
    if (u16StringSize > SHORTSTRINGLENGTH) 
    {
        _szString = OSAL_NEW tChar[u16StringSize]; 
        rfoStream.vReadStringFromStream(_szString,u16StringSize,u16StringSize);
        _szShortString[0] = 0;
    }
    else if (u16StringSize > 0)
    {
        rfoStream.vReadStringFromStream(_szShortString,u16StringSize,u16StringSize);
        _szString = _szShortString;
    }
    else
    {
        _szShortString[0] = 0;
        _szString = _szShortString;
    }
}

