/************************************************************************
 * FILE:         ahl_StreamMessageTarget.cpp
 * PROJECT:      VASCO
 * SW-COMPONENT: (framework)
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  
 *
 *               --> See header file
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Author   | Modification
 * 25.10.02  | Gieseke  | initial revision, extracted from mm_MessageTarget 
 *           |          | module
 *************************************************************************/

#include "ahl_StreamMessageTarget.h"      // use workthread's message map
#include "ahl_Streamer.h"              // use CCA messages



// static variable creation: The MessageMap
const ahl_tStreamMsgMap ahl_tclStreamMessageTarget::_oStreamMsgMap = {0,0};



//-----------------------------------------------------------------------------
// wil_tclMessageTarget (constructor)
//
//-----------------------------------------------------------------------------
ahl_tclStreamMessageTarget::ahl_tclStreamMessageTarget()
{
   // nothing to be done, yet.
}



//-----------------------------------------------------------------------------
// ~wil_tclMessageTarget (destructor)
//
//-----------------------------------------------------------------------------
ahl_tclStreamMessageTarget::~ahl_tclStreamMessageTarget()
{
   // nothing to be done, yet.
}



//-----------------------------------------------------------------------------
// bDefaultStreamMsgHandler (private, static)
//
// Handler for incomming Stream messages to this thread. Examines attached 
// message maps and calls spcific handler ;-)
//-----------------------------------------------------------------------------
tBool ahl_tclStreamMessageTarget::bDefaultStreamMsgHandler(
ahl_tclStreamMessageTarget *pThis, ahl_tclStreamer *poMessage) 
{
   // printf("** wil_tclMessageTarget: bDefaultSvcDataHandler called\n");

   const ahl_tStreamMsgMap* pMessageMap;
   const ahl_tStreamMsgMapEntry* pEntry;
   tU16 u16FunctionID;
   *poMessage >> u16FunctionID;
   
	// look through message map to see if it applies to us
   // printf("searching message map...\n");
   for (pMessageMap = pThis->poGetStreamMsgMap(); pMessageMap != NULL; pMessageMap = pMessageMap->pBaseMap)
   {
      // printf("searching entry ...\n");
      pEntry = pThis->pFindMsgEntry(pMessageMap->pEntries, poMessage, u16FunctionID);
      if(pEntry != 0)
      {
         // printf("function found: %d -> 0x%x\n", pEntry->u16FunctionID, pEntry->pHandlerFunction);
         ahl_tStrMsgFunction fun = pEntry->pHandlerFunction;
         (pThis->*fun)(poMessage);
         return true;
      }
      //else
        //printf("end of entry list reached...\n");
   }
   return FALSE;
}



//-----------------------------------------------------------------------------
// pFindMsgEntry
//
// Searches callback entry in message map. Returns NULL if not found.
//-----------------------------------------------------------------------------
const ahl_tStreamMsgMapEntry* ahl_tclStreamMessageTarget::pFindMsgEntry(
const ahl_tStreamMsgMapEntry* lpEntry, ahl_tclStreamer *pMessage, tU16 u16FuncId) const
{
	// C version of search routine
   // printf("pFindMsgEntry: searching for id = %d\n", u16FunctionID );
   (tVoid) pMessage;  //ABR LINT INFO 715 bgu2hi: Param not used here
   if(lpEntry != 0)
   {
      // printf("pFindMsgEntry: current id = %d\n", u16CurrentId);
      while ( (lpEntry->u16FunctionID) != 0)
	   {
   		if (lpEntry->u16FunctionID == u16FuncId)
		   {
   			return lpEntry;
		   }
		   lpEntry++;
	   }
   }
   return NULL;    // not found
}

//-----------------------------------------------------------------------------
// GetMsgMap
//
// 
//-----------------------------------------------------------------------------
const ahl_tStreamMsgMap* ahl_tclStreamMessageTarget::poGetStreamMsgMap() const
{
   return &_oStreamMsgMap;
}

//-----------------------------------------------------------------------------
// vDispatchMessage
//
// This is the default dispatcher for incomming ServiceData messages. 
// Calls specific handler (here ServiceDataHandler ONLY)
//-----------------------------------------------------------------------------
tVoid ahl_tclStreamMessageTarget::vDispatchMessage(ahl_tclStreamer *poMessage)
{
   //Stream Messages are dispatched by the MSG_MAP mechanism
   if(!bDefaultStreamMsgHandler(this, poMessage))
      vOnUnknownMessage(poMessage);
}

tVoid ahl_tclStreamMessageTarget::vOnUnknownMessage(ahl_tclStreamer *poMessage)
{
    (tVoid) poMessage;  //ABR LINT INFO 715 bgu2hi: Param not used here
   //ET_TRACE_WARNING( 0,"BaseWork vOnUnkownMessage: unknown message\n");
}

