#define AHL_S_IMPORT_INTERFACE_SEQUENCER
#include "ahl_if.h"
#define AHL_S_IMPORT_INTERFACE_LISTSTREAMER
#include "ahl_if.h"


// Class ahl_tclSequence 


ahl_tclSequence::ahl_tclSequence (tU8 u8SeqID)
      : _u8Status(AHL_SEQUENCE_STATUS_NOTAVAIL),
        _u8SeqID(u8SeqID),
        _u8SeqCtr(0),
        _bIsRunning(FALSE),
        _poCurrentAction(0)
{
}


ahl_tclSequence::~ahl_tclSequence()
{
   _oActionList.vRewind();
   ahl_tclSequenceAction *poActualAction;

   while(0 != (poActualAction = 
      (ahl_tclSequenceAction*)_oActionList.pvGetSequential()))
   {
      _oActionList.bRemove(poActualAction);
      OSAL_DELETE poActualAction;
   }

   _poCurrentAction = 0;
}



ahl_tclSequenceAction * ahl_tclSequence::poAddAction (ahl_tclListStreamer *poParameter, tVoid* pvPtr2Object, tvFctPointer pvFctPointer, tBool bLocalAllocatedParameter)
{
   ahl_tclSequenceAction *poNewAction = 
      OSAL_NEW ahl_tclSequenceAction(poParameter,pvPtr2Object,pvFctPointer,bLocalAllocatedParameter);

   if (poNewAction != NULL)
   {
      if(0 == _poCurrentAction)
      {
         _poCurrentAction = poNewAction;
      }
      _oActionList.bAppend(poNewAction);

      poNewAction->_u8SeqID = _u8SeqID;
   }

   return poNewAction;
}

ahl_tclSequenceAction * ahl_tclSequence::poAddAction (tVoid* pvPtr2Object, tvFctPointer pvFctPointer)
{
   ahl_tclSequenceAction *poNewAction = OSAL_NEW ahl_tclSequenceAction(pvPtr2Object,pvFctPointer);

   if (poNewAction != NULL)
   {
      if(0 == _poCurrentAction)
      {
         _poCurrentAction = poNewAction;
      }
      _oActionList.bAppend(poNewAction);
   
      poNewAction->_u8SeqID = _u8SeqID;
   }
   return poNewAction;
}

tVoid ahl_tclSequence::vStartSequence ()
{
   if(_u8SeqCtr < 0xFF)
   {
      ++_u8SeqCtr;
   }

   //_u8Status = AHL_SEQUENCE_STATUS_RUNNING;
   if(FALSE == _bIsRunning)
   {
      _bIsRunning = TRUE;
      vExecute();
   }
}

tVoid ahl_tclSequence::vResetSequence ()
{
   _poCurrentAction = (ahl_tclSequenceAction *)_oActionList.pvGetFirst();
   
   _oActionList.vRewind();
   ahl_tclSequenceAction *poActualAction;
   
   while(0 != (poActualAction = 
      (ahl_tclSequenceAction*)_oActionList.pvGetSequential()))
   {
      poActualAction->vResetAction();
   }
      
}

tVoid ahl_tclSequence::vAbortSequence ()
{
   if (TRUE == _bIsRunning)
   {
      _bIsRunning = FALSE;
      vResetSequence();
      --_u8SeqCtr;
   }
}

tVoid ahl_tclSequence::vExecute ()
{
   tBool bLastActionExecuted = TRUE;

   while(0 != _poCurrentAction && bLastActionExecuted == TRUE)
   {
      if (_poCurrentAction->pvGetFctPointer() == vExecuteIfWaiting) 
         // in this case another Sequence is called
      {
         _bIsRunning = FALSE;
      }

      if(TRUE == (bLastActionExecuted = _poCurrentAction->bExecute()))
         // checks if CurrentAction was executed successfuly
      {
         if(_poCurrentAction == (ahl_tclSequenceAction *)_oActionList.pvGetSequential())
            // checks if CurrentAction is the ActEntry in list
         {
            // assign CurrentAction to the next list entry
            _poCurrentAction = (ahl_tclSequenceAction *)_oActionList.pvGetActEntry();
         }
         else
         {
            if(TRUE == _oActionList.bSetActEntry(_poCurrentAction))
               // find CurrentAction in list and set it as ActEntry
            {
               // assign CurrentAction to the next list entry
               _oActionList.pvGetSequential(); // first returns ActualEntry and then sets ActualEntry to NextEntry
               _poCurrentAction = (ahl_tclSequenceAction *)_oActionList.pvGetActEntry();
            }
            
         }

//         // recursive call
//         vExecute();
      }
   }

   if (_poCurrentAction == 0)
   {
      vResetSequence();
      if(0 != --_u8SeqCtr)
      {
         vExecute();
      }
      else
      {
         _bIsRunning = FALSE;
      }
   }
}

tVoid ahl_tclSequence::vExecuteIfWaiting (tVoid *vPtr2Object, ahl_tclListStreamer *poParameter, tU8 u8SeqID)
{
   ahl_tclSequence * poMySelf = (ahl_tclSequence*)vPtr2Object;
   (tVoid)poParameter;
   (tVoid)u8SeqID;
   
   if (poMySelf->_bIsRunning == TRUE)
   {
      // the sequence should always start from beginning if it was queued
      poMySelf->vResetSequence();

      poMySelf->vExecute();
   }
}

tBool ahl_tclSequence::bSequenceResult (tU16 u16FID)
{
   if((TRUE == _bIsRunning) && (0 != _poCurrentAction))
   {
      if(_poCurrentAction != (ahl_tclSequenceAction *)_oActionList.pvGetActEntry())
         // checks if CurrentAction is the ActEntry in list
      {
         _oActionList.bSetActEntry(_poCurrentAction);
         // find CurrentAction in list and set it as ActEntry
      }

      ahl_tclSequenceAction *poActAction;

      tBool bReturn = FALSE;

      _oActionList.vRewind();

      while (0 != (poActAction = (ahl_tclSequenceAction *)_oActionList.pvGetActEntry()))
      {
         bReturn = poActAction->bFulfillPrecondition(u16FID);
         if(TRUE == bReturn)
         {
            _poCurrentAction = poActAction;
            vExecute(); // executes the CurrentAction
            break;
         }
         else
         {
            _oActionList.pvGetSequential();
         }
      }
      
      return bReturn;
   }
   else
   {
      return FALSE;
   }
}

tBool ahl_tclSequence::bSequenceResult (tU16 u16FID, ahl_tclListStreamer *poParameter)
{
   if(TRUE == bSequenceResult(u16FID))
   {
      ahl_tclSequenceAction * poActAction = 
         (ahl_tclSequenceAction *)_oActionList.pvGetActEntry();

      if ((0 != poActAction) 
         && 
         (0 != poActAction->_poParameter))
      {
         poActAction->_poParameter->vResetReadWriteIndex();
         poActAction->vSetResultParameter(poParameter);
         return TRUE;
      }
      else
      {
         return FALSE;
      }
   }
   else
   {
      return FALSE;
   }
}

tVoid ahl_tclSequence::vSetLastExecutedAction (tvFctPointer pvFctPointer)
{

   if (_bIsRunning == FALSE) 
   {
      ahl_tclSequenceAction *poActualAction = 0;
      
      _oActionList.vRewind();


      while(0 != (poActualAction = 
         (ahl_tclSequenceAction*)_oActionList.pvGetSequential()))
      {
         // mark all actions up to the given function pointer as done
         poActualAction->vMarkActionAsDone();
         if (poActualAction->pvGetFctPointer() == pvFctPointer) 
         {
            if (0 != (poActualAction = 
               (ahl_tclSequenceAction*)_oActionList.pvGetSequential())) 
            {
               poActualAction->vResetAction();
               poActualAction->vSetPrecondsAsFulfilled();
            }
            break;
         }
      }

      // now reset the remaining actions
      while(0 != (poActualAction = 
         (ahl_tclSequenceAction*)_oActionList.pvGetSequential()))
      {
         // mark all actions up to the given function pointer as done
         poActualAction->vResetAction();
      }

      _bIsRunning = TRUE;
      ++(_u8SeqCtr);
   }
}

tBool ahl_tclSequence::bCheckSequenceNotRunning (tVoid *vPtr2Object)
{
   ahl_tclSequence * poMySelf = (ahl_tclSequence*)vPtr2Object;
   
   if(poMySelf->_bIsRunning == TRUE)
   {
      return FALSE;
   }
   else
   {
      return TRUE;
   }

}

// Class ahl_tclSequenceAction 


ahl_tclSequenceAction::ahl_tclSequenceAction (ahl_tclListStreamer *poParameter, tVoid* pvPtr2Object, tvFctPointer pvFctPointer, tBool bLocalAllocatedParameter)
       : _u8SeqID(0),                  //ABR compiler warning change order
        _poParameter(poParameter),    //ABR compiler warning change order
        _pvFctPointer(pvFctPointer),  //ABR compiler warning change order
        _pvPtr2Object(pvPtr2Object),  //ABR compiler warning change order
         _bDone(FALSE),               //ABR compiler warning change order
        _bPreconditions(FALSE),       //ABR compiler warning change order
        _bLocalAllocatedParameter(bLocalAllocatedParameter)  //ABR compiler warning change order
{
}

ahl_tclSequenceAction::ahl_tclSequenceAction (tVoid* pvPtr2Object, tvFctPointer pvFctPointer)
      : _u8SeqID(0),                  //ABR compiler warning change order
        _poParameter(0),              //ABR compiler warning change order
        _pvFctPointer(pvFctPointer),  //ABR compiler warning change order
        _pvPtr2Object(pvPtr2Object),  //ABR compiler warning change order
        _bDone(FALSE),                //ABR compiler warning change order
        _bPreconditions(FALSE),       //ABR compiler warning change order
  _bLocalAllocatedParameter(FALSE)    //ABR compiler warning change order
{
}


ahl_tclSequenceAction::~ahl_tclSequenceAction()
{
   if(0 != _poParameter)
   {
      if (TRUE == _bLocalAllocatedParameter) 
      {
         OSAL_DELETE _poParameter;
      }
      _poParameter = 0;
   }
   
   _pvFctPointer = 0;
   _pvPtr2Object = 0;

   // delete precondition list
   _oPrecondList.vRewind();
   ahl_tclSequenceResult *poActualPrecondition;
   
   while(0 != (poActualPrecondition = (ahl_tclSequenceResult*)_oPrecondList.pvGetSequential()))
   {
      _oPrecondList.bRemove(poActualPrecondition);
      OSAL_DELETE poActualPrecondition;
   }
}



tBool ahl_tclSequenceAction::bExecute ()
{
   if (_bPreconditions == TRUE) 
   {
      bFulfillPrecondition();
   }

   if ((FALSE == _bPreconditions) && (0 != _pvFctPointer) && (FALSE == _bDone))
   {
      _bDone = TRUE;
      _pvFctPointer(_pvPtr2Object,_poParameter,_u8SeqID);
   }

   return _bDone;
}

tVoid ahl_tclSequenceAction::vResetAction ()
{
   _bDone = FALSE;

   if(0 != _oPrecondList.u8GetSize())
   {
      _oPrecondList.vRewind();
      ahl_tclSequenceResult *poActualResult;

      while(0 != (poActualResult = 
         (ahl_tclSequenceResult*)_oPrecondList.pvGetSequential()))
      {
         poActualResult->_bFulfilled = FALSE;
      }
      
      _bPreconditions = TRUE;
   }
   else
   {
      _bPreconditions = FALSE;
   }
   
}

tVoid ahl_tclSequenceAction::vAddPrecondition (tU16 u16FID)
{
   _bPreconditions = TRUE;
   
   ahl_tclSequenceResult *poNewPrecondition = OSAL_NEW ahl_tclSequenceResult(u16FID);
   _oPrecondList.bAppend(poNewPrecondition);
}

tVoid ahl_tclSequenceAction::vAddPrecondition (tVoid* pvPtr2Object, tbFctPointer pbFctPointer)
{
   _bPreconditions = TRUE;
   
   ahl_tclSequenceResult *poNewPrecondition = OSAL_NEW ahl_tclSequenceResult(0,pvPtr2Object,pbFctPointer);
   _oPrecondList.bAppend(poNewPrecondition);
}

tBool ahl_tclSequenceAction::bFulfillPrecondition (tU16 u16FID)
{
   tBool bResultFulfilled = FALSE;

   if(TRUE == _bPreconditions)
   {
      _oPrecondList.vRewind();
      ahl_tclSequenceResult *poActualResult;
      
      tBool bMorePreconditions = FALSE;

      while(0 != (poActualResult = 
         (ahl_tclSequenceResult*)_oPrecondList.pvGetSequential()))
      {
         if(FALSE == poActualResult->_bFulfilled)
            // unfulfilled precondition found
         {
            if (poActualResult->_u16FunctionID == u16FID ||
                poActualResult->_u16FunctionID == 0)
               // unfulfilled precondition matches the actual FID or is 0, which
               // means that only a bool function has to be evaluated
            {
               bResultFulfilled = poActualResult->bCheckResult();

               if(FALSE == bResultFulfilled)
               {
                  // Actual Result was not fulfilled
                  bMorePreconditions = TRUE;
               }
            }
            else
               // a unfulfilled precondition was found which doesn't match
               // the actual FID
            {
               bMorePreconditions = TRUE;
            }
         }
      }

      _bPreconditions = bMorePreconditions;
   }

   return bResultFulfilled;
}

tVoid ahl_tclSequenceAction::vSetResultParameter (ahl_tclListStreamer *poParameter)
{
   if ((0 != poParameter) && (0 != _poParameter))
   {
      (*_poParameter).rfWriteStream(*poParameter);
   }
}

// Class ahl_tclSequenceResult 


ahl_tclSequenceResult::ahl_tclSequenceResult (tU16 u16FID)
    : _u16FunctionID(u16FID),             ///ABR compiler warning change order
        _bFulfilled(FALSE),   
       _pbFctPointer(0),
       _pvPtr2Object(0)
{
}

ahl_tclSequenceResult::ahl_tclSequenceResult (tU16 u16FID, tVoid* pvPtr2Object, tbFctPointer pbFctPointer)
   : _u16FunctionID(u16FID),             //ABR compiler warning change order
        _bFulfilled(FALSE),
        _pbFctPointer(pbFctPointer),
        _pvPtr2Object(pvPtr2Object)
{
}


ahl_tclSequenceResult::~ahl_tclSequenceResult()
{
   _pbFctPointer = 0;
   _pvPtr2Object = 0;
}



tBool ahl_tclSequenceResult::bCheckResult ()
{
   if ((0 != _pbFctPointer)
      && 
      (0 != _pvPtr2Object)) 
   {
      if(TRUE == _pbFctPointer(_pvPtr2Object))
      {
         _bFulfilled = TRUE;
      }
   }
   else
   {
      _bFulfilled = TRUE;
   }

   return _bFulfilled;
}

// Class ahl_tclSequencer 


ahl_tclSequencer::ahl_tclSequencer()
{
}


ahl_tclSequencer::~ahl_tclSequencer()
{
   _oSequenceList.vRewind();
   ahl_tclSequence *poActualSequence;
   while(0 != (poActualSequence = 
      (ahl_tclSequence*)_oSequenceList.pvGetSequential()))
   {
      _oSequenceList.bRemove(poActualSequence);
      OSAL_DELETE poActualSequence;
   }      
}



ahl_tclSequence* ahl_tclSequencer::poAddSequence (tU8 u8SeqID)
{
   ahl_tclSequence *poSequence = OSAL_NEW ahl_tclSequence(u8SeqID);
   _oSequenceList.bAppend(poSequence);
   return poSequence;
}

ahl_tclSequence* ahl_tclSequencer::poFindSequence (tU8 u8SeqID) const
{
   _oSequenceList.vRewind();
   ahl_tclSequence *poActualSequence;
   while(0 != (poActualSequence = 
      (ahl_tclSequence*)_oSequenceList.pvGetSequential()))
   {
      if (poActualSequence->_u8SeqID == u8SeqID)
         return poActualSequence;
   }

   return 0;
}

