//*******************************************************************
//* FILE:         ahl_Lock.h
//*
//* SW-COMPONENT: Application Help Library
//*
//* DESCRIPTION:  This file defines a lock class that is usable as
//*               a critical section.
//*
//* AUTHOR:       CM-CR/EES4-Grosse Pawig
//*
//* COPYRIGHT:    (c) 2002 Blaupunkt GmbH
//*
//* HISTORY:
//* 02.07.2002 CM-CR/EES4-Grosse Pawig
//*            Initial Revision
//*******************************************************************


#ifndef AHL_LOCK_HEADER
#define AHL_LOCK_HEADER 1

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


//*******************************************************************
//* CLASS:       ahl_tclLock
//*
//* DESCRIPTION: A simple lock class.
//*
//*              This class is used to provide a locking mechanism
//*              to grant a thread exclusive access to a data
//*              structure or a region of code.
//*
//* AUTHOR:      CM-CR/EES4-Grosse Pawig
//*
//* COPYRIGHT:   (c) 2002 Blaupunkt GmbH
//*
//* HISTORY:
//* 25.06.2002 CM-CR/EES4-Grosse Pawig
//*            Initial Revision
//*******************************************************************
//##ModelId=3D1855EA003B
class ahl_tclLock 
{

   // Maximum length of the name of the underlying semaphore.
   // 10 bytes for "ahl_Lock::" 
   // 2*sizeof(void*) == 8  bytes for pointers on 32bit platforms
   //       ...       == 16 bytes for pointers on 64bit platforms
   // 1 terminating byte
   enum { EN_MAX_LEN = 10 + (2 * sizeof(void*)) + 1 };

  public:
      ahl_tclLock();


      //*****************************************************************
      //* FUNCTION:    bInit
      //*
      //* DESCRIPTION: Initialise the lock.
      //*
      //*              The necessary resources are allocated. On
      //*              successful return, the lock is ready to use.
      //*
      //* PARAMETER:   -
      //*
      //* RETURNVALUE: TRUE on success, FALSE on failure.
      //*
      //* AUTHOR:      CM-CR/EES4-Grosse Pawig
      //*
      //* HISTORY:
      //* 25.06.2002 CM-CR/EES4-Grosse Pawig
      //*            Initial Revision
      //*****************************************************************
      //##ModelId=3D18562A019C
      tBool bInit ();

      //*****************************************************************
      //* FUNCTION:    bLock
      //*
      //* DESCRIPTION: Acquire the lock.
      //*
      //*              This method is used to acquire the lock. On
      //*              successful return, the calling thread has
      //*              exclusive access to the resources that are
      //*              protected by this lock.
      //*
      //* PARAMETER:   -
      //*
      //* RETURNVALUE: TRUE if the lock has successfully been acquired,
      //*              FALSE otherwise.
      //*
      //* AUTHOR:      CM-CR/EES4-Grosse Pawig
      //*
      //* HISTORY:
      //* 25.06.2002 CM-CR/EES4-Grosse Pawig
      //*            Initial Revision
      //*****************************************************************
      //##ModelId=3D1856480113
      tBool bLock ();

      //*****************************************************************
      //* FUNCTION:    bUnlock
      //*
      //* DESCRIPTION: Release the lock.
      //*
      //*              After a lock has been successfully acquired, it
      //*              has to be released after the calling thread has
      //*              finished using the protected resource.
      //*
      //* PARAMETER:   -
      //*
      //* RETURNVALUE: TRUE if the lock has successfully been released,
      //*              FALSE otherwise.
      //*
      //* AUTHOR:      CM-CR/EES4-Grosse Pawig
      //*
      //* HISTORY:
      //* 25.06.2002 CM-CR/EES4-Grosse Pawig
      //*            Initial Revision
      //*****************************************************************
      //##ModelId=3D18564E0017
      tBool bUnlock ();

      //*****************************************************************
      //* FUNCTION:    bDestroy
      //*
      //* DESCRIPTION: Free the resources of the lock.
      //*
      //*              On application shutdown, the resoures that have
      //*              been aqcuired by bInit() have to be freed by a
      //*              call to bDestroy().
      //*
      //* PARAMETER:   -
      //*
      //* RETURNVALUE: TRUE if the resources have successfully been
      //*              freed, FALSE otherwise (e.g. if the lock had not
      //*              been initialised at all).
      //*
      //* AUTHOR:      CM-CR/EES4-Grosse Pawig
      //*
      //* HISTORY:
      //* 25.06.2002 CM-CR/EES4-Grosse Pawig
      //*            Initial Revision
      //*****************************************************************
      //##ModelId=3D18767A01B4
      tBool bDestroy ();

  protected:
  private:
    // Data Members for Class Attributes

      //Storage for the name of the lock.
      tChar m_szName[EN_MAX_LEN];

      // This semaphore is used to implement the lock.
      OSAL_tSemHandle m_hSemaphore;
};

// Class ahl_tclLock 


/*
 * $Log:   //hi230124/projects/Vasco/swnavi/archives/components/ahl/ahl_Lock.h-arc  $
 * 
 *    Rev 1.3   21 Mar 2003 13:51:02   GGS2HI
 * Adaptions for new system_types.h
 */


#endif
