/*****************************************************************************
 * FILE:         ahl_CriticalSection.cpp
 * PROJECT:      ELeNa
 * SW-COMPONENT: 
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION: - help funtions to enter and release a critical section
 *              - create semaphore variable with the OSAL function
 *                OSAL_s32SemaphoreCreate ( tCString szName, 
 *                                          OSAL_tSemHandle* phSid, 
 *                                          tU32 u32Value);
 *              
 *----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2001 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Author        | Modification
 * 01.10.01  | CM/EPE Perick | initial version
 * 
 *****************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ahl_CriticalSection.h"


tBool ahl_bEnterCritical(OSAL_tSemHandle hSemId)
{
   tBool bSemTake = FALSE;

   tS32 s32Ret = OSAL_s32SemaphoreWait( hSemId, OSAL_C_U32_INFINITE );
   
   if ( s32Ret == OSAL_OK )
   {
      bSemTake = TRUE;
   }
   return ( bSemTake );
}


tBool ahl_bReleaseCritical(OSAL_tSemHandle hSemId)
{
   tBool bSemPost = FALSE;

   tS32 s32Ret = OSAL_s32SemaphorePost( hSemId );
   
   if ( s32Ret == OSAL_OK )
   {
      bSemPost = TRUE;
   }
   return ( bSemPost );
}
