/*****************************************************************************
 *
 *   Projekt                : PROFI/DCAG33
 *   Dateiname              : crc_calc.c
 *   Original-Autor         : Richter
 *   Erstellungsdatum       : 10.02.2000
 *   Letzte Aenderung durch : Richter
 *   Letzte Aenderung am    : 16.02.00
 *   Version                : 3
 *
 *   Code-Review durch      : Unruh
 *   Code-Review am         : 25.02.2000
 *
 *
 *   (C) 1998  debis Systemhaus Information Security Services GmbH
 *             Rabinstrasse 8
 *             D-53111 Bonn
 *
 *****************************************************************************
 *
 *   Aenderungen
 *   ===========
 *
 *   Log
 *
 ****************************************************************************/

/* Includedateien ----------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include "ahl_Crc.h"

/* Makros ------------------------------------------------------------------*/

/* Typdefinitionen ---------------------------------------------------------*/

/* Konstanten --------------------------------------------------------------*/

#define INIT_VALUE      0xFFFFFFFF;
#define XOROUT          0xFFFFFFFF;

#if 0  //ABR LINT INFO 
#define INIT_VALUE_16BIT   0xFFFF;
#define XOROUT_16BIT       0xFFFF;
#endif

/* globale Variablen -------------------------------------------------------*/

/****************************************************************************/
/*                                                                          */
/* CRC LOOKUP TABLE                                                         */
/* ================                                                         */
/* The following CRC lookup table was generated automagically               */
/* by the Rocksoft^tm Model CRC Algorithm Table Generation                  */
/* Program V1.0 using the following model parameters:                       */
/*                                                                          */
/*    Width   : 2 bytes.                                                    */
/*    Poly    : 0x04C11DB7L                                                 */
/*    Reverse : TRUE.                                                       */
/*                                                                          */
/* Die Tabelle wurde beim Generieren in High- und Low-Teil                  */
/* gesplittet. Dadurch reicht ein Table-Offset aus, um beide                */
/* Teil-Werte der 32-Bit-CRC adressieren zu knnen.                         */
/*                                                                          */
/****************************************************************************/

tU16  ahl_gaCrcTable_High[256] =
{
   0x0000, 0x7707, 0xEE0E, 0x9909, 0x076D, 0x706A, 0xE963, 0x9E64,
   0x0EDB, 0x79DC, 0xE0D5, 0x97D2, 0x09B6, 0x7EB1, 0xE7B8, 0x90BF,
   0x1DB7, 0x6AB0, 0xF3B9, 0x84BE, 0x1ADA, 0x6DDD, 0xF4D4, 0x83D3,
   0x136C, 0x646B, 0xFD62, 0x8A65, 0x1401, 0x6306, 0xFA0F, 0x8D08,
   0x3B6E, 0x4C69, 0xD560, 0xA267, 0x3C03, 0x4B04, 0xD20D, 0xA50A,
   0x35B5, 0x42B2, 0xDBBB, 0xACBC, 0x32D8, 0x45DF, 0xDCD6, 0xABD1,
   0x26D9, 0x51DE, 0xC8D7, 0xBFD0, 0x21B4, 0x56B3, 0xCFBA, 0xB8BD,
   0x2802, 0x5F05, 0xC60C, 0xB10B, 0x2F6F, 0x5868, 0xC161, 0xB666,
   0x76DC, 0x01DB, 0x98D2, 0xEFD5, 0x71B1, 0x06B6, 0x9FBF, 0xE8B8,
   0x7807, 0x0F00, 0x9609, 0xE10E, 0x7F6A, 0x086D, 0x9164, 0xE663,
   0x6B6B, 0x1C6C, 0x8565, 0xF262, 0x6C06, 0x1B01, 0x8208, 0xF50F,
   0x65B0, 0x12B7, 0x8BBE, 0xFCB9, 0x62DD, 0x15DA, 0x8CD3, 0xFBD4,
   0x4DB2, 0x3AB5, 0xA3BC, 0xD4BB, 0x4ADF, 0x3DD8, 0xA4D1, 0xD3D6,
   0x4369, 0x346E, 0xAD67, 0xDA60, 0x4404, 0x3303, 0xAA0A, 0xDD0D,
   0x5005, 0x2702, 0xBE0B, 0xC90C, 0x5768, 0x206F, 0xB966, 0xCE61,
   0x5EDE, 0x29D9, 0xB0D0, 0xC7D7, 0x59B3, 0x2EB4, 0xB7BD, 0xC0BA,
   0xEDB8, 0x9ABF, 0x03B6, 0x74B1, 0xEAD5, 0x9DD2, 0x04DB, 0x73DC,
   0xE363, 0x9464, 0x0D6D, 0x7A6A, 0xE40E, 0x9309, 0x0A00, 0x7D07,
   0xF00F, 0x8708, 0x1E01, 0x6906, 0xF762, 0x8065, 0x196C, 0x6E6B,
   0xFED4, 0x89D3, 0x10DA, 0x67DD, 0xF9B9, 0x8EBE, 0x17B7, 0x60B0,
   0xD6D6, 0xA1D1, 0x38D8, 0x4FDF, 0xD1BB, 0xA6BC, 0x3FB5, 0x48B2,
   0xD80D, 0xAF0A, 0x3603, 0x4104, 0xDF60, 0xA867, 0x316E, 0x4669,
   0xCB61, 0xBC66, 0x256F, 0x5268, 0xCC0C, 0xBB0B, 0x2202, 0x5505,
   0xC5BA, 0xB2BD, 0x2BB4, 0x5CB3, 0xC2D7, 0xB5D0, 0x2CD9, 0x5BDE,
   0x9B64, 0xEC63, 0x756A, 0x026D, 0x9C09, 0xEB0E, 0x7207, 0x0500,
   0x95BF, 0xE2B8, 0x7BB1, 0x0CB6, 0x92D2, 0xE5D5, 0x7CDC, 0x0BDB,
   0x86D3, 0xF1D4, 0x68DD, 0x1FDA, 0x81BE, 0xF6B9, 0x6FB0, 0x18B7,
   0x8808, 0xFF0F, 0x6606, 0x1101, 0x8F65, 0xF862, 0x616B, 0x166C,
   0xA00A, 0xD70D, 0x4E04, 0x3903, 0xA767, 0xD060, 0x4969, 0x3E6E,
   0xAED1, 0xD9D6, 0x40DF, 0x37D8, 0xA9BC, 0xDEBB, 0x47B2, 0x30B5,
   0xBDBD, 0xCABA, 0x53B3, 0x24B4, 0xBAD0, 0xCDD7, 0x54DE, 0x23D9,
   0xB366, 0xC461, 0x5D68, 0x2A6F, 0xB40B, 0xC30C, 0x5A05, 0x2D02
};

tU16  ahl_gaCrcTable_Low[256] =
{
   0x0000, 0x3096, 0x612C, 0x51BA, 0xC419, 0xF48F, 0xA535, 0x95A3,
   0x8832, 0xB8A4, 0xE91E, 0xD988, 0x4C2B, 0x7CBD, 0x2D07, 0x1D91,
   0x1064, 0x20F2, 0x7148, 0x41DE, 0xD47D, 0xE4EB, 0xB551, 0x85C7,
   0x9856, 0xA8C0, 0xF97A, 0xC9EC, 0x5C4F, 0x6CD9, 0x3D63, 0x0DF5,
   0x20C8, 0x105E, 0x41E4, 0x7172, 0xE4D1, 0xD447, 0x85FD, 0xB56B,
   0xA8FA, 0x986C, 0xC9D6, 0xF940, 0x6CE3, 0x5C75, 0x0DCF, 0x3D59,
   0x30AC, 0x003A, 0x5180, 0x6116, 0xF4B5, 0xC423, 0x9599, 0xA50F,
   0xB89E, 0x8808, 0xD9B2, 0xE924, 0x7C87, 0x4C11, 0x1DAB, 0x2D3D,
   0x4190, 0x7106, 0x20BC, 0x102A, 0x8589, 0xB51F, 0xE4A5, 0xD433,
   0xC9A2, 0xF934, 0xA88E, 0x9818, 0x0DBB, 0x3D2D, 0x6C97, 0x5C01,
   0x51F4, 0x6162, 0x30D8, 0x004E, 0x95ED, 0xA57B, 0xF4C1, 0xC457,
   0xD9C6, 0xE950, 0xB8EA, 0x887C, 0x1DDF, 0x2D49, 0x7CF3, 0x4C65,
   0x6158, 0x51CE, 0x0074, 0x30E2, 0xA541, 0x95D7, 0xC46D, 0xF4FB,
   0xE96A, 0xD9FC, 0x8846, 0xB8D0, 0x2D73, 0x1DE5, 0x4C5F, 0x7CC9,
   0x713C, 0x41AA, 0x1010, 0x2086, 0xB525, 0x85B3, 0xD409, 0xE49F,
   0xF90E, 0xC998, 0x9822, 0xA8B4, 0x3D17, 0x0D81, 0x5C3B, 0x6CAD,
   0x8320, 0xB3B6, 0xE20C, 0xD29A, 0x4739, 0x77AF, 0x2615, 0x1683,
   0x0B12, 0x3B84, 0x6A3E, 0x5AA8, 0xCF0B, 0xFF9D, 0xAE27, 0x9EB1,
   0x9344, 0xA3D2, 0xF268, 0xC2FE, 0x575D, 0x67CB, 0x3671, 0x06E7,
   0x1B76, 0x2BE0, 0x7A5A, 0x4ACC, 0xDF6F, 0xEFF9, 0xBE43, 0x8ED5,
   0xA3E8, 0x937E, 0xC2C4, 0xF252, 0x67F1, 0x5767, 0x06DD, 0x364B,
   0x2BDA, 0x1B4C, 0x4AF6, 0x7A60, 0xEFC3, 0xDF55, 0x8EEF, 0xBE79,
   0xB38C, 0x831A, 0xD2A0, 0xE236, 0x7795, 0x4703, 0x16B9, 0x262F,
   0x3BBE, 0x0B28, 0x5A92, 0x6A04, 0xFFA7, 0xCF31, 0x9E8B, 0xAE1D,
   0xC2B0, 0xF226, 0xA39C, 0x930A, 0x06A9, 0x363F, 0x6785, 0x5713,
   0x4A82, 0x7A14, 0x2BAE, 0x1B38, 0x8E9B, 0xBE0D, 0xEFB7, 0xDF21,
   0xD2D4, 0xE242, 0xB3F8, 0x836E, 0x16CD, 0x265B, 0x77E1, 0x4777,
   0x5AE6, 0x6A70, 0x3BCA, 0x0B5C, 0x9EFF, 0xAE69, 0xFFD3, 0xCF45,
   0xE278, 0xD2EE, 0x8354, 0xB3C2, 0x2661, 0x16F7, 0x474D, 0x77DB,
   0x6A4A, 0x5ADC, 0x0B66, 0x3BF0, 0xAE53, 0x9EC5, 0xCF7F, 0xFFE9,
   0xF21C, 0xC28A, 0x9330, 0xA3A6, 0x3605, 0x0693, 0x5729, 0x67BF,
   0x7A2E, 0x4AB8, 0x1B02, 0x2B94, 0xBE37, 0x8EA1, 0xDF1B, 0xEF8D
};
/****************************************************************************/
/*                   End of CRC Lookup Table                                */
/****************************************************************************/

/* Funktionen --------------------------------------------------------------*/

/****************************************************************************/
/*                                                                          */
/* Zur Verifikation des CRC-Algorythmus dient die Zeichenkette "123456789" */
/* standardmssig als Vergleich. Stimmt die berechnete CRC mit einem von    */
/* verschiedenen Stellen mehrfach verifizierten Wert berein, kann man      */
/* davon ausgehen, dass der CRC-Algorythmus richtig implementiert wurde.    */
/*                                                                          */
/*      Name   : "CRC-32"                                                   */
/*      Width  : 32                                                         */
/*      Poly   : 04C11DB7                                                   */
/*      Init   : FFFFFFFF                                                   */
/*      RefIn  : True        (Reflexion des Input-Bytes)                    */
/*      RefOut : True        (Reflexion der CRC-Summe vor dem XORieren)     */
/*      XorOut : FFFFFFFF                                                   */
/*      Check  : CBF43926    (o.a. Checksumme bei "123456789")              */
/*                                                                          */
/* Bei den Tabellen ist zu beachten, dass die Reflexion der Werte zu Beginn */
/* der Berechnung (Reflected-In bezieht sich auf das aktuell zu verarbei-   */
/* tende Byte aus dem Datenstrom) und am Ende der kompletten CRC-Berechnung */
/* (Reflected-Out bezieht sich auf den 32-Bit-CRC-Wert nach Abarbeitung     */
/* des Datenstromes) in den Werten der Tabellen schon eingearbeitet ist!    */
/* Die einzigen frei whlbaren Parameter sind in diesem Fall der Initiali-  */
/* sierungswert (0xFFFFFFFF als Standard) und der Wert, mit dem die berech- */
/* nete CRC-Summe noch zustzlich XORiert wird (0xFFFFFFFF als Standard).   */
/*                                                                          */
/****************************************************************************/
#if 0 /* Not used in TM */
///////////////////////////////////////////////////////////////////////////////
//
// Function
//    calc_crc
//
// Description
//    Berechnung der Checksumme mit 16bit-Variablen
//
// Parameters
//    IN tUChar *blk_adr     --Zeiger auf Zeichenkette
//    IN tU32 blk_len      --Lnge der Zeichenkette
//    OUT tU16* nCrc32High   --High-Teil der 32-Bit-Crc-Summe
//    OUT tU16* nCrc32Low --Low-Teil der 32-Bit-Crc-Summe
//
// Return
//    --0 on Success
//
///////////////////////////////////////////////////////////////////////////////

int ahl_calc_crc(const tUChar* pBlk_Adr,
              tU32 nBlk_Len,
              tU16* pnCrc32High,
              tU16* pnCrc32Low )
{
   tU16 nCrcHigh;
   tU16 nCrcLow;
   tU16 nTableOffset;
   tU16 nCrc32High;
   tU16 nCrc32Low;

   nCrc32High = INIT_VALUE_16BIT;
   nCrc32Low = INIT_VALUE_16BIT;

   while( nBlk_Len-- )
   {
      // Tabellen-Offset berechnen
      nTableOffset = (nCrc32Low ^ *pBlk_Adr) & 0xFF;

      // 16-Bit-High-/Low-Teil der 32-Bit-CRC
      nCrcHigh = ahl_gaCrcTable_High[nTableOffset];
      nCrcLow = ahl_gaCrcTable_Low[nTableOffset];

      // Berechnen der 32-Bit-CRC mit 16-Bit-Variablen
      nCrc32Low = (nCrc32High << 8) | (nCrc32Low >> 8);
      nCrc32High = nCrc32High >> 8;
      nCrc32Low = nCrcLow ^ nCrc32Low;
      nCrc32High = nCrcHigh ^ nCrc32High;

      // Berechnen der 32-Bit-CRC mit 32-Bit-Variable fr CRC
      //    nCrc32 = ((nCrcHigh << 16) + nCrcLow) ^ (nCrc32 >> 8);

      // Zeiger auf Daten eins weiter
      pBlk_Adr++;
   }

   // CRC muss noch XORiert werden
   nCrc32Low ^= XOROUT_16BIT;
   nCrc32High ^= XOROUT_16BIT;

   // Variablen bertragen
   *pnCrc32Low = nCrc32Low;
   *pnCrc32High = nCrc32High;

   return(0);
}
#endif

///////////////////////////////////////////////////////////////////////////////
//
// Function
//    calc_crc_32
//
// Description
//    Berechnung der Checksumme mit 32bit-Variablen
//
// Parameters
//    IN tUChar *blk_adr  --Zeiger auf Zeichenkette
//    IN tU32 blk_len   --Lnge der Zeichenkette
//    OUT tU32* pnCrc32 --berechnete CRC
//
// Return
//    --0 on Success
//
///////////////////////////////////////////////////////////////////////////////

int ahl_calc_crc_32(const tUChar* pBlk_Adr,
                 tU32 nBlk_Len,
                 tU32* pnCrc32 )
{
   tU16 nCrcHigh;
   tU16 nCrcLow;
   tU32 nTableOffset;
   tU32 nCrc32 = INIT_VALUE;

   while( nBlk_Len-- )
   {
      // Tabellen-Offset berechnen
      nTableOffset = (nCrc32 ^ *pBlk_Adr) & 0xFF;

      // 16-Bit-High-/Low-Teil der 32-Bit-CRC
      nCrcHigh = ahl_gaCrcTable_High[nTableOffset];
      nCrcLow = ahl_gaCrcTable_Low[nTableOffset];

      // Berechnen der 32-Bit-CRC
      nCrc32 = ((nCrcHigh << 16) + nCrcLow) ^ (nCrc32 >> 8);

      // Zeiger auf Daten eins weiter
      pBlk_Adr++;
   }

   // CRC muss noch XORiert werden
   nCrc32 ^= XOROUT;

   // Variablen bertragen
   *pnCrc32 = nCrc32;

   return(0);
}

#if 0 /* Not used in TM */
///////////////////////////////////////////////////////////////////////////////
//
// Function
//    calc_crc_MBFS
//
// Description
//    Berechnung der Checksumme im MBFS
//
// Parameters
//    IN LPCSTR pFileName           --Name des Files
//    OUT tU32* pnFileLength  --Lnge des Files
//    OUT tU32* pnCrc32    --Crc32
//
// Return
//    --0 on Success
//
///////////////////////////////////////////////////////////////////////////////

int ahl_calc_crc_MBFS(const tChar* pFileName,
                   tU32* pnFileLength,
                   tU32* pnCrc32 )
{
   tU32 nCrcHigh;
   tU32 nCrcLow;
   tU32 nTableOffset;
   tUChar cReadChar[1];
   FILE* file;

   // Variablen initialisieren
   tU32 nCrc32 = 0xFFFFFFFF;
   tU32 nFileLength = 0;

   // Datei oeffnen
   file = fopen(pFileName, "rb");

   if( !file )
   {
      // Variablen bertragen
      *pnCrc32 = nCrc32;
      *pnFileLength = nFileLength;
      return(1);
   }

   while( fread( cReadChar, sizeof( tUChar ), 1, file ) )
   {
      // Byte erfolgreich eingelesen
      nFileLength++;

      // Tabellen-Offset berechnen
      nTableOffset = (nCrc32 ^ *cReadChar) & 0xFF;

      // 16-Bit-High-/Low-Teil der 32-Bit-CRC
      nCrcHigh = ahl_gaCrcTable_High[nTableOffset];
      nCrcLow = ahl_gaCrcTable_Low[nTableOffset];

      // Berechnen der 32-Bit-CRC
      nCrc32 = ((nCrcHigh << 16) + nCrcLow) ^ (nCrc32 >> 8);
   }

   // CRC muss noch XORiert werden
   nCrc32 ^= XOROUT;

   // File schliessen
   fclose(file);

   // Variablen bertragen
   *pnCrc32 = nCrc32;
   *pnFileLength = nFileLength;

   return(0);
}
#endif   /* #if 0 */

/****************************************************************************
* FILE                      [ $RCSfile: crc_calc.c,v $ ]
* ---------------------------------------------------------------------------
* GENERAL :
* $Header:   //hi230124/projects/Vasco/swnavi/archives/components/ahl/ahl_Crc.c-arc   1.0   Sep 05 2003 10:26:38   PEC2HI  $
* ---------------------------------------------------------------------------
* HISTORY
* REV.  DATE        TIME                   AUTHOR
* COMMENT
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
* $Revision:   1.0  $  $Date:   Sep 05 2003 10:26:38  $  $Author:   PEC2HI  $
* $Log:   //hi230124/projects/Vasco/swnavi/archives/components/ahl/ahl_Crc.c-arc  $
 * 
 *    Rev 1.0   Sep 05 2003 10:26:38   PEC2HI
 * Initial revision.
 * 
 *    Rev 1.2   Jan 09 2003 13:41:34   kan2hi
 * Warning removed
 * 
 *    Rev 1.1   Oct 17 2002 17:53:50   kan2hi
 * - CRC32 Calculation added in DIAG-SW
 * - Initial Release of CDROM-Driver added
 * 
 *    Rev 1.0   Sep 27 2002 07:39:48   SZW2HI
 * Initial revision.
 * 
 *    Rev 1.0   Sep 26 2002 14:29:44   SZW2HI
 * Initial revision.
 * 
 *    Rev 1.0   23 Aug 2002 12:40:46   rao2hi
 * Initial revision.
* Revision 2.0  2002/08/05 09:14:50  kan2hi
* Change of Revision
*
* Revision 1.1.1.1  2002/08/05 08:09:37  kan2hi
* no message
*
* Revision 1.1  2002/06/13 12:54:52  kan2hi
* Newly added PC-SW for IRom Loader and Test-Access
*
* Revision 1.2  2001/07/04 14:39:06  KAN2HI
* Watchdog Trigger added
*
* Revision 1.1  2001/07/03 14:15:41  KAN2HI
* New TM-Function for CRC32 calculation added
*
****************************************************************************/


