/************************************************************************
 * FILE:         ahl_BaseWorkThread.h
 * PROJECT:      ELeNa
 * SW-COMPONENT: (framework)
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Framework for base workthread's
 *              
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Author   | Modification
 * 20.06.01  | Perick   | initial version
 * 17.07.01  | Perick   | added Work-Threads to Application Help Library 
 *                     
 *************************************************************************/


#ifndef AHL_BASEWORKTHREAD_H
#define AHL_BASEWORKTHREAD_H


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#include "mm_MessageTarget.h"                     // msg map mechanism

class amt_tclBaseMessage;

class ahl_tclBaseWorkThread : public mm_tclMessageTarget
{
private:
   tChar                _szThreadName[OSAL_C_U32_MAX_NAMELENGTH];  // thread's name
   OSAL_tThreadID       _oThreadID;                  // thread's ID
   OSAL_tMQueueHandle   _oInQueueHandle;             // thread's IN-QUEUE
   tBool                _bIsValidFlag;               // construction valid
   tBool                _bTerminateFlag;

   // entry for all threads, calls thread specific virtual function, see below
   //static tVoid __stdcall dwThreadProc(tVoid* pArg);
   static OSAL_tpfThreadEntry dwThreadProc(tVoid* pArg);

   // creates thread's in queue (internal function)
   tBool                      bCreateInQueue        (const tChar *pcInQueueName,
                                                     tU32 nMaxMessages, 
                                                     tU32 nSizeOfOneMessage);


   // Dispatcher for messages - call this function if there's a new message to dispatch
   void                       vDispatchMessage      (amt_tclBaseMessage *pBaseMessage);


public:
   virtual tVoid              vThreadFunction();

   // react on unkown messages
   virtual tVoid              vOnUnknownMessage(amt_tclBaseMessage* poMessage);

   // Constructor
                              ahl_tclBaseWorkThread     (const tChar *pcNewThreadName,  
                                                         tU32 u32Prio, 
                                                         tU32 u32StackSize,
                                                         tU32 u32nMaxQueueLen);
   // Destructor
   virtual                    ~ahl_tclBaseWorkThread();

   // activate the thread
   tBool                      bActivate();

   // suspend the thread
   tBool                      bSuspend();

   // get the worker's queue
   OSAL_tMQueueHandle*        poGetInQueue();

   // get thread's name
   tChar*                     pcGetThreadName();

   // worker thread is correctly constructed
   tBool                      bIsValid() const;

   // set terminate flag on true
   tBool                      bTerminate();


   tBool                      bMessageWait(amt_tclBaseMessage *pMsgObject,
                                           OSAL_tMSecond nTimeout);

   tS32                       s32GetThreadID() const {return _oThreadID;}
   
  };


#endif // AHL_BASEWORKTHREAD_H
