/************************************************************************
 * FILE:         ahl_BaseWork.h
 * PROJECT:      ELeNa
 * SW-COMPONENT: (framework)
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  
 *              
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Author   | Modification
 * 26.10.01  | Perick   | initial version
 *                     
 *************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ahl_BaseWork.h"           

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"                        // use CCA messages




//-----------------------------------------------------------------------------
// Constructor 
//-----------------------------------------------------------------------------
ahl_tclBaseWork::ahl_tclBaseWork()
{
}



//-----------------------------------------------------------------------------
// Destructor "~ahl_tclWork"
//-----------------------------------------------------------------------------
ahl_tclBaseWork::~ahl_tclBaseWork()
{
}


//-----------------------------------------------------------------------------
// vDispatchMessage
//
// This is the default dispatcher for incomming ServiceData messages. 
// Calls specific handler (here ServiceDataHandler ONLY)
//-----------------------------------------------------------------------------
void ahl_tclBaseWork::vDispatchMessage(amt_tclBaseMessage *poBaseMessage)
{
   tU8 u8MsgType = poBaseMessage->u8GetType();

   switch(u8MsgType)
   {
      case AMT_C_U8_CCAMSGTYPE_SVCDATA:
         {
            amt_tclServiceData oServiceData(poBaseMessage);
            
            //ServiceData Messages are dispatched by the MSG_MAP mechanism
            if(!(ahl_tclBaseWork::bDefaultSvcDataHandler(this, &oServiceData)))
               vOnUnknownMessage(poBaseMessage);
         }
         break;
      default:
         {
            vOnUnknownMessage(poBaseMessage);
         }
   }
}

tVoid ahl_tclBaseWork::vOnUnknownMessage(amt_tclBaseMessage* poBaseMessage)
{
      //ET_TRACE_WARNING( 0,"BaseWork vOnUnkownMessage: unknown message\n");
      poBaseMessage->bDelete();
}

