/************************************************************************
* FILE:          ahl_BaseServer.h
* PROJECT:       none
* SW-COMPONENT:  AHL
*----------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*----------------------------------------------------------------------
*
* AUTHOR:  ESE-Neumann  (jn82hi)
*          TMS-Kempen   (kmr2hi)
*          TMS-Jentsch  (jhr2hi)           
*
* COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
*
* HISTORY:      
*************************************************************************/

#ifndef _AHL_BASESERVERONETHREAD_H_
#define _AHL_BASESERVERONETHREAD_H_

/* use AIL template */
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

/* use Application Help Library */
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#include <set>
#include <iterator>

#include "ahl_ccaExtensionInternal.h"
#include "ahl_ccaNotificationTable.h"

#include "ahl_ccaMethodTable.h"

class ahl_tclBaseOneThreadServerApp;

class ahl_tclBaseOneThreadService : public ahl_tclBaseOneThreadObject
{
public:
   ahl_tclPairList _tclRegisterPair;
   ahl_tclPairList _tclUnregisterPair;
  
   /*---------------------------------------------------------------------*/
   virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);
   /*---------------------------------------------------------------------*/
   virtual tVoid vMyDispatchMessage(amt_tclServiceData *pServiceDataMessage);
   virtual tVoid vOnServiceState(tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, tU8  u8ServiceState, tU16 u16SubId);

   inline tU16 u16GetAppID() const { return _u16AppID; }

   inline tBool bIfServiceAvailable() const { return _bServiceAvailable; }

   virtual tBool bGetServiceVersion (tU16 u16ServiceID, tU16 &rfu16MajorVersion, tU16 &rfu16MinorVersion, tU16 &rfu16PatchVersion); //lint !e1768  don't overwrite

   tVoid vSetServiceState();

   tVoid vInitServiceData(amt_tclServiceData& rServiceDataMessage, tU16 u16TargetAppID, tU16 u16RegisterID, tU16 u16CmdCounter, tU16 u16FunctionId, tU8 u8Opcode = AMT_C_U8_CCAMSG_OPCODE_STATUS, tU16 u16TargetSubID = AMT_C_U16_SUBID_DEFAULT) const;

   inline tU16 u16GetSubID() const { return AMT_C_U16_SUBID_DEFAULT; }; // A service has a fix SubID of AMT_C_U16_SUBID_DEFAULT.

   tBool bSetMethodHandlingType(tU16 u16FktID, ahl_tenMethodMultipleRequestHandlingType eHandlingType, tU32 nTimeout);

   ail_tenCommunicationError ePostMessage(amt_tclServiceData* poMessage);
private:
   tU16            _u16ServiceMajorVersion;
   tU16            _u16ServiceMinorVersion;
   tU16            _u16ServicePatchVersion;

   /* to store the application ID of the service */
   tU16  _u16AppID;

   /* to store the status variables of Service */
   tBool _bServiceAvailableAllowedOnAppstate;
   tBool _bServiceAvailableAllowedOnPrivateReason;
   tBool _bServiceAvailable;

   tBool _bAutoHandleGet;
   tBool _bAutoHandleSet;
   tBool _bAutoHandleIncDec;
   tBool _bEnableHighPrioFIDs;

   tclServerProperties clProperties;
   ahl_tclCCAMethodTable clMethodTable;

   std::set<tU16> sHighPrioFIDs;

   virtual tBool bOnAcceptNewRegister (tU16 u16ServiceId, tU16 u16ClientAppId, tU16 u16ClientSubId, tU16* pu16RegisterId);
   virtual tVoid vOnUnregister (tU16 u16ServiceId, tU16 u16RegisterId);

   ahl_tclBaseOneThreadService();//lint !e1704 Info 1704 , eliminating lint warnings the way of Lars.
protected:
   /* constructor */
   ahl_tclBaseOneThreadService( 
         ahl_tclBaseOneThreadApp*  poMainAppl,
         tU16            u16ServiceID,
         tU16            u16ApplID,
         tU16            u16ServiceMajorVersion,
         tU16            u16ServiceMinorVersion,
         tU16            u16ServicePatchVersion);

   ahl_tclBaseOneThreadService( 
         ahl_tclBaseOneThreadApp*  poMainAppl,
         tU16            u16ServiceID,
         tU16            u16ServiceMajorVersion,
         tU16            u16ServiceMinorVersion,
         tU16            u16ServicePatchVersion = 0);

   /* destructor */
   virtual ~ahl_tclBaseOneThreadService();

   /* this function is a helper to filter trace from the specific app, clienthandler, service */
   virtual tBool bTraceClassFilter(tU16 u16Level) const;
   virtual tVoid vTraceInternalState(TR_tenTraceLevel enLevel) const;

   virtual tVoid vOnNewMessage (amt_tclServiceData* poMessage);
   virtual tVoid vOnUnknownMessage(amt_tclBaseMessage* poMessage);

   virtual tVoid vOnMethodStart(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   virtual tVoid vOnMethodAbort(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   virtual tVoid vOnUpReg(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   virtual tVoid vOnRelUpReg(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   virtual tVoid vOnGet(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   virtual tVoid vOnSet(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   virtual tVoid vOnIncrement(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   virtual tVoid vOnDecrement(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   virtual tVoid vOnPureSet(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   virtual ail_tenCommunicationError eUpdateClients(tU16 u16FunctionId, amt_tclServiceData* poMessage =  NULL);
   tVoid vGenericSetHandler(tU16 u16FunctionId, amt_tclServiceData* poMessage, tU8 u8OpType);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16Error);
   virtual tBool bProcessIncDec(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16Error);

   virtual ail_tenCommunicationError eUpdateRequestingClient(amt_tclServiceData* poMessage);

   virtual amt_tclServiceData* pStatusMessageFactory(tU16 u16Target, tU16 u16FunctionId, tU16 u16RegisterID, tU16 u16CmdCounter);
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poIncomingMessage = NULL);
   virtual tVoid vDestroyFactoryStatusMessage(amt_tclServiceData* poMessage);

   virtual tVoid vUpdateAllProperties();

   virtual tVoid vSetPrivateServiceAvailableAllowed(tBool fServiceAvailableAllowed);

   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();

   virtual tBool bIsTargetFor(tU16 u16ServiceId, tU16 u16AppId, tU16 u16RegisterId, tU16 u16AppSubId) const;
   virtual tVoid vRemoveRegistration();

   tVoid vSetConfiguration(const ahl_sServiceConfig& oServiceConfig);
   tBool bSetFIDasHighPrio(tU16 nFID);

   inline tclServerProperties& tclGetProperties() { return clProperties; }
};


#endif /* _AHL_BASESERVERONETHREAD_H_ */
