/************************************************************************
* FILE:          ahl_baseclient_main.h
* PROJECT:       All
* SW-COMPONENT:  AHL
*----------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*----------------------------------------------------------------------
*
* AUTHOR:  ESE-Neumann  (jn82hi)
*          TMS-Kempen   (kmr2hi)
*          TMS-Jentsch  (jhr2hi)           
*
* COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
*
* HISTORY:      
*************************************************************************/

#ifndef _AHL_MAINONETHREAD_H_
#define _AHL_MAINONETHREAD_H_

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#define AHL_S_IMPORT_INTERFACE_CALLBACK
#define AHL_S_IMPORT_INTERFACE_TIMER
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define AIL_S_IMPORT_INTERFACE_GENERIC
#define AIL_S_IMPORT_INTERFACE_TRACE
#include "ail_if.h"         // use AIL template with MessageMaps

#include "ahl_BaseOneThreadObject.h"

#include <vector>


typedef std::vector<ahl_tclBaseOneThreadObject*> tsOneThreadObjects;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class ahl_tclBaseOneThreadApp : public ail_tclOneThreadAppInterface
{
private:
   tBool _bAppClosed;
   tBool _bBreakLoop;
   ahl_tclExCallbackTimer<ahl_tclBaseOneThreadApp> _atclTimer[AHL_MAX_TIMERS];

   tBool _abTimerCreated[AHL_MAX_TIMERS];
   tBool _abTimerStarted[AHL_MAX_TIMERS];
   tU16 _anTimerId[AHL_MAX_TIMERS];

   tBool _bQueueCallbackInstalled;
   OSAL_tEventHandle _hEventHandle;
 
   tsOneThreadObjects _asObjects;

   tU32 _nNumberOfObjects;

   OSAL_tpfCallback _pfTraceInput;

   //this function must not be used, therefore it is private
   ahl_tclBaseOneThreadApp& operator=(const ahl_tclBaseOneThreadApp& c);

   //this function must not be used, therefore it is private
   ahl_tclBaseOneThreadApp(const ahl_tclBaseOneThreadApp& c);//lint !e1704 Info 1704 , eliminating lint warnings the way of Lars.

   ahl_tclBaseOneThreadObject* sFindObject(tU16 u16ServiceId, tU16 u16AppId, tU16 u16RegisterId, tU16 u16AppSubId) const;

   tVoid vOnTimerCallback(tVoid* pParam);
   static tVoid vOnQueueCallback(tVoid* pArg);
   virtual tVoid vAppEntry();

public:
   ahl_tclPairList _tclLoadPair;
   ahl_tclPairList _tclSavePair;

   // normaly appID will be set by initinstance
   ahl_tclBaseOneThreadApp(tU16 u16AppId = AMT_C_U16_APPID_INVALID);// constructor
   virtual ~ahl_tclBaseOneThreadApp(); // destructor

   tVoid vPlugTraceIn(TR_tenTraceChan enTraceChannel, OSAL_tpfCallback vTraceInput);   //Hier den ganzen Register Kram rein
   tVoid vUnplugTrace(TR_tenTraceChan enTraceChannel);   //Hier den Trace dichtmachen
   
   virtual tVoid vOnServiceState(tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, tU8 u8ServiceState, tU16 u16SubId);
   virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);
   virtual tVoid vOnNewMessage (amt_tclBaseMessage* poMessage);
   virtual tBool bOnAcceptNewRegister (tU16 u16ServiceId, tU16 u16ClientAppId, tU16 u16ClientSubId, tU16* pu16RegisterId);
   virtual tVoid vOnUnregister (tU16 u16ServiceId, tU16 u16RegisterId);

   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnLoadSettings();
   virtual tVoid vOnSaveSettings();
   virtual tVoid vOnNewSWBlockState(tU32 u32newSWBlockID); // this function is called from a SPM client

   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclBaseMessage* poMessage);
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);
   virtual tVoid vOnTimer(tU16 nTimerId);
   virtual tVoid vOnEvent(OSAL_tEventMask nEvent);

   tVoid vAddObject(ahl_tclBaseOneThreadObject* ptclBaseObject);
   tVoid vRemoveObject(const ahl_tclBaseOneThreadObject* ptclBaseObject);

   tVoid vSendEvent(OSAL_tEventMask nEvent); // only for backward compability
   tBool bPostEvent(OSAL_tEventMask nEvent);

   tBool bStartTimer(tU16 nTimerID,  OSAL_tMSecond nTimeUntilFirstTimerTick, OSAL_tMSecond nTimerTickInterval);
   tBool bStopTimer(tU16 nTimerID);

   /* this function is a helper to filter trace from the specific app, clienthandler, service */
   virtual tBool bTraceClassFilter(tU16 u16Level) const;

   tBool bRegisterForAppInfoMsg (tU16 u16ApplicationId, tU16 u16ServiceId, tBool bRegister = TRUE);

   virtual tVoid vOnAsyncRegisterConf (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId);

   virtual tVoid vOnAsyncRegisterConfExt (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId, tU8 u8AsyncRegisterConfStatus);

   virtual tVoid vOnNewAppStateNotify(tU32 /*u32OldAppState*/, tU32 /*u32AppState*/) {};

protected:
   virtual tBool bGetServiceVersion (tU16 u16ServiceID, tU16 &rfu16MajorVersion, tU16 &rfu16MinorVersion, tU16 &rfu16PatchVersion);
   virtual tVoid vOnRegistrationRemoved(tU16 u16ServiceId, tU16 u16ServerAppId, tU16 u16SourceSubId);
   virtual tVoid vTraceInternalState(TR_tenTraceLevel enLevel);
}; 

#endif //_AHL_MAINONETHREAD_H_

