/*******************************************************************************
*
* FILE:          sortlib_helper.h
*
* SW-COMPONENT:  Sorting Lib
*
* PROJECT:       Bosch-CMD
*
* DESCRIPTION:   Sorting Lib for Sqlite
*
* AUTHOR:
*
* COPYRIGHT:     (c) 2011 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/
#ifndef SORTLIB_HELPER_H
#define SORTLIB_HELPER_H

#ifndef FALSE
  #define FALSE (0)
#endif

#ifndef TRUE
  #define TRUE (1)
#endif

#define SORTLIB_LESS       -1
#define SORTLIB_EQUAL      0
#define SORTLIB_GREATER    1
#define SORTLIB_UTF_CODE_0 48
#define SORTLIB_UTF_CODE_9 57

#define SORTLIB_IS_DIGIT(c)  ( (SORTLIB_UTF_CODE_0 <= (c)) && (SORTLIB_UTF_CODE_9 >= (c)) )

#define SORTLIB_COMPARE_NUMS(num1,num2) ( ( num1 > num2 ) ? SORTLIB_GREATER : ( ( num1 < num2 ) ? SORTLIB_LESS : SORTLIB_EQUAL ) )

#define SORTLIB_ARRAY_SIZE 65535

typedef struct _sortlib_inputData__
{
  const char* s1;
  unsigned len1;
  unsigned index1;
  unsigned lastIndex1;

  const char* s2;
  unsigned len2;
  unsigned index2;
  unsigned lastIndex2;

  unsigned ucs1;
  unsigned ucs2;

} sortlib_inputData;


#endif //SORTLIB_HELPER_H
