/*******************************************************************************
*
* FILE:          sortlib.h
*
* SW-COMPONENT:  Sorting Lib
*
* PROJECT:       Bosch-CMD
*
* DESCRIPTION:   Sorting Lib for Sqlite
*
* AUTHOR:
*
* COPYRIGHT:     (c) 2011 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef SORTLIB_H
#define SORTLIB_H

#ifdef VARIANT_S_FTR_ENABLE_NDS
   #define SQLITE_S_IMPORT_INTERFACE_BASE
   #include "nds_sqlite_if.h"
#else
   #include "sqlite3.h"
#endif

/*
** After registering the new sort function using sortlib_register_sort_function
** Use this macro for getting the sorted data from the sqlite database.
** The sql query should contain the "COLLATE" clause, for e.g.:-
** "SELECT * FROM tableName ORDER BY columnName COLLATE "SORTLIB_COLLATE_NAME //Macro use
**                ---OR---
** "SELECT * FROM tableName ORDER BY columnName COLLATE SORT_LIB" //Direct use
*/
#define SORTLIB_COLLATE_NAME "SORT_LIB"

#ifdef __cplusplus
extern "C"
{
#endif //__cplusplus

  int sortlib_register_sort_function( sqlite3* handle );
  int sortlib_compare(const void *string1, const void *string2);
  int sortlib_string_compare(const char* string1, int len1, const char* string2, int len2);
  unsigned sortlib_get_char_sort_prio(unsigned u32Unicode32BitCodePoint);  // function added for vertical keyboard

#ifdef __cplusplus
}
#endif //__cplusplus

#endif  //SORTLIB_H
