/*****************************************************************************
* FILE:         veda_AppMain.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vehicledata
* Template:     applMain.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "veda_AppMain.h"

// veda_tclAppMainIncludes: user specific code start
#include "veda_DiagSystemSetListener.h"
// veda_tclAppMainIncludes: user specific code end

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_APPLICATION
#include "trcGenProj/Header/veda_AppMain.cpp.trc.h"
#endif


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/

// Static self reference to be used in function callbacks.
veda_tclAppMain* veda_tclAppMain::_poMainAppInstance = NULL;

tUChar  veda_tclAppMain::_auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE] = {0};

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
* FUNCTION   : veda_tclAppMain::theServer()
* DESCRIPTION: Creates new server object by using the singleton pattern.
* PARAMETER  : None.
* RETURNVALUE: Pointer to the instance of this application.
*******************************************************************************/
veda_tclAppMain* veda_tclAppMain::theServer()
{
   if ( NULL == _poMainAppInstance )
   {
      _poMainAppInstance = new veda_tclAppMain();
   }
   return _poMainAppInstance;
}


/*******************************************************************************
*
* FUNCTION: veda_tclAppMain::veda_tclAppMain()
*
* DESCRIPTION: Constructor.
*
*              Initialize static self reference to be used in function
*              callbacks.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
veda_tclAppMain::veda_tclAppMain():ahl_tclBaseOneThreadApp(CCA_C_U16_APP_VD_VEHICLE_DATA)
{
   ETG_TRACE_USR4(("veda_tclAppMain() entered."));

   veda_tclAppMain::_poMainAppInstance   = this;

   // veda_tclAppMainConstructor: user specific code start
   m_poServiceDiaglib = NULL;
   m_poSystemSetListener = NULL;
   
   if ( OSAL_OK != OSAL_s32TimerCreate( _vOneSecTimerCallback, (tPVoid)this, &_hOneSecTimer ) )
   {
      ETG_TRACE_ERR(("_vOnesecTimerCreate():OSAL_s32TimerCreate Failed"));
      _hOneSecTimer = OSAL_C_INVALID_HANDLE;
   }
   if ( OSAL_OK != OSAL_s32TimerCreate( _vOneLongDataTimerCallback, (tPVoid)this, &_hLongDataTimer ) )
   {
      ETG_TRACE_ERR(("_vOneLongDataTimer:OSAL_s32TimerCreate Failed for Long Data"));
      _hLongDataTimer = OSAL_C_INVALID_HANDLE;
   }
   // veda_tclAppMainConstructor: user specific code end

   vTracePlugIn();
}

/*******************************************************************************
*
* FUNCTION: veda_tclAppMain::~veda_tclAppMain()
*
* DESCRIPTION: Destructor.
*
*              Invalidate static self reference.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
veda_tclAppMain::~veda_tclAppMain()
{
   ETG_TRACE_USR4(("~veda_tclAppMain() entered."));

   // --- unplug TTFIS trace ---
   vTraceUnplug();   

   // veda_tclAppMainDestructor: user specific code start
   m_poServiceDiaglib = NULL;
   m_poSystemSetListener = NULL;
   
   if (_hOneSecTimer != OSAL_C_INVALID_HANDLE)
   {
      if ( OSAL_OK == OSAL_s32TimerDelete( _hOneSecTimer ) )
      {
         _hOneSecTimer = OSAL_C_INVALID_HANDLE;
         ETG_TRACE_USR4(("_hOneSecTimer Timer is deleted"));
      }
   }
   if (_hLongDataTimer != OSAL_C_INVALID_HANDLE)
   {
      if ( OSAL_OK == OSAL_s32TimerDelete( _hLongDataTimer ) )
      {
         _hLongDataTimer = OSAL_C_INVALID_HANDLE;
         ETG_TRACE_USR4(("_hLongDataTimer Timer is deleted"));
      }
   }
   // veda_tclAppMainDestructor: user specific code end

   veda_tclAppMain::_poMainAppInstance = NULL;
}

/*******************************************************************************
*
* FUNCTION: tBool veda_tclAppMain::vStart()
*
* DESCRIPTION:
*
* PARAMETER: None.
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid veda_tclAppMain::vStart(tVoid)
{

   // veda_tclAppMainvStart: user specific code start
   // veda_tclAppMainvStart: user specific code end

   vGetReferences();
   vStartCommunication();
}

/*******************************************************************************
*
* FUNCTION: tBool veda_tclAppMain::bOnInit()
*
* DESCRIPTION: This function is called by the CCA framework before starting any
*              CCA message related communication action. As default this
*              function always returns TRUE. The user has to implement all his
*              local application initialization (create client and service
*              handler, create worker threads, allocate application memory,...).
*              If returns TRUE, initialization could be successfully performed
*              and framework will register application, else, a reset of the
*              system is forced immediately.
*
*              This function is the counterpart of vOnApplicationClose().
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = Application successfully initialized.
*              FALSE = Application NOT successfully initialized.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
*******************************************************************************/
tBool veda_tclAppMain::bOnInit()
{
   tBool bSuccess = TRUE;

   ETG_TRACE_USR4(("bOnInit() entered."));

   // veda_tclAppMainbOnInit: user specific code start
   // create diaglib-service
   m_poServiceDiaglib = new diaglib::tclServiceDiaglib(this, 0x01);
   if (NULL == m_poServiceDiaglib)
   {
     bSuccess = FALSE;
     NORMAL_M_ASSERT_ALWAYS();
   }
   else
   {
      ETG_TRACE_USR1(("bOnInit() - DIAGLib service created"));

      diaglib::tclSystemSetIF* m_poSystemSetIF;

      // Get SystemSet Interface (the referenced IF-object will be created within diaglib)
      // so it is no problem that the pointer is destroyed here when leaving the scope here
      m_poSystemSetIF = m_poServiceDiaglib->poGetSysSet();

      // create our listener object here
      m_poSystemSetListener = new veda_tclSystemSetListener(m_poSystemSetIF, this);

      // register our listeners at DIAGlib
      if (m_poSystemSetListener != NULL)
      {
         m_poSystemSetIF->vRegisterListener( SYSSETID_VEHI_FUNC_EXTE, diaglib::EN_TYPE_DEFAULT_TEF, m_poSystemSetListener );
         m_poSystemSetIF->vRegisterListener( SYSSETID_VEHI_FUNC_EXTE, diaglib::EN_TYPE_DEFAULT_HMI, m_poSystemSetListener );
		 m_poSystemSetIF->vRegisterListener( SYSSETID_VEHI_FUNC_EXTE, diaglib::EN_TYPE_DEFAULT_CUSTOMER, m_poSystemSetListener );
         m_poSystemSetIF->vRegisterListener( SYSSETID_VEHI_FUNC_EXTE, diaglib::EN_TYPE_CODING,      m_poSystemSetListener );

         ETG_TRACE_USR1(("bOnInit() - DIAG SystemSet Listener registered"));
      }
      else
      {
         ETG_TRACE_USR1(("bOnInit() - ERROR - DIAG SystemSet Listener could not be registered"));
      }
   }
   // veda_tclAppMainbOnInit: user specific code end

   
   return bSuccess;
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclAppMain::vOnApplicationClose()
*
* DESCRIPTION: This function is called by the CCA framework to indicate the
*              imminent shutdown of the application. The user has to implement
*              the de-initialization of all his local application data (destroy
*              client and service handler, destroy worker threads, free
*              application memory, ... ). After this function call the
*              destructor of this application will be called.
*
*              This function is the counterpart of bOnInit().
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
*******************************************************************************/
tVoid veda_tclAppMain::vOnApplicationClose()
{
   ETG_TRACE_USR4(("vOnApplicationClose() entered."));

   // veda_tclAppMainvOnApplicationClose: user specific code start
   if (m_poServiceDiaglib != NULL )
   {
      delete m_poServiceDiaglib;
      m_poServiceDiaglib = NULL;
   }
   if (m_poSystemSetListener != NULL )
   {
      delete m_poSystemSetListener;
      m_poSystemSetListener = NULL;
   }
   // veda_tclAppMainvOnApplicationClose: user specific code end

   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclAppMain::vOnTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called by the CCA framework on the expiration
*              of a previously via function bStartTimer() started timer. The
*              expired timer is forwarded to the respective service or
*              client-handler via a call of vProcessTimer().
*
*              The function is called from this applications context and
*              therefore no interthread programming rules must be considered
*              and the application methods and/or member variables can be
*              accessed without using the static self reference
*              'm_poMainAppInstance'.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tVoid veda_tclAppMain::vOnTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("vOnTimer(id: %d) entered.", u16TimerId ));

   // veda_tclAppMainvOnTimer: user specific code start
   // veda_tclAppMainvOnTimer: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclAppMain::vOnLoopback
*                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called by the CCA framework if a message was
*              sent from one if this applications services or from a
*              callback-handler of this application (so called self or loopback
*              messages). The message can be forwarded to the respective service
*              via a call of vOnLoopbackService(). If there is no service
*              registered for this message then the user has the option to
*              directly evaluate the message in the default block of this.
*              methods switch-clause.
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*
*            [IN] poMessage = Message object.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
*******************************************************************************/
tVoid veda_tclAppMain::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vOnLoopback() entered with service ID %04x.", u16ServiceID));

   gm_tclStreamMessage oVisitorMsg(poMessage);

   veda_tclBaseIf::TMsg oMsg;

   if (oVisitorMsg.u32GetDataSize() >= sizeof(oMsg)) {
      memcpy((tVoid*)&oMsg, oVisitorMsg.pcocGetData(), sizeof(oMsg));
      
      if (oMsg.eCmd != (veda_tclBaseIf::ECmdTypes)poMessage->u16GetFunctionID()) {
         ETG_TRACE_FATAL(("vOnLoopbackService() failed. iFID = 0x%04x, cmd = 0x%04x.", (tU32)poMessage->u16GetFunctionID(), (tU32)oMsg.eCmd));
         NORMAL_M_ASSERT_ALWAYS();
      }
      else {
         ETG_TRACE_USR4(("vOnLoopbackService() entered. iFID = 0x%04x, u32MsgContent = %u.", (tU32)oMsg.eCmd, oMsg.u.u32Data));
         //post message
         vDispatchInternalMsg(&oMsg);
      }
   }
   else {
      ETG_TRACE_FATAL(("vOnLoopbackService() failed. message data size = %d, internal message size = %d.", (tU32)oVisitorMsg.u32GetDataSize(), (tU32)sizeof(oMsg) ));
      NORMAL_M_ASSERT_ALWAYS();
   }

}


tVoid veda_tclAppMain::vDispatchInternalMsg(veda_tclBaseIf::TMsg* pInternalMsg)
{
   if (pInternalMsg->eCmd == veda_tclBaseIf::eCmdTraceCmdReceived) {
      //vHandleTraceMessageGen(_auchTraceInputBuffer);
       vHandleTraceMessage(_auchTraceInputBuffer);
 
       bpstl::set<veda_tclBaseIf*>::iterator iter;
       for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
            (*iter)->vHandleTraceMessage(_auchTraceInputBuffer);
       }
   }
   else {
      bpstl::set<veda_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (pInternalMsg->strClassName[0] != 0) 
         {
            if (0 == OSAL_s32StringCompare((*iter)->getIfName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
            if (0 == OSAL_s32StringCompare((*iter)->getName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
         } else {
            (*iter)->vHandleMessage(pInternalMsg);
         }
      }
   }
}

#ifndef _CCA_APPLICATION_WO_SERVICE
tVoid veda_tclAppMain::vPostInternalMessage(veda_tclBaseIf::TMsg* pInternalMsg)
{
   ETG_TRACE_USR1(("veda_tclAppMain::vPostInternalMessage(): post internal message '%d'.", ETG_CENUM(veda_tclBaseIf::ECmdTypes, pInternalMsg->eCmd)));
   
   // veda_tclAppMainPostInternStartUserSpecificClassCode: user specific code start
   // veda_tclAppMainPostInternStartUserSpecificClassCode: user specific code end

   gm_tclStreamMessage oStreamMsg(u16GetAppId(), u16GetAppId(), 0, 0, 63, (tU16)pInternalMsg->eCmd, AMT_C_U8_CCAMSG_OPCODE_SET, sizeof(veda_tclBaseIf::TMsg) );
   if (OSAL_NULL != oStreamMsg.pu8GetSharedMemBase()) {
       oStreamMsg.vSetData((const tChar*)pInternalMsg);
       if ( oStreamMsg.bIsValid() ) {
          if (enPostMessage(&oStreamMsg, TRUE) != AIL_EN_N_NO_ERROR) {
             NORMAL_M_ASSERT_ALWAYS();
          }
       } else {
          NORMAL_M_ASSERT_ALWAYS();
       }
   } else {
       ETG_TRACE_ERRMEM(("veda_tclAppMain::vPostInternalMessage(): message %d with data size %d bytes could not create! No shared memory.",
               ETG_CENUM(veda_tclBaseIf::ECmdTypes, pInternalMsg->eCmd), sizeof(veda_tclBaseIf::TMsg) ));
   }

   // veda_tclAppMainPostInternEndUserSpecificClassCode: user specific code start
   // veda_tclAppMainPostInternEndUserSpecificClassCode: user specific code end

}
#endif

/*******************************************************************************
* FUNCTION   : veda_tclAppMain::vTracePlugIn
* DESCRIPTION: Activate the TTFIS command channel for vehicledata
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid veda_tclAppMain::vTracePlugIn(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;

   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_VEHICLEDATA;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)veda_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &MyTraceChannel);
      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TracePlugin"));
      }
      // close trace device and clear channel
      OSAL_s32IOClose(desc);    
   }
}

/*******************************************************************************
* FUNCTION   : veda_tclAppMain::vTraceUnplug
* DESCRIPTION: Deactivate the TTFIS command channel for vehicledata
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid veda_tclAppMain::vTraceUnplug(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;
   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_VEHICLEDATA;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)veda_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &MyTraceChannel);

      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TraceUnplug"));
      }

      // close trace device and clear channel
      OSAL_s32IOClose(desc);    
   }
}

/*******************************************************************************
* FUNCTION   : veda_tclAppMain::vTraceCallbackFunction
* DESCRIPTION: Callback function for TTFIS command channel of __APP_NAME__
* PARAMETER  : [IN] puchData = buffer with trace input data
* RETURNVALUE: None
*******************************************************************************/
tVoid veda_tclAppMain::vTraceCallbackFunction(const tUChar* puchData)
{
#ifdef _CCA_APPLICATION_WO_SERVICE

   //veda_tclAppMain::vHandleTraceMessageGen(puchData);
   veda_tclAppMain::vHandleTraceMessage(puchData);
#else
   if (puchData[0] < TRACE_BUFFER_MAXSIZE) {
      ETG_TRACE_USR4(("vTraceCallbackFunction(), length of TTFis message=%u\n Data: %02x",puchData[0],ETG_LIST_LEN(puchData[0]), ETG_LIST_PTR_T8(&(puchData[1]))));
      memcpy(_auchTraceInputBuffer, puchData, puchData[0]+1);

      if (NULL != _poMainAppInstance) {
         veda_tclBaseIf::TMsg oMsg;
         (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
         
         oMsg.eCmd = veda_tclBaseIf::eCmdTraceCmdReceived;
         oMsg.strClassName[0]=0;
         oMsg.u.u32Data = 0;

         _poMainAppInstance->vPostInternalMessage(&oMsg);
      }
   } else {
      ETG_TRACE_ERR(("MAIN :: Input trace command too long"));
   }
#endif // VARIANT_S_FTR_ENABLE_TRACE_CMD_DIRECT
}

tVoid veda_tclAppMain::vLoadRegistry() 
{
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t)"/dev/root/opt/bosch/base/registry/procveda.reg")) == OSAL_OK)
        {
            ETG_TRACE_FATAL(("REGISTRY loaded '/opt/bosch/base/registry/procveda.reg'!"));

        } else {
            ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY  '/opt/bosch/base/registry/procveda.reg'!"));
        }
    }
    OSAL_s32IOClose(regHandle);
}

#ifndef _CCA_APPLICATION_WO_SERVICE

tVoid veda_tclAppMain::vPostMsgCvmEvent(const tChar* strIfName, tU32 u32CvmEvent) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgCvmEvent(): eCvmEvent message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eCvmEvent;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32CvmEvent;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgOneSecondTimeoutEvent(const tChar* strIfName, tU32 u32OneSecondTimeoutEvent) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgOneSecondTimeoutEvent(): eOneSecondTimeoutEvent message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eOneSecondTimeoutEvent;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32OneSecondTimeoutEvent;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgLongDataTimeoutEvent(const tChar* strIfName, tU32 u32OneSecondTimeoutEvent) {

  ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgLongDataTimeoutEvent(): eLongDataTimeout message to '%50s'", strIfName));

     veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eLongDataTimeoutEvent;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32OneSecondTimeoutEvent;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgCmdCsmBusIndReceived(const tChar* strIfName, tU32 u32CmdCsmBusIndReceived) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgCmdCsmBusIndReceived(): eCmdCsmBusIndReceived message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eCmdCsmBusIndReceived;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32CmdCsmBusIndReceived;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgReverseGearStateChanged(const tChar* strIfName, tU32 u32ReverseGearStateChanged) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgReverseGearStateChanged(): eReverseGearStateChanged message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eReverseGearStateChanged;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ReverseGearStateChanged;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgSetLanguage(const tChar* strIfName, tU32 u32SetLanguage) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgSetLanguage(): eSetLanguage message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eSetLanguage;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32SetLanguage;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgSetLanguageSyncSource(const tChar* strIfName, tU32 u32SetLanguageSyncSource) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgSetLanguageSyncSource(): eSetLanguageSyncSource message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eSetLanguageSyncSource;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32SetLanguageSyncSource;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgGetCSMEnggData(const tChar* strIfName, tU32 u32GetCSMEnggData) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgGetCSMEnggData(): eGetCSMEnggData message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eGetCSMEnggData;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32GetCSMEnggData;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgAccessoryStateChanged(const tChar* strIfName, tU32 u32AccessoryStateChanged) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgAccessoryStateChanged(): eAccessoryStateChanged message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eAccessoryStateChanged;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32AccessoryStateChanged;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgIgnitionStateChanged(const tChar* strIfName, tU32 u32IgnitionStateChanged) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgIgnitionStateChanged(): eIgnitionStateChanged message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eIgnitionStateChanged;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32IgnitionStateChanged;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgRegCsmBusStates(const tChar* strIfName, tU32 u32RegCsmBusStates) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgRegCsmBusStates(): eRegCsmBusStates message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eRegCsmBusStates;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32RegCsmBusStates;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgReadCsmBusStates(const tChar* strIfName, tU32 u32ReadCsmBusStates) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgReadCsmBusStates(): eReadCsmBusStates message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eReadCsmBusStates;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32ReadCsmBusStates;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgDefaultSetting(const tChar* strIfName, tU32 u32DefaultSetting) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgDefaultSetting(): eDefaultSetting message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eDefaultSetting;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32DefaultSetting;
    vPostInternalMessage(&oMsg);
}
tVoid veda_tclAppMain::vPostMsgTirePressureSet(const tChar* strIfName, tU32 u32TirePressureSet) {

    ETG_TRACE_USR4(("veda_tclAppMain::vPostMsgTirePressureSet(): eTirePressureSet message to '%50s'", strIfName));

    veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = veda_tclBaseIf::eTirePressureSet;
    OSAL_szStringNCopy(oMsg.strClassName, strIfName, sizeof(oMsg.strClassName)-1);
    oMsg.u.u32Data = u32TirePressureSet;
    vPostInternalMessage(&oMsg);
}
#endif

// veda_tclAppMainUserSpecificClassCode: user specific code start
tVoid veda_tclAppMain::vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState)
{
   ETG_TRACE_USR4(("vOnNewAppStateNotify: OldAppState 0x%02x --> NewAppState 0x%02x.", u32OldAppState, u32AppState ));

   if ( u32OldAppState != u32AppState )
   {
      switch(u32AppState)
      {
         case AMT_C_U32_STATE_NORMAL:
         {
            if (_hOneSecTimer != OSAL_C_INVALID_HANDLE)
            {
               if ( OSAL_s32TimerSetTime( _hOneSecTimer, 1000, 1000 ) != OSAL_OK )
               {
                  ETG_TRACE_ERR(("vOnNewAppStateNotify: vStartTimer() OSAL_s32TimerSetTime Failed"));
               }
               else
               {
                  ETG_TRACE_USR4(("vOnNewAppStateNotify: Started One Second Timer"));
               }
            }
            else
            {
                ETG_TRACE_ERR(("vOnNewAppStateNotify: _hOneSecTimer Time Handle Invalid"));
            }
			if (_hLongDataTimer != OSAL_C_INVALID_HANDLE)
            {
               if ( OSAL_s32TimerSetTime( _hLongDataTimer, 200, 200 ) != OSAL_OK )
               {
                  ETG_TRACE_ERR(("vOnNewAppStateNotify: Long Data vStartTimer() OSAL_s32TimerSetTime Failed"));
               }
               else
               {
                  ETG_TRACE_USR4(("vOnNewAppStateNotify: Started 200 millisecond timer"));
               }
            }
            else
            {
                ETG_TRACE_ERR(("vOnNewAppStateNotify: _hLongDataTimer Time Handle Invalid"));
            }
         }
         break;
            
         case AMT_C_U32_STATE_DIAGNOSIS:
         case AMT_C_U32_STATE_PAUSE:
         case AMT_C_U32_STATE_OFF:
         default:
         {
            if (_hOneSecTimer != OSAL_C_INVALID_HANDLE)
            {
               if ( OSAL_s32TimerSetTime( _hOneSecTimer, 0, 0 ) != OSAL_OK )
               {
                  ETG_TRACE_ERR(("vOnNewAppStateNotify: vStopTimer() OSAL_s32TimerSetTime Failed"));
               }
               else
               {
                  ETG_TRACE_USR4(("vOnNewAppStateNotify: OldAppState 0x%02x --> NewAppState 0x%02x.", u32OldAppState, u32AppState ));
               }
            }
            else
            {
                ETG_TRACE_ERR(("vOnNewAppStateNotify: _hOneSecTimer Time Handle Invalid"));
            }
			
            if (_hLongDataTimer != OSAL_C_INVALID_HANDLE)
            {
               if ( OSAL_s32TimerSetTime( _hLongDataTimer, 0, 0 ) != OSAL_OK )
               {
                  ETG_TRACE_ERR(("vOnNewAppStateNotify: Long Data vStopTimer() OSAL_s32TimerSetTime Failed"));
               }
               else
               {
                  ETG_TRACE_USR4(("vOnNewAppStateNotify: OldAppState 0x%02x --> NewAppState 0x%02x.", u32OldAppState, u32AppState ));
               }
            }
            else
            {
                ETG_TRACE_ERR(("vOnNewAppStateNotify: _hLongDataTimer Time Handle Invalid"));
            }
         }
         break;
      }
   }
}

tVoid veda_tclAppMain::_vOneSecTimerCallback(tVoid *pArg)
{
    veda_tclAppMain *poThisMain = (veda_tclAppMain *) pArg;
    ETG_TRACE_USR4(("veda_tclAppMain::_vOneSecTimerCallback() entered "));
    if (poThisMain)
    {
        tChar cClassName[] = "I_veda_tclClientVcan";
        poThisMain->vPostMsgOneSecondTimeoutEvent(cClassName, 0);
    }
}
tVoid veda_tclAppMain::_vOneLongDataTimerCallback(tVoid *pArg)
{
    veda_tclAppMain *poThisMain = (veda_tclAppMain *) pArg;
    ETG_TRACE_USR4(("veda_tclAppMain::_vOneLongDataTimerCallback() entered "));
    if (poThisMain)
    {
        tChar cClassName[] = "I_veda_tclClientVcanCanAdaptor";
        poThisMain->vPostMsgLongDataTimeoutEvent(cClassName, 0);
    }
}
// veda_tclAppMainUserSpecificClassCode: user specific code end


/*******************************************************************************
*                                       E O F
*******************************************************************************/
