/*****************************************************************************
* FILE:         veda_ServiceVehicle.h
* PROJECT:      G3G project
* SW-COMPONENT: vehicledata
* Template:     ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __veda_ServiceVehicle_H_
#define __veda_ServiceVehicle_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_veda_ServiceVehicle.h"
#include "veda_AppMain.h"

// veda_tclServiceVehicle_Include: user specific code start
// veda_tclServiceVehicle_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class veda_tclServiceVehicleCallbackIF;

class veda_tclServiceVehicle : public Iveda_tclServiceVehicle
{
protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:

   veda_tclServiceVehicle(tVoid); 
   veda_tclServiceVehicle(veda_tclAppMain* poMainAppl);
   virtual ~veda_tclServiceVehicle();

   virtual tVoid vSetCallbackIf(veda_tclServiceVehicleCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // veda_tclServiceVehicleDeclarations: user specific code start
   virtual tVoid vUpdateCANSpeedLimit1(const tU8 u8SpeedLimit1);
   virtual tVoid vUpdateCANSpeedLimit2(const tU8 u8SpeedLimit2);
   virtual tVoid vUpdateCANSpeedLimitDisplay(const tU8 u8SpeedLimitDisplay);
   virtual tVoid vUpdateSpeedLimitDisplayUnit(const tU8 u8SpeedLimitDisplayUnit);
   virtual tVoid vUpdateOverSpeedDisplay(tBool bOverSpeed);
   virtual tVoid vUpdateFreeSpeedDisplay(tBool bFreeSpeed);

   virtual tVoid vCANUpdateDistanceTotal(tU32 u32DistanceTotal, tU32 u32LastValidDistanceTotal, tBool bStatus);
   virtual tVoid vCANUpdateDistanceTotalUnit(tU8 u8DistanceTotalUnit, tBool bStatus);
   // veda_tclServiceVehicleDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'veda_tclServiceVehicle' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   veda_tclServiceVehicle& operator = (const veda_tclServiceVehicle &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
public:
   virtual const tChar* getName() const { return "veda_tclServiceVehicle"; };
   
   virtual tVoid vHandleMessage(veda_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
private:
   veda_tclServiceVehicleCallbackIF* _poCallbackIf;

public:



    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendDistanceUnitStatus(vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit);
   virtual tVoid sendFuelConsumptionUnitStatus(vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit);
   virtual tVoid sendTemperatureUnitStatus(vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit);
   virtual tVoid sendLanguageStatus(vehicle_fi_tcl_e8_Language_Code Language, bpstl::vector<vehicle_fi_tcl_Language_SourceTable, bpstl::allocator<vehicle_fi_tcl_Language_SourceTable> > LangTable);
   virtual tVoid sendLanguageSyncSourceStatus(vehicle_fi_tcl_e8_Language_SourceId Language);
   virtual tVoid sendMeterLanguageKnowledgeStatus(vehicle_fi_tcl_e8_Meter_LangKnowledge State);
   virtual tVoid sendHandBrakeStatus(vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus e8Status);
   virtual tVoid sendIgnitionStatus(vehicle_fi_tcl_e8_Vehicle_Ignition e8Status);
   virtual tVoid sendSpeedStatus(tU16 SpeedValue);
   
   virtual tVoid sendPartialMuteStatus(tU8 PartialMuteValue);
   virtual tVoid sendSwivMonAutoOpenStatus(tU8 SwivMonAutoOpenValue);
   virtual tVoid sendVehicleDriverDoorOpenStatus(tU8 DriverDoorOpenValue);
   virtual tVoid sendDateModeStatus(tU8 DateModeValue);
   virtual tVoid sendTmModeStatus(tU8 TmModeValue);
   //camera
   virtual tVoid sendActCam1Status(tU8 ActCam1Value);
   //camera2
   virtual tVoid sendActCam2Status(tU8 ActCam2Value);
   //camera3
   virtual tVoid sendActCam3Status(tU8 ActCam3Value);
   //camera4
   virtual tVoid sendActCam4Status(tU8 ActCam4Value);
   //camera5
   virtual tVoid sendActCam5Status(tU8 ActCam5Value);
   //camera6
   virtual tVoid sendActCam6Status(tU8 ActCam6Value);
   //camera7
   virtual tVoid sendActCam7Status(tU8 ActCam7Value);
   //camsplit
   virtual tVoid sendCamSplitQuadStatus(tU16 CamSplitQuadValue);
   //MuteDev
   virtual tVoid sendMuteDevStatus(tU8 MuteDevStatus);
   //sysVolt
   virtual tVoid sendSysVoltStatus(tU8 SysVoltStatus);
   //ParkingBreakSwitch
   virtual tVoid sendParkingBreakSwitchStatus(tU8 ParkingBreakSwitchValue);
   //RearCamReq
   virtual tVoid sendRearCamReqStatus(tU8 RearCamReqValue);
   //VIN
   virtual tVoid sendVINStatus(tU32 VINValue);
    //TimeDate
   virtual tVoid sendTimeDateStatus(tU64 TimeDateValue);
    //PhoneCallCommand
   virtual tVoid sendPhoneCallCmdStatus(tU8 PhoneCallCmdValue);
       //RCNextBtn
   virtual tVoid sendRCNextBtnStatus(tU8 RCNextBtnValue);
    //RCPrevBtn
   virtual tVoid sendRCPrevBtnStatus(tU8 RCPrevBtnValue);
    //VolumeCommand
   virtual tVoid sendVolumeCmdStatus(tU8 VolumeCmdValue);
    //ActCam8
   virtual tVoid sendActCam8Status(tU8 ActCam8Value);
   //ActCam9
   virtual tVoid sendActCam9Status(tU8 ActCam9Value);
   //ActCam10
   virtual tVoid sendActCam10Status(tU8 ActCam10Value);
    //ActCam11
   virtual tVoid sendActCam11Status(tU8 ActCam11Value);
   //ActCam12
   virtual tVoid sendActCam12Status(tU8 ActCam12Value);
   //ActCam13
   virtual tVoid sendActCam13Status(tU8 ActCam13Value);
      //ActCam14
   virtual tVoid sendActCam14Status(tU8 ActCam14Value);
   //ActCam15
   virtual tVoid sendActCam15Status(tU8 ActCam15Value);
   //ActCam16
   virtual tVoid sendActCam16Status(tU8 ActCam16Value);
  //ActCam17
   virtual tVoid sendActCam17Status(tU8 ActCam17Value);
   //SourceCommand
   virtual tVoid sendSourceCmdStatus(tU8 SourceCmdValue); 
   //CabinSourceCommand
   virtual tVoid sendCabinSourceCmdStatus(tU8 CabinSourceCmdValue);  
   //CabinVolumeCommand
   virtual tVoid sendCabinVolumeCmdStatus(tU8 CabinVolumeCmdValue);
   //CabinTunerCommand
   virtual tVoid sendCabinTunerCmdStatus(tU8 CabinTunerCmdValue);
   //CabinTrackCommand
   virtual tVoid sendCabinTrackCmdStatus(tU8 CabinTrackCmdValue);
   //CabinPlaylistCommand
   virtual tVoid sendCabinPlaylistCmdStatus(tU8 CabinPlaylistCmdValue);
      		//Track Command 
	virtual tVoid sendTrackCommandStatus(tU8 TrackCommandValue) ;
	 //SMARTVR 
	virtual tVoid sendSMARTVRStatus(tU8 SMARTVRValue) ;
	//Tuner Command 
	virtual tVoid sendTunerCommandStatus(tU8 TunerCommandValue) ;
	//TA Command 
	virtual tVoid sendTACommandStatus(tU8 TACommandValue) ;
	//RDS Command 
	virtual tVoid sendRDSCommandStatus(tU8 RDSCommandValue) ;
   //Voice RecgnCommand
   virtual tVoid sendVoiceRecgCmdStatus(tU8 VoiceRecgCommandValue);
      //SW Version 
   virtual tVoid SendDeviceInfoSWversionStatus(tU32 u32SWversionValue);
   //TotalVehDistDiag 
   virtual tVoid SendTotalVehDistDiagStatus(tU32 u32TotalVehDistDiagValue);
    //Phone Pwr 
   virtual tVoid sendPhonePwrCmdStatus(tU8 PhonePwrCmdValue);
   //Radio Pwr 
   virtual tVoid sendRadioPwrCmdStatus(tU8 RadioPwrCmdValue);
   //CamTxt
   virtual tVoid sendCamTxtStatus(tU64 CamTxtValue);
   //VIN_64
   virtual tVoid sendVIN_64Status(tU64 VIN_64Value);
   //PrivacyResetReq
   virtual tVoid sendPrivacyResetReqStatus(tU8 PrivacyResetReqValue);
   
   virtual tVoid sendSpeedLimitStatus(tU8 SpeedLimit1, tU8 SpeedLimit2, tU8 Display, vehicle_fi_tcl_e8_Vehicle_DistanceUnit DisplayUnit, tBool OverSpeed, tBool FreeSpeed);
   virtual tVoid sendReverseGearStatus(tU8 State);
   virtual tVoid sendSpeedLockStatus(tU8 State);
   virtual tVoid sendDrivingStateStatus(tU8 State);
   virtual tVoid sendGlobalVehicleWarningStateStatus(vehicle_fi_tcl_e8_Vehicle_WarningState State);
   virtual tVoid sendVehicleStatesStatus(vehicle_fi_tcl_e8_Vehicle_States State);
   virtual tVoid sendNetworkStateStatus(tU8 u8BusState_MCAN, tU8 u8BusState_VCAN, tU8 u8MuteState_MCAN, tU8 u8MuteState_VCAN, tBool bBusOff_MCAN, tBool bBusOff_VCAN, tBool bBusOff, tBool bMute_MCAN, tBool bMute_VCAN, std::vector<tU8, std::allocator<tU8> > Listu8AbsentState_ECU, std::vector<tU8, std::allocator<tU8> > Listu8MuteStateMCAN_Channel);
   virtual tVoid sendDistanceTotalizerStatus(tU32 DisTotal, tU32 lastValidDisTotal, tU8 Unit, tBool DisTotalStatus);
   virtual tVoid sendMileageStatus(tU32 Mileage);
   virtual tVoid sendAvgFuelEconomyStatus(tU16 FuelEcon);
   virtual tVoid sendTirePressureSupportStatus(tBool PressureSupport);
   virtual tVoid sendTPMSResetSupportStatus(vehicle_fi_tcl_e8_Vehicle_TPMSReset TPMSResetInfo);
   virtual tVoid sendTirePressureSettingStatus(tU16 SettingPressureFront, tU16 SettingPressureRear);

   virtual tBool onDistanceUnitSet(vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onFuelConsumptionUnitSet(vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onTemperatureUnitSet(vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onLanguageSyncSourceSet(vehicle_fi_tcl_e8_Language_SourceId Language, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onTirePressureSettingSet(vehicle_fi_tcl_e8_Vehicle_TirePressureInfo TirePressureRequestInfo, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid onSetLanguageMStart(vehicle_fi_tcl_e8_Language_SourceId SourceId, vehicle_fi_tcl_e8_Language_Code Language);
   virtual tVoid vHandleSetLanguageOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onRequestMeterLanguageSyncMStart(vehicle_fi_tcl_e8_Meter_SyncRequest RequestId);
   virtual tVoid vHandleRequestMeterLanguageSyncOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onCSMEngineeringDataMStart();
   virtual tVoid vHandleCSMEngineeringDataOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSetOSPAlertsStatusMStart(tBool OSPAlert, tBool DangerousAreaAlert);
   virtual tVoid vHandleSetOSPAlertsStatusOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendMediaInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendCallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendCallInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendPhoneInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendXMInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendMainlineInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendCabinAMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendCabinAMediaInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendCabinAMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendCabinAMainlineInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendCabinACallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendCabinACallInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendCabinAPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendCabinAPhoneInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendCabinAXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendCabinAXMInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendNaviCurrentStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendNaviCurrentStreetNameInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendNaviTurnToStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg);
   virtual tVoid vHandleSendNaviTurnToStreetNameInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendNaviDestinationInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg);
   virtual tVoid vHandleSendNaviDestinationInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendNaviTurnToSymbolsInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg);
   virtual tVoid vHandleSendNaviTurnToSymbolsInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendNaviLaneGuidanceInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg);
   virtual tVoid vHandleSendNaviLaneGuidanceInfoMStart(amt_tclServiceData* poMessage);
   virtual tVoid onSendNaviNavigationWarningInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg);
   virtual tVoid vHandleSendNaviNavigationWarningInfoMStart(amt_tclServiceData* poMessage);

   //Cam1ManAct
   virtual tVoid onCam1ManActMStart(tU8 RequestId);
   virtual tVoid sendCam1ManActMResult(tU8 Result);
   virtual tVoid vHandleCam1ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam2ManAct
   virtual tVoid onCam2ManActMStart(tU8 RequestId);
   virtual tVoid sendCam2ManActMResult(tU8 Result);
   virtual tVoid vHandleCam2ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam3ManAct
   virtual tVoid onCam3ManActMStart(tU8 RequestId);
   virtual tVoid sendCam3ManActMResult(tU8 Result);
   virtual tVoid vHandleCam3ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam4ManAct
   virtual tVoid onCam4ManActMStart(tU8 RequestId);
   virtual tVoid sendCam4ManActMResult(tU8 Result);
   virtual tVoid vHandleCam4ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam5ManAct
   virtual tVoid onCam5ManActMStart(tU8 RequestId);
   virtual tVoid sendCam5ManActMResult(tU8 Result);
   virtual tVoid vHandleCam5ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam6ManAct
   virtual tVoid onCam6ManActMStart(tU8 RequestId);
   virtual tVoid sendCam6ManActMResult(tU8 Result);
   virtual tVoid vHandleCam6ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam7ManAct
   virtual tVoid onCam7ManActMStart(tU8 RequestId);
   virtual tVoid sendCam7ManActMResult(tU8 Result);
   virtual tVoid vHandleCam7ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam8ManAct
   virtual tVoid onCam8ManActMStart(tU8 RequestId);
   virtual tVoid sendCam8ManActMResult(tU8 Result);
   virtual tVoid vHandleCam8ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam9ManAct
   virtual tVoid onCam9ManActMStart(tU8 RequestId);
   virtual tVoid sendCam9ManActMResult(tU8 Result);
   virtual tVoid vHandleCam9ManActOpMStart(amt_tclServiceData* poMessage);
  //Cam10ManAct
   virtual tVoid onCam10ManActMStart(tU8 RequestId);
   virtual tVoid sendCam10ManActMResult(tU8 Result);
   virtual tVoid vHandleCam10ManActOpMStart(amt_tclServiceData* poMessage);
  //Cam11ManAct
   virtual tVoid onCam11ManActMStart(tU8 RequestId);
   virtual tVoid sendCam11ManActMResult(tU8 Result);
   virtual tVoid vHandleCam11ManActOpMStart(amt_tclServiceData* poMessage);
  //Cam12ManAct
   virtual tVoid onCam12ManActMStart(tU8 RequestId);
   virtual tVoid sendCam12ManActMResult(tU8 Result);
   virtual tVoid vHandleCam12ManActOpMStart(amt_tclServiceData* poMessage);
  //Cam13ManAct
   virtual tVoid onCam13ManActMStart(tU8 RequestId);
   virtual tVoid sendCam13ManActMResult(tU8 Result);
   virtual tVoid vHandleCam13ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam14ManAct
   virtual tVoid onCam14ManActMStart(tU8 RequestId);
   virtual tVoid sendCam14ManActMResult(tU8 Result);
   virtual tVoid vHandleCam14ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam15ManAct
   virtual tVoid onCam15ManActMStart(tU8 RequestId);
   virtual tVoid sendCam15ManActMResult(tU8 Result);
   virtual tVoid vHandleCam15ManActOpMStart(amt_tclServiceData* poMessage);
   //Cam16ManAct
   virtual tVoid onCam16ManActMStart(tU8 RequestId);
   virtual tVoid sendCam16ManActMResult(tU8 Result);
   virtual tVoid vHandleCam16ManActOpMStart(amt_tclServiceData* poMessage);
     //Cam17ManAct
   virtual tVoid onCam17ManActMStart(tU8 RequestId);
   virtual tVoid sendCam17ManActMResult(tU8 Result);
   virtual tVoid vHandleCam17ManActOpMStart(amt_tclServiceData* poMessage);
   //PrivacyResetAck
   virtual tVoid onPrivacyResetAckMStart(tU8 RequestId);
   virtual tVoid sendPrivacyResetAckMResult(tU8 Result);
   virtual tVoid vHandlePrivacyResetAckOpMStart(amt_tclServiceData* poMessage);
   //DispCamCls
   virtual tVoid onDispCamClsMStart(tU8 RequestId);
   virtual tVoid sendDispCamClsMResult(tU8 Result);
   virtual tVoid vHandleDispCamClsOpMStart(amt_tclServiceData* poMessage);
   //PhoneBTLinkStatus
   virtual tVoid onPhoneBTLinkStatusMStart(tU8 BTLinkStatus);
   virtual tVoid sendPhoneBTLinkStatusMResult(tU8 Result);
   virtual tVoid vHandlePhoneBTLinkStatusOpMStart(amt_tclServiceData* poMessage);
	//PhoneBookSyncstatus
   virtual tVoid onPhoneBookSyncstatusMStart(tU8 PhoneBookSyncStatusValue);
   virtual tVoid sendPhoneBookSyncstatusMResult(tU8 Result);
   virtual tVoid vHandlePhoneBookSyncstatusOpMStart(amt_tclServiceData* poMessage);
   	//CallHistorySyncStatus
   virtual tVoid onCallHistorySyncStatusMStart(tU8 CallHistorySyncStatusValue);
   virtual tVoid sendCallHistorySyncStatusMResult(tU8 Result);
   virtual tVoid vHandleCallHistorySyncStatusOpMStart(amt_tclServiceData* poMessage);
   //PhoneStatusRoaming
   virtual tVoid onPhoneStatusRoamingMStart(tU8 PhoneStatusRoamingValue);
   virtual tVoid sendPhoneStatusRoamingMResult(tU8 Result);
   virtual tVoid vHandlePhoneStatusRoamingOpMStart(amt_tclServiceData* poMessage);
   //CallDuration
   virtual tVoid onCallDurationMStart(tU16 CallDurationValue);
   virtual tVoid sendCallDurationMResult(tU8 Result);
   virtual tVoid vHandleCallDurationOpMStart(amt_tclServiceData* poMessage);
   //GSMSignalStrength
   virtual tVoid onGSMSignalStrengthMStart(tU8 GSMSignalStrengthValue);
   virtual tVoid sendGSMSignalStrengthMResult(tU8 Result);
   virtual tVoid vHandleGSMSignalStrengthOpMStart(amt_tclServiceData* poMessage);
   //PhoneCallStatus
   virtual tVoid onPhoneCallStatusMStart(tU8 CallStatusValue);
   virtual tVoid sendPhoneCallStatusMResult(tU8 Result);
   virtual tVoid vHandlePhoneCallStatusOpMStart(amt_tclServiceData* poMessage);
   //PhoneBatteryLevelStatus
   virtual tVoid onPhoneBatteryLevelStatusMStart(tU8 PhoneBatteryLevelStatusValue);
   virtual tVoid sendPhoneBatteryLevelStatusMResult(tU8 Result);
   virtual tVoid vHandlePhoneBatteryLevelStatusOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusWifiAvailable
   virtual tVoid onDeviceStatusWifiAvailableMStart(tU8 DeviceStatusWifiStatus);
   virtual tVoid sendDeviceStatusWifiAvailableMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusWifiAvailableOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusAudioSource
   virtual tVoid onMediaStatusAudioSourceMStart(tU8 AudioSource);
   virtual tVoid sendMediaStatusAudioSourceMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusAudioSourceOpMStart(amt_tclServiceData* poMessage);
   //PhoneAvailableStatus
   virtual tVoid onPhoneAvailableStatusMStart(tU8 PhoneAvailableStatusValue);
   virtual tVoid sendPhoneAvailableStatusMResult(tU8 Result);
   virtual tVoid vHandlePhoneAvailableStatusOpMStart(amt_tclServiceData* poMessage);
  //PhoneVRAvailable
   virtual tVoid onPhoneVRAvailableMStart(tU8 PhoneVRAvailableValue);
   virtual tVoid sendPhoneVRAvailableMResult(tU8 Result);
   virtual tVoid vHandlePhoneVRAvailableOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusBTStatus
   virtual tVoid onDeviceStatusBTStatusMStart(tU8 DeviceStatusBTStatusValue);
   virtual tVoid sendDeviceStatusBTStatusMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusBTStatusOpMStart(amt_tclServiceData* poMessage);
   //Req_DeviceInfo
   virtual tVoid onReq_DeviceInfoMStart(tU8 Req_DeviceInfoValue);
   virtual tVoid sendReq_DeviceInfoMResult(tU8 Result);
   virtual tVoid vHandleReq_DeviceInfoOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusBluetoothAvail
   virtual tVoid onDeviceStatusBluetoothAvailMStart(tU8 DeviceStatusBluetoothAvailValue);
   virtual tVoid sendDeviceStatusBluetoothAvailMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusBluetoothAvailOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusVolume
   virtual tVoid onMediaStatusVolumeMStart(tU8 volume);
   virtual tVoid sendMediaStatusVolumeMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusVolumeOpMStart(amt_tclServiceData* poMessage);
	//CabinMediaStatusAudioSource
   virtual tVoid onCabinMediaStatusAudioSourceMStart(tU8 CabinAudioSource);
   virtual tVoid sendCabinMediaStatusAudioSourceMResult(tU8 Result);
   virtual tVoid vHandleCabinMediaStatusAudioSourceOpMStart(amt_tclServiceData* poMessage);
   //CabinMediaStatusTunerBand
   virtual tVoid onCabinMediaStatusTunerBandMStart(tU8 CabinMediaStatusTunerBandValue);
   virtual tVoid sendCabinMediaStatusTunerBandMResult(tU8 Result);
   virtual tVoid vHandleCabinMediaStatusTunerBandOpMStart(amt_tclServiceData* poMessage);
   //CabinMediaStatusVolume
   virtual tVoid onCabinMediaStatusVolumeMStart(tU8 CabinVolume);
   virtual tVoid sendCabinMediaStatusVolumeMResult(tU8 Result);
   virtual tVoid vHandleCabinMediaStatusVolumeOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusMuteStatus
   virtual tVoid onMediaStatusMuteStatusMStart(tU8 MediaStatusMuteValue);
   virtual tVoid sendMediaStatusMuteStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusMuteStatusOpMStart(amt_tclServiceData* poMessage);
   //CabinMediaStatusMuteStatus
   virtual tVoid onCabinMediaStatusMuteStatusMStart(tU8 CabinMediaStatusMuteValue);
   virtual tVoid sendCabinMediaStatusMuteStatusMResult(tU8 Result);
   virtual tVoid vHandleCabinMediaStatusMuteStatusOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusPlayStatus
   virtual tVoid onMediaStatusPlayStatusMStart(tU8 MediaStatusPlayStatusValue);
   virtual tVoid sendMediaStatusPlayStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusPlayStatusOpMStart(amt_tclServiceData* poMessage); 
   //MediaStatusMixState
   virtual tVoid onMediaStatusMixStateMStart(tU8 MediaStatusMixStateValue);
   virtual tVoid sendMediaStatusMixStateMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusMixStateOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusPlaylistMode
   virtual tVoid onMediaStatusPlaylistModeMStart(tU8 MediaStatusPlaylistModeValue);
   virtual tVoid sendMediaStatusPlaylistModeMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusPlaylistModeOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusTrackTime
   virtual tVoid onMediaStatusTrackTimeMStart(tU16 MediaStatusTrackTimeValue);
   virtual tVoid sendMediaStatusTrackTimeMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusTrackTimeOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusCurrTrackNum
   virtual tVoid onMediaStatusCurrTrackNumMStart(tU16 MediaStatusCurrTrackNumValue);
   virtual tVoid sendMediaStatusCurrTrackNumMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusCurrTrackNumOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusRadioStatus
   virtual tVoid onDeviceStatusRadioStatusMStart(tU8 DeviceStatusRadioStatusValue);
   virtual tVoid sendDeviceStatusRadioStatusMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusRadioStatusOpMStart(amt_tclServiceData* poMessage); 
   //DeviceStatusDABAvailStatus
   virtual tVoid onDeviceStatusDABAvailStatusMStart(tU8 DeviceStatusDABAvailStatusValue);
   virtual tVoid sendDeviceStatusDABAvailStatusMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusDABAvailStatusOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusNavData
   virtual tVoid onDeviceStatusNavDataMStart(tU8 DeviceStatusNavDataValue);
   virtual tVoid sendDeviceStatusNavDataMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusNavDataOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusUSB1Present
   virtual tVoid onDeviceStatusUSB1PresentMStart(tU8 DeviceStatusUSB1PresentValue);
   virtual tVoid sendDeviceStatusUSB1PresentMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusUSB1PresentOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusUSB2Present
   virtual tVoid onDeviceStatusUSB2PresentMStart(tU8 DeviceStatusUSB2PresentValue);
   virtual tVoid sendDeviceStatusUSB2PresentMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusUSB2PresentOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusNaviAvail
   virtual tVoid onDeviceStatusNaviAvailMStart(tU8 DeviceStatusNaviAvailValue);
   virtual tVoid sendDeviceStatusNaviAvailMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusNaviAvailOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusUSB1Src
   virtual tVoid onDeviceStatusUSB1SrcMStart(tU8 DeviceStatusUSB1SrcValue);
   virtual tVoid sendDeviceStatusUSB1SrcMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusUSB1SrcOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusUSB2Src
   virtual tVoid onDeviceStatusUSB2SrcMStart(tU8 DeviceStatusUSB2SrcValue);
   virtual tVoid sendDeviceStatusUSB2SrcMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusUSB2SrcOpMStart(amt_tclServiceData* poMessage);
   //DeviceStatusAMFMAvail
   virtual tVoid onDeviceStatusAMFMAvailMStart(tU8 DeviceStatusAMFMAvailValue);
   virtual tVoid sendDeviceStatusAMFMAvailMResult(tU8 Result);
   virtual tVoid vHandleDeviceStatusAMFMAvailOpMStart(amt_tclServiceData* poMessage);
  //MediaStatusSeekStatus
   virtual tVoid onMediaStatusSeekStatusMStart(tU8 MediaStatusSeekStatusValue);
   virtual tVoid sendMediaStatusSeekStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusSeekStatusOpMStart(amt_tclServiceData* poMessage);
  //MediaStatusRepeatStatus
   virtual tVoid onMediaStatusRepeatStatusMStart(tU8 MediaStatusRepeatStatusValue);
   virtual tVoid sendMediaStatusRepeatStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusRepeatStatusOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusDABFMStatus
   virtual tVoid onMediaStatusDABFMStatusMStart(tU8 MediaStatusDABFMStatusValue);
   virtual tVoid sendMediaStatusDABFMStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusDABFMStatusOpMStart(amt_tclServiceData* poMessage);
   //VehicleNaviLatitude
   virtual tVoid onVehicleNaviLatitudeMStart(tU32 VehicleNaviLatitudeValue);
   virtual tVoid sendVehicleNaviLatitudeMResult(tU8 Result);
   virtual tVoid vHandleVehicleNaviLatitudeOpMStart(amt_tclServiceData* poMessage);
   //VehicleNaviLongitude
   virtual tVoid onVehicleNaviLongitudeMStart(tU32 VehicleNaviLongitudeValue);
   virtual tVoid sendVehicleNaviLongitudeMResult(tU8 Result);
   virtual tVoid vHandleVehicleNaviLongitudeOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusTREGStatus
   virtual tVoid onMediaStatusTREGStatusMStart(tU8 MediaStatusTREGStatusValue);
   virtual tVoid sendMediaStatusTREGStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusTREGStatusOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusTREGRTMStatus
   virtual tVoid onMediaStatusTREGRTMStatusMStart(tU8 MediaStatusTREGRTMStatusValue);
   virtual tVoid sendMediaStatusTREGRTMStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusTREGRTMStatusOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusRDSStatus
   virtual tVoid onMediaStatusRDSStatusMStart(tU8 MediaStatusRDSStatusValue);
   virtual tVoid sendMediaStatusRDSStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusRDSStatusOpMStart(amt_tclServiceData* poMessage);
  //MediaStatusTAStatus
   virtual tVoid onMediaStatusTAStatusMStart(tU8 MediaStatusTAStatusValue);
   virtual tVoid sendMediaStatusTAStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusTAStatusOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusTPStatus
   virtual tVoid onMediaStatusTPStatusMStart(tU8 MediaStatusTPStatusValue);
   virtual tVoid sendMediaStatusTPStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusTPStatusOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusTunerBandStatus
   virtual tVoid onMediaStatusTunerBandStatusMStart(tU8 MediaStatusTunerBandStatusValue);
   virtual tVoid sendMediaStatusTunerBandStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusTunerBandStatusOpMStart(amt_tclServiceData* poMessage);
   //MediaStatusTunerPresetStatus
   virtual tVoid onMediaStatusTunerPresetStatusMStart(tU8 MediaStatusTunerPresetStatusValue);
   virtual tVoid sendMediaStatusTunerPresetStatusMResult(tU8 Result);
   virtual tVoid vHandleMediaStatusTunerPresetStatusOpMStart(amt_tclServiceData* poMessage);
   //HUS_DM1_Status
   virtual tVoid onHUS_DM1_StatusMStart(tU64 HUS_DM1_StatusValue);
   virtual tVoid sendHUS_DM1_StatusMResult(tU8 Result);
   virtual tVoid vHandleHUS_DM1_StatusOpMStart(amt_tclServiceData* poMessage);
   

   virtual tVoid sendSetLanguageMResult(tBool Result);
   virtual tVoid sendRequestMeterLanguageSyncMResult(tBool Result);
   virtual tVoid sendCSMEngineeringDataMResult(bpstl::vector<vehicle_fi_tcl_CAN_Message, bpstl::allocator<vehicle_fi_tcl_CAN_Message> > CanMessageList);
   virtual tVoid sendSetOSPAlertsStatusMResult(tBool Status);

   virtual void vGetDistanceUnitMsg(vehicle_mainfi_tclMsgDistanceUnitStatus& oStatus) {
      oStatus.e8DistanceUnit = _tDistanceUnit_e8DistanceUnit;
   }
   virtual void vGetFuelConsumptionUnitMsg(vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& oStatus) {
      oStatus.e8FuelConsumpUnit = _tFuelConsumptionUnit_e8FuelConsumpUnit;
   }
   virtual void vGetTemperatureUnitMsg(vehicle_mainfi_tclMsgTemperatureUnitStatus& oStatus) {
      oStatus.e8TempUnit = _tTemperatureUnit_e8TempUnit;
   }
   virtual void vGetLanguageMsg(vehicle_mainfi_tclMsgLanguageStatus& oStatus) {
      oStatus.Language = _tLanguage_Language;
      oStatus.LangTable = _tLanguage_LangTable;
   }
   virtual void vGetLanguageSyncSourceMsg(vehicle_mainfi_tclMsgLanguageSyncSourceStatus& oStatus) {
      oStatus.Language = _tLanguageSyncSource_Language;
   }
   virtual void vGetMeterLanguageKnowledgeMsg(vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& oStatus) {
      oStatus.State = _tMeterLanguageKnowledge_State;
   }
   virtual void vGetHandBrakeMsg(vehicle_mainfi_tclMsgHandBrakeStatus& oStatus) {
      oStatus.e8Status = _tHandBrake_e8Status;
   }
   virtual void vGetIgnitionMsg(vehicle_mainfi_tclMsgIgnitionStatus& oStatus) {
      oStatus.e8Status = _tIgnition_e8Status;
   }
   virtual void vGetSpeedMsg(vehicle_mainfi_tclMsgSpeedStatus& oStatus) {
      oStatus.SpeedValue = _tSpeed_SpeedValue;
   }
   
   virtual void vGetPartialMuteMsg(vehicle_mainfi_tclMsgPartialMuteStatus& oStatus) {
      oStatus.PartialMuteValue = _tPartialMute_PartialMuteValue;
   }
   virtual void vGetSwivMonAutoOpenMsg(vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& oStatus) {
      oStatus.SwivMonAutoOpenValue = _tSwivMonAutoOpen_SwivMonAutoOpenValue;
   }
   virtual void vGetDriverDoorOpenMsg(vehicle_mainfi_tclMsgDriverDoorOpenStatus& oStatus) {
      oStatus.DriverDoorOpenValue = _tDriverDoorOpen_DriverDoorOpenValue;
   }
   virtual void vGetDateModeMsg(vehicle_mainfi_tclMsgDateModeStatus& oStatus) {
      oStatus.DateModeValue = _tDateMode_DateModeValue;
   }
   virtual void vGetTmModeMsg(vehicle_mainfi_tclMsgTmModeStatus& oStatus) {
      oStatus.TmModeValue = _tTmMode_TmModeValue;
   }
   //camera
   virtual void vGetActCam1Msg(vehicle_mainfi_tclMsgActCam1Status& oStatus) {
      oStatus.ActCam1Value = _tActCam1_ActCam1Value;
   }
   //camera2
   virtual void vGetActCam2Msg(vehicle_mainfi_tclMsgActCam2Status& oStatus) {
      oStatus.ActCam2Value = _tActCam2_ActCam2Value;
   }
   //camera3
   virtual void vGetActCam3Msg(vehicle_mainfi_tclMsgActCam3Status& oStatus) {
      oStatus.ActCam3Value = _tActCam3_ActCam3Value;
   }
   //camera4
   virtual void vGetActCam4Msg(vehicle_mainfi_tclMsgActCam4Status& oStatus) {
      oStatus.ActCam4Value = _tActCam4_ActCam4Value;
   }
   //camera5
   virtual void vGetActCam5Msg(vehicle_mainfi_tclMsgActCam5Status& oStatus) {
      oStatus.ActCam5Value = _tActCam5_ActCam5Value;
   }
   //camera6
   virtual void vGetActCam6Msg(vehicle_mainfi_tclMsgActCam6Status& oStatus) {
      oStatus.ActCam6Value = _tActCam6_ActCam6Value;
   }
   //camera7
   virtual void vGetActCam7Msg(vehicle_mainfi_tclMsgActCam7Status& oStatus) {
      oStatus.ActCam7Value = _tActCam7_ActCam7Value;
   }
   //camsplit
   virtual void vGetCamSplitQuadMsg(vehicle_mainfi_tclMsgCamSplitQuadStatus& oStatus) {
      oStatus.CamSplitQuadValue = _tCamSplitQuad_CamSplitQuadValue;
   }
   //MuteDev
   virtual void vGetMuteDevStatusMsg(vehicle_mainfi_tclMsgMuteDevStatus& oStatus) {
      oStatus.MuteDevStatus = _tMuteDev_MuteDevStatus;
   }
   //sysVolt
   virtual void vGetSysVoltStatusMsg(vehicle_mainfi_tclMsgSysVoltStatus& oStatus) {
      oStatus.SysVoltStatus = _tSysVolt_SysVoltStatus;
   }
   //ParkingBreakSwitch
   virtual void vGetParkingBreakSwitchMsg(vehicle_mainfi_tclMsgParkingBreakSwitchStatus& oStatus) {
      oStatus.ParkingBreakSwitchValue = _tParkingBreakSwitch_ParkingBreakSwitchValue;
   }
   //RearCamReq
   virtual void vGetRearCamReqMsg(vehicle_mainfi_tclMsgRearCamReqStatus& oStatus) {
      oStatus.RearCamReqValue = _tRearCamReq_RearCamReqValue;
   }
   //VIN
   virtual void vGetVINMsg(vehicle_mainfi_tclMsgVINStatus& oStatus) {
      oStatus.VINValue = _tVIN_VINValue;
   }
      //TimeDate
   virtual void vGetTimeDateMsg(vehicle_mainfi_tclMsgTimeDateStatus& oStatus) {
      oStatus.TimeDateValue = _tTimeDate_TimeDateValue;
   }
    //PhoneCallCommand
   virtual void vGetPhoneCallCommandMsg(vehicle_mainfi_tclMsgPhoneCallCommandStatus& oStatus) {
      oStatus.PhoneCallCommandValue = _tPhoneCallCmd_PhoneCallCmdValue;
   }
       //Phone Pwr Cmd 
   virtual void vGetPhonePwrCmdMsg(vehicle_mainfi_tclMsgPhonePwrCmdStatus& oStatus) {
      oStatus.PhonePwrCmdValue = _tPhonePwrCmd_PhonePwrCmdValue;
   }
   
   //Radio Pwr Cmd 
   virtual void vGetRadioPwrCmdMsg(vehicle_mainfi_tclMsgRadioPwrCmdStatus& oStatus) {
      oStatus.RadioPwrCmdValue = _tRadioPwrCmd_RadioPwrCmdValue;
   }
       //VolumeCommand
   virtual void vGetVolumeCommandMsg(vehicle_mainfi_tclMsgVolumeCommandStatus& oStatus) {
      oStatus.VolumeCommandValue = _tVolumeCmd_VolumeCmdValue;
   }
   
   //ActCam8
   virtual void vGetActCam8Msg(vehicle_mainfi_tclMsgActCam8Status& oStatus) {
      oStatus.ActCam8Value = _tActCam8_ActCam8Value;
   }
         
   //ActCam9
   virtual void vGetActCam9Msg(vehicle_mainfi_tclMsgActCam9Status& oStatus) {
      oStatus.ActCam9Value = _tActCam9_ActCam9Value;
   }
   
     //ActCam10
   virtual void vGetActCam10Msg(vehicle_mainfi_tclMsgActCam10Status& oStatus) {
      oStatus.ActCam10Value = _tActCam10_ActCam10Value;
   }
   
        //ActCam11
   virtual void vGetActCam11Msg(vehicle_mainfi_tclMsgActCam11Status& oStatus) {
      oStatus.ActCam11Value = _tActCam11_ActCam11Value;
   }
   
      //ActCam12
   virtual void vGetActCam12Msg(vehicle_mainfi_tclMsgActCam12Status& oStatus) {
      oStatus.ActCam12Value = _tActCam12_ActCam12Value;
   }
   
    //ActCam13
   virtual void vGetActCam13Msg(vehicle_mainfi_tclMsgActCam13Status& oStatus) {
      oStatus.ActCam13Value = _tActCam13_ActCam13Value;
   }
         
    //ActCam14
   virtual void vGetActCam14Msg(vehicle_mainfi_tclMsgActCam14Status& oStatus) {
      oStatus.ActCam14Value = _tActCam14_ActCam14Value;
   }
   
       //ActCam15
   virtual void vGetActCam15Msg(vehicle_mainfi_tclMsgActCam15Status& oStatus) {
      oStatus.ActCam15Value = _tActCam15_ActCam15Value;
   }
          //ActCam16
   virtual void vGetActCam16Msg(vehicle_mainfi_tclMsgActCam16Status& oStatus) {
      oStatus.ActCam16Value = _tActCam16_ActCam16Value;
   }
             //ActCam17
   virtual void vGetActCam17Msg(vehicle_mainfi_tclMsgActCam17Status& oStatus) {
      oStatus.ActCam17Value = _tActCam17_ActCam17Value;
   }
          //SourceCommand
   virtual void vGetSourceCommandMsg(vehicle_mainfi_tclMsgSourceCommandStatus& oStatus) {
      oStatus.SourceCommandValue = _tSourceCmd_SourceCmdValue;
   }
   
    //CabinSourceCommand
   virtual void vGetCabinSourceCommandMsg(vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& oStatus) {
      oStatus.CabinMediaSourceCommandValue = _tCabinSourceCmd_CabinSourceCmdValue;
   }
   
      
    //CabinVolumeCommand
   virtual void vGetCabinVolumeCommandMsg(vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& oStatus) {
      oStatus.CabinMediaVolumeCommandValue = _tCabinVolumeCmd_CabinVolumeCmdValue;
   }
      
      
    //CabinTunerCommand
   virtual void vGetCabinTunerCommandMsg(vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& oStatus) {
      oStatus.CabinMediaTunerCommandValue = _tCabinTunerCmd_CabinTunerCmdValue;
   }
   
         
    //CabinTrackCommand
   virtual void vGetCabinTrackCommandMsg(vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& oStatus) {
      oStatus.CabinMediaTrackCommandValue = _tCabinTrackCmd_CabinTrackCmdValue;
   }
   
      
         
    //CabinPlaylistCommand
   virtual void vGetCabinPlaylistCommandMsg(vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& oStatus) {
      oStatus.CabinMediaPlaylistCommandValue = _tCabinPlaylistCmd_CabinPlaylistCmdValue;
   }
   
   
          //Track command
   virtual void vGetTrackCommandMsg(vehicle_mainfi_tclMsgTrackCommandStatus& oStatus) {
      oStatus.TrackCommandValue = _tTrackCmd_TrackCmdValue;
   }
   
  
   //SMARTVR
   virtual void vGetSMARTVRMsg(vehicle_mainfi_tclMsgSMARTVRStatus& oStatus) {
      oStatus.SMARTVRValue = _tSMARTVR_SMARTVRValue;
   }

   
    //Tuner command
   virtual void vGetTunerCommandMsg(vehicle_mainfi_tclMsgTunerCommandStatus& oStatus) {
      oStatus.TunerCommandValue = _tTunerCmd_TunerCmdValue;
   }
   
   //TA command
   virtual void vGetTACommandMsg(vehicle_mainfi_tclMsgTACommandStatus& oStatus) {
      oStatus.TACommandValue = _tTACmd_TACmdValue;
   }
   
   //RDS command
   virtual void vGetRDSCommandMsg(vehicle_mainfi_tclMsgRDSCommandStatus& oStatus) {
      oStatus.RDSCommandValue = _tRDSCmd_RDSCmdValue;
   }
   
   
   //Voice Command
   virtual void vGetVoiceRecgCommandMsg(vehicle_mainfi_tclMsgVoiceRecgCommandStatus& oStatus) {
      oStatus.VoiceRecgCommandValue = _tVoiceRecgCmd_VoiceRecgCmdValue;
   }
   
   
      
   //RC Next Btn
   virtual void vGetRCNextBtnMsg(vehicle_mainfi_tclMsgRCNextBtnStatus& oStatus) {
      oStatus.RCNextBtnValue = _tRCNextBtn_RCNextBtnValue;
   }
   
         
   //RC Prev Btn
   virtual void vGetRCPrevBtnMsg(vehicle_mainfi_tclMsgRCPrevBtnStatus& oStatus) {
      oStatus.RCPrevBtnValue = _tRCPrevBtn_RCPrevBtnValue;
   }
   
      		//SW Version 
	virtual void vGetDeviceInfoSWversionMsg(vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& oStatus) { 
	 oStatus.SWversionValue=_tSWversion_SWversionValue;
	}
         		//TotalVehDistDiag 
	virtual void vGetTotalVehDistDiagMsg(vehicle_mainfi_tclMsgTotalVehDistDiagStatus& oStatus) { 
	 oStatus.TotalVehDistDiagValue=_tTotalVehDistDiag_TotalVehDistDiagValue;
	}
   
      
   //CamTxt
   virtual void vGetCamTxtMsg(vehicle_mainfi_tclMsgCamTxtStatus& oStatus) {
      oStatus.CamTxtValue = _tCamTxt_CamTxtValue;
   }
   //VIN_64
   virtual void vGetVIN_64Msg(vehicle_mainfi_tclMsgVIN_64Status& oStatus) {
      oStatus.VIN_64Value = _tVIN_64_VIN_64Value;
   }
   //PrivacyResetReq
   virtual void vGetPrivacyResetRequestMsg(vehicle_mainfi_tclMsgPrivacyResetRequestStatus& oStatus) {
      oStatus.PrivacyResetRequestValue = _tPrivacyResetReq_PrivacyResetReqValue;
   }

   //HUS_DM1_Status
   virtual void vGetHUS_DM1_StatusMsg(vehicle_mainfi_tclMsgPrivacyResetRequestStatus& oStatus) {
   //   oStatus.PrivacyResetRequestValue = _tPrivacyResetReq_PrivacyResetReqValue;
   }
   
   virtual void vGetSpeedLimitMsg(vehicle_mainfi_tclMsgSpeedLimitStatus& oStatus) {
      oStatus.SpeedLimit1 = _tSpeedLimit_SpeedLimit1;
      oStatus.SpeedLimit2 = _tSpeedLimit_SpeedLimit2;
      oStatus.Display = _tSpeedLimit_Display;
      oStatus.DisplayUnit = _tSpeedLimit_DisplayUnit;
      oStatus.OverSpeed = _tSpeedLimit_OverSpeed;
      oStatus.FreeSpeed = _tSpeedLimit_FreeSpeed;
   }
   virtual void vGetReverseGearMsg(vehicle_mainfi_tclMsgReverseGearStatus& oStatus) {
      oStatus.State = _tReverseGear_State;
   }
   virtual void vGetSpeedLockMsg(vehicle_mainfi_tclMsgSpeedLockStatus& oStatus) {
      oStatus.State = _tSpeedLock_State;
   }
   virtual void vGetDrivingStateMsg(vehicle_mainfi_tclMsgDrivingStateStatus& oStatus) {
      oStatus.State = _tDrivingState_State;
   }
   virtual void vGetGlobalVehicleWarningStateMsg(vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& oStatus) {
      oStatus.State = _tGlobalVehicleWarningState_State;
   }
   virtual void vGetVehicleStatesMsg(vehicle_mainfi_tclMsgVehicleStatesStatus& oStatus) {
      oStatus.State = _tVehicleStates_State;
   }
   virtual void vGetNetworkStateMsg(vehicle_mainfi_tclMsgNetworkStateStatus& oStatus) {
      oStatus.u8BusState_MCAN = _tNetworkState_u8BusState_MCAN;
      oStatus.u8BusState_VCAN = _tNetworkState_u8BusState_VCAN;
      oStatus.u8MuteState_MCAN = _tNetworkState_u8MuteState_MCAN;
      oStatus.u8MuteState_VCAN = _tNetworkState_u8MuteState_VCAN;
      oStatus.bBusOff_MCAN = _tNetworkState_bBusOff_MCAN;
      oStatus.bBusOff_VCAN = _tNetworkState_bBusOff_VCAN;
      oStatus.bBusOff = _tNetworkState_bBusOff;
      oStatus.bMute_MCAN = _tNetworkState_bMute_MCAN;
      oStatus.bMute_VCAN = _tNetworkState_bMute_VCAN;
      oStatus.Listu8AbsentState_ECU = _tNetworkState_Listu8AbsentState_ECU;
      oStatus.Listu8MuteStateMCAN_Channel = _tNetworkState_Listu8MuteStateMCAN_Channel;
   }
   virtual void vGetDistanceTotalizerMsg(vehicle_mainfi_tclMsgDistanceTotalizerStatus& oStatus) {
      oStatus.DisTotal = _tDistanceTotalizer_DisTotal;
      oStatus.lastValidDisTotal = _tDistanceTotalizer_lastValidDisTotal;
      oStatus.Unit = _tDistanceTotalizer_Unit;
      oStatus.DisTotalStatus = _tDistanceTotalizer_DisTotalStatus;
   }
   virtual void vGetMileageMsg(vehicle_mainfi_tclMsgMileageStatus& oStatus) {
      oStatus.Mileage = _tMileage_Mileage;
   }
   virtual void vGetAvgFuelEconomyMsg(vehicle_mainfi_tclMsgAvgFuelEconomyStatus& oStatus) {
      oStatus.FuelEcon = _tAvgFuelEconomy_FuelEcon;
   }
   virtual void vGetTirePressureSupportMsg(vehicle_mainfi_tclMsgTirePressureSupportStatus& oStatus) {
      oStatus.PressureSupport = _tTirePressureSupport_PressureSupport;
   }
   virtual void vGetTPMSResetSupportMsg(vehicle_mainfi_tclMsgTPMSResetSupportStatus& oStatus) {
      oStatus.TPMSResetInfo = _tTPMSResetSupport_TPMSResetInfo;
   }
   virtual void vGetTirePressureSettingMsg(vehicle_mainfi_tclMsgTirePressureSettingStatus& oStatus) {
      oStatus.SettingPressureFront = _tTirePressureSetting_SettingPressureFront;
      oStatus.SettingPressureRear = _tTirePressureSetting_SettingPressureRear;
   }
   virtual void vGetSetLanguageMsg(vehicle_mainfi_tclMsgSetLanguageMethodStart& oMethodStart) {
      oMethodStart.SourceId = _tSetLanguage_SourceId;
      oMethodStart.Language = _tSetLanguage_Language;
   }
   virtual void vGetRequestMeterLanguageSyncMsg(vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tRequestMeterLanguageSync_RequestId;
   }
   virtual void vGetCSMEngineeringDataMsg(vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart& oMethodStart) {
   }
   virtual void vGetSetOSPAlertsStatusMsg(vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart& oMethodStart) {
      oMethodStart.OSPAlert = _tSetOSPAlertsStatus_OSPAlert;
      oMethodStart.DangerousAreaAlert = _tSetOSPAlertsStatus_DangerousAreaAlert;
   }
   //Cam1ManAct
   virtual void vGetCam1ManActMsg(vehicle_mainfi_tclMsgCam1ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam1ManAct_RequestId;
   }
   //Cam2ManAct
   virtual void vGetCam2ManActMsg(vehicle_mainfi_tclMsgCam2ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam2ManAct_RequestId;
   }
   //Cam3ManAct
   virtual void vGetCam3ManActMsg(vehicle_mainfi_tclMsgCam3ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam3ManAct_RequestId;
   }
   //Cam4ManAct
   virtual void vGetCam4ManActMsg(vehicle_mainfi_tclMsgCam4ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam4ManAct_RequestId;
   }
   //Cam5ManAct
   virtual void vGetCam5ManActMsg(vehicle_mainfi_tclMsgCam5ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam5ManAct_RequestId;
   }
   //Cam6ManAct
   virtual void vGetCam6ManActMsg(vehicle_mainfi_tclMsgCam6ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam6ManAct_RequestId;
   }
   //Cam7ManAct
   virtual void vGetCam7ManActMsg(vehicle_mainfi_tclMsgCam7ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam7ManAct_RequestId;
   }
   //Cam8ManAct
   virtual void vGetCam8ManActMsg(vehicle_mainfi_tclMsgCam8ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam8ManAct_RequestId;
   }
   //Cam9ManAct
   virtual void vGetCam9ManActMsg(vehicle_mainfi_tclMsgCam9ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam9ManAct_RequestId;
   }
  //Cam10ManAct
   virtual void vGetCam10ManActMsg(vehicle_mainfi_tclMsgCam10ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam10ManAct_RequestId;
   }
   //Cam11ManAct
   virtual void vGetCam11ManActMsg(vehicle_mainfi_tclMsgCam11ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam11ManAct_RequestId;
   }
   //Cam12ManAct
   virtual void vGetCam12ManActMsg(vehicle_mainfi_tclMsgCam12ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam12ManAct_RequestId;
   }
   //Cam13ManAct
   virtual void vGetCam13ManActMsg(vehicle_mainfi_tclMsgCam13ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam13ManAct_RequestId;
   }
   //Cam14ManAct
   virtual void vGetCam14ManActMsg(vehicle_mainfi_tclMsgCam14ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam14ManAct_RequestId;
   }
   //Cam15ManAct
   virtual void vGetCam15ManActMsg(vehicle_mainfi_tclMsgCam15ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam15ManAct_RequestId;
   }
   //Cam16ManAct
   virtual void vGetCam16ManActMsg(vehicle_mainfi_tclMsgCam16ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam16ManAct_RequestId;
   }
     //Cam17ManAct
   virtual void vGetCam17ManActMsg(vehicle_mainfi_tclMsgCam17ManActMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tCam17ManAct_RequestId;
   }
   //PrivacyResetAck
   virtual void vGetPrivacyResetAckMsg(vehicle_mainfi_tclMsgPrivacyResetAckMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tPrivacyResetAck_RequestId;
   }
   //DispCamCls
   virtual void vGetDispCamClsMsg(vehicle_mainfi_tclMsgDispCamClsMethodStart& oMethodStart) {
      oMethodStart.RequestId = _tDispCamCls_RequestId;
   }
  //PhoneBTLinkStatus
   virtual void vGetPhoneBTLinkStatusMsg(vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart& oMethodStart) {
      oMethodStart.BTLinkStatus = _tPhoneBTLinkStatus_BTLinkStatus;
   }
     //PhoneBookSyncstatus
   virtual void vGetPhoneBookSyncstatusMsg(vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart& oMethodStart) {
      oMethodStart.PhoneBookSyncStatusValue = _tPhoneBookSyncStatus_PhoneBookSyncStatusValue;
   }
    //CallHistorySyncStatus
   virtual void vGetCallHistorySyncStatusMsg(vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart& oMethodStart) {
      oMethodStart.CallHistorySyncStatusValue = _tCallHistorySyncStatus_CallHistorySyncStatusValue;
   }
   //PhoneStatusRoaming
   virtual void vGetPhoneStatusRoamingMsg(vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart& oMethodStart) {
      oMethodStart.PhoneStatusRoamingValue = _tPhoneStatusRoaming_PhoneStatusRoamingValue;
   }
   //CallDuration
   virtual void vGetCallDurationMsg(vehicle_mainfi_tclMsgCallDurationMethodStart& oMethodStart) {
      oMethodStart.CallDurationValue = _tCallDuration_CallDurationValue;
   }
     //GSMSignalStrength
   virtual void vGetGSMSignalStrengthMsg(vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart& oMethodStart) {
      oMethodStart.GSMSignalStrengthValue = _tGSMSignalStrength_GSMSignalStrengthValue;
   }
    //PhoneCallStatus
   virtual void vGetPhoneCallStatusMsg(vehicle_mainfi_tclMsgPhoneCallStatusMethodStart& oMethodStart) {
      oMethodStart.CallStatusValue = _tPhoneCallStatus_CallStatusValue;
   }
   //PhoneBatteryLevelStatus
   virtual void vGetPhoneBatteryLevelStatusMsg(vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart& oMethodStart) {
      oMethodStart.PhoneBatteryLevelStatusValue = _tPhoneBatteryLevelStatus_PhoneBatteryLevelStatusValue;
   }
   //DeviceStatusWifiAvailable
   virtual void vGetDeviceStatusWifiAvailableMsg(vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusWifiStatus = _tDeviceStatusWifiAvailable_DeviceStatusWifiStatus;
   }
   //MediaStatusAudioSource
   virtual void vGetMediaStatusAudioSourceMsg(vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart& oMethodStart) {
      oMethodStart.AudioSource = _tMediaStatusAudioSource_AudioSource;
   }
    //PhoneAvailableStatus
   virtual void vGetPhoneAvailableStatusMsg(vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart& oMethodStart) {
      oMethodStart.PhoneAvailableStatusValue = _tPhoneAvailableStatus_PhoneAvailableStatusValue;
   }

    //PhoneVRAvailable
   virtual void vGetPhoneVRAvailableStatusMsg(vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart& oMethodStart) {
      oMethodStart.PhoneVRAvailableValue = _tPhoneVRAvailable_PhoneVRAvailableValue;
   }

    //DeviceStatusBTStatus
   virtual void vGetDeviceStatusBTStatusMsg(vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusBTStatusValue = _tDeviceStatusBTStatus_DeviceStatusBTStatusValue;
   } 
   //DeviceStatusBluetoothAvail
   virtual void vGetDeviceStatusBluetoothAvailMsg(vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusBluetoothAvailValue = _tDeviceStatusBluetoothAvail_DeviceStatusBluetoothAvailValue;
   }  
   //Req_DeviceInfo
   virtual void vGetReq_DeviceInfoMsg(vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart& oMethodStart) {
      oMethodStart.Req_DeviceInfoValue = _tReq_DeviceInfo_Req_DeviceInfoValue;
   }
   //MediaStatusVolume
   virtual void vGetMediaStatusVolumeMsg(vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart& oMethodStart) {
      oMethodStart.volume = _tMediaStatusVolume_volume;
   }
   //CabinMediaStatusAudioSource
   virtual void vGetCabinMediaStatusAudioSourceMsg(vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart& oMethodStart) {
      oMethodStart.CabinAudioSource = _tCabinMediaStatusAudioSource_CabinAudioSource;
   }
   //CabinMediaStatusTunerBand
   virtual void vGetCabinMediaStatusTunerBandMsg(vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart& oMethodStart) {
      oMethodStart.CabinMediaStatusTunerBandValue = _tCabinMediaStatusTunerBand_CabinTunerBand;
   }
   //CabinMediaStatusVolume
   virtual void vGetCabinMediaStatusVolumeMsg(vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart& oMethodStart) {
      oMethodStart.CabinVolume = _tCabinMediaStatusVolume_CabinVolume;
   }
   //MediaStatusMuteStatus
   virtual void vGetMediaStatusMuteStatusMsg(vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusMuteValue = _tMediaStatusMuteStatus_MediaStatusMuteValue;
   }
   //CabinMediaStatusMuteStatus
   virtual void vGetCabinMediaStatusMuteStatusMsg(vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart& oMethodStart) {
      oMethodStart.CabinMediaStatusMuteValue = _tCabinMediaStatusMuteStatus_CabinMediaStatusMuteValue;
   }
  //MediaStatusPlayStatus
   virtual void vGetCabinMediaStatusPlayStatusMsg(vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusPlayStatusValue = _tMediaStatusPlayStatus_MediaStatusPlayStatusValue;
   }
  //MediaStatusSeekStatus
   virtual void vGetCabinMediaStatusSeekStatusMsg(vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusSeekStatusValue = _tMediaStatusSeekStatus_MediaStatusSeekStatusValue;
   }
  //MediaStatusRpeatStatus
   virtual void vGetCabinMediaStatusRepeatStatusMsg(vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusRepeatStatusValue = _tMediaStatusRepeatStatus_MediaStatusRepeatStatusValue;
   }
  //MediaStatusDABFMStatus
   virtual void vGetCabinMediaStatusDABFMStatusMsg(vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusDABFMStatusValue = _tMediaStatusDABFMStatus_MediaStatusDABFMStatusValue;
   } 
  //VehicleNaviLatitude
   virtual void vGetVehicleNaviLatitudeMsg(vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart& oMethodStart) {
      oMethodStart.VehicleNaviLatitudeValue = _tVehicleNaviLatitude_VehicleNaviLatitudeValue;
   }
   //VehicleNaviLongitude
   virtual void vGetVehicleNaviLongitudeMsg(vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart& oMethodStart) {
      oMethodStart.VehicleNaviLongitudeValue = _tVehicleNaviLongitude_VehicleNaviLongitudeValue;
   }
  //MediaStatusTREGStatus
   virtual void vGetCabinMediaStatusTREGStatusMsg(vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusTREGStatusValue = _tMediaStatusTREGStatus_MediaStatusTREGStatusValue;
   }
   //MediaStatusTREGRTMStatus
   virtual void vGetMediaStatusTREGRTMStatusMsg(vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusTREGRTMStatusValue = _tMediaStatusTREGRTMStatus_MediaStatusTREGRTMStatusValue;
   }
  //MediaStatusRDSStatus
   virtual void vGetCabinMediaStatusRDSStatusMsg(vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusRDSStatusValue = _tMediaStatusRDSStatus_MediaStatusRDSStatusValue;
   }
  //MediaStatusTAStatus
   virtual void vGetCabinMediaStatusTAStatusMsg(vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusTAStatusValue = _tMediaStatusTAStatus_MediaStatusTAStatusValue;
   }
   //MediaStatusTPStatus
   virtual void vGetCabinMediaStatusTPStatusMsg(vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusTPStatusValue = _tMediaStatusTPStatus_MediaStatusTPStatusValue;
   }
   //MediaStatusTunerBandStatus
   virtual void vGetCabinMediaStatusTunerBandStatusMsg(vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusTunerBandStatusValue = _tMediaStatusTunerBandStatus_MediaStatusTunerBandStatusValue;
   }
   //MediaStatusTunerPresetStatus
   virtual void vGetCabinMediaStatusTunerPresetStatusMsg(vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart& oMethodStart) {
      oMethodStart.MediaStatusTunerPresetStatusValue = _tMediaStatusTunerPresetStatus_MediaStatusTunerPresetStatusValue;
   }  
   //MediaStatusMixState
   virtual void vGetMediaStatusMixStateMsg(vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart& oMethodStart) {
      oMethodStart.MediaStatusMixStateValue = _tMediaStatusMixState_MediaStatusMixStateValue;
   }
   //MediaStatusPlaylistMode
   virtual void vGetMediaStatusPlaylistModeMsg(vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart& oMethodStart) {
      oMethodStart.MediaStatusPlaylistModeValue = _tMediaStatusPlaylistMode_MediaStatusPlaylistModeValue;
   }  
   //MediaStatusTrackTime
   virtual void vGetMediaStatusTrackTimeMsg(vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart& oMethodStart) {
      oMethodStart.MediaStatusTrackTimeValue = _tMediaStatusTrackTime_MediaStatusTrackTimeValue;
   }
   //MediaStatusCurrTrackNum
   virtual void vGetMediaStatusCurrTrackNumMsg(vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart& oMethodStart) {
      oMethodStart.MediaStatusCurrTrackNumValue = _tMediaStatusCurrTrackNum_MediaStatusCurrTrackNumValue;
   }  
   //DeviceStatusRadioStatus
   virtual void vGetDeviceStatusRadioStatusMsg(vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusRadioStatusValue = _tDeviceStatusRadioStatus_DeviceStatusRadioStatusValue;
   }   
   //DeviceStatusDABAvailStatus
   virtual void vGetDeviceStatusDABAvailStatusMsg(vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusDABAvailStatusValue = _tDeviceStatusDABAvailStatus_DeviceStatusDABAvailStatusValue;
   }   
   //DeviceStatusNavData
   virtual void vGetDeviceStatusNavDataMsg(vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusNavDataValue = _tDeviceStatusNavData_DeviceStatusNavDataValue;
   }
   //DeviceStatusUSB1Present
   virtual void vGetDeviceStatusUSB1PresentMsg(vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusUSB1PresentValue = _tDeviceStatusUSB1Present_DeviceStatusUSB1PresentValue;
   }   
   //DeviceStatusUSB2Present
   virtual void vGetDeviceStatusUSB2PresentMsg(vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusUSB2PresentValue = _tDeviceStatusUSB2Present_DeviceStatusUSB2PresentValue;
   } 
   //DeviceStatusNaviAvail
   virtual void vGetDeviceStatusNaviAvailMsg(vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusNaviAvailValue = _tDeviceStatusNaviAvail_DeviceStatusNaviAvailValue;
   }
   //DeviceStatusUSB1Src
   virtual void vGetDeviceStatusUSB1SrcMsg(vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusUSB1SrcValue = _tDeviceStatusUSB1Src_DeviceStatusUSB1SrcValue;
   }   
   //DeviceStatusUSB2Src
   virtual void vGetDeviceStatusUSB2SrcMsg(vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusUSB2SrcValue = _tDeviceStatusUSB2Src_DeviceStatusUSB2SrcValue;
   }
   //DeviceStatusAMFMAvail
   virtual void vGetDeviceStatusAMFMAvailMsg(vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart& oMethodStart) {
      oMethodStart.DeviceStatusAMFMAvailValue = _tDeviceStatusAMFMAvail_DeviceStatusAMFMAvailValue;
   }

private:
   // Add status information properties.
   vehicle_fi_tcl_e8_Vehicle_DistanceUnit _tDistanceUnit_e8DistanceUnit;

   vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit _tFuelConsumptionUnit_e8FuelConsumpUnit;

   vehicle_fi_tcl_e8_Vehicle_TemperatureUnit _tTemperatureUnit_e8TempUnit;

   vehicle_fi_tcl_e8_Language_Code _tLanguage_Language;

   bpstl::vector<vehicle_fi_tcl_Language_SourceTable, bpstl::allocator<vehicle_fi_tcl_Language_SourceTable> > _tLanguage_LangTable;

   vehicle_fi_tcl_e8_Language_SourceId _tLanguageSyncSource_Language;

   vehicle_fi_tcl_e8_Meter_LangKnowledge _tMeterLanguageKnowledge_State;

   vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus _tHandBrake_e8Status;

   vehicle_fi_tcl_e8_Vehicle_Ignition _tIgnition_e8Status;

   tU16 _tSpeed_SpeedValue;
   
   tU8 _tPartialMute_PartialMuteValue;
   tU8 _tSwivMonAutoOpen_SwivMonAutoOpenValue;
   tU8 _tDriverDoorOpen_DriverDoorOpenValue;
   tU8 _tDateMode_DateModeValue;
   tU8 _tTmMode_TmModeValue;
   //camera
   tU8 _tActCam1_ActCam1Value;
   //camera2
   tU8 _tActCam2_ActCam2Value;
   //camera3
   tU8 _tActCam3_ActCam3Value;
   //camera4
   tU8 _tActCam4_ActCam4Value;
   //camera5
   tU8 _tActCam5_ActCam5Value;
   //camera6
   tU8 _tActCam6_ActCam6Value;
   //camera7
   tU8 _tActCam7_ActCam7Value;
   //camsplit
   tU16 _tCamSplitQuad_CamSplitQuadValue;
   //MuteDev
   tU8 _tMuteDev_MuteDevStatus;
   //sysVolt
   tU8 _tSysVolt_SysVoltStatus;
   //ParkingBreakSwitch
   tU8 _tParkingBreakSwitch_ParkingBreakSwitchValue;
   //RearCamReq
   tU8 _tRearCamReq_RearCamReqValue;
   //VIN
   tU32 _tVIN_VINValue;
   //TimeDate
   tU64 _tTimeDate_TimeDateValue;
   //RCNextBtn
   tU8 _tRCNextBtn_RCNextBtnValue;
   //RCPrevBtn
   tU8 _tRCPrevBtn_RCPrevBtnValue;
   //Radio Pwr Command
   tU8 _tRadioPwrCmd_RadioPwrCmdValue;
   //PhoneCall Command
   tU8 _tPhoneCallCmd_PhoneCallCmdValue;
//Phone Pwr Command
   tU8 _tPhonePwrCmd_PhonePwrCmdValue;
   //Volume Cmd
   tU8 _tVolumeCmd_VolumeCmdValue;
   // ActCam8
   tU8 _tActCam8_ActCam8Value;
   // ActCam9
   tU8 _tActCam9_ActCam9Value;
   // ActCam10
   tU8 _tActCam10_ActCam10Value;
   // ActCam11
   tU8 _tActCam11_ActCam11Value;
   // ActCam12
   tU8 _tActCam12_ActCam12Value;
   // ActCam13
   tU8 _tActCam13_ActCam13Value;
   // ActCam14
   tU8 _tActCam14_ActCam14Value;
    // ActCam15
   tU8 _tActCam15_ActCam15Value;
   // ActCam16
   tU8 _tActCam16_ActCam16Value;
  // ActCam17
   tU8 _tActCam17_ActCam17Value;
   //Source Cmd
   tU8 _tSourceCmd_SourceCmdValue; 
   //CabinSource Cmd
   tU8 _tCabinSourceCmd_CabinSourceCmdValue; 
   //CabinVolume Cmd
   tU8 _tCabinVolumeCmd_CabinVolumeCmdValue;
   //CabinTuner Cmd
   tU8 _tCabinTunerCmd_CabinTunerCmdValue;
   //CabinTrack Cmd
   tU8 _tCabinTrackCmd_CabinTrackCmdValue;
   //CabinPlaylist Cmd
   tU8 _tCabinPlaylistCmd_CabinPlaylistCmdValue;
   //Voice Recgn Command
    tU8 _tVoiceRecgCmd_VoiceRecgCmdValue;
	   //sw version
   tU32 _tSWversion_SWversionValue;	 
   //TotalVehDistDiag
   tU32 _tTotalVehDistDiag_TotalVehDistDiagValue;
   // track command 
   tU8 _tTrackCmd_TrackCmdValue;
      // SMARTVR  
   tU8 _tSMARTVR_SMARTVRValue;
   // Tuner command 
   tU8 _tTunerCmd_TunerCmdValue;
  // TA command 
   tU8 _tTACmd_TACmdValue;
  // RDS command 
   tU8 _tRDSCmd_RDSCmdValue;

   
   //CamTxt
   tU64 _tVIN_64_VIN_64Value; 
   //CamTxt
   tU64 _tCamTxt_CamTxtValue;
   //PrivacyResetReq
   tU8 _tPrivacyResetReq_PrivacyResetReqValue;
   
   tU8 _tSpeedLimit_SpeedLimit1;

   tU8 _tSpeedLimit_SpeedLimit2;

   tU8 _tSpeedLimit_Display;

   vehicle_fi_tcl_e8_Vehicle_DistanceUnit _tSpeedLimit_DisplayUnit;

   tBool _tSpeedLimit_OverSpeed;

   tBool _tSpeedLimit_FreeSpeed;

   tU8 _tReverseGear_State;

   tU8 _tSpeedLock_State;

   tU8 _tDrivingState_State;

   vehicle_fi_tcl_e8_Vehicle_WarningState _tGlobalVehicleWarningState_State;

   vehicle_fi_tcl_e8_Vehicle_States _tVehicleStates_State;

   tU8 _tNetworkState_u8BusState_MCAN;

   tU8 _tNetworkState_u8BusState_VCAN;

   tU8 _tNetworkState_u8MuteState_MCAN;

   tU8 _tNetworkState_u8MuteState_VCAN;

   tBool _tNetworkState_bBusOff_MCAN;

   tBool _tNetworkState_bBusOff_VCAN;

   tBool _tNetworkState_bBusOff;

   tBool _tNetworkState_bMute_MCAN;

   tBool _tNetworkState_bMute_VCAN;

   bpstl::vector<tU8, bpstl::allocator<tU8> > _tNetworkState_Listu8AbsentState_ECU;

   bpstl::vector<tU8, bpstl::allocator<tU8> > _tNetworkState_Listu8MuteStateMCAN_Channel;

   tU32 _tDistanceTotalizer_DisTotal;

   tU32 _tDistanceTotalizer_lastValidDisTotal;

   tU8 _tDistanceTotalizer_Unit;

   tBool _tDistanceTotalizer_DisTotalStatus;

   tU32 _tMileage_Mileage;

   tU16 _tAvgFuelEconomy_FuelEcon;

   tBool _tTirePressureSupport_PressureSupport;

   vehicle_fi_tcl_e8_Vehicle_TPMSReset _tTPMSResetSupport_TPMSResetInfo;

   tU16 _tTirePressureSetting_SettingPressureFront;

   tU16 _tTirePressureSetting_SettingPressureRear;

   vehicle_fi_tcl_e8_Language_SourceId _tSetLanguage_SourceId;
   vehicle_fi_tcl_e8_Language_Code _tSetLanguage_Language;
   vehicle_fi_tcl_e8_Meter_SyncRequest _tRequestMeterLanguageSync_RequestId;
   vehicle_fi_tcl_CAN_Mesg _tCAN_Mesg;
   vehicle_fi_tcl_CAN_Navi_Mesg _tCAN_Navi_Mesg;
   tBool _tSetOSPAlertsStatus_OSPAlert;
   tBool _tSetOSPAlertsStatus_DangerousAreaAlert;
   //Cam1ManAct
   tU8 _tCam1ManAct_RequestId;
   //Cam2ManAct
   tU8 _tCam2ManAct_RequestId;
   //Cam3ManAct
   tU8 _tCam3ManAct_RequestId;
   //Cam4ManAct
   tU8 _tCam4ManAct_RequestId;
   //Cam5ManAct
   tU8 _tCam5ManAct_RequestId;
   //Cam6ManAct
   tU8 _tCam6ManAct_RequestId;
   //Cam7ManAct
   tU8 _tCam7ManAct_RequestId;
   //Cam8ManAct
   tU8 _tCam8ManAct_RequestId;
   //Cam9ManAct
   tU8 _tCam9ManAct_RequestId;
   //Cam10ManAct
   tU8 _tCam10ManAct_RequestId;
   //Cam11ManAct
   tU8 _tCam11ManAct_RequestId;
   //Cam12ManAct
   tU8 _tCam12ManAct_RequestId;
   //Cam13ManAct
   tU8 _tCam13ManAct_RequestId;
   //Cam14ManAct
   tU8 _tCam14ManAct_RequestId;
   //Cam15ManAct
   tU8 _tCam15ManAct_RequestId;
    //Cam16ManAct
   tU8 _tCam16ManAct_RequestId;
      //Cam17ManAct
   tU8 _tCam17ManAct_RequestId;
   //PrivacyResetAck
   tU8 _tPrivacyResetAck_RequestId;
   //DispCamCls
   tU8 _tDispCamCls_RequestId;
   //PhoneBTLinkStatus
   tU8 _tPhoneBTLinkStatus_BTLinkStatus;
   //PhoneBookSyncstatus
   tU8 _tPhoneBookSyncStatus_PhoneBookSyncStatusValue;
   //CallHistorySyncStatus
   tU8 _tCallHistorySyncStatus_CallHistorySyncStatusValue;
   //PhoneStatusRoaming
   tU8 _tPhoneStatusRoaming_PhoneStatusRoamingValue;
   //CallDuration
   tU16 _tCallDuration_CallDurationValue;
   //GSMSignalStrength
   tU8 _tGSMSignalStrength_GSMSignalStrengthValue;
   //PhoneCallStatus
   tU8 _tPhoneCallStatus_CallStatusValue;
   //PhoneBatteryLevelStatus
   tU8 _tPhoneBatteryLevelStatus_PhoneBatteryLevelStatusValue;
   //DeviceStatusWifiAvailable
   tU8 _tDeviceStatusWifiAvailable_DeviceStatusWifiStatus;
   //MediaStatusAudioSource
   tU8 _tMediaStatusAudioSource_AudioSource;
   //PhoneAvailableStatus
   tU8 _tPhoneAvailableStatus_PhoneAvailableStatusValue;
   //PhoneVRAvailable
   tU8 _tPhoneVRAvailable_PhoneVRAvailableValue;
   //DeviceStatusBTStatus
   tU8 _tDeviceStatusBTStatus_DeviceStatusBTStatusValue; 
   //DeviceStatusBluetoothAvail
   tU8 _tDeviceStatusBluetoothAvail_DeviceStatusBluetoothAvailValue;
   //Req_DeviceInfo
   tU8 _tReq_DeviceInfo_Req_DeviceInfoValue;
   //MediaStatusVolume
   tU8 _tMediaStatusVolume_volume;
   //CabinMediaStatusAudioSource
   tU8 _tCabinMediaStatusAudioSource_CabinAudioSource;
    //CabinMediaStatusTunerBand
   tU8 _tCabinMediaStatusTunerBand_CabinTunerBand;
   //CabinMediaStatusVolume
   tU8 _tCabinMediaStatusVolume_CabinVolume;
   //MediaStatusMuteStatus
   tU8 _tMediaStatusMuteStatus_MediaStatusMuteValue;
   //CabinMediaStatusMuteStatus
   tU8 _tCabinMediaStatusMuteStatus_CabinMediaStatusMuteValue;
   //MediaStatusPlayStatus
   tU8 _tMediaStatusPlayStatus_MediaStatusPlayStatusValue;
  //MediaStatusSeekStatus
   tU8 _tMediaStatusSeekStatus_MediaStatusSeekStatusValue;
   //MediaStatusRepeatStatus
   tU8 _tMediaStatusRepeatStatus_MediaStatusRepeatStatusValue;
   //MediaStatusDABFMStatus
   tU8 _tMediaStatusDABFMStatus_MediaStatusDABFMStatusValue;
   //VehicleNaviLatitude
   tU32 _tVehicleNaviLatitude_VehicleNaviLatitudeValue;
   //VehicleNaviLongitude
   tU32 _tVehicleNaviLongitude_VehicleNaviLongitudeValue;
   //MediaStatusTREGStatus
   tU8 _tMediaStatusTREGStatus_MediaStatusTREGStatusValue;
   //MediaStatusTREGRTMStatus
   tU8 _tMediaStatusTREGRTMStatus_MediaStatusTREGRTMStatusValue;
   //MediaStatusRDSStatus
   tU8 _tMediaStatusRDSStatus_MediaStatusRDSStatusValue;
  //MediaStatusTAStatus
   tU8 _tMediaStatusTAStatus_MediaStatusTAStatusValue;
   //MediaStatusTPStatus
   tU8 _tMediaStatusTPStatus_MediaStatusTPStatusValue;
   //MediaStatusTunerBandStatus
   tU8 _tMediaStatusTunerBandStatus_MediaStatusTunerBandStatusValue;
   //MediaStatusTunerPresetStatus
   tU8 _tMediaStatusTunerPresetStatus_MediaStatusTunerPresetStatusValue;   
   //MediaStatusMixState
   tU8 _tMediaStatusMixState_MediaStatusMixStateValue;
  //MediaStatusPlaylistMode
   tU8 _tMediaStatusPlaylistMode_MediaStatusPlaylistModeValue;
   //MediaStatusPlaylistMode
   tU16 _tMediaStatusTrackTime_MediaStatusTrackTimeValue;
   //MediaStatusCurrTrackNum
   tU16 _tMediaStatusCurrTrackNum_MediaStatusCurrTrackNumValue;
   //DeviceStatusRadioStatus
   tU8 _tDeviceStatusRadioStatus_DeviceStatusRadioStatusValue;
   //DeviceStatusDABAvailStatus
   tU8 _tDeviceStatusDABAvailStatus_DeviceStatusDABAvailStatusValue;
   //DeviceStatusNavData
   tU8 _tDeviceStatusNavData_DeviceStatusNavDataValue;
   //DeviceStatusUSB1Present
   tU8 _tDeviceStatusUSB1Present_DeviceStatusUSB1PresentValue;  
   //DeviceStatusUSB2Present
   tU8 _tDeviceStatusUSB2Present_DeviceStatusUSB2PresentValue;
   //DeviceStatusNaviAvail
   tU8 _tDeviceStatusNaviAvail_DeviceStatusNaviAvailValue;  
   //DeviceStatusUSB1Src
   tU8 _tDeviceStatusUSB1Src_DeviceStatusUSB1SrcValue;   
   //DeviceStatusUSB2Src
   tU8 _tDeviceStatusUSB2Src_DeviceStatusUSB2SrcValue;  
   //DeviceStatusAMFMAvail
   tU8 _tDeviceStatusAMFMAvail_DeviceStatusAMFMAvailValue;
      //_tHUS_DM1_Status
   tU64  _tHUS_DM1_Status_HUS_DM1_StatusValue;
  
   
   tclMethodResultManager _oMemSendMediaInfoMStart;
   tclMethodResultManager _oMemSendCallInfoMStart;
   tclMethodResultManager _oMemSendPhoneInfoMStart;
   tclMethodResultManager _oMemSendXMInfoMStart;
   tclMethodResultManager _oMemSendMainlineInfoMStart;
   tclMethodResultManager _oMemSendCabinAMediaInfoMStart;
   tclMethodResultManager _oMemSendCabinAMainlineInfoMStart;
   tclMethodResultManager _oMemSendCabinAPhoneInfoMStart;
   tclMethodResultManager _oMemSendCabinACallInfoMStart;
   tclMethodResultManager _oMemSendCabinAXMInfoMStart;
   tclMethodResultManager _oMemSendNaviCurrentStreetNameInfoMStart;
   tclMethodResultManager _oMemSendNaviTurnToStreetNameInfoMStart;
   tclMethodResultManager _oMemSendNaviDestinationInfoMStart;
   tclMethodResultManager _oMemSendNaviTurnToSymbolsInfoMStart;
   tclMethodResultManager _oMemSendNaviLaneGuidanceInfoMStart;
   tclMethodResultManager _oMemSendNaviNavigationWarningInfoMStart;
   tclMethodResultManager _oMemSetLanguage;
   tclMethodResultManager _oMemRequestMeterLanguageSync;
   tclMethodResultManager _oMemCSMEngineeringData;
   tclMethodResultManager _oMemSetOSPAlertsStatus;
   //Cam1ManAct
   tclMethodResultManager _oMemCam1ManAct;
   //Cam2ManAct
   tclMethodResultManager _oMemCam2ManAct;
   //Cam3ManAct
   tclMethodResultManager _oMemCam3ManAct;
   //Cam4ManAct
   tclMethodResultManager _oMemCam4ManAct;
   //Cam5ManAct
   tclMethodResultManager _oMemCam5ManAct;
   //Cam6ManAct
   tclMethodResultManager _oMemCam6ManAct;
   //Cam7ManAct
   tclMethodResultManager _oMemCam7ManAct;
	//Cam8ManAct
   tclMethodResultManager _oMemCam8ManAct;
   	//Cam9ManAct
   tclMethodResultManager _oMemCam9ManAct;
  //Cam10ManAct
   tclMethodResultManager _oMemCam10ManAct;
  //Cam11ManAct
   tclMethodResultManager _oMemCam11ManAct;
  //Cam12ManAct
   tclMethodResultManager _oMemCam12ManAct;
  //Cam13ManAct
   tclMethodResultManager _oMemCam13ManAct;
  //Cam14ManAct
   tclMethodResultManager _oMemCam14ManAct;
  //Cam15ManAct
   tclMethodResultManager _oMemCam15ManAct;
   //Cam16ManAct
   tclMethodResultManager _oMemCam16ManAct;
   //Cam17ManAct
   tclMethodResultManager _oMemCam17ManAct;
   //PrivacyResetAck
   tclMethodResultManager _oMemPrivacyResetAck;
   //DispCamCls
   tclMethodResultManager _oMemDispCamCls;
    //PhoneBTLinkStatus
   tclMethodResultManager _oMemPhoneBTLinkStatus;
    //PhoneBookSyncStatus
   tclMethodResultManager _oMemPhoneBookSyncStatus;
    //CallHistorySyncStatus
   tclMethodResultManager _oMemCallHistorySyncStatus;
   //PhoneStatusRoaming
   tclMethodResultManager _oMemPhoneStatusRoaming;
   //CallDuration
   tclMethodResultManager _oMemCallDuration;
   //GSMSignalStrength
   tclMethodResultManager _oMemGSMSignalStrength;
   //PhoneCallStatus
    tclMethodResultManager _oMemPhoneCallStatus;
	//PhoneBatteryLevelStatus
    tclMethodResultManager _oMemPhoneBatteryLevelStatus;
	//DeviceStatusWifiAvailable
    tclMethodResultManager _oMemDeviceStatusWifiAvailable;
	//MediaStatusAudioSource
    tclMethodResultManager _oMemMediaStatusAudioSource;
	//PhoneAvailableStatus
    tclMethodResultManager _oMemPhoneAvailableStatus;
	//PhoneVRAvailable
    tclMethodResultManager _oMemPhoneVRAvailable;
	//DeviceStatusBTStatus
    tclMethodResultManager _oMemDeviceStatusBTStatus;
	//DeviceStatusBluetoothAvail
    tclMethodResultManager _oMemDeviceStatusBluetoothAvail;
	//Req_DeviceInfo
    tclMethodResultManager _oMemReq_DeviceInfo;
	//MediaStatusVolume
	tclMethodResultManager _oMemMediaStatusVolume;
	//CabinMediaStatusAudioSource
	tclMethodResultManager _oMemCabinMediaStatusAudioSource;
	//CabinMediaStatusTunerBand
	tclMethodResultManager _oMemCabinMediaStatusTunerBand;
	//CabinMediaStatusVolume
	tclMethodResultManager _oMemCabinMediaStatusVolume;
	//MediaStatusMuteStatus
	tclMethodResultManager _oMemMediaStatusMuteStatus;
	//CabinMediaStatusMuteStatus
	tclMethodResultManager _oMemCabinMediaStatusMuteStatus;
	//MediaStatusPlayStatus
	tclMethodResultManager _oMemMediaStatusPlayStatus;
	//MediaStatusSeekStatus
	tclMethodResultManager _oMemMediaStatusSeekStatus;
	//MediaStatusRepeatStatus
	tclMethodResultManager _oMemMediaStatusRepeatStatus;
	//MediaStatusDABFMStatus
	tclMethodResultManager _oMemMediaStatusDABFMStatus;
	//MediaStatusTREGStatus
	tclMethodResultManager _oMemMediaStatusTREGStatus;
	//MediaStatusTREGRTMStatus
	tclMethodResultManager _oMemMediaStatusTREGRTMStatus;
	//MediaStatusRDSStatus
	tclMethodResultManager _oMemMediaStatusRDSStatus;
	//MediaStatusTAStatus
	tclMethodResultManager _oMemMediaStatusTAStatus;
	//MediaStatusTPStatus
	tclMethodResultManager _oMemMediaStatusTPStatus;
	//MediaStatusTunerBandStatus
	tclMethodResultManager _oMemMediaStatusTunerBandStatus;
	//MediaStatusTunerPresetStatus
	tclMethodResultManager _oMemMediaStatusTunerPresetStatus;	
	//MediaStatusMixState
	tclMethodResultManager _oMemMediaStatusMixState;
	//MediaStatusPlaylistMode
	tclMethodResultManager _oMemMediaStatusPlaylistMode;
	//MediaStatusTrackTime
	tclMethodResultManager _oMemMediaStatusTrackTime;
	//MediaStatusCurrTrackNum
	tclMethodResultManager _oMemMediaStatusCurrTrackNum;
	//DeviceStatusRadioStatus
	tclMethodResultManager _oMemDeviceStatusRadioStatus;
	//DeviceStatusDABAvailStatus
	tclMethodResultManager _oMemDeviceStatusDABAvailStatus;
	//DeviceStatusNavData
	tclMethodResultManager _oMemDeviceStatusNavData;
	//DeviceStatusUSB1Present
	tclMethodResultManager _oMemDeviceStatusUSB1Present;	
	//DeviceStatusUSB2Present
	tclMethodResultManager _oMemDeviceStatusUSB2Present;
	//DeviceStatusNaviAvail
	tclMethodResultManager _oMemDeviceStatusNaviAvail;	
	//DeviceStatusUSB1Src
	tclMethodResultManager _oMemDeviceStatusUSB1Src;	
	//DeviceStatusUSB2Src
	tclMethodResultManager _oMemDeviceStatusUSB2Src;
	//DeviceStatusAMFMAvail
	tclMethodResultManager _oMemDeviceStatusAMFMAvail;	
	//   //HUS_DM1_Status
	tclMethodResultManager _oMemHUS_DM1_Status;
	//   //VehicleNaviLatitude
	tclMethodResultManager _oMemVehicleNaviLatitude;
	//   //VehicleNaviLongitude
	tclMethodResultManager _oMemVehicleNaviLongitude;
	
   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(veda_tclServiceVehicle) 

// veda_tclServiceVehicleDeclarationsPart2: user specific code start
   tVoid vSetDefaultUnitSettings();
   tVoid vReadDefaultUnitSettings();

   tVoid _vReadLastModeLanguageSettings();

   tVoid _vInitializeLangSourceTableList(tVoid);

   tU8 _u8ReadKDSDefaultLanguage(tVoid) const;
   tU8 _u8GetDPLangForSource(const tU8 u8Source) const;

   tBool m_bISAConfigured;
   tBool m_bTrafficSignConfigured;
// veda_tclServiceVehicleDeclarationsPart2: user specific code end

};

#endif // __veda_ServiceVehicle_H_


