/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          I_veda_ClientVcanEvobusb2eCanAdaptor.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: vehicledata
  * @Template:     IcsmAdaptor.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Csm adapter interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef _I_VCANCANADAPTOR_H_
#define _I_VCANCANADAPTOR_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#define CSM_C_PROJECT_USERSPACE_EVOBUSB2E
#include "csm_if.h"


// I_veda_tclClientVcanCanAdaptor::Include: user specific code start
#ifndef CSM_C_ASIG_RX_OSPOverSpeedDisplayRequest
#define CSM_C_ASIG_RX_OSPOverSpeedDisplayRequest             CSM_M_MAKE_SIGNAL_ID(CBR_C_DEPRECATED_IDX, 0)
#endif

#ifndef CSM_C_ASIG_RX_OSPSpeedUnit
#define CSM_C_ASIG_RX_OSPSpeedUnit                           CSM_M_MAKE_SIGNAL_ID(CBR_C_DEPRECATED_IDX, 1)
#endif

#ifndef CSM_C_ASIG_RX_TSR_OSP_ActivationStatus
#define CSM_C_ASIG_RX_TSR_OSP_ActivationStatus               CSM_M_MAKE_SIGNAL_ID(CBR_C_DEPRECATED_IDX, 2)
#endif

#ifndef CSM_C_ASIG_TX_BlowerReductionRequest
#define CSM_C_ASIG_TX_BlowerReductionRequest                 CSM_M_MAKE_SIGNAL_ID(CBR_C_DEPRECATED_IDX, 3)
#endif

#ifndef CSM_C_ASIG_TX_TSR_OSPActivationRequest2
#define CSM_C_ASIG_TX_TSR_OSPActivationRequest2              CSM_M_MAKE_SIGNAL_ID(CBR_C_DEPRECATED_IDX, 4)
#endif
// I_veda_tclClientVcanCanAdaptor::Include: user specific code end

//include base class
#include "veda_AppMain.h"
#include "I_veda_ServiceVehicle.h"


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
typedef struct  {
    tU32 u32Status;
    tU8   Speed_Limit_Display_Request;
}TSpeed_Limit_Display_Request;
typedef struct  {
    tU32 u32Status;
    tU8   Navi_display_speed_limit_1;
}TNavi_display_speed_limit_1;
typedef struct  {
    tU32 u32Status;
    tU8   Navi_display_speed_limit_2;
}TNavi_display_speed_limit_2;
typedef struct  {
    tU32 u32Status;
    tU8   IgnitionSupplyConfirmation;
}TIgnitionSupplyConfirmation;
typedef struct  {
    tU32 u32Status;
    tU8   VehicleSpeed[2];
}TVehicleSpeed;
typedef struct  {
    tU32 u32Status;
    tU8   PartialMuteValue;
}TPartialMuteValue;
typedef struct  {
    tU32 u32Status;
    tU8   SwivMonAutoOpenValue;
}TSwivMonAutoOpenValue;
typedef struct  {
    tU32 u32Status;
    tU8   DateModeValue;
}TDateModeValue;
typedef struct  {
    tU32 u32Status;
    tU8  TmModeValue;
}TTmModeValue;
//MediaInfo
typedef struct {
        tU8 u8txtype;
        bpstl::vector<tU8>  list;
}TMediaInfo;
//StreetInfo
typedef struct {
	tU8 u8txtype;
	bpstl::vector<tU8>  list;
}TStreetInfo;
typedef struct {
	bpstl::vector<tU8>  list;
}TNaviInfo;
//camera
typedef struct  {
    tU32 u32Status;
    tU8  ActCam1Value;
}TActCam1Value;
//camera2
typedef struct  {
    tU32 u32Status;
    tU8  ActCam2Value;
}TActCam2Value;
//camera3
typedef struct  {
    tU32 u32Status;
    tU8  ActCam3Value;
}TActCam3Value;
//camera4
typedef struct  {
    tU32 u32Status;
    tU8  ActCam4Value;
}TActCam4Value;
//camera5
typedef struct  {
    tU32 u32Status;
    tU8  ActCam5Value;
}TActCam5Value;
//camera6
typedef struct  {
    tU32 u32Status;
    tU8  ActCam6Value;
}TActCam6Value;
//camera7
typedef struct  {
    tU32 u32Status;
    tU8  ActCam7Value;
}TActCam7Value;
//camsplit
typedef struct  {
    tU32 u32Status;
    tU16  CamSplitQuadValue;
}TCamSplitQuadValue;
//TCOVehiclespeed
typedef struct  {
    tU32 u32Status;
    tU8  TCOVehicleSpeed[2];
}TTCOVehicleSpeed;
//MuteDev
typedef struct  {
    tU32 u32Status;
    tU8   MuteDevStatus;
}TMuteDevStatus;
//CurrGr
typedef struct  {
    tU32 u32Status;
    tU8   TxCurrGrStatus;
}TTxCurrGrStatus;
//SysVolt
typedef struct  {
    tU32 u32Status;
    tU8  SysVoltStatus;
}TSysVoltStatus;
//ParkingBreakSwitch
typedef struct  {
    tU32 u32Status;
    tU8   ParkingBreakSwitchValue;
}TParkingBreakSwitchValue;
//Distance Unit
typedef struct  {
    tU8 u8TxType;
    tU8  UnitDistanceDisplayRequest;
}TUnitDistanceDisplayRequest;
//ReverseSwitch
typedef struct  {
    tU32 u32Status;
    tU8   ReverseSwitchValue;
}TReverseSwitchValue;

//DirectionIndicator
typedef struct  {
    tU32 u32Status;
    tU8   DirectionIndicatorValue;
}TDirectionIndicatorValue;

//RearCamReq
typedef struct  {
    tU32 u32Status;
    tU8   RearCamReqValue;
}TRearCamReqValue;

//VIN
typedef struct  {
    tU32 u32Status;
    tU32  VINValue;
}TVINValue;
//Time Date
typedef struct  {
    tU32 u32Status;
    tU64  TimeDateValue;
}TTimeDateValue;

//Phone Call Command
typedef struct  {
    tU32 u32Status;
    tU8   PhoneCallCmdValue;
}TPhoneCallCommand;

// Volume Command
typedef struct  {
    tU32 u32Status;
    tU8   VolumeCmdValue;
}TVolumeCommand;

// ActCam8 
typedef struct  {
    tU32 u32Status;
    tU8   ActCam8Value;
}TActCam8;
// ActCam9 
typedef struct  {
    tU32 u32Status;
    tU8   ActCam9Value;
}TActCam9;
// ActCam10 
typedef struct  {
    tU32 u32Status;
    tU8   ActCam10Value;
}TActCam10;

// ActCam11 
typedef struct  {
    tU32 u32Status;
    tU8   ActCam11Value;
}TActCam11;

// ActCam12 
typedef struct  {
    tU32 u32Status;
    tU8   ActCam12Value;
}TActCam12;

// ActCam13 
typedef struct  {
    tU32 u32Status;
    tU8   ActCam13Value;
}TActCam13;

// ActCam14
typedef struct  {
    tU32 u32Status;
    tU8   ActCam14Value;
}TActCam14;

// ActCam15
typedef struct  {
    tU32 u32Status;
    tU8   ActCam15Value;
}TActCam15;

// ActCam16
typedef struct  {
    tU32 u32Status;
    tU8   ActCam16Value;
}TActCam16;

// ActCam17
typedef struct  {
    tU32 u32Status;
    tU8   ActCam17Value;
}TActCam17;
// Source Command
typedef struct  {
    tU32 u32Status;
    tU8   SourceCmdValue;
}TSourceCommand;

// CabinSource Command
typedef struct  {
    tU32 u32Status;
    tU8   CabinSourceCmdValue;
}TCabinSourceCommand;

// CabinVolume Command
typedef struct  {
    tU32 u32Status;
    tU8   CabinVolumeCmdValue;
}TCabinVolumeCommand;

// CabinTuner Command
typedef struct  {
    tU32 u32Status;
    tU8   CabinTunerCmdValue;
}TCabinTunerCommand;

// CabinTrackCommand
typedef struct  {
    tU32 u32Status;
    tU8   CabinTrackCmdValue;
}TCabinTrackCommand;

// CabinPlaylistCommand
typedef struct  {
    tU32 u32Status;
    tU8   CabinPlaylistCmdValue;
}TCabinPlaylistCommand;

//Voice Recg  Command
typedef struct  {
    tU32 u32Status;
    tU8   VoiceRecgCmdValue;
}TVoiceRecgCommand;


// RC Next Btn
typedef struct  {
    tU32 u32Status;
    tU8   RCNextBtnValue;
}TRCNextBtn;

// RC Prev Btn
typedef struct  {
    tU32 u32Status;
    tU8   RCPrevBtnValue;
}TRCPrevBtn;

//  SMARTVR
typedef struct  {
    tU32 u32Status;
    tU8   SMARTVRValue;
}TSMARTVR;
//Track  Command
typedef struct  {
    tU32 u32Status;
    tU8   TrackCommandValue;
}TTrackCommand;
//Tuner  Command
typedef struct  {
    tU32 u32Status;
    tU8   TunerCommandValue;
}TTunerCommand;
//TA  Command
typedef struct  {
    tU32 u32Status;
    tU8   TACommandValue;
}TTACommand;
//RDS  Command
typedef struct  {
    tU32 u32Status;
    tU8   RDSCommandValue;
}TRDSCommand;


//VIN_64 
typedef struct  {
    tU32 u32Status;
    tU64   VIN_64Value;
}TVIN_64;

//Totalveh distance 
typedef struct  {
    tU32 u32Status;
    tU32   TotalVehDistDiagValue;
}TTotalVehDistDiag;

//sw version 
typedef struct  {
    tU32 u32Status;
    tU32   SWversionValue;
}TDeviceInfoSWversion;

//PhonePwrCmd  
typedef struct  {
    tU32 u32Status;
    tU8   PhonePwrCmdValue;
}TPhonePwrCmd;


//RadioPwrCmd  
typedef struct  {
    tU32 u32Status;
    tU8   RadioPwrCmdValue;
}TRadioPwrCmd;





//System Language
typedef struct  {
    tU32 u32Status;
    tU16   SystemLanguageValue;
}TSystemLanguageValue;
//CurrLang
typedef struct  {
    tU32 u32Status;
    tU16   CurrLangValue;
}TCurrLangValue;
//CamTxt
typedef struct  {
    tU32 u32Status;
    tU64  CamTxtValue;
}TCamTxtValue;
//PrivacyResetReq
typedef struct  {
    tU32 u32Status;
    tU8  PrivacyResetReqValue;
}TPrivacyResetReqValue;
typedef struct  {
    tU32 u32Status;
    tU8   DistanceUnit;
}TDistanceUnit;

typedef struct  {
    tU32 u32Status;
    tU8   HandBrakeSwitch;
}THandBrakeSwitch;
typedef struct  {
    tU32 u32Status;
    tU8   DistanceTotalizer[4];
}TDistanceTotalizer;
typedef struct  {
    tU32 u32Status;
    tU8   Average_Fuel_Economy[2];
}TAverage_Fuel_Economy;
typedef struct  {
    tU32 u32Status;
    tU8   DiagMuxOn;
}TDiagMuxOn;
typedef struct  {
    tU32 u32Status;
    tU8   DiagMuxOn_84;
}TDiagMuxOn_84;
typedef struct  {
    tU32 u32Status;
    tU8   GADE;
}TGADE;
typedef struct  {
    tU32 u32Status;
    tU8   RearGearEngaged;
}TRearGearEngaged;
typedef struct  {
    tU32 u32Status;
    tU8   OSPOverSpeedDisplayRequest;
}TOSPOverSpeedDisplayRequest;
typedef struct  {
    tU32 u32Status;
    tU8   OSPSpeedUnit;
}TOSPSpeedUnit;
typedef struct  {
    tU32 u32Status;
    tU8   TSR_OSP_ActivationStatus;
}TTSR_OSP_ActivationStatus;
typedef struct  {
    tU32 u32Status;
    tU8   MeterLanguageKnowledge;
}TMeterLanguageKnowledge;
typedef struct  {
    tU32 u32Status;
    tU8   MeterLanguageStatus;
}TMeterLanguageStatus;
typedef struct  {
    tU32 u32Status;
    tU8   UnitDistanceDisplayState;
}TUnitDistanceDisplayState;
typedef struct  {
    tU32 u32Status;
    tU8   Reset_TPMS_answer_back;
}TReset_TPMS_answer_back;
typedef struct  {
    tU32 u32Status;
    tU8   Select_pressure_support;
}TSelect_pressure_support;
typedef struct  {
    tU32 u32Status;
    tU8   Setting_pressure_Front_answer_back;
}TSetting_pressure_Front_answer_back;
typedef struct  {
    tU32 u32Status;
    tU8   Setting_pressure_Rear_answer_back;
}TSetting_pressure_Rear_answer_back;
typedef struct  {
    tU32 u32Status;
    tU8   GlobalVehicleWarningState;
}TGlobalVehicleWarningState;
typedef struct  {
    tU32 u32Status;
    tU8   VehicleStates;
}TVehicleStates;

//Cam1ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam1ManAct;
}TCam1ManAct;
//Cam2ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam2ManAct;
}TCam2ManAct;
//Cam3ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam3ManAct;
}TCam3ManAct;
//Cam4ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam4ManAct;
}TCam4ManAct;
//Cam5ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam5ManAct;
}TCam5ManAct;
//Cam6ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam6ManAct;
}TCam6ManAct;
//Cam7ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam7ManAct;
}TCam7ManAct;
//Cam8Manact
typedef struct  {
    tU8 u8TxType;
    tU8  Cam8ManAct;
}TCam8ManAct;
//Cam9ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam9ManAct;
}TCam9ManAct;
//Cam10ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam10ManAct;
}TCam10ManAct;
//Cam11ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam11ManAct;
}TCam11ManAct;
//Cam12ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam12ManAct;
}TCam12ManAct;
//Cam13ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam13ManAct;
}TCam13ManAct;
//Cam14ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam14ManAct;
}TCam14ManAct;
//Cam15ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam15ManAct;
}TCam15ManAct;
//Cam16ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam16ManAct;
}TCam16ManAct;
//Cam17ManAct
typedef struct  {
    tU8 u8TxType;
    tU8  Cam17ManAct;
}TCam17ManAct;
//PhoneBTLinkStatus
typedef struct  {
    tU8 u8TxType;
    tU8  BTLinkStatus;
}TPhoneBTLinkStatus;
//PhoneBookSyncStatus
typedef struct  {
    tU8 u8TxType;
    tU8  PhoneBookSyncStatusValue;
}TPhoneBookSyncStatus;
//CallHistorySyncStatus
typedef struct  {
    tU8 u8TxType;
    tU8  CallHistorySyncStatusValue;
}TCallHistorySyncStatus;
//PhoneStatusRoaming
typedef struct  {
    tU8 u8TxType;
    tU8  PhoneStatusRoamingValue;
}TPhoneStatusRoaming;
//CallDuration
typedef struct  {
    tU8 u8TxType;
    tU16  CallDurationValue;
}TCallDuration;
//GSMSignalStrength
typedef struct  {
    tU8 u8TxType;
    tU8  GSMSignalStrengthValue;
}TGSMSignalStrength;
//PhoneCallStatus
typedef struct  {
    tU8 u8TxType;
    tU8  CallStatusValue;
}TPhoneCallStatus;
//PhoneBatteryLevelStatus
typedef struct  {
    tU8 u8TxType;
    tU8  PhoneBatteryLevelStatusValue;
}TPhoneBatteryLevelStatus;
//DeviceStatusWifiAvailable
typedef struct  {
    tU8 u8TxType;
    tU8  DeviceStatusWifiStatus;
}TDeviceStatusWifiAvailable;
//MediaStatusAudioSource
typedef struct  {
    tU8 u8TxType;
    tU8  AudioSource;
}TMediaStatusAudioSource;
//PhoneAvailableStatus
typedef struct  {
    tU8 u8TxType;
    tU8  PhoneAvailableStatusValue;
}TPhoneAvailableStatus;

//PhoneVRAvailable
typedef struct  {
    tU8 u8TxType;
    tU8  PhoneVRAvailableValue;
}TPhoneVRAvailable;

//DeviceStatusBTStatus
typedef struct  {
    tU8 u8TxType;
    tU8  DeviceStatusBTStatusValue;
}TDeviceStatusBTStatus;
//DeviceStatusBluetoothAvail
typedef struct  {
    tU8 u8TxType;
    tU8  DeviceStatusBluetoothAvailValue;
}TDeviceStatusBluetoothAvail;
//Req_DeviceInfo
typedef struct  {
    tU8 u8TxType;
    tU8  Req_DeviceInfoValue;
}TReq_DeviceInfo;
//MediaStatusVolume
typedef struct  {
    tU8 u8TxType;
    tU8  volume;
}TMediaStatusVolume;
//CabinMediaStatusAudioSource
typedef struct  {
    tU8 u8TxType;
    tU8  CabinAudioSource;
}TCabinMediaStatusAudioSource;
//CabinMediaStatusTunerBand
typedef struct  {
    tU8 u8TxType;
    tU8  CabinMediaStatusTunerBandValue;
}TCabinMediaStatusTunerBand;
//CabinMediaStatusVolume
typedef struct  {
    tU8 u8TxType;
    tU8  CabinVolume;
}TCabinMediaStatusVolume;
//MediaStatusMuteStatus
typedef struct  {
    tU8 u8TxType;
    tU8  MediaStatusMuteValue;
}TMediaStatusMuteStatus;
//CabinMediaStatusMuteStatus
typedef struct  {
    tU8 u8TxType;
    tU8  CabinMediaStatusMuteValue;
}TCabinMediaStatusMuteStatus;
//MediaStatusPlayStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusPlayStatusValue;
}TMediaStatusPlayStatus;
//MediaStatusMixState
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusMixStateValue;
}TMediaStatusMixState;
//MediaStatusPlaylistMode
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusPlaylistModeValue;
}TMediaStatusPlaylistMode;
//MediaStatusTrackTime
typedef struct  {
    tU8 u8TxType;
    tU16 MediaStatusTrackTimeValue;
}TMediaStatusTrackTime;
//MediaStatusCurrTrackNum
typedef struct  {
    tU8 u8TxType;
    tU16 MediaStatusCurrTrackNumValue;
}TMediaStatusCurrTrackNum;
//DeviceStatusRadioStatus
typedef struct  {
    tU8 u8TxType;
    tU8 DeviceStatusRadioStatusValue;
}TDeviceStatusRadioStatus;
//DeviceStatusDABAvailStatus
typedef struct  {
    tU8 u8TxType;
    tU8 DeviceStatusDABAvailStatusValue;
}TDeviceStatusDABAvailStatus;
//DeviceStatusNavData
typedef struct  {
    tU8 u8TxType;
    tU8 DeviceStatusNavDataValue;
}TDeviceStatusNavData;
//DeviceStatusUSB1Present
typedef struct  {
    tU8 u8TxType;
    tU8 DeviceStatusUSB1PresentValue;
}TDeviceStatusUSB1Present;
//DeviceStatusUSB2Present
typedef struct  {
    tU8 u8TxType;
    tU8 DeviceStatusUSB2PresentValue;
}TDeviceStatusUSB2Present;
//DeviceStatusNaviAvail
typedef struct  {
    tU8 u8TxType;
    tU8 DeviceStatusNaviAvailValue;
}TDeviceStatusNaviAvail;
//DeviceStatusUSB1Src
typedef struct  {
    tU8 u8TxType;
    tU8 DeviceStatusUSB1SrcValue;
}TDeviceStatusUSB1Src;
//DeviceStatusUSB2Src
typedef struct  {
    tU8 u8TxType;
    tU8 DeviceStatusUSB2SrcValue;
}TDeviceStatusUSB2Src;
//DeviceStatusAMFMAvail
typedef struct  {
    tU8 u8TxType;
    tU8 DeviceStatusAMFMAvailValue;
}TDeviceStatusAMFMAvail;
//MediaStatusSeekStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusSeekStatusValue;
}TMediaStatusSeekStatus;
//MediaStatusRepeatStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusRepeatStatusValue;
}TMediaStatusRepeatStatus;
//MediaStatusDABFMStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusDABFMStatusValue;
}TMediaStatusDABFMStatus;
//VehicleNaviLatitude
typedef struct  {
    tU8 u8TxType;
    tU32  VehicleNaviLatitudeValue;
}TVehicleNaviLatitude;
//VehicleNaviLongitude
typedef struct  {
    tU8 u8TxType;
    tU32  VehicleNaviLongitudeValue;
}TVehicleNaviLongitude;
//MediaStatusTREGStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusTREGStatusValue;
}TMediaStatusTREGStatus;
//MediaStatusTREGRTMStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusTREGRTMStatusValue;
}TMediaStatusTREGRTMStatus;
//MediaStatusRDSStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusRDSStatusValue;
}TMediaStatusRDSStatus;
//MediaStatusTAStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusTAStatusValue;
}TMediaStatusTAStatus;
//MediaStatusTPStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusTPStatusValue;
}TMediaStatusTPStatus;
//MediaStatusTunerBandStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusTunerBandStatusValue;
}TMediaStatusTunerBandStatus;
//MediaStatusTunerPresetStatus
typedef struct  {
    tU8 u8TxType;
    tU8 MediaStatusTunerPresetStatusValue;
}TMediaStatusTunerPresetStatus;
//HUS_DM1_Status
typedef struct  {
    tU8 u8TxType;
    tU64 HUS_DM1_StatusValue;
}THUS_DM1_Status;
//PrivacyResetAck
typedef struct  {
    tU8 u8TxType;
    tU8  PrivacyResetAck;
}TPrivacyResetAck;
//DispCamCls
typedef struct  {
    tU8 u8TxType;
    tU8  DispCamCls;
}TDispCamCls;
typedef struct  {
    tU8 u8TxType;
    tU8  Voice_Recognition_Executing;
}TVoice_Recognition_Executing;
typedef struct  {
    tU8 u8TxType;
    tU8  BlowerReductionRequest;
}TBlowerReductionRequest;
typedef struct  {
    tU8 u8TxType;
    tU8  TSR_OSPActivationRequest2;
}TTSR_OSPActivationRequest2;
typedef struct  {
    tU8 u8TxType;
    tU8  MeterLanguageSyncMenu;
}TMeterLanguageSyncMenu;
typedef struct  {
    tU8 u8TxType;
    tU8  CockpitLanguageRequest;
}TCockpitLanguageRequest;
typedef struct  {
    tU8 u8TxType;
    tU8  Setting_Change_Request_for_TPMS;
}TSetting_Change_Request_for_TPMS;
//Driver Door open status Command
typedef struct  {
    tU32 u32Status;
    tU8   DriverDoorstatusCmdValue;
}TDriverDoorstatusCmd;


class CsmCallbackIF {
public:
    virtual ~CsmCallbackIF() {}
    virtual void onSpeed_Limit_Display_RequestStatus(TSpeed_Limit_Display_Request tSpeed_Limit_Display_Request) = 0;
    virtual void onNavi_display_speed_limit_1Status(TNavi_display_speed_limit_1 tNavi_display_speed_limit_1) = 0;
    virtual void onNavi_display_speed_limit_2Status(TNavi_display_speed_limit_2 tNavi_display_speed_limit_2) = 0;
    virtual void onIgnitionSupplyConfirmationStatus(TIgnitionSupplyConfirmation tIgnitionSupplyConfirmation) = 0;
    virtual void onVehicleSpeedStatus(TVehicleSpeed tVehicleSpeed) = 0;
	virtual void onVehiclePartialMuteStatus(TPartialMuteValue tPartialMuteValue) = 0;
	virtual void onVehicleSwivMonAutoOpenStatus(TSwivMonAutoOpenValue tSwivMonAutoOpenValue) = 0;
	virtual void onVehicleDateModeStatus(TDateModeValue tDateModeValue) = 0;
	virtual void onVehicleTmModeStatus(TTmModeValue tTmModeValue) = 0;
	//camera
	virtual void onVehicleActCam1Status(TActCam1Value tActCam1Value) = 0;
	//camera2
	virtual void onVehicleActCam2Status(TActCam2Value tActCam2Value) = 0;
	//camera3
	virtual void onVehicleActCam3Status(TActCam3Value tActCam3Value) = 0;
	//camera4
	virtual void onVehicleActCam4Status(TActCam4Value tActCam4Value) = 0;
	//camera5
	virtual void onVehicleActCam5Status(TActCam5Value tActCam5Value) = 0;
	//camera6
	virtual void onVehicleActCam6Status(TActCam6Value tActCam6Value) = 0;
	//camera7
	virtual void onVehicleActCam7Status(TActCam7Value tActCam7Value) = 0;
	//camsplit
	virtual void onVehicleCamSplitQuadStatus(TCamSplitQuadValue tCamSplitQuadValue) = 0;
	//TCOvehiclespeed
	virtual void onTCOVehicleSpeedStatus(TTCOVehicleSpeed tTCOVehicleSpeed) = 0;
	//MuteDev
	virtual void onVehicleMuteDevStatus(TMuteDevStatus tMuteDevStatus) = 0;
	//SysVolt
	virtual void onVehicleSysVoltStatus(TSysVoltStatus tSysVoltStatus) = 0;
	//ParkingBreakSwitch
	virtual void onVehicleParkingBreakSwitchStatus(TParkingBreakSwitchValue tParkingBreakSwitchValue) = 0;
	//Distance Unit
	virtual void onUnitDistanceDisplayStateStatus(TUnitDistanceDisplayState tUnitDistanceDisplayState) = 0;
	//RearCamReq
	virtual void onVehicleRearCamReqStatus(TRearCamReqValue tRearCamReqValue) = 0;
	//VIN
	virtual void onVehicleVINStatus(TVINValue tVINValue) = 0;
	//Device Info SW version 
	virtual void onDeviceInfoSWversionStatus(TDeviceInfoSWversion tDeviceInfoSWversionValue)=0;
	//TotalVehDistDiag
	virtual void onTotalVehDistDiagStatus(TTotalVehDistDiag tTotalVehDistDiagValue)=0;
	//VIN_64
	virtual void onVIN_64Status(TVIN_64 tVIN_64Value)=0;
	//TimeDate
	virtual void onTimeDateStatus(TTimeDateValue tTimeDateValue) = 0;
	//Phone Call Command 
	virtual void onPhoneCallCommandStatus(TPhoneCallCommand tPhoneCallCommandValue) =0;
	//ActCam8
	virtual void onActCam8Status(TActCam8 tActCam8Value) =0;
	//ActCam9
	virtual void onActCam9Status(TActCam9 tActCam9Value) =0;
	//ActCam10
	virtual void onActCam10Status(TActCam10 tActCam10Value) =0;
	//ActCam11
	virtual void onActCam11Status(TActCam11 tActCam11Value) =0;
	//ActCam12
	virtual void onActCam12Status(TActCam12 tActCam12Value) =0;
	//ActCam13
	virtual void onActCam13Status(TActCam13 tActCam13Value) =0;
	//ActCam14
	virtual void onActCam14Status(TActCam14 tActCam14Value) =0;
	//ActCam15
	virtual void onActCam15Status(TActCam15 tActCam15Value) =0;
	//ActCam16
	virtual void onActCam16Status(TActCam16 tActCam16Value) =0;
	//ActCam17
	virtual void onActCam17Status(TActCam17 tActCam17Value) =0;
 	 //Volume Command
	virtual void onVolumeCommandStatus(TVolumeCommand tVolumeCommandValue) =0;
	//Source Command
	virtual void onSourceCommandStatus(TSourceCommand tSourceCommandValue) =0;
	//CabinSource Command
	virtual void onCabinSourceCommandStatus(TCabinSourceCommand tCabinSourceCommandValue) =0;
	//CabinVolume Command
	virtual void onCabinVolumeCommandStatus(TCabinVolumeCommand tCabinVolumeCommandValue) =0;
	//CabinTuner Command
	virtual void onCabinTunerCommandStatus(TCabinTunerCommand tCabinTunerCommandValue) =0;
	//CabinTrack Command
	virtual void onCabinTrackCommandStatus(TCabinTrackCommand tCabinTrackCommandValue) =0;
	//CabinPlaylist Command
	virtual void onCabinPlaylistCommandStatus(TCabinPlaylistCommand tCabinPlaylistCommandValue) =0;
	//Track Command
	virtual void onTrackCommandStatus(TTrackCommand tTrackCommandValue) =0;
	//SMARTVR
	virtual void onSMARTVRStatus(TSMARTVR tSMARTVRValue) =0;
	//Voice Recg Command
	virtual void onVoiceRecgCommandStatus(TVoiceRecgCommand tVoiceRecgCommandValue) =0;
	//PhonePwr Command
	virtual void onPhonePwrCmdStatus(TPhonePwrCmd tPhonePwrCmdValue) =0;
	//RC Next Btn
	virtual void onRCNextBtnStatus(TRCNextBtn tRCNextBtnValue) =0;
	//RC Prev Btn
	virtual void onRCPrevBtnStatus(TRCPrevBtn tRCPrevBtnValue) =0;
	//System Language
	virtual void onVehicleSystemLanguageStatus(TSystemLanguageValue tSystemLanguageValue) = 0;
	//CurrLang
	virtual void onVehicleCurrLangStatus(TCurrLangValue tCurrLangValue) = 0;
	//CamTxt
	virtual void onVehicleCamTxtStatus(TCamTxtValue tCamTxtValue) = 0;
	//RadioPwr Cmd
	virtual void onRadioPwrCmdStatus(TRadioPwrCmd tRadioPwrCmdValue) = 0;
	//Tuner Command
	virtual void onTunerCommandStatus(TTunerCommand tTunerCommandValue) =0;
	//TA Command
	virtual void onTACommandStatus(TTACommand tTACommandValue) =0;
	//RDS Command
	virtual void onRDSCommandStatus(TRDSCommand tRDSCommandValue) =0;
	virtual void onDistanceUnitStatus(TDistanceUnit tDistanceUnit) = 0;
	virtual void onHandBrakeSwitchStatus(THandBrakeSwitch tHandBrakeSwitch) = 0;
    virtual void onDistanceTotalizerStatus(TDistanceTotalizer tDistanceTotalizer) = 0;
    virtual void onAverage_Fuel_EconomyStatus(TAverage_Fuel_Economy tAverage_Fuel_Economy) = 0;
    virtual void onDiagMuxOnStatus(TDiagMuxOn tDiagMuxOn) = 0;
    virtual void onDiagMuxOn_84Status(TDiagMuxOn_84 tDiagMuxOn_84) = 0;
    virtual void onGADEStatus(TGADE tGADE) = 0;
    virtual void onRearGearEngagedStatus(TRearGearEngaged tRearGearEngaged) = 0;
    virtual void onOSPOverSpeedDisplayRequestStatus(TOSPOverSpeedDisplayRequest tOSPOverSpeedDisplayRequest) = 0;
    virtual void onOSPSpeedUnitStatus(TOSPSpeedUnit tOSPSpeedUnit) = 0;
    virtual void onTSR_OSP_ActivationStatusStatus(TTSR_OSP_ActivationStatus tTSR_OSP_ActivationStatus) = 0;
    virtual void onMeterLanguageKnowledgeStatus(TMeterLanguageKnowledge tMeterLanguageKnowledge) = 0;
    virtual void onMeterLanguageStatusStatus(TMeterLanguageStatus tMeterLanguageStatus) = 0;
    virtual void onReset_TPMS_answer_backStatus(TReset_TPMS_answer_back tReset_TPMS_answer_back) = 0;
    virtual void onSelect_pressure_supportStatus(TSelect_pressure_support tSelect_pressure_support) = 0;
    virtual void onSetting_pressure_Front_answer_backStatus(TSetting_pressure_Front_answer_back tSetting_pressure_Front_answer_back) = 0;
    virtual void onSetting_pressure_Rear_answer_backStatus(TSetting_pressure_Rear_answer_back tSetting_pressure_Rear_answer_back) = 0;
    virtual void onGlobalVehicleWarningStateStatus(TGlobalVehicleWarningState tGlobalVehicleWarningState) = 0;
    virtual void onVehicleStatesStatus(TVehicleStates tVehicleStates) = 0;
     //Driver door open status
    virtual void onVehicleDriverDoorOpenStatus(TDriverDoorstatusCmd tDriverDoorstatusCmd) = 0;
    // CsmCallbackIF::ClassImplementation: user specific code start
    virtual tVoid vHandleCsmFaultIndication(const tU8 u8DiagIndex, const tU8 u8FaultState, const tU8 u8ForceUpdate) = 0;
    virtual tVoid vHandleKDSConfigRead(tVoid) = 0;
    // CsmCallbackIF::ClassImplementation: user specific code end
};


class I_veda_tclClientVcanCanAdaptor : public veda_tclBaseIf
{
public:
    I_veda_tclClientVcanCanAdaptor(veda_tclAppMain* poMainAppl): veda_tclBaseIf(poMainAppl) {;}
    virtual ~I_veda_tclClientVcanCanAdaptor() {;}

    virtual const tChar* getIfName() const { return "I_veda_tclClientVcanCanAdaptor"; };

    virtual tVoid vSendCsmBroadcastSignal(tU8* pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType) = 0;
    virtual tVoid vConnect() = 0;

    virtual tVoid vSetCallbackIf(CsmCallbackIF* poCallback) = 0;
    virtual tVoid vGetSpeed_Limit_Display_Request(TSpeed_Limit_Display_Request& tSpeed_Limit_Display_Request) = 0;
    virtual tVoid vGetNavi_display_speed_limit_1(TNavi_display_speed_limit_1& tNavi_display_speed_limit_1) = 0;
    virtual tVoid vGetNavi_display_speed_limit_2(TNavi_display_speed_limit_2& tNavi_display_speed_limit_2) = 0;
    virtual tVoid vGetIgnitionSupplyConfirmation(TIgnitionSupplyConfirmation& tIgnitionSupplyConfirmation) = 0;
    virtual tVoid vGetVehicleSpeed(TVehicleSpeed& tVehicleSpeed) = 0;

	virtual tVoid vGetPartialMuteValue(TPartialMuteValue& tPartialMuteValue) = 0;
	virtual tVoid vGetSwivMonAutoOpenValue(TSwivMonAutoOpenValue& tSwivMonAutoOpenValue) = 0;
	virtual tVoid vGetDateModeValue(TDateModeValue& tDateModeValue) = 0;
	virtual tVoid vGetTmModeValue(TTmModeValue& tTmModeValue) = 0;
	//camera
	virtual tVoid vGetActCam1Value(TActCam1Value& tActCam1Value) = 0;
	//camera2
	virtual tVoid vGetActCam2Value(TActCam2Value& tActCam2Value) = 0;
	//camera3
	virtual tVoid vGetActCam3Value(TActCam3Value& tActCam3Value) = 0;
	//camera4
	virtual tVoid vGetActCam4Value(TActCam4Value& tActCam4Value) = 0;
	//camera5
	virtual tVoid vGetActCam5Value(TActCam5Value& tActCam5Value) = 0;
	//camera6
	virtual tVoid vGetActCam6Value(TActCam6Value& tActCam6Value) = 0;
	//camera7
	virtual tVoid vGetActCam7Value(TActCam7Value& tActCam7Value) = 0;
	//camsplit
	virtual tVoid vGetCamSplitQuadValue(TCamSplitQuadValue& tCamSplitQuadValue) = 0;
	//TCOVehiclespeed
	 virtual tVoid vGetTCOVehicleSpeed(TTCOVehicleSpeed& tTCOVehicleSpeed) = 0;
	 //MuteDev
	 virtual tVoid vGetMuteDevStatus(TMuteDevStatus& tMuteDevStatus) = 0;
	//SysVolt
	virtual tVoid vGetSysVoltStatus(TSysVoltStatus& tSysVoltStatus) = 0;
	//ParkingBreakSwitch
	virtual tVoid vGetParkingBreakSwitchValue(TParkingBreakSwitchValue& tParkingBreakSwitchValue) = 0;
	//Distance Unit
	virtual tVoid vGetUnitDistanceDisplayState(TUnitDistanceDisplayState& tUnitDistanceDisplayState) = 0;
	//RearCamReq
	virtual tVoid vGetRearCamReqValue(TRearCamReqValue& tRearCamReqValue) = 0;
	//VIN
	virtual tVoid vGetVINValue(TVINValue& tVINValue) = 0;
	//Time Date
	virtual tVoid vGetTimeDateValue(TTimeDateValue& tTimeDateValue) = 0;
	//PhoneCall Command 
	virtual tVoid vGetPhoneCallCmdValue(TPhoneCallCommand& tPhoneCallCommand)=0;
	//System Language
	virtual tVoid vGetSystemLanguageValue(TSystemLanguageValue& tSystemLanguageValue) = 0;
	 //CurrLang
	virtual tVoid vGetCurrLangValue(TCurrLangValue& tCurrLangValue) = 0;
	//CamTxt
	virtual tVoid vGetCamTxtValue(TCamTxtValue& tCamTxtValue) = 0;
	
	virtual tVoid vGetDistanceUnit(TDistanceUnit& tDistanceUnit) = 0;
	virtual tVoid vGetHandBrakeSwitch(THandBrakeSwitch& tHandBrakeSwitch) = 0;
    virtual tVoid vGetDistanceTotalizer(TDistanceTotalizer& tDistanceTotalizer) = 0;
    virtual tVoid vGetAverage_Fuel_Economy(TAverage_Fuel_Economy& tAverage_Fuel_Economy) = 0;
    virtual tVoid vGetDiagMuxOn(TDiagMuxOn& tDiagMuxOn) = 0;
    virtual tVoid vGetDiagMuxOn_84(TDiagMuxOn_84& tDiagMuxOn_84) = 0;
    virtual tVoid vGetGADE(TGADE& tGADE) = 0;
    virtual tVoid vGetRearGearEngaged(TRearGearEngaged& tRearGearEngaged) = 0;
    virtual tVoid vGetOSPOverSpeedDisplayRequest(TOSPOverSpeedDisplayRequest& tOSPOverSpeedDisplayRequest) = 0;
    virtual tVoid vGetOSPSpeedUnit(TOSPSpeedUnit& tOSPSpeedUnit) = 0;
    virtual tVoid vGetTSR_OSP_ActivationStatus(TTSR_OSP_ActivationStatus& tTSR_OSP_ActivationStatus) = 0;
    virtual tVoid vGetMeterLanguageKnowledge(TMeterLanguageKnowledge& tMeterLanguageKnowledge) = 0;
    virtual tVoid vGetMeterLanguageStatus(TMeterLanguageStatus& tMeterLanguageStatus) = 0;
    virtual tVoid vGetReset_TPMS_answer_back(TReset_TPMS_answer_back& tReset_TPMS_answer_back) = 0;
    virtual tVoid vGetSelect_pressure_support(TSelect_pressure_support& tSelect_pressure_support) = 0;
    virtual tVoid vGetSetting_pressure_Front_answer_back(TSetting_pressure_Front_answer_back& tSetting_pressure_Front_answer_back) = 0;
    virtual tVoid vGetSetting_pressure_Rear_answer_back(TSetting_pressure_Rear_answer_back& tSetting_pressure_Rear_answer_back) = 0;
    virtual tVoid vGetGlobalVehicleWarningState(TGlobalVehicleWarningState& tGlobalVehicleWarningState) = 0;
    virtual tVoid vGetVehicleStates(TVehicleStates& tVehicleStates) = 0;

    //Cam1ManAct
	virtual tVoid vSendCam1ManAct(TCam1ManAct tTxSignal) = 0;
	//Cam2ManAct
	virtual tVoid vSendCam2ManAct(TCam2ManAct tTxSignal) = 0;
	//Cam3ManAct
	virtual tVoid vSendCam3ManAct(TCam3ManAct tTxSignal) = 0;
	//Cam4ManAct
	virtual tVoid vSendCam4ManAct(TCam4ManAct tTxSignal) = 0;
	//Cam5ManAct
	virtual tVoid vSendCam5ManAct(TCam5ManAct tTxSignal) = 0;
	//Cam6ManAct
	virtual tVoid vSendCam6ManAct(TCam6ManAct tTxSignal) = 0;
	//Cam7ManAct
	virtual tVoid vSendCam7ManAct(TCam7ManAct tTxSignal) = 0;
	//Cam8ManAct
	virtual tVoid vSendCam8ManAct(TCam8ManAct tTxSignal) = 0;
	//Cam9ManAct
	virtual tVoid vSendCam9ManAct(TCam9ManAct tTxSignal) = 0;
	//Cam10ManAct
	virtual tVoid vSendCam10ManAct(TCam10ManAct tTxSignal) = 0;
	//Cam11ManAct
	virtual tVoid vSendCam11ManAct(TCam11ManAct tTxSignal) = 0;
	//Cam12ManAct
	virtual tVoid vSendCam12ManAct(TCam12ManAct tTxSignal) = 0;
	//Cam13ManAct
	virtual tVoid vSendCam13ManAct(TCam13ManAct tTxSignal) = 0;
	//Cam14ManAct
	virtual tVoid vSendCam14ManAct(TCam14ManAct tTxSignal) = 0;
	//Cam15ManAct
	virtual tVoid vSendCam15ManAct(TCam15ManAct tTxSignal) = 0;
	//Cam16ManAct
	virtual tVoid vSendCam16ManAct(TCam16ManAct tTxSignal) = 0;
	//Cam17ManAct
	virtual tVoid vSendCam17ManAct(TCam17ManAct tTxSignal) = 0;
	//PrivacyResetAck
	virtual tVoid vSendPrivacyResetAck(TPrivacyResetAck tTxSignal) = 0;
	//DispCamCls
	virtual tVoid vSendDispCamCls(TDispCamCls tTxSignal) = 0;
	//PhoneBTLinkStatus
	virtual tVoid vSendPhoneBTLinkStatus(TPhoneBTLinkStatus tTxSignal) = 0;
	//PhoneBookSyncstatus
	virtual tVoid vSendPhoneBookSyncstatus(TPhoneBookSyncStatus tTxSignal) = 0;
	//CallHistorySyncStatus
	virtual tVoid vSendCallHistorySyncStatus(TCallHistorySyncStatus tTxSignal) = 0;
	//PhoneStatusRoaming
	virtual tVoid vSendPhoneStatusRoaming(TPhoneStatusRoaming tTxSignal) = 0;
	//CallDuration
	virtual tVoid vSendCallDuration(TCallDuration tTxSignal) = 0;
	//GSMSignalStrength
	virtual tVoid vSendGSMSignalStrength(TGSMSignalStrength tTxSignal) = 0;
	//PhoneCallStatus
	virtual tVoid vSendPhoneCallStatus(TPhoneCallStatus tTxSignal) = 0;
	//PhoneBatteryLevelStatus
	virtual tVoid vSendPhoneBatteryLevelStatus(TPhoneBatteryLevelStatus tTxSignal) = 0;
	//DeviceStatusWifiAvailable
	virtual tVoid vSendDeviceStatusWifiAvailable(TDeviceStatusWifiAvailable tTxSignal) = 0;
	//MediaStatusAudioSource
	virtual tVoid vSendMediaStatusAudioSource(TMediaStatusAudioSource tTxSignal) = 0;
	//PhoneAvailableStatus
	virtual tVoid vSendPhoneAvailableStatus(TPhoneAvailableStatus tTxSignal) = 0;
	//PhoneVRAvailable
	virtual tVoid vSendPhoneVRAvailable(TPhoneVRAvailable tTxSignal) = 0;
	//DeviceStatusBTStatus
	virtual tVoid vSendDeviceStatusBTStatus(TDeviceStatusBTStatus tTxSignal) = 0;
	//DeviceStatusBluetoothAvail
	virtual tVoid vSendDeviceStatusBluetoothAvail(TDeviceStatusBluetoothAvail tTxSignal) = 0;
	//Req_DeviceInfo
	virtual tVoid vSendReq_DeviceInfo(TReq_DeviceInfo tTxSignal) = 0;
	//MediaStatusVolume
	virtual tVoid vSendMediaStatusVolume(TMediaStatusVolume tTxSignal) = 0;
	//CabinMediaStatusAudioSource
	virtual tVoid vSendCabinMediaStatusAudioSource(TCabinMediaStatusAudioSource tTxSignal) = 0;
	//CabinMediaStatusTunerBand
	virtual tVoid vSendCabinMediaStatusTunerBand(TCabinMediaStatusTunerBand tTxSignal) = 0;
	//CabinMediaStatusVolume
	virtual tVoid vSendCabinMediaStatusVolume(TCabinMediaStatusVolume tTxSignal) = 0;
	//MediaStatusMuteStatus
	virtual tVoid vSendMediaStatusMuteStatus(TMediaStatusMuteStatus tTxSignal) = 0;
	//CabinMediaStatusMuteStatus
	virtual tVoid vSendCabinMediaStatusMuteStatus(TCabinMediaStatusMuteStatus tTxSignal) = 0;
	//MediaStatusPlayStatus
	virtual tVoid vSendMediaStatusPlayStatus(TMediaStatusPlayStatus tTxSignal) = 0;
	//MediaStatusMixState
	virtual tVoid vSendMediaStatusMixState(TMediaStatusMixState tTxSignal) = 0;
	//MediaStatusPlaylistMode
	virtual tVoid vSendMediaStatusPlaylistMode(TMediaStatusPlaylistMode tTxSignal) = 0;
	//MediaStatusTrackTime
	virtual tVoid vSendMediaStatusTrackTime(TMediaStatusTrackTime tTxSignal) = 0;
	//MediaStatusCurrTrackNum
	virtual tVoid vSendMediaStatusCurrTrackNum(TMediaStatusCurrTrackNum tTxSignal) = 0;
	//DeviceStatusRadioStatus
	virtual tVoid vSendDeviceStatusRadioStatus(TDeviceStatusRadioStatus tTxSignal) = 0;
	//DeviceStatusDABAvailStatus
	virtual tVoid vSendDeviceStatusDABAvailStatus(TDeviceStatusDABAvailStatus tTxSignal) = 0;
	//DeviceStatusNavData
	virtual tVoid vSendDeviceStatusNavData(TDeviceStatusNavData tTxSignal) = 0;
	//DeviceStatusUSB1Present
	virtual tVoid vSendDeviceStatusUSB1Present(TDeviceStatusUSB1Present tTxSignal) = 0;
	//DeviceStatusUSB2Present
	virtual tVoid vSendDeviceStatusUSB2Present(TDeviceStatusUSB2Present tTxSignal) = 0;
	//DeviceStatusNaviAvail
	virtual tVoid vSendDeviceStatusNaviAvail(TDeviceStatusNaviAvail tTxSignal) = 0;
	//DeviceStatusUSB1Src
	virtual tVoid vSendDeviceStatusUSB1Src(TDeviceStatusUSB1Src tTxSignal) = 0;
	//DeviceStatusUSB2Src
	virtual tVoid vSendDeviceStatusUSB2Src(TDeviceStatusUSB2Src tTxSignal) = 0;
	//DeviceStatusAMFMAvail
	virtual tVoid vSendDeviceStatusAMFMAvail(TDeviceStatusAMFMAvail tTxSignal) = 0;
	//MediaStatusSeekStatus
	virtual tVoid vSendMediaStatusSeekStatus(TMediaStatusSeekStatus tTxSignal) = 0;
	virtual tVoid onEveryFiveSeconds() = 0;
	//SendMediaInfo
	virtual tVoid vSendMediaInfoToCluster(TMediaInfo tTxSignal) = 0;
	virtual tVoid vSendCallInfoToCluster(TMediaInfo tTxSignal) = 0;
	virtual tVoid vSendPhoneInfoToCluster(TMediaInfo tTxSignal) = 0;
	virtual tVoid vSendTurnToStreetInfoToCluster(TStreetInfo tTxSignal) = 0;
	virtual tVoid vSendCurrentStreetInfoToCluster(TStreetInfo tTxSignal) = 0;
	virtual tVoid vSendDestinationInfoToCluster(TNaviInfo tTxSignal) = 0;
	virtual tVoid vSendTurnToSymbolsInfoToCluster(TNaviInfo tTxSignal) = 0;
	virtual tVoid vSendNaviLaneGuidanceInfoToCluster(TNaviInfo tTxSignal) = 0;
	virtual tVoid vSendNaviWarningInfoToCluster(TNaviInfo tTxSignal) = 0;
	//MediaStatusRepeatStatus
	virtual tVoid vSendMediaStatusRepeatStatus(TMediaStatusRepeatStatus tTxSignal) = 0;
	//MediaStatusDABFMStatus
	virtual tVoid vSendMediaStatusDABFMStatus(TMediaStatusDABFMStatus tTxSignal) = 0;
	//VehicleNaviLatitude
	virtual tVoid vSendVehicleNaviLatitude(TVehicleNaviLatitude tTxSignal) = 0;
	//VehicleNaviLongitude
	virtual tVoid vSendVehicleNaviLongitude(TVehicleNaviLongitude tTxSignal) = 0;
	//MediaStatusTREGStatus
	virtual tVoid vSendMediaStatusTREGStatus(TMediaStatusTREGStatus tTxSignal) = 0;
	//MediaStatusTREGRTMStatus
	virtual tVoid vSendMediaStatusTREGRTMStatus(TMediaStatusTREGRTMStatus tTxSignal) = 0;
	//MediaStatusRDSStatus
	virtual tVoid vSendMediaStatusRDSStatus(TMediaStatusRDSStatus tTxSignal) = 0;
	//MediaStatusTAStatus
	virtual tVoid vSendMediaStatusTAStatus(TMediaStatusTAStatus tTxSignal) = 0;
	//MediaStatusTPStatus
	virtual tVoid vSendMediaStatusTPStatus(TMediaStatusTPStatus tTxSignal) = 0;
	//MediaStatusTunerBandStatus
	virtual tVoid vSendMediaStatusTunerBandStatus(TMediaStatusTunerBandStatus tTxSignal) = 0;
	//MediaStatusTunerPresetStatus
	virtual tVoid vSendMediaStatusTunerPresetStatus(TMediaStatusTunerPresetStatus tTxSignal) = 0;
	//HUS_DM1_Status
	virtual tVoid vSendHUS_DM1_Status(THUS_DM1_Status tTxSignal) = 0;

	
	virtual tVoid vSendVoice_Recognition_Executing(TVoice_Recognition_Executing tTxSignal) = 0;
    virtual tVoid vSendBlowerReductionRequest(TBlowerReductionRequest tTxSignal) = 0;
    virtual tVoid vSendTSR_OSPActivationRequest2(TTSR_OSPActivationRequest2 tTxSignal) = 0;
    virtual tVoid vSendMeterLanguageSyncMenu(TMeterLanguageSyncMenu tTxSignal) = 0;
    virtual tVoid vSendCockpitLanguageRequest(TCockpitLanguageRequest tTxSignal) = 0;
    virtual tVoid vSendUnitDistanceDisplayRequest(TUnitDistanceDisplayRequest tTxSignal) = 0;
    virtual tVoid vSendSetting_Change_Request_for_TPMS(TSetting_Change_Request_for_TPMS tTxSignal) = 0;
    // I_veda_tclClientVcanCanAdaptor::ClassImplementation: user specific code start
    virtual tBool _bCheckCommunicationState_RX(const tU8 u8Bus, const tU8 u8Node, tU8& u8FaultState) const = 0;
    virtual tBool _bCheckCommunicationState_TX(const tU8 u8Bus, const tU8 u8Node, tU8& u8FaultState) const = 0;
    virtual tBool _bCheckCommunicationState_BusOff(const tU8 u8Bus, tU8& u8FaultState) const = 0;

    virtual tBool _bRegisterForBusOffErrorIndication(const tU8 u8Bus, tBool& bInitializationError) const = 0;
    virtual tBool _bRegisterForRxBusErrorIndication(const tU8 u8Bus, const tU8 u8Node) const = 0;
    virtual tBool _bRegisterForTxBusErrorIndication(const tU8 u8Bus, const tU8 u8Node) const = 0;

   // virtual tVoid vReinitCsmNetworkManagement(tVoid) const = 0;
    virtual tVoid _vSendKDSCodingChangedInfoToCSM(tVoid) const = 0;
    virtual tVoid vSendMeidaDataToCluster(vehicle_fi_tcl_CAN_Mesg msg) = 0;
    virtual tVoid vSendCallDataToCluster(vehicle_fi_tcl_CAN_Mesg msg) = 0;
    virtual tVoid vSendPhoneDataToCluster(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	virtual tVoid vSendCabinAMeidaDataToCluster(vehicle_fi_tcl_CAN_Mesg msg) = 0;
    // I_veda_tclClientVcanEvobusb2eCanAdaptor::ClassImplementation: user specific code end
};


#endif // _I_VCANEVOBUSB2ECANADAPTOR_H_
