#ifndef I_VEDA_CLIENTPROFILE_H
#define I_VEDA_CLIENTPROFILE_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Iveda_ClientProfile.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: vehicledata
  * @Template:     IFrancaProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Franca client interface
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include "bosch/cm/profileProxy.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "veda_AppMain.h"

// Iveda_ClientProfileInclude: user specific code start
// Iveda_ClientProfileInclude: user specific code end

using namespace::asf::core;
using namespace::asf::stream;
using namespace::bosch::cm::profile;

class Iveda_tclClientProfile : public veda_tclBaseIf
{
public:
    Iveda_tclClientProfile(veda_tclAppMain* poMain) : veda_tclBaseIf(poMain){;}
    virtual ~Iveda_tclClientProfile(){}

    virtual const tChar* getIfName() const { return( "Iveda_tclClientProfile"); };

    virtual tVoid sendActiveProfileGetValue(tVoid) = 0;
    virtual tVoid sendStatusGetValue(tVoid) = 0;
    virtual tVoid sendCopyProfileGetValue(tVoid) = 0;
    virtual tVoid sendDeleteProfileGetValue(tVoid) = 0;
    virtual tVoid sendDataChangedGetValue(tVoid) = 0;


// Iveda_ClientProfileDeclarationsPart: user specific code start
// Iveda_ClientProfileDeclarationsPart: user specific code end

};


#endif // I_VEDA_CLIENTPROFILE_H

