/*****************************************************************************
* FILE:         veda_ClientVcan.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vehicledata
* Template:     CsmClient.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "veda_ClientVcan.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_CLIENT_VCAN
#include "trcGenProj/Header/veda_ClientVcan.cpp.trc.h"
#endif

// veda_tclClientVcan::ClassIncludes: user specific code start
#define CANGEN_NISSAN_GEN3 0x06
#define CANGEN_NISSAN_GEN5 0x05
#define CANGEN_C1A 0x01
#define ALLIANCE_MESSAGESET_NISSAN	0x00
#define ALLIANCE_MESSAGESET_RENAULT	0x01

#define COCKPIT_LANGUAGE_RESET_REQUEST       0xFF

#include "I_veda_appl_handler.h"
#include "I_veda_ServiceVehicleIf.h"
#include "Iveda_ClientDiaglog.h"
#include "veda_config.h"
#include "I_veda_language_handler.h"
//Added by Shrisha
#include "LanguageList.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_vd_vehicle_data_if.h"
// veda_tclClientVcan::ClassIncludes: user specific code end

veda_tclClientVcan::veda_tclClientVcan(veda_tclAppMain* poMainAppl):
I_veda_tclClientVcan(poMainAppl),
_pCsmBase(NULL)
{
   ETG_TRACE_USR4(("veda_tclClientVcan::veda_tclClientVcan() entered."));
   // veda_tclClientVcan::veda_tclClientVcan: user specific code start
     cmsMediaflag = false;
    stmediamsg.u8txtype = 0XFF;

   _u32AccumulatedMileage = 0;
   u32ConfigMask = 0x00;
   u8VCANDiversity = 0xFF;
   u8CANActivationC1A = 0xFF;
   _bVCANInitializationError = TRUE;
   _bMCANInitializationError = TRUE;
   _bHWIgnition = FALSE;
   _bNodeFaultCallbackRegistered = FALSE;

   _u16CANSpeed = 0xFFFF;
   _u32CANSpeedStatus = CSM_C_SIGNAL_DATA_INVALID;
   //TCOVehiclespeed
   _u16CANTCOSpeed = 0xFFFF;
   _u32CANTCOSpeedStatus = CSM_C_SIGNAL_DATA_INVALID;
   _u8Value_MeterLangStatus = 0x00;
   _u32Status_MeterLangStatus = CSM_C_SIGNAL_DATA_INVALID;
   _u8PartialMuteValue=0xFF;
   _u32CANPartialMuteStatus = CSM_C_SIGNAL_DATA_INVALID;
   _u8SwivMonAutoOpenValue=0xFF;
   _u32CANSwivMonAutoOpenStatus = CSM_C_SIGNAL_DATA_INVALID;
   _u8DateModeValue=0xFF;
   _u32CANDateModeStatus = CSM_C_SIGNAL_DATA_INVALID;
   _u8TmModeValue=0xFF;
   _u32CANTmModeStatus = CSM_C_SIGNAL_DATA_INVALID;
   //camera
   _u8ActCam1Value=0x03;
   _u32CANActCam1Status = CSM_C_SIGNAL_DATA_INVALID;
   //camera2
   _u8ActCam2Value=0x03;
   _u32CANActCam2Status = CSM_C_SIGNAL_DATA_INVALID;
   //camera3
   _u8ActCam3Value=0x03;
   _u32CANActCam3Status = CSM_C_SIGNAL_DATA_INVALID;
   //camera4
   _u8ActCam4Value=0x03;
   _u32CANActCam4Status = CSM_C_SIGNAL_DATA_INVALID;
   //camera5
   _u8ActCam5Value=0x03;
   _u32CANActCam5Status = CSM_C_SIGNAL_DATA_INVALID;
   //camera6
   _u8ActCam6Value=0x03;
   _u32CANActCam6Status = CSM_C_SIGNAL_DATA_INVALID;
   //camera7
   _u8ActCam7Value=0x03;
   _u32CANActCam7Status = CSM_C_SIGNAL_DATA_INVALID;
   //camsplit
   _u16CamSplitQuadValue=0xFFFF;
   _u32CANCamSplitQuadStatus = CSM_C_SIGNAL_DATA_INVALID;
   //Mutedev
   _u8MuteDevStatusValue = 0x03;
   _u32CANMuteDevStatus = CSM_C_SIGNAL_DATA_INVALID;
   //SysVolt
   _u8SysVoltStatusValue = 0x03;
   _u32CANSysVoltStatus = CSM_C_SIGNAL_DATA_INVALID;
   //ParkingbreakSwitch
   _u8ParkingBreakSwitchValue = 0xFF;
   _u32CANParkingBreakSwitchStatus = CSM_C_SIGNAL_DATA_INVALID;
   //RearCamReq
   _u8RearCamReqValue = 0x03;
   _u32CANRearCamReqStatus = CSM_C_SIGNAL_DATA_INVALID;
   //VIN
    _u32VINValue=0xFFFFFFFF;
   _u32CANVINStatus = CSM_C_SIGNAL_DATA_INVALID;
      //Time Date
    _u64TimeDateValue=0xFFFFFFFFFFFFFFFF;
     _u32CANTimeDateStatus = CSM_C_SIGNAL_DATA_INVALID ;
	 //phone Call Command 
	 _u8PhoneCallCommandValue=0xFF;
	 _u32PhoneCallCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	 	 //Volume Command 
	 _u8VolumeCommandValue=0xFF;
	 _u32VolumeCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	 // ActCam8 
	 _u8ActCam8Value=0xFF;
	 _u32ActCam8Status=CSM_C_SIGNAL_DATA_INVALID;
	// ActCam9 
	 _u8ActCam9Value=0xFF;
	 _u32ActCam9Status=CSM_C_SIGNAL_DATA_INVALID;
	// ActCam10
	 _u8ActCam10Value=0xFF;
	 _u32ActCam10Status=CSM_C_SIGNAL_DATA_INVALID;
	 // ActCam11
	 _u8ActCam11Value=0xFF;
	 _u32ActCam11Status=CSM_C_SIGNAL_DATA_INVALID;
	 // ActCam12
	 _u8ActCam12Value=0xFF;
	 _u32ActCam12Status=CSM_C_SIGNAL_DATA_INVALID;
	// ActCam13
	 _u8ActCam13Value=0xFF;
	 _u32ActCam13Status=CSM_C_SIGNAL_DATA_INVALID;
	 	// ActCam14
	 _u8ActCam14Value=0xFF;
	 _u32ActCam14Status=CSM_C_SIGNAL_DATA_INVALID;
	 // ActCam15
	 _u8ActCam15Value=0xFF;
	 _u32ActCam15Status=CSM_C_SIGNAL_DATA_INVALID;
	 // ActCam16
	 _u8ActCam16Value=0xFF;
	 _u32ActCam16Status=CSM_C_SIGNAL_DATA_INVALID;
	 // ActCam17
	 _u8ActCam17Value=0xFF;
	 _u32ActCam17Status=CSM_C_SIGNAL_DATA_INVALID;	 
	 //Source Command 
	 _u8SourceCommandValue=0xFF;
	 _u32SourceCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	 //CabinSource Command 
	 _u8CabinSourceCommandValue=0xFF;
	 _u32CabinSourceCommandStatus=CSM_C_SIGNAL_DATA_INVALID;	
	 //CabinVolume Command 
	 _u8CabinVolumeCommandValue=0xFF;
	 _u32CabinVolumeCommandStatus=CSM_C_SIGNAL_DATA_INVALID; 
	 //CabinTuner Command 
	 _u8CabinTunerCommandValue=0xFF;
	 _u32CabinTunerCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	 //CabinTrackCommand 
	 _u8CabinTrackCommandValue=0xFF;
	 _u32CabinTrackCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	 //CabinPlaylistCommand 
	 _u8CabinPlaylistCommandValue=0xFF;
	 _u32CabinPlaylistCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	  //Track Command 
	 _u8TrackCommandValue=0xFF;
	 _u32TrackCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	 //SMARTVR Command 
	 _u8SMARTVRValue=0xFF;
	 _u32SMARTVRStatus=CSM_C_SIGNAL_DATA_INVALID;
	 //Tuner Command 
	 _u8TunerCommandValue=0xFF;
	 _u32TunerCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	  //TA Command 
	 _u8TACommandValue=0xFF;
	 _u32TACommandStatus=CSM_C_SIGNAL_DATA_INVALID;
  	  //RDS Command 
	 _u8RDSCommandValue=0xFF;
	 _u32RDSCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	 // RC Next Btn 
	 _u8RCNextBtnValue=0xFF;
	 _u32RCNextBtnStatus=CSM_C_SIGNAL_DATA_INVALID;
	 // RC Prev Btn 
	 _u8RCPrevBtnValue=0xFF;
	 _u32RCPrevBtnStatus=CSM_C_SIGNAL_DATA_INVALID;
	 	//Device Info SW version 
    _u32SWversionValue=0xFFFFFFFF;
     _u32DeviceInfoSWversionStatus=CSM_C_SIGNAL_DATA_INVALID;	 	
	 //TotalVehDistDiag
    _u32TotalVehDistDiagValue=0xFFFFFFFF;
     _u32TotalVehDistDiagStatus=CSM_C_SIGNAL_DATA_INVALID;
   //Voice Recgn
     _u8VoiceRecgCommandValue=0xFF;
     _u32VoiceRecgnCommandStatus=CSM_C_SIGNAL_DATA_INVALID;
	    //phone pwr cmd 
     _u8PhonePwrCmdValue=0xFF;
     _u32PhonePwrCmdStatus=CSM_C_SIGNAL_DATA_INVALID;
	 
	//Radio pwr cmd 
     _u8RadioPwrCmdValue=0xFF;
     _u32RadioPwrCmdStatus=CSM_C_SIGNAL_DATA_INVALID;
   
	 
   //System Language
   _u16SystemLanguageValue = 0xFFFF;
   _u32CANSystemLanguageStatus = CSM_C_SIGNAL_DATA_INVALID;
   //CurrLang
   _u16CurrLangValue = 0xFFFF;
   _u32CANCurrLangStatus = CSM_C_SIGNAL_DATA_INVALID;
   //CamTxt
   _u64CamTxtValue=0xFFFFFFFFFFFFFFFF;
   _u32CANCamTxtStatus = CSM_C_SIGNAL_DATA_INVALID; 
   //VIN_64
   _u64VIN_64Value=0xFFFFFFFFFFFFFFFF;
   _u32VIN_64Status = CSM_C_SIGNAL_DATA_INVALID;
   //PrivacyResetReq
    _u8PrivacyResetReqValue=0xFF;
   _u32CANPrivacyResetReqStatus = CSM_C_SIGNAL_DATA_INVALID;
   
   _poApplHdl = NULL;
   _poCCAServiceHdl = NULL;
   _poDiaglogHdl = NULL;
   
   _u8MinSpeed = 0xFF;
   _u8MaxSpeed = 0x00;
   _u8SpeedLockValue = 0x00;
   _u8DriveState = 0xFF;
   _u8counter = 0x00;
   
   _u8TwoSecondTimerCount = 0;
   _bTPMSRequestFlag = FALSE;
   
   _u8AbsentMCANECU.clear();
   _u8AbsentVCANECU.clear();

   // initialize 255 ECU's by default as Unknown
   for (tU8 i = 0; i < 255; i++)
   {
      _u8AbsentVCANECU.push_back(BUS_FAULT_UNKNOWN);
      _u8AbsentMCANECU.push_back(BUS_FAULT_UNKNOWN);
   }

   // allocate memory for keeping track of all CAN Node's current status
   _pu8CANNodeFaultState = new tU8[VEDA_DIAG_LAST];

   VEDA_NULL_POINTER_CHECK(_pu8CANNodeFaultState);

   // initialize all the current CAN Node status as Unknown
   memset(_pu8CANNodeFaultState, 0xFF, (VEDA_DIAG_LAST-1));

   // ITM Node (Our ECU) is hard-coded as  working fine
   _pu8CANNodeFaultState[VEDA_DIAG_ECU_ITM_______] = BUS_FAULT_INACTIVE;

   // initialize the data for sending it to the Diagnosis
   for (tU8 i = 0; i < VEDA_DIAG_LAST; i++)
   {
      if ( tConfig[i].u8Bus == VCAN )
      {
         _u8AbsentVCANECU[tConfig[i].u8FaultIndex] = _pu8CANNodeFaultState[i];
      }
      else if ( tConfig[i].u8Bus == MCAN )
      {
         _u8AbsentMCANECU[tConfig[i].u8FaultIndex] = _pu8CANNodeFaultState[i];
      }
   }

   _bDiagMuxState = FALSE;
   u8GADEState = 0x00; 
   _u8driverdoorstatus = 0;
   _u32Driverdoorstatus = 0;
   //Sleep or Crank fault, Disable
   // veda_tclClientVcan::veda_tclClientVcan: user specific code end
   return;
}

veda_tclClientVcan::~veda_tclClientVcan()
{
   ETG_TRACE_USR4(("veda_tclClientVcan::~veda_tclClientVcan() entered."));
   _pCsmBase = OSAL_NULL;
   // veda_tclClientVcan::~veda_tclClientVcan: user specific code start
   _poApplHdl = NULL;
   _poCCAServiceHdl = NULL;
   _poDiaglogHdl = NULL;

   _u8AbsentMCANECU.clear();
   _u8AbsentVCANECU.clear();

   if ( _pu8CANNodeFaultState )
   {
      delete [] _pu8CANNodeFaultState;
      _pu8CANNodeFaultState = NULL;
   }
   // veda_tclClientVcan::~veda_tclClientVcan: user specific code end
   return;
}

tVoid veda_tclClientVcan::vHandleMessage(veda_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(veda_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   // veda_tclClientVcan::vHandleMessage: user specific code start
   switch(pMsg->eCmd)
   {
   case eOneSecondTimeoutEvent:
      {
         // Poll the Speed data every second
        _vReadVehicleSpeed();
		_vReadTCOVehicleSpeed();
         // Poll for Distance Total
         vGetDistanceTotalizer();
         vGetDistanceUnit();
		 
		 if (_bTPMSRequestFlag)
			_u8TwoSecondTimerCount++;

		 _u8counter++;
		 if(_u8counter%5 == 0)
		 {
                    if (_pCsmBase)
		    {
		       _pCsmBase->onEveryFiveSeconds();
		    }
		 }
      }
      break;

   case eDefaultSetting:
      {
         vHandleKDSConfigRead();
         tChar className[] = "veda_tclClientVcan";
         _cpoMain->theServer()->vPostMsgReadCsmBusStates(className, 0);

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
         vSendUnitDistanceDisplayRequestUpdate(UNIT_DISTANCE_RESET_REQUEST);
         vSendCockpitLanguageUpdate(COCKPIT_LANGUAGE_RESET_REQUEST);
#endif
      }
      break;

   case eReadCsmBusStates:
      {
         tBool bForceUpdate = FALSE;
         if ( 1 == pMsg->u.u32Data )
            bForceUpdate = TRUE;

         if ( _bNodeFaultCallbackRegistered == TRUE )
            vReadAllNodeFaultStates(bForceUpdate);
      }
      break;

   case eIgnitionStateChanged:
      {
         if ( _bHWIgnition != (tBool) pMsg->u.u32Data )
         {
            _bHWIgnition = (tBool) pMsg->u.u32Data;

            if ( _bHWIgnition ) // Ignition ON
            {
               VEDA_NULL_POINTER_CHECK(_pCsmBase);
               VEDA_NULL_POINTER_CHECK(_cpoMain->theServer());

               // re init network management
              // _pCsmBase->vReinitCsmNetworkManagement();
            }

            tChar className[] = "veda_tclClientVcan";
            _cpoMain->theServer()->vPostMsgReadCsmBusStates(className, 0);
         }
      }
      break;

   case eCmdCsmBusIndReceived:
      vHandleCsmFaultIndication(pMsg->u.au8Data[0], pMsg->u.au8Data[1], pMsg->u.au8Data[2]);
      break;
	  
   case eTirePressureSet:
	  vSendTire_Pressure_Set(pMsg->u.u8Data);
	  break;
	  
   default:
      break;
   }
   // veda_tclClientVcan::vHandleMessage: user specific code end
}
//Added by Shrisha
tU8 veda_tclClientVcan::_u8ReadConfiguredRegion(tVoid) const
{
   // Read the KDS Region
   tU8 u8Region = 0xFF;

   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "DestinationRegion1", &u8Region, 1) )
   {
      ETG_TRACE_USR1(("_u8ReadConfiguredRegion(): KDS Region is 0x%02x.", u8Region));
   }
   else
   {
      // Set the Default region as USA
      u8Region = USA;
      ETG_TRACE_ERR(("_u8ReadConfiguredRegion(): KDS Region Read Failed. Setting region as USA"));
   }

   return u8Region;
}
tVoid veda_tclClientVcan::vHandleTraceMessage(const tUChar* puchData)
{
   VEDA_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // veda_tclClientVcan::vHandleTraceMessage: user specific code start
   switch(u32MsgCode)
   {
   case VEHICLEDATA_VEDA_HANDBRAKE_INPUT:
      {
         // Input the Hand Brake CSM Data input
         tU8 u8HandBrakeState = puchData[3];

         vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus oHandBrake;
         oHandBrake.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::tenType>(u8HandBrakeState);

         ETG_TRACE_USR4(("vUpdateHandBrakeState() Current Hand Brake State is %d", \
            ETG_ENUM(VEDA_E8_VEHICLE_HANDBRAKESTATUS, oHandBrake.enType)));

         VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
         _poCCAServiceHdl->sendHandBrakeStatus(oHandBrake);
      }
      break;

   case VEHICLEDATA_VEDA_IGNITION_INPUT:
      {
         // Input the Ignition CSM/HW Data input
         tU8 param1 = puchData[3];

         vehicle_fi_tcl_e8_Vehicle_Ignition oIgnition;
         oIgnition.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_Ignition::tenType>(param1);

         VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
         _poCCAServiceHdl->sendIgnitionStatus(oIgnition);
      }
      break;

   case VEHICLEDATA_VEDA_SPEED_INPUT:
      {
         // Input the Speed CSM Data input
         tU16 u16Speed = ((tU16)puchData[3] <<  8) | (tU16)puchData[4];

         ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current Speed %d.%02d km/hr", \
            u16Speed/100, u16Speed%100));

         VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
         _poCCAServiceHdl->sendSpeedStatus(u16Speed);
      }
      break;
   case VEHICLEDATA_VEDA_PARTIALMUTE_INPUT:
   {
	   // Input the Mute CSM Data input
	   tU8 u8PartialMute = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current volume %d", \
             u8PartialMute));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendPartialMuteStatus(u8PartialMute);
   }
    break;
	
   case VEHICLEDATA_VEDA_SWIVMONAUTOOPEN_INPUT:
   {
	   // Input the SwivMonAutoOpen CSM Data input
	   tU8 u8SwivMonAutoOpen = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current volume %d", \
             u8SwivMonAutoOpen));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendSwivMonAutoOpenStatus(u8SwivMonAutoOpen);
   }
    break;
	
   case VEHICLEDATA_VEDA_DATEMODE_INPUT:
   {
	   // Input the Date mode CSM Data input
	   tU8 u8DateMode = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current volume %d", \
             u8DateMode));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendDateModeStatus(u8DateMode);
   }
    break;
	
   case VEHICLEDATA_VEDA_TMMODE_INPUT:
   {
	   // Input the Time mode CSM Data input
	   tU8 u8TmMode = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current volume %d", \
             u8TmMode));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendTmModeStatus(u8TmMode);
   }
    break;
	
	//camera
	 case VEHICLEDATA_VEDA_ACTCAM1_INPUT:
   {
	   // Input the Activate camera1 CSM Data input
	   tU8 u8ActCam1 = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current camera1 status %d", \
             u8ActCam1));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendActCam1Status(u8ActCam1);
   }
    break;
	//camera2
	 case VEHICLEDATA_VEDA_ACTCAM2_INPUT:
   {
	   // Input the Activate camera2 CSM Data input
	   tU8 u8ActCam2 = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current camera2 status %d", \
             u8ActCam2));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendActCam2Status(u8ActCam2);
   }
    break;
	//camera3
	 case VEHICLEDATA_VEDA_ACTCAM3_INPUT:
   {
	   // Input the Activate camera3 CSM Data input
	   tU8 u8ActCam3 = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current camera3 status %d", \
             u8ActCam3));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendActCam3Status(u8ActCam3);
   }
    break;
	//camera4
	 case VEHICLEDATA_VEDA_ACTCAM4_INPUT:
   {
	   // Input the Activate camera4 CSM Data input
	   tU8 u8ActCam4 = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current camera4 status %d", \
             u8ActCam4));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendActCam4Status(u8ActCam4);
   }
    break;
	//camera5
	 case VEHICLEDATA_VEDA_ACTCAM5_INPUT:
   {
	   // Input the Activate camera5 CSM Data input
	   tU8 u8ActCam5 = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current camera5 status %d", \
             u8ActCam5));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendActCam5Status(u8ActCam5);
   }
    break;
	//camera6
	 case VEHICLEDATA_VEDA_ACTCAM6_INPUT:
   {
	   // Input the Activate camera6 CSM Data input
	   tU8 u8ActCam6 = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current camera6 status %d", \
             u8ActCam6));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendActCam6Status(u8ActCam6);
   }
    break;
	//camera7
	 case VEHICLEDATA_VEDA_ACTCAM7_INPUT:
   {
	   // Input the Activate camera7 CSM Data input
	   tU8 u8ActCam7 = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current camera7 status %d", \
             u8ActCam7));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendActCam7Status(u8ActCam7);
   }
    break;
	//camsplit
	 case VEHICLEDATA_VEDA_CAMSPLITQUAD_INPUT:
   {
	   // Input the Activate camsplit CSM Data input
	   tU8 u16CamSplitQuad = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current camsplit status %d", \
             u16CamSplitQuad));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendCamSplitQuadStatus(u16CamSplitQuad);
   }
    break;
	//MuteDev
	case VEHICLEDATA_VEDA_MUTEDEVSTATUS_INPUT:
   {
	   // Input the MuteDev CSM Data input
	   tU8 u8MuteDevStatus = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current volume %d", \
             u8MuteDevStatus));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendMuteDevStatus(u8MuteDevStatus);
   }
   break;
	//SysVolt
	 case VEHICLEDATA_VEDA_SYSVOLTSTATUS_INPUT:
   {
	   // Input the SysVolt CSM Data input
	   tU8 u8SysVoltStatus = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current sysVolt status %d", \
             u8SysVoltStatus));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendSysVoltStatus(u8SysVoltStatus);
   }
    break;
   //ParkingbreakSwitch
	 case VEHICLEDATA_VEDA_PARKINGBREAKSWITCH_INPUT:
   {
	   // Input the Parking break switch CSM Data input
	   tU8 u8ParkingBreakSwitch = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current parking break switch value %d", \
             u8ParkingBreakSwitch));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendParkingBreakSwitchStatus(u8ParkingBreakSwitch);
   }
    break;
	//RearCamReq
	 case VEHICLEDATA_VEDA_REARCAMREQ_INPUT:
   {
	   // Input the RearCamReq CSM Data input
	   tU8 u8RearCamReq = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current RearCamReq value %d", \
             u8RearCamReq));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendRearCamReqStatus(u8RearCamReq);
   }
    break;
	
	//VIN
   case VEHICLEDATA_VEDA_VIN_INPUT:
   {
	   // Input the VIN CSM Data input
	   tU32 u32VIN = ((tU32)puchData[3] <<  8) | (tU32)puchData[4] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): VIN %d", \
             u32VIN));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendVINStatus(u32VIN);
   }
    break;
   //CamTxt
	 case VEHICLEDATA_VEDA_CAMTXT_INPUT:
   {
	   // Input the CamTxt CSM Data input
	   tU64 u64CamTxt = ((tU64)puchData[3] << 8) | (tU64)puchData[4] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current CamTxt status %d", \
             u64CamTxt));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendCamTxtStatus(u64CamTxt);
   }
    break;
	//Cam1ManAct
	case VEHICLEDATA_VEDA_CAM1MANACT_INPUT:
	{
		tU8 u8Cam1ManAct = puchData[3] ;
	   
	   ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Current Cam1ManAct value %d", \
             u8Cam1ManAct));
	   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->onCam1ManActMStart(u8Cam1ManAct);
	}
	break;

   
   case VEHICLEDATA_VEDA_TRIGGER_CANMETERLANGSTATUS:
   {
      tU8 u8Lang = puchData[3];

      ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Meter Language Status %u", u8Lang));

      veda_tclBaseIf::TMsg pMsg;
      (tVoid)memset((tVoid*)&pMsg, OSAL_NULL, sizeof(pMsg));
      pMsg.eCmd = veda_tclBaseIf::eSetLanguage;
      strncpy(pMsg.strClassName, "veda_tclLanguageHandler", sizeof("veda_tclLanguageHandler"));
      pMsg.u.au8Data[0] = static_cast<tU8>(METER);
      pMsg.u.au8Data[1] = u8Lang;
      
      _cpoMain->theServer()->vPostInternalMessage(&pMsg);
   }
   break;
   
   case VEHICLEDATA_VEDA_TRIGGER_CANMETERLANGKNOWLEDGE:
   {
      tU8 u8LangKnowledge = puchData[3];

      ETG_TRACE_USR4(("veda_tclClientVcan::vHandleTraceMessage(): Meter Language Knowledge %u", u8LangKnowledge));
      
      vehicle_fi_tcl_e8_Meter_LangKnowledge oLangKnowledge;   
      oLangKnowledge.enType = static_cast<vehicle_fi_tcl_e8_Meter_LangKnowledge::tenType>(u8LangKnowledge);
      
      VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendMeterLanguageKnowledgeStatus(oLangKnowledge);
   }
   break;

   default:
      // nothing to do
      break;
   }
   // veda_tclClientVcan::vHandleTraceMessage: user specific code end
}

tVoid veda_tclClientVcan::vGetReferences() {

   _pCsmBase = dynamic_cast<I_veda_tclClientVcanCanAdaptor*>(_cpoMain->getHandler("I_veda_tclClientVcanCanAdaptor"));
   VEDA_NULL_POINTER_CHECK(_pCsmBase);
   _pCsmBase->vSetCallbackIf(this);

   // veda_tclClientVcan::vGetReferences: user specific code start
   _poApplHdl = dynamic_cast<Iveda_tclApplHandler*>(_cpoMain->theServer()->getHandler("Iveda_tclApplHandler"));
   VEDA_NULL_POINTER_CHECK(_poApplHdl);

   _poCCAServiceHdl = dynamic_cast<Iveda_tclServiceVehicleIf*>(_cpoMain->theServer()->getHandler("Iveda_tclServiceVehicleIf"));
   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);

   _poDiaglogHdl = dynamic_cast<Iveda_tclClientDiaglog*>(_cpoMain->getHandler("Iveda_tclClientDiaglog"));
   VEDA_NULL_POINTER_CHECK(_poDiaglogHdl);
   // veda_tclClientVcan::vGetReferences: user specific code end
}


tVoid veda_tclClientVcan::vTraceInfo()
{
   ETG_TRACE_USR4(("veda_tclClientVcan::vTraceInfo() entered."));
}


tVoid veda_tclClientVcan::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("veda_tclClientVcan::vStartCommunication() entered."));
   if (_pCsmBase) _pCsmBase->vConnect();

   // veda_tclClientVcan::vStartCommunication: user specific code start
	if (_pCsmBase) _pCsmBase->_vSendKDSCodingChangedInfoToCSM();
   //vHandleKDSConfigRead();
   vHandleAllNodeFaultRegistration();
   vReadAllNodeFaultStates(FALSE);
   // Load and Check Speed Limits (SpeedLock)
   if (u32ConfigMask & VD_FEATURE_SPEED_LOCK)
   {
	   vLoadCheckSpeedLimit();
   }
      
   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
   _poCCAServiceHdl->sendSpeedStatus((tU16)_u16CANSpeed);
   // veda_tclClientVcan::vStartCommunication: user specific code end
}

void veda_tclClientVcan::onSpeed_Limit_Display_RequestStatus(TSpeed_Limit_Display_Request tSpeed_Limit_Display_Request) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onSpeed_Limit_Display_RequestStatus(): status: %08x, data: %d.", tSpeed_Limit_Display_Request.u32Status , tSpeed_Limit_Display_Request.Speed_Limit_Display_Request));
   // veda_tclClientVcan::onSpeed_Limit_Display_RequestStatus: user specific code start
    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    tU8 u8DisplaySpeedLimit = 0x00; // Speed limit shall not be used

    if ( u32ConfigMask & VD_FEATURE_ISA_AVAILABLE ) {
       if ( bIsSignalValid(tSpeed_Limit_Display_Request.u32Status) ) {
          u8DisplaySpeedLimit = tSpeed_Limit_Display_Request.Speed_Limit_Display_Request;
       }
    }

    ETG_TRACE_USR4(("veda_tclClientVcan::onSpeed_Limit_Display_RequestStatus() received as %u", u8DisplaySpeedLimit));

    _poCCAServiceHdl->vUpdateSpeedLimitDisplay(u8DisplaySpeedLimit);
   // veda_tclClientVcan::onSpeed_Limit_Display_RequestStatus: user specific code end
}

void veda_tclClientVcan::onNavi_display_speed_limit_1Status(TNavi_display_speed_limit_1 tNavi_display_speed_limit_1) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onNavi_display_speed_limit_1Status(): status: %08x, data: %d.", tNavi_display_speed_limit_1.u32Status , tNavi_display_speed_limit_1.Navi_display_speed_limit_1));
   // veda_tclClientVcan::onNavi_display_speed_limit_1Status: user specific code start
    tU8 u8SpeedLimit1 = 0x00; // Invalid Speed Limit Value - ignored by the clients

    if ( u32ConfigMask & VD_FEATURE_ISA_AVAILABLE ) {
       if ( bIsSignalValid(tNavi_display_speed_limit_1.u32Status) ) {
          if (tNavi_display_speed_limit_1.Navi_display_speed_limit_1 <= 255) {
             u8SpeedLimit1 = tNavi_display_speed_limit_1.Navi_display_speed_limit_1;
          }
       }
    }

    ETG_TRACE_USR4(("veda_tclClientVcan::onNavi_display_speed_limit_1Status() received as %u km/hr", u8SpeedLimit1));

    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->vUpdateSpeedLimit1(u8SpeedLimit1);
   // veda_tclClientVcan::onNavi_display_speed_limit_1Status: user specific code end
}

void veda_tclClientVcan::onNavi_display_speed_limit_2Status(TNavi_display_speed_limit_2 tNavi_display_speed_limit_2) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onNavi_display_speed_limit_2Status(): status: %08x, data: %d.", tNavi_display_speed_limit_2.u32Status , tNavi_display_speed_limit_2.Navi_display_speed_limit_2));
   // veda_tclClientVcan::onNavi_display_speed_limit_2Status: user specific code start
    tU8 u8SpeedLimit2 = 0x00; // Invalid Speed Limit Value - ignored by the clients

    if ( u32ConfigMask & VD_FEATURE_ISA_AVAILABLE ) {
       if ( bIsSignalValid(tNavi_display_speed_limit_2.u32Status) ) {
          if (tNavi_display_speed_limit_2.Navi_display_speed_limit_2 <= 255) {
             u8SpeedLimit2 = tNavi_display_speed_limit_2.Navi_display_speed_limit_2;
          }
       }
    }

    ETG_TRACE_USR4(("veda_tclClientVcan::onNavi_display_speed_limit_2Status() received as %u km/hr", u8SpeedLimit2));

    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->vUpdateSpeedLimit2(u8SpeedLimit2);
   // veda_tclClientVcan::onNavi_display_speed_limit_2Status: user specific code end
}

void veda_tclClientVcan::onIgnitionSupplyConfirmationStatus(TIgnitionSupplyConfirmation tIgnitionSupplyConfirmation) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onIgnitionSupplyConfirmationStatus(): status: %08x, data: %d.", tIgnitionSupplyConfirmation.u32Status , tIgnitionSupplyConfirmation.IgnitionSupplyConfirmation));
   // veda_tclClientVcan::onIgnitionSupplyConfirmationStatus: user specific code start
   // veda_tclClientVcan::onIgnitionSupplyConfirmationStatus: user specific code end
}

//Updates Vehicle speed value to Server
void veda_tclClientVcan::onVehicleSpeedStatus(TVehicleSpeed tVehicleSpeed) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleSpeedStatus(): status: %08x, data: %d.", tVehicleSpeed.u32Status , tVehicleSpeed.VehicleSpeed));
   // veda_tclClientVcan::onVehicleSpeedStatus: user specific code start
    _u32CANSpeedStatus = tVehicleSpeed.u32Status;

    if ( bIsSignalValid(_u32CANSpeedStatus) )
    {
        _u16CANSpeed = (tU16) ((tVehicleSpeed.VehicleSpeed[1] << 8) | (tVehicleSpeed.VehicleSpeed[0]));
    }
    else
    {
        _u16CANSpeed = 0xFFFF;
    }
   // veda_tclClientVcan::onVehicleSpeedStatus: user specific code end
}
//TCOVehiclespeed
void veda_tclClientVcan::onTCOVehicleSpeedStatus(TTCOVehicleSpeed tTCOVehicleSpeed) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onTCOVehicleSpeedStatus(): status: %08x, data: %d.", tTCOVehicleSpeed.u32Status , tTCOVehicleSpeed.TCOVehicleSpeed));
   // veda_tclClientVcan::onTCOVehicleSpeedStatus: user specific code start
    _u32CANTCOSpeedStatus = tTCOVehicleSpeed.u32Status;

    if ( bIsSignalValid(_u32CANTCOSpeedStatus) )
    {
        _u16CANTCOSpeed = (tU16) ((tTCOVehicleSpeed.TCOVehicleSpeed[1] << 8) | (tTCOVehicleSpeed.TCOVehicleSpeed[0]));
    }
    else
    {
        _u16CANTCOSpeed = 0xFFFF;
    }
   // veda_tclClientVcan::onTCOVehicleSpeedStatus: user specific code end
}

//Updates partial Mute Value to Server
void veda_tclClientVcan::onVehiclePartialMuteStatus(TPartialMuteValue tPartialMuteValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehiclePartialMuteStatus(): data: %d.", tPartialMuteValue.PartialMuteValue));
	// veda_tclClientVcan::onVehiclePartialMuteStatus: user specific code start
     _u32CANPartialMuteStatus = tPartialMuteValue.u32Status;
	 if(  bIsSignalValid(_u32CANPartialMuteStatus))
	 {
		_u8PartialMuteValue = (tU8) ((tPartialMuteValue.PartialMuteValue));
	 }
	 else
	 {
		_u8PartialMuteValue = 0xFF;
	 }
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendPartialMuteStatus(_u8PartialMuteValue);
	// veda_tclClientVcan::onVehicleMuteStatus: user specific code end
}
//Updates Swiv Monitor ON/OFF status to server
void veda_tclClientVcan::onVehicleSwivMonAutoOpenStatus(TSwivMonAutoOpenValue tSwivMonAutoOpenValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleSwivMonAutoOpenStatus(): data: %d.", tSwivMonAutoOpenValue.SwivMonAutoOpenValue));
	// veda_tclClientVcan::onVehicleSwivMonAutoOpenStatus: user specific code start
     _u32CANSwivMonAutoOpenStatus = tSwivMonAutoOpenValue.u32Status;
	 if(  bIsSignalValid(_u32CANSwivMonAutoOpenStatus))
	 {
		_u8SwivMonAutoOpenValue = (tU8) ((tSwivMonAutoOpenValue.SwivMonAutoOpenValue));
	 }
	 else
	 {
		_u8SwivMonAutoOpenValue = 0xFF;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendSwivMonAutoOpenStatus(_u8SwivMonAutoOpenValue);
	// veda_tclClientVcan::onVehicleMuteStatus: user specific code end
}
//Updates current Date Mode value to server
void veda_tclClientVcan::onVehicleDateModeStatus(TDateModeValue tDateModeValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleDateModeStatus(): data: %d.", tDateModeValue.DateModeValue));
	// veda_tclClientVcan::onVehicleDateModeStatus: user specific code start
     _u32CANDateModeStatus = tDateModeValue.u32Status;
	 if(  bIsSignalValid(_u32CANDateModeStatus))
	 {
		_u8DateModeValue = (tU8) ((tDateModeValue.DateModeValue));
	 }
	 else
	 {
		_u8DateModeValue = 0xFF;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendDateModeStatus(_u8DateModeValue);
	// veda_tclClientVcan::onDateModeStatus: user specific code end
}
	
//Updates current Time mode value to server
void veda_tclClientVcan::onVehicleTmModeStatus(TTmModeValue tTmModeValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleTmModeStatus(): data: %d.", tTmModeValue.TmModeValue));
	// veda_tclClientVcan::onVehicleDateModeStatus: user specific code start
     _u32CANTmModeStatus = tTmModeValue.u32Status;
	 if(  bIsSignalValid(_u32CANTmModeStatus))
	 {
		_u8TmModeValue = (tU8) ((tTmModeValue.TmModeValue));
	 }
	 else
	 {
		_u8TmModeValue = 0xFF;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendTmModeStatus(_u8TmModeValue);
	// veda_tclClientVcan::onTmModeStatus: user specific code end
}

//camera
void veda_tclClientVcan::onVehicleActCam1Status(TActCam1Value tActCam1Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleActCam1Status(): data: %d.", tActCam1Value.ActCam1Value));
	// veda_tclClientVcan::onVehicleActCam1Status: user specific code start
     _u32CANActCam1Status = tActCam1Value.u32Status;
	 if(  bIsSignalValid(_u32CANActCam1Status))
	 {
		_u8ActCam1Value = (tU8) ((tActCam1Value.ActCam1Value));
	 }
	 else
	 {
		_u8ActCam1Value = 0x03;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendActCam1Status(_u8ActCam1Value);
	// veda_tclClientVcan::onVehicleActCam1Status: user specific code end
}
//camera2
void veda_tclClientVcan::onVehicleActCam2Status(TActCam2Value tActCam2Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleActCam2Status(): data: %d.", tActCam2Value.ActCam2Value));
	// veda_tclClientVcan::onVehicleActCam2Status: user specific code start
     _u32CANActCam2Status = tActCam2Value.u32Status;
	 if(  bIsSignalValid(_u32CANActCam2Status))
	 {
		_u8ActCam2Value = (tU8) ((tActCam2Value.ActCam2Value));
	 }
	 else
	 {
		_u8ActCam2Value = 0x03;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendActCam2Status(_u8ActCam2Value);
	// veda_tclClientVcan::onVehicleActCam2Status: user specific code end
}
//camera3
void veda_tclClientVcan::onVehicleActCam3Status(TActCam3Value tActCam3Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleActCam3Status(): data: %d.", tActCam3Value.ActCam3Value));
	// veda_tclClientVcan::onVehicleActCam3Status: user specific code start
     _u32CANActCam3Status = tActCam3Value.u32Status;
	 if(  bIsSignalValid(_u32CANActCam3Status))
	 {
		_u8ActCam3Value = (tU8) ((tActCam3Value.ActCam3Value));
	 }
	 else
	 {
		_u8ActCam3Value = 0x03;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendActCam3Status(_u8ActCam3Value);
	// veda_tclClientVcan::onVehicleActCam3Status: user specific code end
}
//camera4
void veda_tclClientVcan::onVehicleActCam4Status(TActCam4Value tActCam4Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleActCam4Status(): data: %d.", tActCam4Value.ActCam4Value));
	// veda_tclClientVcan::onVehicleActCam4Status: user specific code start
     _u32CANActCam4Status = tActCam4Value.u32Status;
	 if(  bIsSignalValid(_u32CANActCam4Status))
	 {
		_u8ActCam4Value = (tU8) ((tActCam4Value.ActCam4Value));
	 }
	 else
	 {
		_u8ActCam4Value = 0x03;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendActCam4Status(_u8ActCam4Value);
	// veda_tclClientVcan::onVehicleActCam4Status: user specific code end
}
//camera5
void veda_tclClientVcan::onVehicleActCam5Status(TActCam5Value tActCam5Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleActCam5Status(): data: %d.", tActCam5Value.ActCam5Value));
	// veda_tclClientVcan::onVehicleActCam5Status: user specific code start
     _u32CANActCam5Status = tActCam5Value.u32Status;
	 if(  bIsSignalValid(_u32CANActCam5Status))
	 {
		_u8ActCam5Value = (tU8) ((tActCam5Value.ActCam5Value));
	 }
	 else
	 {
		_u8ActCam5Value = 0x03;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendActCam5Status(_u8ActCam5Value);
	// veda_tclClientVcan::onVehicleActCam5Status: user specific code end
}
//camera6
void veda_tclClientVcan::onVehicleActCam6Status(TActCam6Value tActCam6Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleActCam6Status(): data: %d.", tActCam6Value.ActCam6Value));
	// veda_tclClientVcan::onVehicleActCam6Status: user specific code start
     _u32CANActCam6Status = tActCam6Value.u32Status;
	 if(  bIsSignalValid(_u32CANActCam6Status))
	 {
		_u8ActCam6Value = (tU8) ((tActCam6Value.ActCam6Value));
	 }
	 else
	 {
		_u8ActCam6Value = 0x03;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendActCam6Status(_u8ActCam6Value);
	// veda_tclClientVcan::onVehicleActCam6Status: user specific code end
}
//camera7
void veda_tclClientVcan::onVehicleActCam7Status(TActCam7Value tActCam7Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleActCam7Status(): data: %d.", tActCam7Value.ActCam7Value));
	// veda_tclClientVcan::onVehicleActCam7Status: user specific code start
     _u32CANActCam7Status = tActCam7Value.u32Status;
	 if(  bIsSignalValid(_u32CANActCam7Status))
	 {
		_u8ActCam7Value = (tU8) ((tActCam7Value.ActCam7Value));
	 }
	 else
	 {
		_u8ActCam7Value = 0x03;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendActCam7Status(_u8ActCam7Value);
	// veda_tclClientVcan::onVehicleActCam7Status: user specific code end
}
//camsplit
void veda_tclClientVcan::onVehicleCamSplitQuadStatus(TCamSplitQuadValue tCamSplitQuadValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleCamSplitQuadStatus(): data: %d.", tCamSplitQuadValue.CamSplitQuadValue));
	// veda_tclClientVcan::onVehicleActCam7Status: user specific code start
     _u32CANCamSplitQuadStatus = tCamSplitQuadValue.u32Status;
	 if(  bIsSignalValid(_u32CANCamSplitQuadStatus))
	 {
		_u16CamSplitQuadValue = (tU16) ((tCamSplitQuadValue.CamSplitQuadValue));
	 }
	 else
	 {
		_u16CamSplitQuadValue = 0xFFFF;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendCamSplitQuadStatus(_u16CamSplitQuadValue);
	// veda_tclClientVcan::onVehicleCamSplitQuadStatus: user specific code end
}
//MuteDev
void veda_tclClientVcan::onVehicleMuteDevStatus(TMuteDevStatus tMuteDevStatus){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleMuteDevStatus(): data: %d.", tMuteDevStatus.MuteDevStatus));
	// veda_tclClientVcan::onVehicleMuteDevStatusStatus: user specific code start
     _u32CANMuteDevStatus = tMuteDevStatus.u32Status;
	 if(  bIsSignalValid(_u32CANMuteDevStatus))
	 {
		_u8MuteDevStatusValue = (tU8) ((tMuteDevStatus.MuteDevStatus));
	 }
	 else
	 {
		_u8MuteDevStatusValue = 0x03;
	 }
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendMuteDevStatus(_u8MuteDevStatusValue);
	// veda_tclClientVcan::onVehicleMuteDevStatus: user specific code end
}

//Updates SysVoltStatus Value to Server
void veda_tclClientVcan::onVehicleSysVoltStatus(TSysVoltStatus tSysVoltStatus){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleSysVoltStatus(): data: %d.", tSysVoltStatus.SysVoltStatus));
	// veda_tclClientVcan::onVehiclSysVoltStatus: user specific code start
     _u32CANSysVoltStatus = tSysVoltStatus.u32Status;
	 if(  bIsSignalValid(_u32CANSysVoltStatus))
	 {
		_u8SysVoltStatusValue = (tU8) ((tSysVoltStatus.SysVoltStatus));
	 }
	 else
	 {
		_u8SysVoltStatusValue = 0x03;
	 }
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendSysVoltStatus(_u8SysVoltStatusValue);
	// veda_tclClientVcan::onVehicleSysVoltStatus: user specific code end
}

//Updates ParkingBreakSwitch value to server
void veda_tclClientVcan::onVehicleParkingBreakSwitchStatus(TParkingBreakSwitchValue tParkingBreakSwitchValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleParkingBreakSwitchStatus(): data: %d.", tParkingBreakSwitchValue.ParkingBreakSwitchValue));
	// veda_tclClientVcan::onVehiclParkingBreakSwitchValueStatus: user specific code start
     _u32CANParkingBreakSwitchStatus = tParkingBreakSwitchValue.u32Status;
	 if(  bIsSignalValid(_u32CANParkingBreakSwitchStatus))
	 {
		_u8ParkingBreakSwitchValue = (tU8) ((tParkingBreakSwitchValue.ParkingBreakSwitchValue));
	 }
	 else
	 {
		_u8ParkingBreakSwitchValue = 0xFF;
	 }
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendParkingBreakSwitchStatus(_u8ParkingBreakSwitchValue);
	// veda_tclClientVcan::onVehicleParkingBreakSwitchStatus: user specific code end
}

//Updates RearCamReq value to server
void veda_tclClientVcan::onVehicleRearCamReqStatus(TRearCamReqValue tRearCamReqValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleRearCamReqStatus(): data: %d.", tRearCamReqValue.RearCamReqValue));
	// veda_tclClientVcan::onVehicleRearCamReqStatus: user specific code start
     _u32CANRearCamReqStatus = tRearCamReqValue.u32Status;
	 if(  bIsSignalValid(_u32CANRearCamReqStatus))
	 {
		_u8RearCamReqValue = (tU8) ((tRearCamReqValue.RearCamReqValue));
	 }
	 else
	 {
		_u8RearCamReqValue = 0x03;
	 }
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendRearCamReqStatus(_u8RearCamReqValue);
	// veda_tclClientVcan::onVehicleRearCamReqStatus: user specific code end
}

//VIN
void veda_tclClientVcan::onVehicleVINStatus(TVINValue tVINValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleVINStatus(): data: %d.", tVINValue.VINValue));
	// veda_tclClientVcan::onVehicleVINStatus: user specific code start
     _u32CANVINStatus = tVINValue.u32Status;
	 if(  bIsSignalValid(_u32CANVINStatus))
	 {
		_u32VINValue = (tU32) ((tVINValue.VINValue));
	 }
	 else
	 {
		_u32VINValue = 0xFFFFFFFF;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendVINStatus(_u32VINValue);
	// veda_tclClientVcan::onVINStatus: user specific code end
}


//Time Date 
void veda_tclClientVcan::onTimeDateStatus(TTimeDateValue tTimeDateValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onTimeDateStatus(): data: %d.", tTimeDateValue.TimeDateValue));
	// veda_tclClientVcan::onTimeDateStatus: user specific code start
     _u32CANTimeDateStatus = tTimeDateValue.u32Status;
	 if(  bIsSignalValid(_u32CANTimeDateStatus))
	 {
		_u64TimeDateValue = (tU64) ((tTimeDateValue.TimeDateValue));
	 }
	 else
	 {
		_u64TimeDateValue = 0xFFFFFFFFFFFFFFFF;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendTimeDateStatus(_u64TimeDateValue);
	// veda_tclClientVcan::onVINStatus: user specific code end
}



//Phone Call Command
void veda_tclClientVcan::onPhoneCallCommandStatus(TPhoneCallCommand tPhoneCallCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onPhoneCallCommandStatus(): data: %d.", tPhoneCallCommandValue.PhoneCallCmdValue));
	//veda_tclClientVcan::onTimeDateStatus: user specific code start
    _u32PhoneCallCommandStatus = tPhoneCallCommandValue.u32Status;
	  if(  bIsSignalValid(_u32PhoneCallCommandStatus))
	  {
		 _u8PhoneCallCommandValue = (tU8) ((tPhoneCallCommandValue.PhoneCallCmdValue));
	  }
	  else
	 {
		 _u8PhoneCallCommandValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendPhoneCallCmdStatus(_u8PhoneCallCommandValue);
	// veda_tclClientVcan::onPhoneCallCommandStatus: user specific code end
}


//Volume Command
void veda_tclClientVcan::onVolumeCommandStatus(TVolumeCommand tVolumeCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVolumeCommandStatus(): data: %d.", tVolumeCommandValue.VolumeCmdValue));
	//veda_tclClientVcan::onVolumeCommandStatus: user specific code start
    _u32VolumeCommandStatus = tVolumeCommandValue.u32Status;
	  if(  bIsSignalValid(_u32VolumeCommandStatus))
	  {
		 _u8VolumeCommandValue = (tU8) ((tVolumeCommandValue.VolumeCmdValue));
	  }
	  else
	 {
		 _u8VolumeCommandValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendVolumeCmdStatus(_u8VolumeCommandValue);
	// veda_tclClientVcan::onVolumeCommandStatus: user specific code end
}



// ActCam8
void veda_tclClientVcan::onActCam8Status(TActCam8 tActCam8Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam8Status(): data: %d.", tActCam8Value.ActCam8Value));
	//veda_tclClientVcan::onActCam8Status: user specific code start
    _u32ActCam8Status = tActCam8Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam8Status))
	  {
		 _u8ActCam8Value = (tU8) ((tActCam8Value.ActCam8Value));
	  }
	  else
	 {
		 _u8ActCam8Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendActCam8Status(_u8ActCam8Value);
	// veda_tclClientVcan::onActCam8Status: user specific code end
}

// ActCam9
void veda_tclClientVcan::onActCam9Status(TActCam9 tActCam9Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam9Status(): data: %d.", tActCam9Value.ActCam9Value));
	//veda_tclClientVcan::onActCam9Status: user specific code start
    _u32ActCam9Status = tActCam9Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam9Status))
	  {
		 _u8ActCam9Value = (tU8) ((tActCam9Value.ActCam9Value));
	  }
	  else
	 {
		 _u8ActCam9Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendActCam9Status(_u8ActCam9Value);
	// veda_tclClientVcan::onActCam9Status: user specific code end
}

// ActCam10
void veda_tclClientVcan::onActCam10Status(TActCam10 tActCam10Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam10Status(): data: %d.", tActCam10Value.ActCam10Value));
	//veda_tclClientVcan::onActCam10Status: user specific code start
    _u32ActCam10Status = tActCam10Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam10Status))
	  {
		 _u8ActCam10Value = (tU8) ((tActCam10Value.ActCam10Value));
	  }
	  else
	 {
		 _u8ActCam10Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendActCam10Status(_u8ActCam10Value);
	// veda_tclClientVcan::onActCam10Status: user specific code end
}

// ActCam11
void veda_tclClientVcan::onActCam11Status(TActCam11 tActCam11Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam11Status(): data: %d.", tActCam11Value.ActCam11Value));
	//veda_tclClientVcan::onActCam11Status: user specific code start
    _u32ActCam11Status = tActCam11Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam11Status))
	  {
		 _u8ActCam11Value = (tU8) ((tActCam11Value.ActCam11Value));
	  }
	  else
	 {
		 _u8ActCam11Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendActCam11Status(_u8ActCam11Value);
	// veda_tclClientVcan::onActCam11Status: user specific code end
}

// ActCam12
void veda_tclClientVcan::onActCam12Status(TActCam12 tActCam12Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam12Status(): data: %d.", tActCam12Value.ActCam12Value));
	//veda_tclClientVcan::onActCam12Status: user specific code start
    _u32ActCam12Status = tActCam12Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam12Status))
	  {
		 _u8ActCam12Value = (tU8) ((tActCam12Value.ActCam12Value));
	  }
	  else
	 {
		 _u8ActCam12Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendActCam12Status(_u8ActCam12Value);
	// veda_tclClientVcan::onActCam12Status: user specific code end
}

// ActCam13
void veda_tclClientVcan::onActCam13Status(TActCam13 tActCam13Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam13Status(): data: %d.", tActCam13Value.ActCam13Value));
	//veda_tclClientVcan::onActCam13Status: user specific code start
    _u32ActCam13Status = tActCam13Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam13Status))
	  {
		 _u8ActCam13Value = (tU8) ((tActCam13Value.ActCam13Value));
	  }
	  else
	 {
		 _u8ActCam13Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendActCam13Status(_u8ActCam13Value);
	// veda_tclClientVcan::onActCam13Status: user specific code end
}

// ActCam14
void veda_tclClientVcan::onActCam14Status(TActCam14 tActCam14Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam14Status(): data: %d.", tActCam14Value.ActCam14Value));
	//veda_tclClientVcan::onActCam14Status: user specific code start
    _u32ActCam14Status = tActCam14Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam14Status))
	  {
		 _u8ActCam14Value = (tU8) ((tActCam14Value.ActCam14Value));
	  }
	  else
	 {
		 _u8ActCam14Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendActCam14Status(_u8ActCam14Value);
	// veda_tclClientVcan::onActCam14Status: user specific code end
}

// ActCam15
void veda_tclClientVcan::onActCam15Status(TActCam15 tActCam15Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam15Status(): data: %d.", tActCam15Value.ActCam15Value));
	//veda_tclClientVcan::onActCam15Status: user specific code start
    _u32ActCam15Status = tActCam15Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam15Status))
	  {
		 _u8ActCam15Value = (tU8) ((tActCam15Value.ActCam15Value));
	  }
	  else
	 {
		 _u8ActCam15Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendActCam15Status(_u8ActCam15Value);
	// veda_tclClientVcan::onActCam15Status: user specific code end
}

// ActCam16
void veda_tclClientVcan::onActCam16Status(TActCam16 tActCam16Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam16Status(): data: %d.", tActCam16Value.ActCam16Value));
	//veda_tclClientVcan::onActCam16Status: user specific code start
    _u32ActCam16Status = tActCam16Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam16Status))
	  {
		 _u8ActCam16Value = (tU8) ((tActCam16Value.ActCam16Value));
	  }
	  else
	 {
		 _u8ActCam16Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendActCam16Status(_u8ActCam16Value);
	// veda_tclClientVcan::onActCam16Status: user specific code end
}

// ActCam17
void veda_tclClientVcan::onActCam17Status(TActCam17 tActCam17Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onActCam17Status(): data: %d.", tActCam17Value.ActCam17Value));
	//veda_tclClientVcan::onActCam17Status: user specific code start
    _u32ActCam17Status = tActCam17Value.u32Status;
	  if(  bIsSignalValid(_u32ActCam17Status))
	  {
		 _u8ActCam17Value = (tU8) ((tActCam17Value.ActCam17Value));
	  }
	  else
	 {
		 _u8ActCam17Value = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
  //   _poCCAServiceHdl->sendActCam17Status(_u8ActCam17Value);
	// veda_tclClientVcan::onActCam17Status: user specific code end
}

//Source Command
void veda_tclClientVcan::onSourceCommandStatus(TSourceCommand tSourceCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onSourceCommandStatus(): data: %d.", tSourceCommandValue.SourceCmdValue));
	//veda_tclClientVcan::onSourceCommandStatus: user specific code start
    _u32SourceCommandStatus = tSourceCommandValue.u32Status;
	  if(  bIsSignalValid(_u32SourceCommandStatus))
	  {
		 _u8SourceCommandValue = (tU8) ((tSourceCommandValue.SourceCmdValue));
	  }
	  else
	 {
		 _u8SourceCommandValue = 0x3F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendSourceCmdStatus(_u8SourceCommandValue);
	// veda_tclClientVcan::onVolumeCommandStatus: user specific code end
}


//CabinSource Command
void veda_tclClientVcan::onCabinSourceCommandStatus(TCabinSourceCommand tCabinSourceCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onCabinSourceCommandStatus(): data: %d.", tCabinSourceCommandValue.CabinSourceCmdValue));
	//veda_tclClientVcan::onCabinSourceCommandStatus: user specific code start
    _u32CabinSourceCommandStatus = tCabinSourceCommandValue.u32Status;
	  if(  bIsSignalValid(_u32CabinSourceCommandStatus))
	  {
		 _u8CabinSourceCommandValue = (tU8) ((tCabinSourceCommandValue.CabinSourceCmdValue));
	  }
	  else
	 {
		 _u8CabinSourceCommandValue = 0x3F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendCabinSourceCmdStatus(_u8CabinSourceCommandValue);
	// veda_tclClientVcan::onCabinSourceCommandStatus: user specific code end
}




//CabinTuner Command
void veda_tclClientVcan::onCabinTunerCommandStatus(TCabinTunerCommand tCabinTunerCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onCabinTunerCommandStatus(): data: %d.", tCabinTunerCommandValue.CabinTunerCmdValue));
	//veda_tclClientVcan::onCabinTunerCommandStatus: user specific code start
    _u32CabinTunerCommandStatus = tCabinTunerCommandValue.u32Status;
	  if(  bIsSignalValid(_u32CabinTunerCommandStatus))
	  {
		 _u8CabinTunerCommandValue = (tU8) ((tCabinTunerCommandValue.CabinTunerCmdValue));
	  }
	  else
	 {
		 _u8CabinTunerCommandValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendCabinTunerCmdStatus(_u8CabinTunerCommandValue);
	// veda_tclClientVcan::onCabinTunerCommandStatus: user specific code end
}




//CabinVolume Command
void veda_tclClientVcan::onCabinVolumeCommandStatus(TCabinVolumeCommand tCabinVolumeCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onCabinVolumeCommandStatus(): data: %d.", tCabinVolumeCommandValue.CabinVolumeCmdValue));
	//veda_tclClientVcan::onCabinSourceCommandStatus: user specific code start
    _u32CabinVolumeCommandStatus = tCabinVolumeCommandValue.u32Status;
	  if(  bIsSignalValid(_u32CabinVolumeCommandStatus))
	  {
		 _u8CabinVolumeCommandValue = (tU8) ((tCabinVolumeCommandValue.CabinVolumeCmdValue));
	  }
	  else
	 {
		 _u8CabinVolumeCommandValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendCabinVolumeCmdStatus(_u8CabinVolumeCommandValue);
	// veda_tclClientVcan::onCabinVolumeCommandStatus: user specific code end
}





//CabinTrack Command
void veda_tclClientVcan::onCabinTrackCommandStatus(TCabinTrackCommand tCabinTrackCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onCabinTrackCommandStatus(): data: %d.", tCabinTrackCommandValue.CabinTrackCmdValue));
	//veda_tclClientVcan::onCabinTrackCommandStatus: user specific code start
    _u32CabinTrackCommandStatus = tCabinTrackCommandValue.u32Status;
	  if(  bIsSignalValid(_u32CabinTrackCommandStatus))
	  {
		 _u8CabinTrackCommandValue = (tU8) ((tCabinTrackCommandValue.CabinTrackCmdValue));
	  }
	  else
	 {
		 _u8CabinTrackCommandValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendCabinTrackCmdStatus(_u8CabinTrackCommandValue);
	// veda_tclClientVcan::onCabinTrackCommandStatus: user specific code end
}




//CabinPlaylist Command
void veda_tclClientVcan::onCabinPlaylistCommandStatus(TCabinPlaylistCommand tCabinPlaylistCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onCabinPlaylistCommandStatus(): data: %d.", tCabinPlaylistCommandValue.CabinPlaylistCmdValue));
	//veda_tclClientVcan::onCabinPlaylistCommandStatus: user specific code start
    _u32CabinPlaylistCommandStatus = tCabinPlaylistCommandValue.u32Status;
	  if(  bIsSignalValid(_u32CabinPlaylistCommandStatus))
	  {
		 _u8CabinPlaylistCommandValue = (tU8) ((tCabinPlaylistCommandValue.CabinPlaylistCmdValue));
	  }
	  else
	 {
		 _u8CabinPlaylistCommandValue = 0x03;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->sendCabinPlaylistCmdStatus(_u8CabinPlaylistCommandValue);
	// veda_tclClientVcan::onCabinPlaylistCommandStatus: user specific code end
}




// RC Next Btn
void veda_tclClientVcan::onRCNextBtnStatus(TRCNextBtn tRCNextBtnValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onRCNextBtnStatus(): data: %d.", tRCNextBtnValue.RCNextBtnValue));
	//veda_tclClientVcan::onRCNextBtnStatus: user specific code start
    _u32RCNextBtnStatus = tRCNextBtnValue.u32Status;
	  if(  bIsSignalValid(_u32RCNextBtnStatus))
	  {
		 _u8RCNextBtnValue = (tU8) ((tRCNextBtnValue.RCNextBtnValue));
	  }
	  else
	 {
		 _u8RCNextBtnValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendRCNextBtnStatus(_u8RCNextBtnValue);
	// veda_tclClientVcan::onRCNextBtnStatus: user specific code end
}


// RC Prev Btn
void veda_tclClientVcan::onRCPrevBtnStatus(TRCPrevBtn tRCPrevBtnValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onRCPrevBtnStatus(): data: %d.", tRCPrevBtnValue.RCPrevBtnValue));
	//veda_tclClientVcan::onRCPrevBtnStatus: user specific code start
    _u32RCPrevBtnStatus = tRCPrevBtnValue.u32Status;
	  if(  bIsSignalValid(_u32RCPrevBtnStatus))
	  {
		 _u8RCPrevBtnValue = (tU8) ((tRCPrevBtnValue.RCPrevBtnValue));
	  }
	  else
	 {
		 _u8RCPrevBtnValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendRCPrevBtnStatus(_u8RCPrevBtnValue);
	// veda_tclClientVcan::onRCPrevBtnStatus: user specific code end
}





//Track Command
void veda_tclClientVcan::onTrackCommandStatus(TTrackCommand tTrackCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onTrackCommandStatus(): data: %d.", tTrackCommandValue.TrackCommandValue));
	//veda_tclClientVcan::onTrackCommandStatus: user specific code start
    _u32TrackCommandStatus = tTrackCommandValue.u32Status;
	  if(  bIsSignalValid(_u32TrackCommandStatus))
	  {
		 _u8TrackCommandValue = (tU8) ((tTrackCommandValue.TrackCommandValue));
	  }
	  else
	 {
		 _u8TrackCommandValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendTrackCommandStatus(_u8TrackCommandValue);
	// veda_tclClientVcan::sendTrackCommandStatus: user specific code end
}

//SMARTVR
void veda_tclClientVcan::onSMARTVRStatus(TSMARTVR tSMARTVRValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onSMARTVRStatus(): data: %d.", tSMARTVRValue.SMARTVRValue));
	//veda_tclClientVcan::onSMARTVRStatus: user specific code start
    _u32SMARTVRStatus = tSMARTVRValue.u32Status;
	  if(  bIsSignalValid(_u32SMARTVRStatus))
	  {
		 _u8SMARTVRValue = (tU8) ((tSMARTVRValue.SMARTVRValue));
	  }
	  else
	 {
		 _u8SMARTVRValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendSMARTVRStatus(_u8SMARTVRValue);
	// veda_tclClientVcan::sendSMARTVRStatus: user specific code end
}


//Tuner Command
void veda_tclClientVcan::onTunerCommandStatus(TTunerCommand tTunerCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onTunerCommandStatus(): data: %d.", tTunerCommandValue.TunerCommandValue));
	//veda_tclClientVcan::onTunerCommandStatus: user specific code start
    _u32TunerCommandStatus = tTunerCommandValue.u32Status;
	  if(  bIsSignalValid(_u32TunerCommandStatus))
	  {
		 _u8TunerCommandValue = (tU8) ((tTunerCommandValue.TunerCommandValue));
	  }
	  else
	 {
		 _u8TunerCommandValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendTunerCommandStatus(_u8TunerCommandValue);
	// veda_tclClientVcan::sendTunerCommandStatus: user specific code end
}


//TA Command
void veda_tclClientVcan::onTACommandStatus(TTACommand tTACommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onTACommandStatus(): data: %d.", tTACommandValue.TACommandValue));
	//veda_tclClientVcan::onTACommandStatus: user specific code start
    _u32TACommandStatus = tTACommandValue.u32Status;
	  if(  bIsSignalValid(_u32TACommandStatus))
	  {
		 _u8TACommandValue = (tU8) ((tTACommandValue.TACommandValue));
	  }
	  else
	 {
		 _u8TACommandValue = 0x03;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendTACommandStatus(_u8TACommandValue);
	// veda_tclClientVcan::sendTACommandStatus: user specific code end
}


//RDS Command
void veda_tclClientVcan::onRDSCommandStatus(TRDSCommand tRDSCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onRDSCommandStatus(): data: %d.", tRDSCommandValue.RDSCommandValue));
	//veda_tclClientVcan::onRDSCommandStatus: user specific code start
    _u32RDSCommandStatus = tRDSCommandValue.u32Status;
	  if(  bIsSignalValid(_u32RDSCommandStatus))
	  {
		 _u8RDSCommandValue = (tU8) ((tRDSCommandValue.RDSCommandValue));
	  }
	  else
	 {
		 _u8RDSCommandValue = 0x03;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendRDSCommandStatus(_u8RDSCommandValue);
	// veda_tclClientVcan::sendTACommandStatus: user specific code end
}




//Voice Rcgn Command
void veda_tclClientVcan::onVoiceRecgCommandStatus(TVoiceRecgCommand tVoiceRecgCommandValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVoiceRecgCommandStatus(): data: %d.", tVoiceRecgCommandValue.VoiceRecgCmdValue));
	//veda_tclClientVcan::onVoiceRecgCommandStatus: user specific code start
    _u32VoiceRecgnCommandStatus = tVoiceRecgCommandValue.u32Status;
	  if(  bIsSignalValid(_u32VoiceRecgnCommandStatus))
	  {
		 _u8VoiceRecgCommandValue = (tU8) ((tVoiceRecgCommandValue.VoiceRecgCmdValue));
	  }
	  else
	 {
		 _u8VoiceRecgCommandValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendVoiceRecgCmdStatus(_u8VoiceRecgCommandValue);
//	 veda_tclClientVcan::onVoiceRecgCommandStatus: user specific code end
}


void veda_tclClientVcan::onPhonePwrCmdStatus(TPhonePwrCmd tPhonePwrCmdValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onPhonePwrCmdStatus(): data: %d.", tPhonePwrCmdValue.PhonePwrCmdValue));
	//veda_tclClientVcan::onPhonePwrCmdStatus: user specific code start
    _u32PhonePwrCmdStatus = tPhonePwrCmdValue.u32Status;
	  if(  bIsSignalValid(_u32PhonePwrCmdStatus))
	  {
		 _u8PhonePwrCmdValue = (tU8) ((tPhonePwrCmdValue.PhonePwrCmdValue));
	  }
	  else
	 {
		 _u8PhonePwrCmdValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendPhonePwrCmdStatus(_u8PhonePwrCmdValue);
//	 veda_tclClientVcan::onPhonePwrCmdStatus: user specific code end
}



void veda_tclClientVcan::onRadioPwrCmdStatus(TRadioPwrCmd tRadioPwrCmdValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onRadioPwrCmdStatus(): data: %d.", tRadioPwrCmdValue.RadioPwrCmdValue));
	//veda_tclClientVcan::onRadioPwrCmdStatus: user specific code start
    _u32RadioPwrCmdStatus = tRadioPwrCmdValue.u32Status;
	  if(  bIsSignalValid(_u32RadioPwrCmdStatus))
	  {
		 _u8RadioPwrCmdValue = (tU8) ((tRadioPwrCmdValue.RadioPwrCmdValue));
	  }
	  else
	 {
		 _u8RadioPwrCmdValue = 0x0F;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendRadioPwrCmdStatus(_u8RadioPwrCmdValue);
//	 veda_tclClientVcan::onRadioPwrCmdStatus: user specific code end
}







//Device Info SW version
void veda_tclClientVcan::onDeviceInfoSWversionStatus(TDeviceInfoSWversion tDeviceInfoSWversionValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onDeviceInfoSWversionStatus(): data: %d.", tDeviceInfoSWversionValue.SWversionValue));
	//veda_tclClientVcan::onDeviceInfoSWversionStatus: user specific code start
    _u32DeviceInfoSWversionStatus = tDeviceInfoSWversionValue.u32Status;
	  if(  bIsSignalValid(_u32DeviceInfoSWversionStatus))
	  {
		 _u32SWversionValue = (tU32) ((tDeviceInfoSWversionValue.SWversionValue));
	  }
	  else
	 {
		 _u32SWversionValue = 0xFFFFFFFF;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->SendDeviceInfoSWversionStatus(_u32SWversionValue);
	//veda_tclClientVcan::onDeviceInfoSWversionStatus: user specific code end
}


//TotalVehDistDiag
void veda_tclClientVcan::onTotalVehDistDiagStatus(TTotalVehDistDiag tTotalVehDistDiagValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onTotalVehDistDiagStatus(): data: %d.", tTotalVehDistDiagValue.TotalVehDistDiagValue));
	//veda_tclClientVcan::onDeviceInfoSWversionStatus: user specific code start
    _u32TotalVehDistDiagStatus = tTotalVehDistDiagValue.u32Status;
	  if(  bIsSignalValid(_u32TotalVehDistDiagStatus))
	  {
		 _u32TotalVehDistDiagValue = (tU32) ((tTotalVehDistDiagValue.TotalVehDistDiagValue));
	  }
	  else
	 {
		 _u32TotalVehDistDiagValue = 0xFFFFFFFF;
	  }
	  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
     _poCCAServiceHdl->SendTotalVehDistDiagStatus(_u32TotalVehDistDiagValue);
	//veda_tclClientVcan::onTotalVehDistDiagStatus: user specific code end
}



//System Language
void veda_tclClientVcan::onVehicleSystemLanguageStatus(TSystemLanguageValue tSystemLanguage) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleSystemLanguageStatus(): status: %08x, data: %u.", tSystemLanguage.u32Status , tSystemLanguage.SystemLanguageValue));
   tU8 tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US);//Default US-English
   tU8 tVariant = _u8ReadConfiguredRegion();
   ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleCurrLangStatus(): variant: %d ", tVariant));
   //Blocking SNA and Err condition as per settings component request
    if( ( bIsSignalValid(tSystemLanguage.u32Status) ) & (tSystemLanguage.SystemLanguageValue != 0xFFFF & tSystemLanguage.SystemLanguageValue != 0xFFFE))
   {
	  if (tVariant <= MEX)//NAFTA
	  {
		switch(tSystemLanguage.SystemLanguageValue){
			case 0x0:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US);
				break;
			case 0x04:
				tLangCode =  static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_SPANISH_LATIN_AMERICAN);
				break;
			case 0x02:
				tLangCode =  static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_FRENCH_CANADIAN);
				break;
			case 0xFFFE:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNUSED);
				break;
			case 0xFFFF:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNSUPPORTED);
				break;
			default:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US);
				break;
		}
		//Configuring for US-English, as CAN provides only EN
	  }
	  else if((tVariant >= UK) && (tVariant <= OTHER_EUR))//EU
	  {
		switch(tSystemLanguage.SystemLanguageValue){
			case 0x0:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_UK);
				break;
			case 0x01:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_GERMAN);
				break;
			case 0x03:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_DUTCH);
				break;
			case 0x02:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_FRENCH);
				break;
			case 0x06:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ITALIAN);
				break;
			case 0x04:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_SPANISH);
				break;
			case 0x05:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_PORTUGUESE);
				break;
			case 0x14:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_HUNGARIAN);
				break;
			case 0x0D:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_RUSSIAN);
				break;
			case 0x0C:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_CZECH);
				break;
			case 0x07:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_DANISH);
				break;
			case 0x08:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_NORWEGIAN);
				break;
			case 0x0B:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_POLISH);
				break;
			case 0x09:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_SWEDISH);
				break;
			case 0x0E:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_TURKISH);
				break;
			case 0xFFFE:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNUSED);
				break;
			case 0xFFFF:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNSUPPORTED);
				break;
			default:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_UK);
				break;
		}
	  }
	  else
	  {
		  //No requirements in language yet for other region
	  }
      VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	  vehicle_fi_tcl_e8_Language_SourceId sourceId;
	  sourceId.enType = vehicle_fi_tcl_e8_Language_SourceId::FI_EN_HMI ;
	  veda_tclBaseIf::TMsg pMsg;
      (tVoid)memset((tVoid*)&pMsg, OSAL_NULL, sizeof(pMsg));
      pMsg.eCmd = veda_tclBaseIf::eSetLanguage;
      strncpy(pMsg.strClassName, "veda_tclLanguageHandler", sizeof("veda_tclLanguageHandler"));
      pMsg.u.au8Data[0] = static_cast<tU8>(HMI);
      pMsg.u.au8Data[1] = tLangCode;
      
      _cpoMain->theServer()->vPostInternalMessage(&pMsg);
   }
   // veda_tclClientVcan::onVehicleSystemLanguageStatus: user specific code end
}
//CurrLang
void veda_tclClientVcan::onVehicleCurrLangStatus(TCurrLangValue tCurrLang) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleCurrLangStatus(): status: %08x, data: %u.", tCurrLang.u32Status , tCurrLang.CurrLangValue));
   // veda_tclClientVcan::onVehicleCurrLangStatus: user specific code start

   // clear the previous sent request if any
   //vSendCockpitLanguageUpdate(COCKPIT_LANGUAGE_NO_REQUEST);
   tU8 tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US);//Default US-English
   tU8 tVariant = _u8ReadConfiguredRegion();
   ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleCurrLangStatus(): variant: %d ", tVariant));
   
 //  if ( bIsSignalValid(tCurrLang.u32Status) )
	  if( ( bIsSignalValid(tCurrLang.u32Status) ) & (tCurrLang.CurrLangValue != 0xFFFF & tCurrLang.CurrLangValue != 0x0000))
   {
	  if (tVariant <= MEX)//NAFTA
	  {
		switch(tCurrLang.CurrLangValue){
			case 'e'<< 8 | 'n'://'en'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_UK);
				break;
			case 'u'<< 8 | 's'://'us'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US);
				break;
			case 'e'<< 8 | 's'://'es'
				tLangCode =  static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_SPANISH_LATIN_AMERICAN);
				break;
			case 'f'<< 8 | 'r'://'fr'
				tLangCode =  static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_FRENCH_CANADIAN);
				break;
			case 0x0000:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNUSED);
				break;
			case 0xFFFF:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNSUPPORTED);
				break;
			default:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US);
				break;
		}
	  }
	  else if((tVariant >= UK) && (tVariant <= OTHER_EUR))//EU
	  {
		switch(tCurrLang.CurrLangValue){
			case 'e'<< 8 | 'n':		//'en'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_UK);
				break;
			case 'u'<< 8 | 's':		//'us'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US);
				break;
			case 'd'<< 8 | 'e':		//'de'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_GERMAN);
				break;
			case 'n'<< 8 | 'l':		//'nl'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_DUTCH);
				break;
			case 'f'<< 8 | 'r':		//'fr'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_FRENCH);
				break;
			case 'i'<< 8 | 't':		//'it'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ITALIAN);
				break;
			case 'e'<< 8 | 's':		//'es'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_SPANISH);
				break;
			case 'p'<< 8 | 't':		//'pt'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_PORTUGUESE);
				break;
			case 'h'<< 8 | 'u':		//'hu'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_HUNGARIAN);
				break;
			case 'r'<< 8 | 'u':		//'ru'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_RUSSIAN);
				break;
			case 'c'<< 8 | 's':		//'cs'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_CZECH);
				break;
			case 'd'<< 8 | 'a':		//'da'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_DANISH);
				break;
			case 'n'<< 8 | 'o':		//'no'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_NORWEGIAN);
				break;
			case 'p'<< 8 | 'l':		//'pl'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_POLISH);
				break;
			case 's'<< 8 | 'v':		//'sv'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_SWEDISH);
				break;
			case 't'<< 8 | 'r':		//'tr'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_TURKISH);
				break;
			case 'e'<< 8 | 'l':		//'el'
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_GREEK);
				break;
			case 0x0000:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNUSED);
				break;
			case 0xFFFF:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNSUPPORTED);
				break;
			default:
				tLangCode = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_UK);
				break;
		}
	  }
	  else
	  {
		  //No requirements in language yet for other region
	  }
      VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	  vehicle_fi_tcl_e8_Language_SourceId sourceId;
	  sourceId.enType = vehicle_fi_tcl_e8_Language_SourceId::FI_EN_HMI ;
	  veda_tclBaseIf::TMsg pMsg;
      (tVoid)memset((tVoid*)&pMsg, OSAL_NULL, sizeof(pMsg));
      pMsg.eCmd = veda_tclBaseIf::eSetLanguage;
      strncpy(pMsg.strClassName, "veda_tclLanguageHandler", sizeof("veda_tclLanguageHandler"));
      pMsg.u.au8Data[0] = static_cast<tU8>(HMI);
      pMsg.u.au8Data[1] = tLangCode;
      
      _cpoMain->theServer()->vPostInternalMessage(&pMsg);
   }
   // veda_tclClientVcan::onVehicleCurrLangStatus: user specific code end
}

//CamTxt
void veda_tclClientVcan::onVehicleCamTxtStatus(TCamTxtValue tCamTxtValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleCamTxtStatus(): data: %d.", tCamTxtValue.CamTxtValue));
	// veda_tclClientVcan::onVehicleCamTxtStatus: user specific code start
     _u32CANCamTxtStatus = tCamTxtValue.u32Status;
	 if(  bIsSignalValid(_u32CANCamTxtStatus))
	 {
		_u64CamTxtValue = (tU64) ((tCamTxtValue.CamTxtValue));
	 }
	 else
	 {
		_u64CamTxtValue = 0xFFFFFFFFFFFFFFFF;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendCamTxtStatus(_u64CamTxtValue);
	// veda_tclClientVcan::onVehicleCamTxtStatus: user specific code end
}

//VIN_64
void veda_tclClientVcan::onVIN_64Status(TVIN_64 tVIN_64Value){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVIN_64Status(): data: %d.", tVIN_64Value.VIN_64Value));
	// veda_tclClientVcan::onVIN_64Status: user specific code start
     _u32VIN_64Status = tVIN_64Value.u32Status;
	 if(  bIsSignalValid(_u32VIN_64Status))
	 {
		_u64VIN_64Value = (tU64) ((tVIN_64Value.VIN_64Value));
	 }
	 else
	 {
		_u64VIN_64Value = 0xFFFFFFFFFFFFFFFF;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
   _poCCAServiceHdl->sendVIN_64Status(_u64VIN_64Value);
	// veda_tclClientVcan::onVIN_64Status: user specific code end
}

//PrivacyResetReq
void veda_tclClientVcan::onVehiclePrivacyResetReqStatus(TPrivacyResetReqValue tPrivacyResetReqValue){
	 ETG_TRACE_USR4(("veda_tclClientVcan::onVehiclePrivacyResetReqStatus(): data: %d.", tPrivacyResetReqValue.PrivacyResetReqValue));
	// veda_tclClientVcan::onVehiclePrivacyResetReqStatus: user specific code start
     _u32CANPrivacyResetReqStatus = tPrivacyResetReqValue.u32Status;
	 if(  bIsSignalValid(_u32CANPrivacyResetReqStatus))
	 {
		_u8PrivacyResetReqValue = (tU8) ((tPrivacyResetReqValue.PrivacyResetReqValue));
	 }
	 else
	 {
		_u8PrivacyResetReqValue = 0xFF;
	 }
	 VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendPrivacyResetReqStatus(_u8PrivacyResetReqValue);
	// veda_tclClientVcan::onPrivacyResetReqStatus: user specific code end
}

//SendMediaInfo Longdata
tVoid veda_tclClientVcan::vSendMediaInfo(vehicle_fi_tcl_CAN_Mesg msg)
{
	 ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaInfo"));
	// TMediaInfo stmediamsg;
        // stmediamsg.u8txtype = msg.u8MediaType;
        // stmediamsg.list  = msg.listData;	
	  if (_pCsmBase) {
            _pCsmBase->vSendMeidaDataToCluster(msg);

         }
 
}
//SendCabAMediaInfo
tVoid veda_tclClientVcan::vSendCabAMediaInfo(vehicle_fi_tcl_CAN_Mesg msg)
{
	 ETG_TRACE_USR4(("veda_tclClientVcan::vSendCabAMediaInfo"));
          if (_pCsmBase) {
            _pCsmBase->vSendCabinAMeidaDataToCluster(msg);

         }

}
//vSendCallInfo LongData
tVoid veda_tclClientVcan::vSendCallInfo(vehicle_fi_tcl_CAN_Mesg msg)
{
         ETG_TRACE_USR4(("veda_tclClientVcan::vSendCallInfo"));
          if (_pCsmBase) {
            _pCsmBase->vSendCallDataToCluster(msg);
         }

}
//vSendPhoneInfo LongData
tVoid veda_tclClientVcan::vSendPhoneInfo(vehicle_fi_tcl_CAN_Mesg msg)
{
         ETG_TRACE_USR4(("veda_tclClientVcan::vSendPhoneInfo"));
          if (_pCsmBase) {
            _pCsmBase->vSendPhoneDataToCluster(msg);

         }

}
//vSendXmInfo LongData
tVoid veda_tclClientVcan::vSendXMInfo(vehicle_fi_tcl_CAN_Mesg msg)
{
         ETG_TRACE_USR4(("veda_tclClientVcan::vSendXMInfo"));
         if (_pCsmBase) {
            _pCsmBase->vSendMeidaDataToCluster(msg);

         }

}
//vSendMainlineInfo LongData
tVoid veda_tclClientVcan::vSendMainlineInfo(vehicle_fi_tcl_CAN_Mesg msg)
{
         ETG_TRACE_USR4(("veda_tclClientVcan::vSendMainlineInfo"));
         if (_pCsmBase) {
            _pCsmBase->vSendMeidaDataToCluster(msg);

         }

}
tVoid veda_tclClientVcan::vSendCurrentStreetName(vehicle_fi_tcl_CAN_Mesg msg)
{
	 ETG_TRACE_USR4(("veda_tclClientVcan::vSendCurrentStreetName"));
	 TStreetInfo stNaviStreetmsg;
        stNaviStreetmsg.u8txtype = msg.u8MediaType;
        stNaviStreetmsg.list  = msg.listData;
          if (_pCsmBase) {
            _pCsmBase->vSendCurrentStreetInfoToCluster(stNaviStreetmsg);

         }
}
tVoid veda_tclClientVcan::vSendTurnToStreetNameInfo(vehicle_fi_tcl_CAN_Mesg msg)
{
	ETG_TRACE_USR4(("veda_tclClientVcan::vSendTurnToStreetNameInfo"));
	TStreetInfo stNaviStreetmsg;
         stNaviStreetmsg.u8txtype = msg.u8MediaType;
         stNaviStreetmsg.list  = msg.listData;
          if (_pCsmBase) {
            _pCsmBase->vSendTurnToStreetInfoToCluster(stNaviStreetmsg);

         }
}
tVoid veda_tclClientVcan::VSendDestinationInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg)
{
	ETG_TRACE_USR4(("veda_tclClientVcan::VSendDestinationInfo"));
	TNaviInfo stNavimsg;
	stNavimsg.list = msg.listData;
	if (_pCsmBase) {
            _pCsmBase->vSendDestinationInfoToCluster(stNavimsg);

         }
}
tVoid veda_tclClientVcan::VSendTurnToSymbolsInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg)
{
	ETG_TRACE_USR4(("veda_tclClientVcan::VSendTurnToSymbolsInfo"));
	TNaviInfo stNavimsg;
	stNavimsg.list = msg.listData;
	if (_pCsmBase) {
            _pCsmBase->vSendTurnToSymbolsInfoToCluster(stNavimsg);

         }
}
tVoid veda_tclClientVcan::VSendLaneGuidanceInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg)
{
	ETG_TRACE_USR4(("veda_tclClientVcan::VSendLaneGuidanceInfo"));
	TNaviInfo stNavimsg;
	stNavimsg.list = msg.listData;
	if (_pCsmBase) {
            _pCsmBase->vSendNaviLaneGuidanceInfoToCluster(stNavimsg);

         }
}
tVoid veda_tclClientVcan::VSendNaviWarningInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg)
{
	ETG_TRACE_USR4(("veda_tclClientVcan::VSendNaviWarningInfo"));
	TNaviInfo stNavimsg;
	stNavimsg.list = msg.listData;
	if (_pCsmBase) {
            _pCsmBase->vSendNaviWarningInfoToCluster(stNavimsg);

         }
}

tVoid veda_tclClientVcan::CheckandSendDatatoAdapter()
{
}
void veda_tclClientVcan::onHandBrakeSwitchStatus(THandBrakeSwitch tHandBrakeSwitch) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onHandBrakeSwitchStatus(): status: %08x, data: %d.", tHandBrakeSwitch.u32Status , tHandBrakeSwitch.HandBrakeSwitch));
   // veda_tclClientVcan::onHandBrakeSwitchStatus: user specific code start

	vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus oHandBrake;
	oHandBrake.enType = vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::FI_EN_UNKNOWN;

	if ( bIsSignalValid(tHandBrakeSwitch.u32Status) )
	{
	    switch (tHandBrakeSwitch.HandBrakeSwitch)
        {
		case VCAN_HANDBRAKE_OFF:
			oHandBrake.enType = vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::FI_EN_OFF;
			break;
		case VCAN_HANDBRAKE_ON:
 			oHandBrake.enType = vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::FI_EN_ON;
			break;
		default:
			oHandBrake.enType = vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::FI_EN_UNKNOWN;
			break;
		}
		
		ETG_TRACE_USR4(("veda_tclClientVcan::onHandBrakeSwitchStatus() received as %d", ETG_CENUM(enVCANHandBrake, oHandBrake.enType)));
		
		VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
		_poCCAServiceHdl->sendHandBrakeStatus(oHandBrake);
    }
 // veda_tclClientVcan::onHandBrakeSwitchStatus: user specific code end
}

void veda_tclClientVcan::onDistanceTotalizerStatus(TDistanceTotalizer tDistanceTotalizer) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onDistanceTotalizerStatus(): status: %08x, data: %d.", tDistanceTotalizer.u32Status , tDistanceTotalizer.DistanceTotalizer));
   // veda_tclClientVcan::onDistanceTotalizerStatus: user specific code start
   tU32 u32DisTotal = 0xffffffff;
   tU32 u32LastValidDisTotal = 0xffffffff;
   tBool bStatus = FALSE;

   if ( bIsSignalValid(tDistanceTotalizer.u32Status) )
   {
      bStatus = TRUE;
      u32DisTotal = (tU32) ((tDistanceTotalizer.DistanceTotalizer[3] << 24) | (tDistanceTotalizer.DistanceTotalizer[2] << 16) | 
                            (tDistanceTotalizer.DistanceTotalizer[1] << 8) | tDistanceTotalizer.DistanceTotalizer[0]);
   }
   if (u32DisTotal != 0xfffffff)
   {
      u32DisTotal /= 10;
      u32LastValidDisTotal = u32DisTotal;
      
      dp_tclVehDataDistanceTotalizer lastValidDistanceTotal;
      lastValidDistanceTotal << u32LastValidDisTotal;
   }
   else
   {
      u32DisTotal = 0xffffffff;

      dp_tclVehDataDistanceTotalizer lastValidDistanceTotal;
      lastValidDistanceTotal >> u32LastValidDisTotal;
   }
   
   ETG_TRACE_USR4(("veda_tclClientVcan::onDistanceTotalizerStatus Current %u.%u lastValidDistanceTotal %u.%u", u32DisTotal/10, u32DisTotal%10, u32LastValidDisTotal/10, u32LastValidDisTotal%10));

   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
   _poCCAServiceHdl->vUpdateDistanceTotal(u32DisTotal, u32LastValidDisTotal, bStatus);
   // veda_tclClientVcan::onDistanceTotalizerStatus: user specific code end
}

void veda_tclClientVcan::onDistanceUnitStatus(TDistanceUnit tDistanceUnit) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onDistanceUnitStatus(): status: %08x, data: %d.", tDistanceUnit.u32Status , tDistanceUnit.DistanceUnit));
   // veda_tclClientVcan::onDistanceUnitStatus: user specific code start
    tU8 u8DisTotalUnit = 0xFF;
    tBool bStatus = FALSE;

    if ( bIsSignalValid(tDistanceUnit.u32Status) )
    {
       bStatus = TRUE;
       u8DisTotalUnit = (tU8) (tDistanceUnit.DistanceUnit);
    }

    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->vUpdateDistanceTotalUnit(u8DisTotalUnit, bStatus);
   // veda_tclClientVcan::onDistanceUnitStatus: user specific code end
}

void veda_tclClientVcan::onAverage_Fuel_EconomyStatus(TAverage_Fuel_Economy tAverage_Fuel_Economy) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onAverage_Fuel_EconomyStatus(): status: %08x, data: %d.", tAverage_Fuel_Economy.u32Status , tAverage_Fuel_Economy.Average_Fuel_Economy));
   // veda_tclClientVcan::onAverage_Fuel_EconomyStatus: user specific code start
    tU32 u16FuelEcon = 0xFFFF;

    if ( bIsSignalValid(tAverage_Fuel_Economy.u32Status) )
    {
       u16FuelEcon = (tU16) ((tAverage_Fuel_Economy.Average_Fuel_Economy[1] << 8) | (tAverage_Fuel_Economy.Average_Fuel_Economy[0]));
    }

    ETG_TRACE_USR4(("veda_tclClientVcan::onAverage_Fuel_EconomyStatus received as = %u", u16FuelEcon));

    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendAvgFuelEconomyStatus(u16FuelEcon);
   // veda_tclClientVcan::onAverage_Fuel_EconomyStatus: user specific code end
}

void veda_tclClientVcan::onDiagMuxOnStatus(TDiagMuxOn tDiagMuxOn) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onDiagMuxOnStatus(): status: %08x, data: %d.", tDiagMuxOn.u32Status , tDiagMuxOn.DiagMuxOn));
   // veda_tclClientVcan::onDiagMuxOnStatus: user specific code start
    VEDA_NULL_POINTER_CHECK(_pCsmBase);
    if ( u8VCANDiversity == CANGEN_NISSAN_GEN5 )
    {
       if ( bIsSignalValid(tDiagMuxOn.u32Status) )
       {
          tBool bOldDiagMuxState = _bDiagMuxState;
          _bDiagMuxState = tDiagMuxOn.DiagMuxOn;

          if ( bOldDiagMuxState != _bDiagMuxState )
          {
             if ( _bDiagMuxState == TRUE ) // CSM Fault Handling for Category D ECU's should not be masked
             {
                // re init network management
               // _pCsmBase->vReinitCsmNetworkManagement();

                ETG_TRACE_USR1(("veda_tclClientVcan::onDiagMuxOnStatus Cat D Faults Un-masked"));
             }
             else // DiagMux is OFF, Mask all Category D faults
             {
                ETG_TRACE_USR1(("veda_tclClientVcan::onDiagMuxOnStatus Cat D Faults Masked"));
             }

             // Force Read only if the Registration is already completed
             if ( _bNodeFaultCallbackRegistered == TRUE )
             {
                vReadAllNodeFaultStates(FALSE);
             }
          }
       }
       else // Frame is missing, Mask all Category D faults
       {
           if ( FALSE != _bDiagMuxState )
           {
               ETG_TRACE_USR1(("veda_tclClientVcan::onDiagMuxOnStatus Cat D Faults Masked"));

               _bDiagMuxState = FALSE;

               // Force Read only if the Registration is already completed
               if (_bNodeFaultCallbackRegistered == TRUE)
               {
                   vReadAllNodeFaultStates(FALSE);
               }
           }
       }
    }
   // veda_tclClientVcan::onDiagMuxOnStatus: user specific code end
}

void veda_tclClientVcan::onDiagMuxOn_84Status(TDiagMuxOn_84 tDiagMuxOn_84) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onDiagMuxOn_84Status(): status: %08x, data: %d.", tDiagMuxOn_84.u32Status , tDiagMuxOn_84.DiagMuxOn_84));
   // veda_tclClientVcan::onDiagMuxOn_84Status: user specific code start
    VEDA_NULL_POINTER_CHECK(_pCsmBase);
    if ( u8VCANDiversity == CANGEN_NISSAN_GEN3 )
    {
       if ( bIsSignalValid(tDiagMuxOn_84.u32Status) )
       {
          tBool bOldDiagMuxState = _bDiagMuxState;
          _bDiagMuxState = tDiagMuxOn_84.DiagMuxOn_84;

          if ( bOldDiagMuxState != _bDiagMuxState )
          {
             if ( _bDiagMuxState == TRUE )  // CSM Fault Handling for Category D ECU's should not be masked
             {
                // re init network management
                //_pCsmBase->vReinitCsmNetworkManagement();

                ETG_TRACE_USR1(("veda_tclClientVcan::onDiagMuxOnStatus Cat D Faults Un-masked"));
             }
             else // DiagMux is OFF, Mask all Category D faults
             {
                ETG_TRACE_USR1(("veda_tclClientVcan::onDiagMuxOnStatus Cat D Faults Masked"));
             }

             // Force Read only if the Registration is already completed
             if (_bNodeFaultCallbackRegistered == TRUE)
             {
                vReadAllNodeFaultStates(FALSE);
             }
          }
       }
       else // Frame is missing, Mask all Category D faults
       {
           if ( FALSE != _bDiagMuxState )
           {
               ETG_TRACE_USR1(("veda_tclClientVcan::onDiagMuxOnStatus Cat D Faults Masked"));

               _bDiagMuxState = FALSE;

               // Force Read only if the Registration is already completed
               if (_bNodeFaultCallbackRegistered == TRUE)
               {
                   vReadAllNodeFaultStates(FALSE);
               }
           }
       }
    }
   // veda_tclClientVcan::onDiagMuxOn_84Status: user specific code end
}

void veda_tclClientVcan::onGADEStatus(TGADE tGADE) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onGADEStatus(): status: %08x, data: %d.", tGADE.u32Status , tGADE.GADE));
   // veda_tclClientVcan::onGADEStatus: user specific code start
    VEDA_NULL_POINTER_CHECK(_pCsmBase);
    if ( u8VCANDiversity == CANGEN_C1A )
    {
       tU8 OldGade;
       if ( bIsSignalValid(tGADE.u32Status) )
       {
           OldGade = u8GADEState;
           u8GADEState = tGADE.GADE;

           if (u8GADEState != OldGade)
           {
       		   // re init network management
       		   //_pCsmBase->vReinitCsmNetworkManagement();

       		   ETG_TRACE_USR1(("veda_tclClientVcan::onGADEStatus"));

       		   // Force Read only if the Registration is already completed
       		   if (_bNodeFaultCallbackRegistered == TRUE)
       		   {
       			   vReadAllNodeFaultStates(FALSE);
       		   }
       	   //}
          }
          else
          {
             ETG_TRACE_USR1(("veda_tclClientVcan::onGADEStatus"));
          }
       }
       // Feedback from Tobias is pending regarding handling of DTC during invalid status for GADE.
       /*
       else
       {
           ETG_TRACE_USR1(("veda_tclClientVcan::onGADEStatus"));

           // Force Read only if the Registration is already completed
           if (_bNodeFaultCallbackRegistered == TRUE)
           {
               vReadAllNodeFaultStates(FALSE);
           }
       }*/
    }
   // veda_tclClientVcan::onGADEStatus: user specific code end
}

void veda_tclClientVcan::onRearGearEngagedStatus(TRearGearEngaged tRearGearEngaged) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onRearGearEngagedStatus(): status: %08x, data: %d.", tRearGearEngaged.u32Status , tRearGearEngaged.RearGearEngaged));
   // veda_tclClientVcan::onRearGearEngagedStatus: user specific code start

    tU8 u8ReverseGear;
    u8ReverseGear = 0;

    if ( bIsSignalValid(tRearGearEngaged.u32Status) )
    {
    	u8ReverseGear = tRearGearEngaged.RearGearEngaged;
    }

    ETG_TRACE_USR4(("veda_tclClientVcan::onRearGearEngagedStatus() received as %d", u8ReverseGear));

    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendReverseGearCANStatus(u8ReverseGear);

   // veda_tclClientVcan::onRearGearEngagedStatus: user specific code end
}

void veda_tclClientVcan::onOSPOverSpeedDisplayRequestStatus(TOSPOverSpeedDisplayRequest tOSPOverSpeedDisplayRequest) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onOSPOverSpeedDisplayRequestStatus(): status: %08x, data: %d.", tOSPOverSpeedDisplayRequest.u32Status , tOSPOverSpeedDisplayRequest.OSPOverSpeedDisplayRequest));
   // veda_tclClientVcan::onOSPOverSpeedDisplayRequestStatus: user specific code start
    tU8 u8OSPDisplay = 0x00;

    if ( u32ConfigMask & VD_FEATURE_TSR_AVAILABLE )
    {
        if ( bIsSignalValid(tOSPOverSpeedDisplayRequest.u32Status) ) {
            if ( 0x01 == tOSPOverSpeedDisplayRequest.OSPOverSpeedDisplayRequest ) {
                u8OSPDisplay = 0x02;
            }
        }
    }

    ETG_TRACE_USR4(("veda_tclClientVcan::onOSPOverSpeedDisplayRequestStatus() u8OSPDisplay %u", u8OSPDisplay));

    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->vUpdateSpeedLimitDisplay(u8OSPDisplay);
   // veda_tclClientVcan::onOSPOverSpeedDisplayRequestStatus: user specific code end
}

void veda_tclClientVcan::onOSPSpeedUnitStatus(TOSPSpeedUnit tOSPSpeedUnit) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onOSPSpeedUnitStatus(): status: %08x, data: %d.", tOSPSpeedUnit.u32Status , tOSPSpeedUnit.OSPSpeedUnit));
   // veda_tclClientVcan::onOSPSpeedUnitStatus: user specific code start
    tU8 u8OSPSpeedUnit = 0xFF;

    if ( u32ConfigMask & VD_FEATURE_TSR_AVAILABLE )
    {
        if ( bIsSignalValid(tOSPSpeedUnit.u32Status) ) {
            if ( 0x00 == tOSPSpeedUnit.OSPSpeedUnit ) {
                u8OSPSpeedUnit = tOSPSpeedUnit.OSPSpeedUnit;
            } else if ( 0x01 == tOSPSpeedUnit.OSPSpeedUnit ) {
                u8OSPSpeedUnit = tOSPSpeedUnit.OSPSpeedUnit;
            } else {
                u8OSPSpeedUnit = 0xFF;
            }
        }
    }

    ETG_TRACE_USR4(("veda_tclClientVcan::onOSPOverSpeedDisplayRequestStatus() u8OSPSpeedUnit %u", u8OSPSpeedUnit));

    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->vUpdateSpeedLimitDisplay(u8OSPSpeedUnit);
   // veda_tclClientVcan::onOSPSpeedUnitStatus: user specific code end
}

void veda_tclClientVcan::onTSR_OSP_ActivationStatusStatus(TTSR_OSP_ActivationStatus tTSR_OSP_ActivationStatus) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onTSR_OSP_ActivationStatusStatus(): status: %08x, data: %d.", tTSR_OSP_ActivationStatus.u32Status , tTSR_OSP_ActivationStatus.TSR_OSP_ActivationStatus));
   // veda_tclClientVcan::onTSR_OSP_ActivationStatusStatus: user specific code start
    if ( u32ConfigMask & VD_FEATURE_TSR_AVAILABLE )
    {

    }
   // veda_tclClientVcan::onTSR_OSP_ActivationStatusStatus: user specific code end
}

void veda_tclClientVcan::onMeterLanguageKnowledgeStatus(TMeterLanguageKnowledge tMeterLanguageKnowledge) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onMeterLanguageKnowledgeStatus(): status: %08x, data: %d.", tMeterLanguageKnowledge.u32Status , tMeterLanguageKnowledge.MeterLanguageKnowledge));
   // veda_tclClientVcan::onMeterLanguageKnowledgeStatus: user specific code start
   tU8 u8MeterLanguage = 0;
   
   vSendMeterLanguageSyncMenuUpdate(METER_LANG_SYNC_MENU_NO_REQUEST);
   
   if ( bIsSignalValid(tMeterLanguageKnowledge.u32Status) )
   {
      u8MeterLanguage = tMeterLanguageKnowledge.MeterLanguageKnowledge;
   }

   vehicle_fi_tcl_e8_Meter_LangKnowledge oLangKnowledge;   
   oLangKnowledge.enType = static_cast<vehicle_fi_tcl_e8_Meter_LangKnowledge::tenType>(u8MeterLanguage);
   
   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
   _poCCAServiceHdl->sendMeterLanguageKnowledgeStatus(oLangKnowledge);
   // veda_tclClientVcan::onMeterLanguageKnowledgeStatus: user specific code end
}

void veda_tclClientVcan::onMeterLanguageStatusStatus(TMeterLanguageStatus tMeterLanguageStatus) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onMeterLanguageStatusStatus(): status: %08x, data: %d.", tMeterLanguageStatus.u32Status , tMeterLanguageStatus.MeterLanguageStatus));
   // veda_tclClientVcan::onMeterLanguageStatusStatus: user specific code start
   if (( _u8Value_MeterLangStatus != tMeterLanguageStatus.MeterLanguageStatus ) 
      || ( _u32Status_MeterLangStatus != tMeterLanguageStatus.u32Status ))
   {
      _u8Value_MeterLangStatus = tMeterLanguageStatus.MeterLanguageStatus;
      _u32Status_MeterLangStatus = tMeterLanguageStatus.u32Status;
      tU8 u8MeterLanguage = 0;
      
      veda_tclBaseIf::TMsg pMsg;
      (tVoid)memset((tVoid*)&pMsg, OSAL_NULL, sizeof(pMsg));
      pMsg.eCmd = veda_tclBaseIf::eSetLanguage;
      strncpy(pMsg.strClassName, "veda_tclLanguageHandler", sizeof("veda_tclLanguageHandler"));
      pMsg.u.au8Data[0] = static_cast<tU8>(METER);
      
      if ( bIsSignalValid(_u32Status_MeterLangStatus) )
      {
         u8MeterLanguage = _u8Value_MeterLangStatus;
      }
      
      pMsg.u.au8Data[1] = u8MeterLanguage;
      
      _cpoMain->theServer()->vPostInternalMessage(&pMsg);       
   }
   // veda_tclClientVcan::onMeterLanguageStatusStatus: user specific code end
}

void veda_tclClientVcan::onUnitDistanceDisplayStateStatus(TUnitDistanceDisplayState tUnitDistanceDisplayState) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onUnitDistanceDisplayStateStatus(): status: %08x, data: %d.", tUnitDistanceDisplayState.u32Status , tUnitDistanceDisplayState.UnitDistanceDisplayState));
   // veda_tclClientVcan::onUnitDistanceDisplayStateStatus: user specific code start
   // clear the previous sent request if any
   vSendUnitDistanceDisplayRequestUpdate(UNIT_DISTANCE_NO_REQUEST);

   static vehicle_fi_tcl_e8_Vehicle_DistanceUnit oDistanceUnit;
   
   if ( bIsSignalValid(tUnitDistanceDisplayState.u32Status) )
   {
      if ( 0x00 == tUnitDistanceDisplayState.UnitDistanceDisplayState )
      {
         oDistanceUnit.enType = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_KM;
		  ETG_TRACE_USR4(("veda_tclClientVcan::onUnitDistanceDisplayStateStatus():data: %d.", oDistanceUnit.enType));
      }
      else if ( 0x01 == tUnitDistanceDisplayState.UnitDistanceDisplayState )
      {
         oDistanceUnit.enType = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_MILES;
		  ETG_TRACE_USR4(("veda_tclClientVcan::onUnitDistanceDisplayStateStatus():data: %d.", oDistanceUnit.enType));
      }
      else // default value
      {
          ETG_TRACE_USR4(("veda_tclClientVcan::onUnitDistanceDisplayStateStatus():data: %d.", oDistanceUnit.enType));
      }
      VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
      _poCCAServiceHdl->sendDistanceUnitStatus(oDistanceUnit);
   }
   
   // veda_tclClientVcan::onUnitDistanceDisplayStateStatus: user specific code end
}

void veda_tclClientVcan::onReset_TPMS_answer_backStatus(TReset_TPMS_answer_back tReset_TPMS_answer_back) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onReset_TPMS_answer_backStatus(): status: %08x, data: %d.", tReset_TPMS_answer_back.u32Status , tReset_TPMS_answer_back.Reset_TPMS_answer_back));
   // veda_tclClientVcan::onReset_TPMS_answer_backStatus: user specific code start
 
    if (u32ConfigMask & VD_FEATURE_TPMS) // TPMS Configuration Value equal to OFF (with V-CAN Communication)
   {
      vehicle_fi_tcl_e8_Vehicle_TPMSReset oTPMSReset;
	  if ( bIsSignalValid(tReset_TPMS_answer_back.u32Status))
	  {
		if (0x00 == tReset_TPMS_answer_back.Reset_TPMS_answer_back)
			oTPMSReset.enType = vehicle_fi_tcl_e8_Vehicle_TPMSReset::FI_EN_NOT_SUPPORT_THIS_FUNCTION;
		else if (0x01 == tReset_TPMS_answer_back.Reset_TPMS_answer_back)
			oTPMSReset.enType = vehicle_fi_tcl_e8_Vehicle_TPMSReset::FI_EN_SUPPORT;
		else if (0x02 == tReset_TPMS_answer_back.Reset_TPMS_answer_back)
			oTPMSReset.enType = vehicle_fi_tcl_e8_Vehicle_TPMSReset::FI_EN_SUPPORT_AND_RESET;
		else if (0x03 == tReset_TPMS_answer_back.Reset_TPMS_answer_back)
			oTPMSReset.enType = vehicle_fi_tcl_e8_Vehicle_TPMSReset::FI_EN_NO_DEFINITION;
		
		VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
		_poCCAServiceHdl->sendTPMSResetSupportStatus(oTPMSReset);
	    
		if (_bTPMSRequestFlag && _u8TwoSecondTimerCount < 2)
		{
			_poCCAServiceHdl->sendTPMSResetSupportStatus(oTPMSReset);
			_bTPMSRequestFlag = FALSE;
		}
	  }
   }
   
   // veda_tclClientVcan::onReset_TPMS_answer_backStatus: user specific code end
}

void veda_tclClientVcan::onSelect_pressure_supportStatus(TSelect_pressure_support tSelect_pressure_support) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onSelect_pressure_supportStatus(): status: %08x, data: %d.", tSelect_pressure_support.u32Status , tSelect_pressure_support.Select_pressure_support));
   // veda_tclClientVcan::onSelect_pressure_supportStatus: user specific code start
   if (u32ConfigMask & VD_FEATURE_TPMS) // TPMS Configuration Value equal to OFF (with V-CAN Communication)
   {
      tBool TirePressureSupport;
	  if ( bIsSignalValid(tSelect_pressure_support.u32Status) )
	  {
		TirePressureSupport = (tBool)tSelect_pressure_support.Select_pressure_support;
		VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
		_poCCAServiceHdl->sendTirePressureSupportStatus(TirePressureSupport);						
	  }
   }
   // veda_tclClientVcan::onSelect_pressure_supportStatus: user specific code end
}

void veda_tclClientVcan::onSetting_pressure_Front_answer_backStatus(TSetting_pressure_Front_answer_back tSetting_pressure_Front_answer_back) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onSetting_pressure_Front_answer_backStatus(): status: %08x, data: %d.", tSetting_pressure_Front_answer_back.u32Status , tSetting_pressure_Front_answer_back.Setting_pressure_Front_answer_back));
   // veda_tclClientVcan::onSetting_pressure_Front_answer_backStatus: user specific code start
    tU16 u16FrontPressureStatus;
	tU16 u16RearPressureStatus = 0xFFFF;
	if (u32ConfigMask & VD_FEATURE_TPMS) // TPMS Configuration Value equal to OFF (with V-CAN Communication)
    {
	  if ( bIsSignalValid(tSetting_pressure_Front_answer_back.u32Status))
	  {
		  u16FrontPressureStatus = (tU16)tSetting_pressure_Front_answer_back.Setting_pressure_Front_answer_back;
		  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
		 _poCCAServiceHdl->sendTirePressureSettingStatus(u16FrontPressureStatus,u16RearPressureStatus);						
	  }
	}
   // veda_tclClientVcan::onSetting_pressure_Front_answer_backStatus: user specific code end
}

void veda_tclClientVcan::onSetting_pressure_Rear_answer_backStatus(TSetting_pressure_Rear_answer_back tSetting_pressure_Rear_answer_back) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onSetting_pressure_Rear_answer_backStatus(): status: %08x, data: %d.", tSetting_pressure_Rear_answer_back.u32Status , tSetting_pressure_Rear_answer_back.Setting_pressure_Rear_answer_back));
   // veda_tclClientVcan::onSetting_pressure_Rear_answer_backStatus: user specific code start
   
    tU16 u16FrontPressureStatus = 0xFFFF;
	tU16 u16RearPressureStatus;
	if (u32ConfigMask & VD_FEATURE_TPMS) // TPMS Configuration Value equal to OFF (with V-CAN Communication)
	{
	  if ( bIsSignalValid(tSetting_pressure_Rear_answer_back.u32Status))
	  { 
		  u16RearPressureStatus = (tU16)tSetting_pressure_Rear_answer_back.Setting_pressure_Rear_answer_back;
		  VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
		  _poCCAServiceHdl->sendTirePressureSettingStatus(u16FrontPressureStatus,u16RearPressureStatus);						
	  }
	}
   // veda_tclClientVcan::onSetting_pressure_Rear_answer_backStatus: user specific code end
}

void veda_tclClientVcan::onGlobalVehicleWarningStateStatus(TGlobalVehicleWarningState tGlobalVehicleWarningState) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onGlobalVehicleWarningStateStatus(): status: %08x, data: %d.", tGlobalVehicleWarningState.u32Status , tGlobalVehicleWarningState.GlobalVehicleWarningState));
   // veda_tclClientVcan::onGlobalVehicleWarningStateStatus: user specific code start
   vehicle_fi_tcl_e8_Vehicle_WarningState oVehicleWarningState;

   if ( bIsSignalValid(tGlobalVehicleWarningState.u32Status))
   {
		if (0x00 == tGlobalVehicleWarningState.GlobalVehicleWarningState)
			oVehicleWarningState.enType = vehicle_fi_tcl_e8_Vehicle_WarningState::FI_EN_NO_GLOBAL_VEHICLE_FAULT;
		else if (0x01 == tGlobalVehicleWarningState.GlobalVehicleWarningState)
			oVehicleWarningState.enType = vehicle_fi_tcl_e8_Vehicle_WarningState::FI_EN_SERV_ON_R3;
		else if (0x02 == tGlobalVehicleWarningState.GlobalVehicleWarningState)
			oVehicleWarningState.enType = vehicle_fi_tcl_e8_Vehicle_WarningState::FI_EN_STOP_ON_D3;
		else if (0x03 == tGlobalVehicleWarningState.GlobalVehicleWarningState)
			oVehicleWarningState.enType = vehicle_fi_tcl_e8_Vehicle_WarningState::FI_EN_SERV_STOP_ON;

		VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
		_poCCAServiceHdl->sendGlobalVehicleWarningStateStatus(oVehicleWarningState);
   }

   // veda_tclClientVcan::onGlobalVehicleWarningStateStatus: user specific code end
}

void veda_tclClientVcan::onVehicleStatesStatus(TVehicleStates tVehicleStates) {
    ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleStatesStatus(): status: %08x, data: %d.", tVehicleStates.u32Status , tVehicleStates.VehicleStates));
   // veda_tclClientVcan::onVehicleStatesStatus: user specific code start

   vehicle_fi_tcl_e8_Vehicle_States oVehicleState;
   if ( bIsSignalValid(tVehicleStates.u32Status))
   {
 		switch(tVehicleStates.VehicleStates){
 		case 0x00:
 		{
 			oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_SLEEPING;
 			break;
 		}

 		case 0x01:
 		{
 		 	oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_TECHNICAL_WAKEUP;
 		 	break;
 		}

 		case 0x02:
 		{
 		 	oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_CUTOFFPENDING;
 		 	break;
 		}

 		case 0x03:
 		{
 		 	oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_AUTOACC;
 		 	break;
 		}

 		case 0x05:
 		{
 		 	oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_IGNITIONLEVEL;
 		 	break;
 		}

 		case 0x06:
 		{
 		 	oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_STARTINGINPROGRESS;
 		 	break;
 		}

 		case 0x07:
 		{
 		 	oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_POWERTRAINRUNNING;
 		 	break;
 		}

 		case 0x08:
 		{
 		 	oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_AUTOSTART;
 		 	break;
 		}

 		case 0x09:
 		{
 		 	oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_ENGINESYSTEMSTOP;
 		 	break;
 		}

 		case 0x0f:
 		{
 		 	oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_UNAVAILABLE;
 		 	break;
 		}

 		default:
 		{
 			oVehicleState.enType = vehicle_fi_tcl_e8_Vehicle_States::FI_EN_NOTUSED;
 			break;
 		}
 		}
 		VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
 		_poCCAServiceHdl->sendVehicleStatesStatus(oVehicleState);
   }
   // veda_tclClientVcan::onVehicleStatesStatus: user specific code end
}



tVoid veda_tclClientVcan::vGetSpeed_Limit_Display_Request() {
   TSpeed_Limit_Display_Request tMySpeed_Limit_Display_Request;
   if (_pCsmBase) {
       _pCsmBase->vGetSpeed_Limit_Display_Request(tMySpeed_Limit_Display_Request);
   }
   // veda_tclClientVcan::vGetSpeed_Limit_Display_Request: user specific code start
   // veda_tclClientVcan::vGetSpeed_Limit_Display_Request: user specific code end
}

tVoid veda_tclClientVcan::vGetNavi_display_speed_limit_1() {
   TNavi_display_speed_limit_1 tMyNavi_display_speed_limit_1;
   if (_pCsmBase) {
       _pCsmBase->vGetNavi_display_speed_limit_1(tMyNavi_display_speed_limit_1);
   }
   // veda_tclClientVcan::vGetNavi_display_speed_limit_1: user specific code start
   // veda_tclClientVcan::vGetNavi_display_speed_limit_1: user specific code end
}

tVoid veda_tclClientVcan::vGetNavi_display_speed_limit_2() {
   TNavi_display_speed_limit_2 tMyNavi_display_speed_limit_2;
   if (_pCsmBase) {
       _pCsmBase->vGetNavi_display_speed_limit_2(tMyNavi_display_speed_limit_2);
   }
   // veda_tclClientVcan::vGetNavi_display_speed_limit_2: user specific code start
   // veda_tclClientVcan::vGetNavi_display_speed_limit_2: user specific code end
}

tVoid veda_tclClientVcan::vGetIgnitionSupplyConfirmation() {
   TIgnitionSupplyConfirmation tMyIgnitionSupplyConfirmation;
   if (_pCsmBase) {
       _pCsmBase->vGetIgnitionSupplyConfirmation(tMyIgnitionSupplyConfirmation);
   }
   // veda_tclClientVcan::vGetIgnitionSupplyConfirmation: user specific code start
   // veda_tclClientVcan::vGetIgnitionSupplyConfirmation: user specific code end
}

//Fetches the Vehicle speed value after reading the value
tVoid veda_tclClientVcan::vGetVehicleSpeed() {
   TVehicleSpeed tMyVehicleSpeed;
   if (_pCsmBase) {
       _pCsmBase->vGetVehicleSpeed(tMyVehicleSpeed);
   }
}
//TCOVehiclespeed
tVoid veda_tclClientVcan::vGetTCOVehicleSpeed() {
   TTCOVehicleSpeed tMyTCOVehicleSpeed;
   if (_pCsmBase) {
       _pCsmBase->vGetTCOVehicleSpeed(tMyTCOVehicleSpeed);
   }
}
//Fetches the partial mute value after reading the value
tVoid veda_tclClientVcan::vGetPartialMuteValue(){
	TPartialMuteValue tMyPartialMuteValue;
	if (_pCsmBase) {
       _pCsmBase->vGetPartialMuteValue(tMyPartialMuteValue);
   }
}
//Fetches the Sviw Monitor status after reading the status
tVoid veda_tclClientVcan::vGetSwivMonAutoOpenValue(){
	TSwivMonAutoOpenValue tMySwivMonAutoOpenValue;
	if (_pCsmBase) {
       _pCsmBase->vGetSwivMonAutoOpenValue(tMySwivMonAutoOpenValue);
   }
}
//Fetches the current Date Mode Value after reading the value
tVoid veda_tclClientVcan::vGetDateModeValue(){
	TDateModeValue tMyDateModeValue;
	if (_pCsmBase) {
       _pCsmBase->vGetDateModeValue(tMyDateModeValue);
   }
}
//Fetches the current Time Mode value after reading the value
tVoid veda_tclClientVcan::vGetTmModeValue(){
	TTmModeValue tMyTmModeValue;
	if (_pCsmBase) {
       _pCsmBase->vGetTmModeValue(tMyTmModeValue);
   }
}
//camera
tVoid veda_tclClientVcan::vGetActCam1Value(){
	TActCam1Value tMyActCam1Value;
	if (_pCsmBase) {
       _pCsmBase->vGetActCam1Value(tMyActCam1Value);
   }
}
//camera2
tVoid veda_tclClientVcan::vGetActCam2Value(){
	TActCam2Value tMyActCam2Value;
	if (_pCsmBase) {
       _pCsmBase->vGetActCam2Value(tMyActCam2Value);
   }
}
//camera3
tVoid veda_tclClientVcan::vGetActCam3Value(){
	TActCam3Value tMyActCam3Value;
	if (_pCsmBase) {
       _pCsmBase->vGetActCam3Value(tMyActCam3Value);
   }
}
//camera4
tVoid veda_tclClientVcan::vGetActCam4Value(){
	TActCam4Value tMyActCam4Value;
	if (_pCsmBase) {
       _pCsmBase->vGetActCam4Value(tMyActCam4Value);
   }
}
//camera5
tVoid veda_tclClientVcan::vGetActCam5Value(){
	TActCam5Value tMyActCam5Value;
	if (_pCsmBase) {
       _pCsmBase->vGetActCam5Value(tMyActCam5Value);
   }
}
//camera6
tVoid veda_tclClientVcan::vGetActCam6Value(){
	TActCam6Value tMyActCam6Value;
	if (_pCsmBase) {
       _pCsmBase->vGetActCam6Value(tMyActCam6Value);
   }
}
//camera7
tVoid veda_tclClientVcan::vGetActCam7Value(){
	TActCam7Value tMyActCam7Value;
	if (_pCsmBase) {
       _pCsmBase->vGetActCam7Value(tMyActCam7Value);
   }
}
//camsplit
tVoid veda_tclClientVcan::vGetCamSplitQuadValue(){
	TCamSplitQuadValue tMyCamSplitQuadValue;
	if (_pCsmBase) {
       _pCsmBase->vGetCamSplitQuadValue(tMyCamSplitQuadValue);
   }
}
//MuteDev
tVoid veda_tclClientVcan::vGetMuteDevStatus(){
	TMuteDevStatus tMyMuteDevStatus;
	if (_pCsmBase) {
       _pCsmBase->vGetMuteDevStatus(tMyMuteDevStatus);
   }
}

//Fetches the current SysVolt value after reading the value
tVoid veda_tclClientVcan::vGetSysVoltStatus(){
	TSysVoltStatus tMySysVoltStatus;
	if (_pCsmBase) {
       _pCsmBase->vGetSysVoltStatus(tMySysVoltStatus);
   }
}
//Fetches the ParkingBreakSwitch value after reading the status
tVoid veda_tclClientVcan::vGetParkingBreakSwitchValue(){
	TParkingBreakSwitchValue tMyParkingBreakSwitchValue;
	if (_pCsmBase) {
       _pCsmBase->vGetParkingBreakSwitchValue(tMyParkingBreakSwitchValue);
   }
}

//Fetches the RearCamReq value after reading the status
tVoid veda_tclClientVcan::vGetRearCamReqValue(){
	TRearCamReqValue tMyRearCamReqValue;
	if (_pCsmBase) {
       _pCsmBase->vGetRearCamReqValue(tMyRearCamReqValue);
   }
}

//VIN
tVoid veda_tclClientVcan::vGetVINValue(){
	TVINValue tMyVINValue;
	if (_pCsmBase) {
       _pCsmBase->vGetVINValue(tMyVINValue);
   }
   // veda_tclClientVcan::vGetVINValue: user specific code start
   // veda_tclClientVcan::vGetVINValue: user specific code end
}


//TimeDate
tVoid veda_tclClientVcan::vGetTimeDateValue(){
	TTimeDateValue tMyTimeDateValue;
	if (_pCsmBase) {
       _pCsmBase->vGetTimeDateValue(tMyTimeDateValue);
   }

}

//PhoneCall Command
tVoid veda_tclClientVcan::vGetPhoneCallCmdValue(){
	TPhoneCallCommand tMyPhoneCallCommandValue;
	if (_pCsmBase) {
       _pCsmBase->vGetPhoneCallCmdValue(tMyPhoneCallCommandValue);
   }

}



//System Language
tVoid veda_tclClientVcan::vGetSystemLanguageValue(){
	TSystemLanguageValue tMySystemLanguageValue;
	if (_pCsmBase) {
       _pCsmBase->vGetSystemLanguageValue(tMySystemLanguageValue);
   }
}
//CurrLang
tVoid veda_tclClientVcan::vGetCurrLangValue(){
	TCurrLangValue tMyCurrLangValue;
	if (_pCsmBase) {
       _pCsmBase->vGetCurrLangValue(tMyCurrLangValue);
   }
}
//CamTxt
tVoid veda_tclClientVcan::vGetCamTxtValue(){
	TCamTxtValue tMyCamTxtValue;
	if (_pCsmBase) {
       _pCsmBase->vGetCamTxtValue(tMyCamTxtValue);
   }
}
tVoid veda_tclClientVcan::vGetHandBrakeSwitch() {
   THandBrakeSwitch tMyHandBrakeSwitch;
   if (_pCsmBase) {
       _pCsmBase->vGetHandBrakeSwitch(tMyHandBrakeSwitch);
       _pCsmBase->vGetHandBrakeSwitch(tMyHandBrakeSwitch);
   }
   // veda_tclClientVcan::vGetHandBrakeSwitch: user specific code start
   // veda_tclClientVcan::vGetHandBrakeSwitch: user specific code end
}

tVoid veda_tclClientVcan::vGetDistanceTotalizer() {
   TDistanceTotalizer tMyDistanceTotalizer;
   if (_pCsmBase) {
       _pCsmBase->vGetDistanceTotalizer(tMyDistanceTotalizer);
   }
   // veda_tclClientVcan::vGetDistanceTotalizer: user specific code start
   // veda_tclClientVcan::vGetDistanceTotalizer: user specific code end
}

tVoid veda_tclClientVcan::vGetDistanceUnit() {
   TDistanceUnit tMyDistanceUnit;
   if (_pCsmBase) {
       _pCsmBase->vGetDistanceUnit(tMyDistanceUnit);
   }
   // veda_tclClientVcan::vGetDistanceUnit: user specific code start
   // veda_tclClientVcan::vGetDistanceUnit: user specific code end
}

tVoid veda_tclClientVcan::vGetAverage_Fuel_Economy() {
   TAverage_Fuel_Economy tMyAverage_Fuel_Economy;
   if (_pCsmBase) {
       _pCsmBase->vGetAverage_Fuel_Economy(tMyAverage_Fuel_Economy);
   }
   // veda_tclClientVcan::vGetAverage_Fuel_Economy: user specific code start
   // veda_tclClientVcan::vGetAverage_Fuel_Economy: user specific code end
}

tVoid veda_tclClientVcan::vGetDiagMuxOn() {
   TDiagMuxOn tMyDiagMuxOn;
   if (_pCsmBase) {
       _pCsmBase->vGetDiagMuxOn(tMyDiagMuxOn);
   }
   // veda_tclClientVcan::vGetDiagMuxOn: user specific code start
   // veda_tclClientVcan::vGetDiagMuxOn: user specific code end
}

tVoid veda_tclClientVcan::vGetDiagMuxOn_84() {
   TDiagMuxOn_84 tMyDiagMuxOn_84;
   if (_pCsmBase) {
       _pCsmBase->vGetDiagMuxOn_84(tMyDiagMuxOn_84);
   }
   // veda_tclClientVcan::vGetDiagMuxOn_84: user specific code start
   // veda_tclClientVcan::vGetDiagMuxOn_84: user specific code end
}

tVoid veda_tclClientVcan::vGetGADE() {
   TGADE tMyGADE;
   if (_pCsmBase) {
       _pCsmBase->vGetGADE(tMyGADE);
   }
   // veda_tclClientVcan::vGetGADE: user specific code start
   // veda_tclClientVcan::vGetGADE: user specific code end
}

tVoid veda_tclClientVcan::vGetRearGearEngaged() {
   TRearGearEngaged tMyRearGearEngaged;
   if (_pCsmBase) {
       _pCsmBase->vGetRearGearEngaged(tMyRearGearEngaged);
   }
   // veda_tclClientVcan::vGetRearGearEngaged: user specific code start
   // veda_tclClientVcan::vGetRearGearEngaged: user specific code end
}

tVoid veda_tclClientVcan::vGetOSPOverSpeedDisplayRequest() {
   TOSPOverSpeedDisplayRequest tMyOSPOverSpeedDisplayRequest;
   if (_pCsmBase) {
       _pCsmBase->vGetOSPOverSpeedDisplayRequest(tMyOSPOverSpeedDisplayRequest);
   }
   // veda_tclClientVcan::vGetOSPOverSpeedDisplayRequest: user specific code start
   // veda_tclClientVcan::vGetOSPOverSpeedDisplayRequest: user specific code end
}

tVoid veda_tclClientVcan::vGetOSPSpeedUnit() {
   TOSPSpeedUnit tMyOSPSpeedUnit;
   if (_pCsmBase) {
       _pCsmBase->vGetOSPSpeedUnit(tMyOSPSpeedUnit);
   }
   // veda_tclClientVcan::vGetOSPSpeedUnit: user specific code start
   // veda_tclClientVcan::vGetOSPSpeedUnit: user specific code end
}

tVoid veda_tclClientVcan::vGetTSR_OSP_ActivationStatus() {
   TTSR_OSP_ActivationStatus tMyTSR_OSP_ActivationStatus;
   if (_pCsmBase) {
       _pCsmBase->vGetTSR_OSP_ActivationStatus(tMyTSR_OSP_ActivationStatus);
   }
   // veda_tclClientVcan::vGetTSR_OSP_ActivationStatus: user specific code start
   // veda_tclClientVcan::vGetTSR_OSP_ActivationStatus: user specific code end
}

tVoid veda_tclClientVcan::vGetMeterLanguageKnowledge() {
   TMeterLanguageKnowledge tMyMeterLanguageKnowledge;
   if (_pCsmBase) {
       _pCsmBase->vGetMeterLanguageKnowledge(tMyMeterLanguageKnowledge);
   }
   // veda_tclClientVcan::vGetMeterLanguageKnowledge: user specific code start
   // veda_tclClientVcan::vGetMeterLanguageKnowledge: user specific code end
}

tVoid veda_tclClientVcan::vGetMeterLanguageStatus() {
   TMeterLanguageStatus tMyMeterLanguageStatus;
   if (_pCsmBase) {
       _pCsmBase->vGetMeterLanguageStatus(tMyMeterLanguageStatus);
   }
   // veda_tclClientVcan::vGetMeterLanguageStatus: user specific code start
   // veda_tclClientVcan::vGetMeterLanguageStatus: user specific code end
}

tVoid veda_tclClientVcan::vGetUnitDistanceDisplayState() {
   TUnitDistanceDisplayState tMyUnitDistanceDisplayState;
   if (_pCsmBase) {
       _pCsmBase->vGetUnitDistanceDisplayState(tMyUnitDistanceDisplayState);
   }
   // veda_tclClientVcan::vGetUnitDistanceDisplayState: user specific code start
   // veda_tclClientVcan::vGetUnitDistanceDisplayState: user specific code end
}

tVoid veda_tclClientVcan::vGetReset_TPMS_answer_back() {
   TReset_TPMS_answer_back tMyReset_TPMS_answer_back;
   if (_pCsmBase) {
       _pCsmBase->vGetReset_TPMS_answer_back(tMyReset_TPMS_answer_back);
   }
   // veda_tclClientVcan::vGetReset_TPMS_answer_back: user specific code start
   // veda_tclClientVcan::vGetReset_TPMS_answer_back: user specific code end
}

tVoid veda_tclClientVcan::vGetSelect_pressure_support() {
   TSelect_pressure_support tMySelect_pressure_support;
   if (_pCsmBase) {
       _pCsmBase->vGetSelect_pressure_support(tMySelect_pressure_support);
   }
   // veda_tclClientVcan::vGetSelect_pressure_support: user specific code start
   // veda_tclClientVcan::vGetSelect_pressure_support: user specific code end
}

tVoid veda_tclClientVcan::vGetSetting_pressure_Front_answer_back() {
   TSetting_pressure_Front_answer_back tMySetting_pressure_Front_answer_back;
   if (_pCsmBase) {
       _pCsmBase->vGetSetting_pressure_Front_answer_back(tMySetting_pressure_Front_answer_back);
   }
   // veda_tclClientVcan::vGetSetting_pressure_Front_answer_back: user specific code start
   // veda_tclClientVcan::vGetSetting_pressure_Front_answer_back: user specific code end
}

tVoid veda_tclClientVcan::vGetSetting_pressure_Rear_answer_back() {
   TSetting_pressure_Rear_answer_back tMySetting_pressure_Rear_answer_back;
   if (_pCsmBase) {
       _pCsmBase->vGetSetting_pressure_Rear_answer_back(tMySetting_pressure_Rear_answer_back);
   }
   // veda_tclClientVcan::vGetSetting_pressure_Rear_answer_back: user specific code start
   // veda_tclClientVcan::vGetSetting_pressure_Rear_answer_back: user specific code end
}

tVoid veda_tclClientVcan::vGetGlobalVehicleWarningState() {
   TGlobalVehicleWarningState tMyGlobalVehicleWarningState;
   if (_pCsmBase) {
       _pCsmBase->vGetGlobalVehicleWarningState(tMyGlobalVehicleWarningState);
   }
   // veda_tclClientVcan::vGetGlobalVehicleWarningState: user specific code start
   // veda_tclClientVcan::vGetGlobalVehicleWarningState: user specific code end
}

tVoid veda_tclClientVcan::vGetVehicleStates() {
   TVehicleStates tMyVehicleStates;
   if (_pCsmBase) {
       _pCsmBase->vGetVehicleStates(tMyVehicleStates);
   }
   // veda_tclClientVcan::vGetVehicleStates: user specific code start
   // veda_tclClientVcan::vGetVehicleStates: user specific code end
}


// veda_tclClientVcan::ClassImplementation: user specific code start
bool veda_tclClientVcan::bIsSignalValid(const tU32 u32Status) const
{
   if (! (u32Status & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED)))
   {
      return true;
   }
   else
   {
      return false;
   }
}

tVoid veda_tclClientVcan::vHandleAllNodeFaultRegistration(tVoid)
{
   VEDA_NULL_POINTER_CHECK(_pCsmBase);
   tU32 u32Config = u32ConfigMask;

   // VCAN Bus State
   tU8 u8DiaIndex = VEDA_DIAG_BUS_OFF_VCAN__;
   if ( (tConfig[u8DiaIndex].u32FeatureMask & u32Config) == tConfig[u8DiaIndex].u32FeatureMask )
   {
      tU8 u8FaultStatus = BUS_FAULT_CONFIRMED;
      tBool bInitializationError = FALSE;

      if ( _pCsmBase->_bRegisterForBusOffErrorIndication(tConfig[u8DiaIndex].u8AddrField, bInitializationError) )
      {
         _bVCANInitializationError = bInitializationError;
         if ( !bInitializationError )
         {
            u8FaultStatus = BUS_FAULT_INACTIVE;
         }
      }

      vHandleCsmFaultIndication(VEDA_DIAG_VCAN_INIT_____, u8FaultStatus, FALSE);
   }

   // MCAN Bus State
   u8DiaIndex = VEDA_DIAG_BUS_OFF_MCAN__;
   if ( (tConfig[u8DiaIndex].u32FeatureMask & u32Config) == tConfig[u8DiaIndex].u32FeatureMask )
   {
      tU8 u8FaultStatus = BUS_FAULT_CONFIRMED;
      tBool bInitializationError = FALSE;

      if ( _pCsmBase->_bRegisterForBusOffErrorIndication(tConfig[u8DiaIndex].u8AddrField, bInitializationError) )
      {
         _bMCANInitializationError = bInitializationError;
         if ( !bInitializationError )
         {
            u8FaultStatus = BUS_FAULT_INACTIVE;
         }
      }

      vHandleCsmFaultIndication(VEDA_DIAG_MCAN_INIT_____, u8FaultStatus, FALSE);
   }

   // Delegate the registration and Force read for all the nodes
   vRegisterNodeFaultStates();

   _bNodeFaultCallbackRegistered = TRUE;
}

tVoid veda_tclClientVcan::vRegisterNodeFaultStates(tVoid) const
{
   VEDA_NULL_POINTER_CHECK(_pCsmBase);
   for (tU8 i = VD_DIAG_FAULTNODE_START; i <= VD_DIAG_FAULTNODE_END; i++)
   {
      tU8 u8Bus;
      tBool bInitError = TRUE;
      tU32 u32CurrentMask = tConfig[i].u32FeatureMask;
      tU32 u32Config = u32ConfigMask;

      if ( tConfig[i].u8Bus == VCAN )
      {
         u8Bus = CSM_C_CAN_BUS_VCAN;
         bInitError = _bVCANInitializationError;
      }
      else if ( tConfig[i].u8Bus == MCAN )
      {
         u8Bus = CSM_C_CAN_BUS_MCAN;
         bInitError = _bMCANInitializationError;
      }
      else
      {
         u8Bus = 0xFF;
         bInitError = TRUE;
      }

      // is the feature configured ?
      if ( ( (u32Config & u32CurrentMask) == u32CurrentMask ) && !bInitError )
      {
         if ( tConfig[i].u8IndicationType == BUS_RX_STATE )
         {
            _pCsmBase->_bRegisterForRxBusErrorIndication(u8Bus, tConfig[i].u8AddrField);
         }
         else if ( tConfig[i].u8IndicationType == BUS_TX_STATE )
         {
            _pCsmBase->_bRegisterForTxBusErrorIndication(u8Bus, tConfig[i].u8AddrField);
         }
      }
      else
      {
         ETG_TRACE_USR1(("vRegisterNodeFaultStates() Feature %u not configured !!", ETG_CENUM(tenDiagTMapIndex, i)));
      }
   }
}
 //Driver door open status
void veda_tclClientVcan::onVehicleDriverDoorOpenStatus(TDriverDoorstatusCmd tDriverDoorstatusCmd)
{
   ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleDriverDoorOpenStatus(): data: %d.",tDriverDoorstatusCmd.u32Status));
   _u32Driverdoorstatus = tDriverDoorstatusCmd.u32Status;
    if(  bIsSignalValid(_u32Driverdoorstatus))
    {
	_u8driverdoorstatus = (tU8) ((tDriverDoorstatusCmd.DriverDoorstatusCmdValue));
       ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleDriverDoorOpenStatus(): _u8driverdoorstatus is  %d",_u8driverdoorstatus));
    }
    else
    {
       ETG_TRACE_USR4(("veda_tclClientVcan::onVehicleDriverDoorOpenStatus() status is invalid"));
       _u8driverdoorstatus = 0xFF;
    }
     VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    _poCCAServiceHdl->sendVehicleDriverDoorOpenStatus(_u8driverdoorstatus);
}

tVoid veda_tclClientVcan::vReadAllNodeFaultStates(const tBool bForceUpdate)
{
   VEDA_NULL_POINTER_CHECK(_pCsmBase);
   VEDA_NULL_POINTER_CHECK(_pu8CANNodeFaultState);

   // Update all the Diag Bytes
   for (tU8 u8DiagIndex = 0; u8DiagIndex < VEDA_DIAG_LAST; u8DiagIndex++)
   {
      //ETG_TRACE_USR1(("vReadAllNodeFaultStates(): Read Current state of u8DiagIndex %u ", ETG_CENUM(tenDiagTMapIndex, u8DiagIndex)));
      tU8 u8Bus;
      tU8 u8FaultState = BUS_FAULT_UNKNOWN;
      tU32 u32CurrentMask = tConfig[u8DiagIndex].u32FeatureMask;
      tBool bUpdateCatDFaults = FALSE;

      // Feature enabled ?
      if ( u32CurrentMask == (u32CurrentMask & u32ConfigMask) )
      {
         // Bus Init State
         tBool bInitState = TRUE;

         if ( tConfig[u8DiagIndex].u8Bus == VCAN )
         {
            u8Bus = CSM_C_CAN_BUS_VCAN;
            bInitState = _bVCANInitializationError;
         }
         else if ( tConfig[u8DiagIndex].u8Bus == MCAN )
         {
            u8Bus = CSM_C_CAN_BUS_MCAN;
            bInitState = _bMCANInitializationError;
         }
         else
         {
            u8Bus = 0xFF;
            bInitState = TRUE;
         }

         switch ( u8DiagIndex )
         {
         // Category C Faults
         case VEDA_DIAG_BUS_OFF_VCAN__:
         case VEDA_DIAG_BUS_OFF_MCAN__:
         {
             if ( ( !_bIsCANFaultCategoryC_Masked() ) && ( !bInitState )) // Category-C Not Masked
             {
                 _pCsmBase->_bCheckCommunicationState_BusOff(tConfig[u8DiagIndex].u8AddrField, u8FaultState);
             }
             else // Category-C Masked
             {
                 u8FaultState = BUS_FAULT_UNKNOWN;
             }
         }
         break;

         case VEDA_DIAG_MUTE_VCAN_____:
         {
             if ( !_bIsCANFaultCategoryC_Masked() ) // Category-C Not Masked
             {
                 _pCsmBase->_bCheckCommunicationState_TX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
             }
             else // Category-C Masked
             {
                 u8FaultState = BUS_FAULT_UNKNOWN;
             }
         }
         break;

         case VEDA_DIAG_ECU_USM_224___:
         {
        	 if ((u8VCANDiversity == CANGEN_NISSAN_GEN3) || (u8VCANDiversity == CANGEN_NISSAN_GEN5))
        	 {
        		 if ( !_bIsCANFaultCategoryC_Masked() ) // Category-C Not Masked
        		 {
        			 _pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        		 }
        		 else // Category-C Masked
        		 {
        			 u8FaultState = BUS_FAULT_UNKNOWN;
        		 }
        	 }
        	 else if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03))
        	 {
        		 _pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        	 }
        	 else
        	 {
        		 u8FaultState = BUS_FAULT_UNKNOWN;
        	 }
         }
         break;

         case VEDA_DIAG_ECU_BCM_454___:
         {
        	 if ((u8VCANDiversity == CANGEN_NISSAN_GEN3) || (u8VCANDiversity == CANGEN_NISSAN_GEN5))
        	 {
        		 if ( !_bIsCANFaultCategoryC_Masked() ) // Category-C Not Masked
        		 {
        			 _pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        			 bUpdateCatDFaults = TRUE;
        		 }
        		 else // Category-C Masked
        		 {
        			 u8FaultState = BUS_FAULT_UNKNOWN;
        		 }
        	 }
        	 else if ((u8VCANDiversity == CANGEN_C1A)) //&& (u8GADEState == 0x03))
        	 {
       			 _pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
       			 ETG_TRACE_USR1(("C1A: VEDA_DIAG_ECU_BCM_454___ "));
        	 }
       		 else
       		 {
       			 u8FaultState = BUS_FAULT_UNKNOWN;
       		 }
         }
         break;

         // Category D ECU's
         case VEDA_DIAG_ECU_HCM_15C___:
         case VEDA_DIAG_ECU_SBW_0C1___:
         case VEDA_DIAG_ECU_ISA_5EA___:
         {
             //bIsNoCounterCat = TRUE;
             if ( !_bIsCANFaultCategoryD_Masked() ) // Category-D Not Masked
             {
                 _pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
             }
             else // Category D Masked
             {
                 u8FaultState = BUS_FAULT_UNKNOWN;
             }
         }
         break;

         // Category D ECU's
         case VEDA_DIAG_ECU_STRG_002__:
         case VEDA_DIAG_ECU_METER_4F2_:
         case VEDA_DIAG_ECU_SONAR_57A_:
         case VEDA_DIAG_ECU_AVM_5C2___:
         {
        	 if ((u8VCANDiversity == CANGEN_NISSAN_GEN3) || (u8VCANDiversity == CANGEN_NISSAN_GEN5))
        	 {
        		 //bIsNoCounterCat = TRUE;
        		 if ( !_bIsCANFaultCategoryD_Masked() ) // Category-D Not Masked
        		 {
        			 _pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        		 }
        		 else // Category D Masked
        		 {
        			 u8FaultState = BUS_FAULT_UNKNOWN;
        		 }
        	 }
        	 else if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03))
        	 {
        		 _pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        	 }
        	 else
        	 {
        		 u8FaultState = BUS_FAULT_UNKNOWN;
        	 }
         }
         break;

         // C1A ECU's for Renault only
         case VEDA_DIAG_ECU_ATCU______:
         {
			if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03) && (u8CANActivationC1A ==ALLIANCE_MESSAGESET_RENAULT) && ( u32ConfigMask & VD_FEATURE_TRANSMISSION_TYPE ))
        	{
				ETG_TRACE_USR1(("Reanault DTCs reading only for RENAULT Message set "));
				_pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        	}
        	else
        	{
				ETG_TRACE_USR1(("For Other Message SET %d %d %d %d",u8VCANDiversity,u8GADEState,u8CANActivationC1A,u32ConfigMask));
        		u8FaultState = BUS_FAULT_UNKNOWN;
        	}
         }
         break;
         case VEDA_DIAG_ECU_HVAC_A1__:
         {
			if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03) && (u8CANActivationC1A ==ALLIANCE_MESSAGESET_RENAULT) && ( u32ConfigMask & VD_FEATURE_CLIMATE_CONTROL ))
        	{
				ETG_TRACE_USR1(("VEDA_DIAG_ECU_HVAC_A1__:Reanault DTCs reading only for RENAULT Message set "));
				_pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        	}
        	else
        	{
				ETG_TRACE_USR1(("VEDA_DIAG_ECU_HVAC_A1__:For Other Message SET %d %d %d %d",u8VCANDiversity,u8GADEState,u8CANActivationC1A,u32ConfigMask));
        		u8FaultState = BUS_FAULT_UNKNOWN;
        	}
         }
         break;
         case VEDA_DIAG_ECU_EPS_A3___:
         case VEDA_DIAG_ECU_FWS_179___:
         case VEDA_DIAG_ECU_HUD_______:
         case VEDA_DIAG_ECU_ACU_538___:
         case VEDA_DIAG_ECU_ADAS_A6___:
         case VEDA_DIAG_ECU_BSW_______:
         case VEDA_DIAG_ECU_ECM_______:
         case VEDA_DIAG_ECU_SR________:
		 //Alliance ECU's but applicable for RENAULT only for scope 2.1
		 case VEDA_DIAG_ECU_HFM_46F___:
		 case VEDA_DIAG_ECU_TCU_43C___:
		 case VEDA_DIAG_ECU_DSMU______:
		 case VEDA_DIAG_ECU_HSM_______:
         {
			if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03) && (u8CANActivationC1A ==ALLIANCE_MESSAGESET_RENAULT)) 	
        	{
				ETG_TRACE_USR1(("Reanault DTCs reading only for RENAULT Message set "));
				_pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        	}
        	else
        	{
				ETG_TRACE_USR1(("For Other Message SET "));
        		u8FaultState = BUS_FAULT_UNKNOWN;
        	}
         }
         break;	
         // C1A ECU's for Alliance
         case VEDA_DIAG_ECU_VDC_438__:
         case VEDA_DIAG_ECU_FCAM_____:
         {
        	 if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03))
        	 {
        		 _pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        	 }
        	 else
        	 {
        		 u8FaultState = BUS_FAULT_UNKNOWN;
        	 }
         }
         break;		 
		 case VEDA_DIAG_ECU_AMP_______:
		 {
			if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03) && (u8CANActivationC1A ==ALLIANCE_MESSAGESET_RENAULT) && ( u32ConfigMask & VD_FEATURE_MCAN_BOSE_AVAILABLE )) 	
        	{
				ETG_TRACE_USR1(("AMP:Renault DTCs reading only for RENAULT Message set "));
				_pCsmBase->_bCheckCommunicationState_RX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
        	}
        	else
        	{
				ETG_TRACE_USR1(("For Other Message SET "));
        		u8FaultState = BUS_FAULT_UNKNOWN;
        	}
         }
		 break;
		 //ECUs not to monitor for now may be in future
		 case VEDA_DIAG_ECU_PSCU______:
		 {
			u8FaultState = BUS_FAULT_UNKNOWN;
         }
         break;

         // MCAN Mutes
         case VEDA_DIAG_MUTE_MCAN_SWC_:
         case VEDA_DIAG_MUTE_MCAN_AUD_:
         case VEDA_DIAG_MUTE_MCAN_TCU_:
         case VEDA_DIAG_MUTE_MCAN_BOSE:
         case VEDA_DIAG_MUTE_MCAN_RSE_:
         {
             if ( tConfig[u8DiagIndex].u8IndicationType == BUS_TX_STATE )
             {
                 _pCsmBase->_bCheckCommunicationState_TX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
             }
         }
         break;

         case VEDA_DIAG_MUTE_MCAN_NAV_:
         {
             if ( tConfig[u8DiagIndex].u8IndicationType == BUS_TX_STATE )
             {
                 _pCsmBase->_bCheckCommunicationState_TX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
             }
             // as only one of the MCAN Nav Units could be working at a time
             u8FaultState &= _pu8CANNodeFaultState[VEDA_DIAG_MUTE_MCAN_NAV2];
         }
         break;

         case VEDA_DIAG_MUTE_MCAN_NAV2:
         {
             if ( tConfig[u8DiagIndex].u8IndicationType == BUS_TX_STATE )
             {
                 _pCsmBase->_bCheckCommunicationState_TX(u8Bus, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
             }
             // as only one of the MCAN Nav Units could be working at a time
             u8FaultState &= _pu8CANNodeFaultState[VEDA_DIAG_MUTE_MCAN_NAV_];
         }
         break;

         case VEDA_DIAG_ECU_ITM_______:
         {
             // Head Unit our device hard coded Fault State
             u8FaultState = BUS_FAULT_INACTIVE;
         }
         break;

         case VEDA_DIAG_MCAN_INIT_____:
         case VEDA_DIAG_VCAN_INIT_____:
         {
             ( bInitState ) ? (u8FaultState = BUS_FAULT_CONFIRMED) : (u8FaultState = BUS_FAULT_INACTIVE);
         }
         break;

         default:
             u8FaultState = BUS_FAULT_UNKNOWN;
             break;
         }
      }

      else
      {
         ETG_TRACE_USR1(("veda_tclClientVcan::vReadAllNodeFaultStates DiagIndex %u Not Configured", \
            ETG_CENUM(tenDiagTMapIndex, u8DiagIndex)));
      }

      ETG_TRACE_USR1(("vReadAllNodeFaultStates(): Current state of u8DiagIndex %u Fault State %u", \
              ETG_CENUM(tenDiagTMapIndex, u8DiagIndex), ETG_CENUM(enCANFaultState, u8FaultState)));

      // Fault state has really changed ?
      if ( ( _pu8CANNodeFaultState[u8DiagIndex] != u8FaultState ) || bForceUpdate )
      {
         tU8 u8FaultIndex = tConfig[u8DiagIndex].u8FaultIndex;
         tU8 u8DiagFaultState = u8FaultState;

         if (tConfig[u8DiagIndex].u8Bus == MCAN)
         {
            _u8AbsentMCANECU[u8FaultIndex] = u8DiagFaultState;
            _pu8CANNodeFaultState[u8DiagIndex] = u8DiagFaultState;
         }
         else if (tConfig[u8DiagIndex].u8Bus == VCAN)
         {
            if ( u8VCANDiversity == CANGEN_NISSAN_GEN5 ) {
               // to inform diagnosis that fault counter should not be decremented for CAN Gen5
               ETG_TRACE_USR1(("to inform diagnosis that fault counter should not be decremented for CAN Gen5"));
               u8DiagFaultState |= 0x28; // =40
            }
            else {
               ETG_TRACE_USR1(("to inform diagnosis that fault counter should be maintained"));
               u8DiagFaultState |= 0x2A; // =42
            }

            _u8AbsentVCANECU[u8FaultIndex] = u8DiagFaultState;
            _pu8CANNodeFaultState[u8DiagIndex] = u8DiagFaultState;
         }
         if ((u8VCANDiversity == CANGEN_NISSAN_GEN3) || (u8VCANDiversity == CANGEN_NISSAN_GEN5))
         {
        	 _vHandleITCLogging(tConfig[u8DiagIndex].u16ITC[0], u8FaultState);
         }
         else if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03))
         {
        	 _vHandleITCLogging(tConfig[u8DiagIndex].u16ITC[1], u8FaultState);
         }

         ETG_TRACE_USR1(("vReadAllNodeFaultStates: u8DiagFaultState 0x%02x ", u8DiagFaultState));
         ETG_TRACE_USR1(("vReadAllNodeFaultStates: DiagIndex %u FaultState %u", \
            ETG_CENUM(tenDiagTMapIndex, u8DiagIndex), ETG_CENUM(enCANFaultState, u8FaultState)));
      }
   }

   // Update the diag bytes property to the Diagnosis
   _vUpdateCANBusState();
}

tVoid veda_tclClientVcan::vHandleCsmFaultIndication(const tU8 u8DiagIndex, tU8 u8FaultState, const tU8 u8ForceUpdate)
{
   VEDA_NULL_POINTER_CHECK(_pu8CANNodeFaultState);
   
   tBool bUpdateCatDFaults = FALSE;
   tBool bIsCsmUpdateRequired = TRUE;

   switch ( u8DiagIndex )
   {
   // Category C Faults
   case VEDA_DIAG_BUS_OFF_VCAN__:
   case VEDA_DIAG_BUS_OFF_MCAN__:
   case VEDA_DIAG_MUTE_VCAN_____:
   {
       if ( _bIsCANFaultCategoryC_Masked() )
       {
           u8FaultState = BUS_FAULT_UNKNOWN;
       }
   }
   break;

   case VEDA_DIAG_ECU_USM_224___:
   {
	   if ((u8VCANDiversity == CANGEN_NISSAN_GEN3) || (u8VCANDiversity == CANGEN_NISSAN_GEN5))
	   {
		   if ( _bIsCANFaultCategoryC_Masked() )
		   {
			   u8FaultState = BUS_FAULT_UNKNOWN;
		   }
	   }
	   else if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03))
	   {
		   //Do Nothing Just Forward the received Fault Status
	   }
	   else
	   {
		   u8FaultState = BUS_FAULT_UNKNOWN;
	   }

   }
   break;


   case VEDA_DIAG_ECU_BCM_454___:
   {
	   if ((u8VCANDiversity == CANGEN_NISSAN_GEN3) || (u8VCANDiversity == CANGEN_NISSAN_GEN5))
	   {
		   bUpdateCatDFaults = TRUE;
		   if ( _bIsCANFaultCategoryC_Masked() )
		   {
			   u8FaultState = BUS_FAULT_UNKNOWN;
		   }
	   }
	   else if ((u8VCANDiversity == CANGEN_C1A))// && (u8GADEState == 0x03))
	   {
		   //Do Nothing Just Forward the received Fault Status
		   ETG_TRACE_USR1(("C1A: VEDA_DIAG_ECU_BCM_454___ "));
	   }
	   else
	   {
			u8FaultState = BUS_FAULT_UNKNOWN;
	   }
   }
   break;

   // Category D Faults
   case VEDA_DIAG_ECU_ISA_5EA___:
   case VEDA_DIAG_ECU_HCM_15C___:
   case VEDA_DIAG_ECU_SBW_0C1___:
   {
	   if ( _bIsCANFaultCategoryD_Masked() )
	   {
		   u8FaultState = BUS_FAULT_UNKNOWN;
	   }
   }
   break;

   // Category D Faults
   case VEDA_DIAG_ECU_STRG_002__:
   case VEDA_DIAG_ECU_METER_4F2_:
   case VEDA_DIAG_ECU_SONAR_57A_:
   case VEDA_DIAG_ECU_AVM_5C2___:
   {
	   if ((u8VCANDiversity == CANGEN_NISSAN_GEN3) || (u8VCANDiversity == CANGEN_NISSAN_GEN5))
	   {
		   if ( _bIsCANFaultCategoryD_Masked() )
		   {
			   u8FaultState = BUS_FAULT_UNKNOWN;
		   }
   	   }
	   else if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03))
	   {
		   //Do Nothing Just Forward the received Fault Status
	   }
	   else
	   {
		   u8FaultState = BUS_FAULT_UNKNOWN;
	   }
   }
   break;

   case VEDA_DIAG_MUTE_MCAN_NAV_:
   {
       // as only one of the MCAN Nav Units could be working at a time
       u8FaultState &= _pu8CANNodeFaultState[VEDA_DIAG_MUTE_MCAN_NAV2];
   }
   break;

   case VEDA_DIAG_MUTE_MCAN_NAV2:
   {
       // as only one of the MCAN Nav Units could be working at a time
       u8FaultState &= _pu8CANNodeFaultState[VEDA_DIAG_MUTE_MCAN_NAV_];
   }
   break;

   case VEDA_DIAG_ECU_ITM_______:
   {
       // Head Unit our device hard coded Fault State
       u8FaultState = BUS_FAULT_INACTIVE;
   }
   break;

    // C1A ECU's for Renault
    case VEDA_DIAG_ECU_ATCU______:
    {
		if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03) && (u8CANActivationC1A == ALLIANCE_MESSAGESET_RENAULT) && ( u32ConfigMask & VD_FEATURE_TRANSMISSION_TYPE ))
        {
			//Do Nothing Just Forward the received Fault Status
        }
		else
		{
			ETG_TRACE_USR1(("Reanault DTC but different Message set/Config in CSM fault indication"));
			bIsCsmUpdateRequired = FALSE;
			u8FaultState = BUS_FAULT_UNKNOWN;
		}
    }
    break;
	case VEDA_DIAG_ECU_HVAC_A1__:
    {
		if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03) && (u8CANActivationC1A == ALLIANCE_MESSAGESET_RENAULT) && ( u32ConfigMask & VD_FEATURE_CLIMATE_CONTROL ))
        {
			//Do Nothing Just Forward the received Fault Status
        }
		else
		{
			ETG_TRACE_USR1(("VEDA_DIAG_ECU_HVAC_A1__:Reanault DTC but different Message set/Config in CSM fault indication"));
			bIsCsmUpdateRequired = FALSE;
			u8FaultState = BUS_FAULT_UNKNOWN;
		}
    }
    break;
    case VEDA_DIAG_ECU_EPS_A3___:
    case VEDA_DIAG_ECU_FWS_179___:
    case VEDA_DIAG_ECU_HUD_______:
    case VEDA_DIAG_ECU_ACU_538___:
    case VEDA_DIAG_ECU_ADAS_A6___:
    case VEDA_DIAG_ECU_BSW_______:
    case VEDA_DIAG_ECU_ECM_______:
    case VEDA_DIAG_ECU_SR________:
	//Alliance ECU's but applicable for RENAULT only for scope 2.1
	case VEDA_DIAG_ECU_HFM_46F___:
	case VEDA_DIAG_ECU_TCU_43C___:
	case VEDA_DIAG_ECU_DSMU______:
	case VEDA_DIAG_ECU_HSM_______:
    {
		if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03) && (u8CANActivationC1A != ALLIANCE_MESSAGESET_RENAULT)) 	
        {
			ETG_TRACE_USR1(("Reanault DTC but different Message set in CSM fault indication"));
			bIsCsmUpdateRequired = FALSE;
			u8FaultState = BUS_FAULT_UNKNOWN;
        }
    }
    break;
    // C1A ECU's for Alliance 
   case VEDA_DIAG_ECU_VDC_438__:
   case VEDA_DIAG_ECU_FCAM_____:
   {
	   if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03))
	   {
		   //Do Nothing Just Forward the received Fault Status
	   }
	   else
	   {
		   u8FaultState = BUS_FAULT_UNKNOWN;
	   }
   }
   break;  
   case VEDA_DIAG_ECU_AMP_______:
	{
		if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03) && (u8CANActivationC1A ==ALLIANCE_MESSAGESET_RENAULT)  && ( u32ConfigMask & VD_FEATURE_MCAN_BOSE_AVAILABLE )) 	
        {
			//Do Nothing Just Forward the received Fault Status	
            ETG_TRACE_USR1(("AMP:Forward the received Fault Status"));			
        }
        else
        {
			ETG_TRACE_USR1(("AMP:For Other Message SET %d %d %d %d ",u8VCANDiversity,u8GADEState,u8CANActivationC1A,u32ConfigMask));
			bIsCsmUpdateRequired = FALSE;
        	u8FaultState = BUS_FAULT_UNKNOWN;
        }
    }
	break;
	//C1A ECUs not to monitor for now may be in future
	case VEDA_DIAG_ECU_PSCU______:
	{
		bIsCsmUpdateRequired = FALSE;
		u8FaultState = BUS_FAULT_UNKNOWN;
	}
	break;
	
   case VEDA_DIAG_MUTE_MCAN_SWC_:
   case VEDA_DIAG_MUTE_MCAN_AUD_:
   case VEDA_DIAG_MUTE_MCAN_TCU_:
   case VEDA_DIAG_MUTE_MCAN_BOSE:
   case VEDA_DIAG_MUTE_MCAN_RSE_:
   case VEDA_DIAG_MCAN_INIT_____:
   case VEDA_DIAG_VCAN_INIT_____:
   default:
   {
		//Do Nothing Just Forward the received Fault Status
   }
   break;
   }

   // Fault state has really changed ?
   if ( (bIsCsmUpdateRequired==TRUE) && (( _pu8CANNodeFaultState[u8DiagIndex] != u8FaultState ) || ( u8ForceUpdate ) ))
   {
      ETG_TRACE_USR1(("vHandleCsmFaultIndication: DiagIndex %u FaultState %u", \
         ETG_CENUM(tenDiagTMapIndex, u8DiagIndex), ETG_CENUM(enCANFaultState, u8FaultState)));

      tU8 u8FaultIndex = tConfig[u8DiagIndex].u8FaultIndex;
      tU8 u8DiagFaultState = u8FaultState;

      if (tConfig[u8DiagIndex].u8Bus == MCAN)
      {
         _u8AbsentMCANECU[u8FaultIndex] = u8DiagFaultState;
         _pu8CANNodeFaultState[u8DiagIndex] = u8DiagFaultState;
      }
      else if (tConfig[u8DiagIndex].u8Bus == VCAN)
      {
          if ( u8VCANDiversity == CANGEN_NISSAN_GEN5 ) {
             // to inform diagnosis that fault counter should not be decremented for CAN Gen5
             ETG_TRACE_USR1(("to inform diagnosis that fault counter should not be decremented for CAN Gen5"));
             u8DiagFaultState |= 0x28; // =40
          }
          else {
             ETG_TRACE_USR1(("to inform diagnosis that fault counter should be maintained"));
             u8DiagFaultState |= 0x2A; //=42
          }
         _pu8CANNodeFaultState[u8DiagIndex] = u8DiagFaultState;
         _u8AbsentVCANECU[u8FaultIndex] = u8DiagFaultState;
      }

      if ((u8VCANDiversity == CANGEN_NISSAN_GEN3) || (u8VCANDiversity == CANGEN_NISSAN_GEN5))
      {
     	 _vHandleITCLogging(tConfig[u8DiagIndex].u16ITC[0], u8FaultState);
      }
      else if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03))
      {
     	 _vHandleITCLogging(tConfig[u8DiagIndex].u16ITC[1], u8FaultState);
      }
      else if((u8VCANDiversity == CANGEN_C1A) && (u8DiagIndex == VEDA_DIAG_ECU_BCM_454___))
      {
    	  _vHandleITCLogging(tConfig[u8DiagIndex].u16ITC[1], u8FaultState);
      }

      ETG_TRACE_USR1(("vHandleCsmFaultIndication: ECU %02x u8DiagFaultState %02x", \
              ETG_CENUM(tenDiagTMapIndex, u8DiagIndex), u8DiagFaultState));
      
      if ( bUpdateCatDFaults )
      {
          _vReadAllCatDNodeFaultStates(FALSE);
      }

      // Update the diag bytes property to the Diagnosis
      if (_bNodeFaultCallbackRegistered == TRUE)
        _vUpdateCANBusState();
   }
}

tVoid veda_tclClientVcan::vSendTire_Pressure_Set ( tU8 u8TirePressure)
{
	ETG_TRACE_USR1(("veda_tclClientVcan::vSendTire_Pressure_Set entered"));
	
	if (u8TirePressure == 16)
	{
	  _u8TwoSecondTimerCount = 0;
	  _bTPMSRequestFlag = TRUE;
	}
			
	TSetting_Change_Request_for_TPMS tTxSignal;
    tTxSignal.Setting_Change_Request_for_TPMS = u8TirePressure;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendSetting_Change_Request_for_TPMS(tTxSignal);
}

tVoid veda_tclClientVcan::_vReadAllCatDNodeFaultStates(const tBool bUpdateDiag)
{
    ETG_TRACE_USR1(("veda_tclClientVcan::_vReadAllCatDNodeFaultStates entered"));
    VEDA_NULL_POINTER_CHECK(_pCsmBase);
    VEDA_NULL_POINTER_CHECK(_pu8CANNodeFaultState);

    tBool bMaskFault = _bIsCANFaultCategoryD_Masked();
    tU8 u8FaultState = 0xFF;

    // Update all the Diag Bytes
    for (tU8 u8DiagIndex = VD_DIAG_CATD_NODE_BEGIN; u8DiagIndex <= VD_DIAG_CATD_NODE_END; u8DiagIndex++)
    {
        tU8 u8FaultIndex = tConfig[u8DiagIndex].u8FaultIndex;
        tU8 u8DiagFaultState = u8FaultState;
        tU32 u32CurrentMask = tConfig[u8DiagIndex].u32FeatureMask;

        // Feature enabled ?
        if ( u32CurrentMask == (u32CurrentMask & u32ConfigMask) )
        {
            ETG_TRACE_USR1(("veda_tclClientVcan::_vReadAllCatDNodeFaultStates ECU %u", ETG_CENUM(tenDiagTMapIndex, u8DiagIndex)));

            if ( ! bMaskFault ) // if not masked, read the current status
            {
                _pCsmBase->_bCheckCommunicationState_RX(VCAN, tConfig[u8DiagIndex].u8AddrField, u8FaultState);
                u8DiagFaultState = u8FaultState;

                if ( u8VCANDiversity == CANGEN_NISSAN_GEN5 ) {
                    // to inform diagnosis that fault counter should not be decremented for CAN Gen5
                    u8DiagFaultState |= 0x28; // =40
                    ETG_TRACE_USR1(("veda_tclClientVcan::_vReadAllCatDNodeFaultStates: fault counter not decremented for CAN Gen5 u8FaultState 0x%02x", u8FaultState));
                } else {
                   u8DiagFaultState |= 0x2A; //=42
                   ETG_TRACE_USR1(("veda_tclClientVcan::_vReadAllCatDNodeFaultStates: fault counter should be maintained u8FaultState 0x%02x", u8FaultState));
                }
            }

            _pu8CANNodeFaultState[u8DiagIndex] = u8DiagFaultState;
            _u8AbsentVCANECU[u8FaultIndex] = u8DiagFaultState;

            if ((u8VCANDiversity == CANGEN_NISSAN_GEN3) || (u8VCANDiversity == CANGEN_NISSAN_GEN5))
            {
           	 _vHandleITCLogging(tConfig[u8DiagIndex].u16ITC[0], u8FaultState);
            }
            else if ((u8VCANDiversity == CANGEN_C1A) && (u8GADEState == 0x03))
            {
           	 _vHandleITCLogging(tConfig[u8DiagIndex].u16ITC[1], u8FaultState);
            }
        }
    }

    if ( bUpdateDiag && _bNodeFaultCallbackRegistered)
        _vUpdateCANBusState();
}

tVoid veda_tclClientVcan::_vUpdateCANBusState(tVoid) const
{
   VEDA_NULL_POINTER_CHECK(_pu8CANNodeFaultState);

   tU8 u8BusState_MCAN = _pu8CANNodeFaultState[VEDA_DIAG_BUS_OFF_MCAN__];
   tU8 u8BusState_VCAN = _pu8CANNodeFaultState[VEDA_DIAG_BUS_OFF_VCAN__];
   tU8 u8MuteState_MCAN = 0xFF;
   tU8 u8MuteState_VCAN = _pu8CANNodeFaultState[VEDA_DIAG_MUTE_VCAN_____];
   tBool bBusOff_MCAN = !(_pu8CANNodeFaultState[VEDA_DIAG_BUS_OFF_MCAN__] == 0x00 );
   tBool bBusOff_VCAN = !(_pu8CANNodeFaultState[VEDA_DIAG_BUS_OFF_VCAN__] == 0x00 );
   tBool bBusOff = FALSE;
   tBool bMute_MCAN = 0xFF; // Not Diagnosed by Vehicle Data
   tBool bMute_VCAN = !( _pu8CANNodeFaultState[VEDA_DIAG_MUTE_VCAN_____] == 0x00 );

   for (tU8 u8DiagIndex = 0; u8DiagIndex < VEDA_DIAG_LAST; u8DiagIndex++)
   {
	   ETG_TRACE_USR1(("veda_tclClientVcan::_vUpdateCANBusState: u8FaultState %u %u ", ETG_CENUM(tenDiagTMapIndex, u8DiagIndex), (_u8AbsentVCANECU[tConfig[u8DiagIndex].u8FaultIndex])));
   }

   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
   _poCCAServiceHdl->sendNetworkStateStatus(u8BusState_MCAN, u8BusState_VCAN, u8MuteState_MCAN, u8MuteState_VCAN, \
      bBusOff_MCAN, bBusOff_VCAN, bBusOff, \
      bMute_MCAN, bMute_VCAN, _u8AbsentVCANECU, _u8AbsentMCANECU);
}

tVoid veda_tclClientVcan::_vHandleITCLogging(const tU16 u16ItcId, const tU8 u8Status) const
{
   tU8 u8Result = midw_fi_tcl_e8_TestResult::FI_EN_NORESULT;

   if (0xFFFF != u16ItcId)
   {
      switch(u8Status)
      {
      case BUS_FAULT_INACTIVE:
         {
            u8Result = midw_fi_tcl_e8_TestResult::FI_EN_PASSED;
            ETG_TRACE_USR4(("veda_tclClientVcan::_vHandleITCLogging() Log %u Status %u", \
               ETG_ENUM(VEDA_INT_ITC, u16ItcId), ETG_CENUM(enITCResult, u8Result)));
            VEDA_NULL_POINTER_CHECK(_poDiaglogHdl);
            _poDiaglogHdl->prepareSaveTestResultData(u16ItcId, u8Result);
         }
         break;

      case BUS_FAULT_ACTIVE: // temporary state
         // do nothing
         break;

      case BUS_FAULT_CONFIRMED:
         {
            u8Result = midw_fi_tcl_e8_TestResult::FI_EN_FAILED;
            ETG_TRACE_USR4(("veda_tclClientVcan::_vHandleITCLogging() Log %u Status %u", \
               ETG_ENUM(VEDA_INT_ITC, u16ItcId), ETG_CENUM(enITCResult, u8Result)));
            VEDA_NULL_POINTER_CHECK(_poDiaglogHdl);
            _poDiaglogHdl->prepareSaveTestResultData(u16ItcId, u8Result);
         }
         break;

      case BUS_FAULT_UNKNOWN:
      default:
         // do nothing
         break;
      }
   }
}

tBool veda_tclClientVcan::_bIsCANFaultCategoryD_Masked() const
{
   // https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-105378/E_25953NDS06_2.pdf
   // If Diag Mux if FALSE Cat D Faults are masked
   // Cat D Faults are nodes that does not contain either the DiagMuxOn parameter or Ignition Status parameter
   if ((_bDiagMuxState == FALSE ) || (_pu8CANNodeFaultState[VEDA_DIAG_ECU_BCM_454___] == BUS_FAULT_CONFIRMED))
   {
      ETG_TRACE_USR1(("veda_tclClientVcan::_bIsCANFaultCategoryD_Masking Active"));
      return true;
   }

   return false;
}

tBool veda_tclClientVcan::_bIsCANFaultCategoryC_Masked() const
{
   // https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-105378/E_25953NDS06_2.pdf
   // If HW Ignition is OFF, Cat C faults are masked
   // Cat C Faults are node that sends DiagMux or Ignition Status, BusOFF, Mute States
   if (_bHWIgnition == FALSE )
   {
      ETG_TRACE_USR1(("veda_tclClientVcan::_bIsCANFaultCategoryC_Masking Active!!"));
      return true;
   }

   return false;
}

tVoid veda_tclClientVcan::vHandleKDSConfigRead(tVoid)
{
   tU8 u8TempCANActivationC1A = 0xFF;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "CANActivationC1A", &u8TempCANActivationC1A, 1) ) 
   {
      u8CANActivationC1A = u8TempCANActivationC1A;
      ETG_TRACE_USR4(("VehicleInformation.u8CANActivationC1A is %u", u8CANActivationC1A));
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for AllianceMessageSetType"));
   } 	
   tU8 u8TempVCANDiversity = 0xFF;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "VCANDiversity", &u8TempVCANDiversity, 1) )
   {
      u8VCANDiversity = u8TempVCANDiversity;
      ETG_TRACE_USR4(("VehicleInformation.u8VCANDiversity is %u", u8VCANDiversity));
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for VCANDiversity"));
   }

   tU8 u8VCANSupervision = 0xFF;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "VCANSupervision", &u8VCANSupervision, 1) )
   {
      ETG_TRACE_USR4(("VehicleInformation.VCANSupervision is %u", u8VCANSupervision));

      if (u8VCANSupervision == 0x01)
      {
         u32ConfigMask |= VD_FEATURE_VCAN_MONITORING;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for VCANSupervision"));
   }

   tU8 u8CamConfig = 0xFF;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("CameraSystem", "CameraSystem", &u8CamConfig, 1) )
   {
      ETG_TRACE_USR1(("vRegisterForVCANErrorInd() u8CamConfig 0x%02x", u8CamConfig));

      if ( ( u8CamConfig == 0x01 ) || ( u8CamConfig == 0x04 ) )
      {
         u32ConfigMask |= VD_FEATURE_AVM_AVAILABLE;
      }
      else if ( (u8CamConfig == 0x02) || (u8CamConfig == 0x03) )
      {
         u32ConfigMask |= VD_FEATURE_RVC_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for CameraSystem"));
   }

   // Meter
   tU8 u8MeterConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "TypeOfMeter", &u8MeterConfigured, 1) )
   {
      if (( 0x00 == u8MeterConfigured ) || (0x01 == u8MeterConfigured))
      {
         u32ConfigMask |= VD_FEATURE_MCAN_METER_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for TypeOfMeter"));
   }

   tU8 u8SteeringSwitch = 0x00;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "SteeringSW", &u8SteeringSwitch, 1) )
   {
      if (0x01 == u8SteeringSwitch)
      {
         u32ConfigMask |= VD_FEATURE_MCAN_SWC_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for SteeringSW"));
   }

   // TCU
   tU8 u8TCUConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "TCU", &u8TCUConfigured, 1) )
   {
      if ( 0x01 == u8TCUConfigured ) // Available for 0x01 In case of Auto we need to check
      {
         u32ConfigMask |= VD_FEATURE_MCAN_TCU_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for TCU"));
   }

   // Rear Seat Entertainment
   tU8 u8RSEConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "RSE", &u8RSEConfigured, 1) )
   {
      if ( 0x00 != u8RSEConfigured )
      {
         u32ConfigMask |= VD_FEATURE_MCAN_RSE_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for RSE"));
   }

   // BOSE Amplifier
   tU8 u8AmplifierConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "OutputInformation", &u8AmplifierConfigured, 1) )
   {
      // Bose Amplifier with M-CAN communication - not used anywhere
	  //AMP on V1CAN - used for Renault
      if (( 0x01 == u8AmplifierConfigured ) || ( 0x03 == u8AmplifierConfigured ) || (0x05 == u8AmplifierConfigured))
      {
         u32ConfigMask |= VD_FEATURE_MCAN_BOSE_AVAILABLE;
         ETG_TRACE_USR1(("AMP:config %d",u32ConfigMask));
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for AmplifierOutputInformation"));
   }

   tU8 u8SonarConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("CameraSystem", "SonarSystemAvailability", &u8SonarConfigured, 1) )
   {
      // Sonar Configured
      if ( 0x01 == u8SonarConfigured )
      {
         u32ConfigMask |= VD_FEATURE_SONAR_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for SonarSystemAvailability"));
   }

   tU8 u8HEVConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "HEVInformationFunction", &u8HEVConfigured, 1) )
   {
      // Sonar Configured
      if ( 0x01 == u8HEVConfigured )
      {
         u32ConfigMask |= VD_FEATURE_HEV_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for HEVInformationFunction"));
   }

   tU8 u8ISAConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "IntelligentSpeedAssist", &u8ISAConfigured, 1) )
   {
      // ISA Configured
      if ( 0x01 == u8ISAConfigured )
      {
         u32ConfigMask |= VD_FEATURE_ISA_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for IntelligentSpeedAssist"));
   }

   tU8 u8AIVIVariantCoding = 0x00;
   dp_tclKdsAIVIVariantCoding oPDCoding;
   if ( DP_U8_ELEM_STATUS_VALID == oPDCoding.u8GetVariantSelection(u8AIVIVariantCoding) )
   {
      if ( 0x01 == u8AIVIVariantCoding ) // Only if Navi is configured
      {
         u32ConfigMask |= VD_FEATURE_MCAN_NAVI_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for Variant Coding"));
   }

   // Steering Wheel Type
   tU8 u8SteeringWheelMsgType = 0xFF;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("CameraSystem", "CameraSteeringMessage", &u8SteeringWheelMsgType, 1) )
   {
      // Steering Wheel Angle ECU Type Configured
      if ( 0x00 == u8SteeringWheelMsgType ) {
         u32ConfigMask |= VD_FEATURE_STRG_AVAILABLE;
      } else if ( 0x01 == u8SteeringWheelMsgType ) {
         u32ConfigMask |= VD_FEATURE_SBW_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for CameraSteeringMessage"));
   }

   // OSP/TSR configured
   tU8 u8TrafficSignConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "TrafficSignRecognition", &u8TrafficSignConfigured, 1) )
   {
      if ( 0x01 == u8TrafficSignConfigured ) // Only if TSR is configured
      {
          u32ConfigMask |= VD_FEATURE_TSR_AVAILABLE;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for TrafficSignRecognition"));
   }

   // SpeedLock configured
   tU8 u8SpeedLockConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "SpeedLockRestrictions", &u8SpeedLockConfigured, 1) )
   {
      if ( 0x01 == u8SpeedLockConfigured ) // SpeedLock is configured
      {
          u32ConfigMask |= VD_FEATURE_SPEED_LOCK;
      }
   }
   else
   {
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for SpeedLockRestrictions"));
   }
   
    // TPMS for P-IVI Configured
	tU8 u8TPMSConfigured = 0x00;
	if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "TPMS", &u8TPMSConfigured, 1) )
	{
		if ( 0x03 == u8TPMSConfigured ) // SpeedLock is configured as OFF (with V-CAN Communication)
		{
			u32ConfigMask |= VD_FEATURE_TPMS;
		}
	}
	else
	{
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for TPMS"));
	}
	//Automatic Transmission Power Train
	tU8 u8ATConfigured = 0x00;
	if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "TransmissionType", &u8ATConfigured, 1) )
	{
		if ( (0x01 == u8ATConfigured) || (0x02 == u8ATConfigured) ) // Transmission is configured as AT or CVT
		{
			u32ConfigMask |= VD_FEATURE_TRANSMISSION_TYPE;
			ETG_TRACE_USR4(("veda_tclClientVcan::vHandleKDSConfigRead():TransmissionType = %d", u8ATConfigured));
		}
	}
	else
	{
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for Transmission Type"));
	}
    // Climate Control HVAC Type
	tU8 u8HVACConfigured = 0x00;
	if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "HVACType", &u8HVACConfigured, 1) )
	{
		if ( (0x01 == u8HVACConfigured) || (0x02 == u8HVACConfigured) ) // HVAC is configured as Dual Display or GD1A
		{
			u32ConfigMask |= VD_FEATURE_CLIMATE_CONTROL;
		}
	}
	else
	{
	   ETG_TRACE_FATAL(("veda_tclClientVcan::vHandleKDSConfigRead KDS Read Failed for HVACType"));
	}
   ETG_TRACE_USR4(("veda_tclClientVcan::vStartCommunication() FeatureMask is 0x%08x", u32ConfigMask));
}

tVoid veda_tclClientVcan::_vReadVehicleSpeed()
{
    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    
    tU32 u32Speed = _u16CANSpeed; // old speed
    tU32 u32InstantMileage = 0;

    vGetVehicleSpeed(); // new speed updated in '_u16CANSpeed'
    if ( _u16CANSpeed != 0xFFFF )
    {
        // Vehicle has been driven at _u16CANSpeed (resolution 0.01) for 1s (X*0.01)
        // Converting km/hr to km/s (X/3600)
        // Multiplying by 1000 to convert into distance traveled in meters (X*1000)
        // Calculating distance traveled in meters with 0.01m resolution (X*100)
        // Instant Mileage = X * 0.01 * 100 * 1000 * 1/3600

        u32InstantMileage = (tU32) (((tDouble) _u16CANSpeed * 1/3600) * 1000);
		ETG_TRACE_USR4(("_u16CANSpeed %d " , _u16CANSpeed));
        ETG_TRACE_USR4(("vGetVehicleSpeed(): Speed = %d.%02d km/hr, Instant Mileage = %d.%02d m", \
                _u16CANSpeed/100, _u16CANSpeed%100, u32InstantMileage/100, u32InstantMileage%100));

        // Accumulated mileage in meters with resolution of meter
        _u32AccumulatedMileage += (tU32) (u32InstantMileage/100);
        
        ETG_TRACE_USR4(("Accumulated Mileage %d.%03d kms" , _u32AccumulatedMileage/1000, _u32AccumulatedMileage % 1000));

        // only if accumulated mileage has changed
        if ( u32InstantMileage != 0 )
            _poCCAServiceHdl->sendMileageStatus(_u32AccumulatedMileage);
    }
    ETG_TRACE_USR4(("U32speed %d " , u32Speed)); 
	ETG_TRACE_USR4(("_u16CANSpeed %d " , _u16CANSpeed)); 	
// only if the speed has changed
    if ( u32Speed != _u16CANSpeed )
        _poCCAServiceHdl->sendSpeedStatus((tU16)_u16CANSpeed);
	
	// Update Of SpeedLock Status For Registered Clients
	if (_u8SpeedLockValue != 0xFE && (u32ConfigMask & VD_FEATURE_SPEED_LOCK))
	{
		if (((_u16CANSpeed/256 > _u8MaxSpeed) || (_u16CANSpeed/256 < _u8MinSpeed))){
			_u8SpeedLockValue = 0x01;
		}

		else if (((_u16CANSpeed/256 < _u8MaxSpeed) || (_u16CANSpeed/256 > _u8MinSpeed))){
			_u8SpeedLockValue = 0x00;
		}
		
		else if (_u8SpeedLockValue != 0x00 && _u8SpeedLockValue != 0x01){
			_u8SpeedLockValue = 0xFF;
		}

		ETG_TRACE_USR4(("_u8SpeedLockValue Value is %d" , _u8SpeedLockValue));
		_poCCAServiceHdl->sendSpeedLockStatus(_u8SpeedLockValue);
	}
	
	//Update of Driving State status For Registered Clients
	if (_u16CANSpeed == 0x00 && _u16CANSpeed != 0xFFFF)
		_u8DriveState = 0x00;
	else if (_u16CANSpeed > 0x00 && _u16CANSpeed != 0xFFFF)
		_u8DriveState = 0x01;
	else
		_u8DriveState = 0xFF;
	
	ETG_TRACE_USR4(("_u8DriveState Value is %d" , _u8DriveState));
	_poCCAServiceHdl->sendDrivingStateStatus(_u8DriveState);
}
//TCOVehiclespeed
tVoid veda_tclClientVcan::_vReadTCOVehicleSpeed()
{
    VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
    
    tU32 u32TCOSpeed = _u16CANTCOSpeed; // old speed
    tU32 u32InstantMileage = 0;

    vGetTCOVehicleSpeed(); // new speed updated in '_u16CANSpeed'
    if ( _u16CANTCOSpeed != 0xFFFF )
    {
        // Vehicle has been driven at _u16CANTCOSpeed (resolution 0.01) for 1s (X*0.01)
        // Converting km/hr to km/s (X/3600)
        // Multiplying by 1000 to convert into distance traveled in meters (X*1000)
        // Calculating distance traveled in meters with 0.01m resolution (X*100)
        // Instant Mileage = X * 0.01 * 100 * 1000 * 1/3600
        u32InstantMileage = (tU32) (((tDouble) _u16CANTCOSpeed * 1/3600) * 1000);
		ETG_TRACE_USR4(("_u16CANTCOSpeed %d " , _u16CANTCOSpeed));
        ETG_TRACE_USR4(("vGetTCOVehicleSpeed(): Speed = %d.%02d km/hr, Instant Mileage = %d.%02d m", \
                _u16CANTCOSpeed/100, _u16CANTCOSpeed%100, u32InstantMileage/100, u32InstantMileage%100));

        // Accumulated mileage in meters with resolution of meter
        _u32AccumulatedMileage += (tU32) (u32InstantMileage/100);
        
        ETG_TRACE_USR4(("Accumulated Mileage %d.%03d kms" , _u32AccumulatedMileage/1000, _u32AccumulatedMileage % 1000));

        // only if accumulated mileage has changed
        if ( u32InstantMileage != 0 )
            _poCCAServiceHdl->sendMileageStatus(_u32AccumulatedMileage);
    }
    ETG_TRACE_USR4(("U32speed %d " , u32TCOSpeed));
	ETG_TRACE_USR4(("_u16CANSpeed %d " , _u16CANTCOSpeed)); 	
// only if the speed has changed
    if ( u32TCOSpeed != _u16CANTCOSpeed )
		_poCCAServiceHdl->sendSpeedStatus((tU16)_u16CANTCOSpeed);
		/*_poCCAServiceHdl->sendTCOSpeedStatus((tU16)_u16CANTCOSpeed);*/
	
	
	// Update Of SpeedLock Status For Registered Clients
	if (_u8SpeedLockValue != 0xFE && (u32ConfigMask & VD_FEATURE_SPEED_LOCK))
	{
		if (((_u16CANTCOSpeed/256 > _u8MaxSpeed) || (_u16CANTCOSpeed/256 < _u8MinSpeed))){
			_u8SpeedLockValue = 0x01;
		}

		else if (((_u16CANTCOSpeed/256 < _u8MaxSpeed) || (_u16CANTCOSpeed/256 > _u8MinSpeed))){
			_u8SpeedLockValue = 0x00;
		}
		
		else if (_u8SpeedLockValue != 0x00 && _u8SpeedLockValue != 0x01){
			_u8SpeedLockValue = 0xFF;
		}

		ETG_TRACE_USR4(("_u8SpeedLockValue Value is %d" , _u8SpeedLockValue));
		_poCCAServiceHdl->sendSpeedLockStatus(_u8SpeedLockValue);
	}
	
	//Update of Driving State status For Registered Clients
	if (_u16CANTCOSpeed == 0x00 && _u16CANTCOSpeed != 0xFFFF)
		_u8DriveState = 0x00;
	else if (_u16CANTCOSpeed > 0x00 && _u16CANTCOSpeed != 0xFFFF)
		_u8DriveState = 0x01;
	else
		_u8DriveState = 0xFF;
	
	ETG_TRACE_USR4(("_u8DriveState Value is %d" , _u8DriveState));
	_poCCAServiceHdl->sendDrivingStateStatus(_u8DriveState);
}
//ExpectedBehaviour
tVoid veda_tclClientVcan::_vReadPartialMuteValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8PartialMute = _u8PartialMuteValue;
	vGetPartialMuteValue();
}
//ExpectedBehaviour-->SwivMonAutoOpen
tVoid veda_tclClientVcan::_vReadSwivMonAutoOpenValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8SwivMonAutoOpen = _u8SwivMonAutoOpenValue;
	vGetSwivMonAutoOpenValue();
}
//ExpectedBehaviour-->DateMode
tVoid veda_tclClientVcan::_vReadDateModeValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8DateMode = _u8DateModeValue;
	vGetDateModeValue();
}

//ExpectedBehaviour-->TmMode
tVoid veda_tclClientVcan::_vReadTmModeValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8TmMode = _u8TmModeValue;
	vGetTmModeValue();
}

//camera
tVoid veda_tclClientVcan::_vReadActCam1Value()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8ActCam1 = _u8ActCam1Value;
	vGetActCam1Value();
}
//camera2
tVoid veda_tclClientVcan::_vReadActCam2Value()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8ActCam2 = _u8ActCam2Value;
	vGetActCam2Value();
}
//camera3
tVoid veda_tclClientVcan::_vReadActCam3Value()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8ActCam3 = _u8ActCam3Value;
	vGetActCam3Value();
}
//camera4
tVoid veda_tclClientVcan::_vReadActCam4Value()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8ActCam4 = _u8ActCam4Value;
	vGetActCam4Value();
}
//camera5
tVoid veda_tclClientVcan::_vReadActCam5Value()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8ActCam5 = _u8ActCam5Value;
	vGetActCam5Value();
}
//camera6
tVoid veda_tclClientVcan::_vReadActCam6Value()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8ActCam6 = _u8ActCam6Value;
	vGetActCam6Value();
}
//camera7
tVoid veda_tclClientVcan::_vReadActCam7Value()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8ActCam7 = _u8ActCam7Value;
	vGetActCam7Value();
}
//camsplit
tVoid veda_tclClientVcan::_vReadCamSplitQuadValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU16 u16CamSplitQuad = _u16CamSplitQuadValue;
	vGetCamSplitQuadValue();
}
//MuteDev
tVoid veda_tclClientVcan::_vReadMuteDevStatus()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8MuteDevStatus = _u8MuteDevStatusValue;
	vGetMuteDevStatus();
}

//ExpectedBehaviour--> SysVoltStatus
tVoid veda_tclClientVcan::_vReadSysVoltStatus()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8SysVoltStatus = _u8SysVoltStatusValue;
	vGetSysVoltStatus();
}
//ParkingBreakSwitch
tVoid veda_tclClientVcan::_vReadParkingBreakSwitchValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8ParkingBreakSwitch = _u8ParkingBreakSwitchValue;
	vGetParkingBreakSwitchValue();
}
//RearCamReq
tVoid veda_tclClientVcan::_vReadRearCamReqValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8RearCamReq = _u8RearCamReqValue;
	vGetRearCamReqValue();
}
//VIN
tVoid veda_tclClientVcan::_vReadVINValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU32 u32VIN = _u32VINValue;
	vGetVINValue();
}

//Time Date
tVoid veda_tclClientVcan::_vReadTimeDateValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU64 u64TimeDate = _u64TimeDateValue;
	vGetTimeDateValue();
}

//PhoneCallCommand
tVoid veda_tclClientVcan::_vReadPhoneCallCommandValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU8 u8PhoneCallCommand = _u8PhoneCallCommandValue;
	vGetPhoneCallCmdValue();
}



//CamTxt
tVoid veda_tclClientVcan::_vReadCamTxtValue()
{
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	tU64 u64CamTxt = _u64CamTxtValue;
	vGetCamTxtValue();
}
tVoid veda_tclClientVcan::vSendSDSStatusUpdate(const tBool bSDSStatus)
{
    /* defines for CBR_lSignalWrite() */
//    #define CSM_C_TX_CYCLIC                  0x01  /**< transmit cyclic */
//    #define CSM_C_TX_IMMEDIATELY             0x02  /**< transmit immediately */
//    #define CSM_C_TX_BUS_WAKE_TEMP           0x04  /**< transmit with Bus wake temporary */
//    #define CSM_C_TX_FCT_ACTIVE              0x08  /**< transmit and set function active */
//    #define CSM_C_TX_AS_CONFIGURED           0x10  /**< transmit, like configured */
//    #define CSM_C_TX_STORE_ONLY              0x20  /**< no transmit trigger, store value */
//    #define CSM_C_TX_NO_TRANSMISSION         0x40  /**< no transmission, for spontan messages */
//    #define CSM_C_TX_TYPE_VALID_MASK         0x7F  /**< used to check the TX type */

    ETG_TRACE_USR4(("veda_tclClientVcan::vSendSDSStatusUpdate(): SDS Status = %u", bSDSStatus));

    switch (u8VCANDiversity)
    {
    case CANGEN_NISSAN_GEN5: // 0x05
    case CANGEN_NISSAN_GEN3: // 0x06
    {
        TVoice_Recognition_Executing tTxSignal;
        tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
        tTxSignal.Voice_Recognition_Executing = (tU8) bSDSStatus;
        vSendVoice_Recognition_Executing(tTxSignal);
    }
    break;

    default:
    {
        TBlowerReductionRequest tTxSignal;
        tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
        tTxSignal.BlowerReductionRequest = (tU8) bSDSStatus;
        vSendBlowerReductionRequest(tTxSignal);
    }
    break;
    }
}
//Cam1ManAct
tVoid veda_tclClientVcan::vSendCam1ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam1ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam1ManAct tTxSignal;
    tTxSignal.Cam1ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam1ManAct(tTxSignal);
}

//Cam2ManAct
tVoid veda_tclClientVcan::vSendCam2ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam2ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam2ManAct tTxSignal;
    tTxSignal.Cam2ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam2ManAct(tTxSignal);
}

//Cam3ManAct
tVoid veda_tclClientVcan::vSendCam3ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam3ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam3ManAct tTxSignal;
    tTxSignal.Cam3ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam3ManAct(tTxSignal);
}

//Cam4ManAct
tVoid veda_tclClientVcan::vSendCam4ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam4ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam4ManAct tTxSignal;
    tTxSignal.Cam4ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam4ManAct(tTxSignal);
}

//Cam5ManAct
tVoid veda_tclClientVcan::vSendCam5ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam5ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam5ManAct tTxSignal;
    tTxSignal.Cam5ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam5ManAct(tTxSignal);
}

//Cam6ManAct
tVoid veda_tclClientVcan::vSendCam6ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam6ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam6ManAct tTxSignal;
    tTxSignal.Cam6ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam6ManAct(tTxSignal);
}

//Cam7ManAct
tVoid veda_tclClientVcan::vSendCam7ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam7ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam7ManAct tTxSignal;
    tTxSignal.Cam7ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam7ManAct(tTxSignal);
}

//Cam8ManAct
tVoid veda_tclClientVcan::vSendCam8ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam8ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam8ManAct tTxSignal;
    tTxSignal.Cam8ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam8ManAct(tTxSignal);
}

//Cam9ManAct
tVoid veda_tclClientVcan::vSendCam9ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam9ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam9ManAct tTxSignal;
    tTxSignal.Cam9ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam9ManAct(tTxSignal);
}
//Cam10ManAct
tVoid veda_tclClientVcan::vSendCam10ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam10ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam10ManAct tTxSignal;
    tTxSignal.Cam10ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam10ManAct(tTxSignal);
}

//Cam11ManAct
tVoid veda_tclClientVcan::vSendCam11ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam11ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam11ManAct tTxSignal;
    tTxSignal.Cam11ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam11ManAct(tTxSignal);
}

//Cam12ManAct
tVoid veda_tclClientVcan::vSendCam12ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam12ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam12ManAct tTxSignal;
    tTxSignal.Cam12ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam12ManAct(tTxSignal);
}


//Cam13ManAct
tVoid veda_tclClientVcan::vSendCam13ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam13ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam13ManAct tTxSignal;
    tTxSignal.Cam13ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam13ManAct(tTxSignal);
}

//Cam14ManAct
tVoid veda_tclClientVcan::vSendCam14ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam14ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam14ManAct tTxSignal;
    tTxSignal.Cam14ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam14ManAct(tTxSignal);
}
//Cam15ManAct
tVoid veda_tclClientVcan::vSendCam15ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam15ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam15ManAct tTxSignal;
    tTxSignal.Cam15ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam15ManAct(tTxSignal);
}
//Cam16ManAct
tVoid veda_tclClientVcan::vSendCam16ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam16ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam16ManAct tTxSignal;
    tTxSignal.Cam16ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam16ManAct(tTxSignal);
}
//Cam17ManAct
tVoid veda_tclClientVcan::vSendCam17ManActUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCam17ManActUpdate(): Unit Request = %u", u8Request));
    
    TCam17ManAct tTxSignal;
    tTxSignal.Cam17ManAct = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCam17ManAct(tTxSignal);
}

//PrivacyResetAck
tVoid veda_tclClientVcan::vSendPrivacyResetAckUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendPrivacyResetAckUpdate(): Unit Request = %u", u8Request));
    
    TPrivacyResetAck tTxSignal;
    tTxSignal.PrivacyResetAck = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendPrivacyResetAck(tTxSignal);
}
//DispCamCls
tVoid veda_tclClientVcan::vSendDispCamClsUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendDispCamClsUpdate(): Unit Request = %u", u8Request));
    
    TDispCamCls tTxSignal;
    tTxSignal.DispCamCls = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDispCamCls(tTxSignal);
}
//PhoneBTLinkStatus
tVoid veda_tclClientVcan::vSendPhoneBTLinkStatusUpdate(const tU8 BTLinkStatus)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendPhoneBTLinkStatusUpdate():  BTLinkStatus = %u", BTLinkStatus));
    
    TPhoneBTLinkStatus tTxSignal;
    tTxSignal.BTLinkStatus = BTLinkStatus;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendPhoneBTLinkStatus(tTxSignal);
}


//PhoneBookSyncstatus
tVoid veda_tclClientVcan::vSendPhoneBookSyncstatusUpdate(const tU8 PhoneBookSyncStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendPhoneBookSyncstatusUpdate():  PhoneBookSyncStatusValue = %u", PhoneBookSyncStatusValue));
    
    TPhoneBookSyncStatus tTxSignal;
    tTxSignal.PhoneBookSyncStatusValue = PhoneBookSyncStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendPhoneBookSyncstatus(tTxSignal);
}

//CallHistorySyncStatus
tVoid veda_tclClientVcan::vSendCallHistorySyncStatusUpdate(const tU8 CallHistorySyncStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::CallHistorySyncStatusValue():  CallHistorySyncStatusValue = %u", CallHistorySyncStatusValue));
    
    TCallHistorySyncStatus tTxSignal;
    tTxSignal.CallHistorySyncStatusValue = CallHistorySyncStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCallHistorySyncStatus(tTxSignal);
}

//PhoneStatusRoaming
tVoid veda_tclClientVcan::vSendPhoneStatusRoamingUpdate(const tU8 PhoneStatusRoamingValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendPhoneStatusRoamingUpdate():  PhoneStatusRoamingValue = %u", PhoneStatusRoamingValue));
    
    TPhoneStatusRoaming tTxSignal;
    tTxSignal.PhoneStatusRoamingValue = PhoneStatusRoamingValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendPhoneStatusRoaming(tTxSignal);
}



//CallDuration
tVoid veda_tclClientVcan::vSendCallDurationUpdate(const tU16 CallDurationValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCallDurationUpdate():  CallDurationValue = %u", CallDurationValue));
    
    TCallDuration tTxSignal;
    tTxSignal.CallDurationValue = CallDurationValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCallDuration(tTxSignal);
}


//GSMSignalStrength
tVoid veda_tclClientVcan::vSendGSMSignalStrengthUpdate(const tU8 GSMSignalStrengthValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendGSMSignalStrengthUpdate():  GSMSignalStrengthValue = %u", GSMSignalStrengthValue));
    
    TGSMSignalStrength tTxSignal;
    tTxSignal.GSMSignalStrengthValue = GSMSignalStrengthValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendGSMSignalStrength(tTxSignal);
}


//PhoneCallStatus
tVoid veda_tclClientVcan::vSendPhoneCallStatusUpdate(const tU8 CallStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendPhoneCallStatusUpdate():  CallStatusValue = %u", CallStatusValue));
    
    TPhoneCallStatus tTxSignal;
    tTxSignal.CallStatusValue = CallStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendPhoneCallStatus(tTxSignal);
}


//PhoneBatteryLevelStatus
tVoid veda_tclClientVcan::vSendPhoneBatteryLevelStatusUpdate(const tU8 PhoneBatteryLevelStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendPhoneBatteryLevelStatusUpdate():  PhoneBatteryLevelStatusValue = %u", PhoneBatteryLevelStatusValue));
    
    TPhoneBatteryLevelStatus tTxSignal;
    tTxSignal.PhoneBatteryLevelStatusValue = PhoneBatteryLevelStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendPhoneBatteryLevelStatus(tTxSignal);
}

//DeviceStatusWifiAvailable
tVoid veda_tclClientVcan::vSendDeviceStatusWifiAvailableUpdate(const tU8 DeviceStatusWifiStatus)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendDeviceStatusWifiAvailableUpdate():  DeviceStatusWifiStatus = %u", DeviceStatusWifiStatus));
    
    TDeviceStatusWifiAvailable tTxSignal;
    tTxSignal.DeviceStatusWifiStatus = DeviceStatusWifiStatus;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusWifiAvailable(tTxSignal);
}

//MediaStatusAudioSource
tVoid veda_tclClientVcan::vSendMediaStatusAudioSourceUpdate(const tU8 AudioSource)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSenMediaStatusAudioSourceUpdate():  AudioSource = %u", AudioSource));
    
    TMediaStatusAudioSource tTxSignal;
    tTxSignal.AudioSource = AudioSource;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusAudioSource(tTxSignal);
}

//PhoneAvailableStatus
tVoid veda_tclClientVcan::vSendPhoneAvailableStatusUpdate(const tU8 PhoneAvailableStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendPhoneAvailableStatusUpdate():  PhoneAvailableStatusValue = %u", PhoneAvailableStatusValue));
    
    TPhoneAvailableStatus tTxSignal;
    tTxSignal.PhoneAvailableStatusValue = PhoneAvailableStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendPhoneAvailableStatus(tTxSignal);
}


//PhoneVRAvailable
tVoid veda_tclClientVcan::vSendPhoneVRAvailableUpdate(const tU8 PhoneVRAvailableValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendPhoneVRAvailableUpdate():  PhoneVRAvailableValue = %u", PhoneVRAvailableValue));
    
    TPhoneVRAvailable tTxSignal;
    tTxSignal.PhoneVRAvailableValue = PhoneVRAvailableValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendPhoneVRAvailable(tTxSignal);
}


//DeviceStatusBluetoothAvail
tVoid veda_tclClientVcan::vSendDeviceStatusBluetoothAvailUpdate(const tU8 DeviceStatusBluetoothAvailValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendDeviceStatusBluetoothAvailUpdate():  DeviceStatusBluetoothAvailValue = %u", DeviceStatusBluetoothAvailValue));
    
    TDeviceStatusBluetoothAvail tTxSignal;
    tTxSignal.DeviceStatusBluetoothAvailValue = DeviceStatusBluetoothAvailValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusBluetoothAvail(tTxSignal);
}


//Req_DeviceInfo
tVoid veda_tclClientVcan::vSendReq_DeviceInfoUpdate(const tU8 Req_DeviceInfoValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendReq_DeviceInfoUpdate():  Req_DeviceInfoValue = %u", Req_DeviceInfoValue));
    
    TReq_DeviceInfo tTxSignal;
    tTxSignal.Req_DeviceInfoValue = Req_DeviceInfoValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendReq_DeviceInfo(tTxSignal);
}


//DeviceStatusBTStatus
tVoid veda_tclClientVcan::vSendDeviceStatusBTStatusUpdate(const tU8 DeviceStatusBTStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendDeviceStatusBTStatusUpdate():  DeviceStatusBTStatusValue = %u", DeviceStatusBTStatusValue));
    
    TDeviceStatusBTStatus tTxSignal;
    tTxSignal.DeviceStatusBTStatusValue = DeviceStatusBTStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusBTStatus(tTxSignal);
}


//MediaStatusVolume
tVoid veda_tclClientVcan::vSendMediaStatusVolumeUpdate(const tU8 volume)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusVolumeUpdate():  volume = %u", volume));
    
    TMediaStatusVolume tTxSignal;
    tTxSignal.volume = volume;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusVolume(tTxSignal);
}

//CabinMediaStatusAudioSource
tVoid veda_tclClientVcan::vSendCabinMediaStatusAudioSourceUpdate(const tU8 CabinAudioSource)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCabinMediaStatusAudioSourceUpdate():  volume = %u", CabinAudioSource));
    
    TCabinMediaStatusAudioSource tTxSignal;
    tTxSignal.CabinAudioSource = CabinAudioSource;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCabinMediaStatusAudioSource(tTxSignal);
}

//CabinMediaStatusTunerBand
tVoid veda_tclClientVcan::vSendCabinMediaStatusTunerBandUpdate(const tU8 CabinMediaStatusTunerBandValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCabinMediaStatusTunerBandValueUpdate():  volume = %u", CabinMediaStatusTunerBandValue));
    
    TCabinMediaStatusTunerBand tTxSignal;
    tTxSignal.CabinMediaStatusTunerBandValue = CabinMediaStatusTunerBandValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCabinMediaStatusTunerBand(tTxSignal);
}


//CabinMediaStatusVolume
tVoid veda_tclClientVcan::vSendCabinMediaStatusVolumeUpdate(const tU8 CabinVolume)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCabinMediaStatusVolumeUpdate():  CabinVolume = %u", CabinVolume));
    
    TCabinMediaStatusVolume tTxSignal;
    tTxSignal.CabinVolume = CabinVolume;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCabinMediaStatusVolume(tTxSignal);
}


//MediaStatusMuteStatus
tVoid veda_tclClientVcan::vSendMediaStatusMuteStatusUpdate(const tU8 MediaStatusMuteValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusMuteStatusUpdate():  MediaStatusMuteValue = %u", MediaStatusMuteValue));
    
    TMediaStatusMuteStatus tTxSignal;
    tTxSignal.MediaStatusMuteValue = MediaStatusMuteValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusMuteStatus(tTxSignal);
}


//CabinMediaStatusMuteStatus
tVoid veda_tclClientVcan::vSendCabinMediaStatusMuteStatusUpdate(const tU8 CabinMediaStatusMuteValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCabinMediaStatusMuteStatusUpdate():  CabinMediaStatusMuteValue = %u", CabinMediaStatusMuteValue));
    
    TCabinMediaStatusMuteStatus tTxSignal;
    tTxSignal.CabinMediaStatusMuteValue = CabinMediaStatusMuteValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCabinMediaStatusMuteStatus(tTxSignal);
}


//MediaStatusPlayStatus
tVoid veda_tclClientVcan::vSendMediaStatusPlayStatusUpdate(const tU8 MediaStatusPlayStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusPlayStatusUpdate():MediaStatusPlayStatusValue = %u", MediaStatusPlayStatusValue));
    
    TMediaStatusPlayStatus tTxSignal;
    tTxSignal.MediaStatusPlayStatusValue = MediaStatusPlayStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusPlayStatus(tTxSignal);
}
//MediaStatusMixState
tVoid veda_tclClientVcan::vSendMediaStatusMixStateUpdate(const tU8 MediaStatusMixStateValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusMixStateUpdate():MediaStatusMixStateValue = %u", MediaStatusMixStateValue));
    
    TMediaStatusMixState tTxSignal;
    tTxSignal.MediaStatusMixStateValue = MediaStatusMixStateValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusMixState(tTxSignal);
}
//MediaStatusPlaylistMode
tVoid veda_tclClientVcan::vSendMediaStatusPlaylistModeUpdate(const tU8 MediaStatusPlaylistModeValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vMediaStatusPlaylistModeUpdate():MediaStatusPlaylistModeValue = %u", MediaStatusPlaylistModeValue));
    
    TMediaStatusPlaylistMode tTxSignal;
    tTxSignal.MediaStatusPlaylistModeValue = MediaStatusPlaylistModeValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusPlaylistMode(tTxSignal);
}

//MediaStatusTrackTime
tVoid veda_tclClientVcan::vSendMediaStatusTrackTimeUpdate(const tU16 MediaStatusTrackTimeValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vMediaStatusTrackTimeUpdate():MediaStatusTrackTimeValue = %u", MediaStatusTrackTimeValue));
    
    TMediaStatusTrackTime tTxSignal;
    tTxSignal.MediaStatusTrackTimeValue = MediaStatusTrackTimeValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusTrackTime(tTxSignal);
}
//MediaStatusCurrTrackNum
tVoid veda_tclClientVcan::vSendMediaStatusCurrTrackNumUpdate(const tU16 MediaStatusCurrTrackNumValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vMediaStatusCurrTrackNumUpdate():MediaStatusCurrTrackNumValue = %u", MediaStatusCurrTrackNumValue));
    
    TMediaStatusCurrTrackNum tTxSignal;
    tTxSignal.MediaStatusCurrTrackNumValue = MediaStatusCurrTrackNumValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusCurrTrackNum(tTxSignal);
}
//DeviceStatusRadioStatus
tVoid veda_tclClientVcan::vSendDeviceStatusRadioStatusUpdate(const tU8 DeviceStatusRadioStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vDeviceStatusRadioStatusUpdate():DeviceStatusRadioStatusValue = %u", DeviceStatusRadioStatusValue));
    
    TDeviceStatusRadioStatus tTxSignal;
    tTxSignal.DeviceStatusRadioStatusValue = DeviceStatusRadioStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusRadioStatus(tTxSignal);
}
//DeviceStatusDABAvailStatus
tVoid veda_tclClientVcan::vSendDeviceStatusDABAvailStatusUpdate(const tU8 DeviceStatusDABAvailStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vDeviceStatusDABAvailStatusUpdate():DeviceStatusDABAvailStatusValue = %u", DeviceStatusDABAvailStatusValue));
    
    TDeviceStatusDABAvailStatus tTxSignal;
    tTxSignal.DeviceStatusDABAvailStatusValue = DeviceStatusDABAvailStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusDABAvailStatus(tTxSignal);
}
//DeviceStatusNavData
tVoid veda_tclClientVcan::vSendDeviceStatusNavDataUpdate(const tU8 DeviceStatusNavDataValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vDeviceStatusNavDataUpdate():DeviceStatusNavDataValue = %u", DeviceStatusNavDataValue));
    
    TDeviceStatusNavData tTxSignal;
    tTxSignal.DeviceStatusNavDataValue = DeviceStatusNavDataValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusNavData(tTxSignal);
}
//DeviceStatusUSB1Present
tVoid veda_tclClientVcan::vSendDeviceStatusUSB1PresentUpdate(const tU8 DeviceStatusUSB1PresentValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vDeviceStatusUSB1PresentUpdate():DeviceStatusUSB1PresentValue = %u", DeviceStatusUSB1PresentValue));
    
    TDeviceStatusUSB1Present tTxSignal;
    tTxSignal.DeviceStatusUSB1PresentValue = DeviceStatusUSB1PresentValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusUSB1Present(tTxSignal);
}
//DeviceStatusUSB2Present
tVoid veda_tclClientVcan::vSendDeviceStatusUSB2PresentUpdate(const tU8 DeviceStatusUSB2PresentValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vDeviceStatusUSB2PresentUpdate():DeviceStatusUSB2PresentValue = %u", DeviceStatusUSB2PresentValue));
    
    TDeviceStatusUSB2Present tTxSignal;
    tTxSignal.DeviceStatusUSB2PresentValue = DeviceStatusUSB2PresentValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusUSB2Present(tTxSignal);
}
//DeviceStatusNaviAvail
tVoid veda_tclClientVcan::vSendDeviceStatusNaviAvailUpdate(const tU8 DeviceStatusNaviAvailValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vDeviceStatusNaviAvailUpdate():DeviceStatusNaviAvailValue = %u", DeviceStatusNaviAvailValue));
    
    TDeviceStatusNaviAvail tTxSignal;
    tTxSignal.DeviceStatusNaviAvailValue = DeviceStatusNaviAvailValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusNaviAvail(tTxSignal);
}
//DeviceStatusUSB1Src
tVoid veda_tclClientVcan::vSendDeviceStatusUSB1SrcUpdate(const tU8 DeviceStatusUSB1SrcValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vDeviceStatusUSB1SrcUpdate():DeviceStatusUSB1SrcValue = %u", DeviceStatusUSB1SrcValue));
    
    TDeviceStatusUSB1Src tTxSignal;
    tTxSignal.DeviceStatusUSB1SrcValue = DeviceStatusUSB1SrcValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusUSB1Src(tTxSignal);
}
//DeviceStatusUSB2Src
tVoid veda_tclClientVcan::vSendDeviceStatusUSB2SrcUpdate(const tU8 DeviceStatusUSB2SrcValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vDeviceStatusUSB2SrcUpdate():DeviceStatusUSB2SrcValue = %u", DeviceStatusUSB2SrcValue));
    
    TDeviceStatusUSB2Src tTxSignal;
    tTxSignal.DeviceStatusUSB2SrcValue = DeviceStatusUSB2SrcValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusUSB2Src(tTxSignal);
}
//DeviceStatusAMFMAvail
tVoid veda_tclClientVcan::vSendDeviceStatusAMFMAvailUpdate(const tU8 DeviceStatusAMFMAvailValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vDeviceStatusAMFMAvailUpdate():DeviceStatusAMFMAvailValue = %u", DeviceStatusAMFMAvailValue));
    
    TDeviceStatusAMFMAvail tTxSignal;
    tTxSignal.DeviceStatusAMFMAvailValue = DeviceStatusAMFMAvailValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendDeviceStatusAMFMAvail(tTxSignal);
}




//MediaStatusSeekStatus
tVoid veda_tclClientVcan::vSendMediaStatusSeekStatusUpdate(const tU8 MediaStatusSeekStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusSeekStatusUpdate():MediaStatusSeekStatusValue = %u", MediaStatusSeekStatusValue));
    
    TMediaStatusSeekStatus tTxSignal;
    tTxSignal.MediaStatusSeekStatusValue = MediaStatusSeekStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusSeekStatus(tTxSignal);
}

//MediaStatusRepeatStatus
tVoid veda_tclClientVcan::vSendMediaStatusRepeatStatusUpdate(const tU8 MediaStatusRepeatStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusRepeatStatusUpdate():MediaStatusRepeatStatusValue = %u", MediaStatusRepeatStatusValue));
    
    TMediaStatusRepeatStatus tTxSignal;
    tTxSignal.MediaStatusRepeatStatusValue = MediaStatusRepeatStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusRepeatStatus(tTxSignal);
}

//MediaStatusDABFMStatus
tVoid veda_tclClientVcan::vSendMediaStatusDABFMStatusUpdate(const tU8 MediaStatusDABFMStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusDABFMStatusUpdate():MediaStatusDABFMStatusValue = %u", MediaStatusDABFMStatusValue));
    
    TMediaStatusDABFMStatus tTxSignal;
    tTxSignal.MediaStatusDABFMStatusValue = MediaStatusDABFMStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusDABFMStatus(tTxSignal);
}

//VehicleNaviLatitude
tVoid veda_tclClientVcan::vSendVehicleNaviLatitudeUpdate(const tU32 VehicleNaviLatitudeValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendVehicleNaviLatitudeUpdate():VehicleNaviLatitudeValue = %u", VehicleNaviLatitudeValue));
    
    TVehicleNaviLatitude tTxSignal;
    tTxSignal.VehicleNaviLatitudeValue = VehicleNaviLatitudeValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendVehicleNaviLatitude(tTxSignal);
}

//VehicleNaviLongitude
tVoid veda_tclClientVcan::vSendVehicleNaviLongitudeUpdate(const tU32 VehicleNaviLongitudeValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendVehicleNaviLongitudeUpdate():VehicleNaviLongitudeValue = %u", VehicleNaviLongitudeValue));
    
    TVehicleNaviLongitude tTxSignal;
    tTxSignal.VehicleNaviLongitudeValue = VehicleNaviLongitudeValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendVehicleNaviLongitude(tTxSignal);
}

//MediaStatusTREGStatus
tVoid veda_tclClientVcan::vSendMediaStatusTREGStatusUpdate(const tU8 MediaStatusTREGStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusTREGStatusUpdate():MediaStatusTREGStatusValue = %u", MediaStatusTREGStatusValue));
    
    TMediaStatusTREGStatus tTxSignal;
    tTxSignal.MediaStatusTREGStatusValue = MediaStatusTREGStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusTREGStatus(tTxSignal);
}
//MediaStatusTREGRTMStatus
tVoid veda_tclClientVcan::vSendMediaStatusTREGRTMStatusUpdate(const tU8 MediaStatusTREGRTMStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusTREGRTMStatus():MediaStatusTREGRTMStatusValue = %u", MediaStatusTREGRTMStatusValue));
    
    TMediaStatusTREGRTMStatus tTxSignal;
    tTxSignal.MediaStatusTREGRTMStatusValue = MediaStatusTREGRTMStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusTREGRTMStatus(tTxSignal);
}

//MediaStatusRDSStatus
tVoid veda_tclClientVcan::vSendMediaStatusRDSStatusUpdate(const tU8 MediaStatusRDSStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusRDSStatusUpdate():MediaStatusRDSStatusValue = %u", MediaStatusRDSStatusValue));
    
    TMediaStatusRDSStatus tTxSignal;
    tTxSignal.MediaStatusRDSStatusValue = MediaStatusRDSStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusRDSStatus(tTxSignal);
}

//MediaStatusTAStatus
tVoid veda_tclClientVcan::vSendMediaStatusTAStatusUpdate(const tU8 MediaStatusTAStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusTAStatusUpdate():MediaStatusTAStatusValue = %u", MediaStatusTAStatusValue));
    
    TMediaStatusTAStatus tTxSignal;
    tTxSignal.MediaStatusTAStatusValue = MediaStatusTAStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusTAStatus(tTxSignal);
}

//MediaStatusTPStatus
tVoid veda_tclClientVcan::vSendMediaStatusTPStatusUpdate(const tU8 MediaStatusTPStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusTPStatusUpdate():MediaStatusTPStatusValue = %u", MediaStatusTPStatusValue));
    
    TMediaStatusTPStatus tTxSignal;
    tTxSignal.MediaStatusTPStatusValue = MediaStatusTPStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusTPStatus(tTxSignal);
}

//MediaStatusTunerBandStatus
tVoid veda_tclClientVcan::vSendMediaStatusTunerBandStatusUpdate(const tU8 MediaStatusTunerBandStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusTunerBandStatusUpdate():MediaStatusTunerBandStatusValue = %u", MediaStatusTunerBandStatusValue));
    
    TMediaStatusTunerBandStatus tTxSignal;
    tTxSignal.MediaStatusTunerBandStatusValue = MediaStatusTunerBandStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusTunerBandStatus(tTxSignal);
}

//MediaStatusTunerPresetStatus
tVoid veda_tclClientVcan::vSendMediaStatusTunerPresetStatusUpdate(const tU8 MediaStatusTunerPresetStatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMediaStatusTunerPresetStatusUpdate():MediaStatusTunerPresetStatusValue = %u", MediaStatusTunerPresetStatusValue));
    
    TMediaStatusTunerPresetStatus tTxSignal;
    tTxSignal.MediaStatusTunerPresetStatusValue = MediaStatusTunerPresetStatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMediaStatusTunerPresetStatus(tTxSignal);
}

//HUS_DM1_Status
tVoid veda_tclClientVcan::vSendHUS_DM1_StatusUpdate(const tU64 HUS_DM1_StatusValue)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendHUS_DM1_StatusUpdate():HUS_DM1_StatusValue = %u", HUS_DM1_StatusValue));
    
    THUS_DM1_Status tTxSignal;
    tTxSignal.HUS_DM1_StatusValue = HUS_DM1_StatusValue;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendHUS_DM1_Status(tTxSignal);
}

tVoid veda_tclClientVcan::vSendCockpitLanguageUpdate(const tU8 u8RequestedLang)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendCockpitLanguageUpdate(): Request = %u", u8RequestedLang));
    
    TCockpitLanguageRequest tTxSignal;
    tTxSignal.CockpitLanguageRequest = u8RequestedLang;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendCockpitLanguageRequest(tTxSignal);
}

tVoid veda_tclClientVcan::vSendMeterLanguageSyncMenuUpdate(const tU8 u8LangSyncMenu)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendMeterLanguageSyncMenuUpdate(): Sync Menu Request = %u", ETG_CENUM(ten_MeterLangSyncMenuRequest, u8LangSyncMenu)));
    
    TMeterLanguageSyncMenu tTxSignal;
    tTxSignal.MeterLanguageSyncMenu = u8LangSyncMenu;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendMeterLanguageSyncMenu(tTxSignal);
}

tVoid veda_tclClientVcan::vSendUnitDistanceDisplayRequestUpdate(const tU8 u8Request)
{
    ETG_TRACE_USR4(("veda_tclClientVcan::vSendUnitDistanceDisplayRequestUpdate(): Unit Request = %u", ETG_CENUM(ten_UnitDistanceRequest, u8Request)));
    
    TUnitDistanceDisplayRequest tTxSignal;
    tTxSignal.UnitDistanceDisplayRequest = u8Request;
    tTxSignal.u8TxType = CSM_C_TX_AS_CONFIGURED;
    
    vSendUnitDistanceDisplayRequest(tTxSignal);
}

// Load and Check Speed Limits (SpeedLock)
tVoid veda_tclClientVcan::vLoadCheckSpeedLimit(tVoid)
{
   ETG_TRACE_USR4(("veda_tclClientVcan::vLoadCheckSpeedLimit()"));

   if (!DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "SpeedLockMinThresholdForUseRestrictionKmH", &_u8MinSpeed, 1) )
		_u8SpeedLockValue = 0xFE;
   if (!DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "SpeedLockMaxThresholdForUseRestrictionKmH", &_u8MaxSpeed, 1) )
		_u8SpeedLockValue = 0xFE;
   if (_u8MinSpeed > _u8MaxSpeed)
	   _u8SpeedLockValue = 0xFE;
   
	VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
	ETG_TRACE_USR4(("veda_tclClientVcan::vLoadCheckSpeedLimit(): _u8MinSpeed = %d _u8MaxSpeed = %d", _u8MinSpeed, _u8MaxSpeed));
	_poCCAServiceHdl->sendSpeedLockStatus(_u8SpeedLockValue);
}

// veda_tclClientVcan::ClassImplementation: user specific code end
//EOF
