/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Iveda_ClientVcan.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: vehicledata
  * @Template:     ICsmClient.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Csm client interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef _I_VCANCAN_CLIENT_H_
#define _I_VCANCAN_CLIENT_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "veda_AppMain.h"
#include "I_veda_ServiceVehicle.h"

#ifdef USE_EVOBUSB2E_ADAPTOR
#include "I_veda_ClientVcanEvobusb2eCanAdaptor.h"
#endif

#ifdef USE_EVOBUS_ADAPTOR
#include "I_veda_ClientVcanCanAdaptor.h"
#endif
#ifdef USE_INF4CV_ADAPTOR
#include "I_veda_ClientVcanInf4cvCanAdaptor.h"
#endif
#ifdef USE_SMART_ADAPTOR
#include "I_veda_ClientVcanSmartCanAdaptor.h"
#endif

class I_veda_tclClientVcan : public veda_tclBaseIf
{
public:
   I_veda_tclClientVcan(veda_tclAppMain* poMainAppl): veda_tclBaseIf(poMainAppl) {;}
   virtual ~I_veda_tclClientVcan() {;}

   virtual const tChar* getIfName() const { return "I_veda_tclClientVcan"; };

    virtual tVoid vGetSpeed_Limit_Display_Request() = 0;
    virtual tVoid vGetNavi_display_speed_limit_1() = 0;
    virtual tVoid vGetNavi_display_speed_limit_2() = 0;
    virtual tVoid vGetIgnitionSupplyConfirmation() = 0;
    virtual tVoid vGetVehicleSpeed() = 0;
	//TCOVehiclespeed
	virtual tVoid vGetTCOVehicleSpeed() = 0;
	//Mutedev
	virtual tVoid vGetMuteDevStatus() = 0;
	virtual tVoid vGetPartialMuteValue() = 0;
	virtual tVoid vGetSwivMonAutoOpenValue() = 0;
	virtual tVoid vGetDateModeValue() = 0;
	virtual tVoid vGetTmModeValue() = 0;
	//camera
	virtual tVoid vGetActCam1Value() = 0;
	//camera2
	virtual tVoid vGetActCam2Value() = 0;
	//camera3
	virtual tVoid vGetActCam3Value() = 0;
	//camera4
	virtual tVoid vGetActCam4Value() = 0;
	//camera5
	virtual tVoid vGetActCam5Value() = 0;
	//camera6
	virtual tVoid vGetActCam6Value() = 0;
	//camera7
	virtual tVoid vGetActCam7Value() = 0;
	//camsplit
	virtual tVoid vGetCamSplitQuadValue() = 0;
	//SysVolt
	virtual tVoid vGetSysVoltStatus() = 0;
	//ParkingBreakSwitch
	virtual tVoid vGetParkingBreakSwitchValue() = 0;
	//Disatnce Unit
	virtual tVoid vGetUnitDistanceDisplayState() = 0;
	//RearCamReq
	virtual tVoid vGetRearCamReqValue() = 0;
	//VIN
	virtual tVoid vGetVINValue() = 0;
	//Time Date 
	virtual tVoid vGetTimeDateValue() = 0;
	//PhoneCallCommand 
	virtual tVoid vGetPhoneCallCmdValue()= 0;
	//System Language
	virtual tVoid vGetSystemLanguageValue() = 0;
	//CurrLang
	virtual tVoid vGetCurrLangValue() = 0;
	//CamTxt
	virtual tVoid vGetCamTxtValue() = 0;
	
    virtual tVoid vGetHandBrakeSwitch() = 0;
    virtual tVoid vGetDistanceTotalizer() = 0;
    virtual tVoid vGetDistanceUnit() = 0;
    virtual tVoid vGetAverage_Fuel_Economy() = 0;
    virtual tVoid vGetDiagMuxOn() = 0;
    virtual tVoid vGetDiagMuxOn_84() = 0;
    virtual tVoid vGetGADE() = 0;
    virtual tVoid vGetRearGearEngaged() = 0;
    virtual tVoid vGetOSPOverSpeedDisplayRequest() = 0;
    virtual tVoid vGetOSPSpeedUnit() = 0;
    virtual tVoid vGetTSR_OSP_ActivationStatus() = 0;
    virtual tVoid vGetMeterLanguageKnowledge() = 0;
    virtual tVoid vGetMeterLanguageStatus() = 0;
    virtual tVoid vGetReset_TPMS_answer_back() = 0;
    virtual tVoid vGetSelect_pressure_support() = 0;
    virtual tVoid vGetSetting_pressure_Front_answer_back() = 0;
    virtual tVoid vGetSetting_pressure_Rear_answer_back() = 0;
    virtual tVoid vGetGlobalVehicleWarningState() = 0;
    virtual tVoid vGetVehicleStates() = 0;

    virtual tVoid vSendVoice_Recognition_Executing(TVoice_Recognition_Executing tTxSignal) = 0;
    virtual tVoid vSendBlowerReductionRequest(TBlowerReductionRequest tTxSignal) = 0;
    virtual tVoid vSendTSR_OSPActivationRequest2(TTSR_OSPActivationRequest2 tTxSignal) = 0;
    virtual tVoid vSendMeterLanguageSyncMenu(TMeterLanguageSyncMenu tTxSignal) = 0;
    virtual tVoid vSendCockpitLanguageRequest(TCockpitLanguageRequest tTxSignal) = 0;
    virtual tVoid vSendUnitDistanceDisplayRequest(TUnitDistanceDisplayRequest tTxSignal) = 0;
    virtual tVoid vSendSetting_Change_Request_for_TPMS(TSetting_Change_Request_for_TPMS tTxSignal) = 0;

   // I_veda_tclClientVcan::ClassImplementation: user specific code start
    //Cam1ManAct
    virtual tVoid vSendCam1ManActUpdate(const tU8 u8Request) = 0;
	//Cam2ManAct
    virtual tVoid vSendCam2ManActUpdate(const tU8 u8Request) = 0;
	//Cam3ManAct
    virtual tVoid vSendCam3ManActUpdate(const tU8 u8Request) = 0;
	//Cam4ManAct
    virtual tVoid vSendCam4ManActUpdate(const tU8 u8Request) = 0;
	//Cam5ManAct
    virtual tVoid vSendCam5ManActUpdate(const tU8 u8Request) = 0;
	//Cam6ManAct
    virtual tVoid vSendCam6ManActUpdate(const tU8 u8Request) = 0;
	//Cam7ManAct
    virtual tVoid vSendCam7ManActUpdate(const tU8 u8Request) = 0;
	//Cam8ManAct
    virtual tVoid vSendCam8ManActUpdate(const tU8 u8Request) = 0;
	//Cam9ManAct
    virtual tVoid vSendCam9ManActUpdate(const tU8 u8Request) = 0;
	//Cam10ManAct
    virtual tVoid vSendCam10ManActUpdate(const tU8 u8Request) = 0;
	//Cam11ManAct
    virtual tVoid vSendCam11ManActUpdate(const tU8 u8Request) = 0;
	//Cam12ManAct
    virtual tVoid vSendCam12ManActUpdate(const tU8 u8Request) = 0;
    //Cam13ManAct
    virtual tVoid vSendCam13ManActUpdate(const tU8 u8Request) = 0;
  //Cam14ManAct
    virtual tVoid vSendCam14ManActUpdate(const tU8 u8Request) = 0;
	 //Cam15ManAct
    virtual tVoid vSendCam15ManActUpdate(const tU8 u8Request) = 0;
	 //Cam16ManAct
    virtual tVoid vSendCam16ManActUpdate(const tU8 u8Request) = 0;
	 //Cam17ManAct
    virtual tVoid vSendCam17ManActUpdate(const tU8 u8Request) = 0;
	//PrivacyResetAck
	virtual tVoid vSendPrivacyResetAckUpdate(const tU8 u8Request) = 0;
	//DispCamCls
    virtual tVoid vSendDispCamClsUpdate(const tU8 u8Request) = 0;
	//PhoneBTLinkStatus
    virtual tVoid vSendPhoneBTLinkStatusUpdate(const tU8 BTLinkStatus) = 0;
	//PhoneBookSyncstatus
    virtual tVoid vSendPhoneBookSyncstatusUpdate(const tU8 PhoneBookSyncStatusValue) = 0;
	//CallHistorySyncStatus
    virtual tVoid vSendCallHistorySyncStatusUpdate(const tU8 CallHistorySyncStatusValue) = 0;
	//PhoneStatusRoaming
    virtual tVoid vSendPhoneStatusRoamingUpdate(const tU8 PhoneStatusRoamingValue) = 0;
	//CallDuration
    virtual tVoid vSendCallDurationUpdate(const tU16 CallDurationValue) = 0;
	//GSMSignalStrength
    virtual tVoid vSendGSMSignalStrengthUpdate(const tU8 GSMSignalStrengthValue) = 0;
	//PhoneCallStatus
    virtual tVoid vSendPhoneCallStatusUpdate(const tU8 CallStatusValue) = 0;
	//PhoneBatteryLevelStatus
    virtual tVoid vSendPhoneBatteryLevelStatusUpdate(const tU8 PhoneBatteryLevelStatusValue) = 0;
	//DeviceStatusWifiAvailable
    virtual tVoid vSendDeviceStatusWifiAvailableUpdate(const tU8 DeviceStatusWifiStatus) = 0;
	//MediaStatusAudioSource
    virtual tVoid vSendMediaStatusAudioSourceUpdate(const tU8 AudioSource) = 0;
	//PhoneAvailableStatus
    virtual tVoid vSendPhoneAvailableStatusUpdate(const tU8 PhoneAvailableStatusValue) = 0;
	//PhoneVRAvailable
    virtual tVoid vSendPhoneVRAvailableUpdate(const tU8 PhoneVRAvailableValue) = 0;
	//DeviceStatusBTStatus
    virtual tVoid vSendDeviceStatusBTStatusUpdate(const tU8 DeviceStatusBTStatusValue) = 0;
	//DeviceStatusBluetoothAvail
    virtual tVoid vSendDeviceStatusBluetoothAvailUpdate(const tU8 DeviceStatusBluetoothAvailValue) = 0;
	//Req_DeviceInfo
    virtual tVoid vSendReq_DeviceInfoUpdate(const tU8 Req_DeviceInfoValue) = 0;
	//MediaStatusVolume
    virtual tVoid vSendMediaStatusVolumeUpdate(const tU8 Volume) = 0;
	//CabinMediaStatusAudioSource
    virtual tVoid vSendCabinMediaStatusAudioSourceUpdate(const tU8 CabinAudioSource) = 0;
		//CabinMediaStatusTunerBand
    virtual tVoid vSendCabinMediaStatusTunerBandUpdate(const tU8 CabinMediaStatusTunerBandValue) = 0;
	//CabinMediaStatusVolume
    virtual tVoid vSendCabinMediaStatusVolumeUpdate(const tU8 CabinVolume) = 0;
	//MediaStatusMuteStatus
    virtual tVoid vSendMediaStatusMuteStatusUpdate(const tU8 MediaStatusMuteValue) = 0;
	//CabinMediaStatusMuteStatus
    virtual tVoid vSendCabinMediaStatusMuteStatusUpdate(const tU8 CabinMediaStatusMuteValue) = 0;
	//MediaStatusPlayStatus
    virtual tVoid vSendMediaStatusPlayStatusUpdate(const tU8 MediaStatusPlayStatusValue) = 0;
	//MediaStatusMixState
    virtual tVoid vSendMediaStatusMixStateUpdate(const tU8 MediaStatusMixStateValue) = 0;
	//MediaStatusPlaylistMode
    virtual tVoid vSendMediaStatusPlaylistModeUpdate(const tU8 MediaStatusPlaylistModeValue) = 0;
	//MediaStatusTrackTime
    virtual tVoid vSendMediaStatusTrackTimeUpdate(const tU16 MediaStatusTrackTimeValue) = 0;
	//MediaStatusCurrTrackNum
    virtual tVoid vSendMediaStatusCurrTrackNumUpdate(const tU16 MediaStatusCurrTrackNumValue) = 0;
	//DeviceStatusRadioStatus
    virtual tVoid vSendDeviceStatusRadioStatusUpdate(const tU8 DeviceStatusRadioStatusValue) = 0;
	//DeviceStatusDABAvailStatus
    virtual tVoid vSendDeviceStatusDABAvailStatusUpdate(const tU8 DeviceStatusDABAvailStatusValue) = 0;
	//DeviceStatusNavData
    virtual tVoid vSendDeviceStatusNavDataUpdate(const tU8 DeviceStatusNavDataValue) = 0;
	//DeviceStatusUSB1Present
    virtual tVoid vSendDeviceStatusUSB1PresentUpdate(const tU8 DeviceStatusUSB1PresentValue) = 0;
	//DeviceStatusUSB2Present
    virtual tVoid vSendDeviceStatusUSB2PresentUpdate(const tU8 DeviceStatusUSB2PresentValue) = 0;
	//DeviceStatusNaviAvail
    virtual tVoid vSendDeviceStatusNaviAvailUpdate(const tU8 DeviceStatusNaviAvailValue) = 0;
	//DeviceStatusUSB1Src
    virtual tVoid vSendDeviceStatusUSB1SrcUpdate(const tU8 DeviceStatusUSB1SrcValue) = 0;
	//DeviceStatusUSB2Src
    virtual tVoid vSendDeviceStatusUSB2SrcUpdate(const tU8 DeviceStatusUSB2SrcValue) = 0;
	//DeviceStatusAMFMAvail
    virtual tVoid vSendDeviceStatusAMFMAvailUpdate(const tU8 DeviceStatusAMFMAvailValue) = 0;
	//MediaStatusSeekStatus
    virtual tVoid vSendMediaStatusSeekStatusUpdate(const tU8 MediaStatusSeekStatusValue) = 0;
	//MediaStatusRepeatStatus
    virtual tVoid vSendMediaStatusRepeatStatusUpdate(const tU8 MediaStatusRepeatStatusValue) = 0;
	//MediaStatusDABFMStatus
    virtual tVoid vSendMediaStatusDABFMStatusUpdate(const tU8 MediaStatusDABFMStatusValue) = 0;
	//VehicleNaviLatitude
    virtual tVoid vSendVehicleNaviLatitudeUpdate(const tU32 VehicleNaviLatitudeValue) = 0;
	//VehicleNaviLongitude
    virtual tVoid vSendVehicleNaviLongitudeUpdate(const tU32 VehicleNaviLongitudeValue) = 0;
	//MediaStatusTREGStatus
    virtual tVoid vSendMediaStatusTREGStatusUpdate(const tU8 MediaStatusTREGStatusValue) = 0;
	//MediaStatusTREGRTMStatus
    virtual tVoid vSendMediaStatusTREGRTMStatusUpdate(const tU8 MediaStatusTREGRTMStatusValue) = 0;
	//MediaStatusRDSStatus
    virtual tVoid vSendMediaStatusRDSStatusUpdate(const tU8 MediaStatusRDSStatusValue) = 0;
	//MediaStatusTAStatus
    virtual tVoid vSendMediaStatusTAStatusUpdate(const tU8 MediaStatusTAStatusValue) = 0;
	//MediaStatusTPStatus
    virtual tVoid vSendMediaStatusTPStatusUpdate(const tU8 MediaStatusTPStatusValue) = 0;
	//MediaStatusTunerBandStatus
    virtual tVoid vSendMediaStatusTunerBandStatusUpdate(const tU8 MediaStatusTunerBandStatusValue) = 0;
	//MediaStatusTunerpresetStatus
    virtual tVoid vSendMediaStatusTunerPresetStatusUpdate(const tU8 MediaStatusTunerPresetStatusValue) = 0;
	//HUS_DM1_Status
    virtual tVoid vSendHUS_DM1_StatusUpdate(const tU64 HUS_DM1_StatusValue) = 0;
	
    virtual tVoid vSendSDSStatusUpdate(const tBool bSDSStatus) = 0;
    virtual tVoid vSendCockpitLanguageUpdate(const tU8 u8RequestedLang) = 0;
    virtual tVoid vSendMeterLanguageSyncMenuUpdate(const tU8 u8LangSyncMenu) = 0;
    virtual tVoid vSendUnitDistanceDisplayRequestUpdate(const tU8 u8Request) = 0;
    virtual tVoid vSendMediaInfo(vehicle_fi_tcl_CAN_Mesg msg) = 0;
    virtual tVoid vSendCallInfo(vehicle_fi_tcl_CAN_Mesg msg) = 0;
    virtual tVoid vSendPhoneInfo(vehicle_fi_tcl_CAN_Mesg msg) = 0;
    virtual tVoid vSendXMInfo(vehicle_fi_tcl_CAN_Mesg msg) = 0;
    virtual tVoid vSendMainlineInfo(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	virtual tVoid vSendCurrentStreetName(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	virtual tVoid vSendTurnToStreetNameInfo(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	virtual tVoid VSendDestinationInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
	virtual tVoid VSendTurnToSymbolsInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
	virtual tVoid VSendLaneGuidanceInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
	virtual tVoid VSendNaviWarningInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
	 virtual tVoid vSendCabAMediaInfo(vehicle_fi_tcl_CAN_Mesg msg) = 0;

	
	//For P-IVI
	virtual tVoid vSendTire_Pressure_Set ( tU8 u8TirePressure) = 0;
   // I_veda_tclClientVcan::ClassImplementation: user specific code end
};

#endif // _I_VCANCAN_CLIENT_H_
