/************************************************************************
 * FILE:         veda_DiagSystemSetListener.h
 * PROJECT:      IVI
 * SW-COMPONENT: vd_vehicledata
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  
 *              
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 *************************************************************************/
#ifndef _VEDA_DIAGSYSTEMSETLISTENER_H_
#define _VEDA_DIAGSYSTEMSETLISTENER_H_

// Specify what part of diaglib you need in this file 
#define DIAGLIB_INCLUDE_SYSTEM_SET
#include "diaglib_if.h"

class veda_tclAppMain;

class veda_tclSystemSetListener: public diaglib::tclSystemSetListenerIF
{
  public:
    veda_tclSystemSetListener() { m_poSystemSetIF = NULL; m_poMainAppl = NULL; }

    // Depending on the type of listener you need the associated interface to send responses 
    veda_tclSystemSetListener(diaglib::tclSystemSetIF*, veda_tclAppMain* poMainAppl);
    virtual ~veda_tclSystemSetListener();

    // Interface pointers, to send responses to, adjust type according to listener type 
    diaglib::tclSystemSetIF* m_poSystemSetIF;
    // our main app
    veda_tclAppMain* m_poMainAppl;

  public:
    // Place the virtual listener functions here. These depend on the listener you implement 
    /***************************************************************************
    * SystemSetListener methods
    ***************************************************************************/
    virtual tU32 vOnSystemSet( tU32 u32SystemSetID, 
                               diaglib::tenSystemSetType u32SystemSetType,
                               diaglib::tContext MsgContext
                             );

    virtual tU32 vOnSystemSetFinished( tU32 u32SystemSetID, 
                                       diaglib::tenSystemSetType u32SystemSetType,
                                       diaglib::tContext MsgContext
                                     );

    virtual tU32 vOnSystemSetPrepare( tU32 u32SystemSetID, 
                                      diaglib::tenSystemSetType u32SystemSetType,
                                      diaglib::tContext MsgContext
                                    );

    virtual tU32 vOnSystemSetCheck( tU32 u32SystemSetID, 
                                    diaglib::tenSystemSetType u32SystemSetType,
                                    diaglib::tContext MsgContext
                                  );

};

#endif // _VEDA_DIAGSYSTEMSETLISTENER_H_
